/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.videodev;

import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilDetailSplitPanel;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.guiutil.GuiUtilMainPanel;
import com.aastra.oamp.util.UtilFilterTable;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.oamp.util.UtilPrint;
import com.aastra.oamp.videodev.VideoDevConfigMainPanel;
import com.aastra.oamp.videodev.VideoDevMonitorDetailPanel;
import com.aastra.oamp.videodev.VideoDevMonitorTaskPanel;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.VideoDevHandler;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;

public class VideoDevMonitorMainPanel
extends GuiUtilMainPanel
implements VideoDevHandler.VideoDevNotificationInterface,
ConfiguratorTableEventInterface,
ConfiguratorTable.MultiSelectionNotificationInterface {
    private static final long serialVersionUID = 1L;
    private VideoDevHandler videoDevHandler = null;
    private VideoDevHandler.VideoDevDatabase videoDevDatabase = null;
    private GuiUtilDetailSplitPanel videoDevDetailSplitPane = null;
    private AastraScrollPane videoDevTablePane = null;
    private VideoDevMonitorDetailPanel videoDevDetailPanel = null;
    private VideoDevMonitorTaskPanel videoDevTaskPanel = null;
    private int currentVideoDevDetailPanel = -1;
    private int dividerLocation = 0;

    public VideoDevMonitorMainPanel(VideoDevHandler videoDevHandler) {
        this.videoDevHandler = videoDevHandler;
        this.videoDevHandler.registerDataNotificationListener(this);
        this.videoDevDatabase = this.videoDevHandler.getDb();
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getVideoDevDetailSplitPane(), "Center");
        this.add((Component)this.getVideoDevMonitorTaskPanel(), "East");
    }

    private GuiUtilDetailSplitPanel getVideoDevDetailSplitPane() {
        if (this.videoDevDetailSplitPane == null) {
            this.videoDevDetailSplitPane = new GuiUtilDetailSplitPanel(360);
            this.videoDevDetailSplitPane.setTopComponent(this.getVideoDevTablePane());
            this.videoDevDetailSplitPane.setBottomComponent(null);
        }
        return this.videoDevDetailSplitPane;
    }

    private GuiUtilConfiguratorTable getVideoDevTable() {
        if (this.table == null) {
            this.table = new GuiUtilConfiguratorTable((Object)this, (Database)this.videoDevDatabase, VideoDevConfigMainPanel.tableColSel, this.getActiveTableColumns(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectVideoDevMonitor, VideoDevConfigMainPanel.tableColSel), UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthVideoDevMonitor, 0);
            this.table.setColumnFormatString(0, "0x%03X");
            this.table.setColumnFormatString(2, "0x%03X");
            this.table.setIconArray(4, GuiUtilIcon.getIconArrayInactiveActive());
            this.table.setIconArray(5, GuiUtilIcon.getIconArray_Disconnect_OK_Eye_Error());
        }
        return this.table;
    }

    private AastraScrollPane getVideoDevTablePane() {
        if (this.videoDevTablePane == null) {
            this.videoDevTablePane = new AastraScrollPane(this.getVideoDevTable());
            this.dividerLocation = this.videoDevDetailSplitPane.getHeight() - 360;
            this.videoDevTablePane.setMinimumSize(new Dimension(0, this.dividerLocation));
        }
        return this.videoDevTablePane;
    }

    private void enableTableAccess() {
        this.table.setActive(true);
        this.videoDevTaskPanel.setTaskButtonFilter(true);
        this.videoDevTaskPanel.setTaskButtonConfigureTable(true);
    }

    private void disableTableAccess() {
        this.table.setActive(false);
        this.videoDevTaskPanel.setTaskButtonShowDetails(false);
        this.videoDevTaskPanel.setTaskButtonFilter(false);
        this.videoDevTaskPanel.setTaskButtonConfigureTable(false);
    }

    protected void configureTableFilter() {
        boolean bl = UtilFilterTable.setFilterItems(this.table, UtilPreferences.getTableFilterValues(UtilPreferences.TableFilterValuesKeyTypeEnum.TableFilterValuesVideoDevMonitor));
        this.videoDevTaskPanel.setTaskButtonFilterState(bl, null);
    }

    private AastraPanel getVideoDevMonitorDetailPanel() {
        if (this.videoDevDetailPanel == null) {
            this.videoDevDetailPanel = new VideoDevMonitorDetailPanel(this);
        }
        return this.videoDevDetailPanel;
    }

    private AastraPanel getVideoDevMonitorTaskPanel() {
        if (this.videoDevTaskPanel == null) {
            this.videoDevTaskPanel = new VideoDevMonitorTaskPanel(this, this.getVideoDevTable());
        }
        return this.videoDevTaskPanel;
    }

    public void createVideoDevDetailPanel(DataRecord dataRecord) {
        if (this.videoDevDetailSplitPane.getBottomComponent() != null) {
            this.dividerLocation = this.videoDevDetailSplitPane.getDividerLocation();
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Updating video device monitor detail panel");
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Creating video device monitor detail panel");
            this.videoDevDetailSplitPane.setBottomComponent(this.getVideoDevMonitorDetailPanel());
            this.videoDevDetailPanel.setDefaultTab();
        }
        if (dataRecord != null) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading video device[" + (Integer)dataRecord.getField(0) + "]:");
            UtilPrint.printVideoDevRecordString((VideoDevHandler.VideoDevRec)dataRecord, this);
            this.currentVideoDevDetailPanel = (Integer)dataRecord.getField(0);
            this.videoDevDetailPanel.setVideoDevDetailData((VideoDevHandler.VideoDevRec)dataRecord);
        } else {
            this.videoDevDetailPanel.setVideoDevDetailData(null);
        }
        this.videoDevDetailSplitPane.setDividerLocation(this.dividerLocation);
        this.videoDevDetailSplitPane.validate();
        this.videoDevTaskPanel.setTaskButtonShowDetails(false);
    }

    public void removeVideoDevDetailPanel() {
        this.currentVideoDevDetailPanel = -1;
        this.dividerLocation = this.videoDevDetailSplitPane.getDividerLocation();
        this.videoDevDetailSplitPane.setBottomComponent(null);
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing video device monitor detail panel");
        if (this.table.getSelectedRow() >= 0) {
            this.videoDevTaskPanel.setTaskButtonShowDetails(true);
        }
    }

    public void showVideoDevDetails() {
        int n;
        VideoDevHandler.VideoDevRec videoDevRec;
        int n2 = this.table.getSelectedRow();
        if (n2 >= 0 && (videoDevRec = this.videoDevDatabase.getRecordByIdx(n = this.table.convertRowIndexToModel(n2))) != null) {
            this.createVideoDevDetailPanel(videoDevRec);
        }
    }

    @Override
    public void processVideoDevDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "Video device notification: " + dataNotificationEnum.toString() + ",videoDevId=" + n);
        switch (dataNotificationEnum) {
            case DATA_DELETED_ALL: {
                this.disableTableAccess();
                break;
            }
            case DATA_BULK_READY: {
                this.enableTableAccess();
                break;
            }
            default: {
                VideoDevHandler.VideoDevRec videoDevRec;
                if (this.table.getSelectedRow() == -1) {
                    this.videoDevTaskPanel.setTaskButtonShowDetails(false);
                }
                if (this.currentVideoDevDetailPanel != n || (videoDevRec = this.videoDevDatabase.getRecordById(n)) == null) break;
                this.videoDevDetailPanel.setVideoDevDetailData(videoDevRec);
            }
        }
    }

    @Override
    public void processVideoDevErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        if (this.videoDevDetailSplitPane.getBottomComponent() != null) {
            if (dataRecord != null) {
                this.createVideoDevDetailPanel(dataRecord);
            } else {
                this.removeVideoDevDetailPanel();
            }
        } else {
            this.videoDevTaskPanel.setTaskButtonShowDetails(true);
        }
        this.updateTableInfo();
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        this.createVideoDevDetailPanel(dataRecord);
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        int n;
        if (this.videoDevDetailSplitPane.getBottomComponent() != null) {
            if (dataRecord != null) {
                this.createVideoDevDetailPanel(dataRecord);
            } else {
                this.removeVideoDevDetailPanel();
            }
        }
        if ((n = this.table.getSelectedRowCount()) == 1) {
            this.videoDevTaskPanel.setTaskButtonShowDetails(true);
        } else {
            this.videoDevTaskPanel.setTaskButtonShowDetails(false);
        }
        this.updateTableInfo();
    }

    @Override
    public void processMultiSelectionChanged(DataRecord[] dataRecordArray) {
        int n = this.table.getSelectedRowCount();
        if (n == 1) {
            this.videoDevTaskPanel.setTaskButtonShowDetails(true);
        } else {
            this.videoDevTaskPanel.setTaskButtonShowDetails(false);
            if (n > 1 && this.videoDevDetailSplitPane.getBottomComponent() != null) {
                this.removeVideoDevDetailPanel();
            }
        }
    }

    @Override
    protected void componentActivateAction() {
        this.videoDevHandler.start();
        this.configureTableFilter();
    }
}

