/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.wlan;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilDetailSplitPanel;
import com.aastra.oamp.guiutil.GuiUtilDialog;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.guiutil.GuiUtilMainPanel;
import com.aastra.oamp.guiutil.GuiUtilTableColSelect;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilErrorHandling;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.oamp.wlan.WlanProfileACLDetailPanel;
import com.aastra.oamp.wlan.WlanProfileDetailPanel;
import com.aastra.oamp.wlan.WlanProfileTaskPanel;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.WLANProfileHandler;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;

public class WlanProfileMainPanel
extends GuiUtilMainPanel
implements WLANProfileHandler.WLANProfileDataNotificationInterface,
WLANProfileHandler.WLANProfileACLDataNotificationInterface,
ConfiguratorTableEventInterface {
    private static final long serialVersionUID = 1L;
    public static final GuiUtilTableColSelect[] tableColSel = new GuiUtilTableColSelect[]{new GuiUtilTableColSelect(0, true), new GuiUtilTableColSelect(1, true, GuiUtilIcon.getIconArrayInactiveActive()), new GuiUtilTableColSelect(2, true), new GuiUtilTableColSelect(3, false), new GuiUtilTableColSelect(4, false), new GuiUtilTableColSelect(5, false), new GuiUtilTableColSelect(6, false), new GuiUtilTableColSelect(7, false, GuiUtilIcon.getIconArraySpacerInactiveActive()), new GuiUtilTableColSelect(8, false), new GuiUtilTableColSelect(9, true), new GuiUtilTableColSelect(11, true), new GuiUtilTableColSelect(12, false), new GuiUtilTableColSelect(13, false), new GuiUtilTableColSelect(14, false), new GuiUtilTableColSelect(16, true)};
    protected static final int xSizeDetailPanelSurcharge = 400;
    protected static final int ySizeDetailPanelSurcharge = 220;
    private static final int ySizeDetailPanel = 430;
    private WLANProfileHandler wlanProfileHandler = null;
    private GuiMain.GuiNavPanelTypeEnum guiNavPanelType = null;
    private WlanProfileTaskPanel wlanProfileTaskPanel = null;
    private GuiUtilDetailSplitPanel wlanProfileDetailSplitPane = null;
    private AastraScrollPane wlanProfileTablePane = null;
    private WlanProfileDetailPanel wlanProfileDetailPanel = null;
    private WlanProfileACLDetailPanel wlanProfileACLDetailPanel = null;
    private Integer idPending = null;
    private int idDetailPanel = 0;
    private boolean isEditable = true;
    private UtilErrorComp utilErrorComp = null;
    private int dividerLocation = 0;

    public WlanProfileMainPanel(WLANProfileHandler wLANProfileHandler, GuiMain.GuiNavPanelTypeEnum guiNavPanelTypeEnum) {
        this.wlanProfileHandler = wLANProfileHandler;
        this.guiNavPanelType = guiNavPanelTypeEnum;
        this.wlanProfileHandler.registerProfileDataNotificationListener(this);
        this.wlanProfileHandler.registerProfileACLDataNotificationListener(this);
        this.initialize();
    }

    private void initialize() {
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_CONFIG) {
            this.utilErrorComp = new UtilErrorComp();
        } else {
            this.isEditable = false;
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.getWlanProfileDetailSplitPane(), "Center");
        this.add((Component)this.getWlanProfileTaskPanel(), "East");
    }

    protected boolean isGuiNavPanelTypeConfig() {
        return this.isEditable;
    }

    private GuiUtilDetailSplitPanel getWlanProfileDetailSplitPane() {
        if (this.wlanProfileDetailSplitPane == null) {
            this.wlanProfileDetailSplitPane = new GuiUtilDetailSplitPanel(430);
            this.wlanProfileDetailSplitPane.setTopComponent(this.getWlanProfileTablePane());
            this.wlanProfileDetailSplitPane.setBottomComponent(null);
        }
        return this.wlanProfileDetailSplitPane;
    }

    private AastraScrollPane getWlanProfileTablePane() {
        if (this.wlanProfileTablePane == null) {
            this.wlanProfileTablePane = new AastraScrollPane(this.getWlanProfileTable());
            this.dividerLocation = this.wlanProfileDetailSplitPane.getHeight() - 430;
            this.wlanProfileTablePane.setMinimumSize(new Dimension(0, this.dividerLocation));
        }
        return this.wlanProfileTablePane;
    }

    private GuiUtilConfiguratorTable getWlanProfileTable() {
        if (this.table == null) {
            UtilPreferences.TableColSelectKeyTypeEnum tableColSelectKeyTypeEnum;
            UtilPreferences.TableColumnsWidthKeyTypeEnum tableColumnsWidthKeyTypeEnum;
            if (this.isEditable) {
                tableColumnsWidthKeyTypeEnum = UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthWlanConfig;
                tableColSelectKeyTypeEnum = UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectWlanProfileConfig;
            } else {
                tableColumnsWidthKeyTypeEnum = UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthWlanMonitor;
                tableColSelectKeyTypeEnum = UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectWlanProfileMonitor;
            }
            this.table = new GuiUtilConfiguratorTable((Object)this, this.wlanProfileHandler.getWLANProfileDatabase(), tableColSel, this.getActiveTableColumns(tableColSelectKeyTypeEnum, tableColSel), tableColumnsWidthKeyTypeEnum, 0);
        }
        return this.table;
    }

    private void createWlanProfileDetailPanel(WLANProfileHandler.WLANProfile wLANProfile) {
        if (this.wlanProfileDetailSplitPane.getBottomComponent() != null) {
            this.dividerLocation = this.wlanProfileDetailSplitPane.getDividerLocation();
        }
        if (this.wlanProfileDetailSplitPane.getBottomComponent() == this.wlanProfileACLDetailPanel) {
            this.removeWlanProfileACLDetailPanel();
        }
        if (this.wlanProfileDetailSplitPane.getBottomComponent() != null) {
            if (wLANProfile == null) {
                this.wlanProfileDetailPanel.setDefaultTab();
            }
        } else {
            this.wlanProfileDetailSplitPane.setBottomComponent(this.getWlanProfileDetailPanel());
            this.wlanProfileDetailPanel.setDefaultTab();
            this.wlanProfileDetailSplitPane.setDividerLocation(this.dividerLocation);
            this.wlanProfileDetailSplitPane.validate();
            this.wlanProfileTaskPanel.setTaskButtonConfigureShow(false);
            this.wlanProfileTaskPanel.setTaskButtonConfigureShowACL(true);
        }
        if (!this.isEditable) {
            this.idDetailPanel = wLANProfile.id;
        }
        this.wlanProfileDetailPanel.setWlanProfileData(wLANProfile);
    }

    private void createWlanACLDetailPanel(WLANProfileHandler.WLANProfile wLANProfile) {
        if (this.wlanProfileDetailSplitPane.getBottomComponent() == this.wlanProfileDetailPanel) {
            this.removeWlanProfileDetailPanel();
        }
        if (this.wlanProfileDetailSplitPane.getBottomComponent() == null) {
            this.wlanProfileDetailSplitPane.setBottomComponent(this.getWlanACLDetailPanel());
            this.wlanProfileACLDetailPanel.setDefaultTab();
            this.wlanProfileTaskPanel.setTaskButtonConfigureShow(true);
            this.wlanProfileTaskPanel.setTaskButtonConfigureShowACL(false);
        }
        this.wlanProfileACLDetailPanel.setProfile(wLANProfile.id);
    }

    public void removeWlanProfileDetailPanel() {
        if (this.wlanProfileDetailSplitPane.getBottomComponent() == this.wlanProfileDetailPanel) {
            this.idPending = null;
            if (this.isEditable) {
                this.utilErrorComp.clearComponents();
            }
            this.wlanProfileDetailSplitPane.setBottomComponent(null);
            this.processTableEvent();
        }
    }

    public void removeWlanProfileACLDetailPanel() {
        if (this.wlanProfileDetailSplitPane.getBottomComponent() == this.wlanProfileACLDetailPanel) {
            this.wlanProfileDetailSplitPane.setBottomComponent(null);
            this.processTableEvent();
        }
    }

    private WlanProfileDetailPanel getWlanProfileDetailPanel() {
        if (this.wlanProfileDetailPanel == null) {
            this.wlanProfileDetailPanel = new WlanProfileDetailPanel(this, this.utilErrorComp);
        }
        return this.wlanProfileDetailPanel;
    }

    private WlanProfileACLDetailPanel getWlanACLDetailPanel() {
        if (this.wlanProfileACLDetailPanel == null) {
            this.wlanProfileACLDetailPanel = new WlanProfileACLDetailPanel(this, this.wlanProfileHandler);
        }
        return this.wlanProfileACLDetailPanel;
    }

    protected void taskCreateWlanProfile() {
        this.createWlanProfileDetailPanel(null);
    }

    protected void taskConfigureShowWlanProfile() {
        WLANProfileHandler.WLANProfile wLANProfile = this.getSelectedWlanProfile();
        if (wLANProfile != null) {
            this.createWlanProfileDetailPanel(wLANProfile);
        }
    }

    protected void taskDeleteWlanProfile() {
        WLANProfileHandler.WLANProfile wLANProfile;
        GuiUtilDialog guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, UtilLocale.getString("TXT_DELETE_SELECTED_WLAN_PROFILE_?"), true);
        if (guiUtilDialog.getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionYes && (wLANProfile = this.getSelectedWlanProfile()) != null) {
            this.idPending = this.wlanProfileHandler.sendDeleteProfile(wLANProfile);
        }
    }

    protected void taskDeleteAllWlanProfiles() {
        GuiUtilDialog guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, UtilLocale.getString("TXT_DELETE_ALL_WLAN_PROFILES_?"), true);
        if (guiUtilDialog.getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionYes) {
            int n = this.table.getRowCount();
            WLANProfileHandler.WLANProfile wLANProfile = null;
            wLANProfile = this.getSelectedWlanProfile();
            if (wLANProfile != null) {
                this.idPending = wLANProfile.id;
            }
            for (int i = 0; i < n; ++i) {
                int n2 = this.table.convertRowIndexToModel(i);
                wLANProfile = this.wlanProfileHandler.getWlanProfileByTableIdx(n2);
                if (wLANProfile == null) continue;
                this.wlanProfileHandler.sendDeleteProfile(wLANProfile);
            }
        }
    }

    protected void taskConfigureShowWlanACL() {
        WLANProfileHandler.WLANProfile wLANProfile = this.getSelectedWlanProfile();
        if (wLANProfile != null) {
            this.createWlanACLDetailPanel(wLANProfile);
        }
    }

    private WLANProfileHandler.WLANProfile getSelectedWlanProfile() {
        int n = this.table.getSelectedRow();
        if (n >= 0) {
            int n2 = this.table.convertRowIndexToModel(n);
            return this.wlanProfileHandler.getWlanProfileByTableIdx(n2);
        }
        return null;
    }

    public void createWlanProfile() {
        WLANProfileHandler.WLANProfile wLANProfile = this.wlanProfileDetailPanel.getWlanProfileData();
        if (wLANProfile != null) {
            this.idPending = this.wlanProfileHandler.sendCreateWLANProfile(wLANProfile);
        }
    }

    public void changeWlanProfile() {
        WLANProfileHandler.WLANProfile wLANProfile = this.wlanProfileDetailPanel.getWlanProfileData();
        if (wLANProfile != null) {
            this.idPending = this.wlanProfileHandler.sendSetWLANProfile(wLANProfile);
        }
    }

    private WlanProfileTaskPanel getWlanProfileTaskPanel() {
        if (this.wlanProfileTaskPanel == null) {
            this.wlanProfileTaskPanel = new WlanProfileTaskPanel(this, this.table);
        }
        return this.wlanProfileTaskPanel;
    }

    protected void createACLEntry(WLANProfileHandler.ACLEntry aCLEntry, int n) {
        this.wlanProfileHandler.sendCreateACLEntry(aCLEntry, n);
    }

    protected void changeACLEntry(WLANProfileHandler.ACLEntry aCLEntry, int n) {
        this.wlanProfileHandler.sendChangeACLEntry(aCLEntry, n);
    }

    protected void deleteACLEntries(WLANProfileHandler.ACLEntry[] aCLEntryArray, int n) {
        for (int i = 0; i < aCLEntryArray.length; ++i) {
            this.wlanProfileHandler.sendDeleteACLEntry(aCLEntryArray[i], n);
        }
    }

    protected void deleteAllACLEntries(int n) {
        this.wlanProfileHandler.sendDeleteAllACLEntry(n);
    }

    private void enableTableAccess() {
        this.table.setActive(true);
        this.wlanProfileTaskPanel.setTaskButtonConfigureTable(true);
        this.processTableEvent();
    }

    private void disableTableAccess() {
        this.table.setActive(false);
        this.wlanProfileTaskPanel.setTaskButtonCreate(false);
        this.wlanProfileTaskPanel.setTaskButtonConfigureShow(false);
        this.wlanProfileTaskPanel.setTaskButtonDelete(false);
        this.wlanProfileTaskPanel.setTaskButtonDeleteAll(false);
        this.wlanProfileTaskPanel.setTaskButtonConfigureShowACL(false);
        this.wlanProfileTaskPanel.setTaskButtonConfigureTable(false);
    }

    private void processTableEvent() {
        WLANProfileHandler.WLANProfile wLANProfile;
        Component component = this.wlanProfileDetailSplitPane.getBottomComponent();
        if (component != null) {
            WLANProfileHandler.WLANProfile wLANProfile2 = this.getSelectedWlanProfile();
            if (wLANProfile2 != null) {
                if (component == this.wlanProfileDetailPanel) {
                    this.createWlanProfileDetailPanel(wLANProfile2);
                } else {
                    this.createWlanACLDetailPanel(wLANProfile2);
                }
            }
        } else {
            if (this.table.getRowCount() < 20) {
                this.wlanProfileTaskPanel.setTaskButtonCreate(true);
            } else {
                this.wlanProfileTaskPanel.setTaskButtonCreate(false);
            }
            boolean bl = false;
            if (this.table.getSelectedRowCount() > 0) {
                bl = true;
            }
            this.wlanProfileTaskPanel.setTaskButtonConfigureShow(bl);
            this.wlanProfileTaskPanel.setTaskButtonConfigureShowACL(bl);
        }
        boolean bl = false;
        if (this.table.getSelectedRowCount() > 0 && (wLANProfile = this.getSelectedWlanProfile()) != null && wLANProfile.numberRFPs == 0) {
            bl = true;
        }
        this.wlanProfileTaskPanel.setTaskButtonDelete(bl);
        this.updateTableInfo();
    }

    @Override
    public void processWLANProfileDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "WLAN profile notification: " + dataNotificationEnum.toString() + ",id=" + n);
        if (this.isEditable) {
            int n2;
            switch (dataNotificationEnum) {
                case DATA_DELETED_ALL: {
                    this.disableTableAccess();
                    break;
                }
                case DATA_BULK_READY: {
                    this.enableTableAccess();
                    break;
                }
                case NEW_DATA: {
                    if (this.idPending == null || this.idPending != 0) break;
                    this.removeWlanProfileDetailPanel();
                    break;
                }
                case DATA_CHANGED: 
                case DATA_DELETED: {
                    if (this.idPending == null || this.idPending != n) break;
                    Component component = this.wlanProfileDetailSplitPane.getBottomComponent();
                    if (component == this.wlanProfileDetailPanel) {
                        this.removeWlanProfileDetailPanel();
                        break;
                    }
                    if (component != this.wlanProfileACLDetailPanel) break;
                    this.removeWlanProfileACLDetailPanel();
                    break;
                }
            }
            boolean bl = false;
            if (this.table.isEnabled() && (n2 = this.table.getRowCount()) > 0) {
                WLANProfileHandler.WLANProfile wLANProfile;
                int n3;
                for (n3 = 0; n3 < n2 && ((wLANProfile = this.wlanProfileHandler.getWlanProfileByTableIdx(n3)) == null || wLANProfile.numberRFPs <= 0); ++n3) {
                }
                if (n3 == n2) {
                    bl = true;
                }
            }
            this.wlanProfileTaskPanel.setTaskButtonDeleteAll(bl);
        } else {
            switch (dataNotificationEnum) {
                case DATA_DELETED_ALL: {
                    this.disableTableAccess();
                    break;
                }
                case DATA_BULK_READY: {
                    this.enableTableAccess();
                    break;
                }
                case DATA_CHANGED: {
                    Component component;
                    if (this.idDetailPanel != n || (component = this.wlanProfileDetailSplitPane.getBottomComponent()) != this.wlanProfileDetailPanel) break;
                    WLANProfileHandler.WLANProfile wLANProfile = this.wlanProfileHandler.getWlanProfileByProfileId(n);
                    if (wLANProfile != null) {
                        this.wlanProfileDetailPanel.setWlanProfileData(wLANProfile);
                        break;
                    }
                    this.removeWlanProfileDetailPanel();
                    break;
                }
                case DATA_DELETED: {
                    if (this.idDetailPanel != n) break;
                    Component component = this.wlanProfileDetailSplitPane.getBottomComponent();
                    if (component == this.wlanProfileDetailPanel) {
                        this.removeWlanProfileDetailPanel();
                        break;
                    }
                    if (component != this.wlanProfileACLDetailPanel) break;
                    this.removeWlanProfileACLDetailPanel();
                    break;
                }
            }
        }
    }

    @Override
    public void processWLANProfileErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        if (this.isEditable) {
            String string;
            String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
            String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
            String string4 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
            String string5 = null;
            OmiMessage.errorCodes errorCodes2 = null;
            try {
                int n2;
                if (OmiMessage.SSIDProfileType.valueOf(string3) != null && (string = omiMessage.getAttribVal(OmiMessage.attribIds.info.name())) != null && (n2 = string.indexOf(OmiMessage.elemIds.ssid.name())) != -1) {
                    string3 = string3.concat(string.substring(n2 + 4, n2 + 5));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "WLAN profile error notification: " + dataNotificationEnum.toString() + ",Id=" + String.valueOf(n) + ",errCode=" + string2 + ",bad=" + string3 + ",maxLen=" + string4);
            try {
                errorCodes2 = OmiMessage.errorCodes.valueOf(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                errorCodes2 = null;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "WLAN profile error notification: Unknown errorCode=" + string2);
            }
            switch (dataNotificationEnum) {
                case NEW_DATA: 
                case DATA_CHANGED: {
                    if (errorCodes2 != null) {
                        string = this.wlanProfileDetailPanel.getErrorLabelText(string3);
                        string5 = UtilErrorHandling.getErrorMessage(errorCodes2, string, string4);
                        GuiInfoConsole.showError(string5);
                    } else {
                        GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
                    }
                    if (string3 == null) break;
                    this.wlanProfileDetailPanel.markErrorComponent(string3);
                    break;
                }
                case DATA_DELETED: {
                    string5 = errorCodes2 != null ? (errorCodes2 == OmiMessage.errorCodes.EExist ? UtilLocale.getString("TXT_DELETING_SITES_FAILED") : UtilErrorHandling.getErrorMessage(errorCodes2, null, null)) : UtilLocale.getString("TXT_UNKNOWN_ERROR");
                    GuiInfoConsole.showError(string5);
                    break;
                }
            }
        }
    }

    @Override
    public void processWLANProfileACLDataNotification(int n, DataNotificationEnum dataNotificationEnum, String string) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "WLAN ACL notification: " + dataNotificationEnum.toString() + ",profileId=" + n);
        if (this.wlanProfileDetailSplitPane != null) {
            Component component = this.wlanProfileDetailSplitPane.getBottomComponent();
            if (this.wlanProfileACLDetailPanel != null && component == this.wlanProfileACLDetailPanel) {
                this.wlanProfileACLDetailPanel.processACLDataNotification(n, dataNotificationEnum, string);
            }
        }
    }

    @Override
    public void processWLANProfileACLErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        if (this.isEditable) {
            String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
            String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
            String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
            OmiMessage.errorCodes errorCodes2 = null;
            try {
                errorCodes2 = OmiMessage.errorCodes.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                errorCodes2 = null;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "WLAN profile ACL error notification: Unknown errorCode=" + string);
                return;
            }
            if (errorCodes2 == OmiMessage.errorCodes.ENoEnt) {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "WLAN profile ACL (error) notification: ,Id=" + String.valueOf(n) + " no ACL entry");
            } else {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "WLAN profile ACL error notification: " + dataNotificationEnum.toString() + ",Id=" + String.valueOf(n) + ",errCode=" + string + ",bad=" + string2 + ",maxLen=" + string3);
                String string4 = this.wlanProfileACLDetailPanel.getErrorLabelText(string2);
                String string5 = UtilErrorHandling.getErrorMessage(errorCodes2, string4, string3);
                GuiInfoConsole.showError(string5);
                if (string2 != null) {
                    this.wlanProfileACLDetailPanel.markErrorComponent(string2);
                }
            }
        }
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.processTableEvent();
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        this.taskConfigureShowWlanProfile();
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.processTableEvent();
    }
}

