/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.wlan;

import com.aastra.oamp.guiutil.GuiUtilChangeHandler;
import com.aastra.oamp.guiutil.GuiUtilCheckBox;
import com.aastra.oamp.guiutil.GuiUtilComboBox;
import com.aastra.oamp.guiutil.GuiUtilTextFieldFSGuiMode;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.wlan.WlanProfileDetailPanel;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.WLANProfileHandler;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class WlanProfileSSIDGeneralDetailPanel
extends AastraPanel {
    private static final long serialVersionUID = 1L;
    private final int instance;
    private GuiUtilChangeHandler utilChangeHandler = null;
    private String tabTitle = null;
    private WlanProfileDetailPanel wlanProfileDetailPanel = null;
    private boolean isEditable;
    private boolean enableSecurityWEP;
    private GuiUtilCheckBox checkBoxActive = null;
    private GuiUtilCheckBox checkBoxVLANTag = null;
    private GuiUtilTextFieldFSGuiMode textFieldVLANTag = null;
    private GuiUtilComboBox comboBoxSecurity = null;
    private boolean comboBoxSecurityActionListenerActive = false;
    private GuiUtilCheckBox checkBoxBSSIsolation = null;
    private GuiUtilCheckBox checkBoxACLConfiguration = null;
    private GuiUtilCheckBox checkBoxHiddenSSID = null;

    WlanProfileSSIDGeneralDetailPanel(WlanProfileDetailPanel wlanProfileDetailPanel, int n, String string, GuiUtilChangeHandler guiUtilChangeHandler, boolean bl) {
        this.wlanProfileDetailPanel = wlanProfileDetailPanel;
        this.instance = n;
        this.utilChangeHandler = guiUtilChangeHandler;
        this.tabTitle = string;
        this.isEditable = bl;
        this.initialize();
    }

    private void initialize() {
        AastraLabel aastraLabel = null;
        AastraLabel aastraLabel2 = null;
        AastraLabel aastraLabel3 = null;
        AastraLabel aastraLabel4 = null;
        AastraLabel aastraLabel5 = null;
        AastraLabel aastraLabel6 = null;
        this.setLayout(null);
        aastraLabel = new AastraLabel();
        aastraLabel.setBounds(30, 30, 170, 16);
        aastraLabel.setText(UtilLocale.getString("TXT_SSID_ENABLED"));
        this.add(aastraLabel);
        this.add(this.getCheckBoxActive());
        aastraLabel2 = new AastraLabel();
        aastraLabel2.setBounds(30, 60, 170, 16);
        aastraLabel2.setText(UtilLocale.getString("TXT_VLAN_TAG"));
        this.add(aastraLabel2);
        this.add(this.getCheckBoxVLANTag());
        this.add(this.getTextFieldVLANTag());
        aastraLabel3 = new AastraLabel();
        aastraLabel3.setBounds(30, 90, 170, 16);
        aastraLabel3.setText(UtilLocale.getString("TXT_SECURITY_TYPE"));
        this.add(aastraLabel3);
        this.add(this.getComboBoxSecurity());
        aastraLabel4 = new AastraLabel();
        aastraLabel4.setBounds(30, 120, 170, 16);
        aastraLabel4.setText(UtilLocale.getString("TXT_BSS_ISOLATION"));
        this.add(aastraLabel4);
        this.add(this.getCheckBoxBSSIsolation());
        aastraLabel5 = new AastraLabel();
        aastraLabel5.setBounds(30, 150, 170, 16);
        aastraLabel5.setText(UtilLocale.getString("TXT_USE_MAC_ACCESS_FILTER"));
        this.add(aastraLabel5);
        this.add(this.getCheckBoxACLConfiguration());
        aastraLabel6 = new AastraLabel();
        aastraLabel6.setBounds(30, 180, 170, 16);
        aastraLabel6.setText(UtilLocale.getString("TXT_HIDDEN_SSID_MODE"));
        this.add(aastraLabel6);
        this.add(this.getCheckBoxHiddenSSID());
        if (this.isEditable) {
            this.wlanProfileDetailPanel.errorCompPut(OmiMessage.SSIDProfileType.vlanTag.name() + (this.instance + 1), aastraLabel2, this.textFieldVLANTag, this.tabTitle);
        }
    }

    private GuiUtilCheckBox getCheckBoxActive() {
        if (this.checkBoxActive == null) {
            this.checkBoxActive = new GuiUtilCheckBox(this.utilChangeHandler, 215, 30);
            if (this.instance == 0) {
                this.checkBoxActive.setEnabled(false);
            }
        }
        return this.checkBoxActive;
    }

    private GuiUtilCheckBox getCheckBoxVLANTag() {
        if (this.checkBoxVLANTag == null) {
            this.checkBoxVLANTag = new GuiUtilCheckBox(this.utilChangeHandler, 215, 60);
            this.checkBoxVLANTag.setEnabled(false);
            if (this.isEditable) {
                this.checkBoxVLANTag.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (WlanProfileSSIDGeneralDetailPanel.this.checkBoxVLANTag.isSelected()) {
                            WlanProfileSSIDGeneralDetailPanel.this.textFieldVLANTag.setEditable(true);
                            if (WlanProfileSSIDGeneralDetailPanel.this.instance == 0) {
                                WlanProfileSSIDGeneralDetailPanel.this.wlanProfileDetailPanel.configureWMEDependencyVLAN(true);
                            }
                        } else {
                            WlanProfileSSIDGeneralDetailPanel.this.textFieldVLANTag.setText(null);
                            WlanProfileSSIDGeneralDetailPanel.this.textFieldVLANTag.setEditable(false);
                            WlanProfileSSIDGeneralDetailPanel.this.wlanProfileDetailPanel.getUtilErrorComp().clearComponent(WlanProfileSSIDGeneralDetailPanel.this.textFieldVLANTag);
                            if (WlanProfileSSIDGeneralDetailPanel.this.instance == 0) {
                                WlanProfileSSIDGeneralDetailPanel.this.wlanProfileDetailPanel.configureWMEDependencyVLAN(false);
                            }
                        }
                    }
                });
            }
        }
        return this.checkBoxVLANTag;
    }

    protected boolean isCheckBoxVLANTagSelected() {
        return this.checkBoxVLANTag.isSelected();
    }

    private GuiUtilTextFieldFSGuiMode getTextFieldVLANTag() {
        if (this.textFieldVLANTag == null) {
            this.textFieldVLANTag = new GuiUtilTextFieldFSGuiMode(245, 60, AastraCommon.TextFieldSizeType.xs, this.utilChangeHandler, this.isEditable);
            this.textFieldVLANTag.setEditable(false);
            this.textFieldVLANTag.setToolTipText(UtilLocale.getString("TXT_VLAN_TAG_HELP"));
        }
        return this.textFieldVLANTag;
    }

    private GuiUtilComboBox getComboBoxSecurity() {
        if (this.comboBoxSecurity == null) {
            this.comboBoxSecurity = new GuiUtilComboBox(this.utilChangeHandler);
            this.comboBoxSecurity.setBounds(215, 90, 100, 20);
            this.fillComboBoxSecurity();
            if (this.isEditable) {
                this.comboBoxSecurity.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (WlanProfileSSIDGeneralDetailPanel.this.comboBoxSecurityActionListenerActive) {
                            WlanProfileSSIDGeneralDetailPanel.this.wlanProfileDetailPanel.configureTabSecurity(WlanProfileSSIDGeneralDetailPanel.this.instance, OmiMessage.WLANSecurityType.valueOf(WlanProfileSSIDGeneralDetailPanel.this.comboBoxSecurity.getSelectedItem().toString()));
                        }
                    }
                });
                this.comboBoxSecurityActionListenerActive = true;
                this.comboBoxSecurity.activateActionListener();
            }
        }
        return this.comboBoxSecurity;
    }

    private GuiUtilCheckBox getCheckBoxBSSIsolation() {
        if (this.checkBoxBSSIsolation == null) {
            this.checkBoxBSSIsolation = new GuiUtilCheckBox(this.utilChangeHandler, 215, 120);
            if (this.instance > 0) {
                this.checkBoxBSSIsolation.setEnabled(false);
            }
        }
        return this.checkBoxBSSIsolation;
    }

    private GuiUtilCheckBox getCheckBoxACLConfiguration() {
        if (this.checkBoxACLConfiguration == null) {
            this.checkBoxACLConfiguration = new GuiUtilCheckBox(this.utilChangeHandler, 215, 150);
        }
        return this.checkBoxACLConfiguration;
    }

    private GuiUtilCheckBox getCheckBoxHiddenSSID() {
        if (this.checkBoxHiddenSSID == null) {
            this.checkBoxHiddenSSID = new GuiUtilCheckBox(this.utilChangeHandler, 215, 180);
        }
        return this.checkBoxHiddenSSID;
    }

    protected void updateSecurityWEP(boolean bl) {
        this.enableSecurityWEP = bl;
        this.comboBoxSecurityActionListenerActive = false;
        OmiMessage.WLANSecurityType wLANSecurityType = OmiMessage.WLANSecurityType.valueOf(this.getComboBoxSecurity().getSelectedItem().toString());
        this.comboBoxSecurity.removeAllItems();
        this.fillComboBoxSecurity();
        if (!this.enableSecurityWEP && wLANSecurityType == OmiMessage.WLANSecurityType.WEP) {
            wLANSecurityType = OmiMessage.WLANSecurityType.Open;
        }
        this.comboBoxSecurity.setSelectedItem((Object)wLANSecurityType);
        this.comboBoxSecurityActionListenerActive = true;
        this.wlanProfileDetailPanel.configureTabSecurity(this.instance, wLANSecurityType);
    }

    private void fillComboBoxSecurity() {
        for (int i = 0; i < OmiMessage.WLANSecurityType.values().length; ++i) {
            if (OmiMessage.WLANSecurityType.values()[i] == OmiMessage.WLANSecurityType.WEP) {
                if (!this.enableSecurityWEP) continue;
                this.comboBoxSecurity.addItem(OmiMessage.WLANSecurityType.values()[i]);
                continue;
            }
            this.comboBoxSecurity.addItem(OmiMessage.WLANSecurityType.values()[i]);
        }
    }

    protected void setData(WLANProfileHandler.SSIDProfile sSIDProfile) {
        if (sSIDProfile != null) {
            if (this.instance > 0) {
                if (sSIDProfile.enable != null) {
                    this.checkBoxActive.setSelected(sSIDProfile.enable);
                } else {
                    this.checkBoxActive.setSelected(false);
                }
            }
            if (this.instance == 0) {
                if (this.isEditable) {
                    this.checkBoxVLANTag.setEnabled(true);
                }
                if (sSIDProfile.vlanTag > 0) {
                    this.checkBoxVLANTag.setSelected(true);
                    if (this.isEditable) {
                        this.textFieldVLANTag.setEditable(true);
                    }
                    this.textFieldVLANTag.setText(String.valueOf(sSIDProfile.vlanTag));
                } else {
                    this.checkBoxVLANTag.setSelected(false);
                    if (this.isEditable) {
                        this.textFieldVLANTag.setEditable(false);
                    }
                    this.textFieldVLANTag.setText(null);
                }
            } else {
                if (this.isEditable) {
                    this.checkBoxVLANTag.setEnabled(false);
                    this.textFieldVLANTag.setEditable(true);
                }
                this.checkBoxVLANTag.setSelected(true);
                if (sSIDProfile.vlanTag > 0) {
                    this.textFieldVLANTag.setText(String.valueOf(sSIDProfile.vlanTag));
                }
            }
            this.comboBoxSecurity.deactivateActionListener();
            if (sSIDProfile.security != null) {
                this.comboBoxSecurity.setSelectedItem((Object)sSIDProfile.security);
            } else {
                this.comboBoxSecurity.setSelectedItem((Object)OmiMessage.WLANSecurityType.Open);
            }
            this.comboBoxSecurity.activateActionListener();
            if (this.instance == 0) {
                this.checkBoxBSSIsolation.setSelected(sSIDProfile.bssIsolation);
            } else {
                this.checkBoxBSSIsolation.setSelected(false);
            }
            if (sSIDProfile.useACL != null) {
                this.checkBoxACLConfiguration.setSelected(sSIDProfile.useACL);
            } else {
                this.checkBoxACLConfiguration.setSelected(false);
            }
            if (sSIDProfile.hiddenSSID != null) {
                this.checkBoxHiddenSSID.setSelected(sSIDProfile.hiddenSSID);
            } else {
                this.checkBoxHiddenSSID.setSelected(false);
            }
        } else {
            this.checkBoxActive.setSelected(false);
            if (this.instance == 0) {
                if (this.isEditable) {
                    this.checkBoxVLANTag.setEnabled(true);
                    this.textFieldVLANTag.setEditable(false);
                }
                this.checkBoxVLANTag.setSelected(false);
                this.textFieldVLANTag.setText(null);
            } else {
                if (this.isEditable) {
                    this.checkBoxVLANTag.setEnabled(false);
                    this.textFieldVLANTag.setEditable(true);
                }
                this.checkBoxVLANTag.setSelected(true);
                this.textFieldVLANTag.setText(null);
            }
            this.comboBoxSecurity.deactivateActionListener();
            this.comboBoxSecurity.setSelectedItem((Object)OmiMessage.WLANSecurityType.Open);
            this.comboBoxSecurity.activateActionListener();
            this.checkBoxBSSIsolation.setSelected(false);
            this.checkBoxACLConfiguration.setSelected(false);
            this.checkBoxHiddenSSID.setSelected(false);
        }
    }

    protected void setCheckBoxActive(boolean bl) {
        if (this.instance == 0) {
            this.checkBoxActive.setSelected(bl);
        }
    }

    protected void setProfileRFPTypeDependencies(OmiMessage.WLANProfileRFPType wLANProfileRFPType) {
        if (this.isEditable) {
            if (wLANProfileRFPType == OmiMessage.WLANProfileRFPType.RFP42) {
                this.checkBoxACLConfiguration.setSelected(false);
                this.checkBoxACLConfiguration.setEnabled(false);
                this.checkBoxHiddenSSID.setSelected(false);
                this.checkBoxHiddenSSID.setEnabled(false);
            } else {
                this.checkBoxACLConfiguration.setEnabled(true);
                this.checkBoxHiddenSSID.setEnabled(true);
            }
        }
    }

    protected WLANProfileHandler.SSIDProfile getData() {
        WLANProfileHandler.SSIDProfile sSIDProfile = new WLANProfileHandler.SSIDProfile();
        sSIDProfile.enable = this.checkBoxActive.isSelected();
        if (this.checkBoxVLANTag.isSelected()) {
            sSIDProfile.vlanTag = this.wlanProfileDetailPanel.getIntFromOtherWlanProfilePanelTextFieldNotNull(this.textFieldVLANTag, UtilLocale.getString("TXT_VLAN_TAG"), OmiMessage.SSIDProfileType.vlanTag.name() + (this.instance + 1));
            if (sSIDProfile.vlanTag == null) {
                return null;
            }
        } else {
            sSIDProfile.vlanTag = 0;
        }
        sSIDProfile.security = OmiMessage.WLANSecurityType.valueOf(this.comboBoxSecurity.getSelectedItem().toString());
        sSIDProfile.bssIsolation = this.instance == 0 ? Boolean.valueOf(this.checkBoxBSSIsolation.isSelected()) : Boolean.valueOf(false);
        sSIDProfile.useACL = this.checkBoxACLConfiguration.isEnabled() ? Boolean.valueOf(this.checkBoxACLConfiguration.isSelected()) : Boolean.valueOf(false);
        sSIDProfile.hiddenSSID = this.checkBoxHiddenSSID.isEnabled() ? Boolean.valueOf(this.checkBoxHiddenSSID.isSelected()) : Boolean.valueOf(false);
        return sSIDProfile;
    }
}

