/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.Base64Coder;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.OmiHandler;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;
import com.aastra.omilib.OmiRSA;
import com.aastra.util.UtilSpy;
import java.util.LinkedList;

public class AccountDataHandler
implements OmiManagementEventInterface,
OmiMessageInterface {
    private static final int MAX_BULK_RECORDS = 20;
    private static final int CNT_BUILTIN_ACCOUNTS = OmiMessage.BuiltInAccountType.values().length;
    private static final int INVALID_ID = -1;
    private OmiManagement om = null;
    private AccountDatabase accountDb = new AccountDatabase();
    private OmiHandler omiHandler = null;
    private boolean getBulkInProgress = false;
    private LinkedList<AccountDataNotificationInterface> listenerList = new LinkedList();

    public AccountDataHandler() {
    }

    public AccountDataHandler(OmiManagement omiManagement) {
        this.om = omiManagement;
        this.omiHandler = this.om.getOmiHandler();
        this.om.registerManagementEventListener(this);
        OmiMessage.elemIds.GetAccountResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.CreateAccountResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetAccountResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventAccountCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.DeleteAccountResp.registerDataNotificationListener(this);
    }

    public void registerDataNotificationListener(AccountDataNotificationInterface accountDataNotificationInterface) {
        this.listenerList.add(accountDataNotificationInterface);
    }

    public void deregisterDataNotificationListener(AccountDataNotificationInterface accountDataNotificationInterface) {
        this.listenerList.remove(accountDataNotificationInterface);
    }

    private void GenerateDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating account notification: No listener");
        }
        for (AccountDataNotificationInterface accountDataNotificationInterface : this.listenerList) {
            if (accountDataNotificationInterface == null) continue;
            accountDataNotificationInterface.processDataNotification(n, dataNotificationEnum);
        }
    }

    private void GenerateErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating account error notification: No listener");
        }
        for (AccountDataNotificationInterface accountDataNotificationInterface : this.listenerList) {
            if (accountDataNotificationInterface == null) continue;
            accountDataNotificationInterface.processErrorNotification(n, dataNotificationEnum, omiMessage);
        }
    }

    public Database getDb() {
        return this.accountDb;
    }

    public Account getAccountByAccountId(int n) {
        return this.accountDb.getRecordById(n);
    }

    public Account getAccountByTableIdx(int n) {
        return (Account)this.accountDb.getRecordByIdx(n);
    }

    public void sendGetAccount(int n) {
        this.sendGetAccountBulk(n, 1);
    }

    public void sendGetAccountBulk(int n, int n2) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetAccount);
        omiMessage.addAttrib(OmiMessage.attribIds.id.name(), n);
        omiMessage.addAttrib(OmiMessage.attribIds.maxRecords.name(), n2);
        this.omiHandler.sendOmiMessage(omiMessage);
        if (n2 > 1) {
            this.getBulkInProgress = true;
        }
    }

    private void setElemParams(OmiMessage omiMessage, Account account) {
        char[] cArray;
        Object object;
        if (account.username != null) {
            omiMessage.addAttrib(OmiMessage.AccountType.username.name(), account.username);
        }
        if (account.passwordChanged && account.password != null && (object = OmiRSA.encrypt(account.password)) != null) {
            cArray = Base64Coder.encode((byte[])object);
            omiMessage.addAttrib(OmiMessage.AccountType.password.name(), new String(cArray));
        }
        if (account.passwordOld != null && (object = OmiRSA.encrypt(account.passwordOld)) != null) {
            cArray = Base64Coder.encode((byte[])object);
            omiMessage.addAttrib(OmiMessage.AccountType.oldPassword.name(), new String(cArray));
        }
        if (account.permissions != null) {
            object = null;
            for (int i = 0; i < account.permissions.length; ++i) {
                object = object == null ? (Object)omiMessage.addSubElement(OmiMessage.elemIds.permission) : (Object)((OmiMessage)object).addElement(OmiMessage.elemIds.permission);
                ((OmiMessage)object).addBodyText(account.permissions[i].name());
            }
        }
        omiMessage.addAttrib(OmiMessage.AccountType.active.name(), account.active);
        if (account.pwAging != null) {
            omiMessage.addAttrib(OmiMessage.AccountType.aging.name(), account.pwAging.name());
        }
    }

    public void sendCreateAccount(Account account) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.CreateAccount);
        if (account.id != -1) {
            omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), account.id);
        }
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.account);
        if (account.id != -1) {
            omiMessage2.addAttrib(OmiMessage.AccountType.id.name(), account.id);
        }
        this.setElemParams(omiMessage2, account);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendSetAccount(Account account) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.SetAccount);
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), account.id);
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.account);
        omiMessage2.addAttrib(OmiMessage.AccountType.id.name(), account.id);
        this.setElemParams(omiMessage2, account);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendDeleteAccount(int n) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.DeleteAccount);
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), n);
        omiMessage.addAttrib(OmiMessage.AccountType.id.name(), n);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    private int processGetAccountResp(OmiMessage omiMessage) {
        Integer n = 0;
        int n2 = 0;
        for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
            n = this.processAccountElem(omiMessage2, DataNotificationEnum.NEW_DATA);
            if (n != null) {
                ++n2;
                continue;
            }
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "GetAccountResp no account elem");
        }
        if (n2 < 20) {
            return 0;
        }
        return n;
    }

    private Integer processAccountElem(OmiMessage omiMessage, DataNotificationEnum dataNotificationEnum) {
        if (omiMessage.id == OmiMessage.elemIds.account) {
            OmiMessage omiMessage2;
            Boolean bl;
            String string;
            String string2;
            String string3;
            int n = omiMessage.getAttribValInt(OmiMessage.AccountType.id.name());
            Account account = this.accountDb.getRecordById(n);
            if (account == null) {
                account = new Account(n);
            }
            if ((string3 = omiMessage.getAttribVal(OmiMessage.AccountType.username.name())) != null) {
                account.username = string3;
            }
            if ((string2 = omiMessage.getAttribVal(OmiMessage.AccountType.password.name())) != null) {
                account.password = string2;
                account.passwordChanged = false;
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.AccountType.aging.name())) != null) {
                try {
                    account.pwAging = OmiMessage.PasswordAgingType.valueOf(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (omiMessage.getAttribVal(OmiMessage.AccountType.expire.name()) != null) {
                account.pwExpires = omiMessage.getAttribValInt(OmiMessage.AccountType.expire.name());
            }
            if (omiMessage.getAttribVal(OmiMessage.AccountType.state.name()) != null) {
                account.pwState = OmiMessage.AccountPasswordStateType.valueOf(omiMessage.getAttribVal(OmiMessage.AccountType.state.name()));
            }
            if ((bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.AccountType.active.name())) != null) {
                account.active = bl;
            }
            int n2 = 0;
            for (omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
                if (omiMessage2.id != OmiMessage.elemIds.permission || !this.om.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVideo) && OmiMessage.PermissionType.valueOf(omiMessage2.getBodyText()) == OmiMessage.PermissionType.Video) continue;
                ++n2;
            }
            if (n2 > 0) {
                Account.access$602(account, new OmiMessage.PermissionType[n2]);
                n2 = 0;
                for (omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
                    if (omiMessage2.id != OmiMessage.elemIds.permission) continue;
                    try {
                        if (!this.om.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVideo) && OmiMessage.PermissionType.valueOf(omiMessage2.getBodyText()) == OmiMessage.PermissionType.Video) continue;
                        ((Account)account).permissions[n2] = OmiMessage.PermissionType.valueOf(omiMessage2.getBodyText());
                        ++n2;
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.accountDb.addAccount(account);
            this.GenerateDataNotification(n, dataNotificationEnum);
            return n;
        }
        return null;
    }

    @Override
    public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
        if (omiManagementEventEnum == OmiManagementEventEnum.LINK_READY) {
            this.accountDb.clearAll();
            OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.AccountCnf, null, null);
            this.sendGetAccountBulk(0, 20);
        }
    }

    @Override
    public void processOmiMessage(OmiMessage omiMessage) {
        String string = null;
        switch (omiMessage.id) {
            case GetAccountResp: {
                int n = this.processGetAccountResp(omiMessage);
                if (!this.getBulkInProgress) break;
                if (n > 0) {
                    this.sendGetAccountBulk(n + 1, 20);
                    break;
                }
                this.GenerateDataNotification(this.accountDb.getRecordNumber(), DataNotificationEnum.DATA_BULK_READY);
                this.getBulkInProgress = false;
                break;
            }
            case CreateAccountResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    this.GenerateErrorNotification(-1, DataNotificationEnum.NEW_DATA, omiMessage);
                    break;
                }
                OmiMessage omiMessage2 = omiMessage.getSubElement();
                if (omiMessage2 != null && this.processAccountElem(omiMessage2, DataNotificationEnum.NEW_DATA) != null) break;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "CreateAccountResp no Account elem");
                break;
            }
            case DeleteAccountResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    int n = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
                    this.GenerateErrorNotification(n, DataNotificationEnum.DATA_DELETED, omiMessage);
                    break;
                }
                int n = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
                this.accountDb.deleteAccount(n);
                this.GenerateDataNotification(n, DataNotificationEnum.DATA_DELETED);
                break;
            }
            case SetAccountResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    int n = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
                    this.GenerateErrorNotification(n, DataNotificationEnum.DATA_CHANGED, omiMessage);
                    break;
                }
                OmiMessage omiMessage3 = omiMessage.getSubElement();
                if (omiMessage3 != null && this.processAccountElem(omiMessage3, DataNotificationEnum.DATA_CHANGED) != null) break;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "SetAccountResp no Account elem");
                break;
            }
            case EventAccountCnf: {
                OmiMessage omiMessage4 = omiMessage.getSubElement();
                if (omiMessage4 != null) {
                    boolean bl = omiMessage.getAttribValBool(OmiMessage.attribIds.deleted.name());
                    if (bl) {
                        if (omiMessage4.id == OmiMessage.elemIds.account) {
                            int n = omiMessage4.getAttribValInt(OmiMessage.AccountType.id.name());
                            this.accountDb.deleteAccount(n);
                            this.GenerateDataNotification(n, DataNotificationEnum.DATA_DELETED);
                        }
                    } else if (this.processAccountElem(omiMessage4, DataNotificationEnum.DATA_CHANGED) != null) break;
                }
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "EventAccountCnf no Account elem");
                break;
            }
        }
    }

    public int getNumberOfAccounts() {
        return this.accountDb.getRecordNumber();
    }

    public static interface AccountDataNotificationInterface {
        public void processDataNotification(int var1, DataNotificationEnum var2);

        public void processErrorNotification(int var1, DataNotificationEnum var2, OmiMessage var3);
    }

    public static class AccountDatabase
    extends Database {
        public static final int MAX_ACCOUNTS = 100;
        Account[] accounts = new Account[100];
        int[] siteIdx = new int[100];
        int noOfAccounts = 0;

        @Override
        public DataRecord getRecordByIdx(int n) {
            if (n >= 0 && n < this.noOfAccounts) {
                return this.accounts[this.siteIdx[n]];
            }
            return null;
        }

        public Account getRecordById(int n) {
            if (n >= 0 && n < 100) {
                return this.accounts[n];
            }
            return null;
        }

        @Override
        public int getRecordNumber() {
            return this.noOfAccounts;
        }

        @Override
        public void updateIndex() {
            this.noOfAccounts = 0;
            for (int i = 0; i < 100; ++i) {
                if (this.accounts[i] == null) continue;
                this.siteIdx[this.noOfAccounts++] = i;
            }
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }

        public void addAccount(Account account) {
            if (account.id >= 0 && account.id < 100) {
                this.accounts[account.id] = account;
                if (account.id < OmiMessage.BuiltInAccountType.values().length) {
                    this.accounts[account.id].comment = OmiMessage.BuiltInAccountType.values()[account.id].getTranslatedString();
                }
                this.updateIndex();
            }
        }

        public void deleteAccount(int n) {
            this.accounts[n] = null;
            this.updateIndex();
        }

        public void clearAll() {
            for (int i = 0; i < this.noOfAccounts; ++i) {
                this.accounts[i] = null;
            }
            this.noOfAccounts = 0;
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }

        @Override
        public String[] getFieldNames() {
            return Account.getFieldNames();
        }
    }

    public static class Account
    extends DataRecord {
        public static final int IDX_ID = 0;
        public static final int IDX_ACTIVE = 1;
        public static final int IDX_USERNAME = 2;
        public static final int IDX_PASSWORD = 3;
        public static final int IDX_PASSWORD_OLD = 4;
        public static final int IDX_PERMISSIONS = 5;
        public static final int IDX_PW_AGING = 6;
        public static final int IDX_PW_EXPIRES = 7;
        public static final int IDX_PW_STATE = 8;
        public static final int IDX_COMMENT = 9;
        public static final int NUMBER_OF_FIELDS = 10;
        private static String[] fieldNames = new String[]{"id", "active", "username", "password", "old password", "permissions", "pw aging", "pw expires", "state", "comment"};
        public int id = -1;
        private boolean active = true;
        private String username = null;
        private String password = null;
        private boolean passwordChanged = false;
        private String passwordOld = null;
        private OmiMessage.PermissionType[] permissions = null;
        private OmiMessage.PasswordAgingType pwAging = null;
        private int pwExpires = 0;
        private OmiMessage.AccountPasswordStateType pwState = OmiMessage.AccountPasswordStateType.dontCare;
        private String comment = "";

        public Account() {
        }

        public Account(int n) {
            this.id = n;
        }

        public static void setTableHeaderText(int n, String string) {
            if (n >= 0 && n < 10) {
                Account.fieldNames[n] = string;
            }
        }

        public static String[] getFieldNames() {
            return fieldNames;
        }

        @Override
        public Object getField(int n) {
            switch (n) {
                case 0: {
                    return this.id;
                }
                case 1: {
                    return this.active;
                }
                case 2: {
                    return this.username;
                }
                case 3: {
                    return this.password;
                }
                case 4: {
                    return this.passwordOld;
                }
                case 5: {
                    return this.getPermissionsString();
                }
                case 6: {
                    return this.pwAging.getTranslatedString();
                }
                case 7: {
                    return this.pwExpires;
                }
                case 8: {
                    return this.pwState;
                }
                case 9: {
                    return this.comment;
                }
            }
            return null;
        }

        @Override
        public DataRecord clone() {
            Account account = new Account();
            account.id = this.id;
            account.active = this.active;
            account.username = this.username;
            account.password = this.password;
            account.passwordChanged = this.passwordChanged;
            account.passwordOld = this.passwordOld;
            if (this.permissions != null) {
                int n = this.permissions.length;
                account.permissions = new OmiMessage.PermissionType[n];
                for (int i = 0; i < n; ++i) {
                    account.permissions[i] = this.permissions[i];
                }
            }
            account.pwAging = this.pwAging;
            account.pwExpires = this.pwExpires;
            account.pwState = this.pwState;
            account.comment = this.comment;
            return account;
        }

        public boolean getActive() {
            return this.active;
        }

        public void setActive(boolean bl) {
            this.active = bl;
        }

        public String toString() {
            return this.username;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String string) {
            this.username = string;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String string) {
            if (string != null) {
                if (this.password != null) {
                    if (!this.password.equals(string)) {
                        this.passwordChanged = true;
                        this.password = string;
                    }
                } else {
                    this.passwordChanged = true;
                    this.password = string;
                }
            }
        }

        public boolean getPasswordChanged() {
            return this.passwordChanged;
        }

        public String getComment() {
            return this.comment;
        }

        public void setPasswordOld(String string) {
            if (string != null) {
                this.passwordOld = string;
            }
        }

        public OmiMessage.PermissionType[] getPermissions() {
            return this.permissions;
        }

        public String getPermissionsString() {
            String string = "";
            if (this.permissions != null && this.permissions.length != 0) {
                for (int i = 0; i < this.permissions.length; ++i) {
                    if (i > 0) {
                        string = string + ", ";
                    }
                    string = string + this.permissions[i].getTranslatedString();
                }
            }
            return string;
        }

        public void setPermissions(OmiMessage.PermissionType[] permissionTypeArray) {
            this.permissions = permissionTypeArray;
        }

        public void deletePermissions() {
            this.permissions = null;
        }

        public void addPermission(OmiMessage.PermissionType permissionType) {
            if (this.permissions == null || this.permissions.length == 0) {
                this.permissions = new OmiMessage.PermissionType[1];
                this.permissions[0] = permissionType;
            } else {
                int n;
                int n2 = this.permissions.length;
                for (n = 0; n < n2; ++n) {
                    if (this.permissions[n] != permissionType) continue;
                    return;
                }
                OmiMessage.PermissionType[] permissionTypeArray = new OmiMessage.PermissionType[n2 + 1];
                for (n = 0; n < n2; ++n) {
                    permissionTypeArray[n] = this.permissions[n];
                }
                permissionTypeArray[n2] = permissionType;
                this.permissions = permissionTypeArray;
            }
        }

        public OmiMessage.PasswordAgingType getPwAging() {
            return this.pwAging;
        }

        public void setPwAging(OmiMessage.PasswordAgingType passwordAgingType) {
            this.pwAging = passwordAgingType;
        }

        public boolean isBuiltinAccount() {
            return this.id != -1 && this.id < CNT_BUILTIN_ACCOUNTS;
        }

        public boolean isBuiltinAdminAccount() {
            return this.id == OmiMessage.BuiltInAccountType.admin.ordinal();
        }

        public boolean isBuiltinUserAccount() {
            return this.id == OmiMessage.BuiltInAccountType.user.ordinal();
        }

        static /* synthetic */ OmiMessage.PermissionType[] access$602(Account account, OmiMessage.PermissionType[] permissionTypeArray) {
            account.permissions = permissionTypeArray;
            return permissionTypeArray;
        }
    }
}

