/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.OmiHandler;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;
import com.aastra.util.UtilSpy;
import java.util.LinkedList;

public class AlarmTriggerHandler
implements OmiManagementEventInterface,
OmiMessageInterface {
    private AlarmTriggerDatabase alarmTriggerDb = new AlarmTriggerDatabase();
    private OmiHandler omiHandler = null;
    private boolean getBulkInProgress = false;
    private LinkedList<AlarmTriggerCnfDataNotificationInterface> listenerList = new LinkedList();
    private static String[] fieldNames = new String[]{"id", "triggerId", "FAC", "comment", "num"};

    public AlarmTriggerHandler(OmiManagement omiManagement) {
        this.omiHandler = omiManagement.getOmiHandler();
        omiManagement.registerManagementEventListener(this);
        OmiMessage.elemIds.GetAlarmTriggerSummaryResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetAlarmTriggerResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.CreateAlarmTriggerResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetAlarmTriggerResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventAlarmTriggerCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.DeleteAlarmTriggerResp.registerDataNotificationListener(this);
    }

    public void registerDataNotificationListener(AlarmTriggerCnfDataNotificationInterface alarmTriggerCnfDataNotificationInterface) {
        this.listenerList.add(alarmTriggerCnfDataNotificationInterface);
    }

    public void deregisterDataNotificationListener(AlarmTriggerCnfDataNotificationInterface alarmTriggerCnfDataNotificationInterface) {
        this.listenerList.remove(alarmTriggerCnfDataNotificationInterface);
    }

    private void GenerateDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating alarm trigger notification: No listener");
        }
        for (AlarmTriggerCnfDataNotificationInterface alarmTriggerCnfDataNotificationInterface : this.listenerList) {
            if (alarmTriggerCnfDataNotificationInterface == null) continue;
            alarmTriggerCnfDataNotificationInterface.processDataNotification(n, dataNotificationEnum);
        }
    }

    private void GenerateErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating alarm trigger error notification: No listener");
        }
        for (AlarmTriggerCnfDataNotificationInterface alarmTriggerCnfDataNotificationInterface : this.listenerList) {
            if (alarmTriggerCnfDataNotificationInterface == null) continue;
            alarmTriggerCnfDataNotificationInterface.processErrorNotification(n, dataNotificationEnum, omiMessage);
        }
    }

    public Database getDb() {
        return this.alarmTriggerDb;
    }

    public AlarmTrigger getTriggerById(int n) {
        AlarmTrigger alarmTrigger = this.alarmTriggerDb.getRecordById(n);
        return alarmTrigger;
    }

    public AlarmTrigger getTriggerByTableIdx(int n) {
        AlarmTrigger alarmTrigger = (AlarmTrigger)this.alarmTriggerDb.getRecordByIdx(n);
        return alarmTrigger;
    }

    public void SendGetAlarmTrigger(int n) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetAlarmTrigger);
        omiMessage.addAttrib(OmiMessage.attribIds.id.name(), n);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendGetAlarmTriggerBulk(int n, int n2) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetAlarmTrigger);
        omiMessage.addAttrib(OmiMessage.attribIds.id.name(), n);
        omiMessage.addAttrib(OmiMessage.attribIds.maxRecords.name(), n2);
        this.omiHandler.sendOmiMessage(omiMessage);
        if (n2 > 1) {
            this.getBulkInProgress = true;
        }
    }

    public void sendCreateAlarmTrigger(AlarmTrigger alarmTrigger) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.CreateAlarmTrigger);
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.trigger);
        if (alarmTrigger.triggerId != null) {
            omiMessage2.addAttrib(OmiMessage.AlarmTriggerType.triggerId.name(), alarmTrigger.triggerId);
        }
        if (alarmTrigger.fac != null) {
            omiMessage2.addAttrib(OmiMessage.AlarmTriggerType.fac.name(), alarmTrigger.fac);
        }
        if (alarmTrigger.comment != null) {
            omiMessage2.addAttrib(OmiMessage.AlarmTriggerType.comment.name(), alarmTrigger.comment);
        }
        if (alarmTrigger.num != null) {
            omiMessage2.addAttrib(OmiMessage.AlarmTriggerType.num.name(), alarmTrigger.num);
        }
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendSetAlarmTrigger(AlarmTrigger alarmTrigger) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.SetAlarmTrigger);
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), alarmTrigger.id);
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.trigger);
        omiMessage2.addAttrib(OmiMessage.AlarmTriggerType.id.name(), alarmTrigger.id);
        if (alarmTrigger.triggerId != null) {
            omiMessage2.addAttrib(OmiMessage.AlarmTriggerType.triggerId.name(), alarmTrigger.triggerId);
        }
        if (alarmTrigger.fac != null) {
            omiMessage2.addAttrib(OmiMessage.AlarmTriggerType.fac.name(), alarmTrigger.fac);
        }
        if (alarmTrigger.comment != null) {
            omiMessage2.addAttrib(OmiMessage.AlarmTriggerType.comment.name(), alarmTrigger.comment);
        }
        if (alarmTrigger.num != null) {
            omiMessage2.addAttrib(OmiMessage.AlarmTriggerType.num.name(), alarmTrigger.num);
        }
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendDeleteAlarmTrigger(int n) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.DeleteAlarmTrigger);
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), n);
        omiMessage.addAttrib(OmiMessage.AlarmTriggerType.id.name(), n);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    private int processGetAlarmTriggerResp(OmiMessage omiMessage) {
        AlarmTrigger alarmTrigger;
        int n = 0;
        for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
            if (!this.processTriggerElem(omiMessage2, DataNotificationEnum.NEW_DATA)) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "GetAlarmTriggerResp no trigger elem");
                continue;
            }
            ++n;
        }
        if (n == 16 && (alarmTrigger = (AlarmTrigger)this.alarmTriggerDb.getRecordByIdx(this.alarmTriggerDb.getRecordNumber() - 1)) != null) {
            return (Integer)alarmTrigger.getField(0);
        }
        return 0;
    }

    private boolean processTriggerElem(OmiMessage omiMessage, DataNotificationEnum dataNotificationEnum) {
        if (omiMessage.id == OmiMessage.elemIds.trigger) {
            String string;
            int n = omiMessage.getAttribValInt(OmiMessage.AlarmTriggerType.id.name());
            AlarmTrigger alarmTrigger = this.alarmTriggerDb.getRecordById(n);
            if (alarmTrigger == null) {
                alarmTrigger = new AlarmTrigger(n);
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.AlarmTriggerType.triggerId.name())) != null) {
                alarmTrigger.triggerId = string;
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.AlarmTriggerType.fac.name())) != null) {
                alarmTrigger.fac = string;
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.AlarmTriggerType.comment.name())) != null) {
                alarmTrigger.comment = string;
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.AlarmTriggerType.num.name())) != null) {
                alarmTrigger.num = string;
            }
            this.alarmTriggerDb.addTrigger(alarmTrigger);
            this.GenerateDataNotification(n, dataNotificationEnum);
            return true;
        }
        return false;
    }

    @Override
    public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
        if (omiManagementEventEnum == OmiManagementEventEnum.LINK_READY) {
            this.alarmTriggerDb.clearAll();
            this.GenerateDataNotification(0, DataNotificationEnum.DATA_DELETED_ALL);
            OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.AlarmTriggerCnf, null, null);
            this.sendGetAlarmTriggerBulk(0, 20);
        }
    }

    @Override
    public void processOmiMessage(OmiMessage omiMessage) {
        String string = null;
        switch (omiMessage.id) {
            case GetAlarmTriggerResp: {
                int n = this.processGetAlarmTriggerResp(omiMessage);
                if (!this.getBulkInProgress) break;
                if (n > 0) {
                    this.sendGetAlarmTriggerBulk(n + 1, 16);
                    break;
                }
                this.GenerateDataNotification(this.alarmTriggerDb.getRecordNumber(), DataNotificationEnum.DATA_BULK_READY);
                this.getBulkInProgress = false;
                break;
            }
            case CreateAlarmTriggerResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    this.GenerateErrorNotification(-1, DataNotificationEnum.NEW_DATA, omiMessage);
                    break;
                }
                OmiMessage omiMessage2 = omiMessage.getSubElement();
                if (omiMessage2 != null && this.processTriggerElem(omiMessage2, DataNotificationEnum.NEW_DATA)) break;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "CreateAlarmTriggerResp no trigger elem");
                break;
            }
            case DeleteAlarmTriggerResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    int n = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
                    this.GenerateErrorNotification(n, DataNotificationEnum.DATA_DELETED, omiMessage);
                    break;
                }
                int n = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
                this.alarmTriggerDb.deleteTrigger(n);
                this.GenerateDataNotification(n, DataNotificationEnum.DATA_DELETED);
                break;
            }
            case SetAlarmTriggerResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    int n = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
                    this.GenerateErrorNotification(n, DataNotificationEnum.DATA_CHANGED, omiMessage);
                    break;
                }
                OmiMessage omiMessage3 = omiMessage.getSubElement();
                if (omiMessage3 != null && this.processTriggerElem(omiMessage3, DataNotificationEnum.DATA_CHANGED)) break;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "SetAlarmTriggerResp no trigger elem");
                break;
            }
            case EventAlarmTriggerCnf: {
                OmiMessage omiMessage4 = omiMessage.getSubElement();
                if (omiMessage4 != null) {
                    boolean bl = omiMessage.getAttribValBool(OmiMessage.attribIds.deleted.name());
                    if (bl) {
                        if (omiMessage4.id == OmiMessage.elemIds.trigger) {
                            int n = omiMessage4.getAttribValInt(OmiMessage.AlarmTriggerType.id.name());
                            this.alarmTriggerDb.deleteTrigger(n);
                            this.GenerateDataNotification(n, DataNotificationEnum.DATA_DELETED);
                            break;
                        }
                    } else if (this.processTriggerElem(omiMessage4, DataNotificationEnum.DATA_CHANGED)) break;
                }
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "EventAlarmTriggerCnf no trigger elem");
                break;
            }
        }
    }

    public int getNumberOfTrigger() {
        return this.alarmTriggerDb.getRecordNumber();
    }

    public static interface AlarmTriggerCnfDataNotificationInterface {
        public void processDataNotification(int var1, DataNotificationEnum var2);

        public void processErrorNotification(int var1, DataNotificationEnum var2, OmiMessage var3);
    }

    public static class AlarmTriggerDatabase
    extends Database {
        public static final int MAX_TRIGGER = 256;
        AlarmTrigger[] triggers = new AlarmTrigger[256];
        int[] triggerIdx = new int[256];
        int noOfTriggers = 0;

        @Override
        public DataRecord getRecordByIdx(int n) {
            if (n >= 0 && n < this.noOfTriggers) {
                return this.triggers[this.triggerIdx[n]];
            }
            return null;
        }

        public AlarmTrigger getRecordById(int n) {
            if (n >= 0 && n < 256) {
                return this.triggers[n];
            }
            return null;
        }

        @Override
        public int getRecordNumber() {
            return this.noOfTriggers;
        }

        @Override
        public void updateIndex() {
            this.noOfTriggers = 0;
            for (int i = 0; i < 256; ++i) {
                if (this.triggers[i] == null) continue;
                this.triggerIdx[this.noOfTriggers++] = i;
            }
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }

        public void addTrigger(AlarmTrigger alarmTrigger) {
            if (alarmTrigger.id >= 0 && alarmTrigger.id < 256) {
                this.triggers[alarmTrigger.id] = alarmTrigger;
                this.updateIndex();
            }
        }

        public void deleteTrigger(int n) {
            this.triggers[n] = null;
            this.updateIndex();
        }

        public void clearAll() {
            for (int i = 0; i < this.noOfTriggers; ++i) {
                this.triggers[i] = null;
            }
            this.noOfTriggers = 0;
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }

        @Override
        public String[] getFieldNames() {
            return fieldNames;
        }
    }

    public static class AlarmTrigger
    extends DataRecord {
        public static final int IDX_ID = 0;
        public static final int IDX_TRIGGER_ID = 1;
        public static final int IDX_FAC = 2;
        public static final int IDX_COMMENT = 3;
        public static final int IDX_NUM = 4;
        public static final int NUMBER_OF_FIELDS = 5;
        public int id;
        public String triggerId;
        public String fac;
        public String comment;
        public String num;

        public AlarmTrigger() {
        }

        public AlarmTrigger(int n) {
            this.id = n;
        }

        public String toString() {
            return this.triggerId;
        }

        @Override
        public Object getField(int n) {
            switch (n) {
                case 0: {
                    return this.id;
                }
                case 1: {
                    return this.triggerId;
                }
                case 2: {
                    return this.fac;
                }
                case 3: {
                    return this.comment;
                }
                case 4: {
                    return this.num;
                }
            }
            return null;
        }

        @Override
        public DataRecord clone() {
            AlarmTrigger alarmTrigger = new AlarmTrigger();
            alarmTrigger.id = this.id;
            alarmTrigger.triggerId = this.triggerId;
            alarmTrigger.fac = this.fac;
            alarmTrigger.comment = this.comment;
            alarmTrigger.num = this.num;
            return alarmTrigger;
        }

        public static void setTableHeaderText(int n, String string) {
            if (n >= 0 && n < 5) {
                fieldNames[n] = string;
            }
        }
    }
}

