/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.DataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.DatabaseChangeEvent;
import com.aastra.omilib.OmiHandler;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;
import com.aastra.util.UtilSpy;
import java.util.LinkedList;

public class BluetoothBeaconHandler
extends DataHandler
implements OmiMessageInterface,
OmiManagementEventInterface {
    public static final int BUILTIN_MAX_BTB_STAT_DATA = 6;
    private static final int MAX_DEVICE_PER_REQ = 20;
    private OmiHandler omiHandler = null;
    private BtBeaconDatabase btBeaconDb = null;
    private boolean getReqInProgress = false;
    private boolean startFlag = false;
    private boolean autoMode = false;
    private BtBeaconRec[] changeDeleteBeacons = null;
    private LinkedList<BtBeaconNotificationInterface> listenerList = new LinkedList();

    public BluetoothBeaconHandler(OmiManagement omiManagement, int n) {
        this.omiHandler = omiManagement.getOmiHandler();
        this.btBeaconDb = new BtBeaconDatabase(n);
        omiManagement.registerManagementEventListener(this);
        this.initialize();
    }

    public BluetoothBeaconHandler(OmiManagement omiManagement, int n, boolean bl) {
        this.omiHandler = omiManagement.getOmiHandler();
        this.btBeaconDb = new BtBeaconDatabase(n);
        omiManagement.registerManagementEventListener(this);
        this.autoMode = bl;
        this.initialize();
    }

    private void initialize() {
        OmiMessage.elemIds.GetBluetoothBeaconResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.CreateBluetoothBeaconResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.DeleteBluetoothBeaconResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetBluetoothBeaconResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventBluetoothBeaconCnf.registerDataNotificationListener(this);
    }

    public void registerDataNotificationListener(BtBeaconNotificationInterface btBeaconNotificationInterface) {
        this.listenerList.add(btBeaconNotificationInterface);
    }

    public void deregisterDataNotificationListener(BtBeaconNotificationInterface btBeaconNotificationInterface) {
        this.listenerList.remove(btBeaconNotificationInterface);
    }

    private void GenerateDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating Bluetooth beacon notification: No listener");
        }
        for (BtBeaconNotificationInterface btBeaconNotificationInterface : this.listenerList) {
            if (btBeaconNotificationInterface == null) continue;
            btBeaconNotificationInterface.processBtdDataNotification(n, dataNotificationEnum);
        }
    }

    private void GenerateErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating Bluetooth beacon error notification: No listener");
        }
        for (BtBeaconNotificationInterface btBeaconNotificationInterface : this.listenerList) {
            if (btBeaconNotificationInterface == null) continue;
            btBeaconNotificationInterface.processBtdDataErrorNotification(n, dataNotificationEnum, omiMessage);
        }
    }

    public Database getDb() {
        return this.btBeaconDb;
    }

    private void sendGetBluetoothBeacons(int n) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetBluetoothBeacon);
        omiMessage.addAttrib(OmiMessage.BtBeaconType.id.name(), n);
        omiMessage.addAttrib(OmiMessage.attribIds.maxRecords.name(), 20);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public boolean sendBluetoothBeaconReq(int n) {
        if (!this.getReqInProgress) {
            OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetBluetoothBeacon);
            omiMessage.addAttrib(OmiMessage.BtBeaconType.id.name(), n);
            this.omiHandler.sendOmiMessage(omiMessage);
            return true;
        }
        return false;
    }

    public void sendCreateBluetoothBeacon(BtBeaconRec btBeaconRec) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.CreateBluetoothBeacon);
        this.addBtdElem(omiMessage, btBeaconRec);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public boolean sendSetBluetoothBeacon(BtBeaconRec btBeaconRec) {
        if (btBeaconRec.getRecordChanged()) {
            OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.SetBluetoothBeacon);
            omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), btBeaconRec.id);
            this.addBtdElem(omiMessage, btBeaconRec);
            this.omiHandler.sendOmiMessage(omiMessage);
            return true;
        }
        return false;
    }

    public void sendDeleteBluetoothBeacon(int n) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.DeleteBluetoothBeacon);
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), n);
        omiMessage.addAttrib(OmiMessage.attribIds.id.name(), n);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public boolean sendChangeDeleteBtBeacon(DataHandler.SendBulkActionType sendBulkActionType, BtBeaconRec[] btBeaconRecArray, DataHandler.DataHandlerSendBulkInterface dataHandlerSendBulkInterface) {
        if (btBeaconRecArray == null || btBeaconRecArray.length == 0) {
            return false;
        }
        this.changeDeleteBeacons = (BtBeaconRec[])btBeaconRecArray.clone();
        return this.startSendBulk(sendBulkActionType, this.changeDeleteBeacons.length, dataHandlerSendBulkInterface);
    }

    public void cancelChangeDeleteBtBeacon() {
        this.stopSendBulk();
    }

    @Override
    protected void sendNextChange(int n) {
        this.sendSetBluetoothBeacon(this.changeDeleteBeacons[n]);
    }

    @Override
    protected void sendNextDelete(int n) {
        this.sendDeleteBluetoothBeacon(this.changeDeleteBeacons[n].id);
    }

    public void start() {
        if (!this.startFlag) {
            this.btBeaconDb.clearAll();
            OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.BluetoothCnf, null, null);
            this.sendGetBluetoothBeacons(0);
            this.getReqInProgress = true;
            this.startFlag = true;
        }
    }

    public void stop() {
        this.getReqInProgress = false;
        OmiMessage.sendResetEventSubscription(this.omiHandler, OmiMessage.EventType.BluetoothCnf, null, null);
    }

    private BtBeaconRec convertBtdElem(OmiMessage omiMessage) {
        if (omiMessage.id == OmiMessage.elemIds.btb) {
            BtBeaconRec btBeaconRec = new BtBeaconRec();
            Integer n = null;
            Boolean bl = null;
            String string = null;
            n = omiMessage.getAttribValIntNotMandatory(OmiMessage.BtBeaconType.id.name());
            if (n != null) {
                btBeaconRec.setField(0, n);
            }
            if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.BtBeaconType.rfpId.name())) != null) {
                btBeaconRec.setField(2, n);
            }
            if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.BtBeaconType.rssi.name())) != null) {
                btBeaconRec.setField(8, n);
            }
            btBeaconRec.setField(1, omiMessage.getAttribVal(OmiMessage.BtBeaconType.ethAddr.name()));
            btBeaconRec.setField(3, omiMessage.getAttribVal(OmiMessage.BtBeaconType.name.name()));
            btBeaconRec.setField(4, omiMessage.getAttribVal(OmiMessage.BtBeaconType.hierarchy1.name()));
            btBeaconRec.setField(5, omiMessage.getAttribVal(OmiMessage.BtBeaconType.hierarchy2.name()));
            btBeaconRec.setField(6, omiMessage.getAttribVal(OmiMessage.BtBeaconType.hierarchy3.name()));
            btBeaconRec.setField(7, omiMessage.getAttribVal(OmiMessage.BtBeaconType.hierarchy4.name()));
            string = omiMessage.getAttribVal(OmiMessage.BtBeaconType.state.name());
            if (string != null) {
                btBeaconRec.setField(10, (Object)OmiMessage.BtBeaconStateType.valueOf(string));
            }
            if ((bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.BtBeaconType.checkpoint.name())) != null) {
                btBeaconRec.setField(11, bl);
            }
            return btBeaconRec;
        }
        return null;
    }

    private void addBtdElem(OmiMessage omiMessage, BtBeaconRec btBeaconRec) {
        if (btBeaconRec == null) {
            return;
        }
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.btb);
        if (btBeaconRec.id != -1) {
            omiMessage2.addAttrib(OmiMessage.BtBeaconType.id.name(), btBeaconRec.id);
        }
        if (btBeaconRec.rfpId != -1) {
            omiMessage2.addAttrib(OmiMessage.BtBeaconType.rfpId.name(), btBeaconRec.rfpId);
        }
        if (btBeaconRec.ethAddr != null) {
            omiMessage2.addAttrib(OmiMessage.BtBeaconType.ethAddr.name(), btBeaconRec.ethAddr);
        }
        if (btBeaconRec.name != null) {
            omiMessage2.addAttrib(OmiMessage.BtBeaconType.name.name(), btBeaconRec.name);
        }
        if (btBeaconRec.hierarchy1 != null) {
            omiMessage2.addAttrib(OmiMessage.BtBeaconType.hierarchy1.name(), btBeaconRec.hierarchy1);
        }
        if (btBeaconRec.hierarchy2 != null) {
            omiMessage2.addAttrib(OmiMessage.BtBeaconType.hierarchy2.name(), btBeaconRec.hierarchy2);
        }
        if (btBeaconRec.hierarchy3 != null) {
            omiMessage2.addAttrib(OmiMessage.BtBeaconType.hierarchy3.name(), btBeaconRec.hierarchy3);
        }
        if (btBeaconRec.hierarchy4 != null) {
            omiMessage2.addAttrib(OmiMessage.BtBeaconType.hierarchy4.name(), btBeaconRec.hierarchy4);
        }
        if (btBeaconRec.rssiThreshold != -1000) {
            omiMessage2.addAttrib(OmiMessage.BtBeaconType.rssi.name(), btBeaconRec.rssiThreshold);
        }
        if (btBeaconRec.calibration != null) {
            omiMessage2.addAttrib(OmiMessage.BtBeaconType.calibration.name(), btBeaconRec.calibration);
        }
        if (btBeaconRec.checkpoint != null) {
            omiMessage2.addAttrib(OmiMessage.BtBeaconType.checkpoint.name(), btBeaconRec.checkpoint);
        }
    }

    @Override
    public void processOmiMessage(OmiMessage omiMessage) {
        int n = 0;
        OmiMessage omiMessage2 = null;
        int n2 = 0;
        switch (omiMessage.id) {
            case GetBluetoothBeaconResp: {
                for (omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
                    BtBeaconRec btBeaconRec = this.convertBtdElem(omiMessage2);
                    if (btBeaconRec == null) continue;
                    n = btBeaconRec.id;
                    ++n2;
                    btBeaconRec.commitChanges();
                    this.btBeaconDb.addBtBeacon(btBeaconRec);
                }
                if (n2 == 20) {
                    if (!this.getReqInProgress) break;
                    this.sendGetBluetoothBeacons(n + 1);
                    break;
                }
                if (!this.getReqInProgress) break;
                this.getReqInProgress = false;
                this.GenerateDataNotification(this.btBeaconDb.getRecordNumber(), DataNotificationEnum.DATA_BULK_READY);
                break;
            }
            case CreateBluetoothBeaconResp: {
                BtBeaconRec btBeaconRec;
                String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    this.GenerateErrorNotification(-1, DataNotificationEnum.NEW_DATA, omiMessage);
                    break;
                }
                omiMessage2 = omiMessage.getSubElement();
                if (omiMessage2 == null || (btBeaconRec = this.convertBtdElem(omiMessage2)) == null) break;
                btBeaconRec.commitChanges();
                this.btBeaconDb.addBtBeacon(btBeaconRec);
                this.GenerateDataNotification(btBeaconRec.id, DataNotificationEnum.NEW_DATA);
                break;
            }
            case DeleteBluetoothBeaconResp: {
                this.checkSendBulk();
                n = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
                String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    this.GenerateErrorNotification(n, DataNotificationEnum.DATA_DELETED, omiMessage);
                    break;
                }
                this.btBeaconDb.deleteBtBeacon(n);
                this.GenerateDataNotification(n, DataNotificationEnum.DATA_DELETED);
                break;
            }
            case SetBluetoothBeaconResp: {
                this.checkSendBulk();
                String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    n = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
                    this.GenerateErrorNotification(n, DataNotificationEnum.DATA_CHANGED, omiMessage);
                    break;
                }
                OmiMessage omiMessage3 = omiMessage.getSubElement();
                if (omiMessage3 != null) {
                    BtBeaconRec btBeaconRec = this.convertBtdElem(omiMessage3);
                    if (btBeaconRec != null) {
                        btBeaconRec.commitChanges();
                        this.btBeaconDb.addBtBeacon(btBeaconRec);
                        this.GenerateDataNotification(btBeaconRec.id, DataNotificationEnum.DATA_CHANGED_RESP);
                        break;
                    }
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "SetBlueToothDongleResp subelement error");
                    break;
                }
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "SetBlueToothDongleResp no btd elem");
                break;
            }
            case EventBluetoothBeaconCnf: {
                boolean bl = omiMessage.getAttribValBool(OmiMessage.attribIds.deleted.name());
                OmiMessage omiMessage4 = omiMessage.getSubElement();
                if (omiMessage4 != null) {
                    if (bl) {
                        n = omiMessage4.getAttribValInt(OmiMessage.BtBeaconType.id.name());
                        this.btBeaconDb.deleteBtBeacon(n);
                        this.GenerateDataNotification(n, DataNotificationEnum.DATA_DELETED);
                        break;
                    }
                    BtBeaconRec btBeaconRec = this.convertBtdElem(omiMessage4);
                    if (btBeaconRec != null) {
                        btBeaconRec.commitChanges();
                        DataNotificationEnum dataNotificationEnum = this.btBeaconDb.getRecordById(btBeaconRec.id) != null ? DataNotificationEnum.DATA_CHANGED_CNF : DataNotificationEnum.NEW_DATA;
                        this.btBeaconDb.addBtBeacon(btBeaconRec);
                        this.GenerateDataNotification(btBeaconRec.id, dataNotificationEnum);
                        break;
                    }
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "EventBlueToothDongleCnf subelement error");
                    break;
                }
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "EventBlueToothDongleCnf no btd elem");
                break;
            }
        }
    }

    @Override
    public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
        if (omiManagementEventEnum == OmiManagementEventEnum.LINK_READY && (this.startFlag || this.autoMode)) {
            this.startFlag = false;
            this.start();
        }
    }

    public static interface BtBeaconNotificationInterface {
        public void processBtdDataNotification(int var1, DataNotificationEnum var2);

        public void processBtdDataErrorNotification(int var1, DataNotificationEnum var2, OmiMessage var3);
    }

    public static class BtBeaconDatabase
    extends Database {
        public static final int MAX_BT_BEACONS = 1024;
        public static int maxBtBeacons = 1024;
        BtBeaconRec[] btBeacons;
        int[] btBeaconsIdx;
        int noOfBtBeacons = 0;
        int maxBtBeaconId = -1;

        public BtBeaconDatabase() {
            this.initialize();
        }

        public BtBeaconDatabase(int n) {
            maxBtBeacons = n;
            this.initialize();
        }

        private void initialize() {
            this.btBeacons = new BtBeaconRec[maxBtBeacons];
            this.btBeaconsIdx = new int[maxBtBeacons];
        }

        @Override
        public DataRecord getRecordByIdx(int n) {
            if (n >= 0 && n < this.noOfBtBeacons) {
                return this.btBeacons[this.btBeaconsIdx[n]];
            }
            return null;
        }

        public BtBeaconRec getRecordById(int n) {
            if (n >= 0 && n < maxBtBeacons) {
                return this.btBeacons[n];
            }
            return null;
        }

        @Override
        public int getRecordNumber() {
            return this.noOfBtBeacons;
        }

        @Override
        public void updateIndex() {
            this.updateIndex(new DatabaseChangeEvent(Database.DatabaseChangeEnum.INDEX_UPDATE, 0, DatabaseChangeEvent.DatabaseChangeType.BTD));
        }

        public void updateIndex(DatabaseChangeEvent databaseChangeEvent) {
            int n = -1;
            this.noOfBtBeacons = 0;
            for (int i = 0; i <= this.maxBtBeaconId; ++i) {
                if (this.btBeacons[i] == null) continue;
                if (this.getFilterActive(0)) {
                    if (!this.filterMatch(this.btBeacons[i])) continue;
                    if (databaseChangeEvent.recordId == i) {
                        n = this.noOfBtBeacons;
                    }
                    this.btBeaconsIdx[this.noOfBtBeacons++] = i;
                    continue;
                }
                if (databaseChangeEvent.recordId == i) {
                    n = this.noOfBtBeacons;
                }
                this.btBeaconsIdx[this.noOfBtBeacons++] = i;
            }
            if (n != -1) {
                databaseChangeEvent.modelId = n;
            }
            this.generateChangeNotification(databaseChangeEvent);
        }

        public void addBtBeacon(BtBeaconRec btBeaconRec) {
            DatabaseChangeEvent databaseChangeEvent = null;
            int n = btBeaconRec.id;
            if (n < 0 || n >= maxBtBeacons) {
                return;
            }
            if (this.btBeacons[n] != null) {
                databaseChangeEvent = new DatabaseChangeEvent(Database.DatabaseChangeEnum.RECORD_CHANGED, n, DatabaseChangeEvent.DatabaseChangeType.BTD);
                if (btBeaconRec.ethAddr != null) {
                    this.btBeacons[n].ethAddr = btBeaconRec.ethAddr;
                }
                if (btBeaconRec.rfpId != -1) {
                    this.btBeacons[n].rfpId = btBeaconRec.rfpId;
                }
                if (btBeaconRec.name != null) {
                    this.btBeacons[n].name = btBeaconRec.name;
                }
                if (btBeaconRec.hierarchy1 != null) {
                    this.btBeacons[n].hierarchy1 = btBeaconRec.hierarchy1;
                }
                if (btBeaconRec.hierarchy2 != null) {
                    this.btBeacons[n].hierarchy2 = btBeaconRec.hierarchy2;
                }
                if (btBeaconRec.hierarchy3 != null) {
                    this.btBeacons[n].hierarchy3 = btBeaconRec.hierarchy3;
                }
                if (btBeaconRec.hierarchy4 != null) {
                    this.btBeacons[n].hierarchy4 = btBeaconRec.hierarchy4;
                }
                if (btBeaconRec.rssiThreshold != -1000) {
                    this.btBeacons[n].rssiThreshold = btBeaconRec.rssiThreshold;
                }
                if (btBeaconRec.calibration != null) {
                    this.btBeacons[n].calibration = btBeaconRec.calibration;
                }
                if (btBeaconRec.state != null) {
                    this.btBeacons[n].state = btBeaconRec.state;
                }
                if (btBeaconRec.checkpoint != null) {
                    this.btBeacons[n].checkpoint = btBeaconRec.checkpoint;
                }
            } else {
                databaseChangeEvent = new DatabaseChangeEvent(Database.DatabaseChangeEnum.RECORD_ADDED, n, DatabaseChangeEvent.DatabaseChangeType.BTD);
                this.btBeacons[n] = btBeaconRec;
            }
            if (n > this.maxBtBeaconId) {
                this.maxBtBeaconId = n;
            }
            this.updateIndex(databaseChangeEvent);
        }

        public void deleteBtBeacon(int n) {
            if (n >= 0 && n < maxBtBeacons) {
                this.btBeacons[n] = null;
                if (n == this.maxBtBeaconId) {
                    while (this.maxBtBeaconId >= 0 && this.btBeacons[this.maxBtBeaconId] == null) {
                        --this.maxBtBeaconId;
                    }
                }
            }
            DatabaseChangeEvent databaseChangeEvent = new DatabaseChangeEvent(Database.DatabaseChangeEnum.RECORD_DELETED, n, DatabaseChangeEvent.DatabaseChangeType.BTD);
            this.updateIndex(databaseChangeEvent);
        }

        public void deleteBtBeacon(String string) {
            for (int i = 0; i <= this.maxBtBeaconId; ++i) {
                if (this.btBeacons[i] == null || !string.equals(this.btBeacons[i].ethAddr)) continue;
                this.deleteBtBeacon(i);
                return;
            }
        }

        public void deleteBtBeaconsOnRfp(int n) {
            for (int i = 0; i <= this.maxBtBeaconId; ++i) {
                if (this.btBeacons[i] == null || this.btBeacons[i].rfpId != n) continue;
                this.deleteBtBeacon(i);
            }
        }

        public void clearAll() {
            for (int i = 0; i <= this.maxBtBeaconId; ++i) {
                this.btBeacons[i] = null;
            }
            this.maxBtBeaconId = -1;
            this.updateIndex();
        }

        @Override
        public String[] getFieldNames() {
            return BtBeaconRec.getFieldNames();
        }
    }

    public static class BtBeaconRec
    extends DataRecord {
        public static final int INVALID_ID = -1;
        public static final int INVALID_RSSI = -1000;
        public static final int IDX_ID = 0;
        public static final int IDX_ETH_ADDR = 1;
        public static final int IDX_RFP_ID = 2;
        public static final int IDX_NAME = 3;
        public static final int IDX_HIERARCHY1 = 4;
        public static final int IDX_HIERARCHY2 = 5;
        public static final int IDX_HIERARCHY3 = 6;
        public static final int IDX_HIERARCHY4 = 7;
        public static final int IDX_RSSI_THRESHOLD = 8;
        public static final int IDX_CALIBRATION = 9;
        public static final int IDX_STATE = 10;
        public static final int IDX_CHECKPOINT = 11;
        public static final int IDX_POSITIONED = 12;
        public static final int NUMBER_OF_FIELDS = 13;
        int id = -1;
        int rfpId = -1;
        String ethAddr = null;
        String name = null;
        String hierarchy1 = null;
        String hierarchy2 = null;
        String hierarchy3 = null;
        String hierarchy4 = null;
        int rssiThreshold = -1000;
        Integer calibration = null;
        OmiMessage.BtBeaconStateType state = null;
        Boolean checkpoint = null;
        public boolean positioned = false;
        public int locatingXPos = 0;
        public int locatingYPos = 0;
        public int locatingImageId = -1;
        boolean changed = false;
        private static String[] fieldNames = new String[]{"id", "MAC address", "rfpId", "name", "hierarchy1", "hierarchy2", "hierarchy3", "hierarchy4", "rssi", "calibration", "state", "checkpoint", "positioned"};

        public static void setTableHeaderText(int n, String string) {
            if (n >= 0 && n < 13) {
                BtBeaconRec.fieldNames[n] = string;
            }
        }

        public static String[] getFieldNames() {
            return fieldNames;
        }

        @Override
        public Object getField(int n) {
            switch (n) {
                case 0: {
                    return this.id;
                }
                case 2: {
                    if (this.rfpId == -1) {
                        return null;
                    }
                    return this.rfpId;
                }
                case 1: {
                    return this.ethAddr;
                }
                case 3: {
                    return this.name;
                }
                case 4: {
                    return this.hierarchy1;
                }
                case 5: {
                    return this.hierarchy2;
                }
                case 6: {
                    return this.hierarchy3;
                }
                case 7: {
                    return this.hierarchy4;
                }
                case 8: {
                    if (this.rssiThreshold == -1000) {
                        return null;
                    }
                    return this.rssiThreshold;
                }
                case 9: {
                    return this.calibration;
                }
                case 10: {
                    return this.state;
                }
                case 11: {
                    return this.checkpoint;
                }
                case 12: {
                    return this.positioned;
                }
            }
            return null;
        }

        @Override
        public void setField(int n, Object object) {
            int n2 = 0;
            String string = null;
            Boolean bl = false;
            OmiMessage.BtBeaconStateType btBeaconStateType = null;
            try {
                switch (n) {
                    case 0: 
                    case 2: 
                    case 8: 
                    case 9: {
                        n2 = (Integer)object;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        string = (String)object;
                        break;
                    }
                    case 10: {
                        btBeaconStateType = (OmiMessage.BtBeaconStateType)((Object)object);
                        break;
                    }
                    case 11: {
                        bl = (Boolean)object;
                        break;
                    }
                    case 12: {
                        this.positioned = (Boolean)object;
                        return;
                    }
                }
            }
            catch (Exception exception) {
                return;
            }
            switch (n) {
                case 0: {
                    if (this.id == n2) break;
                    this.changed = true;
                    this.id = n2;
                    break;
                }
                case 2: {
                    if (this.rfpId == n2) break;
                    this.changed = true;
                    this.rfpId = n2;
                    break;
                }
                case 1: {
                    if (string != null && this.ethAddr != null) {
                        if (this.ethAddr.equals(string)) {
                            return;
                        }
                        this.changed = true;
                        this.ethAddr = string;
                        return;
                    }
                    if (string == null && this.ethAddr == null) {
                        return;
                    }
                    this.changed = true;
                    this.ethAddr = string;
                    break;
                }
                case 3: {
                    if (string != null && this.name != null) {
                        if (this.name.equals(string)) {
                            return;
                        }
                        this.changed = true;
                        this.name = string;
                        return;
                    }
                    if (string == null && this.name == null) {
                        return;
                    }
                    this.changed = true;
                    this.name = string;
                    break;
                }
                case 4: {
                    if (string != null && this.hierarchy1 != null) {
                        if (this.hierarchy1.equals(string)) {
                            return;
                        }
                        this.changed = true;
                        this.hierarchy1 = string;
                        return;
                    }
                    if (string == null && this.hierarchy1 == null) {
                        return;
                    }
                    this.changed = true;
                    this.hierarchy1 = string;
                    break;
                }
                case 5: {
                    if (string != null && this.hierarchy2 != null) {
                        if (this.hierarchy2.equals(string)) {
                            return;
                        }
                        this.changed = true;
                        this.hierarchy2 = string;
                        return;
                    }
                    if (string == null && this.hierarchy2 == null) {
                        return;
                    }
                    this.changed = true;
                    this.hierarchy2 = string;
                    break;
                }
                case 6: {
                    if (string != null && this.hierarchy3 != null) {
                        if (this.hierarchy3.equals(string)) {
                            return;
                        }
                        this.changed = true;
                        this.hierarchy3 = string;
                        return;
                    }
                    if (string == null && this.hierarchy3 == null) {
                        return;
                    }
                    this.changed = true;
                    this.hierarchy3 = string;
                    break;
                }
                case 7: {
                    if (string != null && this.hierarchy4 != null) {
                        if (this.hierarchy4.equals(string)) {
                            return;
                        }
                        this.changed = true;
                        this.hierarchy4 = string;
                        return;
                    }
                    if (string == null && this.hierarchy4 == null) {
                        return;
                    }
                    this.changed = true;
                    this.hierarchy4 = string;
                    break;
                }
                case 10: {
                    if (this.state == btBeaconStateType) break;
                    this.changed = true;
                    this.state = btBeaconStateType;
                    break;
                }
                case 8: {
                    if (this.rssiThreshold == n2) break;
                    this.changed = true;
                    this.rssiThreshold = n2;
                    break;
                }
                case 9: {
                    if (this.calibration == n2) break;
                    this.changed = true;
                    this.calibration = n2;
                    break;
                }
                case 11: {
                    if (this.checkpoint == bl) break;
                    this.changed = true;
                    this.checkpoint = bl;
                }
            }
        }

        public boolean getRecordChanged() {
            return this.changed;
        }

        public void commitChanges() {
            this.changed = false;
        }

        @Override
        public DataRecord clone() {
            BtBeaconRec btBeaconRec = new BtBeaconRec();
            btBeaconRec.id = this.id;
            btBeaconRec.ethAddr = this.ethAddr;
            btBeaconRec.rfpId = this.rfpId;
            btBeaconRec.name = this.name;
            btBeaconRec.hierarchy1 = this.hierarchy1;
            btBeaconRec.hierarchy2 = this.hierarchy2;
            btBeaconRec.hierarchy3 = this.hierarchy3;
            btBeaconRec.hierarchy4 = this.hierarchy4;
            btBeaconRec.rssiThreshold = this.rssiThreshold;
            btBeaconRec.calibration = this.calibration;
            btBeaconRec.state = this.state;
            btBeaconRec.checkpoint = this.checkpoint;
            btBeaconRec.locatingImageId = this.locatingImageId;
            btBeaconRec.locatingXPos = this.locatingXPos;
            btBeaconRec.locatingYPos = this.locatingYPos;
            btBeaconRec.positioned = this.positioned;
            return btBeaconRec;
        }
    }

    public static class BTClientStatisticData {
        public int ppn = 0;
        public String ethAddr = "";
        public BTBStatisticData[] btLocStat = new BTBStatisticData[6];
    }

    public static class BTBStatisticData {
        public int id = -1;
        public int rssi = -1000;
    }
}

