/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.Base64Coder;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.OmiHandler;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;
import com.aastra.omilib.OmiRSA;
import com.aastra.omilib.OmilibUtil;
import com.aastra.omilib.VersionHandler;
import com.aastra.omilib.VersionTypeEnum;
import com.aastra.util.UtilSpy;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public class CommonDataHandler
implements OmiManagementEventInterface,
OmiMessageInterface {
    private OmiManagement om = null;
    private OmiHandler omiHandler = null;
    private boolean fetchDataOnLinkReady = true;
    private String initialPARK = null;
    private int actualFetchIdx = CommonDataItemEnum.values().length;
    private static boolean doClearAll = true;
    public static final int REV_XSI_DIR_LOOKUP_MATCHING_DIGITS_ALL = 0;
    public static final int REV_XSI_DIR_LOOKUP_MATCHING_DIGITS_MAX = 9;
    public static final int REV_XSI_DIR_LOOKUP_MATCHING_DIGITS_DEFAULT = 6;
    private CommonDataItemClass[] dataElems = new CommonDataItemClass[CommonDataItemEnum.values().length];
    private LinkedList<CommonDataNotificationInterface> listenerList = new LinkedList();

    private void initDataElems() {
        EnumSet<CommonDataItemEnum> enumSet = EnumSet.allOf(CommonDataItemEnum.class);
        for (CommonDataItemEnum commonDataItemEnum : enumSet) {
            switch (commonDataItemEnum) {
                case Limits: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemLimits(OmiMessage.elemIds.Limits, null, OmiMessage.elemIds.LimitsResp, null, null);
                    break;
                }
                case SystemName: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemString(OmiMessage.elemIds.GetSystemName, OmiMessage.elemIds.SetSystemName, OmiMessage.elemIds.GetSystemNameResp, OmiMessage.elemIds.SetSystemNameResp, OmiMessage.elemIds.EventSystemNameCnf, OmiMessage.attribIds.name);
                    break;
                }
                case PublicKey: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemPublicKey(OmiMessage.elemIds.GetPublicKey, null, OmiMessage.elemIds.GetPublicKeyResp, null, null);
                    break;
                }
                case RemoteAccess: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemBool(OmiMessage.elemIds.GetRemoteAccess, OmiMessage.elemIds.SetRemoteAccess, OmiMessage.elemIds.GetRemoteAccessResp, OmiMessage.elemIds.SetRemoteAccessResp, OmiMessage.elemIds.EventRemoteAccessCnf, OmiMessage.attribIds.enable);
                    break;
                }
                case EULAConfirm: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemBool(OmiMessage.elemIds.GetEULAConfirm, OmiMessage.elemIds.SetEULAConfirm, OmiMessage.elemIds.GetEULAConfirmResp, OmiMessage.elemIds.SetEULAConfirmResp, OmiMessage.elemIds.EventEULAConfirmCnf, OmiMessage.attribIds.confirm);
                    break;
                }
                case NetParams: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemNetParams(OmiMessage.elemIds.GetNetParams, OmiMessage.elemIds.SetNetParams, OmiMessage.elemIds.GetNetParamsResp, OmiMessage.elemIds.SetNetParamsResp, OmiMessage.elemIds.EventNetParamsCnf);
                    break;
                }
                case PARK: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemString(OmiMessage.elemIds.GetPARK, OmiMessage.elemIds.SetPARK, OmiMessage.elemIds.GetPARKResp, OmiMessage.elemIds.SetPARKResp, OmiMessage.elemIds.EventPARKCnf, OmiMessage.attribIds.park);
                    break;
                }
                case DECTEncryption: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemBool(OmiMessage.elemIds.GetDECTEncryption, OmiMessage.elemIds.SetDECTEncryption, OmiMessage.elemIds.GetDECTEncryptionResp, OmiMessage.elemIds.SetDECTEncryptionResp, OmiMessage.elemIds.EventDECTEncryptionCnf, OmiMessage.attribIds.enable);
                    break;
                }
                case DECTRegDomain: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemDECTRegDomain(OmiMessage.elemIds.GetDECTRegDomain, OmiMessage.elemIds.SetDECTRegDomain, OmiMessage.elemIds.GetDECTRegDomainResp, OmiMessage.elemIds.SetDECTRegDomainResp, OmiMessage.elemIds.EventDECTRegDomainCnf);
                    break;
                }
                case DECTAuthCode: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemString(OmiMessage.elemIds.GetDECTAuthCode, OmiMessage.elemIds.SetDECTAuthCode, OmiMessage.elemIds.GetDECTAuthCodeResp, OmiMessage.elemIds.SetDECTAuthCodeResp, OmiMessage.elemIds.EventDECTAuthCodeCnf, OmiMessage.attribIds.ac);
                    break;
                }
                case PPDevAutoCreate: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemBool(OmiMessage.elemIds.GetDevAutoCreate, OmiMessage.elemIds.SetDevAutoCreate, OmiMessage.elemIds.GetDevAutoCreateResp, OmiMessage.elemIds.SetDevAutoCreateResp, OmiMessage.elemIds.EventDevAutoCreateCnf, OmiMessage.attribIds.enable);
                    break;
                }
                case PPLoginVariant: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemPPLoginVariant(OmiMessage.elemIds.GetPPLoginVariant, OmiMessage.elemIds.SetPPLoginVariant, OmiMessage.elemIds.GetPPLoginVariantResp, OmiMessage.elemIds.SetPPLoginVariantResp, OmiMessage.elemIds.EventPPLoginVariantCnf);
                    break;
                }
                case PPFirmwareUpdate: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemPPFirmwareUpdate(OmiMessage.elemIds.GetPPFirmwareUpdate, OmiMessage.elemIds.SetPPFirmwareUpdate, OmiMessage.elemIds.GetPPFirmwareUpdateResp, OmiMessage.elemIds.SetPPFirmwareUpdateResp, OmiMessage.elemIds.EventPPFirmwareUpdateCnf);
                    break;
                }
                case WLANRegDomain: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemWLANRegDomain(OmiMessage.elemIds.GetWLANRegDomain, OmiMessage.elemIds.SetWLANRegDomain, OmiMessage.elemIds.GetWLANRegDomainResp, OmiMessage.elemIds.SetWLANRegDomainResp, OmiMessage.elemIds.EventWLANRegDomainCnf);
                    break;
                }
                case WLANRegDomainList: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemWLANRegDomainList(OmiMessage.elemIds.GetWLANRegDomainList, null, OmiMessage.elemIds.GetWLANRegDomainListResp, null, null);
                    break;
                }
                case UserDataServer: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemUserDataServer(OmiMessage.elemIds.GetUserDataServer, OmiMessage.elemIds.SetUserDataServer, OmiMessage.elemIds.GetUserDataServerResp, OmiMessage.elemIds.SetUserDataServerResp, OmiMessage.elemIds.EventUserDataServerCnf);
                    break;
                }
                case BasicSIP: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemBasicSIP(OmiMessage.elemIds.GetBasicSIP, OmiMessage.elemIds.SetBasicSIP, OmiMessage.elemIds.GetBasicSIPResp, OmiMessage.elemIds.SetBasicSIPResp, OmiMessage.elemIds.EventBasicSIPCnf);
                    break;
                }
                case AdvancedSIP: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemAdvancedSIP(OmiMessage.elemIds.GetAdvancedSIP, OmiMessage.elemIds.SetAdvancedSIP, OmiMessage.elemIds.GetAdvancedSIPResp, OmiMessage.elemIds.SetAdvancedSIPResp, OmiMessage.elemIds.EventAdvancedSIPCnf);
                    break;
                }
                case BackupSIP: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemBackupSIP(OmiMessage.elemIds.GetBackupSIP, OmiMessage.elemIds.SetBackupSIP, OmiMessage.elemIds.GetBackupSIPResp, OmiMessage.elemIds.SetBackupSIPResp, OmiMessage.elemIds.EventBackupSIPCnf);
                    break;
                }
                case RTP: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemRTP(OmiMessage.elemIds.GetRTP, OmiMessage.elemIds.SetRTP, OmiMessage.elemIds.GetRTPResp, OmiMessage.elemIds.SetRTPResp, OmiMessage.elemIds.EventRTPCnf);
                    break;
                }
                case DTMF: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemDTMF(OmiMessage.elemIds.GetDTMF, OmiMessage.elemIds.SetDTMF, OmiMessage.elemIds.GetDTMFResp, OmiMessage.elemIds.SetDTMFResp, OmiMessage.elemIds.EventDTMFCnf);
                    break;
                }
                case SecureSIP: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemSecureSIP(OmiMessage.elemIds.GetSecureSIP, OmiMessage.elemIds.SetSecureSIP, OmiMessage.elemIds.GetSecureSIPResp, OmiMessage.elemIds.SetSecureSIPResp, OmiMessage.elemIds.EventSecureSIPCnf, OmiMessage.OpenRespAttribType.haveSIP);
                    break;
                }
                case SecureSIPCertificate: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemCertificate(OmiMessage.elemIds.GetSecureSIPCertificate, OmiMessage.elemIds.SetSecureSIPCertificate, OmiMessage.elemIds.GetSecureSIPCertificateResp, OmiMessage.elemIds.SetSecureSIPCertificateResp, OmiMessage.elemIds.EventSecureSIPCertificateCnf);
                    break;
                }
                case ManualDbBackup: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemClass(null, null, null, OmiMessage.elemIds.ManualDBBackupResp, null);
                    this.dataElems[commonDataItemEnum.ordinal()].fetchAtStart = false;
                    break;
                }
                case ManualDbRestore: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemClass(null, null, null, OmiMessage.elemIds.ManualDBRestoreResp, null);
                    this.dataElems[commonDataItemEnum.ordinal()].fetchAtStart = false;
                    break;
                }
                case AutoDbBackup: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemUrl(OmiMessage.elemIds.GetAutoDBBackup, OmiMessage.elemIds.SetAutoDBBackup, OmiMessage.elemIds.GetAutoDBBackupResp, OmiMessage.elemIds.SetAutoDBBackupResp, OmiMessage.elemIds.EventAutoDBBackupCnf);
                    break;
                }
                case DbTransferState: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemDbTransferState(OmiMessage.elemIds.GetDbTransferState, null, OmiMessage.elemIds.GetDbTransferStateResp, null, OmiMessage.elemIds.EventDbTransferState);
                    this.dataElems[commonDataItemEnum.ordinal()].fetchAtStart = false;
                    break;
                }
                case IMA: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemImaCnf(OmiMessage.elemIds.GetIMA, OmiMessage.elemIds.SetIMA, OmiMessage.elemIds.GetIMAResp, OmiMessage.elemIds.SetIMAResp, OmiMessage.elemIds.EventIMACnf);
                    break;
                }
                case TimeZoneList: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemTimeZoneList(OmiMessage.elemIds.GetTimeZoneList, null, OmiMessage.elemIds.GetTimeZoneListResp, null, OmiMessage.elemIds.EventTimeZoneList);
                    break;
                }
                case TimeZone: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemString(OmiMessage.elemIds.GetTimeZone, OmiMessage.elemIds.SetTimeZone, OmiMessage.elemIds.GetTimeZoneResp, OmiMessage.elemIds.SetTimeZoneResp, OmiMessage.elemIds.EventTimeZoneCnf, OmiMessage.attribIds.id);
                    break;
                }
                case TimeZoneDetails: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemTimeZoneDetails(OmiMessage.elemIds.GetTimeZoneDetails, OmiMessage.elemIds.SetTimeZoneDetails, OmiMessage.elemIds.GetTimeZoneDetailsResp, OmiMessage.elemIds.SetTimeZoneDetailsResp, OmiMessage.elemIds.EventTimeZoneDetailsCnf);
                    break;
                }
                case ResetTimeZoneDetails: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemClass(OmiMessage.elemIds.ResetTimeZoneDetails, null, OmiMessage.elemIds.ResetTimeZoneDetailsResp, null, null);
                    this.dataElems[commonDataItemEnum.ordinal()].fetchAtStart = false;
                    break;
                }
                case PagingAreaSize: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemInt(OmiMessage.elemIds.GetDECTPagingAreaSize, OmiMessage.elemIds.SetDECTPagingAreaSize, OmiMessage.elemIds.GetDECTPagingAreaSizeResp, OmiMessage.elemIds.SetDECTPagingAreaSizeResp, OmiMessage.elemIds.EventDECTPagingAreaCnf, OmiMessage.attribIds.size);
                    break;
                }
                case SNMP: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemSNMP(OmiMessage.elemIds.GetSNMP, OmiMessage.elemIds.SetSNMP, OmiMessage.elemIds.GetSNMPResp, OmiMessage.elemIds.SetSNMPResp, OmiMessage.elemIds.EventSNMPCnf);
                    break;
                }
                case FACPrefix: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemString(OmiMessage.elemIds.GetFACPrefix, OmiMessage.elemIds.SetFACPrefix, OmiMessage.elemIds.GetFACPrefixResp, OmiMessage.elemIds.SetFACPrefixResp, OmiMessage.elemIds.EventFACPrefixCnf, OmiMessage.attribIds.prefix);
                    break;
                }
                case FACList: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemFACList(OmiMessage.elemIds.GetFACList, OmiMessage.elemIds.SetFACList, OmiMessage.elemIds.GetFACListResp, OmiMessage.elemIds.SetFACListResp, OmiMessage.elemIds.EventFACCnf);
                    break;
                }
                case AutoDbBackupFileName: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemString(OmiMessage.elemIds.GetAutoDBBackupFileName, null, OmiMessage.elemIds.GetAutoDBBackupFileNameResp, null, OmiMessage.elemIds.EventAutoDBBackupFileNameCnf, OmiMessage.attribIds.fileName);
                    break;
                }
                case SyslogCnf: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemSyslogCnf(OmiMessage.elemIds.GetSyslogServer, OmiMessage.elemIds.SetSyslogServer, OmiMessage.elemIds.GetSyslogServerResp, OmiMessage.elemIds.SetSyslogServerResp, OmiMessage.elemIds.EventSyslogServerCnf);
                    break;
                }
                case FlashMemUsage: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemInt(OmiMessage.elemIds.GetFlashMemUsage, null, OmiMessage.elemIds.GetFlashMemUsageResp, null, null, OmiMessage.attribIds.level);
                    break;
                }
                case DECTSubscriptMode: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemDECTSubMode(OmiMessage.elemIds.GetDECTSubscriptionMode, OmiMessage.elemIds.SetDECTSubscriptionMode, OmiMessage.elemIds.GetDECTSubscriptionModeResp, OmiMessage.elemIds.SetDECTSubscriptionModeResp, OmiMessage.elemIds.EventDECTSubscriptionMode);
                    break;
                }
                case HealthState: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemHealthState(OmiMessage.elemIds.GetHealthState, null, OmiMessage.elemIds.GetHealthStateResp, null, OmiMessage.elemIds.EventHealthState);
                    break;
                }
                case PbxCnf: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemPbxCnf(OmiMessage.elemIds.GetPBX, OmiMessage.elemIds.SetPBX, OmiMessage.elemIds.GetPBXResp, OmiMessage.elemIds.SetPBXResp, OmiMessage.elemIds.EventPBXCnf);
                    break;
                }
                case License: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemLicense(OmiMessage.elemIds.GetLicense, null, OmiMessage.elemIds.GetLicenseResp, null, OmiMessage.elemIds.EventLicenseCnf);
                    break;
                }
                case LicenseServer: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemLicenseServer(OmiMessage.elemIds.GetLicenseServerList, OmiMessage.elemIds.SetLicenseServerList, OmiMessage.elemIds.GetLicenseServerListResp, OmiMessage.elemIds.SetLicenseServerListResp, OmiMessage.elemIds.EventLicenseServerListCnf);
                    break;
                }
                case RegTrafficShape: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemRegTrafficShape(OmiMessage.elemIds.GetRegistrationTrafficShaping, OmiMessage.elemIds.SetRegistrationTrafficShaping, OmiMessage.elemIds.GetRegistrationTrafficShapingResp, OmiMessage.elemIds.SetRegistrationTrafficShapingResp, OmiMessage.elemIds.EventRegistrationTrafficShapingCnf);
                    break;
                }
                case SuplServ: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemSuplServ(OmiMessage.elemIds.GetSuplServ, OmiMessage.elemIds.SetSuplServ, OmiMessage.elemIds.GetSuplServResp, OmiMessage.elemIds.SetSuplServResp, OmiMessage.elemIds.EventSuplServCnf);
                    break;
                }
                case ConferenceServerSIP: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemConferenceServerSIP(OmiMessage.elemIds.GetConferenceServerSIP, OmiMessage.elemIds.SetConferenceServerSIP, OmiMessage.elemIds.GetConferenceServerSIPResp, OmiMessage.elemIds.SetConferenceServerSIPResp, OmiMessage.elemIds.EventConferenceServerSIPCnf);
                    break;
                }
                case VoiceboxNum: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemString(OmiMessage.elemIds.GetSysVoiceboxNum, OmiMessage.elemIds.SetSysVoiceboxNum, OmiMessage.elemIds.GetSysVoiceboxNumResp, OmiMessage.elemIds.SetSysVoiceboxNumResp, OmiMessage.elemIds.EventSysVoiceboxNumCnf, OmiMessage.attribIds.voiceboxNum, OmiMessage.OpenRespAttribType.haveVoiceboxNumber);
                    break;
                }
                case UserMonitoring: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemUserMonitoring(OmiMessage.elemIds.GetUserMonitoring, OmiMessage.elemIds.SetUserMonitoring, OmiMessage.elemIds.GetUserMonitoringResp, OmiMessage.elemIds.SetUserMonitoringResp, OmiMessage.elemIds.EventUserMonitoringCnf);
                    break;
                }
                case PPFirmwareUpdateOverview: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemPPFirmwareUpdateOverview(OmiMessage.elemIds.GetPPFirmwareUpdateOverview, null, OmiMessage.elemIds.GetPPFirmwareUpdateOverviewResp, null, OmiMessage.elemIds.EventPPFirmwareUpdateOverview);
                    break;
                }
                case BlueToothGlobal: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemBool(OmiMessage.elemIds.GetBluetoothGlobalSettings, OmiMessage.elemIds.SetBluetoothGlobalSettings, OmiMessage.elemIds.GetBluetoothGlobalSettingsResp, OmiMessage.elemIds.SetBluetoothGlobalSettingsResp, OmiMessage.elemIds.EventBluetoothGlobalSettingsCnf, OmiMessage.attribIds.active);
                    break;
                }
                case BlueToothSensitivity: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemBTSensitivity(OmiMessage.elemIds.GetBluetoothSensitivity, OmiMessage.elemIds.SetBluetoothSensitivity, OmiMessage.elemIds.GetBluetoothSensitivityResp, OmiMessage.elemIds.SetBluetoothSensitivityResp, OmiMessage.elemIds.EventBluetoothSensitivityCnf, OmiMessage.OpenRespAttribType.haveBluetooth);
                    break;
                }
                case ToneSchemeType: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemToneSchemeType(OmiMessage.elemIds.GetSysToneScheme, OmiMessage.elemIds.SetSysToneScheme, OmiMessage.elemIds.GetSysToneSchemeResp, OmiMessage.elemIds.SetSysToneSchemeResp, OmiMessage.elemIds.EventSysToneSchemeCnf);
                    break;
                }
                case RFPCapture: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemBool(OmiMessage.elemIds.GetRFPCapture, OmiMessage.elemIds.SetRFPCapture, OmiMessage.elemIds.GetRFPCaptureResp, OmiMessage.elemIds.SetRFPCaptureResp, OmiMessage.elemIds.EventRFPCaptureCnf, OmiMessage.attribIds.enable);
                    break;
                }
                case OMP: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemUrl(OmiMessage.elemIds.GetOMPURL, OmiMessage.elemIds.SetOMPURL, OmiMessage.elemIds.GetOMPURLResp, OmiMessage.elemIds.SetOMPURLResp, OmiMessage.elemIds.EventOMPURLCnf);
                    break;
                }
                case DECTPpSettings: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemDECTPpSettings(OmiMessage.elemIds.GetDECTPpSettings, OmiMessage.elemIds.SetDECTPpSettings, OmiMessage.elemIds.GetDECTPpSettingsResp, OmiMessage.elemIds.SetDECTPpSettingsResp, OmiMessage.elemIds.EventDECTPpSettingsCnf);
                    break;
                }
                case AdditionalSettings: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemAdditionalSettings(OmiMessage.elemIds.GetAdditionalSettings, OmiMessage.elemIds.SetAdditionalSettings, OmiMessage.elemIds.GetAdditionalSettingsResp, OmiMessage.elemIds.SetAdditionalSettingsResp, OmiMessage.elemIds.EventAdditionalSettingsCnf);
                    break;
                }
                case RestrictedSubscriptionDuration: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemBool(OmiMessage.elemIds.GetRestrictedSubscriptionDuration, OmiMessage.elemIds.SetRestrictedSubscriptionDuration, OmiMessage.elemIds.GetRestrictedSubscriptionDurationResp, OmiMessage.elemIds.SetRestrictedSubscriptionDurationResp, OmiMessage.elemIds.EventRestrictedSubscriptionDurationCnf, OmiMessage.attribIds.restrictedSubscrDur);
                    break;
                }
                case SecureSIPCertificateServer: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemCertificateServer(OmiMessage.elemIds.GetSecureSIPCertificateServerImport, OmiMessage.elemIds.SetSecureSIPCertificateServerImport, OmiMessage.elemIds.GetSecureSIPCertificateServerImportResp, OmiMessage.elemIds.SetSecureSIPCertificateServerImportResp, OmiMessage.elemIds.EventSecureSIPCertificateServerImportCnf);
                    break;
                }
                case PortRangeSIP: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemPortRangeSIP(OmiMessage.elemIds.GetPortRangeSIP, OmiMessage.elemIds.SetPortRangeSIP, OmiMessage.elemIds.GetPortRangeSIPResp, OmiMessage.elemIds.SetPortRangeSIPResp, OmiMessage.elemIds.EventPortRangeSIPCnf);
                    break;
                }
                case IntercomCallHandlingSIP: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemIntercomCallHandlingSIP(OmiMessage.elemIds.GetIntercomCallHandlingSIP, OmiMessage.elemIds.SetIntercomCallHandlingSIP, OmiMessage.elemIds.GetIntercomCallHandlingSIPResp, OmiMessage.elemIds.SetIntercomCallHandlingSIPResp, OmiMessage.elemIds.EventIntercomCallHandlingSIPCnf);
                    break;
                }
                case SpecialBranding: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemSpecialBranding(OmiMessage.elemIds.GetSpecialBranding, OmiMessage.elemIds.SetSpecialBranding, OmiMessage.elemIds.GetSpecialBrandingResp, OmiMessage.elemIds.SetSpecialBrandingResp, OmiMessage.elemIds.EventSpecialBrandingCnf);
                    break;
                }
                case ConfigUrl: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemUrl(OmiMessage.elemIds.GetConfigURL, OmiMessage.elemIds.SetConfigURL, OmiMessage.elemIds.GetConfigURLResp, OmiMessage.elemIds.SetConfigURLResp, OmiMessage.elemIds.EventConfigURLCnf);
                    break;
                }
                case UsedConfigUrl: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemUrl(OmiMessage.elemIds.GetUsedConfigURL, null, OmiMessage.elemIds.GetUsedConfigURLResp, null, OmiMessage.elemIds.EventUsedConfigURL);
                    break;
                }
                case SystemCredentials: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemSystemCredentials(OmiMessage.elemIds.GetSystemCredentials, OmiMessage.elemIds.SetSystemCredentials, OmiMessage.elemIds.GetSystemCredentialsResp, OmiMessage.elemIds.SetSystemCredentialsResp, OmiMessage.elemIds.EventSystemCredentialsCnf);
                    break;
                }
                case SystemProvUpdTrig: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemSystemProvUpdTrig(OmiMessage.elemIds.GetSystemProvUpdTrig, OmiMessage.elemIds.SetSystemProvUpdTrig, OmiMessage.elemIds.GetSystemProvUpdTrigResp, OmiMessage.elemIds.SetSystemProvUpdTrigResp, OmiMessage.elemIds.EventSystemProvUpdTrigCnf);
                    break;
                }
                case CoreDumpURL: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemUrl(OmiMessage.elemIds.GetCoreDumpURL, OmiMessage.elemIds.SetCoreDumpURL, OmiMessage.elemIds.GetCoreDumpURLResp, OmiMessage.elemIds.SetCoreDumpURLResp, OmiMessage.elemIds.EventCoreDumpURLCnf);
                    break;
                }
                case NTPServer: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemNTPServer(OmiMessage.elemIds.GetNTPServer, OmiMessage.elemIds.SetNTPServer, OmiMessage.elemIds.GetNTPServerResp, OmiMessage.elemIds.SetNTPServerResp, OmiMessage.elemIds.EventNTPServerCnf);
                    break;
                }
                case ParkServerResult: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemString(null, null, null, null, OmiMessage.elemIds.EventPARKFromServerResult, OmiMessage.attribIds.result);
                    break;
                }
                case OmmCertificate: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemCertificate(OmiMessage.elemIds.GetOMMCertificate, OmiMessage.elemIds.SetOMMCertificate, OmiMessage.elemIds.GetOMMCertificateResp, OmiMessage.elemIds.SetOMMCertificateResp, OmiMessage.elemIds.EventOMMCertificateCnf);
                    break;
                }
                case SoftwareImageUrl: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemUrl(OmiMessage.elemIds.GetSoftwareImageURL, OmiMessage.elemIds.SetSoftwareImageURL, OmiMessage.elemIds.GetSoftwareImageURLResp, OmiMessage.elemIds.SetSoftwareImageURLResp, OmiMessage.elemIds.EventSoftwareImageURLCnf);
                    break;
                }
                case PPFirmwareUrl: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemUrl(OmiMessage.elemIds.GetPPFirmwareURL, OmiMessage.elemIds.SetPPFirmwareURL, OmiMessage.elemIds.GetPPFirmwareURLResp, OmiMessage.elemIds.SetPPFirmwareURLResp, OmiMessage.elemIds.EventPPFirmwareURLCnf);
                    break;
                }
                case PreserveUserDeviceRelation: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemBool(OmiMessage.elemIds.GetPreserveUserDeviceRelation, OmiMessage.elemIds.SetPreserveUserDeviceRelation, OmiMessage.elemIds.GetPreserveUserDeviceRelationResp, OmiMessage.elemIds.SetPreserveUserDeviceRelationResp, OmiMessage.elemIds.EventPreserveUserDeviceRelationCnf, OmiMessage.attribIds.enable);
                    break;
                }
                case SecurePROVCertificateServer: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemCertificateServer(OmiMessage.elemIds.GetSecurePROVCertificateServerImport, OmiMessage.elemIds.SetSecurePROVCertificateServerImport, OmiMessage.elemIds.GetSecurePROVCertificateServerImportResp, OmiMessage.elemIds.SetSecurePROVCertificateServerImportResp, OmiMessage.elemIds.EventSecurePROVCertificateServerImportCnf);
                    break;
                }
                case SecureOMMCertificateServer: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemCertificateServer(OmiMessage.elemIds.GetSecureOMMCertificateServerImport, OmiMessage.elemIds.SetSecureOMMCertificateServerImport, OmiMessage.elemIds.GetSecureOMMCertificateServerImportResp, OmiMessage.elemIds.SetSecureOMMCertificateServerImportResp, OmiMessage.elemIds.EventSecureOMMCertificateServerImportCnf);
                    break;
                }
                case RemoteSystemDump: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemRemoteSystemDump(OmiMessage.elemIds.GetRemoteSystemDump, OmiMessage.elemIds.SetRemoteSystemDump, OmiMessage.elemIds.GetRemoteSystemDumpResp, OmiMessage.elemIds.SetRemoteSystemDumpResp, OmiMessage.elemIds.EventRemoteSystemDumpCnf);
                    break;
                }
                case SARI: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemString(OmiMessage.elemIds.GetSARI, OmiMessage.elemIds.SetSARI, OmiMessage.elemIds.GetSARIResp, OmiMessage.elemIds.SetSARIResp, OmiMessage.elemIds.EventSARICnf, OmiMessage.attribIds.sari, OmiMessage.OpenRespAttribType.haveSARI);
                    break;
                }
                case UserDeviceSyncOMM: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemUserDeviceSyncOMM(OmiMessage.elemIds.GetUserDeviceSyncOMM, OmiMessage.elemIds.SetUserDeviceSyncOMM, OmiMessage.elemIds.GetUserDeviceSyncOMMResp, OmiMessage.elemIds.SetUserDeviceSyncOMMResp, OmiMessage.elemIds.EventUserDeviceSyncOMMCnf);
                    break;
                }
                case DECTPowerLimit: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemBool(OmiMessage.elemIds.GetDECTPowerLimit, OmiMessage.elemIds.SetDECTPowerLimit, OmiMessage.elemIds.GetDECTPowerLimitResp, OmiMessage.elemIds.SetDECTPowerLimitResp, OmiMessage.elemIds.EventDECTPowerLimitCnf, OmiMessage.attribIds.enable);
                    break;
                }
                case ClientInfo: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemString(null, null, null, null, OmiMessage.elemIds.EventClientInfo, OmiMessage.attribIds.info);
                    this.dataElems[commonDataItemEnum.ordinal()].fetchAtStart = false;
                    break;
                }
                case MOMControlState: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemString(OmiMessage.elemIds.GetMOMControlState, null, OmiMessage.elemIds.GetMOMControlStateResp, null, OmiMessage.elemIds.EventMOMControlState, OmiMessage.attribIds.momControlState, OmiMessage.OpenRespAttribType.haveMOM);
                    break;
                }
                case Supplicant: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemBool(OmiMessage.elemIds.GetSupplicant, OmiMessage.elemIds.SetSupplicant, OmiMessage.elemIds.GetSupplicantResp, OmiMessage.elemIds.SetSupplicantResp, OmiMessage.elemIds.EventSupplicantCnf, OmiMessage.attribIds.editable);
                    break;
                }
                case SupplicantCertificate: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemCertificate(OmiMessage.elemIds.GetSupplicantCertificate, OmiMessage.elemIds.SetSupplicantCertificate, OmiMessage.elemIds.GetSupplicantCertificateResp, OmiMessage.elemIds.SetSupplicantCertificateResp, OmiMessage.elemIds.EventSupplicantCertificateCnf);
                    break;
                }
                case SupplicantCertificateServer: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemCertificateServer(OmiMessage.elemIds.GetSupplicantCertificateServerImport, OmiMessage.elemIds.SetSupplicantCertificateServerImport, OmiMessage.elemIds.GetSupplicantCertificateServerImportResp, OmiMessage.elemIds.SetSupplicantCertificateServerImportResp, OmiMessage.elemIds.EventSupplicantCertificateServerImportCnf);
                    break;
                }
                case GDPRCompliance: {
                    this.dataElems[commonDataItemEnum.ordinal()] = new CommonDataItemGDPRCompliance(OmiMessage.elemIds.GetGDPRCompliance, OmiMessage.elemIds.SetGDPRCompliance, OmiMessage.elemIds.GetGDPRComplianceResp, OmiMessage.elemIds.SetGDPRComplianceResp, OmiMessage.elemIds.EventGDPRComplianceCnf);
                    break;
                }
            }
        }
    }

    public void removeItemFromList(CommonDataItemEnum commonDataItemEnum) {
        if (commonDataItemEnum != null) {
            this.dataElems[commonDataItemEnum.ordinal()] = null;
        }
    }

    public Object getData(CommonDataItemEnum commonDataItemEnum) throws DataNotAvaillableException {
        if (commonDataItemEnum == CommonDataItemEnum.InitialPARK) {
            return this.initialPARK;
        }
        if (this.dataElems[commonDataItemEnum.ordinal()] != null) {
            if (this.dataElems[commonDataItemEnum.ordinal()].available) {
                return this.dataElems[commonDataItemEnum.ordinal()].getVal();
            }
            this.omiHandler.sendOmiMessage(this.dataElems[commonDataItemEnum.ordinal()].BuildGetReq());
            throw new DataNotAvaillableException();
        }
        return null;
    }

    public void requestTimeZoneDetails(String string) {
        if (this.omiHandler != null) {
            OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetTimeZoneDetails);
            omiMessage.addAttrib(OmiMessage.attribIds.id.name(), string);
            this.omiHandler.sendOmiMessage(omiMessage);
        }
    }

    public void resetTimeZoneDetails() {
        if (this.omiHandler != null) {
            OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.ResetTimeZoneDetails);
            this.omiHandler.sendOmiMessage(omiMessage);
            if (!VersionHandler.versionElementDb.containsElement(VersionTypeEnum.EventTimeZoneList.name())) {
                omiMessage = new OmiMessage(OmiMessage.elemIds.GetTimeZoneList);
                this.omiHandler.sendOmiMessage(omiMessage);
            }
        }
    }

    public void setData(CommonDataItemEnum commonDataItemEnum, Object object) {
        if (this.dataElems[commonDataItemEnum.ordinal()] != null) {
            if (commonDataItemEnum.dataClass == object.getClass()) {
                this.dataElems[commonDataItemEnum.ordinal()].setVal(object);
            } else {
                throw new IllegalArgumentException("wrong argument type");
            }
        }
    }

    private void clearAll() {
        for (int i = 0; i < this.dataElems.length; ++i) {
            if (this.dataElems[i] == null) continue;
            this.dataElems[i].clear();
        }
    }

    private void sendFirstGet() {
        for (int i = 0; i < this.dataElems.length; ++i) {
            if (!this.sendGet(i)) continue;
            return;
        }
    }

    private void sendNextGet(int n) {
        if (n < this.dataElems.length - 1) {
            for (int i = n + 1; i < this.dataElems.length; ++i) {
                if (!this.sendGet(i)) continue;
                return;
            }
        }
        this.actualFetchIdx = this.dataElems.length;
    }

    private boolean sendGet(int n) {
        if (this.dataElems[n] != null && this.dataElems[n].active() && this.dataElems[n].fetchAtStart) {
            this.actualFetchIdx = n;
            OmiMessage omiMessage = this.dataElems[n].BuildGetReq();
            if (omiMessage != null) {
                this.omiHandler.sendOmiMessage(omiMessage);
                return true;
            }
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, String.format("CommonDataHandler - found item without GetReq: '%s'", new Object[]{CommonDataItemEnum.values()[n]}));
        }
        return false;
    }

    public void sendGetReq(CommonDataItemEnum commonDataItemEnum) {
        int n = commonDataItemEnum.ordinal();
        if (this.dataElems[n] != null) {
            this.omiHandler.sendOmiMessage(this.dataElems[n].BuildGetReq());
        }
    }

    private int handleRxMsg(OmiMessage omiMessage) {
        switch (omiMessage.id) {
            case GetPARKResp: 
            case SetPARKResp: 
            case EventPARKCnf: {
                this.initialPARK = omiMessage.getAttribVal(OmiMessage.attribIds.initialPARK.name());
                break;
            }
        }
        EnumSet<CommonDataItemEnum> enumSet = EnumSet.allOf(CommonDataItemEnum.class);
        for (CommonDataItemEnum commonDataItemEnum : enumSet) {
            if (this.dataElems[commonDataItemEnum.ordinal()] == null || !this.dataElems[commonDataItemEnum.ordinal()].processOmiMessage(omiMessage, commonDataItemEnum)) continue;
            return commonDataItemEnum.ordinal();
        }
        return -1;
    }

    public int commitChangesToOmm() {
        int n = 0;
        EnumSet<CommonDataItemEnum> enumSet = EnumSet.allOf(CommonDataItemEnum.class);
        for (CommonDataItemEnum commonDataItemEnum : enumSet) {
            if (!this.commitChangesToOmm(commonDataItemEnum)) continue;
            ++n;
        }
        return n;
    }

    public boolean commitChangesToOmm(CommonDataItemEnum commonDataItemEnum) {
        OmiMessage omiMessage;
        boolean bl = false;
        if (this.dataElems[commonDataItemEnum.ordinal()] != null && this.dataElems[commonDataItemEnum.ordinal()].changed && (omiMessage = this.dataElems[commonDataItemEnum.ordinal()].BuildSetReq()) != null) {
            this.omiHandler.sendOmiMessage(omiMessage);
            bl = true;
        }
        return bl;
    }

    public void registerDataNotificationListener(CommonDataNotificationInterface commonDataNotificationInterface) {
        this.listenerList.add(commonDataNotificationInterface);
    }

    public void deregisterDataNotificationListener(CommonDataNotificationInterface commonDataNotificationInterface) {
        this.listenerList.remove(commonDataNotificationInterface);
    }

    public boolean registerDataNotificationListener(CommonDataItemEnum commonDataItemEnum, CommonDataNotificationInterface commonDataNotificationInterface) {
        if (this.dataElems[commonDataItemEnum.ordinal()] != null) {
            this.dataElems[commonDataItemEnum.ordinal()].registerDataNotificationListener(commonDataNotificationInterface);
            return true;
        }
        return false;
    }

    public boolean deregisterDataNotificationListener(CommonDataItemEnum commonDataItemEnum, CommonDataNotificationInterface commonDataNotificationInterface) {
        if (this.dataElems[commonDataItemEnum.ordinal()] != null) {
            this.dataElems[commonDataItemEnum.ordinal()].deregisterDataNotificationListener(commonDataNotificationInterface);
            return true;
        }
        return false;
    }

    private void GenerateDataNotification(DataNotificationEnum dataNotificationEnum, CommonDataItemEnum commonDataItemEnum) {
        if (this.listenerList.size() != 0) {
            for (CommonDataNotificationInterface commonDataNotificationInterface : this.listenerList) {
                if (commonDataNotificationInterface == null) continue;
                commonDataNotificationInterface.processCommonDataNotification(dataNotificationEnum, commonDataItemEnum);
            }
        }
    }

    private void GenerateErrorNotification(DataNotificationEnum dataNotificationEnum, CommonDataItemEnum commonDataItemEnum, OmiMessage omiMessage) {
        if (this.listenerList.size() != 0) {
            for (CommonDataNotificationInterface commonDataNotificationInterface : this.listenerList) {
                if (commonDataNotificationInterface == null) continue;
                commonDataNotificationInterface.processCommonDataErrorNotification(dataNotificationEnum, commonDataItemEnum, omiMessage);
            }
        }
    }

    private void initCommonDataHandler(OmiManagement omiManagement) {
        this.omiHandler = omiManagement.getOmiHandler();
        omiManagement.registerManagementEventListener(this);
        OmiMessage.elemIds.LimitsResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetSystemNameResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetSystemNameResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetRemoteAccessResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetRemoteAccessResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetEULAConfirmResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetEULAConfirmResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetNetParamsResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetNetParamsResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetPARKResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetPARKResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetDECTEncryptionResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetDECTEncryptionResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetDECTRegDomainResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetDECTRegDomainResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetDECTAuthCodeResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetDECTAuthCodeResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetPPFirmwareUpdateResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetPPFirmwareUpdateResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetWLANRegDomainResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetWLANRegDomainResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetWLANRegDomainListResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetUserDataServerResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetUserDataServerResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetBasicSIPResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetBasicSIPResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetAdvancedSIPResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetAdvancedSIPResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetBackupSIPResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetBackupSIPResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetRTPResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetRTPResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetDTMFResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetDTMFResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetSecureSIPResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetSecureSIPResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventSecureSIPCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetSecureSIPCertificateResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetSecureSIPCertificateResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventSecureSIPCertificateCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetAutoDBBackupResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetAutoDBBackupResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.ManualDBBackupResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.ManualDBRestoreResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetDbTransferStateResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventSystemNameCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventRemoteAccessCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventEULAConfirmCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventNetParamsCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventPARKCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventDECTEncryptionCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventDECTRegDomainCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventDECTAuthCodeCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventPPFirmwareUpdateCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventWLANRegDomainCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventUserDataServerCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventBasicSIPCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventAdvancedSIPCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventBackupSIPCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventRTPCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventDTMFCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventAutoDBBackupCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetTimeZoneResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetTimeZoneListResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventTimeZoneList.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetTimeZoneDetailsResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetTimeZoneResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetTimeZoneDetailsResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventTimeZoneCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventTimeZoneDetailsCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.ResetTimeZoneDetailsResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetIMAResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetIMAResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventIMACnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventDECTPagingAreaCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetDECTPagingAreaSizeResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetDECTPagingAreaSizeResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetSNMPResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetSNMPResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventSNMPCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetFACPrefixResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetFACPrefixResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventFACPrefixCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetFACListResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetFACListResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventFACCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetPublicKeyResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetDevAutoCreateResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetDevAutoCreateResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventDevAutoCreateCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetPPLoginVariantResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetPPLoginVariantResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventPPLoginVariantCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetSyslogServerResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetSyslogServerResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventSyslogServerCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetDECTSubscriptionModeResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetDECTSubscriptionModeResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventDECTSubscriptionMode.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetAutoDBBackupFileNameResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventAutoDBBackupFileNameCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetFlashMemUsageResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetHealthStateResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventHealthState.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetPBXResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetPBXResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventPBXCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetLicenseResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventLicenseCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetLicenseServerListResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetLicenseServerListResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventLicenseServerListCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetRegistrationTrafficShapingResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetRegistrationTrafficShapingResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventRegistrationTrafficShapingCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetSuplServResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetSuplServResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventSuplServCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetConferenceServerSIPResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetConferenceServerSIPResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventConferenceServerSIPCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetSysVoiceboxNumResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetSysVoiceboxNumResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventSysVoiceboxNumCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetUserMonitoringResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetUserMonitoringResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventUserMonitoringCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetPPFirmwareUpdateOverviewResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventPPFirmwareUpdateOverview.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetBluetoothSensitivityResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetBluetoothSensitivityResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventBluetoothSensitivityCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetBluetoothGlobalSettingsResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetBluetoothGlobalSettingsResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventBluetoothGlobalSettingsCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetSysToneSchemeResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventSysToneSchemeCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventDbTransferState.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetRFPCaptureResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetRFPCaptureResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventRFPCaptureCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetOMPURLResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetOMPURLResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventOMPURLCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetDECTPpSettingsResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetDECTPpSettingsResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventDECTPpSettingsCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetAdditionalSettingsResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetAdditionalSettingsResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventAdditionalSettingsCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetSecureSIPCertificateServerImportResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetSecureSIPCertificateServerImportResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventSecureSIPCertificateServerImportCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetRestrictedSubscriptionDurationResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetRestrictedSubscriptionDurationResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventRestrictedSubscriptionDurationCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetSpecialBrandingResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetSpecialBrandingResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventSpecialBrandingCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetPortRangeSIPResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetPortRangeSIPResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventPortRangeSIPCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetIntercomCallHandlingSIPResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetIntercomCallHandlingSIPResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventIntercomCallHandlingSIPCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetConfigURLResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetConfigURLResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventConfigURLCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetUsedConfigURLResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventUsedConfigURL.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetSystemCredentialsResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetSystemCredentialsResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventSystemCredentialsCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetSystemProvUpdTrigResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetSystemProvUpdTrigResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventSystemProvUpdTrigCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetCoreDumpURLResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetCoreDumpURLResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventCoreDumpURLCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetNTPServerResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetNTPServerResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventNTPServerCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventPARKFromServerResult.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetOMMCertificateResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetOMMCertificateResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventOMMCertificateCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetPPFirmwareURLResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetPPFirmwareURLResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventPPFirmwareURLCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetSoftwareImageURLResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetSoftwareImageURLResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventSoftwareImageURLCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetPreserveUserDeviceRelationResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetPreserveUserDeviceRelationResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventPreserveUserDeviceRelationCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetSecurePROVCertificateServerImportResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetSecurePROVCertificateServerImportResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventSecurePROVCertificateServerImportCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetSecureOMMCertificateServerImportResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetSecureOMMCertificateServerImportResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventSecureOMMCertificateServerImportCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetRemoteSystemDumpResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetRemoteSystemDumpResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventRemoteSystemDumpCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetSARIResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetSARIResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventSARICnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetUserDeviceSyncOMMResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetUserDeviceSyncOMMResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventUserDeviceSyncOMMCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetDECTPowerLimitResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetDECTPowerLimitResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventDECTPowerLimitCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetCorporateDirectoryResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetCorporateDirectoryResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventCorporateDirectoryCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetCorporateDirectoryOrderResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetCorporateDirectoryOrderResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventCorporateDirectoryOrderCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventClientInfo.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetMOMControlStateResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventMOMControlState.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetSupplicantResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetSupplicantResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventSupplicantCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetSupplicantCertificateResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetSupplicantCertificateResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventSupplicantCertificateCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetSupplicantCertificateServerImportResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetSupplicantCertificateServerImportResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventSupplicantCertificateServerImportCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetGDPRComplianceResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetGDPRComplianceResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventGDPRComplianceCnf.registerDataNotificationListener(this);
        this.initDataElems();
    }

    public CommonDataHandler(OmiManagement omiManagement, boolean bl) {
        this.fetchDataOnLinkReady = bl;
        this.om = omiManagement;
        this.initCommonDataHandler(this.om);
    }

    public CommonDataHandler(OmiManagement omiManagement) {
        this.om = omiManagement;
        this.initCommonDataHandler(this.om);
    }

    public int sendManualDbBackup(UrlClass urlClass) {
        Object object;
        if (urlClass.password != null) {
            object = OmiRSA.encrypt(urlClass.password);
            if (object != null) {
                char[] cArray = Base64Coder.encode(object);
                urlClass.password = new String(cArray);
            } else {
                urlClass.password = null;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "sendManualDbBackup: Password encryption failed");
            }
        }
        object = new OmiMessage(OmiMessage.elemIds.ManualDBBackup.name());
        urlClass.addUrlToMsg((OmiMessage)object);
        this.omiHandler.sendOmiMessage((OmiMessage)object);
        return 0;
    }

    public int sendManualDbRestore(UrlClass urlClass) {
        Object object;
        if (urlClass.password != null) {
            object = OmiRSA.encrypt(urlClass.password);
            if (object != null) {
                char[] cArray = Base64Coder.encode(object);
                urlClass.password = new String(cArray);
            } else {
                urlClass.password = null;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "sendManualDbRestore: Password encryption failed");
            }
        }
        object = new OmiMessage(OmiMessage.elemIds.ManualDBRestore.name());
        urlClass.addUrlToMsg((OmiMessage)object);
        this.omiHandler.sendOmiMessage((OmiMessage)object);
        return 0;
    }

    public int sendGetDbTransferState(OmiMessage.DbTransferStateSelectType dbTransferStateSelectType) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetDbTransferState.name());
        omiMessage.addAttrib(OmiMessage.attribIds.select.name(), dbTransferStateSelectType.name());
        this.omiHandler.sendOmiMessage(omiMessage);
        return 0;
    }

    public boolean getDataFromOMM() {
        if (this.fetchDataOnLinkReady) {
            return false;
        }
        if (this.actualFetchIdx != CommonDataItemEnum.values().length) {
            return false;
        }
        this.sendFirstGet();
        return true;
    }

    @Override
    public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
        switch (omiManagementEventEnum) {
            case RCV_OPEN_RESP: {
                this.clearAll();
                doClearAll = false;
                break;
            }
            case LINK_READY: {
                if (doClearAll) {
                    this.clearAll();
                    doClearAll = true;
                }
                OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.SystemCnf, null, null);
                OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.AutoDBCnf, null, null);
                OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.DECTSubscriptionMode, null, null);
                OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.FACCnf, null, null);
                OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.PPFirmwareUpdateCnf, null, null);
                OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.PPFirmwareUpdateOverview, null, null);
                OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.ParkServerResult, null, null);
                if (this.om.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUserDeviceSync)) {
                    OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.Roaming, null, null);
                }
                if (!this.fetchDataOnLinkReady) break;
                this.sendFirstGet();
                break;
            }
            case LINK_CLOSED: {
                this.actualFetchIdx = CommonDataItemEnum.values().length;
                break;
            }
        }
    }

    @Override
    public void processOmiMessage(OmiMessage omiMessage) {
        int n = this.handleRxMsg(omiMessage);
        if (n == this.actualFetchIdx) {
            this.sendNextGet(n);
        }
    }

    public void sendSetFAC(FACListClass fACListClass) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.SetFACList);
        OmiMessage omiMessage2 = null;
        for (int i = 0; i < OmiMessage.FACFeatureType.values().length; ++i) {
            if (fACListClass.FACArr[i] == null) continue;
            omiMessage2 = i == 0 ? omiMessage.addSubElement(OmiMessage.elemIds.fac) : omiMessage2.addElement(OmiMessage.elemIds.fac);
            omiMessage2.addAttrib(OmiMessage.FACType.feature.name(), fACListClass.FACArr[i].feature.name());
            omiMessage2.addAttrib(OmiMessage.FACType.enable.name(), fACListClass.FACArr[i].enable);
            if (fACListClass.FACArr[i].fac == null) continue;
            omiMessage2.addAttrib(OmiMessage.FACType.fac.name(), fACListClass.FACArr[i].fac);
        }
        if (this.omiHandler != null) {
            this.omiHandler.sendOmiMessage(omiMessage);
        }
    }

    private Boolean updateNotMandatoryBoolean(OmiMessage omiMessage, String string, Boolean bl) {
        Boolean bl2 = omiMessage.getAttribValBoolNotMandatory(string);
        if (bl2 != null) {
            bl = bl2;
        }
        return bl;
    }

    public void deleteSIPCertificates() {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.SetSecureSIPCertificate.name());
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.trustedCertificates);
        OmiMessage omiMessage3 = omiMessage2.addElement(OmiMessage.elemIds.localCertificates);
        omiMessage3.addElement(OmiMessage.elemIds.privateKeys);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void deleteOmmCertificates() {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.SetOMMCertificate.name());
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.localCertificates);
        omiMessage2.addElement(OmiMessage.elemIds.privateKeys);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void deleteSupplicantCertificates() {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.SetSupplicantCertificate.name());
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.trustedCertificates);
        OmiMessage omiMessage3 = omiMessage2.addElement(OmiMessage.elemIds.localCertificates);
        omiMessage3.addElement(OmiMessage.elemIds.privateKeys);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendActivateRemoteSystemDump() {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.ActivateRemoteSystemDump.name());
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public class DataNotAvaillableException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public DataNotAvaillableException() {
        }

        public DataNotAvaillableException(String string) {
            super(string);
        }
    }

    private class CommonDataItemGDPRCompliance
    extends CommonDataItemClass {
        GDPRComplianceClass val;

        public CommonDataItemGDPRCompliance(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
            this.val = null;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new GDPRComplianceClass();
            this.getAttribValues(omiMessage);
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val == null) {
                this.setDataFromMessage(omiMessage);
            } else {
                this.getAttribValues(omiMessage);
                super.updateDataFromMessage(omiMessage);
            }
        }

        @Override
        public GDPRComplianceClass getVal() {
            return this.val;
        }

        @Override
        public void setVal(Object object) {
            this.setEnable(((GDPRComplianceClass)object).enable);
            this.setText(((GDPRComplianceClass)object).text);
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            omiMessage.addAttrib(OmiMessage.attribIds.enable.name(), this.val.enable);
            if (this.val.text != null) {
                omiMessage.addAttrib(OmiMessage.attribIds.GDPRComplianceText.name(), this.val.text);
            }
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }

        private void getAttribValues(OmiMessage omiMessage) {
            String string;
            Boolean bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.attribIds.enable.name());
            if (bl != null) {
                this.val.enable = bl;
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.attribIds.GDPRComplianceText.name())) != null) {
                this.val.text = string;
            }
        }

        private void setEnable(Boolean bl) {
            this.create();
            if (bl != null && this.val.enable != bl) {
                this.val.enable = bl;
                this.changed = true;
            }
        }

        private void setText(String string) {
            this.create();
            if (string != null && !this.val.text.equals(string)) {
                this.val.text = string;
                this.changed = true;
            }
        }

        private void create() {
            if (this.val == null) {
                this.val = new GDPRComplianceClass();
                this.changed = true;
            }
        }
    }

    public static class GDPRComplianceClass {
        public boolean enable = false;
        public String text = "";

        public GDPRComplianceClass clone() {
            GDPRComplianceClass gDPRComplianceClass = new GDPRComplianceClass();
            gDPRComplianceClass.enable = this.enable;
            gDPRComplianceClass.text = this.text;
            return gDPRComplianceClass;
        }
    }

    private class CommonDataItemNTPServer
    extends CommonDataItemClass {
        public NTPServerCnfClass val;

        public CommonDataItemNTPServer(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
            this.val = null;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new NTPServerCnfClass();
            this.val.srv1 = omiMessage.getAttribVal(OmiMessage.attribIds.ntpServerName1.name());
            this.val.srv2 = omiMessage.getAttribVal(OmiMessage.attribIds.ntpServerName2.name());
            this.val.srv3 = omiMessage.getAttribVal(OmiMessage.attribIds.ntpServerName3.name());
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val == null) {
                this.setDataFromMessage(omiMessage);
            } else {
                String string = omiMessage.getAttribVal(OmiMessage.attribIds.ntpServerName1.name());
                if (string != null) {
                    this.val.srv1 = string;
                }
                if ((string = omiMessage.getAttribVal(OmiMessage.attribIds.ntpServerName2.name())) != null) {
                    this.val.srv2 = string;
                }
                if ((string = omiMessage.getAttribVal(OmiMessage.attribIds.ntpServerName3.name())) != null) {
                    this.val.srv3 = string;
                }
                super.updateDataFromMessage(omiMessage);
            }
        }

        @Override
        public NTPServerCnfClass getVal() {
            return this.val;
        }

        @Override
        public void setVal(Object object) {
            this.create();
            NTPServerCnfClass nTPServerCnfClass = (NTPServerCnfClass)object;
            if (this.val.srv1 != null) {
                if (nTPServerCnfClass.srv1 != null && !this.val.srv1.equals(nTPServerCnfClass.srv1)) {
                    this.val.srv1 = nTPServerCnfClass.srv1;
                    this.changed = true;
                }
            } else if (nTPServerCnfClass.srv1 != null) {
                this.val.srv1 = nTPServerCnfClass.srv1;
                this.changed = true;
            }
            if (this.val.srv2 != null) {
                if (nTPServerCnfClass.srv2 != null && !this.val.srv2.equals(nTPServerCnfClass.srv2)) {
                    this.val.srv2 = nTPServerCnfClass.srv2;
                    this.changed = true;
                }
            } else if (nTPServerCnfClass.srv2 != null) {
                this.val.srv2 = nTPServerCnfClass.srv2;
                this.changed = true;
            }
            if (this.val.srv3 != null) {
                if (nTPServerCnfClass.srv3 != null && !this.val.srv3.equals(nTPServerCnfClass.srv3)) {
                    this.val.srv3 = nTPServerCnfClass.srv3;
                    this.changed = true;
                }
            } else if (nTPServerCnfClass.srv3 != null) {
                this.val.srv3 = nTPServerCnfClass.srv3;
                this.changed = true;
            }
        }

        private void create() {
            if (this.val == null) {
                this.val = new NTPServerCnfClass();
                this.changed = true;
            }
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            if (this.val.srv1 != null) {
                omiMessage.addAttrib(OmiMessage.attribIds.ntpServerName1.name(), this.val.srv1);
            }
            if (this.val.srv2 != null) {
                omiMessage.addAttrib(OmiMessage.attribIds.ntpServerName2.name(), this.val.srv2);
            }
            if (this.val.srv3 != null) {
                omiMessage.addAttrib(OmiMessage.attribIds.ntpServerName3.name(), this.val.srv3);
            }
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }

        public String toString() {
            String string = "";
            if (this.val.srv1 != null) {
                string = string + this.val.srv1;
            }
            if (this.val.srv2 != null) {
                string = string + ", " + this.val.srv2;
            }
            if (this.val.srv3 != null) {
                string = string + ", " + this.val.srv3;
            }
            return string;
        }
    }

    public static class NTPServerCnfClass {
        public String srv1 = null;
        public String srv2 = null;
        public String srv3 = null;
    }

    private class CommonDataItemUserMonitoring
    extends CommonDataItemClass {
        public UserMonitoringClass val;

        public CommonDataItemUserMonitoring(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6, OmiMessage.OpenRespAttribType.haveUMO);
            this.val = null;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new UserMonitoringClass();
            this.val.startupDelay = omiMessage.getAttribValInt(OmiMessage.UserMonitoringType.startupDelay.name());
            this.val.escalationDelay = omiMessage.getAttribValInt(OmiMessage.UserMonitoringType.escalationDelay.name());
            this.val.activityTimeout1 = omiMessage.getAttribValInt(OmiMessage.UserMonitoringType.activityTimeout1.name());
            this.val.activityTimeout2 = omiMessage.getAttribValInt(OmiMessage.UserMonitoringType.activityTimeout2.name());
            this.val.batteryThresholdValue = omiMessage.getAttribValInt(OmiMessage.UserMonitoringType.batteryThresholdValue.name());
            this.val.locatingEscalation = omiMessage.getAttribValBool(OmiMessage.UserMonitoringType.locatingEscalation.name());
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val == null) {
                this.setDataFromMessage(omiMessage);
            } else {
                if (omiMessage.getAttribVal(OmiMessage.UserMonitoringType.startupDelay.name()) != null) {
                    this.val.startupDelay = omiMessage.getAttribValInt(OmiMessage.UserMonitoringType.startupDelay.name());
                }
                if (omiMessage.getAttribVal(OmiMessage.UserMonitoringType.escalationDelay.name()) != null) {
                    this.val.escalationDelay = omiMessage.getAttribValInt(OmiMessage.UserMonitoringType.escalationDelay.name());
                }
                if (omiMessage.getAttribVal(OmiMessage.UserMonitoringType.activityTimeout1.name()) != null) {
                    this.val.activityTimeout1 = omiMessage.getAttribValInt(OmiMessage.UserMonitoringType.activityTimeout1.name());
                }
                if (omiMessage.getAttribVal(OmiMessage.UserMonitoringType.activityTimeout2.name()) != null) {
                    this.val.activityTimeout2 = omiMessage.getAttribValInt(OmiMessage.UserMonitoringType.activityTimeout2.name());
                }
                if (omiMessage.getAttribVal(OmiMessage.UserMonitoringType.batteryThresholdValue.name()) != null) {
                    this.val.batteryThresholdValue = omiMessage.getAttribValInt(OmiMessage.UserMonitoringType.batteryThresholdValue.name());
                }
                if (omiMessage.getAttribVal(OmiMessage.UserMonitoringType.locatingEscalation.name()) != null) {
                    this.val.locatingEscalation = omiMessage.getAttribValBool(OmiMessage.UserMonitoringType.locatingEscalation.name());
                }
                super.updateDataFromMessage(omiMessage);
            }
        }

        @Override
        public UserMonitoringClass getVal() {
            return this.val;
        }

        private void create() {
            if (this.val == null) {
                this.val = new UserMonitoringClass();
                this.changed = true;
            }
        }

        @Override
        public void setVal(Object object) {
            this.setStartupDelay(((UserMonitoringClass)object).startupDelay);
            this.setEscalationDelay(((UserMonitoringClass)object).escalationDelay);
            this.setActivationTimeout1Delay(((UserMonitoringClass)object).activityTimeout1);
            this.setActivationTimeout2Delay(((UserMonitoringClass)object).activityTimeout2);
            this.setBatteryThresholdValue(((UserMonitoringClass)object).batteryThresholdValue);
            this.setLocatingEscalation(((UserMonitoringClass)object).locatingEscalation);
        }

        private void setStartupDelay(int n) {
            this.create();
            if (this.val.startupDelay != n) {
                this.val.startupDelay = n;
                this.changed = true;
            }
        }

        private void setEscalationDelay(int n) {
            this.create();
            if (this.val.escalationDelay != n) {
                this.val.escalationDelay = n;
                this.changed = true;
            }
        }

        private void setActivationTimeout1Delay(int n) {
            this.create();
            if (this.val.activityTimeout1 != n) {
                this.val.activityTimeout1 = n;
                this.changed = true;
            }
        }

        private void setActivationTimeout2Delay(int n) {
            this.create();
            if (this.val.activityTimeout2 != n) {
                this.val.activityTimeout2 = n;
                this.changed = true;
            }
        }

        private void setBatteryThresholdValue(int n) {
            this.create();
            if (this.val.batteryThresholdValue != n) {
                this.val.batteryThresholdValue = n;
                this.changed = true;
            }
        }

        private void setLocatingEscalation(boolean bl) {
            this.create();
            if (this.val.locatingEscalation != bl) {
                this.val.locatingEscalation = bl;
                this.changed = true;
            }
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            omiMessage.addAttrib(OmiMessage.UserMonitoringType.startupDelay.name(), this.val.startupDelay);
            omiMessage.addAttrib(OmiMessage.UserMonitoringType.escalationDelay.name(), this.val.escalationDelay);
            omiMessage.addAttrib(OmiMessage.UserMonitoringType.activityTimeout1.name(), this.val.activityTimeout1);
            omiMessage.addAttrib(OmiMessage.UserMonitoringType.activityTimeout2.name(), this.val.activityTimeout2);
            omiMessage.addAttrib(OmiMessage.UserMonitoringType.batteryThresholdValue.name(), this.val.batteryThresholdValue);
            omiMessage.addAttrib(OmiMessage.UserMonitoringType.locatingEscalation.name(), this.val.locatingEscalation);
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class UserMonitoringClass {
        public int startupDelay;
        public int escalationDelay;
        public int activityTimeout1;
        public int activityTimeout2;
        public int batteryThresholdValue;
        public boolean locatingEscalation;
    }

    private class CommonDataItemLimits
    extends CommonDataItemClass {
        public LimitsClass val;

        public CommonDataItemLimits(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
            this.val = null;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new LimitsClass();
            this.getAttribValues(omiMessage);
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val == null) {
                this.setDataFromMessage(omiMessage);
            } else {
                this.getAttribValues(omiMessage);
                super.updateDataFromMessage(omiMessage);
            }
        }

        @Override
        public LimitsClass getVal() {
            return this.val;
        }

        private void getAttribValues(OmiMessage omiMessage) {
            this.val.axiClients = omiMessage.getAttribVal(OmiMessage.LimitsType.axiClients.name()) != null ? omiMessage.getAttribValInt(OmiMessage.LimitsType.axiClients.name()) : 0;
            this.val.codec = omiMessage.getAttribValInt(OmiMessage.LimitsType.codec.name());
            this.val.ldapServer = omiMessage.getAttribValInt(OmiMessage.LimitsType.ldapServer.name());
            this.val.licLatency = omiMessage.getAttribValInt(OmiMessage.LimitsType.licLatency.name());
            this.val.ppnNum = omiMessage.getAttribValInt(OmiMessage.LimitsType.ppnNum.name());
            this.val.records = omiMessage.getAttribValInt(OmiMessage.LimitsType.records.name());
            this.val.rfpNum = omiMessage.getAttribValInt(OmiMessage.LimitsType.rfpNum.name());
            this.val.site = omiMessage.getAttribValInt(OmiMessage.LimitsType.site.name());
            this.val.ssidWlan = omiMessage.getAttribValInt(OmiMessage.LimitsType.ssidWlan.name());
            this.val.ssidWlanKey = omiMessage.getAttribValInt(OmiMessage.LimitsType.ssidWlanKey.name());
            this.val.ppProfileNum = omiMessage.getAttribValInt(OmiMessage.LimitsType.ppProfileNum.name());
            this.val.certificatNum = omiMessage.getAttribValInt(OmiMessage.LimitsType.certificatNum.name());
            this.val.trigger = omiMessage.getAttribValInt(OmiMessage.LimitsType.trigger.name());
            this.val.urlLen = omiMessage.getAttribValInt(OmiMessage.LimitsType.urlLen.name());
            this.val.userId = omiMessage.getAttribValInt(OmiMessage.LimitsType.userId.name());
            this.val.dnsServer = omiMessage.getAttribValInt(OmiMessage.LimitsType.dnsServer.name());
            this.val.ntpServer = omiMessage.getAttribValInt(OmiMessage.LimitsType.ntpServer.name());
            this.val.wlanClients = omiMessage.getAttribValInt(OmiMessage.LimitsType.wlanClients.name());
            this.val.wlanMacFilter = omiMessage.getAttribValInt(OmiMessage.LimitsType.wlanClients.name());
            this.val.xmlBuiltInAppl = omiMessage.getAttribValInt(OmiMessage.LimitsType.xmlBuiltInAppl.name());
            this.val.bluetoothBeacons = omiMessage.getAttribValInt(OmiMessage.LimitsType.bluetoothBeacons.name());
            this.val.bluetoothNeighbours = omiMessage.getAttribValInt(OmiMessage.LimitsType.bluetoothNeighbours.name());
            this.val.bluetoothRssiValues = omiMessage.getAttribValInt(OmiMessage.LimitsType.bluetoothRssiValues.name());
            this.val.conferenceRooms = omiMessage.getAttribValInt(OmiMessage.LimitsType.conferenceRooms.name());
            this.val.xmlDynAppl = omiMessage.getAttribValInt(OmiMessage.LimitsType.xmlDynAppl.name());
            this.val.xmlCorpDirAppl = omiMessage.getAttribValInt(OmiMessage.LimitsType.xmlCorpDirAppl.name());
            this.val.limitRTT1 = omiMessage.getAttribValInt(OmiMessage.LimitsType.limitRTT1.name());
            this.val.limitRTT2 = omiMessage.getAttribValInt(OmiMessage.LimitsType.limitRTT2.name());
            this.val.limitRTT3 = omiMessage.getAttribValInt(OmiMessage.LimitsType.limitRTT3.name());
            this.val.limitRTT4 = omiMessage.getAttribValInt(OmiMessage.LimitsType.limitRTT4.name());
        }
    }

    public static class LimitsClass {
        public int axiClients;
        public int codec;
        public int ldapServer;
        public int licLatency;
        public int ppnNum;
        public int records;
        public int rfpNum;
        public int site;
        public int ssidWlan;
        public int ssidWlanKey;
        public int ppProfileNum;
        public int certificatNum;
        public int trigger;
        public int urlLen;
        public int userId;
        public int dnsServer;
        public int ntpServer;
        public int wlanClients;
        public int wlanMacFilter;
        public int xmlBuiltInAppl;
        public int bluetoothBeacons;
        public int bluetoothNeighbours;
        public int bluetoothRssiValues;
        public int conferenceRooms;
        public int xmlDynAppl;
        public int xmlCorpDirAppl;
        public int limitRTT1;
        public int limitRTT2;
        public int limitRTT3;
        public int limitRTT4;
    }

    private class CommonDataItemUserDeviceSyncOMM
    extends CommonDataItemClass {
        private UserDeviceSyncOMMClass val;

        public CommonDataItemUserDeviceSyncOMM(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6, OmiMessage.OpenRespAttribType.haveUserDeviceSync);
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new UserDeviceSyncOMMClass();
            this.val.enable = omiMessage.getAttribValBool(OmiMessage.attribIds.enable.name());
            this.val.omm1DomainName = omiMessage.getAttribVal(OmiMessage.attribIds.omm1DomainName.name());
            this.val.omm2DomainName = omiMessage.getAttribVal(OmiMessage.attribIds.omm2DomainName.name());
            this.val.user = omiMessage.getAttribVal(OmiMessage.attribIds.user.name());
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val != null) {
                String string;
                Boolean bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.attribIds.enable.name());
                if (bl != null) {
                    this.val.enable = bl;
                }
                if ((string = omiMessage.getAttribVal(OmiMessage.attribIds.omm1DomainName.name())) != null) {
                    this.val.omm1DomainName = string;
                }
                if ((string = omiMessage.getAttribVal(OmiMessage.attribIds.omm2DomainName.name())) != null) {
                    this.val.omm2DomainName = string;
                }
                if ((string = omiMessage.getAttribVal(OmiMessage.attribIds.user.name())) != null) {
                    this.val.user = string;
                }
                super.updateDataFromMessage(omiMessage);
            } else {
                this.setDataFromMessage(omiMessage);
            }
        }

        @Override
        public UserDeviceSyncOMMClass getVal() {
            return this.val;
        }

        @Override
        public void setVal(Object object) {
            this.setEnable(((UserDeviceSyncOMMClass)object).enable);
            this.setOMM1DomainName(((UserDeviceSyncOMMClass)object).omm1DomainName);
            this.setOMM2DomainName(((UserDeviceSyncOMMClass)object).omm2DomainName);
            this.setUser(((UserDeviceSyncOMMClass)object).user);
            this.setPassword(((UserDeviceSyncOMMClass)object).password);
        }

        private void setEnable(boolean bl) {
            this.create();
            if (this.val.enable != bl) {
                this.val.enable = bl;
                this.changed = true;
            }
        }

        private void setOMM1DomainName(String string) {
            this.create();
            if (string != null) {
                if (this.val.omm1DomainName != null) {
                    if (!this.val.omm1DomainName.equals(string)) {
                        this.val.omm1DomainName = string;
                        this.changed = true;
                    }
                } else {
                    this.val.omm1DomainName = string;
                    this.changed = true;
                }
            }
        }

        private void setOMM2DomainName(String string) {
            this.create();
            if (string != null) {
                if (this.val.omm2DomainName != null) {
                    if (!this.val.omm2DomainName.equals(string)) {
                        this.val.omm2DomainName = string;
                        this.changed = true;
                    }
                } else {
                    this.val.omm2DomainName = string;
                    this.changed = true;
                }
            }
        }

        private void setUser(String string) {
            this.create();
            if (string != null) {
                if (this.val.user != null) {
                    if (!this.val.user.equals(string)) {
                        this.val.user = string;
                        this.changed = true;
                    }
                } else {
                    this.val.user = string;
                    this.changed = true;
                }
            }
        }

        private void setPassword(String string) {
            this.create();
            if (string != null) {
                byte[] byArray = OmiRSA.encrypt(string);
                if (byArray != null) {
                    char[] cArray = Base64Coder.encode(byArray);
                    this.val.password = new String(cArray);
                    this.changed = true;
                } else {
                    this.val.password = null;
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "CommonData system credentials: Password encryption failed");
                }
            } else {
                this.val.password = null;
            }
        }

        private void create() {
            if (this.val == null) {
                this.val = new UserDeviceSyncOMMClass();
                this.changed = true;
            }
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            omiMessage.addAttrib(OmiMessage.attribIds.enable.name(), this.val.enable);
            omiMessage.addAttrib(OmiMessage.attribIds.omm1DomainName.name(), this.val.omm1DomainName);
            omiMessage.addAttrib(OmiMessage.attribIds.omm2DomainName.name(), this.val.omm2DomainName);
            omiMessage.addAttrib(OmiMessage.attribIds.user.name(), this.val.user);
            if (this.val.password != null) {
                omiMessage.addAttrib(OmiMessage.attribIds.password.name(), this.val.password);
            }
            return omiMessage;
        }
    }

    public static class UserDeviceSyncOMMClass {
        public boolean enable = false;
        public String omm1DomainName = null;
        public String omm2DomainName = null;
        public String user = null;
        public String password = null;
    }

    private class CommonDataItemSystemProvUpdTrig
    extends CommonDataItemClass {
        private SystemProvUpdTrigClass val;

        public CommonDataItemSystemProvUpdTrig(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new SystemProvUpdTrigClass();
            this.getAttribValues(omiMessage);
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val == null) {
                this.setDataFromMessage(omiMessage);
            } else {
                this.getAttribValues(omiMessage);
                super.updateDataFromMessage(omiMessage);
            }
        }

        private void getAttribValues(OmiMessage omiMessage) {
            Integer n;
            Boolean bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.attribIds.enable.name());
            if (bl != null) {
                this.val.enable = bl;
            }
            if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.attribIds.hour.name())) != null) {
                this.val.hour = n;
            }
            if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.attribIds.minute.name())) != null) {
                this.val.min = n;
            }
            if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.attribIds.maxDelay.name())) != null) {
                this.val.maxDelay = n;
            }
            if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.attribIds.hourCalculated.name())) != null) {
                this.val.hourCalculated = n;
            }
            if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.attribIds.minuteCalculated.name())) != null) {
                this.val.minCalculated = n;
            }
            if ((bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.attribIds.autoSoftwareCheck.name())) != null) {
                this.val.autoSoftwareCheck = bl;
            }
        }

        @Override
        public SystemProvUpdTrigClass getVal() {
            return this.val;
        }

        @Override
        public void setVal(Object object) {
            this.setEnable(((SystemProvUpdTrigClass)object).enable);
            this.setHour(((SystemProvUpdTrigClass)object).hour);
            this.setMin(((SystemProvUpdTrigClass)object).min);
            this.setMaxDelay(((SystemProvUpdTrigClass)object).maxDelay);
            this.setAutoSoftwareCheck(((SystemProvUpdTrigClass)object).autoSoftwareCheck);
        }

        private void setEnable(Boolean bl) {
            this.create();
            if (bl != null && this.val.enable != bl) {
                this.val.enable = bl;
                this.changed = true;
            }
        }

        private void setHour(Integer n) {
            this.create();
            if (n != null && this.val.hour != n) {
                this.val.hour = n;
                this.changed = true;
            }
        }

        private void setMin(Integer n) {
            this.create();
            if (n != null && this.val.min != n) {
                this.val.min = n;
                this.changed = true;
            }
        }

        private void setMaxDelay(Integer n) {
            this.create();
            if (n != null && this.val.maxDelay != n) {
                this.val.maxDelay = n;
                this.changed = true;
            }
        }

        private void setAutoSoftwareCheck(Boolean bl) {
            this.create();
            if (bl != null && this.val.autoSoftwareCheck != bl) {
                this.val.autoSoftwareCheck = bl;
                this.changed = true;
            }
        }

        private void create() {
            if (this.val == null) {
                this.val = new SystemProvUpdTrigClass();
                this.changed = true;
            }
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            omiMessage.addAttrib(OmiMessage.attribIds.enable.name(), this.val.enable);
            omiMessage.addAttrib(OmiMessage.attribIds.hour.name(), this.val.hour);
            omiMessage.addAttrib(OmiMessage.attribIds.minute.name(), this.val.min);
            omiMessage.addAttrib(OmiMessage.attribIds.maxDelay.name(), this.val.maxDelay);
            omiMessage.addAttrib(OmiMessage.attribIds.autoSoftwareCheck.name(), this.val.autoSoftwareCheck);
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class SystemProvUpdTrigClass {
        public boolean enable = false;
        public int hour = 0;
        public int min = 0;
        public int maxDelay = 0;
        public int hourCalculated = 0;
        public int minCalculated = 0;
        public boolean autoSoftwareCheck = true;
    }

    private class CommonDataItemSystemCredentials
    extends CommonDataItemClass {
        private SystemCredentialsClass val;

        public CommonDataItemSystemCredentials(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new SystemCredentialsClass();
            this.getAttribValues(omiMessage);
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val == null) {
                this.setDataFromMessage(omiMessage);
            } else {
                this.getAttribValues(omiMessage);
                super.updateDataFromMessage(omiMessage);
            }
        }

        private void getAttribValues(OmiMessage omiMessage) {
            String string = omiMessage.getAttribVal(OmiMessage.attribIds.username.name());
            if (string != null) {
                this.val.username = string;
            }
        }

        @Override
        public SystemCredentialsClass getVal() {
            return this.val;
        }

        @Override
        public void setVal(Object object) {
            this.setUsername(((SystemCredentialsClass)object).username);
            this.setPassword(((SystemCredentialsClass)object).password);
        }

        private void setUsername(String string) {
            this.create();
            if (string != null) {
                if (this.val.username != null) {
                    if (!this.val.username.equals(string)) {
                        this.val.username = string;
                        this.changed = true;
                    }
                } else {
                    this.val.username = string;
                    this.changed = true;
                }
            }
        }

        private void setPassword(String string) {
            this.create();
            if (string != null) {
                byte[] byArray = OmiRSA.encrypt(string);
                if (byArray != null) {
                    char[] cArray = Base64Coder.encode(byArray);
                    this.val.password = new String(cArray);
                    this.changed = true;
                } else {
                    this.val.password = null;
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "CommonData system credentials: Password encryption failed");
                }
            } else {
                this.val.password = null;
            }
        }

        private void create() {
            if (this.val == null) {
                this.val = new SystemCredentialsClass();
                this.changed = true;
            }
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            omiMessage.addAttrib(OmiMessage.attribIds.username.name(), this.val.username);
            if (this.val.password != null) {
                omiMessage.addAttrib(OmiMessage.attribIds.password.name(), this.val.password);
            }
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class SystemCredentialsClass {
        public String username;
        public String password;
    }

    private class CommonDataItemIntercomCallHandlingSIP
    extends CommonDataItemClass {
        private IntercomCallHandlingSIPClass val;

        public CommonDataItemIntercomCallHandlingSIP(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new IntercomCallHandlingSIPClass();
            this.getAttribValues(omiMessage);
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val == null) {
                this.setDataFromMessage(omiMessage);
            } else {
                this.getAttribValues(omiMessage);
                super.updateDataFromMessage(omiMessage);
            }
        }

        private void getAttribValues(OmiMessage omiMessage) {
            String string;
            Boolean bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.attribIds.autoAnswer.name());
            if (bl != null) {
                this.val.autoAnswer = bl;
            }
            if ((bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.attribIds.microphoneMute.name())) != null) {
                this.val.microphoneMute = bl;
            }
            if ((bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.attribIds.warningTone.name())) != null) {
                this.val.warningTone = bl;
            }
            if ((bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.attribIds.allowBargeIn.name())) != null) {
                this.val.allowBargeIn = bl;
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.attribIds.pushToTalkPrefix.name())) != null) {
                this.val.pushToTalkPrefix = string;
            }
        }

        @Override
        public IntercomCallHandlingSIPClass getVal() {
            return this.val;
        }

        @Override
        public void setVal(Object object) {
            this.setAutoAnswer(((IntercomCallHandlingSIPClass)object).autoAnswer);
            this.setMicrophoneMute(((IntercomCallHandlingSIPClass)object).microphoneMute);
            this.setWarningTone(((IntercomCallHandlingSIPClass)object).warningTone);
            this.setAllowBargeIn(((IntercomCallHandlingSIPClass)object).allowBargeIn);
            this.setPushToTalkPrefix(((IntercomCallHandlingSIPClass)object).pushToTalkPrefix);
        }

        private void setAutoAnswer(boolean bl) {
            this.create();
            if (this.val.autoAnswer != bl) {
                this.val.autoAnswer = bl;
                this.changed = true;
            }
        }

        private void setMicrophoneMute(boolean bl) {
            this.create();
            if (this.val.microphoneMute != bl) {
                this.val.microphoneMute = bl;
                this.changed = true;
            }
        }

        private void setWarningTone(boolean bl) {
            this.create();
            if (this.val.warningTone != bl) {
                this.val.warningTone = bl;
                this.changed = true;
            }
        }

        private void setAllowBargeIn(boolean bl) {
            this.create();
            if (this.val.allowBargeIn != bl) {
                this.val.allowBargeIn = bl;
                this.changed = true;
            }
        }

        private void setPushToTalkPrefix(String string) {
            this.create();
            if (string != null) {
                if (this.val.pushToTalkPrefix != null) {
                    if (!this.val.pushToTalkPrefix.equals(string)) {
                        this.val.pushToTalkPrefix = string;
                        this.changed = true;
                    }
                } else {
                    this.val.pushToTalkPrefix = string;
                    this.changed = true;
                }
            }
        }

        private void create() {
            if (this.val == null) {
                this.val = new IntercomCallHandlingSIPClass();
                this.changed = true;
            }
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            omiMessage.addAttrib(OmiMessage.attribIds.autoAnswer.name(), this.val.autoAnswer);
            omiMessage.addAttrib(OmiMessage.attribIds.microphoneMute.name(), this.val.microphoneMute);
            omiMessage.addAttrib(OmiMessage.attribIds.warningTone.name(), this.val.warningTone);
            omiMessage.addAttrib(OmiMessage.attribIds.allowBargeIn.name(), this.val.allowBargeIn);
            omiMessage.addAttrib(OmiMessage.attribIds.pushToTalkPrefix.name(), this.val.pushToTalkPrefix);
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class IntercomCallHandlingSIPClass {
        public boolean autoAnswer;
        public boolean microphoneMute;
        public boolean warningTone;
        public boolean allowBargeIn;
        public String pushToTalkPrefix = null;
    }

    private class CommonDataItemPortRangeSIP
    extends CommonDataItemClass {
        private PortRangeSIP val;

        public CommonDataItemPortRangeSIP(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new PortRangeSIP();
            this.getAttribValues(omiMessage);
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val == null) {
                this.setDataFromMessage(omiMessage);
            } else {
                this.getAttribValues(omiMessage);
                super.updateDataFromMessage(omiMessage);
            }
        }

        private void getAttribValues(OmiMessage omiMessage) {
            block6: for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
                switch (omiMessage2.id) {
                    case userUdpTcp: {
                        this.val.portRangeUserUdpTcp.startPort = omiMessage2.getAttribValInt(OmiMessage.attribIds.startPort.name());
                        this.val.portRangeUserUdpTcp.endPort = omiMessage2.getAttribValInt(OmiMessage.attribIds.endPort.name());
                        continue block6;
                    }
                    case userTls: {
                        this.val.portRangeUserTls.startPort = omiMessage2.getAttribValInt(OmiMessage.attribIds.startPort.name());
                        this.val.portRangeUserTls.endPort = omiMessage2.getAttribValInt(OmiMessage.attribIds.endPort.name());
                        continue block6;
                    }
                    case confRoomUdpTcp: {
                        this.val.portRangeConfUdpTcp.startPort = omiMessage2.getAttribValInt(OmiMessage.attribIds.startPort.name());
                        this.val.portRangeConfUdpTcp.endPort = omiMessage2.getAttribValInt(OmiMessage.attribIds.endPort.name());
                        continue block6;
                    }
                    case confRoomTls: {
                        this.val.portRangeConfTls.startPort = omiMessage2.getAttribValInt(OmiMessage.attribIds.startPort.name());
                        this.val.portRangeConfTls.endPort = omiMessage2.getAttribValInt(OmiMessage.attribIds.endPort.name());
                        continue block6;
                    }
                    default: {
                        UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, omiMessage.id.name() + " - invalid subelement received");
                    }
                }
            }
        }

        @Override
        public PortRangeSIP getVal() {
            return this.val;
        }

        @Override
        public void setVal(Object object) {
            this.setPortRangeUserUdpTcp(((PortRangeSIP)object).portRangeUserUdpTcp);
            this.setPortRangeUserTls(((PortRangeSIP)object).portRangeUserTls);
            this.setPortRangeConfUdpTcp(((PortRangeSIP)object).portRangeConfUdpTcp);
            this.setPortRangeConfTls(((PortRangeSIP)object).portRangeConfTls);
        }

        private void setPortRangeUserUdpTcp(SIPPortRangeType sIPPortRangeType) {
            this.create();
            if (this.val.portRangeUserUdpTcp.startPort != sIPPortRangeType.startPort) {
                this.val.portRangeUserUdpTcp.startPort = sIPPortRangeType.startPort;
                this.changed = true;
            }
            if (this.val.portRangeUserUdpTcp.endPort != sIPPortRangeType.endPort) {
                this.val.portRangeUserUdpTcp.endPort = sIPPortRangeType.endPort;
                this.changed = true;
            }
        }

        private void setPortRangeUserTls(SIPPortRangeType sIPPortRangeType) {
            this.create();
            if (this.val.portRangeUserTls.startPort != sIPPortRangeType.startPort) {
                this.val.portRangeUserTls.startPort = sIPPortRangeType.startPort;
                this.changed = true;
            }
            if (this.val.portRangeUserTls.endPort != sIPPortRangeType.endPort) {
                this.val.portRangeUserTls.endPort = sIPPortRangeType.endPort;
                this.changed = true;
            }
        }

        private void setPortRangeConfUdpTcp(SIPPortRangeType sIPPortRangeType) {
            this.create();
            if (this.val.portRangeConfUdpTcp.startPort != sIPPortRangeType.startPort) {
                this.val.portRangeConfUdpTcp.startPort = sIPPortRangeType.startPort;
                this.changed = true;
            }
            if (this.val.portRangeConfUdpTcp.endPort != sIPPortRangeType.endPort) {
                this.val.portRangeConfUdpTcp.endPort = sIPPortRangeType.endPort;
                this.changed = true;
            }
        }

        private void setPortRangeConfTls(SIPPortRangeType sIPPortRangeType) {
            this.create();
            if (this.val.portRangeConfTls.startPort != sIPPortRangeType.startPort) {
                this.val.portRangeConfTls.startPort = sIPPortRangeType.startPort;
                this.changed = true;
            }
            if (this.val.portRangeConfTls.endPort != sIPPortRangeType.endPort) {
                this.val.portRangeConfTls.endPort = sIPPortRangeType.endPort;
                this.changed = true;
            }
        }

        private void create() {
            if (this.val == null) {
                this.val = new PortRangeSIP();
                this.changed = true;
            }
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.userUdpTcp.name());
            omiMessage2.addAttrib(OmiMessage.attribIds.startPort.name(), this.val.portRangeUserUdpTcp.startPort);
            omiMessage2.addAttrib(OmiMessage.attribIds.endPort.name(), this.val.portRangeUserUdpTcp.endPort);
            omiMessage2 = omiMessage2.addElement(OmiMessage.elemIds.userTls.name());
            omiMessage2.addAttrib(OmiMessage.attribIds.startPort.name(), this.val.portRangeUserTls.startPort);
            omiMessage2.addAttrib(OmiMessage.attribIds.endPort.name(), this.val.portRangeUserTls.endPort);
            omiMessage2 = omiMessage2.addElement(OmiMessage.elemIds.confRoomUdpTcp.name());
            omiMessage2.addAttrib(OmiMessage.attribIds.startPort.name(), this.val.portRangeConfUdpTcp.startPort);
            omiMessage2.addAttrib(OmiMessage.attribIds.endPort.name(), this.val.portRangeConfUdpTcp.endPort);
            omiMessage2 = omiMessage2.addElement(OmiMessage.elemIds.confRoomTls.name());
            omiMessage2.addAttrib(OmiMessage.attribIds.startPort.name(), this.val.portRangeConfTls.startPort);
            omiMessage2.addAttrib(OmiMessage.attribIds.endPort.name(), this.val.portRangeConfTls.endPort);
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class PortRangeSIP {
        public SIPPortRangeType portRangeUserUdpTcp = new SIPPortRangeType();
        public SIPPortRangeType portRangeUserTls = new SIPPortRangeType();
        public SIPPortRangeType portRangeConfUdpTcp = new SIPPortRangeType();
        public SIPPortRangeType portRangeConfTls = new SIPPortRangeType();
    }

    public static class SIPPortRangeType {
        public int startPort;
        public int endPort;
    }

    private class CommonDataItemSpecialBranding
    extends CommonDataItemClass {
        private SpecialBrandingClass val;

        public CommonDataItemSpecialBranding(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new SpecialBrandingClass();
            this.val.key = omiMessage.getAttribVal(OmiMessage.attribIds.key.name());
            this.val.url = new UrlClass(omiMessage.getSubElement());
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val != null) {
                OmiMessage omiMessage2;
                String string = omiMessage.getAttribVal(OmiMessage.attribIds.key.name());
                if (string != null) {
                    this.val.key = string;
                }
                if ((omiMessage2 = omiMessage.getSubElement()) != null) {
                    this.val.url.updateFromMsg(omiMessage2);
                }
                super.updateDataFromMessage(omiMessage);
            } else {
                this.setDataFromMessage(omiMessage);
            }
        }

        @Override
        public SpecialBrandingClass getVal() {
            return this.val;
        }

        public void setKey(String string) {
            this.create();
            if (string != null && string.length() > 0) {
                this.val.key = string;
                this.changed = true;
            } else {
                this.val.key = null;
            }
        }

        public void setUrl(UrlClass urlClass) {
            this.create();
            if (urlClass != null) {
                if (this.val.url == null) {
                    this.val.url = new UrlClass();
                }
                this.changed |= this.val.url.updateFromOtherUrl(urlClass);
            }
        }

        @Override
        public void setVal(Object object) {
            this.setKey(((SpecialBrandingClass)object).key);
            this.setUrl(((SpecialBrandingClass)object).url);
        }

        private void create() {
            if (this.val == null) {
                this.val = new SpecialBrandingClass();
                this.changed = true;
            }
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            if (this.val.key != null) {
                omiMessage.addAttrib(OmiMessage.attribIds.key.name(), this.val.key);
            }
            this.val.url.addUrlToMsg(omiMessage);
            return omiMessage;
        }
    }

    public static class SpecialBrandingClass {
        public String key = "";
        public UrlClass url = null;
    }

    private class CommonDataItemRemoteSystemDump
    extends CommonDataItemClass {
        private RemoteSystemDumpClass val;

        public CommonDataItemRemoteSystemDump(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new RemoteSystemDumpClass();
            this.getAttribValues(omiMessage);
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val == null) {
                this.setDataFromMessage(omiMessage);
            } else {
                this.getAttribValues(omiMessage);
                super.updateDataFromMessage(omiMessage);
            }
        }

        @Override
        public RemoteSystemDumpClass getVal() {
            return this.val;
        }

        @Override
        public void setVal(Object object) {
            this.setEnable(((RemoteSystemDumpClass)object).enable);
            this.setHour(((RemoteSystemDumpClass)object).hour);
            this.setMin(((RemoteSystemDumpClass)object).min);
            this.setUrl(((RemoteSystemDumpClass)object).url);
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            omiMessage.addAttrib(OmiMessage.attribIds.enable.name(), this.val.enable);
            omiMessage.addAttrib(OmiMessage.attribIds.hour.name(), this.val.hour);
            omiMessage.addAttrib(OmiMessage.attribIds.minute.name(), this.val.min);
            this.val.url.addUrlToMsg(omiMessage);
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }

        private void getAttribValues(OmiMessage omiMessage) {
            OmiMessage omiMessage2;
            Integer n;
            Boolean bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.attribIds.enable.name());
            if (bl != null) {
                this.val.enable = bl;
            }
            if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.attribIds.hour.name())) != null) {
                this.val.hour = n;
            }
            if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.attribIds.minute.name())) != null) {
                this.val.min = n;
            }
            if ((omiMessage2 = omiMessage.getSubElement()) != null) {
                this.val.url.updateFromMsg(omiMessage2);
            }
        }

        private void setUrl(UrlClass urlClass) {
            this.create();
            if (urlClass != null) {
                if (this.val.url == null) {
                    this.val.url = new UrlClass();
                }
                this.changed |= this.val.url.updateFromOtherUrl(urlClass);
            }
        }

        private void setEnable(boolean bl) {
            this.create();
            if (this.val.enable != bl) {
                this.val.enable = bl;
                this.changed = true;
            }
        }

        private void setHour(Integer n) {
            this.create();
            if (n != null && this.val.hour != n) {
                this.val.hour = n;
                this.changed = true;
            }
        }

        private void setMin(Integer n) {
            this.create();
            if (n != null && this.val.min != n) {
                this.val.min = n;
                this.changed = true;
            }
        }

        private void create() {
            if (this.val == null) {
                this.val = new RemoteSystemDumpClass();
                this.changed = true;
            }
        }
    }

    public static class RemoteSystemDumpClass {
        public boolean enable = false;
        public int hour = 0;
        public int min = 0;
        public UrlClass url = new UrlClass(OmiMessage.ProtType.TFTP, "", "", "", null);
    }

    private class CommonDataItemCertificateServer
    extends CommonDataItemClass {
        private CertificateServer val;

        public CommonDataItemCertificateServer(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new CertificateServer();
            this.getAttribValues(omiMessage);
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val == null) {
                this.setDataFromMessage(omiMessage);
            } else {
                this.getAttribValues(omiMessage);
                super.updateDataFromMessage(omiMessage);
            }
        }

        private void getAttribValues(OmiMessage omiMessage) {
            Boolean bl;
            OmiMessage omiMessage2;
            String string = omiMessage.getAttribVal(OmiMessage.attribIds.trustedCertificates.name());
            if (string != null) {
                this.val.trustedCertsFileName = string;
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.attribIds.localCertificates.name())) != null) {
                this.val.localCertsFileName = string;
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.attribIds.privateKeys.name())) != null) {
                this.val.privateKeyFileName = string;
            }
            if ((omiMessage2 = omiMessage.getSubElement()) != null) {
                this.val.url.updateFromMsg(omiMessage2);
            }
            if ((bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.attribIds.enable.name())) != null) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "SIPCertificateServer: found element 'enable' outside url");
                this.val.url.enable = bl;
            }
        }

        @Override
        public CertificateServer getVal() {
            return this.val;
        }

        @Override
        public void setVal(Object object) {
            this.setTrustedCertsFileName(((CertificateServer)object).trustedCertsFileName);
            this.setLocalCertsFileName(((CertificateServer)object).localCertsFileName);
            this.setPrivateKeyFileName(((CertificateServer)object).privateKeyFileName);
            this.setUrl(((CertificateServer)object).url);
        }

        private void setTrustedCertsFileName(String string) {
            this.create();
            if (string != null) {
                if (this.val.trustedCertsFileName != null) {
                    if (!this.val.trustedCertsFileName.equals(string)) {
                        this.val.trustedCertsFileName = string;
                        this.changed = true;
                    }
                } else {
                    this.val.trustedCertsFileName = string;
                    this.changed = true;
                }
            }
        }

        private void setLocalCertsFileName(String string) {
            this.create();
            if (string != null) {
                if (this.val.localCertsFileName != null) {
                    if (!this.val.localCertsFileName.equals(string)) {
                        this.val.localCertsFileName = string;
                        this.changed = true;
                    }
                } else {
                    this.val.localCertsFileName = string;
                    this.changed = true;
                }
            }
        }

        private void setPrivateKeyFileName(String string) {
            this.create();
            if (string != null) {
                if (this.val.privateKeyFileName != null) {
                    if (!this.val.privateKeyFileName.equals(string)) {
                        this.val.privateKeyFileName = string;
                        this.changed = true;
                    }
                } else {
                    this.val.privateKeyFileName = string;
                    this.changed = true;
                }
            }
        }

        private void setUrl(UrlClass urlClass) {
            if (urlClass != null) {
                if (this.val.url == null) {
                    this.val.url = new UrlClass();
                }
                this.changed |= this.val.url.updateFromOtherUrl(urlClass);
            }
        }

        private void create() {
            if (this.val == null) {
                this.val = new CertificateServer();
                this.changed = true;
            }
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            if (this.val.trustedCertsFileName != null) {
                omiMessage.addAttrib(OmiMessage.attribIds.trustedCertificates.name(), this.val.trustedCertsFileName);
            }
            omiMessage.addAttrib(OmiMessage.attribIds.localCertificates.name(), this.val.localCertsFileName);
            omiMessage.addAttrib(OmiMessage.attribIds.privateKeys.name(), this.val.privateKeyFileName);
            this.val.url.addUrlToMsg(omiMessage);
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class CertificateServer {
        public UrlClass url = new UrlClass(OmiMessage.ProtType.HTTPS, "", "", "", null);
        public String trustedCertsFileName = null;
        public String localCertsFileName = null;
        public String privateKeyFileName = null;
    }

    private class CommonDataItemAdditionalSettings
    extends CommonDataItemClass {
        private AdditionalSettingsClass val;

        public CommonDataItemAdditionalSettings(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new AdditionalSettingsClass();
            this.getAttribValues(omiMessage);
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val == null) {
                this.setDataFromMessage(omiMessage);
            } else {
                this.getAttribValues(omiMessage);
                super.updateDataFromMessage(omiMessage);
            }
        }

        private void getAttribValues(OmiMessage omiMessage) {
            Integer n;
            Boolean bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.attribIds.truncatePpUserName.name());
            if (bl != null) {
                this.val.truncatePpUserName = bl;
            }
            if ((bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.attribIds.useSIPUserName.name())) != null) {
                this.val.useSipUserName = bl;
            }
            if ((bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.attribIds.useSIPUserAuthentication.name())) != null) {
                this.val.useSipUserAuthentication = bl;
            }
            if ((bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.attribIds.revXsiDirLookup.name())) != null) {
                this.val.revXsiDirLookup = bl;
            }
            if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.attribIds.revXsiDirLookupMatchingDigits.name())) != null) {
                this.val.revXsiDirLookupMatchingDigits = n;
            }
            if ((bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.attribIds.ppUIAdministration.name())) != null) {
                this.val.ppUIAdministration = bl;
            }
        }

        @Override
        public AdditionalSettingsClass getVal() {
            return this.val;
        }

        @Override
        public void setVal(Object object) {
            this.setTruncatePpUserName(((AdditionalSettingsClass)object).truncatePpUserName);
            this.setUseSipUserName(((AdditionalSettingsClass)object).useSipUserName);
            this.setUseSipUserAuthentication(((AdditionalSettingsClass)object).useSipUserAuthentication);
            this.setRevXsiDirLookup(((AdditionalSettingsClass)object).revXsiDirLookup);
            this.setRevXsiDirLookupMatchingDigits(((AdditionalSettingsClass)object).revXsiDirLookupMatchingDigits);
            this.setppUIAdministration(((AdditionalSettingsClass)object).ppUIAdministration);
        }

        private void setTruncatePpUserName(Boolean bl) {
            this.create();
            if (bl != null && this.val.truncatePpUserName != bl) {
                this.val.truncatePpUserName = bl;
                this.changed = true;
            }
        }

        private void setUseSipUserName(Boolean bl) {
            this.create();
            if (bl != null && this.val.useSipUserName != bl) {
                this.val.useSipUserName = bl;
                this.changed = true;
            }
        }

        private void setUseSipUserAuthentication(Boolean bl) {
            this.create();
            if (bl != null && this.val.useSipUserAuthentication != bl) {
                this.val.useSipUserAuthentication = bl;
                this.changed = true;
            }
        }

        private void setRevXsiDirLookup(Boolean bl) {
            this.create();
            if (bl != null && this.val.revXsiDirLookup != bl) {
                this.val.revXsiDirLookup = bl;
                this.changed = true;
            }
        }

        private void setRevXsiDirLookupMatchingDigits(Integer n) {
            this.create();
            if (n != null && this.val.revXsiDirLookupMatchingDigits != n) {
                this.val.revXsiDirLookupMatchingDigits = n;
                this.changed = true;
            }
        }

        private void setppUIAdministration(Boolean bl) {
            this.create();
            if (bl != null && this.val.ppUIAdministration != bl) {
                this.val.ppUIAdministration = bl;
                this.changed = true;
            }
        }

        private void create() {
            if (this.val == null) {
                this.val = new AdditionalSettingsClass();
                this.changed = true;
            }
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            omiMessage.addAttrib(OmiMessage.attribIds.truncatePpUserName.name(), this.val.truncatePpUserName);
            omiMessage.addAttrib(OmiMessage.attribIds.useSIPUserName.name(), this.val.useSipUserName);
            omiMessage.addAttrib(OmiMessage.attribIds.useSIPUserAuthentication.name(), this.val.useSipUserAuthentication);
            omiMessage.addAttrib(OmiMessage.attribIds.revXsiDirLookup.name(), this.val.revXsiDirLookup);
            omiMessage.addAttrib(OmiMessage.attribIds.revXsiDirLookupMatchingDigits.name(), this.val.revXsiDirLookupMatchingDigits);
            omiMessage.addAttrib(OmiMessage.attribIds.ppUIAdministration.name(), this.val.ppUIAdministration);
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class AdditionalSettingsClass {
        public boolean truncatePpUserName = false;
        public boolean useSipUserName = false;
        public boolean useSipUserAuthentication = false;
        public boolean revXsiDirLookup = false;
        public int revXsiDirLookupMatchingDigits = 6;
        public boolean ppUIAdministration = false;

        public AdditionalSettingsClass clone() {
            AdditionalSettingsClass additionalSettingsClass = new AdditionalSettingsClass();
            additionalSettingsClass.truncatePpUserName = this.truncatePpUserName;
            additionalSettingsClass.useSipUserName = this.useSipUserName;
            additionalSettingsClass.useSipUserAuthentication = this.useSipUserAuthentication;
            additionalSettingsClass.revXsiDirLookup = this.revXsiDirLookup;
            additionalSettingsClass.revXsiDirLookupMatchingDigits = this.revXsiDirLookupMatchingDigits;
            additionalSettingsClass.ppUIAdministration = this.ppUIAdministration;
            return additionalSettingsClass;
        }
    }

    private class CommonDataItemDECTPpSettings
    extends CommonDataItemClass {
        private DECTPpSettings val;

        public CommonDataItemDECTPpSettings(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new DECTPpSettings();
            this.getAttribValues(omiMessage);
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val == null) {
                this.setDataFromMessage(omiMessage);
            } else {
                this.getAttribValues(omiMessage);
                super.updateDataFromMessage(omiMessage);
            }
        }

        private void getAttribValues(OmiMessage omiMessage) {
            if (omiMessage.getAttribVal(OmiMessage.attribIds.dialByNumberOnly.name()) != null) {
                this.val.dialByNumberOnly = omiMessage.getAttribValBool(OmiMessage.attribIds.dialByNumberOnly.name());
            }
            for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
                String string;
                if (omiMessage2.id == OmiMessage.elemIds.bootTextHeadline) {
                    string = omiMessage2.getAttribVal(OmiMessage.attribIds.text.name());
                    if (string != null) {
                        this.val.bootTextHeadline.text = string;
                    }
                    if (omiMessage2.getAttribVal(OmiMessage.attribIds.enable.name()) == null) continue;
                    this.val.bootTextHeadline.enable = omiMessage2.getAttribValBool(OmiMessage.attribIds.enable.name());
                    continue;
                }
                if (omiMessage2.id != OmiMessage.elemIds.bootTextStartup) continue;
                string = omiMessage2.getAttribVal(OmiMessage.attribIds.text.name());
                if (string != null) {
                    this.val.bootTextStartup.text = string;
                }
                if (omiMessage2.getAttribVal(OmiMessage.attribIds.enable.name()) == null) continue;
                this.val.bootTextStartup.enable = omiMessage2.getAttribValBool(OmiMessage.attribIds.enable.name());
            }
        }

        @Override
        public DECTPpSettings getVal() {
            return this.val;
        }

        @Override
        public void setVal(Object object) {
            this.setDialByNumberOnly(((DECTPpSettings)object).dialByNumberOnly);
            this.setBootTextHeadlineEnable(((DECTPpSettings)object).bootTextHeadline.enable);
            this.setBootTextHeadline(((DECTPpSettings)object).bootTextHeadline.text);
            this.setBootTextStartupEnable(((DECTPpSettings)object).bootTextStartup.enable);
            this.setBootTextStartup(((DECTPpSettings)object).bootTextStartup.text);
        }

        private void setDialByNumberOnly(Boolean bl) {
            this.create();
            if (bl != null && this.val.dialByNumberOnly != bl) {
                this.val.dialByNumberOnly = bl;
                this.changed = true;
            }
        }

        private void setBootTextHeadlineEnable(Boolean bl) {
            this.create();
            if (bl != null && this.val.bootTextHeadline.enable != bl) {
                this.val.bootTextHeadline.enable = bl;
                this.changed = true;
            }
        }

        public void setBootTextHeadline(String string) {
            this.create();
            if (string != null) {
                if (this.val.bootTextHeadline.text != null) {
                    if (!this.val.bootTextHeadline.text.equals(string)) {
                        this.val.bootTextHeadline.text = string;
                        this.changed = true;
                    }
                } else {
                    this.val.bootTextHeadline.text = string;
                    this.changed = true;
                }
            }
        }

        private void setBootTextStartupEnable(Boolean bl) {
            this.create();
            if (bl != null && this.val.bootTextStartup.enable != bl) {
                this.val.bootTextStartup.enable = bl;
                this.changed = true;
            }
        }

        public void setBootTextStartup(String string) {
            this.create();
            if (string != null) {
                if (this.val.bootTextStartup.text != null) {
                    if (!this.val.bootTextStartup.text.equals(string)) {
                        this.val.bootTextStartup.text = string;
                        this.changed = true;
                    }
                } else {
                    this.val.bootTextStartup.text = string;
                    this.changed = true;
                }
            }
        }

        private void create() {
            if (this.val == null) {
                this.val = new DECTPpSettings();
                this.changed = true;
            }
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            omiMessage.addAttrib(OmiMessage.attribIds.dialByNumberOnly.name(), this.val.dialByNumberOnly);
            OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.bootTextHeadline);
            omiMessage2.addAttrib(OmiMessage.attribIds.enable.name(), this.val.bootTextHeadline.enable);
            omiMessage2.addAttrib(OmiMessage.attribIds.text.name(), this.val.bootTextHeadline.text);
            omiMessage2 = omiMessage2.addElement(OmiMessage.elemIds.bootTextStartup);
            omiMessage2.addAttrib(OmiMessage.attribIds.enable.name(), this.val.bootTextStartup.enable);
            omiMessage2.addAttrib(OmiMessage.attribIds.text.name(), this.val.bootTextStartup.text);
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class DECTPpSettings {
        public PPBootText bootTextHeadline = new PPBootText();
        public PPBootText bootTextStartup = new PPBootText();
        public Boolean dialByNumberOnly;
    }

    public static class PPBootText {
        public boolean enable;
        public String text;
    }

    private class CommonDataItemToneSchemeType
    extends CommonDataItemClass {
        OmiMessage.ToneSchemeType val;

        public CommonDataItemToneSchemeType(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
            this.val = OmiMessage.ToneSchemeType.DE;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            String string = omiMessage.getAttribVal(OmiMessage.attribIds.toneScheme.name());
            if (string != null) {
                try {
                    this.val = OmiMessage.ToneSchemeType.valueOf(string);
                }
                catch (Exception exception) {
                    CommonDataHandler.this.om.buildMsgInternalEventException(OmiManagement.ExceptionType.InvalidEnumConst, exception);
                }
            }
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            this.setDataFromMessage(omiMessage);
        }

        public OmiMessage.ToneSchemeType getVal() {
            return this.val;
        }

        @Override
        public void setVal(Object object) {
            if (this.val != (OmiMessage.ToneSchemeType)((Object)object)) {
                this.val = (OmiMessage.ToneSchemeType)((Object)object);
                this.changed = true;
            }
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            omiMessage.addAttrib(OmiMessage.attribIds.toneScheme.name(), this.val.name());
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    private class CommonDataItemBTSensitivity
    extends CommonDataItemClass {
        BlueToothSensitivityClass val;

        public CommonDataItemBTSensitivity(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6, OmiMessage.OpenRespAttribType openRespAttribType) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6, openRespAttribType);
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new BlueToothSensitivityClass();
            this.getAttribValues(omiMessage);
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val == null) {
                this.setDataFromMessage(omiMessage);
            } else {
                this.getAttribValues(omiMessage);
                super.updateDataFromMessage(omiMessage);
            }
        }

        @Override
        public BlueToothSensitivityClass getVal() {
            return this.val;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }

        @Override
        public void setVal(Object object) {
            this.setBTRfpSensTypeCheckpoint(((BlueToothSensitivityClass)object).rfpSens.checkpoint);
            this.setBTRfpSensTypeLow(((BlueToothSensitivityClass)object).rfpSens.low);
            this.setBTRfpSensTypeMedium(((BlueToothSensitivityClass)object).rfpSens.medium);
            this.setBTRfpSensTypeHigh(((BlueToothSensitivityClass)object).rfpSens.high);
            this.setBTPpSensTypeLow(((BlueToothSensitivityClass)object).ppSens.low);
            this.setBTPpSensTypeMedium(((BlueToothSensitivityClass)object).ppSens.medium);
            this.setBTPpSensTypeHigh(((BlueToothSensitivityClass)object).ppSens.high);
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.rfpSens.name());
            omiMessage2.addAttrib(OmiMessage.BTRfpSensTypeType.checkpoint.name(), this.val.rfpSens.checkpoint);
            omiMessage2.addAttrib(OmiMessage.BTRfpSensTypeType.low.name(), this.val.rfpSens.low);
            omiMessage2.addAttrib(OmiMessage.BTRfpSensTypeType.medium.name(), this.val.rfpSens.medium);
            omiMessage2.addAttrib(OmiMessage.BTRfpSensTypeType.high.name(), this.val.rfpSens.high);
            omiMessage2 = omiMessage2.addElement(OmiMessage.elemIds.ppSens.name());
            omiMessage2.addAttrib(OmiMessage.BTPpSensTypeType.low.name(), this.val.ppSens.low);
            omiMessage2.addAttrib(OmiMessage.BTPpSensTypeType.medium.name(), this.val.ppSens.medium);
            omiMessage2.addAttrib(OmiMessage.BTPpSensTypeType.high.name(), this.val.ppSens.high);
            return omiMessage;
        }

        private void getAttribValues(OmiMessage omiMessage) {
            OmiMessage omiMessage2 = omiMessage.getSubElement();
            if (omiMessage2 != null && omiMessage2.id == OmiMessage.elemIds.rfpSens) {
                if (omiMessage2.getAttribVal(OmiMessage.BTRfpSensTypeType.checkpoint.name()) != null) {
                    this.val.rfpSens.checkpoint = omiMessage2.getAttribValInt(OmiMessage.BTRfpSensTypeType.checkpoint.name());
                }
                if (omiMessage2.getAttribVal(OmiMessage.BTRfpSensTypeType.low.name()) != null) {
                    this.val.rfpSens.low = omiMessage2.getAttribValInt(OmiMessage.BTRfpSensTypeType.low.name());
                }
                if (omiMessage2.getAttribVal(OmiMessage.BTRfpSensTypeType.medium.name()) != null) {
                    this.val.rfpSens.medium = omiMessage2.getAttribValInt(OmiMessage.BTRfpSensTypeType.medium.name());
                }
                if (omiMessage2.getAttribVal(OmiMessage.BTRfpSensTypeType.high.name()) != null) {
                    this.val.rfpSens.high = omiMessage2.getAttribValInt(OmiMessage.BTRfpSensTypeType.high.name());
                }
            }
            if ((omiMessage2 = omiMessage2.getNext()) != null && omiMessage2.id == OmiMessage.elemIds.ppSens) {
                if (omiMessage2.getAttribVal(OmiMessage.BTRfpSensTypeType.low.name()) != null) {
                    this.val.ppSens.low = omiMessage2.getAttribValInt(OmiMessage.BTPpSensTypeType.low.name());
                }
                if (omiMessage2.getAttribVal(OmiMessage.BTPpSensTypeType.medium.name()) != null) {
                    this.val.ppSens.medium = omiMessage2.getAttribValInt(OmiMessage.BTPpSensTypeType.medium.name());
                }
                if (omiMessage2.getAttribVal(OmiMessage.BTPpSensTypeType.high.name()) != null) {
                    this.val.ppSens.high = omiMessage2.getAttribValInt(OmiMessage.BTPpSensTypeType.high.name());
                }
            }
        }

        private void create() {
            if (this.val == null) {
                this.val = new BlueToothSensitivityClass();
                this.changed = true;
            }
        }

        private void setBTRfpSensTypeCheckpoint(int n) {
            this.create();
            if (this.val.rfpSens.checkpoint != n) {
                this.val.rfpSens.checkpoint = n;
                this.changed = true;
            }
        }

        private void setBTRfpSensTypeLow(int n) {
            this.create();
            if (this.val.rfpSens.low != n) {
                this.val.rfpSens.low = n;
                this.changed = true;
            }
        }

        private void setBTRfpSensTypeMedium(int n) {
            this.create();
            if (this.val.rfpSens.medium != n) {
                this.val.rfpSens.medium = n;
                this.changed = true;
            }
        }

        private void setBTRfpSensTypeHigh(int n) {
            this.create();
            if (this.val.rfpSens.high != n) {
                this.val.rfpSens.high = n;
                this.changed = true;
            }
        }

        private void setBTPpSensTypeLow(int n) {
            this.create();
            if (this.val.ppSens.low != n) {
                this.val.ppSens.low = n;
                this.changed = true;
            }
        }

        private void setBTPpSensTypeMedium(int n) {
            this.create();
            if (this.val.ppSens.medium != n) {
                this.val.ppSens.medium = n;
                this.changed = true;
            }
        }

        private void setBTPpSensTypeHigh(int n) {
            this.create();
            if (this.val.ppSens.high != n) {
                this.val.ppSens.high = n;
                this.changed = true;
            }
        }
    }

    public static class BlueToothSensitivityClass {
        public static final int BT_SENSITIVITY_INVALID = 0;
        public static final int BT_SENSITIVITY_MAX = -3;
        public static final int BT_SENSITIVITY_MIN = -99;
        public BTRfpSensTypeClass rfpSens = new BTRfpSensTypeClass();
        public BTPpSensTypeClass ppSens = new BTPpSensTypeClass();

        public static class BTPpSensTypeClass {
            public int low = 0;
            public int medium = 0;
            public int high = 0;
        }

        public static class BTRfpSensTypeClass {
            public int checkpoint = 0;
            public int low = 0;
            public int medium = 0;
            public int high = 0;
        }
    }

    private class CommonDataItemPPFirmwareUpdateOverview
    extends CommonDataItemClass {
        PPFirmwareUpdateOverviewClass val;

        public CommonDataItemPPFirmwareUpdateOverview(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
            this.val = null;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new PPFirmwareUpdateOverviewClass();
            this.getAttribValues(omiMessage);
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val == null) {
                this.setDataFromMessage(omiMessage);
            } else {
                this.getAttribValues(omiMessage);
                super.updateDataFromMessage(omiMessage);
            }
        }

        @Override
        public PPFirmwareUpdateOverviewClass getVal() {
            return this.val;
        }

        private void getAttribValues(OmiMessage omiMessage) {
            if (omiMessage.getAttribVal(OmiMessage.PPFirmwareUpdateOverviewType.state.name()) != null) {
                this.val.state = OmiMessage.PPFirmwareUpdateOverviewStateType.valueOf(omiMessage.getAttribVal(OmiMessage.PPFirmwareUpdateOverviewType.state.name()));
            } else if (omiMessage.getAttribVal(OmiMessage.PPFirmwareUpdateOverviewType.status.name()) != null) {
                this.val.state = OmiMessage.PPFirmwareUpdateOverviewStateType.valueOf(omiMessage.getAttribVal(OmiMessage.PPFirmwareUpdateOverviewType.status.name()));
            }
            if (omiMessage.getAttribVal(OmiMessage.PPFirmwareUpdateOverviewType.known.name()) != null) {
                this.val.known = omiMessage.getAttribValInt(OmiMessage.PPFirmwareUpdateOverviewType.known.name());
            }
            if (omiMessage.getAttribVal(OmiMessage.PPFirmwareUpdateOverviewType.ready.name()) != null) {
                this.val.ready = omiMessage.getAttribValInt(OmiMessage.PPFirmwareUpdateOverviewType.ready.name());
            }
            if (omiMessage.getAttribVal(OmiMessage.PPFirmwareUpdateOverviewType.pending.name()) != null) {
                this.val.pending = omiMessage.getAttribValInt(OmiMessage.PPFirmwareUpdateOverviewType.pending.name());
            }
            if (omiMessage.getAttribVal(OmiMessage.PPFirmwareUpdateOverviewType.active.name()) != null) {
                this.val.active = omiMessage.getAttribValInt(OmiMessage.PPFirmwareUpdateOverviewType.active.name());
            }
            if (omiMessage.getAttribVal(OmiMessage.PPFirmwareUpdateOverviewType.barred.name()) != null) {
                this.val.barred = omiMessage.getAttribValInt(OmiMessage.PPFirmwareUpdateOverviewType.barred.name());
            }
            if (omiMessage.getAttribVal(OmiMessage.PPFirmwareUpdateOverviewType.errored.name()) != null) {
                this.val.errored = omiMessage.getAttribValInt(OmiMessage.PPFirmwareUpdateOverviewType.errored.name());
            }
            if (omiMessage.getAttribVal(OmiMessage.PPFirmwareUpdateOverviewType.notReachable.name()) != null) {
                this.val.notReachable = omiMessage.getAttribValInt(OmiMessage.PPFirmwareUpdateOverviewType.notReachable.name());
            }
            if (omiMessage.getAttribVal(OmiMessage.PPFirmwareUpdateOverviewType.detached.name()) != null) {
                this.val.detached = omiMessage.getAttribValInt(OmiMessage.PPFirmwareUpdateOverviewType.detached.name());
            }
            if (omiMessage.getAttribVal(OmiMessage.PPFirmwareUpdateOverviewType.version.name()) != null) {
                this.val.version = omiMessage.getAttribVal(OmiMessage.PPFirmwareUpdateOverviewType.version.name());
            }
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class PPFirmwareUpdateOverviewClass {
        public OmiMessage.PPFirmwareUpdateOverviewStateType state;
        public int known;
        public int ready;
        public int pending;
        public int active;
        public int barred;
        public int errored;
        public int notReachable;
        public int detached;
        public String version;
    }

    private class CommonDataItemPPFirmwareUpdate
    extends CommonDataItemClass {
        public PPFirmwareUpdateClass val;

        public CommonDataItemPPFirmwareUpdate(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
            this.val = null;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new PPFirmwareUpdateClass();
            this.val.enable = omiMessage.getAttribValBool(OmiMessage.attribIds.enable.name());
            this.val.name = omiMessage.getAttribVal(OmiMessage.attribIds.name.name());
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val == null) {
                this.setDataFromMessage(omiMessage);
            } else {
                if (omiMessage.getAttribVal(OmiMessage.attribIds.enable.name()) != null) {
                    this.val.enable = omiMessage.getAttribValBool(OmiMessage.attribIds.enable.name());
                }
                if (omiMessage.getAttribVal(OmiMessage.attribIds.name.name()) != null) {
                    this.val.name = omiMessage.getAttribVal(OmiMessage.attribIds.name.name());
                }
                super.updateDataFromMessage(omiMessage);
            }
        }

        @Override
        public PPFirmwareUpdateClass getVal() {
            return this.val;
        }

        private void create() {
            if (this.val == null) {
                this.val = new PPFirmwareUpdateClass();
                this.changed = true;
            }
        }

        @Override
        public void setVal(Object object) {
            this.setEnable(((PPFirmwareUpdateClass)object).enable);
        }

        private void setEnable(boolean bl) {
            this.create();
            if (this.val.enable != bl) {
                this.val.enable = bl;
                this.changed = true;
            }
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            omiMessage.addAttrib(OmiMessage.attribIds.enable.name(), this.val.enable);
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class PPFirmwareUpdateClass {
        public boolean enable;
        public String name;
    }

    public static class DbTransferStateClass {
        public OmiMessage.DbTransferStateSelectType select = OmiMessage.DbTransferStateSelectType.manualBackup;
        public OmiMessage.DbTransferStateType state = OmiMessage.DbTransferStateType.idle;
        public String error = "";
        public String lastupd = "";
        public String url = "";
    }

    private class CommonDataItemDbTransferState
    extends CommonDataItemClass {
        public DbTransferStateClass val;

        public CommonDataItemDbTransferState(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
            this.val = null;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new DbTransferStateClass();
            String string = omiMessage.getAttribVal(OmiMessage.attribIds.select.name());
            if (string != null) {
                try {
                    this.val.select = OmiMessage.DbTransferStateSelectType.valueOf(string);
                    this.val.state = OmiMessage.DbTransferStateType.valueOf(omiMessage.getAttribVal(OmiMessage.attribIds.state.name()));
                    this.val.error = omiMessage.getAttribVal(OmiMessage.attribIds.error.name());
                    this.val.lastupd = omiMessage.getAttribVal(OmiMessage.attribIds.lastupd.name());
                    this.val.url = omiMessage.getAttribVal(OmiMessage.attribIds.url.name());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            this.setDataFromMessage(omiMessage);
        }

        @Override
        public DbTransferStateClass getVal() {
            return this.val;
        }

        @Override
        public void setVal(Object object) {
        }

        @Override
        public OmiMessage BuildSetReq() {
            return null;
        }

        @Override
        public void clear() {
            this.val = null;
            super.clear();
        }
    }

    private class CommonDataItemConferenceServerSIP
    extends CommonDataItemClass {
        public ConferenceServerSIPClass val;

        public CommonDataItemConferenceServerSIP(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6, OmiMessage.OpenRespAttribType.haveConference);
            this.val = null;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new ConferenceServerSIPClass();
            if (omiMessage.getAttribVal(OmiMessage.ConferenceServerSIPType.conferenceServerType.name()) != null) {
                this.val.type = OmiMessage.ConferenceServerSIPTypeType.valueOf(omiMessage.getAttribVal(OmiMessage.ConferenceServerSIPType.conferenceServerType.name()));
            }
            this.val.uri = omiMessage.getAttribVal(OmiMessage.ConferenceServerSIPType.conferenceServerURI.name());
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val == null) {
                this.setDataFromMessage(omiMessage);
            } else {
                if (omiMessage.getAttribVal(OmiMessage.ConferenceServerSIPType.conferenceServerType.name()) != null) {
                    this.val.type = OmiMessage.ConferenceServerSIPTypeType.valueOf(omiMessage.getAttribVal(OmiMessage.ConferenceServerSIPType.conferenceServerType.name()));
                }
                if (omiMessage.getAttribVal(OmiMessage.ConferenceServerSIPType.conferenceServerURI.name()) != null) {
                    this.val.uri = omiMessage.getAttribVal(OmiMessage.ConferenceServerSIPType.conferenceServerURI.name());
                }
                super.updateDataFromMessage(omiMessage);
            }
        }

        @Override
        public ConferenceServerSIPClass getVal() {
            return this.val;
        }

        private void create() {
            if (this.val == null) {
                this.val = new ConferenceServerSIPClass();
                this.changed = true;
            }
        }

        public void setConferenceServerUri(String string) {
            this.create();
            if (this.val.uri != string) {
                this.val.uri = string;
                this.changed = true;
            }
        }

        public void setConferenceServerType(OmiMessage.ConferenceServerSIPTypeType conferenceServerSIPTypeType) {
            this.create();
            if (this.val.type != conferenceServerSIPTypeType) {
                this.val.type = conferenceServerSIPTypeType;
                this.changed = true;
            }
        }

        @Override
        public void setVal(Object object) {
            this.setConferenceServerType(((ConferenceServerSIPClass)object).type);
            this.setConferenceServerUri(((ConferenceServerSIPClass)object).uri);
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            omiMessage.addAttrib(OmiMessage.ConferenceServerSIPType.conferenceServerType.name(), this.val.type.name());
            omiMessage.addAttrib(OmiMessage.ConferenceServerSIPType.conferenceServerURI.name(), this.val.uri);
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class ConferenceServerSIPClass {
        public OmiMessage.ConferenceServerSIPTypeType type = null;
        public String uri = null;
    }

    private class CommonDataItemSuplServ
    extends CommonDataItemClass {
        public SuplServClass val;

        public CommonDataItemSuplServ(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
            this.val = null;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new SuplServClass();
            this.val.callForwDiv = omiMessage.getAttribValBool(OmiMessage.SuplServType.callForwDiv.name());
            this.val.locLineHndlg = omiMessage.getAttribValBool(OmiMessage.SuplServType.locLineHndlg.name());
            this.val.callTransferByHook = omiMessage.getAttribValBool(OmiMessage.SuplServType.callTransferByHook.name());
            this.val.uriSeparator = omiMessage.getAttribValBool(OmiMessage.SuplServType.uriSeparator.name());
            this.val.reRegisterAfterFailOver = omiMessage.getAttribValBool(OmiMessage.SuplServType.reRegisterAfterFailOver.name());
            this.val.ringingOnHold = omiMessage.getAttribValBool(OmiMessage.SuplServType.ringingOnHold.name());
            this.val.transferByHook6xxd = omiMessage.getAttribValBool(OmiMessage.SuplServType.transferByHook6xxd.name());
            this.val.callRejectOnSilentCharging = omiMessage.getAttribValBool(OmiMessage.SuplServType.callRejectOnSilentCharging.name());
            this.val.releaseInfoTimerActiveCall = omiMessage.getAttribValInt(OmiMessage.SuplServType.releaseInfoTimerActiveCall.name());
            this.val.releaseInfoTimerHoldCall = omiMessage.getAttribValInt(OmiMessage.SuplServType.releaseInfoTimerHoldCall.name());
            this.val.releaseInfoTimerFailedCall = omiMessage.getAttribValInt(OmiMessage.SuplServType.releaseInfoTimerFailedCall.name());
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val == null) {
                this.setDataFromMessage(omiMessage);
            } else {
                this.val.callForwDiv = CommonDataHandler.this.updateNotMandatoryBoolean(omiMessage, OmiMessage.SuplServType.callForwDiv.name(), this.val.callForwDiv);
                this.val.locLineHndlg = CommonDataHandler.this.updateNotMandatoryBoolean(omiMessage, OmiMessage.SuplServType.locLineHndlg.name(), this.val.locLineHndlg);
                this.val.callTransferByHook = CommonDataHandler.this.updateNotMandatoryBoolean(omiMessage, OmiMessage.SuplServType.callTransferByHook.name(), this.val.callTransferByHook);
                this.val.uriSeparator = CommonDataHandler.this.updateNotMandatoryBoolean(omiMessage, OmiMessage.SuplServType.uriSeparator.name(), this.val.uriSeparator);
                this.val.reRegisterAfterFailOver = CommonDataHandler.this.updateNotMandatoryBoolean(omiMessage, OmiMessage.SuplServType.reRegisterAfterFailOver.name(), this.val.reRegisterAfterFailOver);
                this.val.ringingOnHold = CommonDataHandler.this.updateNotMandatoryBoolean(omiMessage, OmiMessage.SuplServType.ringingOnHold.name(), this.val.ringingOnHold);
                this.val.transferByHook6xxd = CommonDataHandler.this.updateNotMandatoryBoolean(omiMessage, OmiMessage.SuplServType.transferByHook6xxd.name(), this.val.transferByHook6xxd);
                this.val.callRejectOnSilentCharging = CommonDataHandler.this.updateNotMandatoryBoolean(omiMessage, OmiMessage.SuplServType.callRejectOnSilentCharging.name(), this.val.callRejectOnSilentCharging);
                if (omiMessage.getAttribVal(OmiMessage.SuplServType.releaseInfoTimerActiveCall.name()) != null) {
                    this.val.releaseInfoTimerActiveCall = omiMessage.getAttribValInt(OmiMessage.SuplServType.releaseInfoTimerActiveCall.name());
                }
                if (omiMessage.getAttribVal(OmiMessage.SuplServType.releaseInfoTimerHoldCall.name()) != null) {
                    this.val.releaseInfoTimerHoldCall = omiMessage.getAttribValInt(OmiMessage.SuplServType.releaseInfoTimerHoldCall.name());
                }
                if (omiMessage.getAttribVal(OmiMessage.SuplServType.releaseInfoTimerFailedCall.name()) != null) {
                    this.val.releaseInfoTimerFailedCall = omiMessage.getAttribValInt(OmiMessage.SuplServType.releaseInfoTimerFailedCall.name());
                }
                super.updateDataFromMessage(omiMessage);
            }
        }

        @Override
        public SuplServClass getVal() {
            return this.val;
        }

        private void create() {
            if (this.val == null) {
                this.val = new SuplServClass();
                this.changed = true;
            }
        }

        public void setCallForwDiv(boolean bl) {
            this.create();
            if (this.val.callForwDiv != bl) {
                this.val.callForwDiv = bl;
                this.changed = true;
            }
        }

        public void setLocalLineHndlg(boolean bl) {
            this.create();
            if (this.val.locLineHndlg != bl) {
                this.val.locLineHndlg = bl;
                this.changed = true;
            }
        }

        public void setCallTransferByHook(boolean bl) {
            this.create();
            if (this.val.callTransferByHook != bl) {
                this.val.callTransferByHook = bl;
                this.changed = true;
            }
        }

        public void setUriSeparator(boolean bl) {
            this.create();
            if (this.val.uriSeparator != bl) {
                this.val.uriSeparator = bl;
                this.changed = true;
            }
        }

        public void setReRegisterAfterFailOver(boolean bl) {
            this.create();
            if (this.val.reRegisterAfterFailOver != bl) {
                this.val.reRegisterAfterFailOver = bl;
                this.changed = true;
            }
        }

        public void setRingingOnHold(boolean bl) {
            this.create();
            if (this.val.ringingOnHold != bl) {
                this.val.ringingOnHold = bl;
                this.changed = true;
            }
        }

        public void setTransferByHook6xxd(boolean bl) {
            this.create();
            if (this.val.transferByHook6xxd != bl) {
                this.val.transferByHook6xxd = bl;
                this.changed = true;
            }
        }

        public void setCallRejectOnSilentCharging(boolean bl) {
            this.create();
            if (this.val.callRejectOnSilentCharging != bl) {
                this.val.callRejectOnSilentCharging = bl;
                this.changed = true;
            }
        }

        public void setReleaseInfoTimerActiveCall(int n) {
            this.create();
            if (this.val.releaseInfoTimerActiveCall != n) {
                this.val.releaseInfoTimerActiveCall = n;
                this.changed = true;
            }
        }

        public void setReleaseInfoTimerHoldCall(int n) {
            this.create();
            if (this.val.releaseInfoTimerHoldCall != n) {
                this.val.releaseInfoTimerHoldCall = n;
                this.changed = true;
            }
        }

        public void setReleaseInfoTimerFailedCall(int n) {
            this.create();
            if (this.val.releaseInfoTimerFailedCall != n) {
                this.val.releaseInfoTimerFailedCall = n;
                this.changed = true;
            }
        }

        @Override
        public void setVal(Object object) {
            this.setCallForwDiv(((SuplServClass)object).callForwDiv);
            this.setLocalLineHndlg(((SuplServClass)object).locLineHndlg);
            this.setCallTransferByHook(((SuplServClass)object).callTransferByHook);
            this.setUriSeparator(((SuplServClass)object).uriSeparator);
            this.setReRegisterAfterFailOver(((SuplServClass)object).reRegisterAfterFailOver);
            this.setRingingOnHold(((SuplServClass)object).ringingOnHold);
            this.setTransferByHook6xxd(((SuplServClass)object).transferByHook6xxd);
            this.setCallRejectOnSilentCharging(((SuplServClass)object).callRejectOnSilentCharging);
            this.setReleaseInfoTimerActiveCall(((SuplServClass)object).releaseInfoTimerActiveCall);
            this.setReleaseInfoTimerHoldCall(((SuplServClass)object).releaseInfoTimerHoldCall);
            this.setReleaseInfoTimerFailedCall(((SuplServClass)object).releaseInfoTimerFailedCall);
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            omiMessage.addAttrib(OmiMessage.SuplServType.callForwDiv.name(), this.val.callForwDiv);
            omiMessage.addAttrib(OmiMessage.SuplServType.locLineHndlg.name(), this.val.locLineHndlg);
            omiMessage.addAttrib(OmiMessage.SuplServType.callTransferByHook.name(), this.val.callTransferByHook);
            omiMessage.addAttrib(OmiMessage.SuplServType.uriSeparator.name(), this.val.uriSeparator);
            omiMessage.addAttrib(OmiMessage.SuplServType.reRegisterAfterFailOver.name(), this.val.reRegisterAfterFailOver);
            omiMessage.addAttrib(OmiMessage.SuplServType.ringingOnHold.name(), this.val.ringingOnHold);
            omiMessage.addAttrib(OmiMessage.SuplServType.transferByHook6xxd.name(), this.val.transferByHook6xxd);
            omiMessage.addAttrib(OmiMessage.SuplServType.callRejectOnSilentCharging.name(), this.val.callRejectOnSilentCharging);
            omiMessage.addAttrib(OmiMessage.SuplServType.releaseInfoTimerActiveCall.name(), this.val.releaseInfoTimerActiveCall);
            omiMessage.addAttrib(OmiMessage.SuplServType.releaseInfoTimerHoldCall.name(), this.val.releaseInfoTimerHoldCall);
            omiMessage.addAttrib(OmiMessage.SuplServType.releaseInfoTimerFailedCall.name(), this.val.releaseInfoTimerFailedCall);
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class SuplServClass {
        public boolean callForwDiv = true;
        public boolean locLineHndlg = true;
        public boolean callTransferByHook = false;
        public boolean uriSeparator = false;
        public boolean reRegisterAfterFailOver = false;
        public boolean ringingOnHold = true;
        public boolean transferByHook6xxd = true;
        public boolean callRejectOnSilentCharging = false;
        public int releaseInfoTimerActiveCall = 5;
        public int releaseInfoTimerHoldCall = 5;
        public int releaseInfoTimerFailedCall = 5;
    }

    private class CommonDataItemRegTrafficShape
    extends CommonDataItemClass {
        public RegTrafficShapeClass val;

        public CommonDataItemRegTrafficShape(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
            this.val = null;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new RegTrafficShapeClass();
            this.val.maxRegistrations = omiMessage.getAttribValInt(OmiMessage.RegistrationTrafficShapingType.maxRegistrations.name());
            this.val.timeout = omiMessage.getAttribValInt(OmiMessage.RegistrationTrafficShapingType.timeout.name());
            this.val.spreadRegRenew = omiMessage.getAttribValBool(OmiMessage.RegistrationTrafficShapingType.spreadRegRenew.name());
            this.val.renewalTimer = omiMessage.getAttribValInt(OmiMessage.RegistrationTrafficShapingType.renewalTimer.name());
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val == null) {
                this.setDataFromMessage(omiMessage);
            } else {
                Integer n;
                Boolean bl;
                if (omiMessage.getAttribVal(OmiMessage.RegistrationTrafficShapingType.maxRegistrations.name()) != null) {
                    this.val.maxRegistrations = omiMessage.getAttribValInt(OmiMessage.RegistrationTrafficShapingType.maxRegistrations.name());
                }
                if (omiMessage.getAttribVal(OmiMessage.RegistrationTrafficShapingType.timeout.name()) != null) {
                    this.val.timeout = omiMessage.getAttribValInt(OmiMessage.RegistrationTrafficShapingType.timeout.name());
                }
                if ((bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.RegistrationTrafficShapingType.spreadRegRenew.name())) != null) {
                    this.val.spreadRegRenew = bl;
                }
                if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.RegistrationTrafficShapingType.renewalTimer.name())) != null) {
                    this.val.renewalTimer = n;
                }
                super.updateDataFromMessage(omiMessage);
            }
        }

        @Override
        public RegTrafficShapeClass getVal() {
            return this.val;
        }

        private void create() {
            if (this.val == null) {
                this.val = new RegTrafficShapeClass();
                this.changed = true;
            }
        }

        public void setMaxRegistrations(int n) {
            this.create();
            if (this.val.maxRegistrations != n) {
                this.val.maxRegistrations = n;
                this.changed = true;
            }
        }

        public void setTimeout(int n) {
            this.create();
            if (this.val.timeout != n) {
                this.val.timeout = n;
                this.changed = true;
            }
        }

        public void setSpreadRegRenew(boolean bl) {
            this.create();
            if (this.val.spreadRegRenew != bl) {
                this.val.spreadRegRenew = bl;
                this.changed = true;
            }
        }

        public void setRenewalTimer(int n) {
            this.create();
            if (this.val.renewalTimer != n) {
                this.val.renewalTimer = n;
                this.changed = true;
            }
        }

        @Override
        public void setVal(Object object) {
            this.setMaxRegistrations(((RegTrafficShapeClass)object).maxRegistrations);
            this.setTimeout(((RegTrafficShapeClass)object).timeout);
            this.setSpreadRegRenew(((RegTrafficShapeClass)object).spreadRegRenew);
            this.setRenewalTimer(((RegTrafficShapeClass)object).renewalTimer);
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            omiMessage.addAttrib(OmiMessage.RegistrationTrafficShapingType.maxRegistrations.name(), this.val.maxRegistrations);
            omiMessage.addAttrib(OmiMessage.RegistrationTrafficShapingType.timeout.name(), this.val.timeout);
            omiMessage.addAttrib(OmiMessage.RegistrationTrafficShapingType.spreadRegRenew.name(), this.val.spreadRegRenew);
            if (!this.val.spreadRegRenew) {
                omiMessage.addAttrib(OmiMessage.RegistrationTrafficShapingType.renewalTimer.name(), this.val.renewalTimer);
            }
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class RegTrafficShapeClass {
        public static final int RENEWAL_TIMER_MAX = Integer.MAX_VALUE;
        public int maxRegistrations;
        public int timeout;
        public boolean spreadRegRenew;
        public int renewalTimer;
    }

    private class CommonDataItemLicenseServer
    extends CommonDataItemClass {
        public LicenseServerClass val;

        public CommonDataItemLicenseServer(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
            this.val = null;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = this.createNewLicenseServerClass();
            this.addLicenseServer(omiMessage);
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val == null) {
                this.val = this.createNewLicenseServerClass();
            }
            this.addLicenseServer(omiMessage);
            super.updateDataFromMessage(omiMessage);
        }

        private LicenseServerClass createNewLicenseServerClass() {
            LicenseServerClass licenseServerClass = new LicenseServerClass();
            for (int i = 0; i < 3; ++i) {
                licenseServerClass.licenseServerList[i] = new LicenseServerData();
            }
            return licenseServerClass;
        }

        private void addLicenseServer(OmiMessage omiMessage) {
            String string;
            Boolean bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.LicenseServerListType.serverActive.name());
            if (bl != null) {
                this.val.serverActive = bl;
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.LicenseServerListType.installationId.name())) != null) {
                this.val.installationId = omiMessage.getAttribValIntNotMandatory(OmiMessage.LicenseServerListType.installationId.name());
            }
            block5: for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
                switch (omiMessage2.id) {
                    case licenseServer1: {
                        this.getLicenseServerData(omiMessage2, 0);
                        continue block5;
                    }
                    case licenseServer2: {
                        this.getLicenseServerData(omiMessage2, 1);
                        continue block5;
                    }
                    case licenseServer3: {
                        this.getLicenseServerData(omiMessage2, 2);
                        continue block5;
                    }
                }
            }
        }

        private void getLicenseServerData(OmiMessage omiMessage, int n) {
            Integer n2;
            String string = omiMessage.getAttribVal(OmiMessage.LicenseServerType.server.name());
            if (string != null) {
                this.val.licenseServerList[n].server = string;
            }
            if ((n2 = omiMessage.getAttribValIntNotMandatory(OmiMessage.LicenseServerType.port.name())) != null) {
                this.val.licenseServerList[n].port = n2;
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.LicenseServerType.serverStandby.name())) != null) {
                this.val.licenseServerList[n].serverStandby = string;
            }
            if ((n2 = omiMessage.getAttribValIntNotMandatory(OmiMessage.LicenseServerType.portStandby.name())) != null) {
                this.val.licenseServerList[n].portStandby = n2;
            }
        }

        @Override
        public LicenseServerClass getVal() {
            return this.val;
        }

        private void create() {
            if (this.val == null) {
                this.val = new LicenseServerClass();
                this.changed = true;
            }
        }

        @Override
        public void setVal(Object object) {
            if (object.getClass() != LicenseServerClass.class) {
                throw new IllegalArgumentException("Wrong argument type");
            }
            this.setServerActive(((LicenseServerClass)object).serverActive);
            this.setInstallationId(((LicenseServerClass)object).installationId);
            for (int i = 0; i < 3; ++i) {
                this.setServer(((LicenseServerClass)object).licenseServerList[i].server, i);
                this.setPort(((LicenseServerClass)object).licenseServerList[i].port, i);
                this.setServerStandby(((LicenseServerClass)object).licenseServerList[i].serverStandby, i);
                this.setPortStandby(((LicenseServerClass)object).licenseServerList[i].portStandby, i);
            }
        }

        private void setServerActive(boolean bl) {
            this.create();
            if (this.val.serverActive != bl) {
                this.val.serverActive = bl;
                this.changed = true;
            }
        }

        private void setInstallationId(int n) {
            this.create();
            if (this.val.installationId != n) {
                this.val.installationId = n;
                this.changed = true;
            }
        }

        public void setServer(String string, int n) {
            this.create();
            if (this.val.licenseServerList[n].server == null) {
                this.val.licenseServerList[n].server = string;
                this.changed = true;
            } else if (!this.val.licenseServerList[n].server.equals(string)) {
                this.val.licenseServerList[n].server = string;
                this.changed = true;
            }
        }

        public void setPort(int n, int n2) {
            this.create();
            if (this.val.licenseServerList[n2].port != n) {
                this.val.licenseServerList[n2].port = n;
                this.changed = true;
            }
        }

        public void setServerStandby(String string, int n) {
            this.create();
            if (this.val.licenseServerList[n].serverStandby == null) {
                this.val.licenseServerList[n].serverStandby = string;
                this.changed = true;
            } else if (!this.val.licenseServerList[n].serverStandby.equals(string)) {
                this.val.licenseServerList[n].serverStandby = string;
                this.changed = true;
            }
        }

        public void setPortStandby(int n, int n2) {
            this.create();
            if (this.val.licenseServerList[n2].portStandby != n) {
                this.val.licenseServerList[n2].portStandby = n;
                this.changed = true;
            }
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            omiMessage.addAttrib(OmiMessage.LicenseServerListType.serverActive.name(), this.val.serverActive);
            omiMessage.addAttrib(OmiMessage.LicenseServerListType.installationId.name(), this.val.installationId);
            OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.licenseServer1.name());
            omiMessage2.addAttrib(OmiMessage.LicenseServerType.server.name(), this.val.licenseServerList[0].server);
            omiMessage2.addAttrib(OmiMessage.LicenseServerType.port.name(), this.val.licenseServerList[0].port);
            omiMessage2.addAttrib(OmiMessage.LicenseServerType.serverStandby.name(), this.val.licenseServerList[0].serverStandby);
            omiMessage2.addAttrib(OmiMessage.LicenseServerType.portStandby.name(), this.val.licenseServerList[0].portStandby);
            omiMessage2 = omiMessage2.addElement(OmiMessage.elemIds.licenseServer2.name());
            omiMessage2.addAttrib(OmiMessage.LicenseServerType.server.name(), this.val.licenseServerList[1].server);
            omiMessage2.addAttrib(OmiMessage.LicenseServerType.port.name(), this.val.licenseServerList[1].port);
            omiMessage2.addAttrib(OmiMessage.LicenseServerType.serverStandby.name(), this.val.licenseServerList[1].serverStandby);
            omiMessage2.addAttrib(OmiMessage.LicenseServerType.portStandby.name(), this.val.licenseServerList[1].portStandby);
            omiMessage2 = omiMessage2.addElement(OmiMessage.elemIds.licenseServer3.name());
            omiMessage2.addAttrib(OmiMessage.LicenseServerType.server.name(), this.val.licenseServerList[2].server);
            omiMessage2.addAttrib(OmiMessage.LicenseServerType.port.name(), this.val.licenseServerList[2].port);
            omiMessage2.addAttrib(OmiMessage.LicenseServerType.serverStandby.name(), this.val.licenseServerList[2].serverStandby);
            omiMessage2.addAttrib(OmiMessage.LicenseServerType.portStandby.name(), this.val.licenseServerList[2].portStandby);
            return omiMessage;
        }

        @Override
        public void clear() {
            this.val = null;
            super.clear();
        }
    }

    public static class LicenseServerClass {
        public static final int MAX_NUM_LICENSE_SERVER = 3;
        public boolean serverActive = true;
        public int installationId = 0;
        public LicenseServerData[] licenseServerList = new LicenseServerData[3];

        public LicenseServerClass() {
            for (int i = 0; i < 3; ++i) {
                this.licenseServerList[i] = new LicenseServerData();
            }
            this.licenseServerList[0].server = "127.0.0.1";
        }
    }

    public static class LicenseServerData {
        public String server = "";
        public int port = 38229;
        public String serverStandby = "";
        public int portStandby = 38229;
    }

    private class CommonDataItemLicense
    extends CommonDataItemClass {
        public LicenseClass val;

        public CommonDataItemLicense(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
            this.val = null;
        }

        private LicenseData getLicenseData(OmiMessage omiMessage) {
            LicenseData licenseData = new LicenseData();
            licenseData.key = omiMessage.getAttribVal(OmiMessage.LicenseType.key.name());
            licenseData.number = omiMessage.getAttribValInt(OmiMessage.LicenseType.number.name());
            licenseData.systemLicenseVersion = omiMessage.getAttribVal(OmiMessage.LicenseType.systemLicenseVersion.name());
            licenseData.messagingLicenseRcvMsgs = omiMessage.getAttribValBool(OmiMessage.LicenseType.messagingLicenseRcvMsgs.name());
            licenseData.locatingLicense = omiMessage.getAttribValBool(OmiMessage.LicenseType.locatingLicense.name());
            return licenseData;
        }

        private void addLicenseData(OmiMessage omiMessage) {
            String string = omiMessage.getAttribVal(OmiMessage.LicenseAttribType.type.name());
            if (string != null) {
                try {
                    this.val.type = OmiMessage.LicenseTypeType.valueOf(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.LicenseAttribType.state.name())) != null) {
                try {
                    this.val.state = OmiMessage.LicenseStateType.valueOf(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.LicenseAttribType.latency.name())) != null) {
                this.val.latency = omiMessage.getAttribValInt(OmiMessage.LicenseAttribType.latency.name());
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.LicenseAttribType.park.name())) != null) {
                this.val.park = string;
            }
            boolean bl = false;
            boolean bl2 = false;
            block13: for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
                switch (omiMessage2.id) {
                    case violation: {
                        if (!bl2) {
                            this.val.numViolations = 0;
                        }
                        bl2 = true;
                        string = omiMessage2.getBodyText();
                        try {
                            this.val.violations[this.val.numViolations] = OmiMessage.LicenseViolationType.valueOf(string);
                            ++this.val.numViolations;
                        }
                        catch (Exception exception) {}
                        continue block13;
                    }
                    case licenseRfp: {
                        if (!bl) {
                            this.val.numRfps = 0;
                            bl = true;
                        }
                        if (this.val.numRfps >= 3) continue block13;
                        this.val.licenseRfpType[this.val.numRfps].id = omiMessage2.getAttribValInt(OmiMessage.LicenseRfpType.id.name());
                        this.val.licenseRfpType[this.val.numRfps].ethAddr = omiMessage2.getAttribVal(OmiMessage.LicenseRfpType.ethAddr.name());
                        this.val.licenseRfpType[this.val.numRfps].connected = omiMessage2.getAttribValBool(OmiMessage.LicenseRfpType.connected.name());
                        ++this.val.numRfps;
                        continue block13;
                    }
                    case sysLicense: {
                        this.val.sysLicense = this.getLicenseData(omiMessage2);
                        continue block13;
                    }
                    case msgLicense: {
                        this.val.msgLicense = this.getLicenseData(omiMessage2);
                        continue block13;
                    }
                    case locLicense: {
                        this.val.locLicense = this.getLicenseData(omiMessage2);
                        continue block13;
                    }
                }
            }
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = this.createNewLicenseClass();
            this.addLicenseData(omiMessage);
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val == null) {
                this.val = this.createNewLicenseClass();
            }
            this.addLicenseData(omiMessage);
            super.updateDataFromMessage(omiMessage);
        }

        @Override
        public LicenseClass getVal() {
            return this.val;
        }

        @Override
        public void setVal(Object object) {
        }

        @Override
        public OmiMessage BuildSetReq() {
            return null;
        }

        @Override
        public void clear() {
            this.val = null;
            super.clear();
        }

        private LicenseClass createNewLicenseClass() {
            LicenseClass licenseClass = new LicenseClass();
            for (int i = 0; i < 3; ++i) {
                licenseClass.licenseRfpType[i] = new LicenseRfpTypeClass();
            }
            return licenseClass;
        }
    }

    public static class LicenseClass {
        public static final int MAX_NUM_LICENSE_RFPS = 3;
        public OmiMessage.LicenseTypeType type;
        public OmiMessage.LicenseStateType state;
        public int latency = 0;
        public String park = "";
        public LicenseData sysLicense = null;
        public LicenseData msgLicense = null;
        public LicenseData locLicense = null;
        public int numRfps = 0;
        public LicenseRfpTypeClass[] licenseRfpType = new LicenseRfpTypeClass[3];
        public int numViolations = 0;
        public OmiMessage.LicenseViolationType[] violations = new OmiMessage.LicenseViolationType[OmiMessage.LicenseViolationType.values().length];
    }

    public static class LicenseRfpTypeClass {
        public int id;
        public String ethAddr;
        public boolean connected;
    }

    public static class LicenseData {
        public String key;
        public int number;
        public String systemLicenseVersion;
        public boolean messagingLicenseRcvMsgs;
        public boolean locatingLicense;
    }

    private class CommonDataItemHealthState
    extends CommonDataItemClass {
        public HealthStateClass val;

        public CommonDataItemHealthState(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
            this.val = null;
        }

        private void addHealthState(OmiMessage omiMessage) {
            OmiMessage.HealthComponentType healthComponentType = null;
            OmiMessage.SeverityType severityType = OmiMessage.SeverityType.Unknown;
            String string = omiMessage.getAttribVal(OmiMessage.HealthStateType.reason.name());
            try {
                String string2 = omiMessage.getAttribVal(OmiMessage.HealthStateType.component.name());
                if (string2 != null) {
                    healthComponentType = OmiMessage.HealthComponentType.valueOf(string2);
                }
                if ((string2 = omiMessage.getAttribVal(OmiMessage.HealthStateType.severity.name())) != null) {
                    severityType = OmiMessage.SeverityType.valueOf(string2);
                }
                this.val.reasonCode[healthComponentType.ordinal()] = omiMessage.getAttribValInt(OmiMessage.HealthStateType.reasonCode.name());
                this.val.severity[healthComponentType.ordinal()] = severityType;
                this.val.reason[healthComponentType.ordinal()] = string;
            }
            catch (Exception exception) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, String.format("addHealthState caused exception: '%s'", exception.getMessage()));
            }
        }

        private void addAllHealthStates(OmiMessage omiMessage) {
            for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
                this.addHealthState(omiMessage2);
            }
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new HealthStateClass();
            this.addAllHealthStates(omiMessage);
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            this.addAllHealthStates(omiMessage);
            super.updateDataFromMessage(omiMessage);
        }

        @Override
        public HealthStateClass getVal() {
            return this.val;
        }

        @Override
        public void setVal(Object object) {
        }

        @Override
        public OmiMessage BuildSetReq() {
            return null;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class HealthStateClass {
        public OmiMessage.SeverityType[] severity = new OmiMessage.SeverityType[OmiMessage.HealthComponentType.values().length];
        public String[] reason = new String[OmiMessage.HealthComponentType.values().length];
        public int[] reasonCode = new int[OmiMessage.HealthComponentType.values().length];

        public HealthStateClass() {
            for (int i = 0; i < OmiMessage.HealthComponentType.values().length; ++i) {
                this.reason[i] = "";
                this.reasonCode[i] = 0;
                this.severity[i] = OmiMessage.SeverityType.Unknown;
            }
        }
    }

    private class CommonDataItemPbxCnf
    extends CommonDataItemClass {
        public PbxCnfClass val;

        public CommonDataItemPbxCnf(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6, OmiMessage.OpenRespAttribType.havePBXAddressCnf);
            this.val = null;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new PbxCnfClass();
            this.val.pbx = omiMessage.getAttribVal(OmiMessage.PBXType.pbx.name());
            this.val.pbxPort = omiMessage.getAttribValInt(OmiMessage.PBXType.pbxPort.name());
            this.val.pbxStb = omiMessage.getAttribVal(OmiMessage.PBXType.pbxStb.name());
            this.val.pbxStbPort = omiMessage.getAttribValInt(OmiMessage.PBXType.pbxStbPort.name());
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val == null) {
                this.setDataFromMessage(omiMessage);
            } else {
                if (omiMessage.getAttribVal(OmiMessage.PBXType.pbx.name()) != null) {
                    this.val.pbx = omiMessage.getAttribVal(OmiMessage.PBXType.pbx.name());
                }
                if (omiMessage.getAttribVal(OmiMessage.PBXType.pbxPort.name()) != null) {
                    this.val.pbxPort = omiMessage.getAttribValInt(OmiMessage.PBXType.pbxPort.name());
                }
                if (omiMessage.getAttribVal(OmiMessage.PBXType.pbxStb.name()) != null) {
                    this.val.pbxStb = omiMessage.getAttribVal(OmiMessage.PBXType.pbxStb.name());
                }
                if (omiMessage.getAttribVal(OmiMessage.PBXType.pbxStbPort.name()) != null) {
                    this.val.pbxStbPort = omiMessage.getAttribValInt(OmiMessage.PBXType.pbxStbPort.name());
                }
                super.updateDataFromMessage(omiMessage);
            }
        }

        @Override
        public PbxCnfClass getVal() {
            return this.val;
        }

        private void create() {
            if (this.val == null) {
                this.val = new PbxCnfClass();
                this.changed = true;
            }
        }

        public void setPbx(String string) {
            this.create();
            if (string != null) {
                if (this.val.pbx != null) {
                    if (!this.val.pbx.equals(string)) {
                        this.val.pbx = string;
                        this.changed = true;
                    }
                } else {
                    this.val.pbx = string;
                    this.changed = true;
                }
            }
        }

        public void setPbxPort(int n) {
            this.create();
            if (this.val.pbxPort != n) {
                this.val.pbxPort = n;
                this.changed = true;
            }
        }

        public void setPbxStb(String string) {
            this.create();
            if (string != null) {
                if (this.val.pbxStb != null) {
                    if (!this.val.pbxStb.equals(string)) {
                        this.val.pbxStb = string;
                        this.changed = true;
                    }
                } else {
                    this.val.pbxStb = string;
                    this.changed = true;
                }
            }
        }

        public void setPbxStbPort(int n) {
            this.create();
            if (this.val.pbxStbPort != n) {
                this.val.pbxStbPort = n;
                this.changed = true;
            }
        }

        @Override
        public void setVal(Object object) {
            this.setPbx(((PbxCnfClass)object).pbx);
            this.setPbxPort(((PbxCnfClass)object).pbxPort);
            this.setPbxStb(((PbxCnfClass)object).pbxStb);
            this.setPbxStbPort(((PbxCnfClass)object).pbxStbPort);
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            if (this.val.pbx != null) {
                omiMessage.addAttrib(OmiMessage.PBXType.pbx.name(), this.val.pbx);
                omiMessage.addAttrib(OmiMessage.PBXType.pbxPort.name(), this.val.pbxPort);
            }
            if (this.val.pbxStb != null) {
                omiMessage.addAttrib(OmiMessage.PBXType.pbxStb.name(), this.val.pbxStb);
                omiMessage.addAttrib(OmiMessage.PBXType.pbxStbPort.name(), this.val.pbxStbPort);
            }
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class PbxCnfClass {
        public String pbx = null;
        public String pbxStb = null;
        public int pbxPort = 0;
        public int pbxStbPort = 0;
    }

    private class CommonDataItemImaCnf
    extends CommonDataItemClass {
        public IMACnfClass val;

        public CommonDataItemImaCnf(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
            this.val = null;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new IMACnfClass();
            this.val.enable = omiMessage.getAttribValBool(OmiMessage.IMACnfType.enable.name());
            this.val.url = new UrlClass(omiMessage.getSubElement());
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val == null) {
                this.setDataFromMessage(omiMessage);
            } else {
                OmiMessage omiMessage2;
                if (omiMessage.getAttribVal(OmiMessage.IMACnfType.enable.name()) != null) {
                    this.val.enable = omiMessage.getAttribValBool(OmiMessage.IMACnfType.enable.name());
                }
                if ((omiMessage2 = omiMessage.getSubElement()) != null) {
                    this.val.url.updateFromMsg(omiMessage2);
                }
                super.updateDataFromMessage(omiMessage);
            }
        }

        @Override
        public IMACnfClass getVal() {
            return this.val;
        }

        private void create() {
            if (this.val == null) {
                this.val = new IMACnfClass();
                this.changed = true;
            }
        }

        public void setEnable(boolean bl) {
            this.create();
            if (this.val.enable != bl) {
                this.val.enable = bl;
                this.changed = true;
            }
        }

        public void setURL(UrlClass urlClass) {
            this.create();
            if (urlClass != null) {
                if (this.val.url == null) {
                    this.val.url = new UrlClass();
                }
                this.changed |= this.val.url.updateFromOtherUrl(urlClass);
            }
        }

        @Override
        public void setVal(Object object) {
            this.setEnable(((IMACnfClass)object).enable);
            this.setURL(((IMACnfClass)object).url);
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            omiMessage.addAttrib(OmiMessage.IMACnfType.enable.name(), this.val.enable);
            this.val.url.addUrlToMsg(omiMessage);
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class IMACnfClass {
        public boolean enable = false;
        public UrlClass url = null;
    }

    private class CommonDataItemSyslogCnf
    extends CommonDataItemClass {
        public SyslogCnfClass val;

        public CommonDataItemSyslogCnf(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
            this.val = null;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new SyslogCnfClass();
            this.val.ipAddr = omiMessage.getAttribVal(OmiMessage.SyslogCnfType.ipAddr.name());
            this.val.enable = omiMessage.getAttribValBool(OmiMessage.SyslogCnfType.enable.name());
            this.val.port = omiMessage.getAttribValInt(OmiMessage.SyslogCnfType.port.name());
            this.val.forward = omiMessage.getAttribValBoolNotMandatory(OmiMessage.SyslogCnfType.forward.name());
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val == null) {
                this.setDataFromMessage(omiMessage);
            } else {
                String string = omiMessage.getAttribVal(OmiMessage.SyslogCnfType.ipAddr.name());
                if (string != null) {
                    this.val.ipAddr = string;
                }
                this.val.enable = CommonDataHandler.this.updateNotMandatoryBoolean(omiMessage, OmiMessage.SyslogCnfType.enable.name(), this.val.enable);
                this.val.forward = CommonDataHandler.this.updateNotMandatoryBoolean(omiMessage, OmiMessage.SyslogCnfType.forward.name(), this.val.forward);
                if (omiMessage.getAttribVal(OmiMessage.SyslogCnfType.port.name()) != null) {
                    this.val.port = omiMessage.getAttribValInt(OmiMessage.SyslogCnfType.port.name());
                }
                super.updateDataFromMessage(omiMessage);
            }
        }

        @Override
        public SyslogCnfClass getVal() {
            return this.val;
        }

        private void create() {
            if (this.val == null) {
                this.val = new SyslogCnfClass();
                this.changed = true;
            }
        }

        public void setEnable(boolean bl) {
            this.create();
            if (this.val.enable != bl) {
                this.val.enable = bl;
                this.changed = true;
            }
        }

        public void setIpAddr(String string) {
            this.create();
            if (string != null) {
                if (this.val.ipAddr != null) {
                    if (!this.val.ipAddr.equals(string)) {
                        this.val.ipAddr = string;
                        this.changed = true;
                    }
                } else {
                    this.val.ipAddr = string;
                    this.changed = true;
                }
            }
        }

        public void setPort(int n) {
            this.create();
            if (this.val.port != n) {
                this.val.port = n;
                this.changed = true;
            }
        }

        public void setForward(Boolean bl) {
            this.create();
            if (bl != null) {
                if (this.val.forward == null) {
                    this.val.forward = bl;
                    this.changed = true;
                } else if (!this.val.forward.equals(bl)) {
                    this.val.forward = bl;
                    this.changed = true;
                }
            }
        }

        @Override
        public void setVal(Object object) {
            this.setEnable(((SyslogCnfClass)object).enable);
            this.setIpAddr(((SyslogCnfClass)object).ipAddr);
            this.setPort(((SyslogCnfClass)object).port);
            this.setForward(((SyslogCnfClass)object).forward);
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            omiMessage.addAttrib(OmiMessage.SyslogCnfType.enable.name(), this.val.enable);
            if (this.val.ipAddr != null) {
                omiMessage.addAttrib(OmiMessage.SyslogCnfType.ipAddr.name(), this.val.ipAddr);
                omiMessage.addAttrib(OmiMessage.SyslogCnfType.port.name(), this.val.port);
            }
            if (this.val.forward != null) {
                omiMessage.addAttrib(OmiMessage.SyslogCnfType.forward.name(), this.val.forward);
            }
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class SyslogCnfClass {
        public boolean enable = false;
        public String ipAddr = null;
        public int port = 0;
        public Boolean forward = null;
    }

    private class CommonDataItemPublicKey
    extends CommonDataItemClass {
        public PublicKeyClass val;

        public CommonDataItemPublicKey(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
            this.val = null;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new PublicKeyClass();
            this.val.modulus = omiMessage.getAttribVal(OmiMessage.PublicKeyType.modulus.name());
            this.val.exponent = omiMessage.getAttribVal(OmiMessage.PublicKeyType.exponent.name());
            OmiRSA.setKey(this.val.modulus, this.val.exponent);
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            this.setDataFromMessage(omiMessage);
        }

        @Override
        public PublicKeyClass getVal() {
            return this.val;
        }

        @Override
        public void setVal(Object object) {
        }

        @Override
        public OmiMessage BuildSetReq() {
            return null;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class PublicKeyClass {
        public String modulus = null;
        public String exponent = null;
    }

    private class CommonDataItemTimeZoneDetails
    extends CommonDataItemClass {
        public TimeZoneDetailsClass val;
        private OmiMessage.elemIds getId;

        public CommonDataItemTimeZoneDetails(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
            this.val = null;
            this.getId = elemIds2;
        }

        @Override
        public OmiMessage BuildGetReq() {
            if (this.getId != null) {
                try {
                    String string = CommonDataHandler.this.getData(CommonDataItemEnum.TimeZone).toString();
                    OmiMessage omiMessage = new OmiMessage(this.getId.name());
                    omiMessage.addAttrib(OmiMessage.attribIds.id.name(), string);
                    return omiMessage;
                }
                catch (DataNotAvaillableException dataNotAvaillableException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
                this.val = new TimeZoneDetailsClass();
                if (omiMessage2.id != OmiMessage.elemIds.zone) continue;
                this.val.id = omiMessage2.getAttribVal(OmiMessage.attribIds.id.name());
                this.val.name = omiMessage2.getAttribVal(OmiMessage.attribIds.name.name());
                this.val.stdOffset = omiMessage2.getAttribValInt(OmiMessage.TimeZoneType.stdOffset.name());
                this.val.stdMonth = omiMessage2.getAttribValInt(OmiMessage.TimeZoneType.stdMonth.name());
                this.val.stdDay = omiMessage2.getAttribValInt(OmiMessage.TimeZoneType.stdDay.name());
                this.val.stdDoW = omiMessage2.getAttribValInt(OmiMessage.TimeZoneType.stdDoW.name());
                this.val.stdWoM = omiMessage2.getAttribValInt(OmiMessage.TimeZoneType.stdWoM.name());
                this.val.stdHour = omiMessage2.getAttribValInt(OmiMessage.TimeZoneType.stdHour.name());
                this.val.stdMin = omiMessage2.getAttribValInt(OmiMessage.TimeZoneType.stdMin.name());
                this.val.dstOffset = omiMessage2.getAttribValInt(OmiMessage.TimeZoneType.dstOffset.name());
                this.val.dstMonth = omiMessage2.getAttribValInt(OmiMessage.TimeZoneType.dstMonth.name());
                this.val.dstDay = omiMessage2.getAttribValInt(OmiMessage.TimeZoneType.dstDay.name());
                this.val.dstDoW = omiMessage2.getAttribValInt(OmiMessage.TimeZoneType.dstDoW.name());
                this.val.dstWoM = omiMessage2.getAttribValInt(OmiMessage.TimeZoneType.dstWoM.name());
                this.val.dstHour = omiMessage2.getAttribValInt(OmiMessage.TimeZoneType.dstHour.name());
                this.val.dstMin = omiMessage2.getAttribValInt(OmiMessage.TimeZoneType.dstMin.name());
            }
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            this.setDataFromMessage(omiMessage);
            if (!VersionHandler.versionElementDb.containsElement(VersionTypeEnum.EventTimeZoneList.name())) {
                CommonDataHandler.this.omiHandler.sendOmiMessage(new OmiMessage(OmiMessage.elemIds.GetTimeZoneList));
            }
        }

        @Override
        public TimeZoneDetailsClass getVal() {
            return this.val;
        }

        @Override
        public void setVal(Object object) {
            if (object.getClass() == TimeZoneDetailsClass.class) {
                this.val = (TimeZoneDetailsClass)object;
                this.changed = true;
            }
        }

        @Override
        public OmiMessage BuildSetReq() {
            if (this.val != null) {
                OmiMessage omiMessage = new OmiMessage(this.setId.name());
                OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.zone);
                omiMessage2.addAttrib(OmiMessage.TimeZoneType.id.name(), this.val.id);
                if (this.val.name != null) {
                    omiMessage2.addAttrib(OmiMessage.TimeZoneType.name.name(), this.val.name);
                }
                omiMessage2.addAttrib(OmiMessage.TimeZoneType.stdOffset.name(), this.val.stdOffset);
                omiMessage2.addAttrib(OmiMessage.TimeZoneType.stdMonth.name(), this.val.stdMonth);
                omiMessage2.addAttrib(OmiMessage.TimeZoneType.stdDay.name(), this.val.stdDay);
                omiMessage2.addAttrib(OmiMessage.TimeZoneType.stdDoW.name(), this.val.stdDoW);
                omiMessage2.addAttrib(OmiMessage.TimeZoneType.stdWoM.name(), this.val.stdWoM);
                omiMessage2.addAttrib(OmiMessage.TimeZoneType.stdHour.name(), this.val.stdHour);
                omiMessage2.addAttrib(OmiMessage.TimeZoneType.stdMin.name(), this.val.stdMin);
                omiMessage2.addAttrib(OmiMessage.TimeZoneType.dstOffset.name(), this.val.dstOffset);
                omiMessage2.addAttrib(OmiMessage.TimeZoneType.dstMonth.name(), this.val.dstMonth);
                omiMessage2.addAttrib(OmiMessage.TimeZoneType.dstDay.name(), this.val.dstDay);
                omiMessage2.addAttrib(OmiMessage.TimeZoneType.dstDoW.name(), this.val.dstDoW);
                omiMessage2.addAttrib(OmiMessage.TimeZoneType.dstWoM.name(), this.val.dstWoM);
                omiMessage2.addAttrib(OmiMessage.TimeZoneType.dstHour.name(), this.val.dstHour);
                omiMessage2.addAttrib(OmiMessage.TimeZoneType.dstMin.name(), this.val.dstMin);
                return omiMessage;
            }
            return null;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class TimeZoneDetailsClass {
        public String id;
        public String name;
        public int stdOffset;
        public int stdMonth;
        public int stdDay;
        public int stdDoW;
        public int stdWoM;
        public int stdHour;
        public int stdMin;
        public int dstOffset;
        public int dstMonth;
        public int dstDay;
        public int dstDoW;
        public int dstWoM;
        public int dstHour;
        public int dstMin;
    }

    private class CommonDataItemTimeZoneList
    extends CommonDataItemClass {
        public TimeZoneListClass val;

        public CommonDataItemTimeZoneList(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
            this.val = null;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            OmiMessage omiMessage2;
            this.val = new TimeZoneListClass();
            int n = 0;
            for (omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
                if (omiMessage2.id != OmiMessage.elemIds.zone) continue;
                ++n;
            }
            if (n > 0) {
                this.val.list = new TimeZoneIdNameClass[n];
                n = 0;
                for (omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
                    if (omiMessage2.id != OmiMessage.elemIds.zone) continue;
                    this.val.list[n] = new TimeZoneIdNameClass();
                    this.val.list[n].id = omiMessage2.getAttribVal(OmiMessage.attribIds.id.name());
                    this.val.list[n].name = omiMessage2.getAttribVal(OmiMessage.attribIds.name.name());
                    if (omiMessage2.getAttribVal(OmiMessage.attribIds.modified.name()) != null) {
                        this.val.list[n].modified = omiMessage2.getAttribValBool(OmiMessage.attribIds.modified.name());
                    }
                    ++n;
                }
            }
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val == null) {
                super.setDataFromMessage(omiMessage);
            } else {
                block0: for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
                    if (omiMessage2.id != OmiMessage.elemIds.zone) continue;
                    String string = omiMessage2.getAttribVal(OmiMessage.attribIds.id.name());
                    for (int i = 0; i < this.val.list.length; ++i) {
                        if (!this.val.list[i].id.equals(string)) continue;
                        this.val.list[i].id = string;
                        this.val.list[i].name = omiMessage2.getAttribVal(OmiMessage.attribIds.name.name());
                        this.val.list[i].modified = omiMessage2.getAttribValBool(OmiMessage.attribIds.modified.name());
                        continue block0;
                    }
                }
                super.updateDataFromMessage(omiMessage);
            }
        }

        @Override
        public TimeZoneListClass getVal() {
            return this.val;
        }

        @Override
        public void setVal(Object object) {
        }

        @Override
        public OmiMessage BuildSetReq() {
            return null;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class TimeZoneListClass {
        public TimeZoneIdNameClass[] list = null;
    }

    public static class TimeZoneIdNameClass {
        public String id;
        public String name;
        public boolean modified = false;
    }

    private class CommonDataItemFACList
    extends CommonDataItemClass {
        public FACListClass val;

        public CommonDataItemFACList(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
            this.val = null;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            if (this.val == null) {
                this.val = new FACListClass();
            }
            OmiMessage omiMessage2 = omiMessage.getSubElement();
            while (omiMessage2 != null) {
                if (omiMessage2.id != OmiMessage.elemIds.fac) continue;
                String string = omiMessage2.getAttribVal(OmiMessage.FACType.feature.name());
                if (string != null) {
                    OmiMessage.FACFeatureType fACFeatureType = null;
                    try {
                        fACFeatureType = OmiMessage.FACFeatureType.valueOf(string);
                        int n = fACFeatureType.ordinal();
                        FACListClass.FACClass fACClass = new FACListClass.FACClass();
                        fACClass.feature = fACFeatureType;
                        fACClass.enable = omiMessage2.getAttribValBool(OmiMessage.FACType.enable.name());
                        fACClass.fac = omiMessage2.getAttribVal(OmiMessage.FACType.fac.name());
                        this.val.FACArr[n] = fACClass;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                omiMessage2 = omiMessage2.getNext();
            }
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            this.setDataFromMessage(omiMessage);
        }

        @Override
        public FACListClass getVal() {
            return this.val;
        }

        private void create() {
            if (this.val == null) {
                this.val = new FACListClass();
                this.changed = true;
            }
        }

        private void setEnable(OmiMessage.FACFeatureType fACFeatureType, boolean bl) {
            this.create();
            int n = fACFeatureType.ordinal();
            FACListClass.FACClass fACClass = this.val.FACArr[n];
            if (fACClass == null) {
                fACClass = new FACListClass.FACClass();
                fACClass.feature = fACFeatureType;
                this.changed = true;
                this.val.FACArr[n] = fACClass;
            }
            if (fACClass.enable != bl) {
                fACClass.enable = bl;
                this.changed = true;
            }
        }

        private void setFAC(OmiMessage.FACFeatureType fACFeatureType, String string) {
            this.create();
            int n = fACFeatureType.ordinal();
            FACListClass.FACClass fACClass = this.val.FACArr[n];
            if (fACClass == null) {
                fACClass = new FACListClass.FACClass();
                this.changed = true;
                fACClass.feature = fACFeatureType;
                this.val.FACArr[n] = fACClass;
            }
            if (string != null) {
                if (fACClass.fac != null) {
                    if (!fACClass.fac.equals(string)) {
                        fACClass.fac = string;
                        this.changed = true;
                    }
                } else {
                    fACClass.fac = string;
                    this.changed = true;
                }
            }
        }

        @Override
        public void setVal(Object object) {
            FACListClass fACListClass = (FACListClass)object;
            for (int i = 0; i < fACListClass.FACArr.length; ++i) {
                if (fACListClass.FACArr[i] == null) continue;
                FACListClass.FACClass fACClass = fACListClass.FACArr[i];
                this.setEnable(fACClass.feature, fACClass.enable);
                this.setFAC(fACClass.feature, fACClass.fac);
            }
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            OmiMessage omiMessage2 = null;
            for (int i = 0; i < this.val.FACArr.length; ++i) {
                if (this.val.FACArr[i] == null) continue;
                omiMessage2 = omiMessage2 == null ? omiMessage.addSubElement(OmiMessage.elemIds.fac) : omiMessage2.addElement(OmiMessage.elemIds.fac);
                FACListClass.FACClass fACClass = this.val.FACArr[i];
                omiMessage2.addAttrib(OmiMessage.FACType.feature.name(), fACClass.feature.name());
                omiMessage2.addAttrib(OmiMessage.FACType.enable.name(), fACClass.enable);
                omiMessage2.addAttrib(OmiMessage.FACType.fac.name(), fACClass.fac);
            }
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear(CommonDataItemEnum.FACList);
            this.val = null;
        }
    }

    public static class FACListClass {
        public FACClass[] FACArr = new FACClass[OmiMessage.FACFeatureType.values().length];

        public static class FACClass {
            public OmiMessage.FACFeatureType feature;
            public boolean enable;
            public String fac;
        }
    }

    private class CommonDataItemSNMP
    extends CommonDataItemClass {
        public SNMPClass val;

        public CommonDataItemSNMP(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
            this.val = null;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new SNMPClass();
            this.val.readCommunity = omiMessage.getAttribVal(OmiMessage.SNMPType.readCommunity.name());
            this.val.contact = omiMessage.getAttribVal(OmiMessage.SNMPType.contact.name());
            this.val.enableTraps = omiMessage.getAttribValBool(OmiMessage.SNMPType.enableTraps.name());
            this.val.trapCommunity = omiMessage.getAttribVal(OmiMessage.SNMPType.trapCommunity.name());
            this.val.trapHostAddr = omiMessage.getAttribVal(OmiMessage.SNMPType.trapHostAddr.name());
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val != null) {
                this.val.enableTraps = CommonDataHandler.this.updateNotMandatoryBoolean(omiMessage, OmiMessage.SNMPType.enableTraps.name(), this.val.enableTraps);
                String string = omiMessage.getAttribVal(OmiMessage.SNMPType.readCommunity.name());
                if (string != null) {
                    this.val.readCommunity = string;
                }
                if ((string = omiMessage.getAttribVal(OmiMessage.SNMPType.contact.name())) != null) {
                    this.val.contact = string;
                }
                if ((string = omiMessage.getAttribVal(OmiMessage.SNMPType.trapCommunity.name())) != null) {
                    this.val.trapCommunity = string;
                }
                if ((string = omiMessage.getAttribVal(OmiMessage.SNMPType.trapHostAddr.name())) != null) {
                    this.val.trapHostAddr = string;
                }
            } else {
                this.setDataFromMessage(omiMessage);
            }
        }

        @Override
        public SNMPClass getVal() {
            return this.val;
        }

        private void create() {
            if (this.val == null) {
                this.val = new SNMPClass();
                this.changed = true;
            }
        }

        public void setEnableTraps(boolean bl) {
            this.create();
            if (this.val.enableTraps != bl) {
                this.val.enableTraps = bl;
                this.changed = true;
            }
        }

        public void setReadCommunity(String string) {
            this.create();
            if (string != null) {
                if (this.val.readCommunity != null) {
                    if (!this.val.readCommunity.equals(string)) {
                        this.val.readCommunity = string;
                        this.changed = true;
                    }
                } else {
                    this.val.readCommunity = string;
                    this.changed = true;
                }
            }
        }

        public void setContact(String string) {
            this.create();
            if (string != null) {
                if (this.val.contact != null) {
                    if (!this.val.contact.equals(string)) {
                        this.val.contact = string;
                        this.changed = true;
                    }
                } else {
                    this.val.contact = string;
                    this.changed = true;
                }
            }
        }

        public void setTrapCommunity(String string) {
            this.create();
            if (string != null) {
                if (this.val.trapCommunity != null) {
                    if (!this.val.trapCommunity.equals(string)) {
                        this.val.trapCommunity = string;
                        this.changed = true;
                    }
                } else {
                    this.val.trapCommunity = string;
                    this.changed = true;
                }
            }
        }

        public void setTrapHostAddr(String string) {
            this.create();
            if (string != null) {
                if (this.val.trapHostAddr != null) {
                    if (!this.val.trapHostAddr.equals(string)) {
                        this.val.trapHostAddr = string;
                        this.changed = true;
                    }
                } else {
                    this.val.trapHostAddr = string;
                    this.changed = true;
                }
            }
        }

        @Override
        public void setVal(Object object) {
            this.setReadCommunity(((SNMPClass)object).readCommunity);
            this.setContact(((SNMPClass)object).contact);
            this.setEnableTraps(((SNMPClass)object).enableTraps);
            this.setTrapCommunity(((SNMPClass)object).trapCommunity);
            this.setTrapHostAddr(((SNMPClass)object).trapHostAddr);
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            if (this.val.readCommunity != null) {
                omiMessage.addAttrib(OmiMessage.SNMPType.readCommunity.name(), this.val.readCommunity);
            }
            if (this.val.contact != null) {
                omiMessage.addAttrib(OmiMessage.SNMPType.contact.name(), this.val.contact);
            }
            omiMessage.addAttrib(OmiMessage.SNMPType.enableTraps.name(), this.val.enableTraps);
            if (this.val.trapCommunity != null) {
                omiMessage.addAttrib(OmiMessage.SNMPType.trapCommunity.name(), this.val.trapCommunity);
            }
            if (this.val.trapHostAddr != null) {
                omiMessage.addAttrib(OmiMessage.SNMPType.trapHostAddr.name(), this.val.trapHostAddr);
            }
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class SNMPClass {
        public String readCommunity = null;
        public String contact = null;
        public boolean enableTraps = false;
        public String trapCommunity = null;
        public String trapHostAddr = null;
    }

    private class CommonDataItemCertificate
    extends CommonDataItemClass {
        public CertificateClass val;

        public CommonDataItemCertificate(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
            this.val = null;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new CertificateClass();
            this.val.nTrustedCertificates = omiMessage.getAttribValInt(OmiMessage.CertificateType.nTrustedCertificates.name());
            this.val.nLocalCertificates = omiMessage.getAttribValInt(OmiMessage.CertificateType.nLocalCertificates.name());
            this.val.nPrivateKeys = omiMessage.getAttribValInt(OmiMessage.CertificateType.nPrivateKeys.name());
            this.val.identity = omiMessage.getAttribVal(OmiMessage.CertificateType.identity.name());
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val != null) {
                if (omiMessage.getAttribVal(OmiMessage.CertificateType.nTrustedCertificates.name()) != null) {
                    this.val.nTrustedCertificates = omiMessage.getAttribValInt(OmiMessage.CertificateType.nTrustedCertificates.name());
                }
                if (omiMessage.getAttribVal(OmiMessage.CertificateType.nLocalCertificates.name()) != null) {
                    this.val.nLocalCertificates = omiMessage.getAttribValInt(OmiMessage.CertificateType.nLocalCertificates.name());
                }
                if (omiMessage.getAttribVal(OmiMessage.CertificateType.nPrivateKeys.name()) != null) {
                    this.val.nPrivateKeys = omiMessage.getAttribValInt(OmiMessage.CertificateType.nPrivateKeys.name());
                }
                if (omiMessage.getAttribVal(OmiMessage.CertificateType.identity.name()) != null) {
                    this.val.identity = omiMessage.getAttribVal(OmiMessage.CertificateType.identity.name());
                }
                this.val.privateKeyPassword = null;
                super.updateDataFromMessage(omiMessage);
            } else {
                this.setDataFromMessage(omiMessage);
            }
        }

        @Override
        public CertificateClass getVal() {
            return this.val;
        }

        private void create() {
            if (this.val == null) {
                this.val = new CertificateClass();
                this.changed = true;
            }
        }

        public void setTrustedCertificates(Vector<String> vector) {
            this.create();
            if (this.val.trustedCertificates == null) {
                this.val.trustedCertificates = vector;
                this.changed = true;
            } else if (!this.val.trustedCertificates.equals(vector)) {
                this.val.trustedCertificates = vector;
                this.changed = true;
            }
        }

        public void setLocalCertificates(Vector<String> vector) {
            this.create();
            if (this.val.localCertificates == null) {
                this.val.localCertificates = vector;
                this.changed = true;
            } else if (!this.val.localCertificates.equals(vector)) {
                this.val.localCertificates = vector;
                this.changed = true;
            }
        }

        public void setPrivateKey(String string) {
            this.create();
            if (this.val.privateKey == null) {
                this.val.privateKey = string;
                this.changed = true;
            } else if (!this.val.privateKey.equals(string)) {
                this.val.privateKey = string;
                this.changed = true;
            }
        }

        public void setPrivateKeyPassword(String string) {
            this.create();
            if (this.val.privateKeyPassword == null) {
                this.val.privateKeyPassword = string;
                this.changed = true;
            }
        }

        public void setIdentity(String string) {
            this.create();
            if (this.val.identity == null) {
                if (string != null) {
                    this.val.identity = string;
                    this.changed = true;
                }
            } else if (!this.val.identity.equals(string)) {
                this.val.identity = string;
                this.changed = true;
            }
        }

        @Override
        public void setVal(Object object) {
            if (object.getClass() != CertificateClass.class) {
                throw new IllegalArgumentException("wrong argument type");
            }
            this.setTrustedCertificates(((CertificateClass)object).trustedCertificates);
            this.setLocalCertificates(((CertificateClass)object).localCertificates);
            this.setPrivateKey(((CertificateClass)object).privateKey);
            this.setPrivateKeyPassword(((CertificateClass)object).privateKeyPassword);
            this.setIdentity(((CertificateClass)object).identity);
        }

        @Override
        public OmiMessage BuildSetReq() {
            Iterator<String> iterator;
            Object object;
            Object object2;
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            if (this.val.privateKey != null && this.val.privateKey.length() > 0) {
                object2 = omiMessage.addSubElement(OmiMessage.elemIds.privateKeys);
                object = ((OmiMessage)object2).addSubElement(OmiMessage.elemIds.certificate);
                ((OmiMessage)object).addAttrib(OmiMessage.attribIds.key.name(), this.val.privateKey);
            }
            if (!this.val.trustedCertificates.isEmpty()) {
                object2 = omiMessage.addSubElement(OmiMessage.elemIds.trustedCertificates);
                object = null;
                iterator = this.val.trustedCertificates.iterator();
                while (iterator.hasNext()) {
                    object = object == null ? ((OmiMessage)object2).addSubElement(OmiMessage.elemIds.certificate) : ((OmiMessage)object).addElement(OmiMessage.elemIds.certificate);
                    ((OmiMessage)object).addAttrib(OmiMessage.attribIds.key.name(), iterator.next());
                }
            }
            if (!this.val.localCertificates.isEmpty()) {
                object2 = omiMessage.addSubElement(OmiMessage.elemIds.localCertificates);
                object = null;
                iterator = this.val.localCertificates.iterator();
                while (iterator.hasNext()) {
                    object = object == null ? ((OmiMessage)object2).addSubElement(OmiMessage.elemIds.certificate) : ((OmiMessage)object).addElement(OmiMessage.elemIds.certificate);
                    ((OmiMessage)object).addAttrib(OmiMessage.attribIds.key.name(), iterator.next());
                }
            }
            if (this.val.privateKeyPassword != null) {
                object2 = OmiRSA.encrypt(this.val.privateKeyPassword);
                if (object2 != null) {
                    object = Base64Coder.encode((byte[])object2);
                    omiMessage.addAttrib(OmiMessage.CertificateType.privateKeyPassword.name(), new String((char[])object));
                } else {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "CommonDataURL: privateKeyPassword encryption failed");
                }
            }
            if (this.val.identity != null) {
                omiMessage.addAttrib(OmiMessage.CertificateType.identity.name(), this.val.identity);
            }
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class CertificateClass {
        public int nTrustedCertificates = 0;
        public int nLocalCertificates = 0;
        public int nPrivateKeys = 0;
        public Vector<String> trustedCertificates = new Vector();
        public Vector<String> localCertificates = new Vector();
        public String privateKey = null;
        public String privateKeyPassword = null;
        public String identity = null;
    }

    private class CommonDataItemSecureSIP
    extends CommonDataItemClass {
        public SecureSIPClass val;

        public CommonDataItemSecureSIP(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6, OmiMessage.OpenRespAttribType openRespAttribType) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6, openRespAttribType);
            this.val = null;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new SecureSIPClass();
            this.val.keepAliveTimeoutEnable = omiMessage.getAttribValBool(OmiMessage.SecureSIPType.keepAliveTimeoutEnable.name());
            this.val.timeout = omiMessage.getAttribValInt(OmiMessage.SecureSIPType.timeout.name());
            this.val.sendSipsOverTLS = omiMessage.getAttribValBool(OmiMessage.SecureSIPType.sendSipsOverTLS.name());
            this.val.authenticationTLS = omiMessage.getAttribValBool(OmiMessage.SecureSIPType.authenticationTLS.name());
            this.val.commonNameValidationTLS = omiMessage.getAttribValBool(OmiMessage.SecureSIPType.commonNameValidationTLS.name());
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val != null) {
                if (omiMessage.getAttribVal(OmiMessage.SecureSIPType.keepAliveTimeoutEnable.name()) != null) {
                    this.val.keepAliveTimeoutEnable = omiMessage.getAttribValBool(OmiMessage.SecureSIPType.keepAliveTimeoutEnable.name());
                }
                if (omiMessage.getAttribVal(OmiMessage.SecureSIPType.timeout.name()) != null) {
                    this.val.timeout = omiMessage.getAttribValInt(OmiMessage.SecureSIPType.timeout.name());
                }
                if (omiMessage.getAttribVal(OmiMessage.SecureSIPType.sendSipsOverTLS.name()) != null) {
                    this.val.sendSipsOverTLS = omiMessage.getAttribValBool(OmiMessage.SecureSIPType.sendSipsOverTLS.name());
                }
                if (omiMessage.getAttribVal(OmiMessage.SecureSIPType.authenticationTLS.name()) != null) {
                    this.val.authenticationTLS = omiMessage.getAttribValBool(OmiMessage.SecureSIPType.authenticationTLS.name());
                }
                if (omiMessage.getAttribVal(OmiMessage.SecureSIPType.commonNameValidationTLS.name()) != null) {
                    this.val.commonNameValidationTLS = omiMessage.getAttribValBool(OmiMessage.SecureSIPType.commonNameValidationTLS.name());
                }
                super.updateDataFromMessage(omiMessage);
            } else {
                this.setDataFromMessage(omiMessage);
            }
        }

        @Override
        public SecureSIPClass getVal() {
            return this.val;
        }

        private void create() {
            if (this.val == null) {
                this.val = new SecureSIPClass();
                this.changed = true;
            }
        }

        public void setkeepAliveTimeoutEnable(boolean bl) {
            this.create();
            if (this.val.keepAliveTimeoutEnable != bl) {
                this.val.keepAliveTimeoutEnable = bl;
                this.changed = true;
            }
        }

        public void setTimeout(int n) {
            this.create();
            if (this.val.timeout != n) {
                this.val.timeout = n;
                this.changed = true;
            }
        }

        public void setSendSipsOverTLS(boolean bl) {
            this.create();
            if (this.val.sendSipsOverTLS != bl) {
                this.val.sendSipsOverTLS = bl;
                this.changed = true;
            }
        }

        public void setTLSAuthentication(boolean bl) {
            this.create();
            if (this.val.authenticationTLS != bl) {
                this.val.authenticationTLS = bl;
                this.changed = true;
            }
        }

        public void setTLSCommonNameValidation(boolean bl) {
            this.create();
            if (this.val.commonNameValidationTLS != bl) {
                this.val.commonNameValidationTLS = bl;
                this.changed = true;
            }
        }

        @Override
        public void setVal(Object object) {
            if (object.getClass() != SecureSIPClass.class) {
                throw new IllegalArgumentException("wrong argument type");
            }
            this.setkeepAliveTimeoutEnable(((SecureSIPClass)object).keepAliveTimeoutEnable);
            this.setTimeout(((SecureSIPClass)object).timeout);
            this.setSendSipsOverTLS(((SecureSIPClass)object).sendSipsOverTLS);
            this.setTLSAuthentication(((SecureSIPClass)object).authenticationTLS);
            this.setTLSCommonNameValidation(((SecureSIPClass)object).commonNameValidationTLS);
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            omiMessage.addAttrib(OmiMessage.SecureSIPType.keepAliveTimeoutEnable.name(), this.val.keepAliveTimeoutEnable);
            omiMessage.addAttrib(OmiMessage.SecureSIPType.timeout.name(), this.val.timeout);
            omiMessage.addAttrib(OmiMessage.SecureSIPType.sendSipsOverTLS.name(), this.val.sendSipsOverTLS);
            omiMessage.addAttrib(OmiMessage.SecureSIPType.authenticationTLS.name(), this.val.authenticationTLS);
            omiMessage.addAttrib(OmiMessage.SecureSIPType.commonNameValidationTLS.name(), this.val.commonNameValidationTLS);
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class SecureSIPClass {
        public boolean keepAliveTimeoutEnable = false;
        public int timeout = 30;
        public boolean sendSipsOverTLS = false;
        public boolean authenticationTLS = true;
        public boolean commonNameValidationTLS = false;
    }

    private class CommonDataItemDTMF
    extends CommonDataItemClass {
        public DTMFClass val;

        public CommonDataItemDTMF(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
            this.val = null;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new DTMFClass(omiMessage.getAttribValBool(OmiMessage.attribIds.outOfBand.name()), omiMessage.getAttribValInt(OmiMessage.attribIds.payloadType.name()), OmiMessage.DTMFMethodType.valueOf(omiMessage.getAttribVal(OmiMessage.attribIds.method.name())));
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val != null) {
                this.val.outOfBand = CommonDataHandler.this.updateNotMandatoryBoolean(omiMessage, OmiMessage.attribIds.outOfBand.name(), this.val.outOfBand);
                if (omiMessage.getAttribVal(OmiMessage.attribIds.payloadType.name()) != null) {
                    this.val.payloadType = omiMessage.getAttribValInt(OmiMessage.attribIds.payloadType.name());
                }
                if (omiMessage.getAttribVal(OmiMessage.attribIds.method.name()) != null) {
                    this.val.method = OmiMessage.DTMFMethodType.valueOf(omiMessage.getAttribVal(OmiMessage.attribIds.method.name()));
                }
                super.updateDataFromMessage(omiMessage);
            } else {
                this.setDataFromMessage(omiMessage);
            }
        }

        @Override
        public DTMFClass getVal() {
            return this.val;
        }

        private void create() {
            if (this.val == null) {
                this.val = new DTMFClass();
                this.changed = true;
            }
        }

        public void setOutOfBand(boolean bl) {
            this.create();
            if (this.val.outOfBand != bl) {
                this.val.outOfBand = bl;
                this.changed = true;
            }
        }

        public void setPayloadType(int n) {
            this.create();
            if (this.val.payloadType != n) {
                this.val.payloadType = n;
                this.changed = true;
            }
        }

        public void setMethod(OmiMessage.DTMFMethodType dTMFMethodType) {
            this.create();
            if (this.val.method != dTMFMethodType) {
                this.val.method = dTMFMethodType;
                this.changed = true;
            }
        }

        @Override
        public void setVal(Object object) {
            this.setOutOfBand(((DTMFClass)object).outOfBand);
            this.setPayloadType(((DTMFClass)object).payloadType);
            this.setMethod(((DTMFClass)object).method);
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            omiMessage.addAttrib(OmiMessage.attribIds.outOfBand.name(), this.val.outOfBand);
            omiMessage.addAttrib(OmiMessage.attribIds.payloadType.name(), this.val.payloadType);
            omiMessage.addAttrib(OmiMessage.attribIds.method.name(), this.val.method.name());
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class DTMFClass {
        public boolean outOfBand = false;
        public int payloadType = 0;
        public OmiMessage.DTMFMethodType method = null;

        public DTMFClass() {
        }

        public DTMFClass(boolean bl, int n, OmiMessage.DTMFMethodType dTMFMethodType) {
            this.outOfBand = bl;
            this.payloadType = n;
            this.method = dTMFMethodType;
        }
    }

    private class CommonDataItemRTP
    extends CommonDataItemClass {
        public RTPClass val;

        public CommonDataItemRTP(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
            this.val = null;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new RTPClass(omiMessage.getAttribValInt(OmiMessage.attribIds.portBase.name()), omiMessage.getAttribValInt(OmiMessage.attribIds.packetTime.name()), omiMessage.getAttribValBool(OmiMessage.attribIds.silenceSupp.name()), omiMessage.getAttribValBool(OmiMessage.attribIds.receiverPrecedence.name()), omiMessage.getAttribValBool(OmiMessage.attribIds.comfortNoisePktElim.name()), omiMessage.getAttribValBool(OmiMessage.attribIds.singleCodecReplyInSDP.name()));
            this.val.addCodecsFromMsg(omiMessage);
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val != null) {
                if (omiMessage.getAttribVal(OmiMessage.attribIds.portBase.name()) != null) {
                    this.val.portBase = omiMessage.getAttribValInt(OmiMessage.attribIds.portBase.name());
                }
                if (omiMessage.getAttribVal(OmiMessage.attribIds.packetTime.name()) != null) {
                    this.val.packetTime = omiMessage.getAttribValInt(OmiMessage.attribIds.packetTime.name());
                }
                this.val.silenceSupp = CommonDataHandler.this.updateNotMandatoryBoolean(omiMessage, OmiMessage.attribIds.silenceSupp.name(), this.val.silenceSupp);
                this.val.receiverPrecedence = CommonDataHandler.this.updateNotMandatoryBoolean(omiMessage, OmiMessage.attribIds.receiverPrecedence.name(), this.val.receiverPrecedence);
                this.val.comfNoisePktElim = CommonDataHandler.this.updateNotMandatoryBoolean(omiMessage, OmiMessage.attribIds.comfortNoisePktElim.name(), this.val.comfNoisePktElim);
                this.val.singleCodecReplyInSDP = CommonDataHandler.this.updateNotMandatoryBoolean(omiMessage, OmiMessage.attribIds.singleCodecReplyInSDP.name(), this.val.singleCodecReplyInSDP);
                this.val.addCodecsFromMsg(omiMessage);
                super.updateDataFromMessage(omiMessage);
            } else {
                this.setDataFromMessage(omiMessage);
            }
        }

        @Override
        public RTPClass getVal() {
            return this.val;
        }

        private void create() {
            if (this.val == null) {
                this.val = new RTPClass();
                this.changed = true;
            }
        }

        public void setPortBase(int n) {
            this.create();
            if (this.val.portBase != n) {
                this.val.portBase = n;
                this.changed = true;
            }
        }

        public void setPacketTime(int n) {
            this.create();
            if (this.val.packetTime != n) {
                this.val.packetTime = n;
                this.changed = true;
            }
        }

        public void setSilenceSupp(boolean bl) {
            this.create();
            if (this.val.silenceSupp != bl) {
                this.val.silenceSupp = bl;
                this.changed = true;
            }
        }

        public void setReceiverPrecedence(boolean bl) {
            this.create();
            if (this.val.receiverPrecedence != bl) {
                this.val.receiverPrecedence = bl;
                this.changed = true;
            }
        }

        public void setComfortNoisePktElim(boolean bl) {
            this.create();
            if (this.val.comfNoisePktElim != bl) {
                this.val.comfNoisePktElim = bl;
                this.changed = true;
            }
        }

        public void setSingleCodecReply(boolean bl) {
            this.create();
            if (this.val.singleCodecReplyInSDP != bl) {
                this.val.singleCodecReplyInSDP = bl;
                this.changed = true;
            }
        }

        public void setCodecs(OmiMessage.CodecType[] codecTypeArray) {
            this.create();
            if (this.val.codecs == null) {
                if (codecTypeArray == null) {
                    return;
                }
                this.val.codecs = codecTypeArray;
                this.changed = true;
            } else if (this.val.codecs.length != codecTypeArray.length) {
                this.val.codecs = codecTypeArray;
                this.changed = true;
            } else {
                for (int i = 0; i < codecTypeArray.length; ++i) {
                    if (this.val.codecs[i] == codecTypeArray[i]) continue;
                    this.changed = true;
                }
                this.val.codecs = codecTypeArray;
            }
        }

        @Override
        public void setVal(Object object) {
            this.setPortBase(((RTPClass)object).portBase);
            this.setPacketTime(((RTPClass)object).packetTime);
            this.setSilenceSupp(((RTPClass)object).silenceSupp);
            this.setReceiverPrecedence(((RTPClass)object).receiverPrecedence);
            this.setComfortNoisePktElim(((RTPClass)object).comfNoisePktElim);
            this.setSingleCodecReply(((RTPClass)object).singleCodecReplyInSDP);
            this.setCodecs(((RTPClass)object).codecs);
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            omiMessage.addAttrib(OmiMessage.attribIds.portBase.name(), this.val.portBase);
            omiMessage.addAttrib(OmiMessage.attribIds.packetTime.name(), this.val.packetTime);
            omiMessage.addAttrib(OmiMessage.attribIds.silenceSupp.name(), this.val.silenceSupp);
            omiMessage.addAttrib(OmiMessage.attribIds.receiverPrecedence.name(), this.val.receiverPrecedence);
            omiMessage.addAttrib(OmiMessage.attribIds.comfortNoisePktElim.name(), this.val.comfNoisePktElim);
            omiMessage.addAttrib(OmiMessage.attribIds.singleCodecReplyInSDP.name(), this.val.singleCodecReplyInSDP);
            if (this.val.codecs != null) {
                OmiMessage omiMessage2 = null;
                for (int i = 0; i < this.val.codecs.length; ++i) {
                    omiMessage2 = i == 0 ? omiMessage.addSubElement(OmiMessage.elemIds.codec) : omiMessage2.addElement(OmiMessage.elemIds.codec);
                    omiMessage2.addAttrib(OmiMessage.attribIds.type.name(), this.val.codecs[i].val);
                }
            }
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class RTPClass {
        public int portBase = 0;
        public int packetTime = 0;
        public boolean silenceSupp = false;
        public boolean receiverPrecedence = false;
        public boolean comfNoisePktElim = false;
        public boolean singleCodecReplyInSDP = false;
        public OmiMessage.CodecType[] codecs = null;

        public RTPClass() {
        }

        public RTPClass(int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, OmiMessage.CodecType[] codecTypeArray) {
            this.portBase = n;
            this.packetTime = n2;
            this.silenceSupp = bl;
            this.receiverPrecedence = bl2;
            this.comfNoisePktElim = bl3;
            this.singleCodecReplyInSDP = bl4;
            this.codecs = codecTypeArray;
        }

        public RTPClass(int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.portBase = n;
            this.packetTime = n2;
            this.silenceSupp = bl;
            this.receiverPrecedence = bl2;
            this.comfNoisePktElim = bl3;
            this.singleCodecReplyInSDP = bl4;
            this.codecs = null;
        }

        private void addCodecsFromMsg(OmiMessage omiMessage) {
            OmiMessage omiMessage2;
            int n = 0;
            for (omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
                if (omiMessage2.id != OmiMessage.elemIds.codec) continue;
                ++n;
            }
            if (n > 0) {
                this.codecs = new OmiMessage.CodecType[n];
                int n2 = 0;
                for (omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
                    if (omiMessage2.id != OmiMessage.elemIds.codec) continue;
                    this.codecs[n2] = OmiMessage.CodecType.getCodecFromOMIMsg(omiMessage2.getAttribVal(OmiMessage.attribIds.type.name()));
                    ++n2;
                }
            } else {
                this.codecs = null;
            }
        }
    }

    private class CommonDataItemBackupSIP
    extends CommonDataItemClass {
        BackupSIPClass val;

        CommonDataItemBackupSIP(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
            this.val = null;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new BackupSIPClass(omiMessage.getAttribValBool(OmiMessage.BackupSIPType.failoverActive.name()), omiMessage.getAttribValInt(OmiMessage.BackupSIPType.failoverTime.name()), omiMessage.getAttribVal(OmiMessage.BackupSIPType.secondaryProxyServer.name()), omiMessage.getAttribValInt(OmiMessage.BackupSIPType.secondaryProxyPort.name()), omiMessage.getAttribVal(OmiMessage.BackupSIPType.secondaryRegServer.name()), omiMessage.getAttribValInt(OmiMessage.BackupSIPType.secondaryRegPort.name()), omiMessage.getAttribVal(OmiMessage.BackupSIPType.secondaryOutboundProxyServer.name()), omiMessage.getAttribValInt(OmiMessage.BackupSIPType.secondaryOutboundProxyPort.name()), omiMessage.getAttribVal(OmiMessage.BackupSIPType.tertiaryProxyServer.name()), omiMessage.getAttribValInt(OmiMessage.BackupSIPType.tertiaryProxyPort.name()), omiMessage.getAttribVal(OmiMessage.BackupSIPType.tertiaryRegServer.name()), omiMessage.getAttribValInt(OmiMessage.BackupSIPType.tertiaryRegPort.name()), omiMessage.getAttribVal(OmiMessage.BackupSIPType.tertiaryOutboundProxyServer.name()), omiMessage.getAttribValInt(OmiMessage.BackupSIPType.tertiaryOutboundProxyPort.name()));
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val != null) {
                String string = null;
                this.val.failoverActive = CommonDataHandler.this.updateNotMandatoryBoolean(omiMessage, OmiMessage.BackupSIPType.failoverActive.name(), this.val.failoverActive);
                if (omiMessage.getAttribVal(OmiMessage.BackupSIPType.failoverTime.name()) != null) {
                    this.val.failoverTime = omiMessage.getAttribValInt(OmiMessage.BackupSIPType.failoverTime.name());
                }
                if ((string = omiMessage.getAttribVal(OmiMessage.BackupSIPType.secondaryProxyServer.name())) != null) {
                    this.val.secondaryProxyServer = string;
                }
                if (omiMessage.getAttribVal(OmiMessage.BackupSIPType.secondaryProxyPort.name()) != null) {
                    this.val.secondaryProxyPort = omiMessage.getAttribValInt(OmiMessage.BackupSIPType.secondaryProxyPort.name());
                }
                if ((string = omiMessage.getAttribVal(OmiMessage.BackupSIPType.secondaryRegServer.name())) != null) {
                    this.val.secondaryRegServer = string;
                }
                if (omiMessage.getAttribVal(OmiMessage.BackupSIPType.secondaryRegPort.name()) != null) {
                    this.val.secondaryRegPort = omiMessage.getAttribValInt(OmiMessage.BackupSIPType.secondaryRegPort.name());
                }
                if ((string = omiMessage.getAttribVal(OmiMessage.BackupSIPType.secondaryOutboundProxyServer.name())) != null) {
                    this.val.secondaryOutboundProxyServer = string;
                }
                if (omiMessage.getAttribVal(OmiMessage.BackupSIPType.secondaryOutboundProxyPort.name()) != null) {
                    this.val.secondaryOutboundProxyPort = omiMessage.getAttribValInt(OmiMessage.BackupSIPType.secondaryOutboundProxyPort.name());
                }
                if ((string = omiMessage.getAttribVal(OmiMessage.BackupSIPType.tertiaryProxyServer.name())) != null) {
                    this.val.tertiaryProxyServer = string;
                }
                if (omiMessage.getAttribVal(OmiMessage.BackupSIPType.tertiaryProxyPort.name()) != null) {
                    this.val.tertiaryProxyPort = omiMessage.getAttribValInt(OmiMessage.BackupSIPType.tertiaryProxyPort.name());
                }
                if ((string = omiMessage.getAttribVal(OmiMessage.BackupSIPType.tertiaryRegServer.name())) != null) {
                    this.val.tertiaryRegServer = string;
                }
                if (omiMessage.getAttribVal(OmiMessage.BackupSIPType.tertiaryRegPort.name()) != null) {
                    this.val.tertiaryRegPort = omiMessage.getAttribValInt(OmiMessage.BackupSIPType.tertiaryRegPort.name());
                }
                if ((string = omiMessage.getAttribVal(OmiMessage.BackupSIPType.tertiaryOutboundProxyServer.name())) != null) {
                    this.val.tertiaryOutboundProxyServer = string;
                }
                if (omiMessage.getAttribVal(OmiMessage.BackupSIPType.tertiaryOutboundProxyPort.name()) != null) {
                    this.val.tertiaryOutboundProxyPort = omiMessage.getAttribValInt(OmiMessage.BackupSIPType.tertiaryOutboundProxyPort.name());
                }
                super.updateDataFromMessage(omiMessage);
            } else {
                this.setDataFromMessage(omiMessage);
            }
        }

        @Override
        public BackupSIPClass getVal() {
            return this.val;
        }

        private void create() {
            if (this.val == null) {
                this.val = new BackupSIPClass();
                this.changed = true;
            }
        }

        public void setFailoverActive(boolean bl) {
            this.create();
            if (this.val.failoverActive != bl) {
                this.val.failoverActive = bl;
                this.changed = true;
            }
        }

        public void setFailoverTime(int n) {
            this.create();
            if (this.val.failoverTime != n) {
                this.val.failoverTime = n;
                this.changed = true;
            }
        }

        public void setSecondaryProxyServer(String string) {
            this.create();
            if (this.val.secondaryProxyServer == null) {
                this.val.secondaryProxyServer = string;
                this.changed = true;
            } else if (!this.val.secondaryProxyServer.equals(string)) {
                this.val.secondaryProxyServer = string;
                this.changed = true;
            }
        }

        public void setSecondaryProxyPort(int n) {
            this.create();
            if (this.val.secondaryProxyPort != n) {
                this.val.secondaryProxyPort = n;
                this.changed = true;
            }
        }

        public void setSecondaryRegServer(String string) {
            this.create();
            if (this.val.secondaryRegServer == null) {
                this.val.secondaryRegServer = string;
                this.changed = true;
            } else if (!this.val.secondaryRegServer.equals(string)) {
                this.val.secondaryRegServer = string;
                this.changed = true;
            }
        }

        public void setSecondaryRegPort(int n) {
            this.create();
            if (this.val.secondaryRegPort != n) {
                this.val.secondaryRegPort = n;
                this.changed = true;
            }
        }

        public void setSecondaryOutboundProxyServer(String string) {
            this.create();
            if (this.val.secondaryOutboundProxyServer == null) {
                this.val.secondaryOutboundProxyServer = string;
                this.changed = true;
            } else if (!this.val.secondaryOutboundProxyServer.equals(string)) {
                this.val.secondaryOutboundProxyServer = string;
                this.changed = true;
            }
        }

        public void setSecondaryOutboundProxyPort(int n) {
            this.create();
            if (this.val.secondaryOutboundProxyPort != n) {
                this.val.secondaryOutboundProxyPort = n;
                this.changed = true;
            }
        }

        public void setTertiaryProxyServer(String string) {
            this.create();
            if (this.val.tertiaryProxyServer == null) {
                this.val.tertiaryProxyServer = string;
                this.changed = true;
            } else if (!this.val.tertiaryProxyServer.equals(string)) {
                this.val.tertiaryProxyServer = string;
                this.changed = true;
            }
        }

        public void setTertiaryProxyPort(int n) {
            this.create();
            if (this.val.tertiaryProxyPort != n) {
                this.val.tertiaryProxyPort = n;
                this.changed = true;
            }
        }

        public void setTertiaryRegServer(String string) {
            this.create();
            if (this.val.tertiaryRegServer == null) {
                this.val.tertiaryRegServer = string;
                this.changed = true;
            } else if (!this.val.tertiaryRegServer.equals(string)) {
                this.val.tertiaryRegServer = string;
                this.changed = true;
            }
        }

        public void setTertiaryRegPort(int n) {
            this.create();
            if (this.val.tertiaryRegPort != n) {
                this.val.tertiaryRegPort = n;
                this.changed = true;
            }
        }

        public void setTertiaryOutboundProxyServer(String string) {
            this.create();
            if (this.val.tertiaryOutboundProxyServer == null) {
                this.val.tertiaryOutboundProxyServer = string;
                this.changed = true;
            } else if (!this.val.tertiaryOutboundProxyServer.equals(string)) {
                this.val.tertiaryOutboundProxyServer = string;
                this.changed = true;
            }
        }

        public void setTertiaryOutboundProxyPort(int n) {
            this.create();
            if (this.val.tertiaryOutboundProxyPort != n) {
                this.val.tertiaryOutboundProxyPort = n;
                this.changed = true;
            }
        }

        @Override
        public void setVal(Object object) {
            if (object.getClass() != BackupSIPClass.class) {
                throw new IllegalArgumentException("wrong argument type");
            }
            this.setFailoverActive(((BackupSIPClass)object).failoverActive);
            this.setFailoverTime(((BackupSIPClass)object).failoverTime);
            this.setSecondaryProxyServer(((BackupSIPClass)object).secondaryProxyServer);
            this.setSecondaryProxyPort(((BackupSIPClass)object).secondaryProxyPort);
            this.setSecondaryRegServer(((BackupSIPClass)object).secondaryRegServer);
            this.setSecondaryRegPort(((BackupSIPClass)object).secondaryRegPort);
            this.setSecondaryOutboundProxyServer(((BackupSIPClass)object).secondaryOutboundProxyServer);
            this.setSecondaryOutboundProxyPort(((BackupSIPClass)object).secondaryOutboundProxyPort);
            this.setTertiaryProxyServer(((BackupSIPClass)object).tertiaryProxyServer);
            this.setTertiaryProxyPort(((BackupSIPClass)object).tertiaryProxyPort);
            this.setTertiaryRegServer(((BackupSIPClass)object).tertiaryRegServer);
            this.setTertiaryRegPort(((BackupSIPClass)object).tertiaryRegPort);
            this.setTertiaryOutboundProxyServer(((BackupSIPClass)object).tertiaryOutboundProxyServer);
            this.setTertiaryOutboundProxyPort(((BackupSIPClass)object).tertiaryOutboundProxyPort);
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            omiMessage.addAttrib(OmiMessage.BackupSIPType.failoverActive.name(), this.val.failoverActive);
            omiMessage.addAttrib(OmiMessage.BackupSIPType.failoverTime.name(), this.val.failoverTime);
            if (this.val.secondaryProxyServer != null) {
                omiMessage.addAttrib(OmiMessage.BackupSIPType.secondaryProxyServer.name(), this.val.secondaryProxyServer);
            }
            omiMessage.addAttrib(OmiMessage.BackupSIPType.secondaryProxyPort.name(), this.val.secondaryProxyPort);
            if (this.val.secondaryRegServer != null) {
                omiMessage.addAttrib(OmiMessage.BackupSIPType.secondaryRegServer.name(), this.val.secondaryRegServer);
            }
            omiMessage.addAttrib(OmiMessage.BackupSIPType.secondaryRegPort.name(), this.val.secondaryRegPort);
            if (this.val.secondaryOutboundProxyServer != null) {
                omiMessage.addAttrib(OmiMessage.BackupSIPType.secondaryOutboundProxyServer.name(), this.val.secondaryOutboundProxyServer);
            }
            omiMessage.addAttrib(OmiMessage.BackupSIPType.secondaryOutboundProxyPort.name(), this.val.secondaryOutboundProxyPort);
            if (this.val.tertiaryProxyServer != null) {
                omiMessage.addAttrib(OmiMessage.BackupSIPType.tertiaryProxyServer.name(), this.val.tertiaryProxyServer);
            }
            omiMessage.addAttrib(OmiMessage.BackupSIPType.tertiaryProxyPort.name(), this.val.tertiaryProxyPort);
            if (this.val.tertiaryRegServer != null) {
                omiMessage.addAttrib(OmiMessage.BackupSIPType.tertiaryRegServer.name(), this.val.tertiaryRegServer);
            }
            omiMessage.addAttrib(OmiMessage.BackupSIPType.tertiaryRegPort.name(), this.val.tertiaryRegPort);
            if (this.val.tertiaryOutboundProxyServer != null) {
                omiMessage.addAttrib(OmiMessage.BackupSIPType.tertiaryOutboundProxyServer.name(), this.val.tertiaryOutboundProxyServer);
            }
            omiMessage.addAttrib(OmiMessage.BackupSIPType.tertiaryOutboundProxyPort.name(), this.val.tertiaryOutboundProxyPort);
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class BackupSIPClass {
        public boolean failoverActive = false;
        public int failoverTime = 0;
        public String secondaryProxyServer = null;
        public int secondaryProxyPort = 0;
        public String secondaryRegServer = null;
        public int secondaryRegPort = 0;
        public String secondaryOutboundProxyServer = null;
        public int secondaryOutboundProxyPort = 0;
        public String tertiaryProxyServer = null;
        public int tertiaryProxyPort = 0;
        public String tertiaryRegServer = null;
        public int tertiaryRegPort = 0;
        public String tertiaryOutboundProxyServer = null;
        public int tertiaryOutboundProxyPort = 0;

        public BackupSIPClass() {
        }

        public BackupSIPClass(boolean bl, int n, String string, int n2, String string2, int n3, String string3, int n4, String string4, int n5, String string5, int n6, String string6, int n7) {
            this.failoverActive = bl;
            this.failoverTime = n;
            this.secondaryProxyServer = string;
            this.secondaryProxyPort = n2;
            this.secondaryRegServer = string2;
            this.secondaryRegPort = n3;
            this.secondaryOutboundProxyServer = string3;
            this.secondaryOutboundProxyPort = n4;
            this.tertiaryProxyServer = string4;
            this.tertiaryProxyPort = n5;
            this.tertiaryRegServer = string5;
            this.tertiaryRegPort = n6;
            this.tertiaryOutboundProxyServer = string6;
            this.tertiaryOutboundProxyPort = n7;
        }
    }

    private class CommonDataItemAdvancedSIP
    extends CommonDataItemClass {
        public AdvancedSIPClass val;

        public CommonDataItemAdvancedSIP(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
            this.val = null;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            String string;
            this.val = new AdvancedSIPClass();
            this.val.mwiSubscription = omiMessage.getAttribValBool(OmiMessage.AdvancedSIPType.mwiSubscription.name());
            this.val.userAgentInfo = omiMessage.getAttribValBool(OmiMessage.AdvancedSIPType.userAgentInfo.name());
            this.val.userAgentCompatibility = omiMessage.getAttribValBool(OmiMessage.AdvancedSIPType.userAgentCompatibility.name());
            this.val.xAastraId = omiMessage.getAttribValBool(OmiMessage.AdvancedSIPType.xAastraId.name());
            this.val.dialTerminator = omiMessage.getAttribVal(OmiMessage.AdvancedSIPType.dialTerminator.name());
            this.val.regTimeoutRetryTimer = omiMessage.getAttribValInt(OmiMessage.AdvancedSIPType.regTimeoutRetryTimer.name());
            this.val.regFailedRetryTimer = omiMessage.getAttribValInt(OmiMessage.AdvancedSIPType.regFailedRetryTimer.name());
            this.val.transactionTimer = omiMessage.getAttribValInt(OmiMessage.AdvancedSIPType.transactionTimer.name());
            this.val.blacklistTimeout = omiMessage.getAttribValInt(OmiMessage.AdvancedSIPType.blacklistTimeout.name());
            this.val.callerDetermination = OmiMessage.CallerDeterminationType.getEnumFromString(omiMessage.getAttribVal(OmiMessage.AdvancedSIPType.callerDetermination.name()));
            this.val.multipleRing = omiMessage.getAttribValBool(OmiMessage.AdvancedSIPType.multipleRing.name());
            this.val.callRejectStateCodeUsr = omiMessage.getAttribValInt(OmiMessage.AdvancedSIPType.callRejectStateCodeUsr.name());
            this.val.callRejectStateCodeDev = omiMessage.getAttribValInt(OmiMessage.AdvancedSIPType.callRejectStateCodeDev.name());
            this.val.sessionTimer = omiMessage.getAttribValInt(OmiMessage.AdvancedSIPType.sessionTimer.name());
            this.val.incomingCallTimeout = omiMessage.getAttribValInt(OmiMessage.AdvancedSIPType.incomingCallTimeout.name());
            this.val.removeRoute = omiMessage.getAttribValBool(OmiMessage.AdvancedSIPType.removeRoute.name());
            this.val.mwiSubscriptionPeriod = omiMessage.getAttribValLong(OmiMessage.AdvancedSIPType.mwiSubscriptionPeriod.name());
            if (CommonDataHandler.this.om.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSemiAttendedTransfer)) {
                this.val.sAttTransferMode = OmiMessage.SemiAttendedTransferModeType.valueOf(omiMessage.getAttribVal(OmiMessage.AdvancedSIPType.semiAttendedTransferMode.name()));
                this.val.referToWithReplaces = omiMessage.getAttribValBool(OmiMessage.AdvancedSIPType.referToWithReplaces.name());
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.AdvancedSIPType.contactMatching.name())) != null) {
                try {
                    this.val.contactMatching = OmiMessage.SIPContactMatchingType.valueOf(string);
                }
                catch (Exception exception) {
                    this.val.contactMatching = null;
                }
            }
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val != null) {
                this.val.mwiSubscription = CommonDataHandler.this.updateNotMandatoryBoolean(omiMessage, OmiMessage.AdvancedSIPType.mwiSubscription.name(), this.val.mwiSubscription);
                this.val.userAgentInfo = CommonDataHandler.this.updateNotMandatoryBoolean(omiMessage, OmiMessage.AdvancedSIPType.userAgentInfo.name(), this.val.userAgentInfo);
                this.val.userAgentCompatibility = CommonDataHandler.this.updateNotMandatoryBoolean(omiMessage, OmiMessage.AdvancedSIPType.userAgentCompatibility.name(), this.val.userAgentCompatibility);
                this.val.xAastraId = CommonDataHandler.this.updateNotMandatoryBoolean(omiMessage, OmiMessage.AdvancedSIPType.xAastraId.name(), this.val.xAastraId);
                if (omiMessage.getAttribVal(OmiMessage.AdvancedSIPType.regTimeoutRetryTimer.name()) != null) {
                    this.val.regTimeoutRetryTimer = omiMessage.getAttribValInt(OmiMessage.AdvancedSIPType.regTimeoutRetryTimer.name());
                }
                if (omiMessage.getAttribVal(OmiMessage.AdvancedSIPType.regFailedRetryTimer.name()) != null) {
                    this.val.regFailedRetryTimer = omiMessage.getAttribValInt(OmiMessage.AdvancedSIPType.regFailedRetryTimer.name());
                }
                if (omiMessage.getAttribVal(OmiMessage.AdvancedSIPType.transactionTimer.name()) != null) {
                    this.val.transactionTimer = omiMessage.getAttribValInt(OmiMessage.AdvancedSIPType.transactionTimer.name());
                }
                if (omiMessage.getAttribVal(OmiMessage.AdvancedSIPType.blacklistTimeout.name()) != null) {
                    this.val.blacklistTimeout = omiMessage.getAttribValInt(OmiMessage.AdvancedSIPType.blacklistTimeout.name());
                }
                if (omiMessage.getAttribVal(OmiMessage.AdvancedSIPType.dialTerminator.name()) != null) {
                    this.val.dialTerminator = omiMessage.getAttribVal(OmiMessage.AdvancedSIPType.dialTerminator.name());
                }
                if (omiMessage.getAttribVal(OmiMessage.AdvancedSIPType.callerDetermination.name()) != null) {
                    this.val.callerDetermination = OmiMessage.CallerDeterminationType.getEnumFromString(omiMessage.getAttribVal(OmiMessage.AdvancedSIPType.callerDetermination.name()));
                }
                this.val.multipleRing = CommonDataHandler.this.updateNotMandatoryBoolean(omiMessage, OmiMessage.AdvancedSIPType.multipleRing.name(), this.val.multipleRing);
                if (omiMessage.getAttribVal(OmiMessage.AdvancedSIPType.callRejectStateCodeUsr.name()) != null) {
                    this.val.callRejectStateCodeUsr = omiMessage.getAttribValInt(OmiMessage.AdvancedSIPType.callRejectStateCodeUsr.name());
                }
                if (omiMessage.getAttribVal(OmiMessage.AdvancedSIPType.callRejectStateCodeDev.name()) != null) {
                    this.val.callRejectStateCodeDev = omiMessage.getAttribValInt(OmiMessage.AdvancedSIPType.callRejectStateCodeDev.name());
                }
                if (omiMessage.getAttribVal(OmiMessage.AdvancedSIPType.sessionTimer.name()) != null) {
                    this.val.sessionTimer = omiMessage.getAttribValInt(OmiMessage.AdvancedSIPType.sessionTimer.name());
                }
                if (omiMessage.getAttribVal(OmiMessage.AdvancedSIPType.incomingCallTimeout.name()) != null) {
                    this.val.incomingCallTimeout = omiMessage.getAttribValInt(OmiMessage.AdvancedSIPType.incomingCallTimeout.name());
                }
                this.val.removeRoute = CommonDataHandler.this.updateNotMandatoryBoolean(omiMessage, OmiMessage.AdvancedSIPType.removeRoute.name(), this.val.removeRoute);
                if (omiMessage.getAttribVal(OmiMessage.AdvancedSIPType.mwiSubscriptionPeriod.name()) != null) {
                    this.val.mwiSubscriptionPeriod = omiMessage.getAttribValLong(OmiMessage.AdvancedSIPType.mwiSubscriptionPeriod.name());
                }
                if (CommonDataHandler.this.om.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSemiAttendedTransfer)) {
                    if (omiMessage.getAttribVal(OmiMessage.AdvancedSIPType.semiAttendedTransferMode.name()) != null) {
                        this.val.sAttTransferMode = OmiMessage.SemiAttendedTransferModeType.valueOf(omiMessage.getAttribVal(OmiMessage.AdvancedSIPType.semiAttendedTransferMode.name()));
                    }
                    this.val.referToWithReplaces = CommonDataHandler.this.updateNotMandatoryBoolean(omiMessage, OmiMessage.AdvancedSIPType.referToWithReplaces.name(), this.val.referToWithReplaces);
                }
                if (omiMessage.getAttribVal(OmiMessage.AdvancedSIPType.contactMatching.name()) != null) {
                    this.val.contactMatching = OmiMessage.SIPContactMatchingType.valueOf(omiMessage.getAttribVal(OmiMessage.AdvancedSIPType.contactMatching.name()));
                }
                super.updateDataFromMessage(omiMessage);
            } else {
                this.setDataFromMessage(omiMessage);
            }
        }

        @Override
        public AdvancedSIPClass getVal() {
            return this.val;
        }

        private void create() {
            if (this.val == null) {
                this.val = new AdvancedSIPClass();
                this.changed = true;
            }
        }

        public void setMwiSubscription(boolean bl) {
            this.create();
            if (this.val.mwiSubscription != bl) {
                this.val.mwiSubscription = bl;
                this.changed = true;
            }
        }

        public void setUserAgentInfo(boolean bl) {
            this.create();
            if (this.val.userAgentInfo != bl) {
                this.val.userAgentInfo = bl;
                this.changed = true;
            }
        }

        public void setUserAgentCompability(boolean bl) {
            this.create();
            if (this.val.userAgentCompatibility != bl) {
                this.val.userAgentCompatibility = bl;
                this.changed = true;
            }
        }

        public void setXAastraId(boolean bl) {
            this.create();
            if (this.val.xAastraId != bl) {
                this.val.xAastraId = bl;
                this.changed = true;
            }
        }

        public void setDialTerminator(String string) {
            this.create();
            if (this.val.dialTerminator == null) {
                this.val.dialTerminator = string;
                this.changed = true;
            } else if (!this.val.dialTerminator.equals(string)) {
                this.val.dialTerminator = string;
                this.changed = true;
            }
        }

        public void setRegTimeoutRetryTimer(int n) {
            this.create();
            if (this.val.regTimeoutRetryTimer != n) {
                this.val.regTimeoutRetryTimer = n;
                this.changed = true;
            }
        }

        public void setRegFailedRetryTimer(int n) {
            this.create();
            if (this.val.regFailedRetryTimer != n) {
                this.val.regFailedRetryTimer = n;
                this.changed = true;
            }
        }

        public void setTransactionTimer(int n) {
            this.create();
            if (this.val.transactionTimer != n) {
                this.val.transactionTimer = n;
                this.changed = true;
            }
        }

        public void setBlacklistTimeout(int n) {
            this.create();
            if (this.val.blacklistTimeout != n) {
                this.val.blacklistTimeout = n;
                this.changed = true;
            }
        }

        public void setCallerDetermination(OmiMessage.CallerDeterminationType callerDeterminationType) {
            this.create();
            if (this.val.callerDetermination == null) {
                this.val.callerDetermination = callerDeterminationType;
                this.changed = true;
            } else if (!this.val.callerDetermination.equals((Object)callerDeterminationType)) {
                this.val.callerDetermination = callerDeterminationType;
                this.changed = true;
            }
        }

        public void setMultipleRing(boolean bl) {
            this.create();
            if (this.val.multipleRing != bl) {
                this.val.multipleRing = bl;
                this.changed = true;
            }
        }

        private void setRemoveRoute(boolean bl) {
            this.create();
            if (this.val.removeRoute != bl) {
                this.val.removeRoute = bl;
                this.changed = true;
            }
        }

        public void setMWISubscriptionPeriod(long l) {
            this.create();
            if (this.val.mwiSubscriptionPeriod != l) {
                this.val.mwiSubscriptionPeriod = l;
                this.changed = true;
            }
        }

        public void setSemiAttendedTransferMode(OmiMessage.SemiAttendedTransferModeType semiAttendedTransferModeType) {
            this.create();
            if (this.val.sAttTransferMode == null ? semiAttendedTransferModeType == null : this.val.sAttTransferMode == semiAttendedTransferModeType) {
                return;
            }
            this.val.sAttTransferMode = semiAttendedTransferModeType;
            this.changed = true;
        }

        public void setReferToWithReplaces(boolean bl) {
            this.create();
            if (this.val.referToWithReplaces != bl) {
                this.val.referToWithReplaces = bl;
                this.changed = true;
            }
        }

        public void setCallRejectStateCodeUsr(int n) {
            this.create();
            if (this.val.callRejectStateCodeUsr != n) {
                this.val.callRejectStateCodeUsr = n;
                this.changed = true;
            }
        }

        public void setCallRejectStateCodeDev(int n) {
            this.create();
            if (this.val.callRejectStateCodeDev != n) {
                this.val.callRejectStateCodeDev = n;
                this.changed = true;
            }
        }

        public void setSessionTimer(int n) {
            this.create();
            if (this.val.sessionTimer != n) {
                this.val.sessionTimer = n;
                this.changed = true;
            }
        }

        public void setIncomingCallTimeout(int n) {
            this.create();
            if (this.val.incomingCallTimeout != n) {
                this.val.incomingCallTimeout = n;
                this.changed = true;
            }
        }

        public void setContactMatching(OmiMessage.SIPContactMatchingType sIPContactMatchingType) {
            this.create();
            if (this.val.contactMatching != sIPContactMatchingType) {
                this.val.contactMatching = sIPContactMatchingType;
                this.changed = true;
            }
        }

        @Override
        public void setVal(Object object) {
            if (object.getClass() != AdvancedSIPClass.class) {
                throw new IllegalArgumentException("wrong argument type");
            }
            this.setMwiSubscription(((AdvancedSIPClass)object).mwiSubscription);
            this.setUserAgentInfo(((AdvancedSIPClass)object).userAgentInfo);
            this.setUserAgentCompability(((AdvancedSIPClass)object).userAgentCompatibility);
            this.setXAastraId(((AdvancedSIPClass)object).xAastraId);
            this.setRegTimeoutRetryTimer(((AdvancedSIPClass)object).regTimeoutRetryTimer);
            this.setRegFailedRetryTimer(((AdvancedSIPClass)object).regFailedRetryTimer);
            this.setTransactionTimer(((AdvancedSIPClass)object).transactionTimer);
            this.setBlacklistTimeout(((AdvancedSIPClass)object).blacklistTimeout);
            this.setDialTerminator(((AdvancedSIPClass)object).dialTerminator);
            this.setCallerDetermination(((AdvancedSIPClass)object).callerDetermination);
            this.setMultipleRing(((AdvancedSIPClass)object).multipleRing);
            this.setCallRejectStateCodeUsr(((AdvancedSIPClass)object).callRejectStateCodeUsr);
            this.setCallRejectStateCodeDev(((AdvancedSIPClass)object).callRejectStateCodeDev);
            this.setSessionTimer(((AdvancedSIPClass)object).sessionTimer);
            this.setIncomingCallTimeout(((AdvancedSIPClass)object).incomingCallTimeout);
            this.setContactMatching(((AdvancedSIPClass)object).contactMatching);
            this.setRemoveRoute(((AdvancedSIPClass)object).removeRoute);
            this.setMWISubscriptionPeriod(((AdvancedSIPClass)object).mwiSubscriptionPeriod);
            if (CommonDataHandler.this.om.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSemiAttendedTransfer)) {
                this.setSemiAttendedTransferMode(((AdvancedSIPClass)object).sAttTransferMode);
                this.setReferToWithReplaces(((AdvancedSIPClass)object).referToWithReplaces);
            }
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            omiMessage.addAttrib(OmiMessage.AdvancedSIPType.mwiSubscription.name(), this.val.mwiSubscription);
            omiMessage.addAttrib(OmiMessage.AdvancedSIPType.userAgentInfo.name(), this.val.userAgentInfo);
            omiMessage.addAttrib(OmiMessage.AdvancedSIPType.userAgentCompatibility.name(), this.val.userAgentCompatibility);
            omiMessage.addAttrib(OmiMessage.AdvancedSIPType.xAastraId.name(), this.val.xAastraId);
            omiMessage.addAttrib(OmiMessage.AdvancedSIPType.dialTerminator.name(), this.val.dialTerminator);
            omiMessage.addAttrib(OmiMessage.AdvancedSIPType.regTimeoutRetryTimer.name(), this.val.regTimeoutRetryTimer);
            omiMessage.addAttrib(OmiMessage.AdvancedSIPType.regFailedRetryTimer.name(), this.val.regFailedRetryTimer);
            omiMessage.addAttrib(OmiMessage.AdvancedSIPType.transactionTimer.name(), this.val.transactionTimer);
            omiMessage.addAttrib(OmiMessage.AdvancedSIPType.blacklistTimeout.name(), this.val.blacklistTimeout);
            omiMessage.addAttrib(OmiMessage.AdvancedSIPType.callerDetermination.name(), OmiMessage.CallerDeterminationType.getStringFromEnum(this.val.callerDetermination));
            omiMessage.addAttrib(OmiMessage.AdvancedSIPType.multipleRing.name(), this.val.multipleRing);
            if (CommonDataHandler.this.om.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSemiAttendedTransfer)) {
                omiMessage.addAttrib(OmiMessage.AdvancedSIPType.semiAttendedTransferMode.name(), this.val.sAttTransferMode.name());
                omiMessage.addAttrib(OmiMessage.AdvancedSIPType.referToWithReplaces.name(), this.val.referToWithReplaces);
            }
            omiMessage.addAttrib(OmiMessage.AdvancedSIPType.callRejectStateCodeUsr.name(), this.val.callRejectStateCodeUsr);
            omiMessage.addAttrib(OmiMessage.AdvancedSIPType.callRejectStateCodeDev.name(), this.val.callRejectStateCodeDev);
            omiMessage.addAttrib(OmiMessage.AdvancedSIPType.sessionTimer.name(), this.val.sessionTimer);
            omiMessage.addAttrib(OmiMessage.AdvancedSIPType.incomingCallTimeout.name(), this.val.incomingCallTimeout);
            omiMessage.addAttrib(OmiMessage.AdvancedSIPType.removeRoute.name(), this.val.removeRoute);
            omiMessage.addAttrib(OmiMessage.AdvancedSIPType.mwiSubscriptionPeriod.name(), this.val.mwiSubscriptionPeriod);
            if (this.val.contactMatching != null) {
                omiMessage.addAttrib(OmiMessage.AdvancedSIPType.contactMatching.name(), this.val.contactMatching.name());
            }
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class AdvancedSIPClass {
        public boolean mwiSubscription = false;
        public boolean userAgentInfo = false;
        public boolean userAgentCompatibility = false;
        public boolean xAastraId = false;
        public String dialTerminator = "#";
        public int regTimeoutRetryTimer = 0;
        public int regFailedRetryTimer = 0;
        public int transactionTimer = 0;
        public int blacklistTimeout = 0;
        public OmiMessage.CallerDeterminationType callerDetermination = OmiMessage.CallerDeterminationType.PAssertIdentity;
        public boolean multipleRing = true;
        public OmiMessage.SemiAttendedTransferModeType sAttTransferMode = OmiMessage.SemiAttendedTransferModeType.Blind;
        public boolean referToWithReplaces = false;
        public int callRejectStateCodeUsr = 486;
        public int callRejectStateCodeDev = 486;
        public int sessionTimer = 0;
        public int incomingCallTimeout = 180;
        public OmiMessage.SIPContactMatchingType contactMatching = null;
        public boolean removeRoute = false;
        public long mwiSubscriptionPeriod = 0L;
    }

    private class CommonDataItemBasicSIP
    extends CommonDataItemClass {
        public BasicSIPClass val;

        public CommonDataItemBasicSIP(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
            this.val = null;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new BasicSIPClass(omiMessage.getAttribVal(OmiMessage.BasicSIPType.proxyServer.name()), omiMessage.getAttribValInt(OmiMessage.BasicSIPType.proxyPort.name()), omiMessage.getAttribVal(OmiMessage.BasicSIPType.regServer.name()), omiMessage.getAttribValInt(OmiMessage.BasicSIPType.regPort.name()), omiMessage.getAttribValLong(OmiMessage.BasicSIPType.regPeriod.name()), omiMessage.getAttribVal(OmiMessage.BasicSIPType.sipRegisterCheckNum.name()));
            if (omiMessage.getAttribVal(OmiMessage.BasicSIPType.transportProt.name()) != null) {
                this.val.transportProt = OmiMessage.SIPSecureTransportProtocolType.valueOf(omiMessage.getAttribVal(OmiMessage.BasicSIPType.transportProt.name()));
            }
            this.val.outboundProxyServer = omiMessage.getAttribVal(OmiMessage.BasicSIPType.outboundProxyServer.name());
            this.val.outboundProxyPort = omiMessage.getAttribValInt(OmiMessage.BasicSIPType.outboundProxyPort.name());
            this.val.gruu = omiMessage.getAttribValBoolNotMandatory(OmiMessage.BasicSIPType.gruu.name());
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val != null) {
                String string;
                if (omiMessage.getAttribVal(OmiMessage.BasicSIPType.transportProt.name()) != null) {
                    this.val.transportProt = OmiMessage.SIPSecureTransportProtocolType.valueOf(omiMessage.getAttribVal(OmiMessage.BasicSIPType.transportProt.name()));
                }
                if ((string = omiMessage.getAttribVal(OmiMessage.BasicSIPType.proxyServer.name())) != null) {
                    this.val.proxyServer = string;
                }
                if (omiMessage.getAttribVal(OmiMessage.BasicSIPType.proxyPort.name()) != null) {
                    this.val.proxyPort = omiMessage.getAttribValInt(OmiMessage.BasicSIPType.proxyPort.name());
                }
                if ((string = omiMessage.getAttribVal(OmiMessage.BasicSIPType.outboundProxyServer.name())) != null) {
                    this.val.outboundProxyServer = string;
                }
                if (omiMessage.getAttribVal(OmiMessage.BasicSIPType.outboundProxyPort.name()) != null) {
                    this.val.outboundProxyPort = omiMessage.getAttribValInt(OmiMessage.BasicSIPType.outboundProxyPort.name());
                }
                if ((string = omiMessage.getAttribVal(OmiMessage.BasicSIPType.regServer.name())) != null) {
                    this.val.regServer = string;
                }
                if (omiMessage.getAttribVal(OmiMessage.BasicSIPType.regPort.name()) != null) {
                    this.val.regPort = omiMessage.getAttribValInt(OmiMessage.BasicSIPType.regPort.name());
                }
                if (omiMessage.getAttribVal(OmiMessage.BasicSIPType.regPeriod.name()) != null) {
                    this.val.regPeriod = omiMessage.getAttribValLong(OmiMessage.BasicSIPType.regPeriod.name());
                }
                if ((string = omiMessage.getAttribVal(OmiMessage.BasicSIPType.sipRegisterCheckNum.name())) != null) {
                    this.val.sipRegisterCheckNum = string;
                }
                if (omiMessage.getAttribVal(OmiMessage.BasicSIPType.gruu.name()) != null) {
                    this.val.gruu = omiMessage.getAttribValBool(OmiMessage.BasicSIPType.gruu.name());
                }
                super.updateDataFromMessage(omiMessage);
            } else {
                this.setDataFromMessage(omiMessage);
            }
        }

        @Override
        public BasicSIPClass getVal() {
            return this.val;
        }

        public void setTransportProtocol(OmiMessage.SIPSecureTransportProtocolType sIPSecureTransportProtocolType) {
            if (this.val == null) {
                this.val = new BasicSIPClass();
                this.changed = true;
            }
            if (this.val.transportProt != sIPSecureTransportProtocolType) {
                this.val.transportProt = sIPSecureTransportProtocolType;
                this.changed = true;
            }
        }

        public void setProxyServer(String string) {
            if (this.val == null) {
                this.val = new BasicSIPClass();
                this.changed = true;
            }
            if (this.val.proxyServer == null) {
                this.val.proxyServer = string;
                this.changed = true;
            } else if (!this.val.proxyServer.equals(string)) {
                this.val.proxyServer = string;
                this.changed = true;
            }
        }

        public void setProxyPort(int n) {
            if (this.val == null) {
                this.val = new BasicSIPClass();
                this.changed = true;
            }
            if (this.val.proxyPort != n) {
                this.val.proxyPort = n;
                this.changed = true;
            }
        }

        public void setOutboundProxyServer(String string) {
            if (this.val == null) {
                this.val = new BasicSIPClass();
                this.changed = true;
            }
            if (this.val.outboundProxyServer == null) {
                this.val.outboundProxyServer = string;
                this.changed = true;
            } else if (!this.val.outboundProxyServer.equals(string)) {
                this.val.outboundProxyServer = string;
                this.changed = true;
            }
        }

        public void setOutboundProxyPort(int n) {
            if (this.val == null) {
                this.val = new BasicSIPClass();
                this.changed = true;
            }
            if (this.val.outboundProxyPort != n) {
                this.val.outboundProxyPort = n;
                this.changed = true;
            }
        }

        public void setRegServer(String string) {
            if (this.val == null) {
                this.val = new BasicSIPClass();
                this.changed = true;
            }
            if (this.val.regServer == null) {
                this.val.regServer = string;
                this.changed = true;
            } else if (!this.val.regServer.equals(string)) {
                this.val.regServer = string;
                this.changed = true;
            }
        }

        public void setRegPort(int n) {
            if (this.val == null) {
                this.val = new BasicSIPClass();
                this.changed = true;
            }
            if (this.val.regPort != n) {
                this.val.regPort = n;
                this.changed = true;
            }
        }

        public void setRegPeriod(long l) {
            if (this.val == null) {
                this.val = new BasicSIPClass();
                this.changed = true;
            }
            if (this.val.regPeriod != l) {
                this.val.regPeriod = l;
                this.changed = true;
            }
        }

        public void setGruu(boolean bl) {
            if (this.val == null) {
                this.val = new BasicSIPClass();
                this.changed = true;
            }
            if (this.val.gruu == null) {
                this.val.gruu = bl;
                this.changed = true;
            } else if (this.val.gruu != bl) {
                this.val.gruu = bl;
                this.changed = true;
            }
        }

        @Override
        public void setVal(Object object) {
            if (object.getClass() != BasicSIPClass.class) {
                throw new IllegalArgumentException("wrong argument type");
            }
            this.setTransportProtocol(((BasicSIPClass)object).transportProt);
            this.setProxyServer(((BasicSIPClass)object).proxyServer);
            this.setProxyPort(((BasicSIPClass)object).proxyPort);
            this.setOutboundProxyServer(((BasicSIPClass)object).outboundProxyServer);
            this.setOutboundProxyPort(((BasicSIPClass)object).outboundProxyPort);
            this.setRegServer(((BasicSIPClass)object).regServer);
            this.setRegPort(((BasicSIPClass)object).regPort);
            this.setRegPeriod(((BasicSIPClass)object).regPeriod);
            this.setGruu(((BasicSIPClass)object).gruu);
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            omiMessage.addAttrib(OmiMessage.BasicSIPType.transportProt.name(), this.val.transportProt.name());
            if (this.val.proxyServer != null) {
                omiMessage.addAttrib(OmiMessage.BasicSIPType.proxyServer.name(), this.val.proxyServer);
            }
            omiMessage.addAttrib(OmiMessage.BasicSIPType.proxyPort.name(), this.val.proxyPort);
            if (this.val.outboundProxyServer != null) {
                omiMessage.addAttrib(OmiMessage.BasicSIPType.outboundProxyServer.name(), this.val.outboundProxyServer);
            }
            omiMessage.addAttrib(OmiMessage.BasicSIPType.outboundProxyPort.name(), this.val.outboundProxyPort);
            if (this.val.regServer != null) {
                omiMessage.addAttrib(OmiMessage.BasicSIPType.regServer.name(), this.val.regServer);
            }
            omiMessage.addAttrib(OmiMessage.BasicSIPType.regPort.name(), this.val.regPort);
            omiMessage.addAttrib(OmiMessage.BasicSIPType.regPeriod.name(), this.val.regPeriod);
            if (this.val.gruu != null) {
                omiMessage.addAttrib(OmiMessage.BasicSIPType.gruu.name(), this.val.gruu);
            }
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class BasicSIPClass {
        public OmiMessage.SIPSecureTransportProtocolType transportProt = OmiMessage.SIPSecureTransportProtocolType.UDP;
        public String proxyServer = null;
        public int proxyPort = 0;
        public String outboundProxyServer = null;
        public int outboundProxyPort = 0;
        public String regServer = null;
        public int regPort = 0;
        public long regPeriod = 0L;
        public String sipRegisterCheckNum = null;
        public Boolean gruu = null;

        public BasicSIPClass() {
        }

        public BasicSIPClass(String string, int n, String string2, int n2, long l, String string3) {
            this.proxyServer = string;
            this.proxyPort = n;
            this.regServer = string2;
            this.regPort = n2;
            this.regPeriod = l;
            this.sipRegisterCheckNum = string3;
        }
    }

    private class CommonDataItemUserDataServer
    extends CommonDataItemClass {
        public UserDataServerClass val;

        public CommonDataItemUserDataServer(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
            this.val = null;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new UserDataServerClass();
            this.val.url = new UrlClass(omiMessage.getSubElement());
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            OmiMessage omiMessage2 = omiMessage.getSubElement();
            if (omiMessage2 != null) {
                if (this.val.url != null) {
                    this.val.url.updateFromMsg(omiMessage2);
                } else {
                    this.val.url = new UrlClass(omiMessage2);
                }
            } else {
                this.val.url = null;
            }
            super.updateDataFromMessage(omiMessage);
        }

        @Override
        public UserDataServerClass getVal() {
            return this.val;
        }

        private void create() {
            if (this.val == null) {
                this.val = new UserDataServerClass();
                this.changed = true;
            }
        }

        public void setUrl(UrlClass urlClass) {
            this.create();
            if (urlClass != null) {
                if (this.val.url == null) {
                    this.val.url = new UrlClass();
                }
                this.changed |= this.val.url.updateFromOtherUrl(urlClass);
            }
        }

        @Override
        public void setVal(Object object) {
            if (object.getClass() != UserDataServerClass.class) {
                throw new IllegalArgumentException("wrong argument type");
            }
            this.setUrl(((UserDataServerClass)object).url);
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            if (this.val.url != null) {
                this.val.url.addUrlToMsg(omiMessage);
            }
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class UserDataServerClass {
        public UrlClass url = null;
    }

    private class CommonDataItemWLANRegDomain
    extends CommonDataItemClass {
        public WLANRegDomainElem val;

        public CommonDataItemWLANRegDomain(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            String string = null;
            String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.regDomain.name());
            if (string2 != null) {
                OmiMessage.WlanRegDomainInvalidType wlanRegDomainInvalidType = OmiMessage.WlanRegDomainInvalidType.getInvalidDomainFromAxi(string2);
                string = wlanRegDomainInvalidType != null ? wlanRegDomainInvalidType.getStrTranslated() : string2;
            }
            String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.channels2_4G.name());
            String string4 = omiMessage.getAttribVal(OmiMessage.attribIds.channels5G.name());
            this.val = new WLANRegDomainElem(string, string3, string4);
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            this.setDataFromMessage(omiMessage);
        }

        @Override
        public WLANRegDomainElem getVal() {
            return this.val;
        }

        @Override
        public void setVal(Object object) {
            if (!this.val.domain.equals(((WLANRegDomainElem)object).domain)) {
                this.val.domain = ((WLANRegDomainElem)object).domain;
                this.changed = true;
            }
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            omiMessage.addAttrib(OmiMessage.attribIds.regDomain.name(), this.val.domain);
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class WLANRegDomainElem {
        public String domain = null;
        public int[] channels2_4G = new int[0];
        public int[] channels5G = new int[0];

        public WLANRegDomainElem() {
        }

        public WLANRegDomainElem(String string) {
            this.domain = string;
        }

        public WLANRegDomainElem(String string, int[] nArray, int[] nArray2) {
            this.domain = string;
            this.channels2_4G = nArray;
            this.channels5G = nArray2;
        }

        public WLANRegDomainElem(String string, String string2, String string3) {
            int n;
            String[] stringArray;
            this.domain = string;
            if (string2 != null && !string2.isEmpty()) {
                stringArray = string2.split(",");
                this.channels2_4G = new int[stringArray.length];
                for (n = 0; n < stringArray.length; ++n) {
                    this.channels2_4G[n] = new Integer(stringArray[n]);
                }
            }
            if (string3 != null && !string3.isEmpty()) {
                stringArray = string3.split(",");
                this.channels5G = new int[stringArray.length];
                for (n = 0; n < stringArray.length; ++n) {
                    this.channels5G[n] = new Integer(stringArray[n]);
                }
            }
        }
    }

    private class CommonDataItemWLANRegDomainList
    extends CommonDataItemClass {
        String[] list;

        public CommonDataItemWLANRegDomainList(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, null, elemIds4, null, null);
            this.list = null;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            OmiMessage omiMessage2;
            int n = 0;
            for (omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
                if (omiMessage2.id != OmiMessage.elemIds.regDomain) continue;
                ++n;
            }
            if (n > 0) {
                this.list = new String[n];
                n = 0;
                for (omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
                    if (omiMessage2.id != OmiMessage.elemIds.regDomain) continue;
                    this.list[n] = omiMessage2.getAttribVal(OmiMessage.attribIds.name.name());
                    ++n;
                }
            } else {
                this.list = null;
            }
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            this.setDataFromMessage(omiMessage);
        }

        public String[] getVal() {
            return this.list;
        }

        @Override
        public void clear() {
            super.clear();
            this.list = null;
        }
    }

    private class CommonDataItemDECTRegDomain
    extends CommonDataItemClass {
        public OmiMessage.DECTRegDomainType val;

        public CommonDataItemDECTRegDomain(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            String string = omiMessage.getAttribVal(OmiMessage.attribIds.regDomain.name());
            if (string != null) {
                this.val = OmiMessage.DECTRegDomainType.valueOf(string);
            }
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            this.setDataFromMessage(omiMessage);
        }

        public OmiMessage.DECTRegDomainType getVal() {
            return this.val;
        }

        @Override
        public void setVal(Object object) {
            if (object != this.val) {
                this.val = (OmiMessage.DECTRegDomainType)((Object)object);
                this.changed = true;
            }
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            omiMessage.addAttrib(OmiMessage.attribIds.regDomain.name(), this.val.name());
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    private class CommonDataItemPPLoginVariant
    extends CommonDataItemClass {
        public OmiMessage.PPLoginVariantType val;

        public CommonDataItemPPLoginVariant(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
            this.val = null;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            String string = omiMessage.getAttribVal(OmiMessage.attribIds.login.name());
            if (string != null) {
                this.val = OmiMessage.PPLoginVariantType.valueOf(string);
            }
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            this.setDataFromMessage(omiMessage);
        }

        public OmiMessage.PPLoginVariantType getVal() {
            return this.val;
        }

        @Override
        public void setVal(Object object) {
            if ((OmiMessage.PPLoginVariantType)((Object)object) != this.val) {
                this.val = (OmiMessage.PPLoginVariantType)((Object)object);
                this.changed = true;
            }
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            omiMessage.addAttrib(OmiMessage.attribIds.login.name(), this.val.name());
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    private class CommonDataItemNetParams
    extends CommonDataItemClass {
        public NetParamClass val;

        public CommonDataItemNetParams(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
            this.val = null;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            OmiMessage omiMessage2 = omiMessage.getSubElement();
            if (omiMessage2 != null && omiMessage2.id == OmiMessage.elemIds.net) {
                this.val = new NetParamClass(omiMessage2.getAttribValInt(OmiMessage.NetParamType.voiceToS.name()), omiMessage2.getAttribValInt(OmiMessage.NetParamType.sigToS.name()), omiMessage2.getAttribValInt(OmiMessage.NetParamType.ttl.name()), omiMessage2.getAttribValInt(OmiMessage.NetParamType.voiceEthPrio.name()), omiMessage2.getAttribValInt(OmiMessage.NetParamType.sigEthPrio.name()));
                super.setDataFromMessage(omiMessage);
            }
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val != null) {
                OmiMessage omiMessage2 = omiMessage.getSubElement();
                if (omiMessage2 != null && omiMessage2.id == OmiMessage.elemIds.net) {
                    if (omiMessage2.getAttribVal(OmiMessage.NetParamType.voiceToS.name()) != null) {
                        this.val.voiceToS = omiMessage2.getAttribValInt(OmiMessage.NetParamType.voiceToS.name());
                    }
                    if (omiMessage2.getAttribVal(OmiMessage.NetParamType.sigToS.name()) != null) {
                        this.val.sigToS = omiMessage2.getAttribValInt(OmiMessage.NetParamType.sigToS.name());
                    }
                    if (omiMessage2.getAttribVal(OmiMessage.NetParamType.ttl.name()) != null) {
                        this.val.ttl = omiMessage2.getAttribValInt(OmiMessage.NetParamType.ttl.name());
                    }
                    if (omiMessage2.getAttribVal(OmiMessage.NetParamType.voiceEthPrio.name()) != null) {
                        this.val.voiceEthPrio = omiMessage2.getAttribValInt(OmiMessage.NetParamType.voiceEthPrio.name());
                    }
                    if (omiMessage2.getAttribVal(OmiMessage.NetParamType.sigEthPrio.name()) != null) {
                        this.val.sigEthPrio = omiMessage2.getAttribValInt(OmiMessage.NetParamType.sigEthPrio.name());
                    }
                    super.updateDataFromMessage(omiMessage);
                }
            } else {
                this.setDataFromMessage(omiMessage);
            }
        }

        @Override
        public NetParamClass getVal() {
            return this.val;
        }

        public void setVoiceToS(int n) {
            if (this.val == null) {
                this.val = new NetParamClass();
                this.changed = true;
            }
            if (this.val.voiceToS != n) {
                this.val.voiceToS = n;
                this.changed = true;
            }
        }

        public void setSigToS(int n) {
            if (this.val == null) {
                this.val = new NetParamClass();
                this.changed = true;
            }
            if (this.val.sigToS != n) {
                this.val.sigToS = n;
                this.changed = true;
            }
        }

        public void setTtl(int n) {
            if (this.val == null) {
                this.val = new NetParamClass();
                this.changed = true;
            }
            if (this.val.ttl != n) {
                this.val.ttl = n;
                this.changed = true;
            }
        }

        public void setVoiceEthPrio(int n) {
            if (this.val == null) {
                this.val = new NetParamClass();
                this.changed = true;
            }
            if (this.val.voiceEthPrio != n) {
                this.val.voiceEthPrio = n;
                this.changed = true;
            }
        }

        public void setSigEthPrio(int n) {
            if (this.val == null) {
                this.val = new NetParamClass();
                this.changed = true;
            }
            if (this.val.sigEthPrio != n) {
                this.val.sigEthPrio = n;
                this.changed = true;
            }
        }

        @Override
        public void setVal(Object object) {
            this.setVoiceToS(((NetParamClass)object).voiceToS);
            this.setSigToS(((NetParamClass)object).sigToS);
            this.setTtl(((NetParamClass)object).ttl);
            this.setVoiceEthPrio(((NetParamClass)object).voiceEthPrio);
            this.setSigEthPrio(((NetParamClass)object).sigEthPrio);
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            this.val.appendToMsg(omiMessage);
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class NetParamClass {
        public static final int MaxDiffServ = 63;
        public int voiceToS = 0;
        public int sigToS = 0;
        public int ttl = 0;
        public int voiceEthPrio = 0;
        public int sigEthPrio = 0;

        public NetParamClass() {
        }

        public NetParamClass(int n, int n2, int n3, int n4, int n5) {
            this.voiceToS = n;
            this.sigToS = n2;
            this.ttl = n3;
            this.voiceEthPrio = n4;
            this.sigEthPrio = n5;
        }

        public void appendToMsg(OmiMessage omiMessage) {
            OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.net.name());
            omiMessage2.addAttrib(OmiMessage.NetParamType.voiceToS.name(), this.voiceToS);
            omiMessage2.addAttrib(OmiMessage.NetParamType.sigToS.name(), this.sigToS);
            omiMessage2.addAttrib(OmiMessage.NetParamType.ttl.name(), this.ttl);
            omiMessage2.addAttrib(OmiMessage.NetParamType.voiceEthPrio.name(), this.voiceEthPrio);
            omiMessage2.addAttrib(OmiMessage.NetParamType.sigEthPrio.name(), this.sigEthPrio);
        }
    }

    private class CommonDataItemDECTSubMode
    extends CommonDataItemClass {
        public DECTSubscriptionMode val;

        public CommonDataItemDECTSubMode(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new DECTSubscriptionMode();
            this.val.mode = OmiMessage.DECTSubscriptionModeType.Off;
            String string = omiMessage.getAttribVal(OmiMessage.attribIds.mode.name());
            if (string != null) {
                try {
                    this.val.mode = OmiMessage.DECTSubscriptionModeType.valueOf(string);
                }
                catch (Exception exception) {
                    this.val.mode = null;
                }
            }
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            this.setDataFromMessage(omiMessage);
            super.updateDataFromMessage(omiMessage);
        }

        @Override
        public DECTSubscriptionMode getVal() {
            return this.val;
        }

        @Override
        public void setVal(Object object) {
            if (CommonDataHandler.this.omiHandler != null) {
                DECTSubscriptionMode dECTSubscriptionMode = (DECTSubscriptionMode)object;
                OmiMessage omiMessage = new OmiMessage(this.setId.name());
                omiMessage.addAttrib(OmiMessage.attribIds.mode.name(), dECTSubscriptionMode.mode.name());
                if (dECTSubscriptionMode.mode == OmiMessage.DECTSubscriptionModeType.Wildcard) {
                    omiMessage.addAttrib(OmiMessage.attribIds.timeout.name(), dECTSubscriptionMode.timeout);
                }
                CommonDataHandler.this.omiHandler.sendOmiMessage(omiMessage);
            }
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            omiMessage.addAttrib(OmiMessage.attribIds.mode.name(), this.val.mode.name());
            if (this.val.mode == OmiMessage.DECTSubscriptionModeType.Wildcard) {
                omiMessage.addAttrib(OmiMessage.attribIds.timeout.name(), this.val.timeout);
            }
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class DECTSubscriptionMode {
        public OmiMessage.DECTSubscriptionModeType mode;
        public int timeout;

        public DECTSubscriptionMode() {
        }

        public DECTSubscriptionMode(OmiMessage.DECTSubscriptionModeType dECTSubscriptionModeType, int n) {
            this.mode = dECTSubscriptionModeType;
            this.timeout = n;
        }
    }

    private class CommonDataItemUrl
    extends CommonDataItemClass {
        public UrlClass val;

        public CommonDataItemUrl(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
            this.val = null;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = new UrlClass(omiMessage.getSubElement());
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            if (this.val == null) {
                this.setDataFromMessage(omiMessage);
            } else {
                this.val.enable = CommonDataHandler.this.updateNotMandatoryBoolean(omiMessage, OmiMessage.attribIds.enable.name(), this.val.enable);
                OmiMessage omiMessage2 = omiMessage.getSubElement();
                if (omiMessage2 != null) {
                    if (this.val != null) {
                        this.val.updateFromMsg(omiMessage2);
                    } else {
                        this.val = new UrlClass(omiMessage2);
                    }
                } else {
                    this.val = null;
                }
            }
            super.updateDataFromMessage(omiMessage);
        }

        @Override
        public UrlClass getVal() {
            return this.val;
        }

        private void create() {
            if (this.val == null) {
                this.val = new UrlClass();
                this.changed = true;
            }
        }

        public void setUrl(UrlClass urlClass) {
            this.create();
            if (urlClass != null) {
                if (this.val == null) {
                    this.val = new UrlClass();
                }
                this.changed |= this.val.updateFromOtherUrl(urlClass);
            }
        }

        @Override
        public void setVal(Object object) {
            if (object.getClass() != UrlClass.class) {
                throw new IllegalArgumentException("wrong argument type");
            }
            this.setUrl((UrlClass)object);
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            if (this.val != null) {
                this.val.addUrlToMsg(omiMessage);
            }
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    public static class UrlClass {
        public Boolean enable = null;
        public OmiMessage.ProtType protocol = null;
        public OmiMessage.SslMethodType sslMethod = null;
        public Boolean useCommonCerts = null;
        public String host = null;
        public Integer port = null;
        public String path = null;
        public String username = null;
        public String password = null;
        public boolean passwordChanged = false;
        public String privateKeyPassword = null;
        public boolean privateKeyPasswordChanged = false;
        public Boolean validateCert = null;
        public Boolean validateExpires = null;
        public Boolean validateHostName = null;
        public Boolean importCerts = null;
        public Boolean allowNonConfTrustCerts = null;
        public Integer nTrustedCertificates = null;
        public Integer nLocalCertificates = null;
        public Integer nPrivateKeys = null;
        public Vector<String> trustedCertificates = null;
        public Vector<String> localCertificates = null;
        public Vector<String> privateKeys = null;

        public UrlClass() {
        }

        public UrlClass(OmiMessage.ProtType protType, String string, String string2, String string3, String string4) {
            this.protocol = protType;
            this.host = string;
            this.path = string2;
            this.username = string3;
            this.password = string4;
        }

        public UrlClass(OmiMessage omiMessage) {
            this.enable = false;
            this.protocol = OmiMessage.ProtType.None;
            this.host = null;
            this.path = null;
            this.username = null;
            this.password = null;
            this.updateFromMsg(omiMessage);
        }

        public UrlClass clone() {
            UrlClass urlClass = new UrlClass();
            urlClass.enable = this.enable;
            urlClass.protocol = this.protocol;
            urlClass.sslMethod = this.sslMethod;
            urlClass.useCommonCerts = this.useCommonCerts;
            urlClass.host = this.host;
            urlClass.port = this.port;
            urlClass.path = this.path;
            urlClass.username = this.username;
            urlClass.password = this.password;
            urlClass.passwordChanged = this.passwordChanged;
            urlClass.privateKeyPassword = this.privateKeyPassword;
            urlClass.privateKeyPasswordChanged = this.privateKeyPasswordChanged;
            urlClass.validateCert = this.validateCert;
            urlClass.validateExpires = this.validateExpires;
            urlClass.validateHostName = this.validateHostName;
            urlClass.importCerts = this.importCerts;
            urlClass.allowNonConfTrustCerts = this.allowNonConfTrustCerts;
            urlClass.nTrustedCertificates = this.nTrustedCertificates;
            urlClass.nLocalCertificates = this.nLocalCertificates;
            urlClass.nPrivateKeys = this.nPrivateKeys;
            urlClass.trustedCertificates = this.trustedCertificates;
            urlClass.localCertificates = this.localCertificates;
            urlClass.privateKeys = this.privateKeys;
            return urlClass;
        }

        public void updateFromMsg(OmiMessage omiMessage) {
            if (omiMessage == null) {
                return;
            }
            if (omiMessage.id == OmiMessage.elemIds.url) {
                Integer n;
                String string;
                Boolean bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.URLType.enable.name());
                if (bl != null) {
                    this.enable = bl;
                }
                if ((string = omiMessage.getAttribVal(OmiMessage.URLType.protocol.name())) != null) {
                    this.protocol = OmiMessage.ProtType.valueOf(string);
                }
                if ((string = omiMessage.getAttribVal(OmiMessage.URLType.host.name())) != null) {
                    this.host = string;
                }
                if ((string = omiMessage.getAttribVal(OmiMessage.URLType.path.name())) != null) {
                    this.path = string;
                }
                if ((string = omiMessage.getAttribVal(OmiMessage.URLType.username.name())) != null) {
                    this.username = string;
                }
                if ((string = omiMessage.getAttribVal(OmiMessage.URLType.password.name())) != null) {
                    this.password = string;
                }
                if ((string = omiMessage.getAttribVal(OmiMessage.URLType.port.name())) != null) {
                    this.port = Integer.parseInt(string);
                }
                if ((string = omiMessage.getAttribVal(OmiMessage.URLType.sslMethod.name())) != null) {
                    this.sslMethod = OmiMessage.SslMethodType.protocolValueToEnum(string);
                }
                if ((bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.URLType.useCommonCerts.name())) != null) {
                    this.useCommonCerts = bl;
                }
                if ((bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.URLType.validateCerts.name())) != null) {
                    this.validateCert = bl;
                }
                if ((bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.URLType.validateExpires.name())) != null) {
                    this.validateExpires = bl;
                }
                if ((bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.URLType.validateHostName.name())) != null) {
                    this.validateHostName = bl;
                }
                if ((bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.URLType.importCerts.name())) != null) {
                    this.importCerts = bl;
                }
                if ((bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.URLType.allowNonConfTrustCerts.name())) != null) {
                    this.allowNonConfTrustCerts = bl;
                }
                if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.URLType.nTrustedCertificates.name())) != null) {
                    this.nTrustedCertificates = n;
                }
                if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.URLType.nLocalCertificates.name())) != null) {
                    this.nLocalCertificates = n;
                }
                if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.URLType.nPrivateKeys.name())) != null) {
                    this.nPrivateKeys = n;
                }
            }
        }

        public boolean updateFromOtherUrl(UrlClass urlClass) {
            char[] cArray;
            byte[] byArray;
            boolean bl = false;
            if (this.enable != urlClass.enable) {
                this.enable = urlClass.enable;
                bl = true;
            }
            if (this.protocol != null) {
                if (urlClass.protocol != null && !this.protocol.equals((Object)urlClass.protocol)) {
                    this.protocol = urlClass.protocol;
                    bl = true;
                }
            } else if (urlClass.protocol != null) {
                this.protocol = urlClass.protocol;
                bl = true;
            }
            if (this.port != null) {
                if (urlClass.port != null && this.port != urlClass.port) {
                    this.port = urlClass.port;
                    bl = true;
                }
            } else if (urlClass.port != null) {
                this.port = urlClass.port;
                bl = true;
            }
            if (this.sslMethod != null) {
                if (urlClass.sslMethod != null && !this.sslMethod.equals((Object)urlClass.sslMethod)) {
                    this.sslMethod = urlClass.sslMethod;
                    bl = true;
                }
            } else if (urlClass.sslMethod != null) {
                this.sslMethod = urlClass.sslMethod;
                bl = true;
            }
            if (this.useCommonCerts != null) {
                if (urlClass.useCommonCerts != null && !this.useCommonCerts.equals(urlClass.useCommonCerts)) {
                    this.useCommonCerts = urlClass.useCommonCerts;
                    bl = true;
                }
            } else if (urlClass.useCommonCerts != null) {
                this.useCommonCerts = urlClass.useCommonCerts;
                bl = true;
            }
            if (this.host != null) {
                if (urlClass.host != null && !this.host.equals(urlClass.host)) {
                    this.host = urlClass.host;
                    bl = true;
                }
            } else if (urlClass.host != null) {
                this.host = urlClass.host;
                bl = true;
            }
            if (this.path != null) {
                if (urlClass.path != null && !this.path.equals(urlClass.path)) {
                    this.path = urlClass.path;
                    bl = true;
                }
            } else if (urlClass.path != null) {
                this.path = urlClass.path;
                bl = true;
            }
            if (urlClass.protocol == OmiMessage.ProtType.TFTP && urlClass.username != null) {
                urlClass.username = null;
            }
            if (this.username != null) {
                if (urlClass.username != null) {
                    if (!this.username.equals(urlClass.username)) {
                        this.username = urlClass.username;
                        bl = true;
                    }
                } else {
                    this.username = null;
                    bl = true;
                }
            } else if (urlClass.username != null) {
                this.username = urlClass.username;
                bl = true;
            }
            if (urlClass.passwordChanged) {
                if (urlClass.password != null) {
                    byArray = OmiRSA.encrypt(urlClass.password);
                    if (byArray != null) {
                        cArray = Base64Coder.encode(byArray);
                        this.password = new String(cArray);
                    } else {
                        UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "CommonDataURL: Password encryption failed");
                    }
                } else {
                    this.password = null;
                }
                bl = true;
            }
            if (urlClass.privateKeyPasswordChanged) {
                if (urlClass.privateKeyPassword != null) {
                    byArray = OmiRSA.encrypt(urlClass.privateKeyPassword);
                    if (byArray != null) {
                        cArray = Base64Coder.encode(byArray);
                        this.privateKeyPassword = new String(cArray);
                    } else {
                        UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "CommonDataURL: privateKeyPassword encryption failed");
                    }
                } else {
                    this.privateKeyPassword = null;
                }
                bl = true;
            }
            if (this.validateCert != null) {
                if (urlClass.validateCert != null && !this.validateCert.equals(urlClass.validateCert)) {
                    this.validateCert = urlClass.validateCert;
                    bl = true;
                }
            } else if (urlClass.validateCert != null) {
                this.validateCert = urlClass.validateCert;
                bl = true;
            }
            if (this.validateExpires != null) {
                if (urlClass.validateExpires != null && !this.validateExpires.equals(urlClass.validateExpires)) {
                    this.validateExpires = urlClass.validateExpires;
                    bl = true;
                }
            } else if (urlClass.validateExpires != null) {
                this.validateExpires = urlClass.validateExpires;
                bl = true;
            }
            if (this.validateHostName != null) {
                if (urlClass.validateHostName != null && !this.validateHostName.equals(urlClass.validateHostName)) {
                    this.validateHostName = urlClass.validateHostName;
                    bl = true;
                }
            } else if (urlClass.validateHostName != null) {
                this.validateHostName = urlClass.validateHostName;
                bl = true;
            }
            if (this.importCerts != null) {
                if (urlClass.importCerts != null && !this.importCerts.equals(urlClass.importCerts)) {
                    this.importCerts = urlClass.importCerts;
                    bl = true;
                }
            } else if (urlClass.importCerts != null) {
                this.importCerts = urlClass.importCerts;
                bl = true;
            }
            if (this.allowNonConfTrustCerts != null) {
                if (urlClass.allowNonConfTrustCerts != null && !this.allowNonConfTrustCerts.equals(urlClass.allowNonConfTrustCerts)) {
                    this.allowNonConfTrustCerts = urlClass.allowNonConfTrustCerts;
                    bl = true;
                }
            } else if (urlClass.allowNonConfTrustCerts != null) {
                this.allowNonConfTrustCerts = urlClass.allowNonConfTrustCerts;
                bl = true;
            }
            if (this.trustedCertificates != null) {
                if (urlClass.trustedCertificates != null && !this.trustedCertificates.equals(urlClass.trustedCertificates)) {
                    this.trustedCertificates = urlClass.trustedCertificates;
                    bl = true;
                }
            } else if (urlClass.trustedCertificates != null) {
                this.trustedCertificates = urlClass.trustedCertificates;
                bl = true;
            }
            if (this.localCertificates != null) {
                if (urlClass.localCertificates != null && !this.localCertificates.equals(urlClass.localCertificates)) {
                    this.localCertificates = urlClass.localCertificates;
                    bl = true;
                }
            } else if (urlClass.localCertificates != null) {
                this.localCertificates = urlClass.localCertificates;
                bl = true;
            }
            if (this.privateKeys != null) {
                if (urlClass.privateKeys != null && !this.privateKeys.equals(urlClass.privateKeys)) {
                    this.privateKeys = urlClass.privateKeys;
                    bl = true;
                }
            } else if (urlClass.privateKeys != null) {
                this.privateKeys = urlClass.privateKeys;
                bl = true;
            }
            return bl;
        }

        public void setAndEncryptPrivateKeyPassword(String string) {
            byte[] byArray = OmiRSA.encrypt(string);
            if (byArray != null) {
                char[] cArray = Base64Coder.encode(byArray);
                this.privateKeyPassword = new String(cArray);
            } else {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "CommonDataURL: privateKeyPassword encryption failed");
            }
        }

        private OmiMessage addCertsToMessage(OmiMessage omiMessage, OmiMessage omiMessage2, String string, Vector<String> vector) {
            omiMessage2 = omiMessage2 == null ? omiMessage.addSubElement(string) : omiMessage2.addElement(string);
            Iterator<String> iterator = vector.iterator();
            OmiMessage omiMessage3 = null;
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                if (string2.isEmpty()) continue;
                omiMessage3 = omiMessage3 == null ? omiMessage2.addSubElement(OmiMessage.elemIds.certificate.name()) : omiMessage3.addElement(OmiMessage.elemIds.certificate);
                omiMessage3.addAttrib("key", string2);
            }
            return omiMessage2;
        }

        public void addCertificate(OmiMessage.PEMCertificateListType pEMCertificateListType, String string) {
            Vector<String> vector = null;
            switch (pEMCertificateListType) {
                case trustedCertificates: {
                    if (this.trustedCertificates == null) {
                        this.trustedCertificates = new Vector();
                    }
                    vector = this.trustedCertificates;
                    break;
                }
                case localCertificates: {
                    if (this.localCertificates == null) {
                        this.localCertificates = new Vector();
                    }
                    vector = this.localCertificates;
                    break;
                }
                case privateKey: {
                    if (this.privateKeys == null) {
                        this.privateKeys = new Vector();
                    }
                    vector = this.privateKeys;
                    break;
                }
            }
            if (vector != null && string != null) {
                vector.add(string);
            }
        }

        public boolean addPemFile(String string, OmiMessage.PEMCertificateListType pEMCertificateListType) {
            BufferedReader bufferedReader = null;
            int n = 0;
            try {
                FileReader fileReader = new FileReader(string);
                bufferedReader = new BufferedReader(fileReader);
                String string2 = "";
                String string3 = bufferedReader.readLine();
                byte[] byArray = new byte[]{10, 0};
                String string4 = new String(byArray);
                boolean bl = false;
                boolean bl2 = false;
                while (string3 != null && !bl2) {
                    switch (n) {
                        case 0: {
                            if (!string3.startsWith("-----BEGIN")) break;
                            if (string3.contains("PRIVATE KEY")) {
                                bl = true;
                            }
                            n = 1;
                            string2 = string2 + string3 + string4;
                            break;
                        }
                        case 1: {
                            string2 = string2 + string3 + string4;
                            if (!string3.startsWith("-----END")) break;
                            n = 0;
                            if (bl && pEMCertificateListType == OmiMessage.PEMCertificateListType.privateKey) {
                                this.addCertificate(OmiMessage.PEMCertificateListType.privateKey, string2);
                                bl2 = true;
                            } else {
                                this.addCertificate(pEMCertificateListType, string2);
                            }
                            bl = false;
                            string2 = "";
                        }
                    }
                    string3 = bufferedReader.readLine();
                }
                bufferedReader.close();
                return true;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                iOException.printStackTrace();
            }
            return false;
        }

        public OmiMessage addUrlToMsg(OmiMessage omiMessage) {
            if (omiMessage != null) {
                OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.url.name());
                if (this.enable != null) {
                    omiMessage2.addAttrib(OmiMessage.URLType.enable.name(), this.enable);
                }
                if (this.protocol != null && this.protocol != OmiMessage.ProtType.None) {
                    omiMessage2.addAttrib(OmiMessage.URLType.protocol.name(), this.protocol.name());
                }
                if (this.host != null) {
                    omiMessage2.addAttrib(OmiMessage.URLType.host.name(), this.host);
                }
                if (this.path != null) {
                    omiMessage2.addAttrib(OmiMessage.URLType.path.name(), this.path);
                }
                if (this.username != null) {
                    omiMessage2.addAttrib(OmiMessage.URLType.username.name(), this.username);
                }
                if (this.password != null) {
                    omiMessage2.addAttrib(OmiMessage.URLType.password.name(), this.password);
                }
                if (this.port != null) {
                    omiMessage2.addAttrib(OmiMessage.URLType.port.name(), this.port);
                }
                if (this.sslMethod != null) {
                    omiMessage2.addAttrib(OmiMessage.URLType.sslMethod.name(), this.sslMethod.protocolValue);
                }
                if (this.useCommonCerts != null) {
                    omiMessage2.addAttrib(OmiMessage.URLType.useCommonCerts.name(), this.useCommonCerts);
                }
                if (this.privateKeyPassword != null) {
                    omiMessage2.addAttrib(OmiMessage.URLType.privateKeyPassword.name(), this.privateKeyPassword);
                }
                if (this.validateCert != null) {
                    omiMessage2.addAttrib(OmiMessage.URLType.validateCerts.name(), this.validateCert);
                }
                if (this.validateExpires != null) {
                    omiMessage2.addAttrib(OmiMessage.URLType.validateExpires.name(), this.validateExpires);
                }
                if (this.validateHostName != null) {
                    omiMessage2.addAttrib(OmiMessage.URLType.validateHostName.name(), this.validateHostName);
                }
                if (this.importCerts != null) {
                    omiMessage2.addAttrib(OmiMessage.URLType.importCerts.name(), this.importCerts);
                }
                if (this.allowNonConfTrustCerts != null) {
                    omiMessage2.addAttrib(OmiMessage.URLType.allowNonConfTrustCerts.name(), this.allowNonConfTrustCerts);
                }
                OmiMessage omiMessage3 = null;
                if (this.trustedCertificates != null) {
                    omiMessage3 = this.addCertsToMessage(omiMessage2, omiMessage3, OmiMessage.URLType.trustedCertificates.name(), this.trustedCertificates);
                }
                if (this.localCertificates != null) {
                    omiMessage3 = this.addCertsToMessage(omiMessage2, omiMessage3, OmiMessage.URLType.localCertificates.name(), this.localCertificates);
                }
                if (this.privateKeys != null) {
                    this.addCertsToMessage(omiMessage2, omiMessage3, OmiMessage.URLType.privateKeys.name(), this.privateKeys);
                }
                return omiMessage2;
            }
            return null;
        }

        public String getUrlParamsAsString() {
            Object[] objectArray = new Object[1];
            objectArray[0] = this.enable != null ? (this.enable.booleanValue() ? "enabled" : "disabled") : "unknown";
            return String.format("   url (%s) :\n", objectArray) + String.format("      protocol: \"%s\"\n", this.protocol != null ? this.protocol : "") + String.format("      host: \"%s\"\n", this.host != null ? this.host : "") + String.format("      port: %d\n", this.port) + String.format("      path: \"%s\"\n", this.path != null ? this.path : "") + String.format("      username: \"%s\"\n", this.username != null ? this.username : "");
        }
    }

    private class CommonDataItemBool
    extends CommonDataItemClass {
        public boolean val;
        public OmiMessage.attribIds attrib;

        public CommonDataItemBool(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6, OmiMessage.attribIds attribIds2) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
            this.attrib = attribIds2;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            String string = omiMessage.getAttribVal(this.attrib.name());
            this.val = false;
            if (string != null) {
                this.val = OmilibUtil.interpreteBoolean(string);
            }
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            this.setDataFromMessage(omiMessage);
            super.updateDataFromMessage(omiMessage);
        }

        @Override
        public Boolean getVal() {
            return this.val;
        }

        @Override
        public void setVal(Object object) {
            if (this.val != (Boolean)object) {
                this.val = (Boolean)object;
                this.changed = true;
            }
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            omiMessage.addAttrib(this.attrib.name(), this.val);
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = false;
        }
    }

    private class CommonDataItemInt
    extends CommonDataItemClass {
        public int val;
        public OmiMessage.attribIds attrib;

        public CommonDataItemInt(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6, OmiMessage.attribIds attribIds2) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
            this.attrib = attribIds2;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = Integer.parseInt(omiMessage.getAttribVal(this.attrib.name()));
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            this.val = Integer.parseInt(omiMessage.getAttribVal(this.attrib.name()));
            super.updateDataFromMessage(omiMessage);
        }

        @Override
        public Integer getVal() {
            return this.val;
        }

        @Override
        public void setVal(Object object) {
            if (this.val != (Integer)object) {
                this.val = (Integer)object;
                this.changed = true;
            }
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            omiMessage.addAttrib(this.attrib.name(), this.val);
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = 0;
        }
    }

    private class CommonDataItemString
    extends CommonDataItemClass {
        public String val;
        public OmiMessage.attribIds attrib;

        public CommonDataItemString(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6, OmiMessage.attribIds attribIds2) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6);
            this.attrib = attribIds2;
        }

        public CommonDataItemString(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6, OmiMessage.attribIds attribIds2, OmiMessage.OpenRespAttribType openRespAttribType) {
            super(elemIds2, elemIds3, elemIds4, elemIds5, elemIds6, openRespAttribType);
            this.attrib = attribIds2;
        }

        @Override
        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.val = omiMessage.getAttribVal(this.attrib.name());
            super.setDataFromMessage(omiMessage);
        }

        @Override
        protected void updateDataFromMessage(OmiMessage omiMessage) {
            this.val = omiMessage.getAttribVal(this.attrib.name());
            super.updateDataFromMessage(omiMessage);
        }

        @Override
        public String getVal() {
            return this.val;
        }

        @Override
        public void setVal(Object object) {
            if (this.val != null) {
                if (!this.val.equals(object)) {
                    this.val = (String)object;
                    this.changed = true;
                }
            } else {
                this.val = (String)object;
                this.changed = true;
            }
        }

        @Override
        public OmiMessage BuildSetReq() {
            OmiMessage omiMessage = new OmiMessage(this.setId.name());
            omiMessage.addAttrib(this.attrib.name(), this.val);
            return omiMessage;
        }

        @Override
        public void clear() {
            super.clear();
            this.val = null;
        }
    }

    private class CommonDataItemClass {
        public OmiMessage.elemIds getId;
        public OmiMessage.elemIds setId;
        public OmiMessage.elemIds getRespId;
        public OmiMessage.elemIds setRespId;
        public OmiMessage.elemIds eventId;
        public boolean fetchAtStart = true;
        public OmiMessage.OpenRespAttribType haveAttrib = null;
        public boolean changed = false;
        public boolean available = false;
        private LinkedList<CommonDataNotificationInterface> listenerList = new LinkedList();

        public void registerDataNotificationListener(CommonDataNotificationInterface commonDataNotificationInterface) {
            this.listenerList.add(commonDataNotificationInterface);
        }

        public void deregisterDataNotificationListener(CommonDataNotificationInterface commonDataNotificationInterface) {
            this.listenerList.remove(commonDataNotificationInterface);
        }

        private void GenerateItemDataNotification(DataNotificationEnum dataNotificationEnum, CommonDataItemEnum commonDataItemEnum) {
            if (this.listenerList.size() != 0) {
                for (CommonDataNotificationInterface commonDataNotificationInterface : this.listenerList) {
                    if (commonDataNotificationInterface == null) continue;
                    commonDataNotificationInterface.processCommonDataNotification(dataNotificationEnum, commonDataItemEnum);
                }
            }
        }

        private void GenerateItemErrorNotification(DataNotificationEnum dataNotificationEnum, CommonDataItemEnum commonDataItemEnum, OmiMessage omiMessage) {
            if (this.listenerList.size() != 0) {
                for (CommonDataNotificationInterface commonDataNotificationInterface : this.listenerList) {
                    if (commonDataNotificationInterface == null) continue;
                    commonDataNotificationInterface.processCommonDataErrorNotification(dataNotificationEnum, commonDataItemEnum, omiMessage);
                }
            }
        }

        public CommonDataItemClass(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6) {
            this.getId = elemIds2;
            this.setId = elemIds3;
            this.getRespId = elemIds4;
            this.setRespId = elemIds5;
            this.eventId = elemIds6;
        }

        public CommonDataItemClass(OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.elemIds elemIds5, OmiMessage.elemIds elemIds6, OmiMessage.OpenRespAttribType openRespAttribType) {
            this.getId = elemIds2;
            this.setId = elemIds3;
            this.getRespId = elemIds4;
            this.setRespId = elemIds5;
            this.eventId = elemIds6;
            this.haveAttrib = openRespAttribType;
        }

        public boolean active() {
            if (this.haveAttrib == null) {
                return true;
            }
            return CommonDataHandler.this.om.getOmmAttribBool(this.haveAttrib);
        }

        public OmiMessage BuildGetReq() {
            if (this.getId != null) {
                if (this.haveAttrib == null) {
                    return new OmiMessage(this.getId.name());
                }
                if (CommonDataHandler.this.om.getOmmAttribBool(this.haveAttrib)) {
                    return new OmiMessage(this.getId.name());
                }
            }
            return null;
        }

        public OmiMessage BuildSetReq() {
            return null;
        }

        protected void setDataFromMessage(OmiMessage omiMessage) {
            this.changed = false;
        }

        protected void updateDataFromMessage(OmiMessage omiMessage) {
            this.changed = false;
        }

        public boolean processOmiMessage(OmiMessage omiMessage, CommonDataItemEnum commonDataItemEnum) {
            if (omiMessage.id == this.getRespId) {
                String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    if (this.getId.name().equals(omiMessage.getAttribVal(OmiMessage.attribIds.bad.name()))) {
                        return true;
                    }
                    CommonDataHandler.this.GenerateErrorNotification(DataNotificationEnum.NEW_DATA, commonDataItemEnum, omiMessage);
                    this.GenerateItemErrorNotification(DataNotificationEnum.NEW_DATA, commonDataItemEnum, omiMessage);
                } else {
                    this.setDataFromMessage(omiMessage);
                    this.available = true;
                    CommonDataHandler.this.GenerateDataNotification(DataNotificationEnum.NEW_DATA, commonDataItemEnum);
                    this.GenerateItemDataNotification(DataNotificationEnum.NEW_DATA, commonDataItemEnum);
                }
                return true;
            }
            if (omiMessage.id == this.setRespId || omiMessage.id == this.eventId) {
                String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    CommonDataHandler.this.GenerateErrorNotification(DataNotificationEnum.DATA_CHANGED, commonDataItemEnum, omiMessage);
                    this.GenerateItemErrorNotification(DataNotificationEnum.DATA_CHANGED, commonDataItemEnum, omiMessage);
                } else {
                    this.updateDataFromMessage(omiMessage);
                    this.available = true;
                    this.GenerateItemDataNotification(DataNotificationEnum.NEW_DATA, commonDataItemEnum);
                }
                return true;
            }
            return false;
        }

        public Object getVal() {
            return null;
        }

        public void setVal(Object object) {
        }

        public void clear() {
            this.changed = false;
            this.available = false;
        }

        public void clear(CommonDataItemEnum commonDataItemEnum) {
            this.changed = false;
            this.available = false;
            this.GenerateItemDataNotification(DataNotificationEnum.DATA_DELETED_ALL, commonDataItemEnum);
        }
    }

    public static interface CommonDataNotificationInterface {
        public void processCommonDataNotification(DataNotificationEnum var1, CommonDataItemEnum var2);

        public void processCommonDataErrorNotification(DataNotificationEnum var1, CommonDataItemEnum var2, OmiMessage var3);
    }

    public static enum CommonDataItemEnum {
        Limits(LimitsClass.class),
        SystemName(String.class),
        PublicKey(PublicKeyClass.class),
        RemoteAccess(Boolean.class),
        EULAConfirm(Boolean.class),
        NetParams(NetParamClass.class),
        PARK(String.class),
        InitialPARK(String.class),
        DECTEncryption(Boolean.class),
        DECTRegDomain(OmiMessage.DECTRegDomainType.class),
        DECTAuthCode(String.class),
        PPDevAutoCreate(Boolean.class),
        PPLoginVariant(OmiMessage.PPLoginVariantType.class),
        PPFirmwareUpdate(PPFirmwareUpdateClass.class),
        WLANRegDomainList(String[].class),
        WLANRegDomain(WLANRegDomainElem.class),
        UserDataServer(UserDataServerClass.class),
        BasicSIP(BasicSIPClass.class),
        AdvancedSIP(AdvancedSIPClass.class),
        BackupSIP(BackupSIPClass.class),
        RTP(RTPClass.class),
        DTMF(DTMFClass.class),
        SecureSIP(SecureSIPClass.class),
        SecureSIPCertificate(CertificateClass.class),
        ManualDbBackup(UrlClass.class),
        ManualDbRestore(UrlClass.class),
        AutoDbBackup(UrlClass.class),
        DbTransferState(DbTransferStateClass.class),
        IMA(IMACnfClass.class),
        TimeZoneList(TimeZoneListClass.class),
        TimeZone(String.class),
        TimeZoneDetails(TimeZoneDetailsClass.class),
        ResetTimeZoneDetails(null),
        PagingAreaSize(Integer.class),
        SNMP(SNMPClass.class),
        FACPrefix(String.class),
        FACList(FACListClass.class),
        AutoDbBackupFileName(String.class),
        SyslogCnf(SyslogCnfClass.class),
        FlashMemUsage(Integer.class),
        DECTSubscriptMode(DECTSubscriptionMode.class),
        HealthState(HealthStateClass.class),
        PbxCnf(PbxCnfClass.class),
        License(LicenseClass.class),
        LicenseServer(LicenseServerClass.class),
        RegTrafficShape(RegTrafficShapeClass.class),
        SuplServ(SuplServClass.class),
        ConferenceServerSIP(ConferenceServerSIPClass.class),
        VoiceboxNum(String.class),
        UserMonitoring(UserMonitoringClass.class),
        PPFirmwareUpdateOverview(PPFirmwareUpdateOverviewClass.class),
        BlueToothGlobal(Boolean.class),
        BlueToothSensitivity(BlueToothSensitivityClass.class),
        ToneSchemeType(OmiMessage.ToneSchemeType.class),
        RFPCapture(Boolean.class),
        OMP(UrlClass.class),
        DECTPpSettings(DECTPpSettings.class),
        AdditionalSettings(AdditionalSettingsClass.class),
        SecureSIPCertificateServer(CertificateServer.class),
        RestrictedSubscriptionDuration(Boolean.class),
        SpecialBranding(SpecialBrandingClass.class),
        ConfigUrl(UrlClass.class),
        UsedConfigUrl(UrlClass.class),
        SystemCredentials(SystemCredentialsClass.class),
        SystemProvUpdTrig(SystemProvUpdTrigClass.class),
        PortRangeSIP(PortRangeSIP.class),
        IntercomCallHandlingSIP(IntercomCallHandlingSIPClass.class),
        CoreDumpURL(UrlClass.class),
        NTPServer(NTPServerCnfClass.class),
        ParkServerResult(String.class),
        OmmCertificate(CertificateClass.class),
        SoftwareImageUrl(UrlClass.class),
        PPFirmwareUrl(UrlClass.class),
        PreserveUserDeviceRelation(Boolean.class),
        SecurePROVCertificateServer(CertificateServer.class),
        SecureOMMCertificateServer(CertificateServer.class),
        RemoteSystemDump(RemoteSystemDumpClass.class),
        SARI(String.class),
        UserDeviceSyncOMM(UserDeviceSyncOMMClass.class),
        DECTPowerLimit(Boolean.class),
        ClientInfo(String.class),
        MOMControlState(String.class),
        Supplicant(Boolean.class),
        SupplicantCertificate(CertificateClass.class),
        SupplicantCertificateServer(CertificateServer.class),
        GDPRCompliance(GDPRComplianceClass.class);

        public Class<?> dataClass;

        private CommonDataItemEnum(Class<?> clazz) {
            this.dataClass = clazz;
        }
    }
}

