/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.LDAPDataHandler;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;
import com.aastra.omilib.XMLApplicationHandler;
import com.aastra.util.UtilSpy;
import java.util.LinkedList;

public class CorpDirDataHandler
implements OmiManagementEventInterface,
OmiMessageInterface {
    public static final int INVALID_ID = -1;
    private LDAPDataHandler ldapHandler = null;
    private XMLApplicationHandler xmlHandler = null;
    private CorpDirDatabase db = new CorpDirDatabase();
    private LinkedList<CorpDirDataNotificationInterface> listenerList = new LinkedList();
    private static String[] fieldNames = new String[]{"id", "type", "active", "order", "name", "server", "referenceId"};

    public CorpDirDataHandler(OmiManagement omiManagement, LDAPDataHandler lDAPDataHandler, XMLApplicationHandler xMLApplicationHandler) {
        omiManagement.registerManagementEventListener(this);
        this.ldapHandler = lDAPDataHandler;
        this.xmlHandler = xMLApplicationHandler;
        OmiMessage.elemIds.GetLDAPResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.CreateLDAPResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetLDAPResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.DeleteLDAPResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventLDAPCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetXMLApplicationResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.CreateXMLApplicationResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetXMLApplicationResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.DeleteXMLApplicationResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventXMLApplicationCnf.registerDataNotificationListener(this);
    }

    public Database getDb() {
        return this.db;
    }

    public int getNumberOfCorpDirEntries() {
        return this.db.getRecordNumber();
    }

    public CorpDirRecord getCorpDirRecordById(int n) {
        CorpDirRecord corpDirRecord = this.db.getRecordById(n);
        return corpDirRecord;
    }

    public CorpDirRecord getCorpDirRecordByTableIdx(int n) {
        CorpDirRecord corpDirRecord = this.db.getRecordByIdx(n);
        return corpDirRecord;
    }

    public int getCorpDirIdByLDAPId(int n) {
        return this.db.getCorpDirIdByLDAPId(n);
    }

    public int getCorpDirIdByXMLId(int n) {
        return this.db.getCorpDirIdByXMLId(n);
    }

    @Override
    public void processOmiMessage(OmiMessage omiMessage) {
        String string = null;
        OmiMessage omiMessage2 = null;
        int n = 0;
        switch (omiMessage.id) {
            case GetLDAPResp: {
                for (omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
                    if (this.processLDAPElem(omiMessage2, DataNotificationEnum.NEW_DATA)) {
                        ++n;
                        continue;
                    }
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "GetLDAPResp no LDAP elem");
                }
                if (n <= 5) break;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "GetLDAPResp contains more LDAP elems than allowed");
                break;
            }
            case CreateLDAPResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    this.GenerateErrorNotification(-1, DataNotificationEnum.NEW_DATA, omiMessage);
                    break;
                }
                omiMessage2 = omiMessage.getSubElement();
                if (omiMessage2 != null && this.processLDAPElem(omiMessage2, DataNotificationEnum.NEW_DATA)) break;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "CreateLDAPResp no LDAP elem");
                break;
            }
            case DeleteLDAPResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string == null) break;
                int n2 = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
                int n3 = this.db.getCorpDirIdByLDAPId(n2);
                this.GenerateErrorNotification(n3, DataNotificationEnum.DATA_DELETED, omiMessage);
                break;
            }
            case SetLDAPResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    int n4 = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
                    int n5 = this.db.getCorpDirIdByLDAPId(n4);
                    this.GenerateErrorNotification(n5, DataNotificationEnum.DATA_CHANGED, omiMessage);
                    break;
                }
                omiMessage2 = omiMessage.getSubElement();
                if (omiMessage2 != null && this.processLDAPElem(omiMessage2, DataNotificationEnum.DATA_CHANGED)) break;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "SetLDAPResp no LDAP elem");
                break;
            }
            case EventLDAPCnf: {
                omiMessage2 = omiMessage.getSubElement();
                if (omiMessage2 != null) {
                    boolean bl = omiMessage.getAttribValBool(OmiMessage.attribIds.deleted.name());
                    if (bl) {
                        if (omiMessage2.id == OmiMessage.elemIds.ldap) {
                            int n6 = omiMessage2.getAttribValInt(OmiMessage.LDAPNewType.id.name());
                            int n7 = this.db.getCorpDirIdByLDAPId(n6);
                            this.db.delete(n7);
                            this.GenerateDataNotification(n7, DataNotificationEnum.DATA_DELETED);
                            break;
                        }
                    } else if (this.processLDAPElem(omiMessage2, DataNotificationEnum.DATA_CHANGED)) break;
                }
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "EventLDAPCnf no LDAP elem");
                break;
            }
            case GetXMLApplicationResp: {
                if (omiMessage2 != null) {
                    for (omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
                        if (this.processXMLApplElem(omiMessage2, DataNotificationEnum.NEW_DATA)) {
                            ++n;
                            continue;
                        }
                        UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "GetXMLApplicationResp contains wrong element");
                    }
                    if (n <= 30) break;
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "GetXMLApplicationResp contains more elements than allowed");
                    break;
                }
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "GetXMLApplicationResp contains no element");
                break;
            }
            case CreateXMLApplicationResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    this.GenerateErrorNotification(-1, DataNotificationEnum.NEW_DATA, omiMessage);
                    break;
                }
                omiMessage2 = omiMessage.getSubElement();
                if (omiMessage2 != null && this.processXMLApplElem(omiMessage2, DataNotificationEnum.NEW_DATA)) break;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "CreateXMLApplicationResp contains no elements");
                break;
            }
            case DeleteXMLApplicationResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string == null) break;
                int n8 = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
                int n9 = this.db.getCorpDirIdByXMLId(n8);
                this.GenerateErrorNotification(n9, DataNotificationEnum.DATA_DELETED, omiMessage);
                break;
            }
            case SetXMLApplicationResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    int n10 = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
                    int n11 = this.db.getCorpDirIdByXMLId(n10);
                    this.GenerateErrorNotification(n11, DataNotificationEnum.DATA_CHANGED, omiMessage);
                    break;
                }
                omiMessage2 = omiMessage.getSubElement();
                if (omiMessage2 != null && this.processXMLApplElem(omiMessage2, DataNotificationEnum.DATA_CHANGED)) break;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "SetXMLApplicationResp contains no elements");
                break;
            }
            case EventXMLApplicationCnf: {
                omiMessage2 = omiMessage.getSubElement();
                if (omiMessage2 != null) {
                    boolean bl = omiMessage.getAttribValBool(OmiMessage.attribIds.deleted.name());
                    if (bl) {
                        if (omiMessage2.id == OmiMessage.elemIds.xmlAppl && omiMessage2.getAttribVal(OmiMessage.XMLApplicationType.type.name()) != null) {
                            if (OmiMessage.XMLApplicationTypeType.valueOf(omiMessage2.getAttribVal(OmiMessage.XMLApplicationType.type.name())) != OmiMessage.XMLApplicationTypeType.CorpDir) break;
                            if (omiMessage2.getAttribVal(OmiMessage.XMLApplicationType.id.name()) != null) {
                                int n12 = omiMessage2.getAttribValInt(OmiMessage.XMLApplicationType.id.name());
                                int n13 = this.db.getCorpDirIdByXMLId(n12);
                                this.db.delete(n13);
                                this.GenerateDataNotification(n13, DataNotificationEnum.DATA_DELETED);
                                break;
                            }
                        }
                    } else if (this.processXMLApplElem(omiMessage2, DataNotificationEnum.DATA_CHANGED)) break;
                }
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "EventXMLApplicationCnf invalid");
                break;
            }
        }
    }

    private boolean processLDAPElem(OmiMessage omiMessage, DataNotificationEnum dataNotificationEnum) {
        if (omiMessage.id == OmiMessage.elemIds.ldap) {
            String string;
            String string2;
            Integer n;
            int n2 = omiMessage.getAttribValInt(OmiMessage.LDAPNewType.id.name());
            CorpDirRecord corpDirRecord = this.db.getRecordByLDAPId(n2);
            if (corpDirRecord == null) {
                corpDirRecord = new CorpDirRecord();
                corpDirRecord.relatedId = n2;
            }
            corpDirRecord.type = CorpDirTypeType.LDAP;
            Boolean bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.LDAPNewType.active.name());
            if (bl != null) {
                corpDirRecord.active = bl;
            }
            if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.LDAPNewType.order.name())) != null) {
                corpDirRecord.order = n;
            }
            if ((string2 = omiMessage.getAttribVal(OmiMessage.LDAPNewType.name.name())) != null) {
                corpDirRecord.name = string2;
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.LDAPNewType.server.name())) != null) {
                corpDirRecord.server = string;
            }
            this.db.add(corpDirRecord);
            this.GenerateDataNotification(n2, dataNotificationEnum);
            return true;
        }
        return false;
    }

    private boolean processXMLApplElem(OmiMessage omiMessage, DataNotificationEnum dataNotificationEnum) {
        if (omiMessage.id == OmiMessage.elemIds.xmlAppl) {
            OmiMessage omiMessage2;
            String string;
            if (omiMessage.getAttribVal(OmiMessage.XMLApplicationType.type.name()) != null && OmiMessage.XMLApplicationTypeType.valueOf(omiMessage.getAttribVal(OmiMessage.XMLApplicationType.type.name())) != OmiMessage.XMLApplicationTypeType.CorpDir) {
                return true;
            }
            int n = omiMessage.getAttribValInt(OmiMessage.XMLApplicationType.id.name());
            CorpDirRecord corpDirRecord = this.db.getRecordByXMLId(n);
            if (corpDirRecord == null) {
                corpDirRecord = new CorpDirRecord();
                corpDirRecord.relatedId = n;
            }
            corpDirRecord.type = CorpDirTypeType.XML;
            Boolean bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.XMLApplicationType.enable.name());
            if (bl != null) {
                corpDirRecord.active = bl;
            }
            if (omiMessage.getAttribVal(OmiMessage.XMLApplicationType.corpDirOrder.name()) != null) {
                corpDirRecord.order = omiMessage.getAttribValInt(OmiMessage.XMLApplicationType.corpDirOrder.name());
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.XMLApplicationType.name.name())) != null) {
                corpDirRecord.name = string;
            }
            if ((omiMessage2 = omiMessage.getSubElement()) != null) {
                CommonDataHandler.UrlClass urlClass = new CommonDataHandler.UrlClass();
                urlClass.updateFromMsg(omiMessage2);
                corpDirRecord.server = urlClass.host;
            }
            this.db.add(corpDirRecord);
            this.GenerateDataNotification(n, dataNotificationEnum);
            return true;
        }
        return false;
    }

    public void sendCreateLDAP(LDAPDataHandler.LDAPRecord lDAPRecord) {
        this.ldapHandler.sendCreateLDAP(lDAPRecord);
    }

    public void sendSetLDAP(LDAPDataHandler.LDAPRecord lDAPRecord) {
        this.ldapHandler.sendSetLDAP(lDAPRecord);
    }

    public void sendDeleteLDAP(int n) {
        this.ldapHandler.sendDeleteLDAP(n);
    }

    public void sendCreateXMLAppl(XMLApplicationHandler.XMLApplRec xMLApplRec) {
        xMLApplRec.type = OmiMessage.XMLApplicationTypeType.CorpDir;
        this.xmlHandler.sendCreateXMLAppl(xMLApplRec);
    }

    public void sendSetXMLAppl(XMLApplicationHandler.XMLApplRec xMLApplRec) {
        this.xmlHandler.sendSetXMLAppl(xMLApplRec);
    }

    public void sendDeleteXMLAppl(int n) {
        this.xmlHandler.sendDeleteXMLAppl(n);
    }

    public LDAPDataHandler.LDAPRecord getLDAPRecordByLDAPId(int n) {
        return this.ldapHandler.getLDAPRecordById(n);
    }

    public XMLApplicationHandler.XMLApplRec getXMLRecordByXMLId(int n) {
        return this.xmlHandler.getXMLApplRecordById(n);
    }

    @Override
    public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
        if (omiManagementEventEnum == OmiManagementEventEnum.LINK_READY) {
            this.db.clearAll();
        }
    }

    public void registerDataNotificationListener(CorpDirDataNotificationInterface corpDirDataNotificationInterface) {
        this.listenerList.add(corpDirDataNotificationInterface);
    }

    public void deregisterDataNotificationListener(CorpDirDataNotificationInterface corpDirDataNotificationInterface) {
        this.listenerList.remove(corpDirDataNotificationInterface);
    }

    private void GenerateDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generate corporate directory DataNotification - no Device Listener");
        }
        for (CorpDirDataNotificationInterface corpDirDataNotificationInterface : this.listenerList) {
            if (corpDirDataNotificationInterface == null) continue;
            corpDirDataNotificationInterface.processCorpDirDataNotification(n, dataNotificationEnum);
        }
    }

    private void GenerateErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generate corporate directory ErrorNotification - no Device Listener");
        }
        for (CorpDirDataNotificationInterface corpDirDataNotificationInterface : this.listenerList) {
            if (corpDirDataNotificationInterface == null) continue;
            corpDirDataNotificationInterface.processCorpDirErrorNotification(n, dataNotificationEnum, omiMessage);
        }
    }

    public static class CorpDirDatabase
    extends Database {
        public static final int MAX_ENTRIES = 5;
        CorpDirRecord[] recs = new CorpDirRecord[5];
        int[] idxRecs = new int[5];
        int noOfRecs = 0;

        @Override
        public CorpDirRecord getRecordByIdx(int n) {
            if (n >= 0 && n < this.noOfRecs) {
                return this.recs[this.idxRecs[n]];
            }
            return null;
        }

        private CorpDirRecord getRecordById(int n) {
            if (n >= 0 && n < 5) {
                return this.recs[n];
            }
            return null;
        }

        private CorpDirRecord getRecordByLDAPId(int n) {
            for (int i = 0; i < 5; ++i) {
                if (this.recs[i] == null || this.recs[i].type != CorpDirTypeType.LDAP || this.recs[i].relatedId != n) continue;
                return this.recs[i];
            }
            return null;
        }

        private int getCorpDirIdByLDAPId(int n) {
            CorpDirRecord corpDirRecord = this.getRecordByLDAPId(n);
            if (corpDirRecord != null) {
                return corpDirRecord.id;
            }
            return -1;
        }

        private CorpDirRecord getRecordByXMLId(int n) {
            for (int i = 0; i < 5; ++i) {
                if (this.recs[i] == null || this.recs[i].type != CorpDirTypeType.XML || this.recs[i].relatedId != n) continue;
                return this.recs[i];
            }
            return null;
        }

        private int getCorpDirIdByXMLId(int n) {
            CorpDirRecord corpDirRecord = this.getRecordByXMLId(n);
            if (corpDirRecord != null) {
                return corpDirRecord.id;
            }
            return -1;
        }

        @Override
        public int getRecordNumber() {
            return this.noOfRecs;
        }

        @Override
        public void updateIndex() {
            this.noOfRecs = 0;
            for (int i = 0; i < 5; ++i) {
                if (this.recs[i] == null) continue;
                this.idxRecs[this.noOfRecs++] = i;
            }
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }

        public void add(CorpDirRecord corpDirRecord) {
            if (corpDirRecord.id == -1) {
                for (int i = 0; i < 5; ++i) {
                    if (this.recs[i] != null) continue;
                    corpDirRecord.id = i;
                    this.recs[i] = corpDirRecord;
                    this.updateIndex();
                    return;
                }
            } else {
                this.recs[corpDirRecord.id] = corpDirRecord;
                this.updateIndex();
            }
        }

        public void delete(int n) {
            if (n == -1 || n > 5) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, String.format("Deleting corp. dir.: id[%d] invalid", n));
                return;
            }
            if (this.recs[n] == null) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, String.format("Deleting corp. dir. entry[%d] failed: Entry does not exist.", n));
                return;
            }
            this.recs[n] = null;
            this.updateIndex();
        }

        public void clearAll() {
            for (int i = 0; i < this.noOfRecs; ++i) {
                if (this.recs[i] == null) continue;
                this.recs[i] = null;
            }
            this.noOfRecs = 0;
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }

        @Override
        public String[] getFieldNames() {
            return fieldNames;
        }
    }

    public static class CorpDirRecord
    extends DataRecord {
        public static final int IDX_ID = 0;
        public static final int IDX_TYPE = 1;
        public static final int IDX_ACTIVE = 2;
        public static final int IDX_ORDER = 3;
        public static final int IDX_NAME = 4;
        public static final int IDX_SERVER = 5;
        public static final int IDX_RELATED_ID = 6;
        public static final int NUMBER_OF_FIELDS = 7;
        public int id = -1;
        public CorpDirTypeType type;
        public boolean active;
        public int order;
        public String name;
        public String server;
        public int relatedId;

        public CorpDirRecord() {
            this.id = -1;
        }

        public CorpDirRecord(int n) {
            this.id = n;
        }

        @Override
        public Object getField(int n) {
            switch (n) {
                case 0: {
                    return this.id;
                }
                case 1: {
                    return this.type;
                }
                case 2: {
                    return this.active;
                }
                case 3: {
                    return this.order;
                }
                case 4: {
                    return this.name;
                }
                case 5: {
                    return this.server;
                }
                case 6: {
                    return this.relatedId;
                }
            }
            return null;
        }

        @Override
        public CorpDirRecord clone() {
            CorpDirRecord corpDirRecord = new CorpDirRecord();
            corpDirRecord.id = this.id;
            corpDirRecord.type = this.type;
            corpDirRecord.active = this.active;
            corpDirRecord.order = this.order;
            corpDirRecord.name = this.name;
            corpDirRecord.server = this.server;
            corpDirRecord.relatedId = this.relatedId;
            return corpDirRecord;
        }

        public static void setTableHeaderText(int n, String string) {
            if (n >= 0 && n < 7) {
                fieldNames[n] = string;
            }
        }
    }

    public static enum CorpDirTypeType {
        LDAP,
        XML;

    }

    public static interface CorpDirDataNotificationInterface {
        public void processCorpDirDataNotification(int var1, DataNotificationEnum var2);

        public void processCorpDirErrorNotification(int var1, DataNotificationEnum var2, OmiMessage var3);
    }
}

