/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.Base64Coder;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.OmiHandler;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;
import com.aastra.omilib.OmiRSA;
import com.aastra.util.UtilSpy;
import java.util.LinkedList;

public class CorporateDirectoryHandler
implements OmiMessageInterface,
OmiManagementEventInterface {
    public static final int MAX_CORPORATE_DIRECTORIES = 5;
    private OmiManagement omiManagement = null;
    private OmiHandler omiHandler = null;
    private DirectoryDatabase db = new DirectoryDatabase();
    private LinkedList<CorporateDirectoryDataNotificationInterface> listenerList = new LinkedList();
    private static String[] fieldNames = new String[]{"id", "type", "active", "name", "search type", "display type", "time out", "search base", "url", "order"};

    public CorporateDirectoryHandler(OmiManagement omiManagement) {
        this.omiManagement = omiManagement;
        this.omiHandler = this.omiManagement.getOmiHandler();
        this.omiManagement.registerManagementEventListener(this);
        OmiMessage.elemIds.GetCorporateDirectoryResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetCorporateDirectoryResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventCorporateDirectoryCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetCorporateDirectoryOrderResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetCorporateDirectoryOrderResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventCorporateDirectoryOrderCnf.registerDataNotificationListener(this);
    }

    public CorporateDirectoryRecord getDirectoryRecordById(int n) {
        return this.db.getRecordById(n);
    }

    public CorporateDirectoryRecord getDirectoryRecordByOrder(int n) {
        return this.db.getRecordByOrder(n);
    }

    public CorporateDirectoryRecord getDirectoryRecordByTableIdx(int n) {
        return this.db.getRecordByIdx(n);
    }

    public boolean setDirectoryRecord(CorporateDirectoryRecord corporateDirectoryRecord) {
        return this.db.setRecord(corporateDirectoryRecord);
    }

    public void registerDataNotificationListener(CorporateDirectoryDataNotificationInterface corporateDirectoryDataNotificationInterface) {
        this.listenerList.add(corporateDirectoryDataNotificationInterface);
    }

    public void deregisterDataNotificationListener(CorporateDirectoryDataNotificationInterface corporateDirectoryDataNotificationInterface) {
        this.listenerList.remove(corporateDirectoryDataNotificationInterface);
    }

    private void GenerateDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generate corporate directory DataNotification - no Device Listener");
        }
        for (CorporateDirectoryDataNotificationInterface corporateDirectoryDataNotificationInterface : this.listenerList) {
            if (corporateDirectoryDataNotificationInterface == null) continue;
            corporateDirectoryDataNotificationInterface.processCorporateDirectoryDataNotification(n, dataNotificationEnum);
        }
    }

    private void GenerateErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generate corporate directory ErrorNotification - no Device Listener");
        }
        for (CorporateDirectoryDataNotificationInterface corporateDirectoryDataNotificationInterface : this.listenerList) {
            if (corporateDirectoryDataNotificationInterface == null) continue;
            corporateDirectoryDataNotificationInterface.processCorporateDirectoryErrorNotification(n, dataNotificationEnum, omiMessage);
        }
    }

    public DirectoryDatabase getDb() {
        return this.db;
    }

    public boolean checkCorporateDirectoryId(int n) {
        if (n <= 0 || n > 5) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "corporate directory - id[" + n + "] out of range");
            return false;
        }
        return true;
    }

    private boolean sendGetCorporateDirectory(int n) {
        if (!this.checkCorporateDirectoryId(n)) {
            return false;
        }
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetCorporateDirectory);
        omiMessage.addAttrib(OmiMessage.attribIds.id.name(), n);
        this.omiHandler.sendOmiMessage(omiMessage);
        return true;
    }

    public void sendSetCorporateDirectory(CorporateDirectoryRecord corporateDirectoryRecord) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.SetCorporateDirectory);
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), corporateDirectoryRecord.id);
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.directory);
        omiMessage2.addAttrib(OmiMessage.CorporateDirectoryType.id.name(), corporateDirectoryRecord.id);
        omiMessage2.addAttrib(OmiMessage.CorporateDirectoryType.active.name(), corporateDirectoryRecord.active);
        omiMessage2.addAttrib(OmiMessage.CorporateDirectoryType.type.name(), OmiMessage.CorporateDirectoryTypeType.getValFromTxt(corporateDirectoryRecord.type).name());
        if (corporateDirectoryRecord.name != null) {
            omiMessage2.addAttrib(OmiMessage.CorporateDirectoryType.name.name(), corporateDirectoryRecord.name);
        }
        if (corporateDirectoryRecord.searchType != null) {
            omiMessage2.addAttrib(OmiMessage.CorporateDirectoryType.searchType.name(), corporateDirectoryRecord.searchType.name());
        }
        if (corporateDirectoryRecord.displayType != null) {
            omiMessage2.addAttrib(OmiMessage.CorporateDirectoryType.displayType.name(), corporateDirectoryRecord.displayType.getStringFromEnum());
        }
        if (corporateDirectoryRecord.searchBase != null) {
            omiMessage2.addAttrib(OmiMessage.CorporateDirectoryType.searchBase.name(), corporateDirectoryRecord.searchBase);
        }
        omiMessage2.addAttrib(OmiMessage.CorporateDirectoryType.timeout.name(), corporateDirectoryRecord.timeout);
        if (corporateDirectoryRecord.url != null) {
            byte[] byArray;
            if (corporateDirectoryRecord.url.password != null && (byArray = OmiRSA.encrypt(corporateDirectoryRecord.url.password)) != null) {
                char[] cArray = Base64Coder.encode(byArray);
                corporateDirectoryRecord.url.password = new String(cArray);
            }
            corporateDirectoryRecord.url.addUrlToMsg(omiMessage2);
        }
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    private boolean sendGetCorporateDirectoryOrder() {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetCorporateDirectoryOrder);
        this.omiHandler.sendOmiMessage(omiMessage);
        return true;
    }

    public void requestChangeOrder(int n, boolean bl) {
        int n2;
        int[] nArray = new int[6];
        for (n2 = 1; n2 <= 5; ++n2) {
            nArray[n2] = this.getDirectoryRecordByOrder((int)n2).id;
        }
        for (n2 = 1; n2 <= 5; ++n2) {
            if (nArray[n2] != n) continue;
            if (bl) {
                int n3 = nArray[n2 + 1];
                nArray[n2 + 1] = n;
                nArray[n2] = n3;
                break;
            }
            int n4 = nArray[n2 - 1];
            nArray[n2 - 1] = n;
            nArray[n2] = n4;
            break;
        }
        this.sendSetCorporateDirectoryOrder(nArray);
    }

    public void sendSetCorporateDirectoryOrder(int[] nArray) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.SetCorporateDirectoryOrder);
        OmiMessage omiMessage2 = null;
        for (int i = 1; i <= 5; ++i) {
            omiMessage2 = i == 1 ? omiMessage.addSubElement(OmiMessage.elemIds.directory) : omiMessage2.addElement(OmiMessage.elemIds.directory);
            omiMessage2.addAttrib(OmiMessage.CorporateDirectoryOrderType.order.name(), i);
            omiMessage2.addAttrib(OmiMessage.CorporateDirectoryOrderType.id.name(), nArray[i]);
        }
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    private boolean processDirectoryElem(OmiMessage omiMessage, DataNotificationEnum dataNotificationEnum) {
        OmiMessage omiMessage2;
        Integer n;
        String string;
        if (omiMessage.id != OmiMessage.elemIds.directory) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "process directory element: found invalid sub element");
            return false;
        }
        int n2 = omiMessage.getAttribValInt(OmiMessage.CorporateDirectoryType.id.name());
        CorporateDirectoryRecord corporateDirectoryRecord = this.getDirectoryRecordById(n2);
        Boolean bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.CorporateDirectoryType.active.name());
        if (bl != null) {
            corporateDirectoryRecord.active = bl;
        }
        if ((string = omiMessage.getAttribVal(OmiMessage.CorporateDirectoryType.type.name())) != null) {
            try {
                corporateDirectoryRecord.type = OmiMessage.CorporateDirectoryTypeType.valueOf(string).getText();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println("Wrong CorporateDirectoryTypeType");
                corporateDirectoryRecord.type = OmiMessage.CorporateDirectoryTypeType.LDAP.getText();
            }
        }
        if ((string = omiMessage.getAttribVal(OmiMessage.CorporateDirectoryType.name.name())) != null) {
            corporateDirectoryRecord.name = string;
        }
        if ((string = omiMessage.getAttribVal(OmiMessage.CorporateDirectoryType.searchBase.name())) != null) {
            corporateDirectoryRecord.searchBase = string;
        }
        if ((string = omiMessage.getAttribVal(OmiMessage.CorporateDirectoryType.searchType.name())) != null) {
            corporateDirectoryRecord.searchType = OmiMessage.SearchNewType.valueOf(string);
        }
        if ((string = omiMessage.getAttribVal(OmiMessage.CorporateDirectoryType.displayType.name())) != null) {
            corporateDirectoryRecord.displayType = OmiMessage.DisplayNewType.getEnumFromString(string);
        }
        if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.CorporateDirectoryType.timeout.name())) != null) {
            corporateDirectoryRecord.timeout = n;
        }
        if ((omiMessage2 = omiMessage.getSubElement()) != null) {
            corporateDirectoryRecord.url.updateFromMsg(omiMessage2);
        }
        if (this.setDirectoryRecord(corporateDirectoryRecord)) {
            this.GenerateDataNotification(n2, dataNotificationEnum);
        }
        return true;
    }

    private boolean processDirectoryOrderSequence(OmiMessage omiMessage) {
        int n = 0;
        for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
            if (this.processDirectoryOrderElem(omiMessage2)) {
                ++n;
                continue;
            }
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, omiMessage.id.name() + " no directory order elem");
            return false;
        }
        if (n > 5) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, omiMessage.id.name() + " contains more directory order elems than allowed");
        }
        return true;
    }

    private boolean processDirectoryOrderElem(OmiMessage omiMessage) {
        if (omiMessage.id != OmiMessage.elemIds.directory) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "process directory order element: found invalid sub element");
            return false;
        }
        int n = omiMessage.getAttribValInt(OmiMessage.CorporateDirectoryOrderType.id.name());
        CorporateDirectoryRecord corporateDirectoryRecord = this.getDirectoryRecordById(n);
        corporateDirectoryRecord.order = omiMessage.getAttribValInt(OmiMessage.CorporateDirectoryOrderType.order.name());
        if (this.setDirectoryRecord(corporateDirectoryRecord)) {
            this.GenerateDataNotification(n, DataNotificationEnum.DATA_CHANGED);
        }
        return true;
    }

    @Override
    public void processOmiMessage(OmiMessage omiMessage) {
        OmiMessage omiMessage2 = null;
        String string = null;
        switch (omiMessage.id) {
            case GetCorporateDirectoryResp: {
                omiMessage2 = omiMessage.getSubElement();
                if (omiMessage2 != null) {
                    this.processDirectoryElem(omiMessage2, DataNotificationEnum.DATA_CHANGED);
                    break;
                }
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "GetCorporateDirectoryResp no directory element elem");
                break;
            }
            case SetCorporateDirectoryResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    int n = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
                    this.GenerateErrorNotification(n, DataNotificationEnum.DATA_CHANGED, omiMessage);
                    break;
                }
                omiMessage2 = omiMessage.getSubElement();
                if (omiMessage2 != null) {
                    this.processDirectoryElem(omiMessage2, DataNotificationEnum.DATA_CHANGED);
                    break;
                }
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "SetCorporateDirectoryResp no directory element elem");
                break;
            }
            case EventCorporateDirectoryCnf: {
                omiMessage2 = omiMessage.getSubElement();
                if (omiMessage2 != null) {
                    this.processDirectoryElem(omiMessage2, DataNotificationEnum.DATA_CHANGED);
                    break;
                }
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "EventCorporateDirectoryCnf no directory element elem");
                break;
            }
            case SetCorporateDirectoryOrderResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    int n = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
                    this.GenerateErrorNotification(n, DataNotificationEnum.DATA_CHANGED, omiMessage);
                    break;
                }
                this.processDirectoryOrderSequence(omiMessage);
                break;
            }
            case GetCorporateDirectoryOrderResp: 
            case EventCorporateDirectoryOrderCnf: {
                this.processDirectoryOrderSequence(omiMessage);
                break;
            }
        }
    }

    @Override
    public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
        if (omiManagementEventEnum == OmiManagementEventEnum.LINK_READY) {
            for (int i = 1; i <= 5; ++i) {
                this.sendGetCorporateDirectory(i);
            }
            this.sendGetCorporateDirectoryOrder();
        }
    }

    public static class DirectoryDatabase
    extends Database {
        CorporateDirectoryRecord[] recs = new CorporateDirectoryRecord[5];
        int[] idxRecs = new int[5];

        public DirectoryDatabase() {
            for (int i = 0; i < 5; ++i) {
                this.recs[i] = new CorporateDirectoryRecord(i + 1);
                this.idxRecs[i] = i;
            }
            this.updateIndex();
        }

        private CorporateDirectoryRecord getRecordById(int n) {
            if (n > 0 && n <= 5) {
                return this.recs[n - 1];
            }
            return null;
        }

        private CorporateDirectoryRecord getRecordByOrder(int n) {
            if (n > 0 && n <= 5) {
                for (int i = 0; i < 5; ++i) {
                    if (this.recs[i].order != n) continue;
                    return this.recs[i];
                }
            }
            return null;
        }

        private boolean setRecord(CorporateDirectoryRecord corporateDirectoryRecord) {
            if (corporateDirectoryRecord.id > 0 && corporateDirectoryRecord.id <= 5) {
                this.recs[corporateDirectoryRecord.id - 1] = corporateDirectoryRecord;
                this.updateIndex();
                return true;
            }
            return false;
        }

        @Override
        public void updateIndex() {
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }

        @Override
        public int getRecordNumber() {
            return 5;
        }

        @Override
        public CorporateDirectoryRecord getRecordByIdx(int n) {
            return this.recs[this.idxRecs[n]];
        }

        @Override
        public String[] getFieldNames() {
            return fieldNames;
        }
    }

    public static class CorporateDirectoryRecord
    extends DataRecord {
        public static final int IDX_ID = 0;
        public static final int IDX_TYPE = 1;
        public static final int IDX_ACTIVE = 2;
        public static final int IDX_NAME = 3;
        public static final int IDX_SEARCH_TYPE = 4;
        public static final int IDX_DISPLAY_TYPE = 5;
        public static final int IDX_TIMEOUT = 6;
        public static final int IDX_SEARCH_BASE = 7;
        public static final int IDX_URL = 8;
        public static final int IDX_ORDER = 9;
        public static final int NUMBER_OF_FIELDS = 10;
        public int id;
        public String type;
        public boolean active;
        public String name;
        public OmiMessage.SearchNewType searchType = null;
        public OmiMessage.DisplayNewType displayType = null;
        public int timeout = 0;
        public String searchBase = null;
        public CommonDataHandler.UrlClass url = new CommonDataHandler.UrlClass();
        public int order = 0;

        public CorporateDirectoryRecord() {
        }

        public CorporateDirectoryRecord(int n) {
            this.id = n;
        }

        @Override
        public Object getField(int n) {
            switch (n) {
                case 0: {
                    return this.id;
                }
                case 1: {
                    return this.type;
                }
                case 2: {
                    return this.active;
                }
                case 3: {
                    return this.name;
                }
                case 4: {
                    return this.searchType;
                }
                case 5: {
                    return this.displayType;
                }
                case 6: {
                    return this.timeout;
                }
                case 7: {
                    return this.searchBase;
                }
                case 8: {
                    return this.url;
                }
                case 9: {
                    return this.order;
                }
            }
            return null;
        }

        @Override
        public CorporateDirectoryRecord clone() {
            CorporateDirectoryRecord corporateDirectoryRecord = new CorporateDirectoryRecord();
            corporateDirectoryRecord.id = this.id;
            corporateDirectoryRecord.type = this.type;
            corporateDirectoryRecord.active = this.active;
            corporateDirectoryRecord.name = this.name;
            corporateDirectoryRecord.searchType = this.searchType;
            corporateDirectoryRecord.displayType = this.displayType;
            corporateDirectoryRecord.timeout = this.timeout;
            corporateDirectoryRecord.searchBase = this.searchBase;
            corporateDirectoryRecord.url = this.url.clone();
            corporateDirectoryRecord.order = this.order;
            return corporateDirectoryRecord;
        }

        public static void setTableHeaderText(int n, String string) {
            if (n >= 0 && n < 10) {
                fieldNames[n] = string;
            }
        }
    }

    public static interface CorporateDirectoryDataNotificationInterface {
        public void processCorporateDirectoryDataNotification(int var1, DataNotificationEnum var2);

        public void processCorporateDirectoryErrorNotification(int var1, DataNotificationEnum var2, OmiMessage var3);
    }
}

