/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import java.util.Timer;
import java.util.TimerTask;

public abstract class DataHandler {
    private static final int timeout = 5000;
    private boolean sendBulkActive = false;
    private boolean sendBulkCanceled = false;
    private int sendBulkCntSent = 0;
    private int sendBulkCntTotal = 0;
    private DataHandlerSendBulkInterface sendBulkCaller = null;
    private SendBulkActionType sendBulkActionType = null;
    private Timer timeoutTimer = null;
    private TimeoutTimerTask timeoutTimerTask = null;

    protected void sendNextCreate(int n) {
    }

    protected void sendNextChange(int n) {
    }

    protected void sendNextDelete(int n) {
    }

    private void sendNext(int n) {
        switch (this.sendBulkActionType) {
            case Create: {
                this.sendNextCreate(n);
                break;
            }
            case Change: {
                this.sendNextChange(n);
                break;
            }
            case Delete: {
                this.sendNextDelete(n);
            }
        }
    }

    protected boolean startSendBulk(SendBulkActionType sendBulkActionType, int n, DataHandlerSendBulkInterface dataHandlerSendBulkInterface) {
        if (this.sendBulkActive) {
            return false;
        }
        this.sendBulkCntTotal = n;
        this.sendBulkActionType = sendBulkActionType;
        this.sendBulkCaller = dataHandlerSendBulkInterface;
        this.sendBulkCntSent = 20;
        if (this.sendBulkCntSent > this.sendBulkCntTotal) {
            this.sendBulkCntSent = this.sendBulkCntTotal;
        }
        for (int i = 0; i < this.sendBulkCntSent; ++i) {
            this.sendNext(i);
        }
        this.sendBulkActive = true;
        this.timeoutTimer = new Timer("Omilib_DataHandlerTimeoutTimer");
        this.timeoutTimerTask = new TimeoutTimerTask();
        this.timeoutTimer.schedule((TimerTask)this.timeoutTimerTask, 5000L);
        return true;
    }

    protected void stopSendBulk() {
        if (this.sendBulkCaller != null) {
            this.sendBulkCanceled = true;
        }
    }

    protected void checkSendBulk() {
        if (this.sendBulkActive) {
            if (this.sendBulkCanceled || this.sendBulkCntSent == this.sendBulkCntTotal) {
                this.timeoutTimer.cancel();
                this.sendBulkActive = false;
            } else {
                this.sendNext(this.sendBulkCntSent);
                this.timeoutTimerTask.cancel();
                this.timeoutTimerTask = new TimeoutTimerTask();
                this.timeoutTimer.schedule((TimerTask)this.timeoutTimerTask, 5000L);
            }
            this.sendBulkCaller.notifyProgress(this.sendBulkCntSent, this.sendBulkCanceled);
            if (this.sendBulkCanceled) {
                this.sendBulkCanceled = false;
            }
            if (this.sendBulkActive) {
                ++this.sendBulkCntSent;
            }
        }
    }

    public class TimeoutTimerTask
    extends TimerTask {
        @Override
        public void run() {
            DataHandler.this.sendBulkActive = false;
            if (DataHandler.this.sendBulkCaller != null) {
                DataHandler.this.sendBulkCaller.timeout(DataHandler.this.sendBulkCntSent);
            }
        }
    }

    public static enum SendBulkActionType {
        Create,
        Change,
        Delete;

    }

    public static interface DataHandlerSendBulkInterface {
        public void notifyProgress(int var1, boolean var2);

        public void timeout(int var1);
    }
}

