/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.OmilibUtil;
import com.aastra.util.UtilSpy;

public class DataRecord {
    public boolean deleted = false;

    public String[] getFieldNameArray() {
        return null;
    }

    public Object getField(int n) {
        return null;
    }

    public boolean getFieldChanged(int n) {
        return false;
    }

    public void setField(int n, Object object) {
    }

    public DataRecord clone() {
        return new DataRecord();
    }

    public class DataElem {
        private Object val = null;
        private Object orig = null;
        private Class<?> elemClass = String.class;
        private boolean changed = false;

        public DataElem() {
        }

        public DataElem(Class<?> clazz) {
            this.elemClass = clazz;
        }

        private boolean setFromString(String string) {
            if (this.elemClass == String.class) {
                this.val = string;
                return true;
            }
            if (this.elemClass == Boolean.class) {
                this.val = OmilibUtil.interpreteBoolean(string) ? Boolean.valueOf(true) : Boolean.valueOf(false);
                return true;
            }
            if (this.elemClass == Integer.class) {
                try {
                    int n = Integer.parseInt(string);
                    this.val = n;
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "setFromString: Cannot convert String \"" + string + "\" to Integer");
                }
            } else {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "setFromString: Cannot convert String to " + this.elemClass.getName());
            }
            return false;
        }

        private boolean compareWithString(String string) {
            if (this.val == null) {
                return false;
            }
            if (this.elemClass == Boolean.class) {
                if (OmilibUtil.interpreteBoolean(string)) {
                    return (Boolean)this.val == true;
                }
                return (Boolean)this.val == false;
            }
            if (this.elemClass == Integer.class) {
                try {
                    int n = Integer.parseInt(string);
                    return (Integer)this.val == n;
                }
                catch (NumberFormatException numberFormatException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "compareWithString: Cannot convert String \"" + string + "\" to Integer");
                }
            } else {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "compareWithString: Cannot convert String to " + this.elemClass.getName());
            }
            return true;
        }

        public void setValue(Object object) {
            this.changed = false;
            if (object != null) {
                if (object.getClass() == this.elemClass) {
                    this.val = object;
                } else if (object instanceof String) {
                    this.setFromString((String)object);
                } else {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "setValue: Wrong class: " + object.getClass().getName() + " <-> " + this.elemClass.getName() + "  ( Value= " + object.toString() + " )");
                }
            } else {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "setValue: Argument is null");
                this.val = null;
            }
        }

        public String getString() {
            if (this.val == null) {
                return "";
            }
            if (this.elemClass == Boolean.class) {
                if (((Boolean)this.val).booleanValue()) {
                    return "1";
                }
                return "0";
            }
            if (this.val instanceof Enum) {
                return ((Enum)this.val).name();
            }
            return this.val.toString();
        }

        public Object getValue() {
            if (this.val == null) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "getValue: Value is null");
                return "";
            }
            return this.val;
        }

        public void changeValue(Object object) {
            if (object != null) {
                if (this.val != null && this.val.equals(object)) {
                    return;
                }
                if (object.getClass() == this.elemClass) {
                    this.orig = this.val;
                    this.val = object;
                    this.changed = true;
                } else if (object instanceof String) {
                    String string = (String)object;
                    if (!this.compareWithString(string)) {
                        Object object2 = this.val;
                        if (this.setFromString(string)) {
                            this.orig = object2;
                            this.changed = true;
                        } else {
                            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "changeValue: Wrong class: " + object.getClass().getName() + " <-> " + this.elemClass.getName() + "  ( Value= " + object.toString() + " )");
                        }
                    }
                } else {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "changeValue: Class not accepted: " + object.getClass().getName() + " expected:" + this.elemClass.getName() + "  ( Value= " + object.toString() + " )");
                }
            } else {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "changeValue: Setting element to null ");
                this.orig = this.val;
                this.val = object;
                this.changed = true;
            }
        }

        public void undoChange() {
            if (this.changed) {
                this.val = this.orig;
                this.changed = false;
            }
        }

        public void commitChange() {
            this.changed = false;
        }

        public boolean getChanged() {
            return this.changed;
        }

        public DataElem clone() {
            DataElem dataElem = new DataElem();
            dataElem.changed = this.changed;
            dataElem.orig = this.orig;
            dataElem.val = this.val;
            dataElem.elemClass = this.elemClass;
            return dataElem;
        }
    }
}

