/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.DataRecord;
import com.aastra.omilib.DatabaseChangeEvent;
import java.util.LinkedList;

public abstract class Database {
    public static final int MAX_FIELD = 150;
    public static final int MAX_FILTER_ITEMS = 3;
    private FilterItem[] filterArray = null;
    private String[] fieldFormatStringArray = null;
    protected LinkedList<DatabaseChangeNotificationInterface> listenerList = new LinkedList();

    public void registerChangeNotificationListener(DatabaseChangeNotificationInterface databaseChangeNotificationInterface) {
        this.listenerList.add(databaseChangeNotificationInterface);
    }

    public void deregisterChangeNotificationListener(DatabaseChangeNotificationInterface databaseChangeNotificationInterface) {
        this.listenerList.remove(databaseChangeNotificationInterface);
    }

    protected void generateChangeNotification(DatabaseChangeEvent databaseChangeEvent) {
        if (this.listenerList.size() == 0) {
            return;
        }
        for (DatabaseChangeNotificationInterface databaseChangeNotificationInterface : this.listenerList) {
            if (databaseChangeNotificationInterface == null) continue;
            databaseChangeNotificationInterface.databaseChangeNotification(databaseChangeEvent);
        }
    }

    protected void generateChangeNotification(DatabaseChangeEnum databaseChangeEnum) {
        this.generateChangeNotification(new DatabaseChangeEvent(databaseChangeEnum, 0, DatabaseChangeEvent.DatabaseChangeType.ALL));
    }

    public static String wildcardToRegex(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        stringBuffer.append('^');
        int n = string.length();
        block5: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '*': {
                    stringBuffer.append(".*");
                    continue block5;
                }
                case '?': {
                    stringBuffer.append(".");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    stringBuffer.append("\\");
                    stringBuffer.append(c);
                    continue block5;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        stringBuffer.append('$');
        return stringBuffer.toString();
    }

    public abstract int getRecordNumber();

    public abstract DataRecord getRecordByIdx(int var1);

    public abstract String[] getFieldNames();

    public void setFieldFormatString(int n, String string) {
        if (n >= 0 && n < 150) {
            if (this.fieldFormatStringArray == null) {
                this.fieldFormatStringArray = new String[150];
            }
            this.fieldFormatStringArray[n] = string;
        }
    }

    public String getFieldFormatString(int n) {
        if (n < 0 || n >= 150) {
            return null;
        }
        if (this.fieldFormatStringArray == null) {
            return null;
        }
        return this.fieldFormatStringArray[n];
    }

    protected FilterItem[] getFilterArray() {
        if (this.filterArray == null) {
            this.filterArray = new FilterItem[3];
        }
        return this.filterArray;
    }

    public void setFilter(Integer n, String string, int n2) {
        if (this.getFilterArray()[n2] == null) {
            this.filterArray[n2] = new FilterItem();
        }
        this.filterArray[n2].active = false;
        this.filterArray[n2].column = n;
        this.filterArray[n2].searchString = string;
        if (this.filterArray[n2].column != null) {
            this.filterArray[n2].fieldFormatString = this.getFieldFormatString(this.filterArray[n2].column);
        }
        if (string != null && n != null && string.length() > 0) {
            this.filterArray[n2].active = true;
        }
    }

    public String getFilterString() {
        return this.getFilterString(0);
    }

    public String getFilterString(int n) {
        return this.getFilterArray()[n].searchString;
    }

    public Integer getFilterColumn(int n) {
        return this.getFilterArray()[n].column;
    }

    public boolean getFilterActive() {
        return this.getFilterActive(0);
    }

    public boolean getFilterActive(int n) {
        if (this.getFilterArray()[n] != null) {
            return this.getFilterArray()[n].active;
        }
        return false;
    }

    public void updateIndex() {
        this.generateChangeNotification(DatabaseChangeEnum.INDEX_UPDATE);
    }

    protected boolean filterMatch(DataRecord dataRecord) {
        boolean bl = false;
        if (this.filterMatchSingle(0, dataRecord)) {
            if (this.getFilterActive(1)) {
                if (this.filterMatchSingle(1, dataRecord)) {
                    bl = this.getFilterActive(2) ? this.filterMatchSingle(2, dataRecord) : true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    private boolean filterMatchSingle(int n, DataRecord dataRecord) {
        return this.getFilterArray()[n].match(dataRecord.getField(this.getFilterColumn(n)));
    }

    private static String getHexFormatString(Integer n) {
        String string = Integer.toHexString(n).toUpperCase();
        switch (string.length()) {
            case 1: {
                return "0x00" + string;
            }
            case 2: {
                return "0x0" + string;
            }
        }
        return "0x" + string;
    }

    public static interface DatabaseChangeNotificationInterface {
        public void databaseChangeNotification(DatabaseChangeEvent var1);
    }

    public static enum DatabaseChangeEnum {
        RECORD_ADDED,
        RECORD_CHANGED,
        RECORD_DELETED,
        INDEX_UPDATE;

    }

    protected static class FilterItem {
        private String searchString = null;
        private Integer column = null;
        private boolean active = false;
        private String fieldFormatString = null;

        protected boolean match(Object object) {
            String string = this.getCompareString(object);
            return string != null && string.contains(this.searchString);
        }

        private String getCompareString(Object object) {
            if (object != null) {
                if (object.getClass() == Boolean.class) {
                    if (((Boolean)object).booleanValue()) {
                        return "1";
                    }
                    return "0";
                }
                if (object.getClass() == Enum.class) {
                    return ((Enum)object).name();
                }
                if (object.getClass() == Integer.class) {
                    if (this.fieldFormatString != null) {
                        if (this.fieldFormatString.equals("0x%03X")) {
                            return Database.getHexFormatString((Integer)object);
                        }
                        return String.format(this.fieldFormatString, object);
                    }
                    return object.toString();
                }
                return object.toString();
            }
            return null;
        }
    }
}

