/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.OmiHandler;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;
import com.aastra.util.UtilSpy;
import java.util.LinkedList;

public class DigitTreatmentHandlerExpanded
implements OmiManagementEventInterface,
OmiMessageInterface {
    private static String strAllSites = "All";
    private static final int maxRecBulkReq = 20;
    protected DigitTreatmentDatabase digitTreatmentDb = new DigitTreatmentDatabase();
    protected OmiHandler omiHandler = null;
    private boolean getBulkInProgress = false;
    private LinkedList<DigitTreatmentDataNotificationInterface> listenerList = new LinkedList();
    private static String[] fieldNames = new String[]{"id", "Ext. pattern", "Int. pattern", "Directory", "Direction", "Sites"};

    public DigitTreatmentHandlerExpanded(OmiManagement omiManagement) {
        this.omiHandler = omiManagement.getOmiHandler();
        omiManagement.registerManagementEventListener(this);
        OmiMessage.elemIds.GetDigitTreatmentSummaryResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetDigitTreatmentResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.CreateDigitTreatmentResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetDigitTreatmentResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventDigitTreatmentCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.DeleteDigitTreatmentResp.registerDataNotificationListener(this);
    }

    public static String getStrAllSites() {
        return strAllSites;
    }

    public static void setStrAllSites(String string) {
        strAllSites = string;
    }

    public Database getDb() {
        return this.digitTreatmentDb;
    }

    public int getNumberOfDigitTreatments() {
        return this.digitTreatmentDb.getRecordNumber();
    }

    public void registerDataNotificationListener(DigitTreatmentDataNotificationInterface digitTreatmentDataNotificationInterface) {
        this.listenerList.add(digitTreatmentDataNotificationInterface);
    }

    public void deregisterDataNotificationListener(DigitTreatmentDataNotificationInterface digitTreatmentDataNotificationInterface) {
        this.listenerList.remove(digitTreatmentDataNotificationInterface);
    }

    protected void GenerateDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generate LDAP DataNotification - no Device Listener");
        }
        for (DigitTreatmentDataNotificationInterface digitTreatmentDataNotificationInterface : this.listenerList) {
            if (digitTreatmentDataNotificationInterface == null) continue;
            digitTreatmentDataNotificationInterface.processDataNotification(n, dataNotificationEnum);
        }
    }

    private void GenerateErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generate LDAP ErrorNotification - no Device Listener");
        }
        for (DigitTreatmentDataNotificationInterface digitTreatmentDataNotificationInterface : this.listenerList) {
            if (digitTreatmentDataNotificationInterface == null) continue;
            digitTreatmentDataNotificationInterface.processErrorNotification(n, dataNotificationEnum, omiMessage);
        }
    }

    public DigitTreatment getDigitTreatmentByDigitTreatmentId(int n) {
        DigitTreatment digitTreatment = this.digitTreatmentDb.getRecordById(n);
        return this.setElements(digitTreatment);
    }

    public DigitTreatment getDigitTreatmentByTableIdx(int n) {
        DigitTreatment digitTreatment = this.digitTreatmentDb.getRecordByIdx(n);
        return this.setElements(digitTreatment);
    }

    private DigitTreatment setElements(DigitTreatment digitTreatment) {
        if (digitTreatment != null) {
            DigitTreatment digitTreatment2 = new DigitTreatment();
            digitTreatment2.id = (Integer)digitTreatment.getField(0);
            digitTreatment2.extPattern = (String)digitTreatment.getField(1);
            digitTreatment2.intPattern = (String)digitTreatment.getField(2);
            digitTreatment2.directory = (Boolean)digitTreatment.getField(4);
            digitTreatment2.direction = (DirectionType)((Object)digitTreatment.getField(3));
            digitTreatment2.sites = (String)digitTreatment.getField(5);
            return digitTreatment2;
        }
        return null;
    }

    public void sendGetDigitTreatmentSummary() {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetDigitTreatmentSummary);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendGetDigitTreatment(int n) {
        this.sendGetDigitTreatmentBulk(n, 1);
    }

    public void sendGetDigitTreatmentBulk(int n, int n2) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetDigitTreatment);
        omiMessage.addAttrib(OmiMessage.attribIds.id.name(), n);
        omiMessage.addAttrib(OmiMessage.attribIds.maxRecords.name(), n2);
        this.omiHandler.sendOmiMessage(omiMessage);
        if (n2 > 1) {
            this.getBulkInProgress = true;
        }
    }

    public void sendCreateDigitTreatment(DigitTreatment digitTreatment) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.CreateDigitTreatment);
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.rule);
        if (digitTreatment.extPattern != null) {
            omiMessage2.addAttrib(OmiMessage.DigitTreatmentExpandedType.externalPattern.name(), digitTreatment.extPattern);
        }
        if (digitTreatment.intPattern != null) {
            omiMessage2.addAttrib(OmiMessage.DigitTreatmentExpandedType.internalPattern.name(), digitTreatment.intPattern);
        }
        omiMessage2.addAttrib(OmiMessage.DigitTreatmentExpandedType.directory.name(), digitTreatment.directory);
        omiMessage2.addAttrib(OmiMessage.DigitTreatmentExpandedType.direction.name(), digitTreatment.direction.toString());
        if (digitTreatment.sites != null && digitTreatment.sites.length() > 0 && !digitTreatment.sites.equals(strAllSites)) {
            String[] stringArray = digitTreatment.sites.split(",");
            OmiMessage omiMessage3 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                omiMessage3 = omiMessage3 == null ? omiMessage2.addSubElement(OmiMessage.elemIds.sites) : omiMessage3.addElement(OmiMessage.elemIds.sites);
                omiMessage3.addAttrib(OmiMessage.SiteIdType.siteId.name(), stringArray[i]);
            }
        }
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendSetDigitTreatment(DigitTreatment digitTreatment) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.SetDigitTreatment);
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), digitTreatment.id);
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.rule);
        omiMessage2.addAttrib(OmiMessage.DigitTreatmentExpandedType.id.name(), digitTreatment.id);
        if (digitTreatment.extPattern != null) {
            omiMessage2.addAttrib(OmiMessage.DigitTreatmentExpandedType.externalPattern.name(), digitTreatment.extPattern);
        }
        if (digitTreatment.intPattern != null) {
            omiMessage2.addAttrib(OmiMessage.DigitTreatmentExpandedType.internalPattern.name(), digitTreatment.intPattern);
        }
        omiMessage2.addAttrib(OmiMessage.DigitTreatmentExpandedType.directory.name(), digitTreatment.directory);
        omiMessage2.addAttrib(OmiMessage.DigitTreatmentExpandedType.direction.name(), digitTreatment.direction.toString());
        if (digitTreatment.sites != null && digitTreatment.sites.length() > 0 && !digitTreatment.sites.equals(strAllSites)) {
            String[] stringArray = digitTreatment.sites.split(",");
            OmiMessage omiMessage3 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                omiMessage3 = omiMessage3 == null ? omiMessage2.addSubElement(OmiMessage.elemIds.sites) : omiMessage3.addElement(OmiMessage.elemIds.sites);
                omiMessage3.addAttrib(OmiMessage.SiteIdType.siteId.name(), stringArray[i]);
            }
        }
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendDeleteDigitTreatment(int n) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.DeleteDigitTreatment);
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), n);
        omiMessage.addAttrib(OmiMessage.DigitTreatmentType.id.name(), n);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    private void processGetDigitTreatmentSummaryResp(OmiMessage omiMessage) {
        OmiMessage omiMessage2 = omiMessage.getSubElement();
        if (omiMessage2 != null) {
            DigitTreatmentSummary.nRules = omiMessage2.getAttribValInt(OmiMessage.attribIds.nRecords.name());
            DigitTreatmentSummary.idFirst = omiMessage2.getAttribValInt(OmiMessage.attribIds.idFirst.name());
        } else {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "CreateDigitTreatmentSummaryResp no rule elem");
        }
    }

    private int processGetDigitTreatmentResp(OmiMessage omiMessage) {
        DigitTreatment digitTreatment;
        int n = 0;
        for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
            if (!this.processDigitTreatmentElem(omiMessage2, DataNotificationEnum.NEW_DATA)) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "GetDigitTreatmentResp no rule elem");
                continue;
            }
            ++n;
        }
        if (n == 20 && (digitTreatment = this.digitTreatmentDb.getRecordByIdx(this.digitTreatmentDb.getRecordNumber() - 1)) != null) {
            return (Integer)digitTreatment.getField(0);
        }
        return 0;
    }

    protected boolean processDigitTreatmentElem(OmiMessage omiMessage, DataNotificationEnum dataNotificationEnum) {
        if (omiMessage.id == OmiMessage.elemIds.rule) {
            OmiMessage omiMessage2;
            Boolean bl;
            String string;
            int n = omiMessage.getAttribValInt(OmiMessage.DigitTreatmentExpandedType.id.name());
            DigitTreatment digitTreatment = this.digitTreatmentDb.getRecordById(n);
            if (digitTreatment == null) {
                digitTreatment = new DigitTreatment(n);
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.DigitTreatmentExpandedType.externalPattern.name())) != null) {
                digitTreatment.extPattern = string;
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.DigitTreatmentExpandedType.internalPattern.name())) != null) {
                digitTreatment.intPattern = string;
            }
            if ((bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.DigitTreatmentExpandedType.directory.name())) != null) {
                digitTreatment.directory = bl;
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.DigitTreatmentExpandedType.direction.name())) != null) {
                digitTreatment.direction = DirectionType.valueOf(string);
            }
            digitTreatment.sites = strAllSites;
            int n2 = 0;
            for (omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
                if (omiMessage2.id != OmiMessage.elemIds.sites) continue;
                ++n2;
            }
            if (n2 > 0) {
                String string2;
                Integer[] integerArray = new Integer[n2];
                int n3 = 0;
                for (omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
                    if (omiMessage2.id != OmiMessage.elemIds.sites) continue;
                    try {
                        string2 = omiMessage2.getAttribVal(OmiMessage.SiteIdType.siteId.name());
                        if (string2 == null) continue;
                        if (!string2.equals("0")) {
                            integerArray[n3] = new Integer(string2);
                            ++n3;
                            continue;
                        }
                        UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "ProcessDigitTreatmentElem - invalid siteId '0' received");
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (n3 > 0) {
                    string2 = integerArray[0].toString();
                    for (int i = 1; i < n3; ++i) {
                        string2 = string2 + "," + integerArray[i].toString();
                    }
                    digitTreatment.sites = string2;
                }
                if (n3 < n2) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "ProcessDigitTreatmentElem - site elem(s) without Id (or with id = '0') received");
                }
            }
            this.digitTreatmentDb.addDigitTreatment(digitTreatment);
            this.GenerateDataNotification(n, dataNotificationEnum);
            return true;
        }
        return false;
    }

    @Override
    public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
        if (omiManagementEventEnum == OmiManagementEventEnum.LINK_READY) {
            this.digitTreatmentDb.clearAll();
            this.GenerateDataNotification(0, DataNotificationEnum.DATA_DELETED_ALL);
            OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.DigitTreatmentCnf, null, null);
            this.sendGetDigitTreatmentBulk(0, 20);
        }
    }

    @Override
    public void processOmiMessage(OmiMessage omiMessage) {
        String string = null;
        switch (omiMessage.id) {
            case GetDigitTreatmentSummaryResp: {
                this.processGetDigitTreatmentSummaryResp(omiMessage);
                break;
            }
            case GetDigitTreatmentResp: {
                int n = this.processGetDigitTreatmentResp(omiMessage);
                if (!this.getBulkInProgress) break;
                if (n > 0) {
                    this.sendGetDigitTreatmentBulk(n + 1, 20);
                    break;
                }
                this.GenerateDataNotification(this.digitTreatmentDb.getRecordNumber(), DataNotificationEnum.DATA_BULK_READY);
                this.getBulkInProgress = false;
                break;
            }
            case CreateDigitTreatmentResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    this.GenerateErrorNotification(-1, DataNotificationEnum.NEW_DATA, omiMessage);
                    break;
                }
                OmiMessage omiMessage2 = omiMessage.getSubElement();
                if (omiMessage2 != null && this.processDigitTreatmentElem(omiMessage2, DataNotificationEnum.NEW_DATA)) break;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "CreateDigitTreatmentResp no rule elem");
                break;
            }
            case DeleteDigitTreatmentResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    int n = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
                    this.GenerateErrorNotification(n, DataNotificationEnum.DATA_DELETED, omiMessage);
                    break;
                }
                int n = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
                this.digitTreatmentDb.deleteDigitTreatment(n);
                this.GenerateDataNotification(n, DataNotificationEnum.DATA_DELETED);
                break;
            }
            case SetDigitTreatmentResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    int n = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
                    this.GenerateErrorNotification(n, DataNotificationEnum.DATA_CHANGED, omiMessage);
                    break;
                }
                OmiMessage omiMessage3 = omiMessage.getSubElement();
                if (omiMessage3 != null && this.processDigitTreatmentElem(omiMessage3, DataNotificationEnum.DATA_CHANGED)) break;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "SetDigitTreatmentResp no rule elem");
                break;
            }
            case EventDigitTreatmentCnf: {
                OmiMessage omiMessage4 = omiMessage.getSubElement();
                if (omiMessage4 != null) {
                    boolean bl = omiMessage.getAttribValBool(OmiMessage.attribIds.deleted.name());
                    if (bl) {
                        if (omiMessage4.id == OmiMessage.elemIds.rule) {
                            int n = omiMessage4.getAttribValInt(OmiMessage.DigitTreatmentType.id.name());
                            this.digitTreatmentDb.deleteDigitTreatment(n);
                            this.GenerateDataNotification(n, DataNotificationEnum.DATA_DELETED);
                        }
                    } else if (this.processDigitTreatmentElem(omiMessage4, DataNotificationEnum.DATA_CHANGED)) break;
                }
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "EventDigitTreatmentCnf no rule elem");
                break;
            }
        }
    }

    public static class DigitTreatmentDatabase
    extends Database {
        public static final int MAX_DT_REC = 750;
        DigitTreatment[] dTArray = new DigitTreatment[750];
        int[] dTIdx = new int[750];
        int noOfDTs = 0;

        @Override
        public DigitTreatment getRecordByIdx(int n) {
            if (n >= 0 && n < this.noOfDTs) {
                return this.dTArray[this.dTIdx[n]];
            }
            return null;
        }

        public DigitTreatment getRecordById(int n) {
            if (n >= 0 && n < 750) {
                return this.dTArray[n];
            }
            return null;
        }

        @Override
        public int getRecordNumber() {
            return this.noOfDTs;
        }

        @Override
        public void updateIndex() {
            this.noOfDTs = 0;
            for (int i = 0; i < 750; ++i) {
                if (this.dTArray[i] == null) continue;
                this.dTIdx[this.noOfDTs++] = i;
            }
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }

        public void addDigitTreatment(DigitTreatment digitTreatment) {
            if (digitTreatment.id >= 0 && digitTreatment.id < 750) {
                this.dTArray[digitTreatment.id] = digitTreatment;
                this.updateIndex();
            }
        }

        public void deleteDigitTreatment(int n) {
            this.dTArray[n] = null;
            this.updateIndex();
        }

        public void clearAll() {
            for (int i = 0; i < 750; ++i) {
                this.dTArray[i] = null;
            }
            this.noOfDTs = 0;
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }

        @Override
        public String[] getFieldNames() {
            return fieldNames;
        }
    }

    public static class DigitTreatment
    extends DataRecord {
        public static final int IDX_ID = 0;
        public static final int IDX_EXTERNAL_PATTERN = 1;
        public static final int IDX_INTERNAL_PATTERN = 2;
        public static final int IDX_DIRECTION = 3;
        public static final int IDX_DIRECTORY = 4;
        public static final int IDX_SITES = 5;
        public static final int NUMBER_OF_FIELDS = 6;
        public int id;
        public String extPattern;
        public String intPattern;
        public boolean directory;
        public DirectionType direction;
        public String sites;

        public DigitTreatment() {
        }

        public DigitTreatment(int n) {
            this.id = n;
        }

        public String toString() {
            return this.extPattern;
        }

        @Override
        public Object getField(int n) {
            switch (n) {
                case 0: {
                    return this.id;
                }
                case 1: {
                    return this.extPattern;
                }
                case 2: {
                    return this.intPattern;
                }
                case 4: {
                    return this.directory;
                }
                case 3: {
                    return this.direction;
                }
                case 5: {
                    return this.sites;
                }
            }
            return null;
        }

        @Override
        public DataRecord clone() {
            DigitTreatment digitTreatment = new DigitTreatment();
            digitTreatment.id = this.id;
            digitTreatment.extPattern = this.extPattern;
            digitTreatment.intPattern = this.intPattern;
            digitTreatment.directory = this.directory;
            digitTreatment.direction = this.direction;
            digitTreatment.sites = this.sites;
            return digitTreatment;
        }

        public static void setTableHeaderText(int n, String string) {
            if (n >= 0 && n < 6) {
                fieldNames[n] = string;
            }
        }
    }

    public static class DigitTreatmentSummary {
        public static int nRules = 0;
        public static int idFirst = 0;
    }

    public static enum DirectionType {
        Both,
        Incoming,
        Outgoing,
        Directory;

    }

    public static interface DigitTreatmentDataNotificationInterface {
        public void processDataNotification(int var1, DataNotificationEnum var2);

        public void processErrorNotification(int var1, DataNotificationEnum var2, OmiMessage var3);
    }
}

