/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.OmiHandler;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;
import com.aastra.util.UtilSpy;
import java.util.LinkedList;

public class EventLogMonitoringHandler
implements OmiManagementEventInterface,
OmiMessageInterface {
    private static final int MAX_BULK_RECORDS = 20;
    public static final int INVALID_ID = -1;
    private OmiManagement om = null;
    private OmiHandler omiHandler = null;
    private boolean getBulkInProgress = false;
    private EventLogDatabase eventLogDb = new EventLogDatabase();
    private LinkedList<EventLogNotificationInterface> listenerList = new LinkedList();

    public EventLogMonitoringHandler(OmiManagement omiManagement) {
        this.omiHandler = omiManagement.getOmiHandler();
        this.om = omiManagement;
        this.om.registerManagementEventListener(this);
        OmiMessage.elemIds.GetEventLogBufferResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.DeleteEventLogBufferResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventEventLogEntry.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventEventLogBufferDelete.registerDataNotificationListener(this);
    }

    public void registerDataNotificationListener(EventLogNotificationInterface eventLogNotificationInterface) {
        this.listenerList.add(eventLogNotificationInterface);
    }

    public void deregisterDataNotificationListener(EventLogNotificationInterface eventLogNotificationInterface) {
        this.listenerList.remove(eventLogNotificationInterface);
    }

    private void GenerateDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating event log notification: No listener");
        }
        for (EventLogNotificationInterface eventLogNotificationInterface : this.listenerList) {
            if (eventLogNotificationInterface == null) continue;
            eventLogNotificationInterface.processEventLogDataNotification(n, dataNotificationEnum);
        }
    }

    public Database getDb() {
        return this.eventLogDb;
    }

    public EventLogEntry getEventLogEntryById(int n) {
        return this.eventLogDb.getRecordById(n);
    }

    public EventLogEntry getEventLogEntryByTableIdx(int n) {
        return (EventLogEntry)this.eventLogDb.getRecordByIdx(n);
    }

    public void sendGetEventLogBufferBulk(int n, int n2) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetEventLogBuffer);
        omiMessage.addAttrib(OmiMessage.attribIds.id.name(), n);
        omiMessage.addAttrib(OmiMessage.attribIds.maxRecords.name(), n2);
        this.omiHandler.sendOmiMessage(omiMessage);
        if (n2 > 1) {
            this.getBulkInProgress = true;
        }
    }

    public void sendDeleteEventLogBuffer() {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.DeleteEventLogBuffer);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    @Override
    public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
        if (omiManagementEventEnum == OmiManagementEventEnum.LINK_READY) {
            this.eventLogDb.clearAll();
            OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.EventLog, null, null);
            this.sendGetEventLogBufferBulk(0, 20);
        }
    }

    @Override
    public void processOmiMessage(OmiMessage omiMessage) {
        switch (omiMessage.id) {
            case GetEventLogBufferResp: {
                int n = this.processGetEventLogBufferResp(omiMessage);
                if (!this.getBulkInProgress) break;
                if (n > 0) {
                    this.sendGetEventLogBufferBulk(n, 20);
                    break;
                }
                this.getBulkInProgress = false;
                break;
            }
            case DeleteEventLogBufferResp: {
                this.processDeleteEventLogBufferResp(omiMessage);
                break;
            }
            case EventEventLogBufferDelete: {
                this.processEventEventLogBufferDelete(omiMessage);
                break;
            }
            case EventEventLogEntry: {
                if (this.processEventEventLogEntry(omiMessage)) break;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "EventEventLogEntry invalid");
                break;
            }
        }
    }

    private boolean processEventEventLogEntry(OmiMessage omiMessage) {
        OmiMessage omiMessage2 = omiMessage.getSubElement();
        if (omiMessage2 != null) {
            return this.processEventLogElem(omiMessage2);
        }
        return false;
    }

    private int processGetEventLogBufferResp(OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        if (string == null) {
            for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
                if (this.processEventLogElem(omiMessage2)) continue;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "GetEventLogBufferResp no elem");
            }
            if (!omiMessage.getAttribValBool(OmiMessage.attribIds.eof.name())) {
                return omiMessage.getAttribValInt(OmiMessage.attribIds.id.name());
            }
        }
        return 0;
    }

    private void processDeleteEventLogBufferResp(OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        if (string != null) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "DeleteEventLogBufferResp delivers error");
        } else {
            this.eventLogDb.clearAll();
            this.GenerateDataNotification(-1, DataNotificationEnum.DATA_DELETED_ALL);
        }
    }

    private void processEventEventLogBufferDelete(OmiMessage omiMessage) {
        if (omiMessage.getAttribValBool(OmiMessage.attribIds.deleted.name())) {
            this.eventLogDb.clearAll();
            this.GenerateDataNotification(-1, DataNotificationEnum.DATA_DELETED_ALL);
        }
    }

    private boolean processEventLogElem(OmiMessage omiMessage) {
        if (omiMessage.id == OmiMessage.elemIds.e) {
            DataNotificationEnum dataNotificationEnum;
            String string;
            EventLogEntry eventLogEntry = new EventLogEntry();
            if (omiMessage.getAttribVal(OmiMessage.EventLogEntryType.id.name()) != null) {
                eventLogEntry.id = omiMessage.getAttribValInt(OmiMessage.EventLogEntryType.id.name());
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.EventLogEntryType.time.name())) != null) {
                eventLogEntry.time = string;
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.EventLogEntryType.level.name())) != null) {
                eventLogEntry.level = OmiMessage.EventLogEntryLevelType.valueOf(string);
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.EventLogEntryType.name.name())) != null) {
                eventLogEntry.name = string;
            }
            if (omiMessage.getAttribVal(OmiMessage.EventLogEntryType.count.name()) != null) {
                eventLogEntry.count = omiMessage.getAttribValInt(OmiMessage.EventLogEntryType.count.name());
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.EventLogEntryType.msg.name())) != null) {
                eventLogEntry.message = string;
            }
            if ((dataNotificationEnum = this.eventLogDb.addEntry(eventLogEntry)) != null) {
                this.GenerateDataNotification(eventLogEntry.id, dataNotificationEnum);
            }
            return true;
        }
        return false;
    }

    public static class EventLogDatabase
    extends Database {
        public static final int MAX_EVENT_LOG_ENTRIES = 1000;
        private EventLogEntry[] entries = new EventLogEntry[1000];
        private int noOfEntries = 0;

        @Override
        public DataRecord getRecordByIdx(int n) {
            if (n >= 0 && n < this.noOfEntries) {
                return this.entries[n];
            }
            return null;
        }

        public EventLogEntry getRecordById(int n) {
            for (int i = 0; i < this.noOfEntries; ++i) {
                if (this.entries[i].id != n) continue;
                return this.entries[i];
            }
            return null;
        }

        @Override
        public int getRecordNumber() {
            return this.noOfEntries;
        }

        public DataNotificationEnum addEntry(EventLogEntry eventLogEntry) {
            int n = 0;
            while (this.entries[n] != null) {
                if (this.entries[n].id == eventLogEntry.id) {
                    this.entries[n] = eventLogEntry;
                    this.generateChangeNotification(Database.DatabaseChangeEnum.RECORD_CHANGED);
                    return DataNotificationEnum.DATA_CHANGED;
                }
                if (++n != 1000) continue;
                return null;
            }
            this.noOfEntries = n + 1;
            this.entries[n] = eventLogEntry;
            this.generateChangeNotification(Database.DatabaseChangeEnum.RECORD_ADDED);
            return DataNotificationEnum.NEW_DATA;
        }

        public void clearAll() {
            for (int i = 0; i < this.noOfEntries; ++i) {
                this.entries[i] = null;
            }
            this.noOfEntries = 0;
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }

        @Override
        public String[] getFieldNames() {
            return EventLogEntry.getFieldNames();
        }
    }

    public static class EventLogEntry
    extends DataRecord {
        public static final int IDX_ID = 0;
        public static final int IDX_TIME = 1;
        public static final int IDX_LEVEL = 2;
        public static final int IDX_NAME = 3;
        public static final int IDX_COUNT = 4;
        public static final int IDX_MESSAGE = 5;
        public static final int NUMBER_OF_FIELDS = 6;
        private static String[] fieldNames = new String[]{"id", "time", "level", "subsystem", "count", "message"};
        public int id = 0;
        public String time = null;
        public OmiMessage.EventLogEntryLevelType level = OmiMessage.EventLogEntryLevelType.Event;
        public String name = null;
        public int count = 0;
        public String message = null;

        public static void setTableHeaderText(int n, String string) {
            if (n >= 0 && n < 6) {
                EventLogEntry.fieldNames[n] = string;
            }
        }

        public static String[] getFieldNames() {
            return fieldNames;
        }

        @Override
        public Object getField(int n) {
            switch (n) {
                case 0: {
                    return this.id;
                }
                case 1: {
                    return this.time;
                }
                case 2: {
                    return this.level;
                }
                case 3: {
                    return this.name;
                }
                case 4: {
                    return this.count;
                }
                case 5: {
                    return this.message.substring(this.message.indexOf(58) + 1);
                }
            }
            return null;
        }

        @Override
        public EventLogEntry clone() {
            EventLogEntry eventLogEntry = new EventLogEntry();
            eventLogEntry.id = this.id;
            eventLogEntry.time = this.time;
            eventLogEntry.level = this.level;
            eventLogEntry.name = this.name;
            eventLogEntry.count = this.count;
            eventLogEntry.message = this.message;
            return eventLogEntry;
        }

        public String toString() {
            return this.name;
        }
    }

    public static interface EventLogNotificationInterface {
        public void processEventLogDataNotification(int var1, DataNotificationEnum var2);
    }
}

