/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.OmiHandler;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;

public class MessagingHandler
implements OmiManagementEventInterface {
    private OmiHandler omiHandler = null;
    private String fromAddr = null;
    private int msgId = 0;

    public MessagingHandler(OmiManagement omiManagement) {
        this.omiHandler = omiManagement.getOmiHandler();
        omiManagement.registerManagementEventListener(this);
    }

    public void setFromAddr(String string) {
        this.fromAddr = string;
    }

    public void registerListener(OmiMessageInterface omiMessageInterface) {
        OmiMessage.elemIds.EventMessageConfirmation.registerDataNotificationListener(omiMessageInterface);
        OmiMessage.elemIds.EventMessageProgress.registerDataNotificationListener(omiMessageInterface);
        OmiMessage.elemIds.EventMessageQueueEmpty.registerDataNotificationListener(omiMessageInterface);
        OmiMessage.elemIds.EventMessageSend.registerDataNotificationListener(omiMessageInterface);
        OmiMessage.elemIds.SendMessageResp.registerDataNotificationListener(omiMessageInterface);
        OmiMessage.elemIds.DeleteMessageResp.registerDataNotificationListener(omiMessageInterface);
        OmiMessage.elemIds.CancelMessageResp.registerDataNotificationListener(omiMessageInterface);
    }

    public void deregisterListener(OmiMessageInterface omiMessageInterface) {
        OmiMessage.elemIds.EventMessageConfirmation.deregisterDataNotificationListener(omiMessageInterface);
        OmiMessage.elemIds.EventMessageProgress.deregisterDataNotificationListener(omiMessageInterface);
        OmiMessage.elemIds.EventMessageQueueEmpty.deregisterDataNotificationListener(omiMessageInterface);
        OmiMessage.elemIds.EventMessageSend.deregisterDataNotificationListener(omiMessageInterface);
        OmiMessage.elemIds.SendMessageResp.deregisterDataNotificationListener(omiMessageInterface);
        OmiMessage.elemIds.DeleteMessageResp.deregisterDataNotificationListener(omiMessageInterface);
        OmiMessage.elemIds.CancelMessageResp.deregisterDataNotificationListener(omiMessageInterface);
    }

    public void SendMessageNoCheck(Message message) {
        if (message != null) {
            OmiMessage omiMessage = message.ConvertToOmiSendMessage();
            this.omiHandler.sendOmiMessage(omiMessage);
        }
    }

    public Boolean SendMessage(Message message) {
        if (message != null && message.sendTime != null && message.fromAddr != null && message.toAddr != null && message.content != null) {
            OmiMessage omiMessage = message.ConvertToOmiSendMessage();
            this.omiHandler.sendOmiMessage(omiMessage);
            return true;
        }
        return false;
    }

    public int sendPlainMessage(String string, OmiMessage.PriorityType priorityType, String string2) {
        ++this.msgId;
        if (this.msgId == Short.MAX_VALUE) {
            this.msgId = 0;
        }
        if (this.fromAddr == null) {
            this.fromAddr = "";
        }
        Message message = new Message();
        message.sendTime = 0;
        message.id = this.msgId;
        message.toAddr = string;
        message.fromAddr = this.fromAddr;
        message.priority = priorityType;
        message.content = string2;
        message.folder = OmiMessage.FolderType.Inbox;
        message.contentType = OmiMessage.ContentType.text_plain;
        this.SendMessage(message);
        return this.msgId;
    }

    public void subscribeForMessageReplys(String string) {
        OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.MessageSend, OmiMessage.EventFilterItems.scheme, string);
    }

    @Override
    public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
        if (omiManagementEventEnum == OmiManagementEventEnum.LINK_READY) {
            // empty if block
        }
    }

    public static class Message {
        public Boolean alwaysIndirect = null;
        public Integer sendTime = null;
        public Integer id = null;
        public Integer ppn = null;
        public String fromAddr = null;
        public String fromName = null;
        public String toAddr = null;
        public String toName = null;
        public String callbackAddr = null;
        public String callbackName = null;
        public Boolean autoCallback = null;
        public OmiMessage.PriorityType priority = null;
        public OmiMessage.FolderType folder = null;
        public Boolean noReply = null;
        public Boolean autoDelete = null;
        public Boolean popUp = null;
        public OmiMessage.EncodingType encoding = null;
        public OmiMessage.ContentType contentType = null;
        public OmiMessage.MessageConfirmType[] confirm = null;
        public String content = null;
        public OmiMessage.MelodyType melody = null;
        public String explicitToneSelection = null;
        public Integer signallingVolume = null;
        public Boolean increasingVolume = null;
        public Boolean vibraCall = null;
        public Boolean discCallOnRecv = null;
        public Boolean noInbandSignalling = null;
        public Boolean ringerTone = null;
        public Integer textColourR = null;
        public Integer textColourG = null;
        public Integer textColourB = null;
        public Integer bgColourR = null;
        public Integer bgColourG = null;
        public Integer bgColourB = null;

        public OmiMessage ConvertToOmiSendMessage() {
            OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.SendMessage);
            if (this.id != null) {
                omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), this.id);
            }
            if (this.alwaysIndirect != null) {
                omiMessage.addAttrib(OmiMessage.attribIds.alwaysIndirect.name(), this.alwaysIndirect);
            }
            OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.msg);
            if (this.sendTime != null) {
                omiMessage2.addAttrib(OmiMessage.MessageType.sendTime.name(), this.sendTime);
            }
            if (this.id != null) {
                omiMessage2.addAttrib(OmiMessage.MessageType.id.name(), this.id);
            }
            if (this.fromAddr != null) {
                omiMessage2.addAttrib(OmiMessage.MessageType.fromAddr.name(), this.fromAddr);
            }
            if (this.fromName != null) {
                omiMessage2.addAttrib(OmiMessage.MessageType.fromName.name(), this.fromName);
            }
            if (this.toAddr != null) {
                omiMessage2.addAttrib(OmiMessage.MessageType.toAddr.name(), this.toAddr);
            }
            if (this.toName != null) {
                omiMessage2.addAttrib(OmiMessage.MessageType.toName.name(), this.toName);
            }
            if (this.callbackAddr != null) {
                omiMessage2.addAttrib(OmiMessage.MessageType.callbackAddr.name(), this.callbackAddr);
            }
            if (this.callbackName != null) {
                omiMessage2.addAttrib(OmiMessage.MessageType.callbackName.name(), this.callbackName);
            }
            if (this.autoCallback != null) {
                omiMessage2.addAttrib(OmiMessage.MessageType.autoCallback.name(), this.autoCallback);
            }
            if (this.priority != null) {
                omiMessage2.addAttrib(OmiMessage.MessageType.priority.name(), this.priority.name());
            }
            if (this.folder != null) {
                omiMessage2.addAttrib(OmiMessage.MessageType.folder.name(), this.folder.name());
            }
            if (this.noReply != null) {
                omiMessage2.addAttrib(OmiMessage.MessageType.noReply.name(), this.noReply);
            }
            if (this.autoDelete != null) {
                omiMessage2.addAttrib(OmiMessage.MessageType.autoDelete.name(), this.autoDelete);
            }
            if (this.popUp != null) {
                omiMessage2.addAttrib(OmiMessage.MessageType.popUp.name(), this.popUp);
            }
            if (this.encoding != null) {
                omiMessage2.addAttrib(OmiMessage.MessageType.encoding.name(), this.encoding.encoding);
            }
            if (this.contentType != null) {
                omiMessage2.addAttrib(OmiMessage.MessageType.contentType.name(), this.contentType.type);
            }
            if (this.content != null) {
                omiMessage2.addAttrib(OmiMessage.MessageType.content.name(), this.content);
            }
            if (this.melody != null) {
                omiMessage2.addAttrib(OmiMessage.MessageType.melody.name(), this.melody.name());
            }
            if (this.explicitToneSelection != null) {
                omiMessage2.addAttrib(OmiMessage.MessageType.explicitToneSelection.name(), this.explicitToneSelection);
            }
            if (this.signallingVolume != null) {
                omiMessage2.addAttrib(OmiMessage.MessageType.signallingVolume.name(), this.signallingVolume);
            }
            if (this.increasingVolume != null) {
                omiMessage2.addAttrib(OmiMessage.MessageType.increasingVolume.name(), this.increasingVolume);
            }
            if (this.vibraCall != null) {
                omiMessage2.addAttrib(OmiMessage.MessageType.vibraCall.name(), this.vibraCall);
            }
            if (this.discCallOnRecv != null) {
                omiMessage2.addAttrib(OmiMessage.MessageType.discCallOnRecv.name(), this.discCallOnRecv);
            }
            if (this.noInbandSignalling != null) {
                omiMessage2.addAttrib(OmiMessage.MessageType.noInbandSignalling.name(), this.noInbandSignalling);
            }
            if (this.ringerTone != null) {
                omiMessage2.addAttrib(OmiMessage.MessageType.ringerTone.name(), this.ringerTone);
            }
            if (this.textColourR != null) {
                omiMessage2.addAttrib(OmiMessage.MessageType.textColourR.name(), this.textColourR);
            }
            if (this.textColourG != null) {
                omiMessage2.addAttrib(OmiMessage.MessageType.textColourG.name(), this.textColourG);
            }
            if (this.textColourB != null) {
                omiMessage2.addAttrib(OmiMessage.MessageType.textColourB.name(), this.textColourB);
            }
            if (this.bgColourR != null) {
                omiMessage2.addAttrib(OmiMessage.MessageType.bgColourR.name(), this.bgColourR);
            }
            if (this.bgColourG != null) {
                omiMessage2.addAttrib(OmiMessage.MessageType.bgColourG.name(), this.bgColourG);
            }
            if (this.bgColourB != null) {
                omiMessage2.addAttrib(OmiMessage.MessageType.bgColourB.name(), this.bgColourB);
            }
            if (this.confirm != null) {
                OmiMessage omiMessage3 = null;
                for (int i = 0; i < this.confirm.length; ++i) {
                    omiMessage3 = omiMessage3 == null ? omiMessage2.addSubElement(OmiMessage.elemIds.confirm) : omiMessage3.addElement(OmiMessage.elemIds.confirm);
                    omiMessage3.addBodyText(this.confirm[i].name());
                }
            }
            return omiMessage;
        }
    }
}

