/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.Base64Coder;
import com.aastra.omilib.OmiHandler;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class OmiFileTransfer {
    private static boolean active = false;
    private static String remoteFileName = null;
    private static String localFileName = null;
    private static OmiHandler omiHandler = null;
    private static OmiManagement omiManagement = null;
    private static FileTransferDataHandler ftDataHandler = null;
    private static FileTransferNotificationInterface eventIf = null;
    private static File localFile = null;
    private static FileOutputStream fos = null;
    private static FileInputStream fis = null;
    private static int fileOffset = 0;
    private static boolean eof = false;
    private static boolean readErr = false;
    private static int fileSize = 0;
    private static final int MAX_PUT_FILE_BLOCK_SIZE = 500;

    private static void sendEvent(OmiFileTransferEvents omiFileTransferEvents, OmiMessage omiMessage, int n) {
        if (eventIf != null) {
            eventIf.omiFileTransferNotification(remoteFileName, omiFileTransferEvents, omiMessage, n);
        }
    }

    public static void setOmiManagement(OmiManagement omiManagement) {
        omiHandler = omiManagement.getOmiHandler();
        OmiFileTransfer.omiManagement = omiManagement;
        if (ftDataHandler == null) {
            ftDataHandler = new FileTransferDataHandler();
            OmiMessage.elemIds.GetFileResp.registerDataNotificationListener(ftDataHandler);
            OmiMessage.elemIds.PutFileResp.registerDataNotificationListener(ftDataHandler);
            omiManagement.registerManagementEventListener(ftDataHandler);
        }
    }

    public static boolean getFileTransferActive() {
        return active;
    }

    public static StartFileTransferReturnEnum startFileTransfer(OmiMessage.elemIds elemIds2, String string, String string2, FileTransferNotificationInterface fileTransferNotificationInterface) {
        if (omiHandler == null) {
            return StartFileTransferReturnEnum.FILE_TRANSFER_NOT_INITIALIZED;
        }
        if (active) {
            return StartFileTransferReturnEnum.FILETRANSFER_ACTIVE;
        }
        if (string == null) {
            return StartFileTransferReturnEnum.WRONG_PARAM;
        }
        if (string2 == null && elemIds2 == OmiMessage.elemIds.GetFile) {
            return StartFileTransferReturnEnum.WRONG_PARAM;
        }
        if (!omiManagement.getOmiLinkState()) {
            return StartFileTransferReturnEnum.NO_LINK_TO_OMM;
        }
        remoteFileName = string;
        localFileName = string2;
        eventIf = fileTransferNotificationInterface;
        fileOffset = 0;
        fileSize = 0;
        active = true;
        if (elemIds2 == OmiMessage.elemIds.GetFile) {
            try {
                localFile = new File(localFileName);
                fos = new FileOutputStream(localFile);
            }
            catch (Exception exception) {
                localFile = null;
                fos = null;
                active = false;
                return StartFileTransferReturnEnum.LOCAL_FILE_ERROR;
            }
            OmiFileTransfer.sendGetFile();
        } else if (elemIds2 == OmiMessage.elemIds.PutFile) {
            eof = false;
            readErr = false;
            try {
                if (localFileName != null) {
                    localFile = new File(localFileName);
                    fis = new FileInputStream(localFile);
                    fileSize = (int)localFile.length();
                }
            }
            catch (Exception exception) {
                localFile = null;
                fis = null;
                active = false;
                return StartFileTransferReturnEnum.LOCAL_FILE_ERROR;
            }
            OmiFileTransfer.sendPutFile();
        }
        return StartFileTransferReturnEnum.FILETRANSFER_START_OK;
    }

    private static void sendGetFile() {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetFile);
        omiMessage.addAttrib(OmiMessage.attribIds.name.name(), remoteFileName);
        omiHandler.sendOmiMessage(omiMessage);
    }

    private static void sendPutFile() {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.PutFile);
        omiMessage.addAttrib(OmiMessage.attribIds.name.name(), remoteFileName);
        if (fis != null) {
            try {
                byte[] byArray = new byte[500];
                int n = fis.read(byArray);
                if (n == -1) {
                    omiMessage.addAttrib(OmiMessage.FileType.eof.name(), 1);
                    omiMessage.addAttrib(OmiMessage.FileType.data.name(), "");
                    omiMessage.addAttrib(OmiMessage.FileType.offset.name(), fileOffset);
                    eof = true;
                } else {
                    String string = new String(Base64Coder.encode(byArray, n));
                    omiMessage.addAttrib(OmiMessage.FileType.data.name(), string);
                    omiMessage.addAttrib(OmiMessage.FileType.offset.name(), fileOffset);
                    fileOffset += n;
                    int n2 = -1;
                    if (fileSize > 0) {
                        n2 = fileOffset * 100 / fileSize;
                        OmiFileTransfer.sendEvent(OmiFileTransferEvents.TRANSFER_NOTIFICATION, null, n2);
                    }
                }
            }
            catch (Exception exception) {
                omiMessage.addAttrib(OmiMessage.FileType.offset.name(), -1);
                readErr = true;
            }
        } else {
            omiMessage.addAttrib(OmiMessage.FileType.eof.name(), 1);
            omiMessage.addAttrib(OmiMessage.FileType.data.name(), "");
            omiMessage.addAttrib(OmiMessage.FileType.offset.name(), 0);
            eof = true;
        }
        omiHandler.sendOmiMessage(omiMessage);
    }

    private static void clearPutFile() {
        localFile = null;
        remoteFileName = null;
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            fis = null;
        }
        eof = false;
        readErr = false;
        fileOffset = 0;
        active = false;
    }

    private static void clearGetFile() {
        if (fos != null) {
            try {
                fos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            fos = null;
        }
        localFile = null;
        active = false;
        eof = false;
    }

    public static enum StartFileTransferReturnEnum {
        FILETRANSFER_START_OK,
        FILETRANSFER_ACTIVE,
        WRONG_PARAM,
        FILE_TRANSFER_NOT_INITIALIZED,
        LOCAL_FILE_ERROR,
        NO_LINK_TO_OMM;

    }

    public static class FileTransferDataHandler
    implements OmiMessageInterface,
    OmiManagementEventInterface {
        @Override
        public void processOmiMessage(OmiMessage omiMessage) {
            switch (omiMessage.id) {
                case GetFileResp: {
                    String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                    if (string != null) {
                        active = false;
                        OmiFileTransfer.sendEvent(OmiFileTransferEvents.TRANSFER_ERROR, omiMessage, 0);
                        OmiFileTransfer.clearGetFile();
                        break;
                    }
                    int n = omiMessage.getAttribValInt(OmiMessage.FileType.offset.name());
                    String string2 = omiMessage.getAttribVal(OmiMessage.FileType.data.name());
                    String string3 = omiMessage.getAttribVal(OmiMessage.FileType.name.name());
                    String string4 = omiMessage.getAttribVal(OmiMessage.FileType.size.name());
                    if (string4 != null) {
                        fileSize = Integer.parseInt(string4);
                    }
                    eof = omiMessage.getAttribValBool(OmiMessage.FileType.eof.name());
                    if (!string3.equals(remoteFileName)) {
                        active = false;
                        OmiFileTransfer.sendEvent(OmiFileTransferEvents.ERROR_NAME_CONFLICT, null, 0);
                        OmiFileTransfer.clearGetFile();
                        break;
                    }
                    if (n != fileOffset) {
                        active = false;
                        OmiFileTransfer.sendEvent(OmiFileTransferEvents.ERROR_OFFSET_MISMATCH, null, 0);
                        OmiFileTransfer.clearGetFile();
                        break;
                    }
                    byte[] byArray = Base64Coder.decode(string2);
                    fileOffset = fileOffset + byArray.length;
                    int n2 = -1;
                    if (fileSize > 0) {
                        n2 = fileOffset * 100 / fileSize;
                        OmiFileTransfer.sendEvent(OmiFileTransferEvents.TRANSFER_NOTIFICATION, null, n2);
                    }
                    if (fos != null) {
                        try {
                            fos.write(byArray);
                            fos.flush();
                        }
                        catch (IOException iOException) {
                            active = false;
                            OmiFileTransfer.sendEvent(OmiFileTransferEvents.TRANSFER_ERROR, null, 0);
                            OmiFileTransfer.clearGetFile();
                        }
                    }
                    if (eof) {
                        active = false;
                        OmiFileTransfer.sendEvent(OmiFileTransferEvents.TRANSFER_COMPLETED, null, 0);
                        OmiFileTransfer.clearGetFile();
                        break;
                    }
                    OmiFileTransfer.sendGetFile();
                    break;
                }
                case PutFileResp: {
                    String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                    if (string != null) {
                        if (readErr) {
                            active = false;
                            OmiFileTransfer.sendEvent(OmiFileTransferEvents.ERROR_READING_FILE, null, 0);
                            OmiFileTransfer.clearPutFile();
                            break;
                        }
                        active = false;
                        OmiFileTransfer.sendEvent(OmiFileTransferEvents.TRANSFER_ERROR, omiMessage, 0);
                        OmiFileTransfer.clearPutFile();
                        break;
                    }
                    if (eof) {
                        active = false;
                        OmiFileTransfer.sendEvent(OmiFileTransferEvents.TRANSFER_COMPLETED, null, 0);
                        OmiFileTransfer.clearPutFile();
                        break;
                    }
                    OmiFileTransfer.sendPutFile();
                    break;
                }
            }
        }

        @Override
        public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
            if (omiManagementEventEnum == OmiManagementEventEnum.LINK_CLOSED && active) {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    active = false;
                    OmiFileTransfer.sendEvent(OmiFileTransferEvents.TRANSFER_ERROR, null, 0);
                    fos = null;
                    localFile = null;
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    active = false;
                    OmiFileTransfer.sendEvent(OmiFileTransferEvents.TRANSFER_ERROR, null, 0);
                    fis = null;
                    localFile = null;
                }
            }
        }
    }

    public static interface FileTransferNotificationInterface {
        public void omiFileTransferNotification(String var1, OmiFileTransferEvents var2, OmiMessage var3, int var4);
    }

    public static enum OmiFileTransferLogicalName {
        CONFIG(":config"),
        EMPTY(":empty"),
        EULA(":eula"),
        IMA(":ima"),
        SYSDUMP(":sysdump"),
        PARK(":park"),
        MOMIPDECTTEMPLATE(":momIPDectTemplate"),
        MOMPROVISIONING(":momProvisioning");

        private String str;

        private OmiFileTransferLogicalName(String string2) {
            this.str = string2;
        }

        public String toString() {
            return this.str;
        }

        public boolean isOfType(String string) {
            return string != null && string.equals(this.str);
        }
    }

    public static enum OmiFileTransferEvents {
        TRANSFER_COMPLETED,
        TRANSFER_NOTIFICATION,
        TRANSFER_ERROR,
        ERROR_NAME_CONFLICT,
        ERROR_OFFSET_MISMATCH,
        ERROR_READING_FILE;

    }
}

