/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiMessage;
import com.aastra.util.UtilSpy;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Scanner;
import java.util.Timer;
import java.util.TimerTask;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class OmiHandler
extends Thread {
    private OmiManagement omiManagement = null;
    private Socket socket = null;
    private SSLSocket sslSocket = null;
    private boolean linkOpen = false;
    private OutputStream outputStream = null;
    private OutputStreamWriter outputWriter = null;
    private String ommAddress = null;
    private boolean useSsl = false;
    private Integer port = null;
    private boolean terminateFlag = false;
    private boolean openLinkReqFlag = true;
    private boolean socketClosedByApp = false;
    private Timer keepAliveTimer = null;
    private int keepAliveCounter = 0;
    private Timer pingRespTimer = null;
    private static final int KEEP_ALIVE_TIMEOUT = 240;
    private static final int TIMER_TICK = 20;
    private static final int PING_RESP_TIMEOUT = 20;

    public void handlePingResp() {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_LINK, this, "Received ping response");
        if (this.pingRespTimer != null) {
            this.pingRespTimer.cancel();
        }
    }

    public OmiHandler(String string) {
        this.ommAddress = string;
    }

    public OmiHandler(String string, boolean bl, boolean bl2) {
        this.ommAddress = string;
        OmiMessage.useSynchronizer = bl;
        this.useSsl = bl2;
    }

    public OmiHandler(String string, boolean bl, boolean bl2, Integer n, OmiManagement omiManagement) {
        this.ommAddress = string;
        OmiMessage.useSynchronizer = bl;
        this.useSsl = bl2;
        if (n != null && n != 0) {
            this.port = n;
        }
        this.omiManagement = omiManagement;
    }

    private void closeLink(boolean bl) {
        if (this.linkOpen) {
            try {
                if (this.socket != null) {
                    if (bl) {
                        this.socketClosedByApp = true;
                    }
                    this.socket.close();
                    this.socket = null;
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_LINK, this, "closeLink: Socket closed");
                }
                if (this.sslSocket != null) {
                    if (bl) {
                        this.socketClosedByApp = true;
                    }
                    this.sslSocket.close();
                    this.sslSocket = null;
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_LINK, this, "closeLink: SSL socket closed");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void closeLink() {
        this.closeLink(true);
    }

    private void changeOmmAddress(String string, boolean bl) {
        boolean bl2 = false;
        if (bl) {
            bl2 = true;
        }
        if (this.ommAddress != null) {
            if (!this.ommAddress.equals(string)) {
                this.ommAddress = string;
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_LINK, this, "Changing OMM address to " + string);
                bl2 = true;
            }
        } else {
            this.ommAddress = string;
            bl2 = true;
        }
        if (bl2 && this.linkOpen) {
            try {
                if (this.socket != null) {
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_LINK, this, "changeOmmAddress: Closing socket");
                    this.socket.close();
                    this.socket = null;
                }
                if (this.sslSocket != null) {
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_LINK, this, "changeOmmAddress: Closing SSL socket");
                    this.sslSocket.close();
                    this.sslSocket = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setOmmAddress(String string, Integer n) {
        if (string == null) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_LINK, this, "setOmmAddress: OMM IP address is null. Returning without changing parameters");
            return;
        }
        boolean bl = false;
        if (n != null && n != 0) {
            if (this.port != null) {
                if (!this.port.equals(n)) {
                    this.port = n;
                    bl = true;
                }
            } else {
                this.port = n;
                bl = true;
            }
        } else if (this.port != null) {
            this.port = null;
            bl = true;
        }
        this.changeOmmAddress(string, bl);
    }

    public void setOmmAddress(String string) {
        this.port = null;
        this.changeOmmAddress(string, false);
    }

    public void enableLinkEstablish() {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_LINK, this, "Link establish enabled");
        this.openLinkReqFlag = true;
    }

    private void sendString(String string) {
        if (string != null && this.outputWriter != null) {
            try {
                this.outputWriter.write(string);
                this.outputWriter.flush();
            }
            catch (IOException iOException) {
                this.linkOpen = false;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_LINK, this, "TX error. Exception: " + iOException.toString());
                this.internalEventLinkReleased();
            }
        }
    }

    public synchronized void sendOmiMessage(OmiMessage omiMessage) {
        if (this.linkOpen) {
            String string = omiMessage.getXmlString();
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "o " + string);
            this.sendString(string + "\u0000");
        }
        this.keepAliveCounter = 0;
    }

    private void processXmlInputBlock(String string) {
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        OmiMessage omiMessage = null;
        OmiMessage omiMessage2 = null;
        boolean bl = false;
        int n = 0;
        try {
            StringReader stringReader = new StringReader(string);
            XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(stringReader);
            while (xMLStreamReader.hasNext()) {
                switch (xMLStreamReader.getEventType()) {
                    case 1: {
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_XML, this, "START_ELEMENT='" + xMLStreamReader.getLocalName() + "'");
                        omiMessage2 = omiMessage == null ? (omiMessage = new OmiMessage(xMLStreamReader.getLocalName())) : (bl ? omiMessage2.addSubElement(xMLStreamReader.getLocalName()) : omiMessage2.addElement(xMLStreamReader.getLocalName()));
                        bl = true;
                        n = 0;
                        for (int i = 0; i < xMLStreamReader.getAttributeCount(); ++i) {
                            omiMessage2.addAttrib(xMLStreamReader.getAttributeLocalName(i), xMLStreamReader.getAttributeValue(i));
                            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_XML, this, "  Attribute='" + xMLStreamReader.getAttributeLocalName(i) + "', value='" + xMLStreamReader.getAttributeValue(i) + "'");
                        }
                        break;
                    }
                    case 4: {
                        if (xMLStreamReader.isWhiteSpace()) break;
                        omiMessage2.addBodyText(xMLStreamReader.getText());
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_XML, this, "  CHARACTERS='" + xMLStreamReader.getText() + "'");
                        break;
                    }
                    case 2: {
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_XML, this, "END_ELEMENT='" + xMLStreamReader.getLocalName() + "'");
                        bl = false;
                        if (++n <= 1) break;
                        omiMessage2 = omiMessage2.getParent();
                        break;
                    }
                }
                xMLStreamReader.next();
            }
            if (omiMessage.id != OmiMessage.elemIds.InvalidId) {
                omiMessage.id.processMessage(omiMessage);
            }
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
            this.omiManagement.setExceptionInfo(new OmiManagement.ExceptionInfo(OmiManagement.ExceptionType.XmlStreamException, xMLStreamException.getMessage()));
            omiMessage = new OmiMessage(OmiMessage.elemIds.internalEvent_Exception);
            omiMessage.id.processMessage(omiMessage);
        }
    }

    private void internalEventLinkReleased() {
        if (!this.socketClosedByApp) {
            OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.internalEvent_LinkReleased);
            omiMessage.id.processMessage(omiMessage);
        }
    }

    public void terminateIpThread() {
        if (this.keepAliveTimer != null) {
            this.keepAliveTimer.cancel();
        }
        if (this.pingRespTimer != null) {
            this.pingRespTimer.cancel();
        }
        this.terminateFlag = true;
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
            if (this.sslSocket != null) {
                this.sslSocket.close();
                this.sslSocket = null;
            }
        }
        catch (IOException iOException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_LINK, this, "Closing socket failed. Exception: " + iOException.toString());
        }
    }

    @Override
    public void run() {
        Object object;
        InputStream inputStream = null;
        Scanner scanner = null;
        this.keepAliveTimer = new Timer("Omilib_KeepAliveTimer");
        this.keepAliveTimer.schedule((TimerTask)new KeepAliveTimer(), 20000L, 20000L);
        if (this.ommAddress == null) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_LINK, this, "OMM IP address is null. Skipping link establish");
            this.openLinkReqFlag = false;
            object = new OmiMessage(OmiMessage.elemIds.internalEvent_LinkOpenFailed);
            ((OmiMessage)object).id.processMessage((OmiMessage)object);
        }
        while (!this.terminateFlag) {
            TrustManager[] trustManagerArray;
            while (!this.openLinkReqFlag) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_LINK, this, String.format("Trying to create socket with %s%s", this.ommAddress, this.port != null ? ":" + this.port : ""));
            try {
                this.openLinkReqFlag = false;
                if (this.useSsl) {
                    Object object2;
                    String[] stringArray;
                    object = null;
                    trustManagerArray = new TrustManager[]{new X509TrustManager(){

                        @Override
                        public X509Certificate[] getAcceptedIssuers() {
                            return null;
                        }

                        @Override
                        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                        }
                    }};
                    try {
                        stringArray = SSLContext.getInstance("SSL");
                        stringArray.init(null, trustManagerArray, new SecureRandom());
                        object = stringArray.getSocketFactory();
                    }
                    catch (Exception exception) {
                        UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_LINK, this, "Creating SSL socket failed. Exception: " + exception.toString());
                        object2 = new OmiMessage(OmiMessage.elemIds.internalEvent_LinkOpenFailed);
                        ((OmiMessage)object2).id.processMessage((OmiMessage)object2);
                    }
                    if (this.port != null) {
                        this.sslSocket = (SSLSocket)((SocketFactory)object).createSocket(this.ommAddress, (int)this.port);
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_LINK, this, "SSL socket with " + this.ommAddress + ":" + this.port + " created");
                    } else {
                        this.sslSocket = (SSLSocket)((SocketFactory)object).createSocket(this.ommAddress, 12622);
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_LINK, this, "SSL socket with " + this.ommAddress + ":12622 created");
                    }
                    stringArray = new String[]{"TLSv1.2"};
                    this.sslSocket.setEnabledProtocols(stringArray);
                    object2 = this.sslSocket.getSession();
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_LINK, this, "Protocol is " + object2.getProtocol() + ", cipher is " + object2.getCipherSuite());
                    inputStream = this.sslSocket.getInputStream();
                    this.outputStream = this.sslSocket.getOutputStream();
                } else {
                    if (this.port != null) {
                        this.socket = new Socket(this.ommAddress, (int)this.port);
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_LINK, this, "Socket with " + this.ommAddress + ":" + this.port + " created");
                    } else {
                        this.socket = new Socket(this.ommAddress, 12621);
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_LINK, this, "Socket with " + this.ommAddress + ":12621 created");
                    }
                    inputStream = this.socket.getInputStream();
                    this.outputStream = this.socket.getOutputStream();
                }
                this.outputWriter = new OutputStreamWriter(this.outputStream, "UTF-8");
                scanner = new Scanner(inputStream, "UTF-8");
                scanner.useDelimiter("\u0000");
                this.linkOpen = true;
                object = new OmiMessage(OmiMessage.elemIds.internalEvent_LinkOpen);
                ((OmiMessage)object).id.processMessage((OmiMessage)object);
            }
            catch (UnknownHostException unknownHostException) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_LINK, this, "Creating socket failed: Unknown host");
                trustManagerArray = new OmiMessage(OmiMessage.elemIds.internalEvent_LinkOpenFailed);
                trustManagerArray.id.processMessage((OmiMessage)trustManagerArray);
            }
            catch (IOException iOException) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_LINK, this, "Creating socket failed. Exception: " + iOException.toString());
                trustManagerArray = new OmiMessage(OmiMessage.elemIds.internalEvent_LinkOpenFailed);
                trustManagerArray.id.processMessage((OmiMessage)trustManagerArray);
            }
            if (this.linkOpen) {
                this.socketClosedByApp = false;
            }
            while (this.linkOpen) {
                if (scanner != null) {
                    if (scanner.hasNext()) {
                        object = scanner.next();
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "i " + (String)object);
                        this.processXmlInputBlock((String)object);
                        continue;
                    }
                    this.linkOpen = false;
                    object = scanner.ioException();
                    if (object != null) {
                        UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_LINK, this, "No RX data received. Exception: " + ((Throwable)object).toString());
                    } else {
                        UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_LINK, this, "No RX data received");
                    }
                    this.internalEventLinkReleased();
                    continue;
                }
                this.linkOpen = false;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_LINK, this, "Link scanner is null");
                this.internalEventLinkReleased();
            }
        }
    }

    public class PingRespTimeout
    extends TimerTask {
        @Override
        public void run() {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_LINK, this, "Ping response not received in time - close link to OMM");
            if (OmiHandler.this.pingRespTimer != null) {
                OmiHandler.this.pingRespTimer.cancel();
            }
            OmiHandler.this.closeLink(false);
        }
    }

    public class KeepAliveTimer
    extends TimerTask {
        @Override
        public void run() {
            OmiHandler.this.keepAliveCounter++;
            if (OmiHandler.this.keepAliveCounter >= 12) {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_LINK, this, "Keep alive timer elapsed. Sending ping request");
                OmiHandler.this.pingRespTimer = new Timer("Omilib_PingResponseTimer");
                OmiHandler.this.pingRespTimer.schedule((TimerTask)new PingRespTimeout(), 20000L);
                OmiHandler.this.sendOmiMessage(new OmiMessage(OmiMessage.elemIds.Ping));
            }
        }
    }
}

