/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DigitTreatmentHandlerExpanded;
import com.aastra.omilib.OmiHandler;
import com.aastra.omilib.OmiMessageInterface;
import com.aastra.omilib.OmiMessageSynchronizer;
import com.aastra.omilib.OmilibUtil;
import com.aastra.util.UtilSpy;
import java.awt.EventQueue;
import java.io.StringReader;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class OmiMessage {
    public static boolean useSynchronizer = false;
    public elemIds id = null;
    private HashMap<String, String> attribs = null;
    private OmiMessage next = null;
    private OmiMessage subElem = null;
    private ArrayList<String> attribNames = null;
    private int currentNameIdx = 0;
    private String body = null;
    private OmiMessage parent = null;

    public OmiMessage(String string) {
        try {
            this.id = elemIds.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.id = elemIds.InvalidId;
        }
    }

    public OmiMessage(elemIds elemIds2) {
        this.id = elemIds2;
    }

    public OmiMessage addElement(String string) {
        OmiMessage omiMessage;
        this.next = omiMessage = new OmiMessage(string);
        this.next.parent = this.parent;
        return omiMessage;
    }

    public OmiMessage addElement(elemIds elemIds2) {
        OmiMessage omiMessage;
        this.next = omiMessage = new OmiMessage(elemIds2);
        this.next.parent = this.parent;
        return omiMessage;
    }

    public OmiMessage addSubElement(String string) {
        OmiMessage omiMessage;
        this.subElem = omiMessage = new OmiMessage(string);
        this.subElem.parent = this;
        return omiMessage;
    }

    public OmiMessage addSubElement(elemIds elemIds2) {
        OmiMessage omiMessage;
        this.subElem = omiMessage = new OmiMessage(elemIds2);
        this.subElem.parent = this;
        return omiMessage;
    }

    public OmiMessage getSubElement() {
        return this.subElem;
    }

    public OmiMessage getNext() {
        return this.next;
    }

    public OmiMessage getParent() {
        return this.parent;
    }

    public void addAttrib(String string, String string2) {
        if (this.attribs == null) {
            this.attribs = new HashMap();
            this.attribNames = new ArrayList();
        }
        this.attribNames.add(string);
        this.attribs.put(string, string2);
    }

    public void addAttrib(String string, int n) {
        this.addAttrib(string, Integer.toString(n, 10));
    }

    public void addAttrib(String string, long l) {
        this.addAttrib(string, Long.toString(l, 10));
    }

    public void addAttrib(String string, boolean bl) {
        if (bl) {
            this.addAttrib(string, "1");
        } else {
            this.addAttrib(string, "0");
        }
    }

    public void addBodyText(String string) {
        this.body = string;
    }

    public String getBodyText() {
        return this.body;
    }

    public String getAttribVal(String string) {
        if (this.attribs != null) {
            return this.attribs.get(string);
        }
        return null;
    }

    public boolean getAttribValBool(String string) {
        String string2;
        if (this.attribs != null && (string2 = this.attribs.get(string)) != null) {
            return OmilibUtil.interpreteBoolean(string2);
        }
        return false;
    }

    public Boolean getAttribValBoolNotMandatory(String string) {
        String string2;
        if (this.attribs != null && (string2 = this.attribs.get(string)) != null) {
            return OmilibUtil.interpreteBoolean(string2);
        }
        return null;
    }

    public int getAttribValInt(String string) {
        String string2;
        if (this.attribs != null && (string2 = this.attribs.get(string)) != null) {
            try {
                int n = Integer.parseInt(string2);
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        return 0;
    }

    public long getAttribValLong(String string) {
        String string2;
        if (this.attribs != null && (string2 = this.attribs.get(string)) != null) {
            try {
                long l = Long.parseLong(string2);
                return l;
            }
            catch (NumberFormatException numberFormatException) {
                return 0L;
            }
        }
        return 0L;
    }

    public Integer getAttribValIntNotMandatory(String string) {
        String string2;
        if (this.attribs != null && (string2 = this.attribs.get(string)) != null) {
            try {
                int n = Integer.parseInt(string2);
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    public String getFirstAttribName() {
        if (this.attribs != null) {
            this.currentNameIdx = 1;
            return this.attribNames.get(0);
        }
        return null;
    }

    public String getNextAttribName() {
        if (this.attribs != null && this.currentNameIdx < this.attribNames.size()) {
            return this.attribNames.get(this.currentNameIdx++);
        }
        return null;
    }

    public int getId() {
        return this.id.ordinal();
    }

    public String getElemName() {
        return this.id.name();
    }

    public String getXmlString() {
        return this.appendToXmlString("");
    }

    private static String toXML(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.current();
        while (c != '\uffff') {
            if (c == '<') {
                stringBuilder.append("&lt;");
            } else if (c == '>') {
                stringBuilder.append("&gt;");
            } else if (c == '\"') {
                stringBuilder.append("&quot;");
            } else if (c == '\'') {
                stringBuilder.append("&#039;");
            } else if (c == '&') {
                stringBuilder.append("&amp;");
            } else {
                stringBuilder.append(c);
            }
            c = stringCharacterIterator.next();
        }
        return stringBuilder.toString();
    }

    private String appendToXmlString(String string) {
        if (this.id != elemIds.InvalidId) {
            string = string + "<" + this.id.name() + " ";
            String string2 = this.getFirstAttribName();
            while (string2 != null) {
                string = string + string2 + "=\"" + OmiMessage.toXML(this.getAttribVal(string2)) + "\" ";
                string2 = this.getNextAttribName();
            }
            if (this.subElem != null) {
                string = string + ">";
                if (this.body != null) {
                    string = string + this.body;
                }
                string = this.subElem.appendToXmlString(string);
                string = string + "</" + this.id.name() + ">";
            }
            if (this.next != null) {
                if (this.body != null) {
                    string = string + ">" + OmiMessage.toXML(this.body) + "</" + this.id.name() + ">";
                } else if (this.subElem == null) {
                    string = string + "/>";
                }
                string = this.next.appendToXmlString(string);
            } else if (this.body != null) {
                string = string + ">" + OmiMessage.toXML(this.body) + "</" + this.id.name() + ">";
            } else if (this.subElem == null) {
                string = string + "/>";
            }
        }
        return string;
    }

    public static void sendEventSubscription(OmiHandler omiHandler, CmdType cmdType, EventType eventType, EventFilterItems eventFilterItems, String string) {
        OmiMessage omiMessage = new OmiMessage(elemIds.Subscribe);
        OmiMessage omiMessage2 = omiMessage.addSubElement(elemIds.e);
        omiMessage2.addAttrib(attribIds.cmd.name(), cmdType.name());
        omiMessage2.addAttrib(attribIds.eventType.name(), eventType.name());
        if (eventFilterItems != null) {
            omiMessage2.addAttrib(eventFilterItems.name(), string);
        }
        omiHandler.sendOmiMessage(omiMessage);
    }

    public static void sendSetEventSubscription(OmiHandler omiHandler, EventType eventType) {
        OmiMessage.sendEventSubscription(omiHandler, CmdType.On, eventType, null, null);
    }

    public static void sendSetEventSubscription(OmiHandler omiHandler, EventType eventType, EventFilterItems eventFilterItems, String string) {
        OmiMessage.sendEventSubscription(omiHandler, CmdType.On, eventType, eventFilterItems, string);
    }

    public static void sendResetEventSubscription(OmiHandler omiHandler, EventType eventType) {
        OmiMessage.sendEventSubscription(omiHandler, CmdType.Off, eventType, null, null);
    }

    public static void sendResetEventSubscription(OmiHandler omiHandler, EventType eventType, EventFilterItems eventFilterItems, String string) {
        OmiMessage.sendEventSubscription(omiHandler, CmdType.Off, eventType, eventFilterItems, string);
    }

    public static OmiMessage convertXmlString(String string) {
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        OmiMessage omiMessage = null;
        OmiMessage omiMessage2 = null;
        boolean bl = false;
        int n = 0;
        try {
            StringReader stringReader = new StringReader(string);
            XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(stringReader);
            while (xMLStreamReader.hasNext()) {
                switch (xMLStreamReader.getEventType()) {
                    case 1: {
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_XML, OmiMessage.class, "START_ELEMENT='" + xMLStreamReader.getLocalName() + "'");
                        omiMessage2 = omiMessage == null ? (omiMessage = new OmiMessage(xMLStreamReader.getLocalName())) : (bl ? omiMessage2.addSubElement(xMLStreamReader.getLocalName()) : omiMessage2.addElement(xMLStreamReader.getLocalName()));
                        bl = true;
                        n = 0;
                        for (int i = 0; i < xMLStreamReader.getAttributeCount(); ++i) {
                            omiMessage2.addAttrib(xMLStreamReader.getAttributeLocalName(i), xMLStreamReader.getAttributeValue(i));
                            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_XML, OmiMessage.class, "  Attribute='" + xMLStreamReader.getAttributeLocalName(i) + "', value='" + xMLStreamReader.getAttributeValue(i) + "'");
                        }
                        break;
                    }
                    case 4: {
                        if (xMLStreamReader.isWhiteSpace()) break;
                        omiMessage2.addBodyText(xMLStreamReader.getText());
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_XML, OmiMessage.class, "  CHARACTERS='" + xMLStreamReader.getText() + "'");
                        break;
                    }
                    case 2: {
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_XML, OmiMessage.class, "END_ELEMENT='" + xMLStreamReader.getLocalName() + "'");
                        bl = false;
                        if (++n <= 1) break;
                        omiMessage2 = omiMessage2.getParent();
                        break;
                    }
                }
                xMLStreamReader.next();
            }
        }
        catch (Exception exception) {
            return null;
        }
        return omiMessage;
    }

    public static enum PpProfileDataSetType {
        name,
        id,
        timeStamp,
        ppData,
        healthState;

    }

    public static enum ParkServerResultType {
        Success,
        RequestAlreadyStarted,
        NoOwnMACAddress,
        FileTransferError,
        ServerResponseError,
        InvalidPARK,
        WrongMAC,
        WrongChecksum,
        MissingParam,
        FileError;

    }

    public static enum EventLogEntryLevelType {
        Always(null),
        GenInfo(null),
        FnEnter(null),
        Event(null),
        MinorErr(null),
        MajorErr(null),
        FatalErr(null);

        public String guiValue;

        private EventLogEntryLevelType(String string2) {
            this.guiValue = string2;
        }

        public String toString() {
            if (this.guiValue == null) {
                return this.name();
            }
            return this.guiValue;
        }

        public void setGuiValue(String string) {
            if (string != null) {
                this.guiValue = string;
            }
        }
    }

    public static enum EventLogEntryType {
        id,
        time,
        level,
        name,
        count,
        msg;

    }

    public static enum ToneSchemeType {
        AU,
        AT,
        BE,
        BY,
        BR,
        CH,
        CZ,
        DE,
        DK,
        ES,
        EE,
        FI,
        FR,
        GB,
        HU,
        IT,
        LT,
        LV,
        NL,
        NO,
        PL,
        RU,
        SK,
        SE,
        TW,
        UA,
        US;

    }

    public static enum VideoDevFrameRateType {
        FR_5("5"),
        FR_10("10");

        private String guiValue;

        private VideoDevFrameRateType(String string2) {
            this.guiValue = string2;
        }

        public String toString() {
            return this.guiValue;
        }

        public String getAxiVal() {
            return this.guiValue;
        }

        public static VideoDevFrameRateType axiValueToEnum(String string) {
            return VideoDevFrameRateType.guiValueToEnum(string);
        }

        public static VideoDevFrameRateType guiValueToEnum(String string) {
            EnumSet<VideoDevFrameRateType> enumSet = EnumSet.allOf(VideoDevFrameRateType.class);
            for (VideoDevFrameRateType videoDevFrameRateType : enumSet) {
                if (!string.equals(videoDevFrameRateType.guiValue)) continue;
                return videoDevFrameRateType;
            }
            return null;
        }
    }

    public static enum VideoDevResolutionType {
        QCIF(176, 144, "QCIF ( 176 x  144)"),
        QVGA(320, 240, "QVGA ( 320 x  240)"),
        CIF(352, 288, "CIF  ( 352 x  288)"),
        VGA(640, 480, "VGA  ( 640 x  480)"),
        SVGA(800, 600, "SVGA ( 800 x  600)");

        private int x;
        private int y;
        private String guiValue;

        private VideoDevResolutionType(int n2, int n3, String string2) {
            this.x = n2;
            this.y = n3;
            this.guiValue = string2;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public String toString() {
            return this.guiValue;
        }

        public static VideoDevResolutionType guiValueToEnum(String string) {
            EnumSet<VideoDevResolutionType> enumSet = EnumSet.allOf(VideoDevResolutionType.class);
            for (VideoDevResolutionType videoDevResolutionType : enumSet) {
                if (!string.equals(videoDevResolutionType.guiValue)) continue;
                return videoDevResolutionType;
            }
            return null;
        }
    }

    public static enum VideoDevStateType {
        unplugged(null),
        inactive(null),
        active(null),
        failed(null);

        private String guiValue;

        private VideoDevStateType(String string2) {
            this.guiValue = string2;
        }

        public String toString() {
            if (this.guiValue == null) {
                return this.name();
            }
            return this.guiValue;
        }

        public void setGuiValue(String string) {
            if (string != null) {
                this.guiValue = string;
            }
        }

        public static VideoDevStateType guiValueToEnum(String string) {
            EnumSet<VideoDevStateType> enumSet = EnumSet.allOf(VideoDevStateType.class);
            for (VideoDevStateType videoDevStateType : enumSet) {
                if (!string.equals(videoDevStateType.guiValue)) continue;
                return videoDevStateType;
            }
            return null;
        }
    }

    public static enum VideoDevType {
        id,
        tag,
        rfpId,
        usbPath,
        active,
        state,
        name,
        siteId,
        siteName,
        hierarchy1,
        hierarchy2,
        hierarchy3,
        hierarchy4,
        resolution,
        frameRate,
        rotation,
        ppnNum;

    }

    public static enum BtBeaconClientStatisticDataType {
        ppn,
        ethAddr,
        btLocStat;

    }

    public static enum BtBeaconStatisticDataType {
        id,
        rssi;

    }

    public static enum BtBeaconStateType {
        unplugged(null),
        plugged(null),
        failed(null);

        private String guiValue;

        private BtBeaconStateType(String string2) {
            this.guiValue = string2;
        }

        public String toString() {
            if (this.guiValue == null) {
                return this.name();
            }
            return this.guiValue;
        }

        public void setGuiValue(String string) {
            if (string != null) {
                this.guiValue = string;
            }
        }

        public static BtBeaconStateType guiValueToEnum(String string) {
            EnumSet<BtBeaconStateType> enumSet = EnumSet.allOf(BtBeaconStateType.class);
            for (BtBeaconStateType btBeaconStateType : enumSet) {
                if (!string.equals(btBeaconStateType.guiValue)) continue;
                return btBeaconStateType;
            }
            return null;
        }
    }

    public static enum BtBeaconType {
        id,
        ethAddr,
        rfpId,
        name,
        hierarchy1,
        hierarchy2,
        hierarchy3,
        hierarchy4,
        rssi,
        calibration,
        state,
        checkpoint,
        neighbour;

    }

    public static enum ConferenceServerSIPType {
        conferenceServerType,
        conferenceServerURI;

    }

    public static enum ConferenceServerSIPTypeType {
        None(null),
        Integrated(null),
        External(null),
        ExternalBlindTransfer(null);

        private String guiValue;

        private ConferenceServerSIPTypeType(String string2) {
            this.guiValue = string2;
        }

        public String toString() {
            if (this.guiValue == null) {
                return this.name();
            }
            return this.guiValue;
        }

        public void setGuiValue(String string) {
            if (string != null) {
                this.guiValue = string;
            }
        }

        public static ConferenceServerSIPTypeType guiValueToEnum(String string) {
            EnumSet<ConferenceServerSIPTypeType> enumSet = EnumSet.allOf(ConferenceServerSIPTypeType.class);
            for (ConferenceServerSIPTypeType conferenceServerSIPTypeType : enumSet) {
                if (!string.equals(conferenceServerSIPTypeType.guiValue)) continue;
                return conferenceServerSIPTypeType;
            }
            return null;
        }
    }

    public static enum SuplServType {
        callForwDiv,
        locLineHndlg,
        callTransferByHook,
        uriSeparator,
        reRegisterAfterFailOver,
        ringingOnHold,
        transferByHook6xxd,
        releaseInfoTimerActiveCall,
        releaseInfoTimerHoldCall,
        releaseInfoTimerFailedCall,
        callRejectOnSilentCharging;

    }

    public static enum RegistrationTrafficShapingType {
        enable,
        maxRegistrations,
        timeout,
        spreadRegRenew,
        renewalTimer;

    }

    public static enum LicenseServerListType {
        serverActive,
        installationId,
        licenseServer1,
        licenseServer2,
        licenseServer3;

    }

    public static enum LicenseServerType {
        server,
        port,
        serverStandby,
        portStandby;

    }

    public static enum LicenseAttribType {
        type,
        state,
        latency,
        park;

    }

    public static enum LicenseRfpType {
        id,
        ethAddr,
        connected;

    }

    public static enum LicenseType {
        key,
        number,
        systemLicenseVersion,
        messagingLicenseRcvMsgs,
        locatingLicense;

    }

    public static enum LicenseViolationType {
        noViolation,
        noLicense,
        numRFPs,
        swRelease,
        numSendMsgs,
        numLocatables;

    }

    public static enum LicenseStateType {
        noLicense,
        inactiveLicense,
        inactiveLicenseBlocked,
        noRedundancyLicense,
        noRedundancyLicenseBlocked,
        activeLicense,
        activeLicenseBlocked;

    }

    public static enum LicenseTypeType {
        small,
        standard;

    }

    public static enum PBXType {
        pbx,
        pbxPort,
        pbxStb,
        pbxStbPort;

    }

    public static enum HealthStateReasonType {
        ok(""),
        licenseWarningNoRedundancy(""),
        licenseErrorBlocked(""),
        licenseErrorInactive(""),
        licenseErrorMissing(""),
        rfpWarningClusterSyncLost(""),
        standbyWarningConnectionLost(""),
        dbTransferWarningManualDBImportFailed(""),
        dbTransferWarningAutoDBImportFailed(""),
        dbTransferWarningManualDBExportFailed(""),
        dbTransferWarningAutoDBExportFailed(""),
        downloadWarningFileNotAvailableOrCorrupted(""),
        rfpWarningBrandingMismatch(""),
        rfpWarningNoEncryption(""),
        rfpWarningProtocolMismatch(""),
        imaErrorConnectionLost(""),
        imaErrorReadConfirm(""),
        imaWarningMessageQueueFull(""),
        imaWarningErrorSendMessage(""),
        imaWarningErrorDeleteMessage(""),
        imaWarningErrorSendMail(""),
        imaWarningErrorReceiveMail(""),
        imaWarningErrorDeleteMail(""),
        imaWarningErrorGetRssFeed(""),
        rfpWarningStandbyMismatch(""),
        licenseErrorGracePeriodExpired(""),
        licenseWarningAllG729ChannelsInUse(""),
        umoWarningStartUp(""),
        umoWarningTooManyUsers(""),
        umoErrorConnectionLost(""),
        rfpWarningUsbOverloadDetected(""),
        udsErrorCommonUserDataFileImportFailed(""),
        udsErrorCommonUserDataFileInvalidConfig(""),
        udsWarningUserDataFileImportFailed(""),
        udsWarningUserDataFileInvalidConfig(""),
        usbMemWarningMemoryIsMissing(""),
        downloadWarningStartUp(""),
        rfpWarningNoAdvancedFeatures(""),
        ppProfileErrorDefaultProfileRejected(""),
        ppProfileErrorProfileRejected(""),
        licenseServerErrorNotStarted(""),
        licenseServerErrorClientNotConnected(""),
        licenseServerErrorParsingFile(""),
        licenseServerErrorNoLicenseReceived(""),
        licenseServerWarningErrorStandbyMissing(""),
        licenseServerErrorInstallationIDInvalid(""),
        videoErrorDeviceFailed(""),
        videoErrorDeviceUnplugged(""),
        bluetoothErrorBeaconFailed(""),
        bluetoothErrorBeaconUnplugged(""),
        sipCertErrorHTTPTrustedCertificate(""),
        sipCertErrorNotInDatabaseTrustedCertificate(""),
        sipCertErrorFileTransferTrustedCertificate(""),
        sipCertErrorHTTPLocalCertificate(""),
        sipCertErrorNotInDatabaseLocalCertificate(""),
        sipCertErrorFileTransferLocalCertificate(""),
        sipCertErrorHTTPPrivateKey(""),
        sipCertErrorNotInDatabasePrivateKey(""),
        sipCertErrorFileTransferPrivateKey(""),
        axiCommandProcessingError(""),
        provisioningServerError(""),
        dhcpServerInvalidIpAddressRange(""),
        userDeviceSyncErrorCannotConnectToAXI(""),
        userDeviceSyncErrorDifferentAXIVersions(""),
        userDeviceSyncErrorRfpPcOmmConnection(""),
        userDeviceSyncWarningDifferentSystemTimes(""),
        userDeviceSyncErrorSyncActiveCentralOmm(""),
        userDeviceSyncErrorSARINotConfiguredCentralOmm(""),
        imaErrorParseConfigFile(""),
        rfpWarningSupplicantConfigMismatch(""),
        ommCertServerErrorImport(""),
        provisioningCertServerErrorImport(""),
        supplicantCertServerErrorImport(""),
        supplicantWarningEditModeActive("");

        private String translatedString;

        private HealthStateReasonType(String string2) {
            this.translatedString = string2;
        }

        public void setTranslatedString(String string) {
            this.translatedString = string;
        }

        public String getTranslatedString() {
            return this.translatedString;
        }

        public static HealthStateReasonType getValFromTxt(String string) {
            EnumSet<HealthStateReasonType> enumSet = EnumSet.allOf(HealthStateReasonType.class);
            for (HealthStateReasonType healthStateReasonType : enumSet) {
                if (!string.equals(healthStateReasonType.translatedString)) continue;
                return healthStateReasonType;
            }
            return null;
        }
    }

    public static enum SeverityType {
        OK,
        Idle,
        Warning,
        Error,
        Unknown;

    }

    public static enum HealthStateType {
        component,
        severity,
        reason,
        reasonCode;

    }

    public static enum HealthComponentType {
        sync("Synchronization state"),
        standby("Standby OMM"),
        dbTransfer("DB import/export"),
        download("Downloading new firmware to portable parts"),
        rfp("Radio fixed parts"),
        license("License"),
        ima("OM Integrated Messaging & Alerting service"),
        umo("User monitoring"),
        uds("User data server import"),
        licenseServer("License server"),
        sip("SIP"),
        bluetooth("Bluetooth"),
        video("Video"),
        sipCert("SIP certificate server import"),
        usbMem("USB memory"),
        axiProvisioningCommands("AXI provisioning commands"),
        provisioningServer("Provisioning server"),
        userDeviceSync("User/device synchronisation"),
        dhcpServer("DHCP server"),
        ommCertServer("OMM certificate server import"),
        provCertServer("Provisioning certificate server import"),
        supplicantCertServer("802.1x supplicant certificate server import"),
        supplicant("802.1x supplicant");

        private String translatedString;

        private HealthComponentType(String string2) {
            this.translatedString = string2;
        }

        public void setTranslatedString(String string) {
            this.translatedString = string;
        }

        public String getTranslatedString() {
            return this.translatedString;
        }

        public static HealthComponentType getValFromTxt(String string) {
            EnumSet<HealthComponentType> enumSet = EnumSet.allOf(HealthComponentType.class);
            for (HealthComponentType healthComponentType : enumSet) {
                if (!string.equals(healthComponentType.translatedString)) continue;
                return healthComponentType;
            }
            return null;
        }
    }

    public static enum IMACnfType {
        enable,
        url;

    }

    public static enum PasswordAgingType {
        none("None"),
        time3Months("3 months"),
        time6Months("6 months"),
        count50Logins("50 logins"),
        count100Logins("100 logins");

        private String translatedString;

        private PasswordAgingType(String string2) {
            this.translatedString = string2;
        }

        public void setTranslatedString(String string) {
            this.translatedString = string;
        }

        public String getTranslatedString() {
            return this.translatedString;
        }

        public static PasswordAgingType getValFromTxt(String string) {
            EnumSet<PasswordAgingType> enumSet = EnumSet.allOf(PasswordAgingType.class);
            for (PasswordAgingType passwordAgingType : enumSet) {
                if (!string.equals(passwordAgingType.translatedString)) continue;
                return passwordAgingType;
            }
            return null;
        }
    }

    public static enum AccountStateType {
        id,
        username,
        state;

    }

    public static enum AccountType {
        id,
        username,
        password,
        oldPassword,
        permission,
        active,
        aging,
        expire,
        state;

    }

    public static enum SyslogCnfType {
        enable,
        ipAddr,
        port,
        forward;

    }

    public static enum FileType {
        name,
        offset,
        data,
        eof,
        size;

    }

    public static enum SyncOffsetType {
        id,
        offset,
        rssi,
        lost;

    }

    public static enum WLANClientType {
        ethAddr;

    }

    public static enum ACLEntryType {
        ethAddr,
        name;

    }

    public static enum WLANProfileType {
        id(Integer.class),
        enable(Boolean.class),
        beaconIntval(Integer.class),
        dtimIntval(Integer.class),
        rtsThreshold(Integer.class),
        fragThreshold(Integer.class),
        interferenceAvoidance(Boolean.class),
        maxRate(Integer.class),
        mode(WLANModeType.class),
        qos(WMEQoSType.class),
        profileType(WLANProfileRFPType.class),
        nRFPs(Integer.class);

        public Class<?> type;

        private WLANProfileType(Class<?> clazz) {
            this.type = clazz;
        }
    }

    public static enum WLANProfileRFPType {
        RFP42,
        RFP43;

    }

    public static enum WEPKeyLengthType {
        LEN_64("64"),
        LEN_128("128"),
        LEN_256("256");

        private String guiValue;

        private WEPKeyLengthType(String string2) {
            this.guiValue = string2;
        }

        public String toString() {
            return this.guiValue;
        }

        public String getAxiVal() {
            return this.guiValue;
        }

        public static WEPKeyLengthType axiValueToEnum(String string) {
            return WEPKeyLengthType.guiValueToEnum(string);
        }

        public static WEPKeyLengthType guiValueToEnum(String string) {
            EnumSet<WEPKeyLengthType> enumSet = EnumSet.allOf(WEPKeyLengthType.class);
            for (WEPKeyLengthType wEPKeyLengthType : enumSet) {
                if (!string.equals(wEPKeyLengthType.guiValue)) continue;
                return wEPKeyLengthType;
            }
            return null;
        }
    }

    public static enum WLANMaxRateType {
        RATE_1000("1", "1000"),
        RATE_2000("2", "2000"),
        RATE_5500("5,5", "5500"),
        RATE_6000("6", "6000"),
        RATE_9000("9", "9000"),
        RATE_11000("11", "11000"),
        RATE_12000("12", "12000"),
        RATE_18000("18", "18000"),
        RATE_22000("22", "22000"),
        RATE_24000("24", "24000"),
        RATE_36000("36", "36000"),
        RATE_48000("48", "48000"),
        RATE_54000("54", "54000");

        private String guiValue;
        private String axiValue;

        private WLANMaxRateType(String string2, String string3) {
            this.guiValue = string2;
            this.axiValue = string3;
        }

        public String toString() {
            return this.guiValue;
        }

        public String getAxiVal() {
            return this.axiValue;
        }

        public static WLANMaxRateType axiValueToEnum(String string) {
            EnumSet<WLANMaxRateType> enumSet = EnumSet.allOf(WLANMaxRateType.class);
            for (WLANMaxRateType wLANMaxRateType : enumSet) {
                if (!string.equals(wLANMaxRateType.axiValue)) continue;
                return wLANMaxRateType;
            }
            return null;
        }

        public static WLANMaxRateType guiValueToEnum(String string) {
            EnumSet<WLANMaxRateType> enumSet = EnumSet.allOf(WLANMaxRateType.class);
            for (WLANMaxRateType wLANMaxRateType : enumSet) {
                if (!string.equals(wLANMaxRateType.guiValue)) continue;
                return wLANMaxRateType;
            }
            return null;
        }
    }

    public static enum WMEQoSType {
        None("None", "None"),
        WME("WME", "WME"),
        WME_VLAN("VLAN", "WME-VLAN"),
        WME_DiffServ("Diff serv", "WME-DiffServ");

        public String guiValue;
        public String axiValue;

        private WMEQoSType(String string2, String string3) {
            this.guiValue = string2;
            this.axiValue = string3;
        }

        public String toString() {
            return this.guiValue;
        }

        public String getAxiVal() {
            return this.axiValue;
        }

        public static WMEQoSType guiValueToEnum(String string) {
            EnumSet<WMEQoSType> enumSet = EnumSet.allOf(WMEQoSType.class);
            for (WMEQoSType wMEQoSType : enumSet) {
                if (!string.equals(wMEQoSType.guiValue)) continue;
                return wMEQoSType;
            }
            return null;
        }

        public static WMEQoSType axiValueToEnum(String string) {
            EnumSet<WMEQoSType> enumSet = EnumSet.allOf(WMEQoSType.class);
            for (WMEQoSType wMEQoSType : enumSet) {
                if (!string.equals(wMEQoSType.axiValue)) continue;
                return wMEQoSType;
            }
            return null;
        }
    }

    public static enum WLANModeType {
        B("802.11b"),
        G("802.11g"),
        BG("802.11bg"),
        ABG("802.11abg"),
        N("802.11n");

        public String guiValue;

        private WLANModeType(String string2) {
            this.guiValue = string2;
        }

        public String toString() {
            return this.guiValue;
        }

        public static WLANModeType guiValueToEnum(String string) {
            EnumSet<WLANModeType> enumSet = EnumSet.allOf(WLANModeType.class);
            for (WLANModeType wLANModeType : enumSet) {
                if (!string.equals(wLANModeType.guiValue)) continue;
                return wLANModeType;
            }
            return null;
        }
    }

    public static enum SSIDProfileType {
        enable(Boolean.class),
        ssid(String.class),
        vlanTag(Integer.class),
        security(WLANSecurityType.class),
        distributionIntval(Integer.class),
        privacy(Boolean.class),
        wepKey1(String.class),
        wepKey2(String.class),
        wepKey3(String.class),
        wepKey4(String.class),
        defaultWepKey(Integer.class),
        wepKeyHex(Boolean.class),
        wpaType(WPATypeType.class),
        psk(String.class),
        pskHex(Boolean.class),
        useRadius(Boolean.class),
        radiusAddr(String.class),
        radiusPort(Integer.class),
        radiusSecret(String.class),
        keyLength(Integer.class),
        bssIsolation(Boolean.class),
        useACL(Boolean.class),
        hiddenSSID(Boolean.class);

        public Class<?> type;

        private SSIDProfileType(Class<?> clazz) {
            this.type = clazz;
        }
    }

    public static enum WPATypeType {
        Any,
        WPA1,
        WPA2;

    }

    public static enum WLANSecurityType {
        Open,
        WEP,
        WPA;

    }

    public static enum PublicKeyType {
        modulus,
        exponent;

    }

    public static enum BuiltInAccountType {
        user("Read-only"),
        admin("Full access"),
        root("Root (SSH only)");

        public String translatedString;

        private BuiltInAccountType(String string2) {
            this.translatedString = string2;
        }

        public void setTranslatedString(String string) {
            this.translatedString = string;
        }

        public String getTranslatedString() {
            return this.translatedString;
        }

        public static BuiltInAccountType getValFromTxt(String string) {
            EnumSet<BuiltInAccountType> enumSet = EnumSet.allOf(BuiltInAccountType.class);
            for (BuiltInAccountType builtInAccountType : enumSet) {
                if (!string.equals(builtInAccountType.translatedString)) continue;
                return builtInAccountType;
            }
            return null;
        }
    }

    public static enum BuiltInApplicationType {
        callerList("Caller list"),
        redialList("Redial list"),
        userPresence("User presence"),
        systemApplMenu("System application menu"),
        eventActions("Event actions"),
        admin("Administration"),
        featureAccessCodes("Feature access codes"),
        callCompletion("Call completion"),
        parkCall("Park call"),
        unparkCall("Unpark call"),
        pickup("Pickup"),
        take("Take"),
        callForward("Call forward"),
        callRouting("Call routing"),
        callProtection("Call protection"),
        voiceBox("Voice box");

        public String txt;

        private BuiltInApplicationType(String string2) {
            this.txt = string2;
        }

        public void setTxt(String string) {
            this.txt = string;
        }

        public static BuiltInApplicationType getValFromTxt(String string) {
            EnumSet<BuiltInApplicationType> enumSet = EnumSet.allOf(BuiltInApplicationType.class);
            for (BuiltInApplicationType builtInApplicationType : enumSet) {
                if (!string.equals(builtInApplicationType.txt)) continue;
                return builtInApplicationType;
            }
            return null;
        }
    }

    public static enum XMLApplicationTypeType {
        BuiltIn,
        Dynamic,
        CorpDir,
        BuiltInReadOnly;

    }

    public static enum XMLApplicationType {
        id,
        enable,
        name,
        type,
        corpDirOrder,
        url;

    }

    public static enum AlarmTriggerType {
        id(Integer.class),
        triggerId(String.class),
        fac(String.class),
        comment(String.class),
        num(String.class);

        public Class<?> type;

        private AlarmTriggerType(Class<?> clazz) {
            this.type = clazz;
        }
    }

    public static enum SpecialAlarmTriggerType {
        SOS,
        MANDOWN;

    }

    public static enum FACType {
        feature(FACFeatureType.class),
        enable(Boolean.class),
        fac(String.class);

        public Class<?> type;

        private FACType(Class<?> clazz) {
            this.type = clazz;
        }
    }

    public static enum FACFeatureType {
        ActivateSubscription(null),
        ActivateWildcard(null),
        DeactivateSubscription(null),
        UserLogin(null),
        UserLogout(null),
        SystemCredentialPasswd(null),
        BlindTransfer(null);

        private String guiValue;

        private FACFeatureType(String string2) {
            this.guiValue = string2;
        }

        public String toString() {
            if (this.guiValue == null) {
                return this.name();
            }
            return this.guiValue;
        }

        public void setGuiValue(String string) {
            if (string != null) {
                this.guiValue = string;
            }
        }

        public static FACFeatureType guiValueToEnum(String string) {
            EnumSet<FACFeatureType> enumSet = EnumSet.allOf(FACFeatureType.class);
            for (FACFeatureType fACFeatureType : enumSet) {
                if (!string.equals(fACFeatureType.guiValue)) continue;
                return fACFeatureType;
            }
            return null;
        }
    }

    public static enum CorporateDirectoryOrderType {
        order,
        id;

    }

    public static enum CorporateDirectoryTypeType {
        LDAP("LDAP"),
        XML("XML"),
        XSIenterprise("XSI Enterprise"),
        XSIenterpriseCommon("XSI Enterprise common"),
        XSIgroup("XSI Group"),
        XSIgroupCommon("XSI Group common"),
        XSIpersonal("XSI Personal");

        private String txt;

        private CorporateDirectoryTypeType(String string2) {
            this.txt = string2;
        }

        public String getText() {
            return this.txt;
        }

        public static CorporateDirectoryTypeType getValFromTxt(String string) {
            EnumSet<CorporateDirectoryTypeType> enumSet = EnumSet.allOf(CorporateDirectoryTypeType.class);
            for (CorporateDirectoryTypeType corporateDirectoryTypeType : enumSet) {
                if (!string.equals(corporateDirectoryTypeType.txt)) continue;
                return corporateDirectoryTypeType;
            }
            return null;
        }
    }

    public static enum CorporateDirectoryType {
        id,
        active,
        type,
        name,
        searchType,
        displayType,
        searchBase,
        timeout,
        url;

    }

    public static enum DisplayNewType {
        CN("CN"),
        SN_GN("SN, GN");

        public String str;

        private DisplayNewType(String string2) {
            this.str = string2;
        }

        public String getStringFromEnum() {
            return this.str;
        }

        public static DisplayNewType getEnumFromString(String string) {
            EnumSet<DisplayNewType> enumSet = EnumSet.allOf(DisplayNewType.class);
            for (DisplayNewType displayNewType : enumSet) {
                if (!string.equals(displayNewType.str)) continue;
                return displayNewType;
            }
            return CN;
        }
    }

    public static enum SearchNewType {
        GN,
        SN,
        CN;

    }

    public static enum LDAPNewType {
        id,
        server,
        port,
        searchBase,
        username,
        password,
        searchType,
        displayType,
        timeout,
        active,
        order,
        name;

    }

    public static enum SNMPType {
        readCommunity,
        contact,
        enableTraps,
        trapCommunity,
        trapHostAddr;

    }

    public static enum SiteIdType {
        siteId;

    }

    public static enum ConferenceRoomType {
        id,
        name,
        conferenceId,
        sipAuthId,
        sipPw,
        fixedSipPort,
        calculatedSipPort;

    }

    public static enum DigitTreatmentExpandedType {
        id(Integer.class),
        externalPattern(String.class),
        internalPattern(String.class),
        directory(Boolean.class),
        direction(DigitTreatmentHandlerExpanded.DirectionType.class),
        sites(SiteIdType[].class);

        public Class<?> type;

        private DigitTreatmentExpandedType(Class<?> clazz) {
            this.type = clazz;
        }
    }

    public static enum DigitTreatmentSimpleType {
        id(Integer.class),
        prefix(String.class),
        substitute(String.class);

        public Class<?> type;

        private DigitTreatmentSimpleType(Class<?> clazz) {
            this.type = clazz;
        }
    }

    public static enum DigitTreatmentType {
        id(Integer.class);

        public Class<?> type;

        private DigitTreatmentType(Class<?> clazz) {
            this.type = clazz;
        }
    }

    public static enum SrtpStateType {
        Disabled(null),
        Preferred(null),
        Only(null);

        private String guiValue;

        private SrtpStateType(String string2) {
            this.guiValue = string2;
        }

        public String toString() {
            if (this.guiValue == null) {
                return this.name();
            }
            return this.guiValue;
        }

        public void setGuiValue(String string) {
            if (string != null) {
                this.guiValue = string;
            }
        }

        public static SrtpStateType guiValueToEnum(String string) {
            EnumSet<SrtpStateType> enumSet = EnumSet.allOf(SrtpStateType.class);
            for (SrtpStateType srtpStateType : enumSet) {
                if (!string.equals(srtpStateType.guiValue)) continue;
                return srtpStateType;
            }
            return null;
        }
    }

    public static enum RfpQualityType {
        id(Integer.class, DataClass.ClassReadOnly),
        connects(Integer.class, DataClass.ClassReadOnly),
        duration(Integer.class, DataClass.ClassReadOnly),
        packetsRx(Integer.class, DataClass.ClassReadOnly),
        octetsRx(Integer.class, DataClass.ClassReadOnly),
        packetsTx(Integer.class, DataClass.ClassReadOnly),
        octetsTx(Integer.class, DataClass.ClassReadOnly),
        packetsLost(Integer.class, DataClass.ClassReadOnly),
        maxJitter(Integer.class, DataClass.ClassReadOnly),
        connectedTime(Integer.class, DataClass.ClassReadOnly),
        currentRTT(Integer.class, DataClass.ClassReadOnly),
        maxRTT(Integer.class, DataClass.ClassReadOnly),
        count(Integer.class, DataClass.ClassReadOnly),
        interval1(Integer.class, DataClass.ClassReadOnly),
        interval2(Integer.class, DataClass.ClassReadOnly),
        interval3(Integer.class, DataClass.ClassReadOnly),
        interval4(Integer.class, DataClass.ClassReadOnly),
        interval5(Integer.class, DataClass.ClassReadOnly),
        strongRels(Integer.class, DataClass.ClassReadOnly),
        lowRels(Integer.class, DataClass.ClassReadOnly),
        maxRSSI(Integer.class, DataClass.ClassReadOnly),
        minRSSI(Integer.class, DataClass.ClassReadOnly);

        public Class<?> type;
        public DataClass cl;

        private RfpQualityType(Class<?> clazz, DataClass dataClass) {
            this.type = clazz;
            this.cl = dataClass;
        }
    }

    public static enum MOMControlStateType {
        Connected,
        Disconnected,
        NoMOMControl;

    }

    public static enum ApplicationDataChannelType {
        channelId,
        applData;

    }

    public static enum ApplicationDataChannelCnfType {
        ommId,
        applName,
        channelId,
        subscribed,
        connected;

    }

    public static enum OMMType {
        id(Integer.class, DataClass.ClassReadOnly),
        name(String.class, DataClass.ClassReadWrite),
        desc(String.class, DataClass.ClassReadWrite),
        domain1(String.class, DataClass.ClassReadWrite),
        domain2(String.class, DataClass.ClassReadWrite),
        username(String.class, DataClass.ClassReadWrite),
        password(String.class, DataClass.ClassReadWrite),
        cloudId(String.class, DataClass.ClassReadOnly),
        enable(Boolean.class, DataClass.ClassReadWrite),
        ommProvisioning(Boolean.class, DataClass.ClassReadWrite),
        connected(Boolean.class, DataClass.ClassReadWrite),
        sslMethod(SslMethodType.class, DataClass.ClassReadWrite),
        validateCerts(Boolean.class, DataClass.ClassReadWrite),
        validateExpires(Boolean.class, DataClass.ClassReadWrite),
        validateHostName(Boolean.class, DataClass.ClassReadWrite),
        allowNonConfTrustCerts(Boolean.class, DataClass.ClassReadWrite),
        importCerts(Boolean.class, DataClass.ClassReadWrite);

        public Class<?> type;
        public DataClass cl;

        private OMMType(Class<?> clazz, DataClass dataClass) {
            this.type = clazz;
            this.cl = dataClass;
        }
    }

    public static enum SiteType {
        id(Integer.class, DataClass.ClassReadOnly),
        name(String.class, DataClass.ClassReadWrite),
        nRFPs(Integer.class, DataClass.ClassReadOnly),
        wideband(Boolean.class, DataClass.ClassReadWrite),
        srtp(SrtpStateType.class, DataClass.ClassReadWrite),
        dectSecurity(Boolean.class, DataClass.ClassReadWrite),
        videoStreaming(Boolean.class, DataClass.ClassReadWrite);

        public Class<?> type;
        public DataClass cl;

        private SiteType(Class<?> clazz, DataClass dataClass) {
            this.type = clazz;
            this.cl = dataClass;
        }
    }

    public static enum SoftwareUpdateType {
        timedUpdate,
        allAtOnce,
        hour,
        minute,
        maxDelay,
        hourCalculated,
        minuteCalculated;

    }

    public static enum TimeZoneType {
        id,
        name,
        stdOffset,
        stdMonth,
        stdDay,
        stdDoW,
        stdWoM,
        stdHour,
        stdMin,
        dstOffset,
        dstMonth,
        dstDay,
        dstDoW,
        dstWoM,
        dstHour,
        dstMin;

    }

    public static enum SysStatNameType {
        elemId,
        type,
        name,
        resolution,
        duration,
        numOfRecords,
        sum,
        unit,
        numOfFreqDistUnits;

    }

    public static enum StatisticType {
        occurrence,
        min,
        max,
        sum,
        minmax;

    }

    public static enum VisibilityType {
        id,
        rssiAvg;

    }

    public static enum LocationType {
        id,
        rssiNew,
        rssiOld,
        nMultiFrame;

    }

    public static enum RFPStatNameType {
        elemId,
        group,
        name;

    }

    public static enum RFPStatSummaryType {
        numElemPerRec,
        recordSets,
        resolution;

    }

    public static enum MelodyType {
        None,
        MsgMelody1,
        MsgMelody2,
        MsgMelody3,
        MsgMelody4,
        MsgMelody5,
        MsgMelody6,
        MsgMelody7,
        MsgMelody8,
        MsgMelody9,
        MsgMelody10,
        MsgMelody11,
        MsgMelody12,
        MsgMelody13,
        MsgMelody14,
        MsgMelody15,
        MsgMelody16,
        MsgMelody17,
        MsgMelody18,
        MsgMelody19,
        MsgMelody20;

    }

    public static enum MessageProgressType {
        Overridden,
        DeleteOverridden,
        Delivered,
        DeleteDelivered,
        PagingTimeout,
        Rejected,
        Busy,
        WrongCharacterSet,
        WrongURI,
        TemporaryUnavailable,
        Unknown;

    }

    public static enum MessageConfirmType {
        ReadYes,
        ReadNo,
        OrderOk,
        OrderNok,
        OrderDontKnow,
        OrderNext,
        CompleteDone,
        CompleteNotDone,
        CompleteFailed;

    }

    public static enum ContentType {
        text_plain("text/plain"),
        text_x_vcard("text/x-vcard");

        public String type;

        private ContentType(String string2) {
            this.type = string2;
        }
    }

    public static enum EncodingType {
        UTF8("UTF-8");

        public String encoding;

        private EncodingType(String string2) {
            this.encoding = string2;
        }
    }

    public static enum FolderType {
        None,
        Idle,
        Inbox,
        AddToInbox,
        AddToPreDefined,
        AddToOutbox;

    }

    public static enum PriorityType {
        Info,
        Low,
        Normal,
        High,
        Emergency,
        LocatingAlert;

    }

    public static enum MessageType {
        sendTime,
        id,
        ppn,
        fromAddr,
        fromName,
        toAddr,
        toName,
        callbackAddr,
        callbackName,
        autoCallback,
        priority,
        folder,
        noReply,
        autoDelete,
        popUp,
        encoding,
        contentType,
        confirm,
        content,
        melody,
        explicitToneSelection,
        signallingVolume,
        increasingVolume,
        vibraCall,
        discCallOnRecv,
        noInbandSignalling,
        ringerTone,
        textColourR,
        textColourG,
        textColourB,
        bgColourR,
        bgColourG,
        bgColourB;

    }

    public static enum CapturedRFPType {
        ethAddr,
        ipAddr,
        hwType,
        hasWlan,
        radioType,
        outdoorType,
        hasFreqShift;

    }

    public static enum RFPWlanHTUsedType {
        None(null),
        HT20(null),
        HT40Minus(null),
        HT40Plus(null);

        private String guiValue;

        private RFPWlanHTUsedType(String string2) {
            this.guiValue = string2;
        }

        public String toString() {
            if (this.guiValue == null) {
                return this.name();
            }
            return this.guiValue;
        }

        public void setGuiValue(String string) {
            if (string != null) {
                this.guiValue = string;
            }
        }

        public static RFPWlanHTUsedType guiValueToEnum(String string) {
            EnumSet<RFPWlanHTUsedType> enumSet = EnumSet.allOf(RFPWlanHTUsedType.class);
            for (RFPWlanHTUsedType rFPWlanHTUsedType : enumSet) {
                if (!string.equals(rFPWlanHTUsedType.guiValue)) continue;
                return rFPWlanHTUsedType;
            }
            return null;
        }
    }

    public static enum RfpCapabilityStateType {
        NotSupportedInactive,
        SupportedInactive,
        NotSupportedError,
        SupportedActive;

    }

    public static enum RFPSyncStateType {
        Inactive,
        NotSynced,
        Searching,
        Synced;

    }

    public static enum RFPRadioTypeType {
        None,
        LowTX,
        NormalTX,
        ConfigurableTX;

    }

    public static enum RFPHwTypeType {
        UNKNOWN("unknown", "Auto", "0"),
        RFP31("RFP 31", "RFP 31/32/33/34", "31"),
        RFP33("RFP 33", "RFP 31/32/33/34", "33"),
        RFP41("RFP 41", "RFP 41/42", "41"),
        RFP32("RFP 32", "RFP 31/32/33/34", "32"),
        RFP32US("RFP 32 US", "RFP 31/32/33/34", "32"),
        RFP34("RFP 34", "RFP 31/32/33/34", "34"),
        RFP34US("RFP 34 US", "RFP 31/32/33/34", "34"),
        RFP42("RFP 42", "RFP 41/42", "42"),
        RFP42US("RFP 42 US", "RFP 41/42", "42"),
        RFP35("RFP 35", "RFP 35/36/37", "35"),
        RFP36("RFP 36", "RFP 35/36/37", "36"),
        RFP37("RFP 37", "RFP 35/36/37", "37"),
        RFP43("RFP 43", "RFP 43", "43"),
        RFPL31("RFP L31", "RFP 31/32/33/34", "31"),
        RFPL33("RFP L33", "RFP 31/32/33/34", "33"),
        RFPL41("RFP L41", "RFP 41/42", "41"),
        RFPL32("RFP L32", "RFP 31/32/33/34", "32"),
        RFPL32US("RFP L32 US", "RFP 31/32/33/34", "32"),
        RFPL34("RFP L34", "RFP 31/32/33/34", "34"),
        RFPL34US("RFP L34 US", "RFP 31/32/33/34", "34"),
        RFPL42("RFP L42", "RFP 41/42", "42"),
        RFPL42US("RFP L42 US", "RFP 41/42", "42"),
        RFPL35("RFP L35", "RFP 35/36/37", "35"),
        RFPL36("RFP L36", "RFP 35/36/37", "36"),
        RFPL37("RFP L37", "RFP 35/36/37", "37"),
        RFPL43("RFP L43", "RFP 43", "43"),
        RFPSL35("RFP SL35", "RFP 35/36/37", "35"),
        RFPSL36("RFP SL36", "RFP 35/36/37", "36"),
        RFPSL37("RFP SL37", "RFP 35/36/37", "37"),
        RFPSL43("RFP SL43", "RFP 43", "43"),
        PCECM("PC ECM", "PC ECM", "0");

        public String strRealHw;
        public String strPreselect;
        public String strExport;

        private RFPHwTypeType(String string2, String string3, String string4) {
            this.strRealHw = string2;
            this.strPreselect = string3;
            this.strExport = string4;
        }

        public void setStrPreselect(String string) {
            this.strPreselect = string;
        }

        public String getStrPreselect() {
            return this.strPreselect;
        }

        public static RFPHwTypeType getTypeFromStrRealHw(String string) {
            EnumSet<RFPHwTypeType> enumSet = EnumSet.allOf(RFPHwTypeType.class);
            for (RFPHwTypeType rFPHwTypeType : enumSet) {
                if (!string.equals(rFPHwTypeType.strRealHw)) continue;
                return rFPHwTypeType;
            }
            return UNKNOWN;
        }

        public static RFPHwTypeType getTypeFromStrPreselect(String string) {
            if (string.equals("RFP 31/32/33/34")) {
                return RFP32;
            }
            if (string.equals("RFP 41/42")) {
                return RFP42;
            }
            if (string.equals("RFP 35/36/37")) {
                return RFP35;
            }
            if (string.equals("RFP 43")) {
                return RFP43;
            }
            return UNKNOWN;
        }

        public static String getStrPreselectFromStrExport(String string) {
            EnumSet<RFPHwTypeType> enumSet = EnumSet.allOf(RFPHwTypeType.class);
            for (RFPHwTypeType rFPHwTypeType : enumSet) {
                if (!string.equals(rFPHwTypeType.strExport)) continue;
                return rFPHwTypeType.strPreselect;
            }
            return RFPHwTypeType.UNKNOWN.strPreselect;
        }
    }

    public static enum RFPType {
        id(Integer.class, DataClass.ClassReadOnly, 0, "rfp Id"),
        ethAddr(String.class, DataClass.ClassReadWrite, 0, "eth Address"),
        dectOn(Boolean.class, DataClass.ClassReadWrite, 0, "dect enabled"),
        wlanOn(Boolean.class, DataClass.ClassReadWrite, 0, "wlan enabled"),
        licenseRfp(Boolean.class, DataClass.ClassReadWrite, 0, "license rfp"),
        name(String.class, DataClass.ClassReadWrite, 0, "name"),
        site(Integer.class, DataClass.ClassReadWrite, 0, "site id"),
        hierarchy1(String.class, DataClass.ClassReadWrite, 0, "building"),
        hierarchy2(String.class, DataClass.ClassReadWrite, 0, "floor"),
        hierarchy3(String.class, DataClass.ClassReadWrite, 0, "room"),
        hierarchy4(String.class, DataClass.ClassReadWrite, 0, "hierarchy4"),
        rpn(Integer.class, DataClass.ClassReadWrite, 0, "rpn"),
        pagingArea(Integer.class, DataClass.ClassReadWrite, 0, "paging area"),
        cluster(Integer.class, DataClass.ClassReadWrite, 0, "cluster"),
        preferredSync(Boolean.class, DataClass.ClassReadWrite, 0, "preferred sync"),
        reflectiveEnv(Boolean.class, DataClass.ClassReadWrite, 0, "reflective env"),
        conferenceChannels(Boolean.class, DataClass.ClassReadWrite, 0, "conference channels"),
        x(Integer.class, DataClass.ClassReadWrite, 0, "x position"),
        y(Integer.class, DataClass.ClassReadWrite, 0, "y position"),
        wlanProfile(Integer.class, DataClass.ClassReadWrite, 0, "wlan profile"),
        wlanAntennaDiv(Boolean.class, DataClass.ClassReadWrite, 0, "wlan antenna div."),
        wlanHighThroughput(Boolean.class, DataClass.ClassReadWrite, 0, "wlan high through."),
        wlanAntenna(Integer.class, DataClass.ClassReadWrite, 0, "wlan antenna"),
        wlanChannel(Integer.class, DataClass.ClassReadWrite, 0, "wlan channel"),
        wlanPower(Integer.class, DataClass.ClassReadWrite, 0, "wlan power"),
        hwType(RFPHwTypeType.class, DataClass.ClassReadWrite, 0, "hw type"),
        hwTypeLocked(Boolean.class, DataClass.ClassReadOnly, 0, "hw type locked"),
        connected(Boolean.class, DataClass.ClassReadOnly, 0, "connected"),
        ipAddr(String.class, DataClass.ClassReadOnly, 0, "ip address"),
        dectRunning(Boolean.class, DataClass.ClassReadOnly, 0, "dect running"),
        wlanRunning(Boolean.class, DataClass.ClassReadOnly, 0, "wlan running"),
        ommRunning(Boolean.class, DataClass.ClassReadOnly, 0, "omm running"),
        ommStbRunning(Boolean.class, DataClass.ClassReadOnly, 0, "standby omm running"),
        hasWlan(Boolean.class, DataClass.ClassReadOnly, 0, "wlan avail."),
        syncState(RFPSyncStateType.class, DataClass.ClassReadOnly, 0, "sync state"),
        swVersion(String.class, DataClass.ClassReadOnly, 0, "sw version"),
        newSoftwareRequest(Boolean.class, DataClass.ClassReadOnly, 0, "new sw request"),
        brandingMismatch(Boolean.class, DataClass.ClassReadOnly, 0, "branding mismatch"),
        versionMismatch(Boolean.class, DataClass.ClassReadOnly, 0, "version mismatch"),
        stbMismatch(Boolean.class, DataClass.ClassReadOnly, 0, "standby omm mism."),
        wlanLinkNok(Boolean.class, DataClass.ClassReadOnly, 0, "wlan link not ok"),
        hasEncryption(Boolean.class, DataClass.ClassReadOnly, 0, "encryption"),
        hasAdvancedFeatures(Boolean.class, DataClass.ClassReadOnly, 0, "advanced feat."),
        wlanChannelUsed(Integer.class, DataClass.ClassReadOnly, 0, "wlan chan used"),
        wlanHighThroughputTypeUsed(RFPWlanHTUsedType.class, DataClass.ClassReadOnly, 0, "wlan ht used"),
        wlanPowerUsed(Integer.class, DataClass.ClassReadOnly, 0, "wlan power used"),
        supplicantCertificateMismatch(Boolean.class, DataClass.ClassReadOnly, 0, "802.1X cfg. mism."),
        radioType(RFPRadioTypeType.class, DataClass.ClassReadOnly, 0, "radio type"),
        outdoorType(Boolean.class, DataClass.ClassReadOnly, 0, "outdoor"),
        hasFreqShift(Boolean.class, DataClass.ClassReadOnly, 0, "freq. shift"),
        nSyncRels(Integer.class, DataClass.ClassReadOnly, 0, "n sync rels");

        public Class<?> type;
        public DataClass cl;
        public int param;
        public String text;

        private RFPType(Class<?> clazz, DataClass dataClass, int n2, String string2) {
            this.type = clazz;
            this.cl = dataClass;
            this.param = n2;
            this.text = string2;
        }

        protected String getText() {
            return this.text;
        }

        protected boolean isClassReadOnly() {
            return this.cl == DataClass.ClassReadOnly;
        }
    }

    public static enum MonitoringStateType {
        Unknown,
        Available,
        Warning,
        Unavailable,
        Escalated;

    }

    public static enum BTSensitivityType {
        low(null),
        medium(null),
        high(null);

        private String guiValue;

        private BTSensitivityType(String string2) {
            this.guiValue = string2;
        }

        public String toString() {
            if (this.guiValue == null) {
                return this.name();
            }
            return this.guiValue;
        }

        public void setGuiValue(String string) {
            if (string != null) {
                this.guiValue = string;
            }
        }

        public static BTSensitivityType guiValueToEnum(String string) {
            EnumSet<BTSensitivityType> enumSet = EnumSet.allOf(BTSensitivityType.class);
            for (BTSensitivityType bTSensitivityType : enumSet) {
                if (!string.equals(bTSensitivityType.guiValue)) continue;
                return bTSensitivityType;
            }
            return null;
        }
    }

    public static enum PPUserLanguageType {
        English(null),
        German(null),
        French(null),
        Spanish(null),
        Italian(null),
        Dutch(null),
        Swedish(null),
        Portuguese(null),
        Danish(null),
        Finnish(null),
        Norwegian(null),
        Czech(null),
        Slovakian(null),
        Hungarian(null),
        Russian(null),
        Turkish(null),
        Polish(null),
        Estonian(null);

        private String guiValue;

        private PPUserLanguageType(String string2) {
            this.guiValue = string2;
        }

        public String toString() {
            if (this.guiValue == null) {
                return this.name();
            }
            return this.guiValue;
        }

        public void setGuiValue(String string) {
            if (string != null) {
                this.guiValue = string;
            }
        }

        public static PPUserLanguageType guiValueToEnum(String string) {
            EnumSet<PPUserLanguageType> enumSet = EnumSet.allOf(PPUserLanguageType.class);
            for (PPUserLanguageType pPUserLanguageType : enumSet) {
                if (!string.equals(pPUserLanguageType.guiValue)) continue;
                return pPUserLanguageType;
            }
            return null;
        }
    }

    public static enum ConferenceServerPPUserTypeType {
        None(null),
        Global(null),
        Integrated(null),
        External(null),
        ExternalBlindTransfer(null);

        private String guiValue;

        private ConferenceServerPPUserTypeType(String string2) {
            this.guiValue = string2;
        }

        public String toString() {
            if (this.guiValue == null) {
                return this.name();
            }
            return this.guiValue;
        }

        public void setGuiValue(String string) {
            if (string != null) {
                this.guiValue = string;
            }
        }

        public static ConferenceServerPPUserTypeType guiValueToEnum(String string) {
            EnumSet<ConferenceServerPPUserTypeType> enumSet = EnumSet.allOf(ConferenceServerPPUserTypeType.class);
            for (ConferenceServerPPUserTypeType conferenceServerPPUserTypeType : enumSet) {
                if (!string.equals(conferenceServerPPUserTypeType.guiValue)) continue;
                return conferenceServerPPUserTypeType;
            }
            return null;
        }
    }

    public static enum GlobalOnOffType {
        Global(null),
        On(null),
        Off(null);

        private String guiValue;

        private GlobalOnOffType(String string2) {
            this.guiValue = string2;
        }

        public String toString() {
            if (this.guiValue == null) {
                return this.name();
            }
            return this.guiValue;
        }

        public void setGuiValue(String string) {
            if (string != null) {
                this.guiValue = string;
            }
        }

        public static GlobalOnOffType guiValueToEnum(String string) {
            EnumSet<GlobalOnOffType> enumSet = EnumSet.allOf(GlobalOnOffType.class);
            for (GlobalOnOffType globalOnOffType : enumSet) {
                if (!string.equals(globalOnOffType.guiValue)) continue;
                return globalOnOffType;
            }
            return null;
        }
    }

    public static enum PPUserKeyLockTimeType {
        NONE(0, "NONE"),
        _10(10, "10"),
        _20(20, "20"),
        _30(30, "30"),
        _60(60, "60"),
        _90(90, "90"),
        _120(120, "120");

        private Integer intVal;
        String guiVal;

        private PPUserKeyLockTimeType(Integer n2, String string2) {
            this.intVal = n2;
            this.guiVal = string2;
        }

        public String getGuiVal() {
            return this.guiVal;
        }

        public void setGuiVal(String string) {
            this.guiVal = string;
        }

        public Integer getIntVal() {
            return this.intVal;
        }

        public static PPUserKeyLockTimeType getEnumFromIntVal(Integer n) {
            EnumSet<PPUserKeyLockTimeType> enumSet = EnumSet.allOf(PPUserKeyLockTimeType.class);
            for (PPUserKeyLockTimeType pPUserKeyLockTimeType : enumSet) {
                if (!n.equals(pPUserKeyLockTimeType.intVal)) continue;
                return pPUserKeyLockTimeType;
            }
            return NONE;
        }

        public static PPUserKeyLockTimeType getEnumFromGuiVal(String string) {
            EnumSet<PPUserKeyLockTimeType> enumSet = EnumSet.allOf(PPUserKeyLockTimeType.class);
            for (PPUserKeyLockTimeType pPUserKeyLockTimeType : enumSet) {
                if (!string.equals(pPUserKeyLockTimeType.guiVal)) continue;
                return pPUserKeyLockTimeType;
            }
            return null;
        }
    }

    public static enum CallForwardStateType {
        Off,
        Busy,
        NoAnswer,
        BusyNoAnswer,
        All;

    }

    public static enum PPDevDummiesType {
        uidHex,
        ppnHex,
        acCodeMigrated;

    }

    public static enum PPUserDummiesType {
        uidHex,
        ppnHex,
        ppnOldHex;

    }

    public static enum RFPSummaryType {
        nRFPs,
        idFirst,
        nConnected,
        wrongBrandedRFPs,
        wrongStandbyRFPs,
        wrongVersionedRFPs,
        newAvailSWRFPs,
        advancedFeaturesErrorRFPs,
        DecryptedDECTRFPs,
        DECTactivatedRFPs,
        DECTactiveRFPs,
        WLANactivatedRFPs,
        WLANrunningRFPs,
        usedDECTclusters,
        usedPagingAreas,
        usedWLANprofiles,
        usbOverloads,
        supplicantConfigMismatch;

    }

    public static enum PPUmoType {
        uid(Integer.class, DataClass.ClassReadOnly, 0, "uid"),
        ppn(Integer.class, DataClass.ClassReadOnly, 0, "related ppn"),
        name(String.class, DataClass.ClassReadOnly, 0, "name"),
        num(String.class, DataClass.ClassReadOnly, 0, "number"),
        monitoringMode(PPMonitoringModeType.class, DataClass.ClassReadOnly, 0, "monitoring mode"),
        HAS(MonitoringStateType.class, DataClass.ClassReadOnly, 0, "assignment state"),
        HSS(MonitoringStateType.class, DataClass.ClassReadOnly, 0, "subscription state"),
        HRS(MonitoringStateType.class, DataClass.ClassReadOnly, 0, "registration state"),
        HCS(MonitoringStateType.class, DataClass.ClassReadOnly, 0, "activity state "),
        SRS(MonitoringStateType.class, DataClass.ClassReadOnly, 0, "sip user reg state"),
        SCS(MonitoringStateType.class, DataClass.ClassReadOnly, 0, "silent charg state"),
        CDS(MonitoringStateType.class, DataClass.ClassReadOnly, 0, "call div state"),
        HBS(MonitoringStateType.class, DataClass.ClassReadOnly, 0, "battery state"),
        BTS(MonitoringStateType.class, DataClass.ClassReadOnly, 0, "bluetooth state"),
        SWS(MonitoringStateType.class, DataClass.ClassReadOnly, 0, "software state"),
        CUS(MonitoringStateType.class, DataClass.ClassReadOnly, 0, "combined user state");

        public Class<?> type;
        public DataClass cl;
        public int param;
        protected String text;

        private PPUmoType(Class<?> clazz, DataClass dataClass, int n2, String string2) {
            this.type = clazz;
            this.cl = dataClass;
            this.param = n2;
            this.text = string2;
        }

        protected String getText() {
            return this.text;
        }
    }

    public static enum PPUserType {
        uid(Integer.class, DataClass.ClassReadOnly, 0, "uid"),
        uidSec(Integer.class, DataClass.ClassReadOnly, 0, "uid sec."),
        timeStamp(String.class, DataClass.ClassReadOnly, 0, "time stamp"),
        timeStampAdmin(String.class, DataClass.ClassReadOnly, 0, "time stamp admin"),
        timeStampRelation(String.class, DataClass.ClassReadOnly, 0, "time stamp rel."),
        relType(PPRelTypeType.class, DataClass.ClassReadWrite, 0, "rel type (user)"),
        name(String.class, DataClass.ClassReadWrite, 0, "name"),
        ppn(Integer.class, DataClass.ClassReadOnly, 0, "related ppn"),
        ppnOld(Integer.class, DataClass.ClassReadOnly, 0, "related ppn old"),
        num(String.class, DataClass.ClassReadWrite, 0, "number"),
        addId(String.class, DataClass.ClassReadWrite, 0, "additional id"),
        sipAuthId(String.class, DataClass.ClassReadWrite, 0, "sip auth id"),
        sipPw(String.class, DataClass.ClassReadWrite, 0, "sip Password"),
        sipRegisterCheck(Boolean.class, DataClass.ClassReadWrite, 0, "sip reg check"),
        sosNum(String.class, DataClass.ClassReadWrite, 0, "sos number"),
        manDownNum(String.class, DataClass.ClassReadWrite, 0, "man down number"),
        voiceboxNum(String.class, DataClass.ClassReadWrite, 0, "voicebox number"),
        pin(String.class, DataClass.ClassReadWrite, 0, "pin"),
        forwardState(CallForwardStateType.class, DataClass.ClassReadWrite, 0, "forward state"),
        forwardTime(Integer.class, DataClass.ClassReadWrite, 0, "forward time"),
        forwardDest(String.class, DataClass.ClassReadWrite, 0, "forward dest"),
        lang(PPUserLanguageType.class, DataClass.ClassReadWrite, 0, "language"),
        holdRingBackTime(Integer.class, DataClass.ClassReadWrite, 0, "hold ring back time"),
        callWaitingDisabled(Boolean.class, DataClass.ClassReadWrite, 0, "call wait disabled"),
        external(Boolean.class, DataClass.ClassReadWrite, 0, "external"),
        hierarchy1(String.class, DataClass.ClassReadWrite, 0, "hierarchy1"),
        hierarchy2(String.class, DataClass.ClassReadWrite, 0, "hierarchy2"),
        trackingActive(Boolean.class, DataClass.ClassReadWrite, 0, "tracking active"),
        locatable(Boolean.class, DataClass.ClassReadWrite, 0, "locatable"),
        BTlocatable(Boolean.class, DataClass.ClassReadWrite, 0, "bluetooth loc"),
        locRight(Boolean.class, DataClass.ClassReadWrite, 0, "loc right"),
        msgRight(Boolean.class, DataClass.ClassReadWrite, 0, "msg right"),
        sendVcardRight(Boolean.class, DataClass.ClassReadWrite, 0, "send vcard right"),
        recvVcardRight(Boolean.class, DataClass.ClassReadWrite, 0, "recv vcard right"),
        allowVideoStream(Boolean.class, DataClass.ClassReadWrite, 0, "allow video stream"),
        keepLocalPB(Boolean.class, DataClass.ClassReadWrite, 0, "keep loc phonebook"),
        monitoringMode(PPMonitoringModeType.class, DataClass.ClassReadWrite, 0, "monitoring"),
        vip(Boolean.class, DataClass.ClassReadWrite, 0, "vip"),
        conferenceServerType(ConferenceServerPPUserTypeType.class, DataClass.ClassReadWrite, 0, "conf srv type"),
        conferenceServerURI(String.class, DataClass.ClassReadWrite, 0, "conf srv uri"),
        BTsensitivity(BTSensitivityType.class, DataClass.ClassReadWrite, 0, "bluetooth sens"),
        credentialPw(String.class, DataClass.ClassReadOnly, 0, "cred pw"),
        configurationDataLoaded(Boolean.class, DataClass.ClassReadOnly, 0, "conf data loaded"),
        ppData(String.class, DataClass.ClassReadWrite, 0, "conf data"),
        ppProfileId(Integer.class, DataClass.ClassReadWrite, 0, "profile id"),
        fixedSipPort(Integer.class, DataClass.ClassReadWrite, 0, "fixed sip port"),
        calculatedSipPort(Integer.class, DataClass.ClassReadOnly, 0, "calc. sip port"),
        autoAnswer(GlobalOnOffType.class, DataClass.ClassReadWrite, 0, "auto answer"),
        microphoneMute(GlobalOnOffType.class, DataClass.ClassReadWrite, 0, "microph. mute"),
        warningTone(GlobalOnOffType.class, DataClass.ClassReadWrite, 0, "warning tone"),
        allowBargeIn(GlobalOnOffType.class, DataClass.ClassReadWrite, 0, "allow barge in"),
        autoLogoutOnCharge(Boolean.class, DataClass.ClassReadWrite, 0, "logout on charge"),
        hotDeskingSupport(Boolean.class, DataClass.ClassReadWrite, 0, "hot desking supp."),
        authenticateLogout(Boolean.class, DataClass.ClassReadWrite, 0, "auth. logout"),
        permanent(Boolean.class, DataClass.ClassReadWrite, 0, "permanent"),
        useSIPUserName(GlobalOnOffType.class, DataClass.ClassReadWrite, 0, "use sip user name"),
        useSIPUserAuthentication(GlobalOnOffType.class, DataClass.ClassReadWrite, 0, "use sip user auth."),
        serviceUserName(String.class, DataClass.ClassReadWrite, 0, "serv. user name"),
        serviceAuthName(String.class, DataClass.ClassReadWrite, 0, "serv. auth. name"),
        serviceAuthPassword(String.class, DataClass.ClassReadWrite, 0, "serv. password"),
        keyLockEnable(Boolean.class, DataClass.ClassReadWrite, 0, "key lock enable"),
        keyLockPin(String.class, DataClass.ClassReadWrite, 0, "key lock pin"),
        keyLockTime(Integer.class, DataClass.ClassReadWrite, 0, "key lock time"),
        HAS(MonitoringStateType.class, DataClass.ClassReadOnly, 0, "hs assignment"),
        HSS(MonitoringStateType.class, DataClass.ClassReadOnly, 0, "hs subscription"),
        HRS(MonitoringStateType.class, DataClass.ClassReadOnly, 0, "hs registration"),
        HCS(MonitoringStateType.class, DataClass.ClassReadOnly, 0, "hs activity"),
        SRS(MonitoringStateType.class, DataClass.ClassReadOnly, 0, "hs sip user reg"),
        SCS(MonitoringStateType.class, DataClass.ClassReadOnly, 0, "hs silent charg"),
        CDS(MonitoringStateType.class, DataClass.ClassReadOnly, 0, "hs call divertion"),
        HBS(MonitoringStateType.class, DataClass.ClassReadOnly, 0, "hs battery"),
        BTS(MonitoringStateType.class, DataClass.ClassReadOnly, 0, "hs bluetooth"),
        SWS(MonitoringStateType.class, DataClass.ClassReadOnly, 0, "hs software state"),
        CUS(MonitoringStateType.class, DataClass.ClassReadOnly, 0, "hs combined");

        public Class<?> type;
        public DataClass cl;
        public int param;
        protected String text;

        private PPUserType(Class<?> clazz, DataClass dataClass, int n2, String string2) {
            this.type = clazz;
            this.cl = dataClass;
            this.param = n2;
            this.text = string2;
        }

        protected String getText() {
            return this.text;
        }

        protected boolean isClassReadOnly() {
            return this.cl == DataClass.ClassReadOnly;
        }
    }

    public static enum ActivePpType {
        ppn,
        trType,
        rfpId;

    }

    public static enum LastPPActionType {
        ppn,
        trType,
        rfpId,
        relTime;

    }

    public static enum BTPpSensTypeType {
        low,
        medium,
        high;

    }

    public static enum BTRfpSensTypeType {
        checkpoint,
        low,
        medium,
        high;

    }

    public static enum GenericNoneInactiveActiveType {
        none,
        inactive,
        active;

    }

    public static enum PPFirmwareUpdateStatusCauseType {
        none,
        busy,
        battery,
        barred,
        noMaster,
        crc,
        noMem,
        flash,
        system,
        version,
        file,
        container;

    }

    public static enum PPFirmwareUpdateStatusStateType {
        ready,
        pending,
        active,
        barred,
        error,
        notReachable,
        detached,
        unknown;

    }

    public static enum PPFirmwareUpdateStatusType {
        ppn,
        state,
        cause,
        bytes,
        version;

    }

    public static enum PPFirmwareUpdateOverviewType {
        state,
        status,
        known,
        ready,
        pending,
        active,
        barred,
        errored,
        notReachable,
        detached,
        version;

    }

    public static enum PPFirmwareUpdateOverviewStateType {
        startup,
        disabled,
        running,
        error;

    }

    public static enum UserMonitoringType {
        startupDelay,
        escalationDelay,
        activityTimeout1,
        activityTimeout2,
        batteryThresholdValue,
        locatingEscalation;

    }

    public static enum RegServerTypeType {
        None(null),
        Primary(null),
        Secondary(null),
        Tertiary(null);

        private String guiValue;

        private RegServerTypeType(String string2) {
            this.guiValue = string2;
        }

        public String toString() {
            if (this.guiValue == null) {
                return this.name();
            }
            return this.guiValue;
        }

        public void setGuiValue(String string) {
            if (string != null) {
                this.guiValue = string;
            }
        }

        public static RegServerTypeType guiValueToEnum(String string) {
            EnumSet<RegServerTypeType> enumSet = EnumSet.allOf(RegServerTypeType.class);
            for (RegServerTypeType regServerTypeType : enumSet) {
                if (!string.equals(regServerTypeType.guiValue)) continue;
                return regServerTypeType;
            }
            return null;
        }
    }

    public static enum VideoDevSummaryType {
        nRecords,
        idFirst,
        enabledNum,
        stateUnpluggedNum,
        stateInactiveNum,
        stateActiveNum,
        stateFailedNum;

    }

    public static enum BluetoothSummaryType {
        nRecords,
        idFirst,
        checkpointNum,
        stateUnpluggedNum,
        statePluggedNum,
        stateFailedNum;

    }

    public static enum PPUserCallStateType {
        ringing,
        calling,
        paging,
        connected,
        idle,
        none;

    }

    public static enum PPUserSipEventType {
        sipRegistrationEvent,
        sipRegistrationEndEvent,
        sipNotifyEvent;

    }

    public static enum SiteSummaryType {
        nRecords,
        idFirst,
        rfpSiteNum,
        g722SiteNum,
        dectSecuritySiteNum,
        videoStreamingSiteNum,
        srtpSiteNum;

    }

    public static enum PPDevSummaryType {
        nRecords,
        ppnFirst,
        subscribedDevs;

    }

    public static enum PPUserSummaryType {
        nRecords,
        uidFirst,
        nSipRegistration,
        nLocatable,
        nBtLocatable,
        nMsgSend,
        usersActiveMonitored,
        usersPassiveMonitored,
        usersWarned,
        usersUnavailable,
        usersEscalated;

    }

    public static enum PPDevRoamingStateType {
        RoamingIdle(null),
        RoamingInit(null),
        RoamingAck(null),
        RoamingComplete(null);

        private String guiValue;

        private PPDevRoamingStateType(String string2) {
            this.guiValue = string2;
        }

        public String toString() {
            if (this.guiValue == null) {
                return this.name();
            }
            return this.guiValue;
        }

        public void setGuiValue(String string) {
            if (string != null) {
                this.guiValue = string;
            }
        }

        public static PPDevRoamingStateType guiValueToEnum(String string) {
            EnumSet<PPDevRoamingStateType> enumSet = EnumSet.allOf(PPDevRoamingStateType.class);
            for (PPDevRoamingStateType pPDevRoamingStateType : enumSet) {
                if (!string.equals(pPDevRoamingStateType.guiValue)) continue;
                return pPDevRoamingStateType;
            }
            return null;
        }
    }

    public static enum DECTSubscriptionModeType {
        Wildcard,
        Configured,
        Off;

    }

    public static enum DECTSubscriptionStateType {
        No,
        Unconfirmed,
        Yes;

    }

    public static enum PPRelTypeType {
        Unbound(null),
        Dynamic(null),
        Fixed(null);

        public String guiValue;

        private PPRelTypeType(String string2) {
            this.guiValue = string2;
        }

        public String toString() {
            if (this.guiValue == null) {
                return this.name();
            }
            return this.guiValue;
        }

        public void setGuiValue(String string) {
            if (string != null) {
                this.guiValue = string;
            }
        }
    }

    public static enum PPDevHwTypeType {
        _142d("142d", "142d"),
        _610d("610d", "610d"),
        _620d("620d", "620d"),
        _630d("630d", "630d"),
        _612d("612d", "612d"),
        _622d("622d", "622d"),
        _632d("632d", "632d"),
        _650c("650c", "650c"),
        _612v2("612v2", "612 v2"),
        _622v2("622v2", "622 v2"),
        _632v2("632v2", "632 v2"),
        GAP("GAP", "GAP"),
        Unknown("Unknown", "unknown");

        public String axiVal;
        public String guiVal;

        private PPDevHwTypeType(String string2, String string3) {
            this.axiVal = string2;
            this.guiVal = string3;
        }

        public String toString() {
            return this.guiVal;
        }

        public static PPDevHwTypeType getValFromAxiString(String string) {
            EnumSet<PPDevHwTypeType> enumSet = EnumSet.allOf(PPDevHwTypeType.class);
            for (PPDevHwTypeType pPDevHwTypeType : enumSet) {
                if (!string.equals(pPDevHwTypeType.axiVal)) continue;
                return pPDevHwTypeType;
            }
            return Unknown;
        }
    }

    public static enum PPMonitoringModeType {
        Off(null),
        Passive(null),
        Active(null);

        private String guiValue;

        private PPMonitoringModeType(String string2) {
            this.guiValue = string2;
        }

        public String toString() {
            if (this.guiValue == null) {
                return this.name();
            }
            return this.guiValue;
        }

        public void setGuiValue(String string) {
            if (string != null) {
                this.guiValue = string;
            }
        }

        public static PPMonitoringModeType guiValueToEnum(String string) {
            EnumSet<PPMonitoringModeType> enumSet = EnumSet.allOf(PPMonitoringModeType.class);
            for (PPMonitoringModeType pPMonitoringModeType : enumSet) {
                if (!string.equals(pPMonitoringModeType.guiValue)) continue;
                return pPMonitoringModeType;
            }
            return null;
        }
    }

    public static enum PPDevType {
        ppn(Integer.class, DataClass.ClassReadOnly, 0, "pp number"),
        ppnSec(Integer.class, DataClass.ClassReadOnly, 0, "pp number sec."),
        timeStamp(String.class, DataClass.ClassReadOnly, 0, "time stamp"),
        timeStampAdmin(String.class, DataClass.ClassReadOnly, 0, "time stamp admin"),
        timeStampRelation(String.class, DataClass.ClassReadOnly, 0, "time stamp rel."),
        timeStampRoaming(String.class, DataClass.ClassReadOnly, 0, "time stamp roaming"),
        timeStampSubscription(String.class, DataClass.ClassReadOnly, 0, "time stamp subscr."),
        relType(PPRelTypeType.class, DataClass.ClassReadWrite, 0, "rel type (dev)"),
        uid(Integer.class, DataClass.ClassReadOnly, 0, "related uid"),
        ipei(String.class, DataClass.ClassReadWrite, 0, "ipei"),
        ac(String.class, DataClass.ClassReadWrite, 8, "ac"),
        s(DECTSubscriptionStateType.class, DataClass.ClassResetOnly, 0, "subscribed"),
        uak(String.class, DataClass.ClassReadOnly, 32, "uak"),
        encrypt(Boolean.class, DataClass.ClassReadWrite, 0, "encryption"),
        capMessaging(Boolean.class, DataClass.ClassReadOnly, 0, "cap messaging"),
        capMessagingForInternalUse(Boolean.class, DataClass.ClassReadOnly, 0, "cap mes int use"),
        capEnhLocating(Boolean.class, DataClass.ClassReadOnly, 0, "cap enh locating"),
        capBluetooth(Boolean.class, DataClass.ClassReadOnly, 0, "cap bluetooth"),
        hwType(PPDevHwTypeType.class, DataClass.ClassReadOnly, 0, "hw type"),
        ethAddr(String.class, DataClass.ClassReadOnly, 0, "bt eth addr"),
        ppProfileCapability(Boolean.class, DataClass.ClassReadOnly, 0, "profile cap"),
        ppDefaultProfileLoaded(Boolean.class, DataClass.ClassReadOnly, 0, "def prof loaded"),
        subscribeToPARIOnly(Boolean.class, DataClass.ClassReadWrite, 0, "subscr. pari only"),
        ommId(String.class, DataClass.ClassReadOnly, 0, "omm id"),
        ommIdAck(String.class, DataClass.ClassReadOnly, 0, "omm id ack"),
        roaming(PPDevRoamingStateType.class, DataClass.ClassReadOnly, 0, "roaming state"),
        autoCreate(Boolean.class, DataClass.ClassReadOnly, 0, "auto create"),
        modicType(String.class, DataClass.ClassReadOnly, 0, "modic type"),
        locationData(String.class, DataClass.ClassReadOnly, 0, "location data"),
        dectIeFixedId(String.class, DataClass.ClassReadOnly, 0, "dect ie fixed id"),
        subscriptionId(String.class, DataClass.ClassReadOnly, 0, "subscription id"),
        fwUpdState(PPFirmwareUpdateStatusStateType.class, DataClass.ClassReadOnly, 0, "fw upd state"),
        fwUpdCause(PPFirmwareUpdateStatusCauseType.class, DataClass.ClassReadOnly, 0, "fw upd cause"),
        fwUpdBytes(Integer.class, DataClass.ClassReadOnly, 0, "fw upd bytes"),
        fwVersion(String.class, DataClass.ClassReadOnly, 0, "fw version"),
        sipEvent(PPUserSipEventType.class, DataClass.ClassReadOnly, 0, "st sip event"),
        onHook(Boolean.class, DataClass.ClassReadOnly, 0, "st on hook"),
        silentCharging(Boolean.class, DataClass.ClassReadOnly, 0, "st silent charging"),
        callState(PPUserCallStateType.class, DataClass.ClassReadOnly, 0, "st call state"),
        registered(Boolean.class, DataClass.ClassReadOnly, 0, "st registered"),
        batteryLevel(Integer.class, DataClass.ClassReadOnly, 0, "st battery level"),
        bluetooth(Boolean.class, DataClass.ClassReadOnly, 0, "st bluetooth"),
        swVersion(String.class, DataClass.ClassReadOnly, 0, "st sw version"),
        regServerType(RegServerTypeType.class, DataClass.ClassReadOnly, 0, "st reg srv type"),
        regServerAddr(String.class, DataClass.ClassReadOnly, 0, "st reg srv addr"),
        regServerPort(Integer.class, DataClass.ClassReadOnly, 0, "st reg srv port");

        public Class<?> type;
        public DataClass cl;
        public int param;
        public String text;

        private PPDevType(Class<?> clazz, DataClass dataClass, int n2, String string2) {
            this.type = clazz;
            this.cl = dataClass;
            this.param = n2;
            this.text = string2;
        }

        protected String getText() {
            return this.text;
        }

        protected boolean isClassReadOnly() {
            return this.cl == DataClass.ClassReadOnly;
        }
    }

    public static enum SslMethodType {
        TLS_1_0("TLS 1.0", "TLS1.0"),
        TLS_1_1("TLS 1.1", "TLS1.1"),
        TLS_1_2("TLS 1.2", "TLS1.2"),
        AUTO("Auto", "Auto");

        public String guiValue;
        public String protocolValue;

        private SslMethodType(String string2, String string3) {
            this.guiValue = string2;
            this.protocolValue = string3;
        }

        public String toString() {
            return this.guiValue;
        }

        public static SslMethodType guiValueToEnum(String string) {
            EnumSet<SslMethodType> enumSet = EnumSet.allOf(SslMethodType.class);
            for (SslMethodType sslMethodType : enumSet) {
                if (!string.equals(sslMethodType.guiValue)) continue;
                return sslMethodType;
            }
            return null;
        }

        public static SslMethodType protocolValueToEnum(String string) {
            EnumSet<SslMethodType> enumSet = EnumSet.allOf(SslMethodType.class);
            for (SslMethodType sslMethodType : enumSet) {
                if (!string.equals(sslMethodType.protocolValue)) continue;
                return sslMethodType;
            }
            return null;
        }
    }

    public static enum ProtType {
        None(false, false, false),
        FTP(false, false, true),
        TFTP(false, false, false),
        FTPS(false, true, true),
        HTTP(false, false, true),
        HTTPS(false, true, true),
        SFTP(false, true, true),
        SCP(false, true, true),
        FILE(false, false, false);

        private Boolean valid;
        public Boolean SSLSelectionPossible;
        public Boolean userAndPasswordPossible;

        private ProtType(Boolean bl, boolean bl2, boolean bl3) {
            this.valid = bl;
            this.SSLSelectionPossible = bl2;
            this.userAndPasswordPossible = bl3;
        }

        public void setValid(Boolean bl) {
            this.valid = bl;
        }

        public Boolean isValid() {
            return this.valid;
        }

        public static int getValidProtTypeNumber() {
            int n = 0;
            EnumSet<ProtType> enumSet = EnumSet.allOf(ProtType.class);
            for (ProtType protType : enumSet) {
                if (!protType.valid.booleanValue()) continue;
                ++n;
            }
            return n;
        }

        public static ProtType[] getValidProtTypes() {
            ProtType[] protTypeArray = new ProtType[ProtType.getValidProtTypeNumber()];
            int n = 0;
            EnumSet<ProtType> enumSet = EnumSet.allOf(ProtType.class);
            for (ProtType protType : enumSet) {
                if (!protType.valid.booleanValue()) continue;
                protTypeArray[n] = protType;
                ++n;
            }
            return protTypeArray;
        }
    }

    public static enum URLType {
        enable,
        protocol,
        host,
        path,
        username,
        password,
        port,
        sslMethod,
        useCommonCerts,
        privateKeyPassword,
        validateCerts,
        validateExpires,
        validateHostName,
        importCerts,
        allowNonConfTrustCerts,
        nTrustedCertificates,
        nLocalCertificates,
        nPrivateKeys,
        trustedCertificates,
        localCertificates,
        privateKeys;

    }

    public static enum DbTransferStateType {
        idle,
        running,
        finished,
        identical,
        internal_error,
        invalid_file,
        invalid_param,
        unknown;

    }

    public static enum DbTransferStateSelectType {
        manualBackup,
        manualRestore,
        automaticBackup;

    }

    public static enum PEMCertificateListType {
        trustedCertificates("Trusted certificate(s)"),
        localCertificates("Local certificate(s)"),
        privateKey("Private key");

        private String translatedString;

        private PEMCertificateListType(String string2) {
            this.translatedString = string2;
        }

        public void setTranslatedString(String string) {
            this.translatedString = string;
        }

        public String getTranslatedString() {
            return this.translatedString;
        }

        public static PEMCertificateListType getValFromTxt(String string) {
            EnumSet<PEMCertificateListType> enumSet = EnumSet.allOf(PEMCertificateListType.class);
            for (PEMCertificateListType pEMCertificateListType : enumSet) {
                if (!string.equals(pEMCertificateListType.translatedString)) continue;
                return pEMCertificateListType;
            }
            return null;
        }
    }

    public static enum SIPSecureTransportProtocolType {
        UDP("UDP"),
        TCP("TCP"),
        UDPandTCP("UDP/TCP"),
        TLS("TLS"),
        PersistentTLS("Persistent TLS");

        public String guiValue;

        private SIPSecureTransportProtocolType(String string2) {
            this.guiValue = string2;
        }

        public String toString() {
            return this.guiValue;
        }

        public static SIPSecureTransportProtocolType guiValueToEnum(String string) {
            EnumSet<SIPSecureTransportProtocolType> enumSet = EnumSet.allOf(SIPSecureTransportProtocolType.class);
            for (SIPSecureTransportProtocolType sIPSecureTransportProtocolType : enumSet) {
                if (!string.equals(sIPSecureTransportProtocolType.guiValue)) continue;
                return sIPSecureTransportProtocolType;
            }
            return null;
        }
    }

    public static enum SemiAttendedTransferModeType {
        Blind,
        Attended;

    }

    public static enum CallerDeterminationType {
        PAssertIdentity("P-Assert-Identity"),
        fromTo("From/To");

        public String str;

        private CallerDeterminationType(String string2) {
            this.str = string2;
        }

        public static String getStringFromEnum(CallerDeterminationType callerDeterminationType) {
            return callerDeterminationType.str;
        }

        public static CallerDeterminationType getEnumFromString(String string) {
            EnumSet<CallerDeterminationType> enumSet = EnumSet.allOf(CallerDeterminationType.class);
            for (CallerDeterminationType callerDeterminationType : enumSet) {
                if (!string.equals(callerDeterminationType.str)) continue;
                return callerDeterminationType;
            }
            return PAssertIdentity;
        }
    }

    public static enum CertificateType {
        nTrustedCertificates,
        nLocalCertificates,
        nPrivateKeys,
        trustedCertificates,
        localCertificates,
        privateKeys,
        privateKeyPassword,
        identity;

    }

    public static enum SecureSIPType {
        keepAliveTimeoutEnable,
        timeout,
        sendSipsOverTLS,
        authenticationTLS,
        commonNameValidationTLS;

    }

    public static enum BackupSIPType {
        failoverActive,
        failoverTime,
        secondaryProxyServer,
        secondaryProxyPort,
        secondaryRegServer,
        secondaryRegPort,
        secondaryOutboundProxyServer,
        secondaryOutboundProxyPort,
        tertiaryProxyServer,
        tertiaryProxyPort,
        tertiaryRegServer,
        tertiaryRegPort,
        tertiaryOutboundProxyServer,
        tertiaryOutboundProxyPort;

    }

    public static enum SIPContactMatchingType {
        Uri,
        IpOnly,
        UsernameOnly,
        IpAndUsername;

        private String guiName = this.name();

        public void setGuiString(String string) {
            this.guiName = string;
        }

        public String toString() {
            return this.guiName;
        }
    }

    public static enum AdvancedSIPType {
        mwiSubscription,
        userAgentInfo,
        userAgentCompatibility,
        xAastraId,
        dialTerminator,
        regTimeoutRetryTimer,
        regFailedRetryTimer,
        transactionTimer,
        blacklistTimeout,
        callerDetermination,
        multipleRing,
        semiAttendedTransferMode,
        referToWithReplaces,
        callRejectStateCodeUsr,
        callRejectStateCodeDev,
        sessionTimer,
        incomingCallTimeout,
        contactMatching,
        removeRoute,
        mwiSubscriptionPeriod;

    }

    public static enum BasicSIPType {
        transportProt,
        proxyServer,
        proxyPort,
        outboundProxyServer,
        outboundProxyPort,
        regServer,
        regPort,
        regPeriod,
        sipRegisterCheckNum,
        gruu;

    }

    public static enum DTMFMethodType {
        RFC2833,
        INFO,
        Both;

    }

    public static enum RTPPacketTimeEnum {
        _10ms("10"),
        _20ms("20"),
        _30ms("30");

        private String strVal;

        private RTPPacketTimeEnum(String string2) {
            this.strVal = string2;
        }

        public String getStrVal() {
            return this.strVal;
        }
    }

    public static enum CodecType {
        None("None"),
        G_722("G.722"),
        G_711_ULAW("G.711-u-law"),
        G_711_ALAW("G.711-A-law"),
        G_729_A("G.729-A");

        public String val;
        public String guival = null;

        private CodecType(String string2) {
            this.val = string2;
        }

        public static CodecType getCodecFromOMIMsg(String string) {
            EnumSet<CodecType> enumSet = EnumSet.allOf(CodecType.class);
            for (CodecType codecType : enumSet) {
                if (!string.equals(codecType.val)) continue;
                return codecType;
            }
            return None;
        }

        public void setGuiText(String string) {
            this.guival = string;
        }

        public String toString() {
            if (this.guival != null) {
                return this.guival;
            }
            return this.val;
        }
    }

    public static enum WlanRegDomainInvalidType {
        None("00", "None"),
        US_FCC("10", "USA FCC"),
        Canada_IC("20", "Canada IC"),
        Europe_ETSI("30", "Europe ETSI"),
        Spain("31", "Spain"),
        France("32", "France"),
        Japan_MKK("40", "Japan MKK"),
        Japan_MKK1("41", "Japan MKK1");

        public String axi;
        private String strTranslated;

        private WlanRegDomainInvalidType(String string2, String string3) {
            this.axi = string2;
            this.strTranslated = string3;
        }

        public static WlanRegDomainInvalidType getInvalidDomainFromAxi(String string) {
            EnumSet<WlanRegDomainInvalidType> enumSet = EnumSet.allOf(WlanRegDomainInvalidType.class);
            for (WlanRegDomainInvalidType wlanRegDomainInvalidType : enumSet) {
                if (!string.equals(wlanRegDomainInvalidType.axi)) continue;
                return wlanRegDomainInvalidType;
            }
            return null;
        }

        public static boolean isInvalidDomain(String string) {
            EnumSet<WlanRegDomainInvalidType> enumSet = EnumSet.allOf(WlanRegDomainInvalidType.class);
            for (WlanRegDomainInvalidType wlanRegDomainInvalidType : enumSet) {
                if (!string.equals(wlanRegDomainInvalidType.name())) continue;
                return true;
            }
            return false;
        }

        public void setStrTranslated(String string) {
            this.strTranslated = string;
        }

        public String getStrTranslated() {
            return this.strTranslated;
        }
    }

    public static enum DECTRegDomainType {
        None("None"),
        EMEA("EMEA"),
        US("US (FCC/IC)"),
        Brazil("Brazil (Anatel)"),
        Taiwan("Taiwan"),
        Radio1910_1927MHz250mW("Radio 1910-1927MHz 250mW");

        public String val;

        private DECTRegDomainType(String string2) {
            this.val = string2;
        }

        public void setStrTranslated(String string) {
            this.val = string;
        }

        public String getStrTranslated() {
            return this.val;
        }

        public static DECTRegDomainType getValFromStrTranslated(String string) {
            EnumSet<DECTRegDomainType> enumSet = EnumSet.allOf(DECTRegDomainType.class);
            for (DECTRegDomainType dECTRegDomainType : enumSet) {
                if (!string.equals(dECTRegDomainType.val)) continue;
                return dECTRegDomainType;
            }
            return null;
        }
    }

    public static enum PPLoginVariantType {
        NUMBER("number"),
        ID("id");

        public String txt;

        private PPLoginVariantType(String string2) {
            this.txt = string2;
        }

        public void setTxt(String string) {
            this.txt = string;
        }

        public static PPLoginVariantType getValFromTxt(String string) {
            EnumSet<PPLoginVariantType> enumSet = EnumSet.allOf(PPLoginVariantType.class);
            for (PPLoginVariantType pPLoginVariantType : enumSet) {
                if (!string.equals(pPLoginVariantType.txt)) continue;
                return pPLoginVariantType;
            }
            return NUMBER;
        }
    }

    public static enum NetParamType {
        voiceToS,
        sigToS,
        ttl,
        voiceEthPrio,
        sigEthPrio;

    }

    public static enum CmdType {
        On,
        Off;

    }

    public static enum EventType {
        SystemCnf,
        SystemState,
        AutoDBCnf,
        DECTSubscriptionMode,
        EventLog,
        PPDevCnf,
        PPUserCnf,
        PPState,
        PPBtState,
        PPCallState,
        PPCallStateRinging,
        PPCallStateCalling,
        PPCallStatePaging,
        PPCallStateConnected,
        PPCallStateIdle,
        PPCallStateNone,
        PPDevState,
        PPDevStateOnHook,
        PPDevStateSilentCharging,
        PPDevStateBatteryLevel,
        PPDevStateSwVersion,
        PPSipState,
        PPSipStateRegEvent,
        PPSipStateEndEvent,
        PPSipStateNotifyEvent,
        PPSipStateRegistered,
        PPSipStateServerType,
        PPSipStateServerAddr,
        PPSipStateServerPort,
        PPTransaction,
        PPTransactionLinkEstablish,
        PPTransactionRelease,
        PPTransactionEstablish,
        PPTransactionPPNotFound,
        PPTransactionPagingStarted,
        PPTransactionReleaseFromPP,
        PPTransactionPPSetupRejected,
        PPTransactionComsRelease,
        PPTransactionComsEstablish,
        PPTransactionSsFac,
        PPTransactionSsRelease,
        PPTransactionSsEstablish,
        PPTransactionConnHandover,
        PPTransactionLocReg,
        PPTransactionDetach,
        RFPCnf,
        RFPState,
        RFPDetails,
        RFPConnectAttempt,
        SiteCnf,
        MessageQueueEmpty,
        MessageProgress,
        MessageConfirmation,
        MessageSend,
        AlarmTriggerCnf,
        AlarmTrigger,
        AlarmCallProgress,
        Locating,
        LocatingBluetooth,
        PositionTrack,
        DigitTreatmentCnf,
        WLANProfileCnf,
        ACLCnf,
        WLANClient,
        RFPSync,
        FACCnf,
        AccountCnf,
        PPFirmwareUpdateCnf,
        PPFirmwareUpdateOverview,
        PPFirmwareUpdateState,
        PPFirmwareState,
        BluetoothCnf,
        BluetoothBeaconSumCnf,
        BluetoothBeaconSumState,
        ConferenceCnf,
        Conference,
        VideoDev,
        VideoDevSumCnf,
        VideoDevSumState,
        AccountSummary,
        PPDevSummary,
        PPUserSummary,
        RFPSummary,
        SiteSummary,
        RFPMsQuality,
        RFPIpQuality,
        RFPSyncQuality,
        ParkServerResult,
        PPHCM,
        Roaming,
        MOMOMMCnf,
        ApplicationDataChannel;

    }

    public static enum EventFilterItems {
        ppn,
        uid,
        rfpId,
        omm,
        trigger,
        scheme;

    }

    public static enum ppTransEvent {
        None,
        LinkEstablish,
        ConnHandover,
        Establish,
        Release,
        PagingStarted,
        ReleaseFromPP,
        PPSetupRejected,
        PPNotFound,
        LocReg,
        Detach,
        CcEstablish,
        CcRelease,
        CcPagingStarted,
        CcReleaseFromPP,
        CcSetupRejected,
        CcPPNotFound,
        SsEstablish,
        SsRelease,
        SsFac,
        ComsEstablish,
        ComsRelease,
        Cc,
        Ss,
        Coms;

    }

    public static enum LimitsType {
        axiClients,
        codec,
        ldapServer,
        licLatency,
        ppnNum,
        records,
        rfpNum,
        site,
        ssidWlan,
        ssidWlanKey,
        ppProfileNum,
        certificatNum,
        trigger,
        urlLen,
        userId,
        dnsServer,
        ntpServer,
        wlanClients,
        wlanMacFilter,
        xmlBuiltInAppl,
        bluetoothBeacons,
        bluetoothNeighbours,
        bluetoothRssiValues,
        conferenceRooms,
        xmlDynAppl,
        xmlCorpDirAppl,
        limitRTT1,
        limitRTT2,
        limitRTT3,
        limitRTT4,
        omm;

    }

    public static enum OpenRespAttribType {
        protocolVersion(Integer.class, 0),
        ommVersion(String.class, null),
        ommAxiSpecVersion(String.class, null),
        axiClients(Integer.class, 0),
        permission(PermissionType.class, null),
        ommStbState(OmmStbStateType.class, (Object)((Object)OmmStbStateType.Unknown)),
        ommStbAddr(String.class, "-"),
        ommStream(String.class, null),
        ommPlatform(String.class, null),
        uptime(Integer.class, 0),
        EULAConfirm(Boolean.class, false),
        accountState(AccountState.class, null),
        publicKey(CommonDataHandler.PublicKeyClass.class, null),
        minPPSwVersion1(String.class, null),
        minPPSwVersion2(String.class, null),
        GDPREnabled(Boolean.class, false),
        GDPRComplianceText(String.class, null),
        haveAutoDB(Boolean.class, false),
        haveLDAP(Boolean.class, false),
        haveXMLCorpDir(Boolean.class, false),
        haveDECTRegDomain(Boolean.class, false),
        haveDigitTreatment(Boolean.class, false),
        haveDigitTreatmentSimple(Boolean.class, false),
        haveExternalUserData(Boolean.class, false),
        haveFACs(Boolean.class, false),
        haveEnrolmentPBX(Boolean.class, false),
        haveEnrolmentRFP(Boolean.class, false),
        haveEnrolmentPP(Boolean.class, false),
        haveIMA(Boolean.class, false),
        haveLicensing(Boolean.class, false),
        haveLicensingCodec(Boolean.class, false),
        havePagingAreas(Boolean.class, false),
        haveRTPPortBaseCnf(Boolean.class, false),
        haveSIP(Boolean.class, false),
        haveSIPStimulus(Boolean.class, false),
        haveSNMP(Boolean.class, false),
        haveSOSNumberPP(Boolean.class, false),
        haveTZones(Boolean.class, false),
        haveUnboundDevices(Boolean.class, false),
        haveVLAN(Boolean.class, false),
        haveWLAN(Boolean.class, false),
        haveLocating(Boolean.class, false),
        haveHCM(Boolean.class, false),
        havePPFirmwareUpdate(Boolean.class, false),
        haveIPParamCnf(Boolean.class, false),
        haveXML(Boolean.class, false),
        haveXMLDynamic(Boolean.class, false),
        haveVoiceboxNumber(Boolean.class, false),
        haveUMO(Boolean.class, false),
        haveBluetooth(Boolean.class, false),
        haveConference(Boolean.class, false),
        havePBXAddressCnf(Boolean.class, false),
        haveRFPMCnf(Boolean.class, false),
        haveProtFTP(Boolean.class, false),
        haveProtFTPS(Boolean.class, false),
        haveProtHTTP(Boolean.class, false),
        haveProtHTTPS(Boolean.class, false),
        haveProtSCP(Boolean.class, false),
        haveProtSFTP(Boolean.class, false),
        haveProtTFTP(Boolean.class, false),
        haveVideo(Boolean.class, false),
        haveSemiAttendedTransfer(Boolean.class, false),
        haveSRTP(Boolean.class, false),
        haveOMP(Boolean.class, false),
        haveDECTPpSettings(Boolean.class, false),
        haveSpecialBranding(Boolean.class, false),
        haveNTP(Boolean.class, false),
        haveOmmLogForward(Boolean.class, false),
        havePARKFile(Boolean.class, false),
        haveRFPOMM(Boolean.class, false),
        haveSoftwareImageURL(Boolean.class, false),
        haveSARI(Boolean.class, false),
        haveUserDeviceSync(Boolean.class, false),
        haveMOM(Boolean.class, false),
        haveMOMAppl(Boolean.class, false);

        public Class<?> type;
        public Object defValue;

        private OpenRespAttribType(Class<?> clazz, Object object) {
            this.type = clazz;
            this.defValue = object;
        }
    }

    public static enum OmmStbStateType {
        Unknown,
        None,
        OK,
        NotSynchronized,
        DifferentOMMTypes,
        DifferentOMMVersions;

    }

    public static class AccountState {
        public int id;
        public String username = null;
        public AccountPasswordStateType passwordState;
    }

    public static enum AccountPasswordStateType {
        dontCare,
        changed,
        notChanged,
        expired;

    }

    public static enum PermissionType {
        AllCnfRead("Read"),
        AllCnfWrite("Write"),
        InfoMessaging("Info messaging"),
        Messaging("Messaging"),
        Alerting("Emergency messaging"),
        LocatingAlert("Locating alert messaging"),
        Locating("Locating"),
        Monitoring("Monitoring"),
        Video("Video");

        private String translatedString;

        private PermissionType(String string2) {
            this.translatedString = string2;
        }

        public void setTranslatedString(String string) {
            this.translatedString = string;
        }

        public String getTranslatedString() {
            return this.translatedString;
        }

        public static PermissionType getValFromTxt(String string) {
            EnumSet<PermissionType> enumSet = EnumSet.allOf(PermissionType.class);
            for (PermissionType permissionType : enumSet) {
                if (!string.equals(permissionType.translatedString)) continue;
                return permissionType;
            }
            return null;
        }
    }

    public static enum DataClass {
        ClassReadWrite,
        ClassReadOnly,
        ClassResetOnly;

    }

    public static enum attribIds {
        ommVersion,
        protocolVersion,
        username,
        password,
        permission,
        EULAConfirm,
        ommStbState,
        ommStbAddr,
        seq,
        nPPs,
        nRFPs,
        nRecords,
        ppnFirst,
        idFirst,
        mode,
        timeout,
        fromPPN,
        fromId,
        maxRecords,
        cmd,
        eventType,
        errCode,
        id,
        rfpId,
        ppn,
        uid,
        omm,
        trigger,
        trType,
        info,
        bad,
        maxLen,
        active,
        enable,
        sendTime,
        confTime,
        toAddr,
        fromAddr,
        event,
        content,
        name,
        park,
        ac,
        regDomain,
        portBase,
        packetTime,
        silenceSupp,
        receiverPrecedence,
        comfortNoisePktElim,
        type,
        outOfBand,
        payloadType,
        method,
        select,
        state,
        error,
        lastupd,
        withState,
        withDetails,
        rstTime,
        elemId,
        recordSet,
        periodic,
        numOfRecords,
        age,
        sum,
        counter,
        duration,
        currMeasuredTime,
        oldMeasuredTime,
        min,
        max,
        occurrence,
        freqDistUnits,
        freqDistValues,
        deleted,
        deletedAll,
        deleteAll,
        size,
        num,
        wlanProfile,
        nMultiFrame,
        fileName,
        initialPARK,
        alwaysIndirect,
        trackingActive,
        level,
        prefix,
        login,
        wideband,
        srtp,
        resetDB,
        resetToFactoryDefaults,
        confirm,
        numberOfLines,
        element,
        channels2_4G,
        channels5G,
        voiceboxNum,
        startupDelay,
        escalationDelay,
        activityTimeout1,
        activityTimeout2,
        toneScheme,
        videoStream,
        freeChannels,
        totalChannels,
        singleCodecReplyInSDP,
        readCommunity,
        contact,
        trapCommunity,
        trapHostAddr,
        modified,
        eof,
        key,
        url,
        server,
        port,
        serverStandby,
        portStandby,
        installationId,
        ompWebStartCodebase,
        dialByNumberOnly,
        truncatePpUserName,
        text,
        interval,
        trustedCertificates,
        localCertificates,
        privateKeys,
        restrictedSubscrDur,
        credentials,
        useCommonFileNameOnServer,
        startPort,
        endPort,
        autoAnswer,
        microphoneMute,
        warningTone,
        allowBargeIn,
        pushToTalkPrefix,
        hour,
        minute,
        ntpServerName1,
        ntpServerName2,
        ntpServerName3,
        result,
        sari,
        omm1DomainName,
        omm2DomainName,
        user,
        OMPClient,
        useSIPUserName,
        useSIPUserAuthentication,
        momControlState,
        maxDelay,
        hourCalculated,
        minuteCalculated,
        autoSoftwareCheck,
        editable,
        revXsiDirLookup,
        revXsiDirLookupMatchingDigits,
        GDPRComplianceText,
        ppUIAdministration;

    }

    public static enum errorCodes {
        EVersion,
        EPerm,
        EInval,
        EMissing,
        EExist,
        ENoMem,
        ENoEnt,
        ENoWrite,
        EAuth,
        EAreaFull,
        EFailed,
        ETooLong,
        EWouldBlock,
        EForbidden,
        EInProgress,
        ELicense,
        ELicenseFile,
        EEncryptNotAllowed,
        EPwEmpty,
        EPwUnchanged,
        EPwTooSimilar,
        EPwTooShort,
        EPwSimilarToName,
        EPwSimilarToHost,
        EPwTooManySimilarChars,
        EInvalidChars,
        EPwTooWeak,
        EDectRegDomainInvalid,
        EWlanRegDomainInvalid,
        ELicenseWrongInstallId,
        InternalEExistNotUnique;

    }

    public static enum elemIds {
        InvalidId,
        Open,
        OpenResp,
        Limits,
        LimitsResp,
        Authenticate,
        AuthenticateResp,
        GetPPDevSummary,
        GetPPDevSummaryResp,
        EventPPDevSummary,
        GetPPDev,
        GetPPDevResp,
        CreatePPDev,
        CreatePPDevResp,
        SetPPDev,
        SetPPDevResp,
        DeletePPDev,
        DeletePPDevResp,
        GetLastPPDevAction,
        GetLastPPDevActionResp,
        GetActivePPDev,
        GetActivePPDevResp,
        GetPPUserSummary,
        GetPPUserSummaryResp,
        EventPPUserSummary,
        GetPPUser,
        GetPPUserResp,
        CreatePPUser,
        CreatePPUserResp,
        DeletePPUser,
        DeletePPUserResp,
        SetPPUser,
        SetPPUserResp,
        SetPPUserTracking,
        SetPPUserTrackingResp,
        CreateFixedPP,
        CreateFixedPPResp,
        pp,
        user,
        GetDECTSubscriptionMode,
        GetDECTSubscriptionModeResp,
        SetDECTSubscriptionMode,
        SetDECTSubscriptionModeResp,
        EventDECTSubscriptionMode,
        Subscribe,
        SubscribeResp,
        e,
        rfp,
        GetRFPSummary,
        GetRFPSummaryResp,
        EventRFPSummary,
        GetRFP,
        GetRFPResp,
        CreateRFP,
        CreateRFPResp,
        DeleteRFP,
        DeleteRFPResp,
        SetRFP,
        SetRFPResp,
        EventRFPCnfChange,
        EventRFPStateChange,
        GetSystemName,
        GetSystemNameResp,
        SetSystemName,
        SetSystemNameResp,
        publicKey,
        GetPublicKey,
        GetPublicKeyResp,
        GetSoftwareUpdate,
        GetSoftwareUpdateResp,
        SoftwareUpdate,
        SoftwareUpdateResp,
        EventSoftwareUpdateCnf,
        SystemRestart,
        SystemRestartResp,
        GetRemoteAccess,
        GetRemoteAccessResp,
        SetRemoteAccess,
        SetRemoteAccessResp,
        GetEULAConfirm,
        GetEULAConfirmResp,
        SetEULAConfirm,
        SetEULAConfirmResp,
        GetNetParams,
        GetNetParamsResp,
        SetNetParams,
        SetNetParamsResp,
        GetPARK,
        GetPARKResp,
        SetPARK,
        SetPARKResp,
        GetDECTEncryption,
        GetDECTEncryptionResp,
        SetDECTEncryption,
        SetDECTEncryptionResp,
        GetDECTRegDomain,
        GetDECTRegDomainResp,
        SetDECTRegDomain,
        SetDECTRegDomainResp,
        GetDECTAuthCode,
        GetDECTAuthCodeResp,
        SetDECTAuthCode,
        SetDECTAuthCodeResp,
        GetDevAutoCreate,
        GetDevAutoCreateResp,
        SetDevAutoCreate,
        SetDevAutoCreateResp,
        GetPPFirmwareUpdate,
        GetPPFirmwareUpdateResp,
        SetPPFirmwareUpdate,
        SetPPFirmwareUpdateResp,
        GetWLANRegDomain,
        GetWLANRegDomainResp,
        SetWLANRegDomain,
        SetWLANRegDomainResp,
        GetWLANRegDomainList,
        GetWLANRegDomainListResp,
        regDomain,
        GetUserDataServer,
        GetUserDataServerResp,
        SetUserDataServer,
        SetUserDataServerResp,
        GetBasicSIP,
        GetBasicSIPResp,
        SetBasicSIP,
        SetBasicSIPResp,
        GetAdvancedSIP,
        GetAdvancedSIPResp,
        SetAdvancedSIP,
        SetAdvancedSIPResp,
        GetBackupSIP,
        GetBackupSIPResp,
        SetBackupSIP,
        SetBackupSIPResp,
        GetRTP,
        GetRTPResp,
        SetRTP,
        SetRTPResp,
        GetDTMF,
        GetDTMFResp,
        SetDTMF,
        SetDTMFResp,
        SetSecureSIP,
        SetSecureSIPResp,
        GetSecureSIP,
        GetSecureSIPResp,
        GetSecureSIPCertificate,
        GetSecureSIPCertificateResp,
        EventSecureSIPCertificateCnf,
        SetSecureSIPCertificate,
        SetSecureSIPCertificateResp,
        GetAutoDBBackup,
        GetAutoDBBackupResp,
        SetAutoDBBackup,
        SetAutoDBBackupResp,
        GetAutoDBBackupFileName,
        GetAutoDBBackupFileNameResp,
        EventAutoDBBackupFileNameCnf,
        ManualDBBackup,
        ManualDBBackupResp,
        ManualDBRestore,
        ManualDBRestoreResp,
        GetDbTransferState,
        GetDbTransferStateResp,
        GetTimeZone,
        GetTimeZoneResp,
        GetTimeZoneList,
        GetTimeZoneListResp,
        EventTimeZoneList,
        GetTimeZoneDetails,
        GetTimeZoneDetailsResp,
        SetTimeZone,
        SetTimeZoneResp,
        SetTimeZoneDetails,
        SetTimeZoneDetailsResp,
        ResetTimeZoneDetails,
        ResetTimeZoneDetailsResp,
        zone,
        GetSNMP,
        GetSNMPResp,
        SetSNMP,
        SetSNMPResp,
        GetIMA,
        GetIMAResp,
        SetIMA,
        SetIMAResp,
        ldap,
        GetLDAP,
        GetLDAPResp,
        SetLDAP,
        SetLDAPResp,
        CreateLDAP,
        CreateLDAPResp,
        DeleteLDAP,
        DeleteLDAPResp,
        GetSiteSummary,
        GetSiteSummaryResp,
        EventSiteSummary,
        GetSite,
        GetSiteResp,
        CreateSite,
        CreateSiteResp,
        SetSite,
        SetSiteResp,
        DeleteSite,
        DeleteSiteResp,
        site,
        sites,
        GetDECTPagingAreaSize,
        GetDECTPagingAreaSizeResp,
        SetDECTPagingAreaSize,
        SetDECTPagingAreaSizeResp,
        GetDigitTreatmentSummary,
        GetDigitTreatmentSummaryResp,
        GetDigitTreatment,
        GetDigitTreatmentResp,
        CreateDigitTreatment,
        CreateDigitTreatmentResp,
        DeleteDigitTreatment,
        DeleteDigitTreatmentResp,
        SetDigitTreatment,
        SetDigitTreatmentResp,
        rule,
        GetFACList,
        GetFACListResp,
        SetFACList,
        SetFACListResp,
        GetFACPrefix,
        GetFACPrefixResp,
        SetFACPrefix,
        SetFACPrefixResp,
        fac,
        GetAlarmTriggerSummary,
        GetAlarmTriggerSummaryResp,
        GetAlarmTrigger,
        GetAlarmTriggerResp,
        CreateAlarmTrigger,
        CreateAlarmTriggerResp,
        DeleteAlarmTrigger,
        DeleteAlarmTriggerResp,
        SetAlarmTrigger,
        SetAlarmTriggerResp,
        trigger,
        GetRFPStatisticConfig,
        GetRFPStatisticConfigResp,
        rfpStatHead,
        rfpStatSummary,
        rfpStatName,
        GetRFPStatistic,
        GetRFPStatisticResp,
        rfpStatData,
        ResetRFPStatistic,
        ResetRFPStatisticResp,
        RequestPositionInfo,
        RequestPositionInfoResp,
        GetSysStatisticConfig,
        GetSysStatisticConfigResp,
        GetSysStatisticOccurrence,
        GetSysStatisticOccurrenceResp,
        GetSysStatisticMinMax,
        GetSysStatisticMinMaxResp,
        GetSysStatisticMinMaxRecord,
        GetSysStatisticMinMaxRecordResp,
        GetSysStatisticMinMaxSummary,
        GetSysStatisticMinMaxSummaryResp,
        ResetSysStatistic,
        ResetSysStatisticResp,
        sysStatName,
        sysCounter,
        sysRecHeader,
        sysRec,
        sysSummary,
        GetRFPSync,
        GetRFPSyncResp,
        forward,
        backward,
        GetWLANProfile,
        GetWLANProfileResp,
        CreateWLANProfile,
        CreateWLANProfileResp,
        DeleteWLANProfile,
        DeleteWLANProfileResp,
        SetWLANProfile,
        SetWLANProfileResp,
        profile,
        ssid,
        ssid1,
        ssid2,
        ssid3,
        ssid4,
        GetACLEntry,
        GetACLEntryResp,
        CreateACLEntry,
        CreateACLEntryResp,
        SetACLEntry,
        SetACLEntryResp,
        DeleteACLEntry,
        DeleteACLEntryResp,
        entry,
        GetWLANClients,
        GetWLANClientsResp,
        EventWLANClient,
        GetFile,
        GetFileResp,
        PutFile,
        PutFileResp,
        GetSyslogServer,
        GetSyslogServerResp,
        SetSyslogServer,
        SetSyslogServerResp,
        EventSyslogServerCnf,
        GetAccountSummary,
        GetAccountSummaryResp,
        EventAccountSummary,
        GetAccount,
        GetAccountResp,
        CreateAccount,
        CreateAccountResp,
        SetAccount,
        SetAccountResp,
        DeleteAccount,
        DeleteAccountResp,
        EventAccountCnf,
        account,
        accountState,
        permission,
        GetHealthState,
        GetHealthStateResp,
        health,
        EventHealthState,
        GetFlashMemUsage,
        GetFlashMemUsageResp,
        GetCoreDumpURL,
        SetCoreDumpURL,
        GetCoreDumpURLResp,
        SetCoreDumpURLResp,
        EventCoreDumpURLCnf,
        GetNTPServer,
        GetNTPServerResp,
        SetNTPServer,
        SetNTPServerResp,
        EventNTPServerCnf,
        GetPpProfile,
        GetPpProfileResp,
        SetPpProfile,
        SetPpProfileResp,
        EventPpProfileCnf,
        ppProfile,
        codec,
        url,
        net,
        SendMessage,
        SendMessageResp,
        msg,
        loc,
        vis,
        confirm,
        confirmReq,
        confirmation,
        DeleteMessage,
        DeleteMessageResp,
        CancelMessage,
        CancelMessageResp,
        EventSystemNameCnf,
        EventRemoteAccessCnf,
        EventEULAConfirmCnf,
        EventNetParamsCnf,
        EventPARKCnf,
        EventDECTEncryptionCnf,
        EventDECTRegDomainCnf,
        EventDECTAuthCodeCnf,
        EventDevAutoCreateCnf,
        EventPPFirmwareUpdateCnf,
        EventWLANRegDomainCnf,
        EventUserDataServerCnf,
        EventBasicSIPCnf,
        EventAdvancedSIPCnf,
        EventBackupSIPCnf,
        EventRTPCnf,
        EventDTMFCnf,
        EventSecureSIPCnf,
        EventAutoDBBackupCnf,
        EventSNMPCnf,
        EventPPTransaction,
        EventRFPCnf,
        EventRFPState,
        EventRFPDetails,
        EventMessageQueueEmpty,
        EventMessageProgress,
        EventMessageConfirmation,
        EventMessageSend,
        EventAlarmTrigger,
        EventAlarmCallProgress,
        EventPositionInfo,
        EventPositionHistory,
        EventPositionTrack,
        EventPositionRequest,
        EventPPDevCnf,
        EventPPUserCnf,
        EventTimeZoneCnf,
        EventTimeZoneDetailsCnf,
        EventIMACnf,
        EventSiteCnf,
        EventRFPSync,
        EventRFPSyncRel,
        EventDECTPagingAreaCnf,
        EventDigitTreatmentCnf,
        EventFACCnf,
        EventFACPrefixCnf,
        EventAlarmTriggerCnf,
        EventLDAPCnf,
        EventWLANProfileCnf,
        EventACLCnf,
        EventDbTransferState,
        Ping,
        PingResp,
        GetPBX,
        GetPBXResp,
        SetPBX,
        SetPBXResp,
        EventPBXCnf,
        GetLicense,
        GetLicenseResp,
        SetLicense,
        SetLicenseResp,
        violation,
        licenseRfp,
        sysLicense,
        msgLicense,
        locLicense,
        EventLicenseCnf,
        EventPermissionChange,
        GetStbState,
        EventStbStateChange,
        GetRegistrationTrafficShaping,
        GetRegistrationTrafficShapingResp,
        SetRegistrationTrafficShaping,
        SetRegistrationTrafficShapingResp,
        EventRegistrationTrafficShapingCnf,
        GetSuplServ,
        GetSuplServResp,
        SetSuplServ,
        SetSuplServResp,
        EventSuplServCnf,
        GetConferenceServerSIP,
        GetConferenceServerSIPResp,
        SetConferenceServerSIP,
        SetConferenceServerSIPResp,
        EventConferenceServerSIPCnf,
        GetPPLoginVariant,
        GetPPLoginVariantResp,
        SetPPLoginVariant,
        SetPPLoginVariantResp,
        EventPPLoginVariantCnf,
        xmlAppl,
        CreateXMLApplication,
        CreateXMLApplicationResp,
        DeleteXMLApplication,
        DeleteXMLApplicationResp,
        SetXMLApplication,
        SetXMLApplicationResp,
        GetXMLApplication,
        GetXMLApplicationResp,
        EventXMLApplicationCnf,
        version,
        GetVersions,
        GetVersionsResp,
        GetSysVoiceboxNum,
        GetSysVoiceboxNumResp,
        SetSysVoiceboxNum,
        SetSysVoiceboxNumResp,
        EventSysVoiceboxNumCnf,
        GetUserMonitoring,
        GetUserMonitoringResp,
        SetUserMonitoring,
        SetUserMonitoringResp,
        EventUserMonitoringCnf,
        GetPPFirmwareUpdateOverview,
        GetPPFirmwareUpdateOverviewResp,
        EventPPFirmwareUpdateOverview,
        ppFwSt,
        GetPPFirmwareUpdateStatus,
        GetPPFirmwareUpdateStatusResp,
        EventPPFirmwareUpdateStatus,
        SetPPUserDevRelation,
        SetPPUserDevRelationResp,
        GetPPState,
        GetPPStateResp,
        EventPPState,
        GetBluetoothBeacon,
        GetBluetoothBeaconResp,
        CreateBluetoothBeacon,
        CreateBluetoothBeaconResp,
        DeleteBluetoothBeacon,
        DeleteBluetoothBeaconResp,
        SetBluetoothBeacon,
        SetBluetoothBeaconResp,
        EventBluetoothBeaconCnf,
        GetBluetoothClientStatistic,
        GetBluetoothClientStatisticResp,
        EventBluetoothClientStatistic,
        btClientStat,
        btb,
        room,
        CreateConferenceRoom,
        CreateConferenceRoomResp,
        DeleteConferenceRoom,
        DeleteConferenceRoomResp,
        GetConferenceRoom,
        GetConferenceRoomResp,
        SetConferenceRoom,
        SetConferenceRoomResp,
        EventConferenceRoomCnf,
        GetFreeConferenceChannels,
        GetFreeConferenceChannelsResp,
        EventFreeConferenceChannels,
        GetBluetoothGlobalSettings,
        GetBluetoothGlobalSettingsResp,
        SetBluetoothGlobalSettings,
        SetBluetoothGlobalSettingsResp,
        EventBluetoothGlobalSettingsCnf,
        rfpSens,
        ppSens,
        GetBluetoothSensitivity,
        GetBluetoothSensitivityResp,
        SetBluetoothSensitivity,
        SetBluetoothSensitivityResp,
        EventBluetoothSensitivityCnf,
        GetSysToneScheme,
        GetSysToneSchemeResp,
        SetSysToneScheme,
        SetSysToneSchemeResp,
        EventSysToneSchemeCnf,
        videoDev,
        ppList,
        GetVideoDev,
        GetVideoDevResp,
        CreateVideoDev,
        CreateVideoDevResp,
        SetVideoDev,
        SetVideoDevResp,
        DeleteVideoDev,
        DeleteVideoDevResp,
        EventVideoDevCnf,
        GetVideoDevLink,
        GetVideoDevLinkResp,
        EventVideoDevLink,
        GetRFPCapture,
        GetRFPCaptureResp,
        SetRFPCapture,
        SetRFPCaptureResp,
        EventRFPCaptureCnf,
        GetRFPCaptureList,
        GetRFPCaptureListResp,
        DeleteRFPCaptureList,
        DeleteRFPCaptureListResp,
        DeleteRFPCaptureListElem,
        DeleteRFPCaptureListElemResp,
        EventRFPCapture,
        EventRFPConnectAttempt,
        GetEventLogBuffer,
        GetEventLogBufferResp,
        DeleteEventLogBuffer,
        DeleteEventLogBufferResp,
        EventEventLogEntry,
        EventEventLogBufferDelete,
        trustedCertificates,
        localCertificates,
        privateKeys,
        certificate,
        GetRFPMediaStreamQuality,
        GetRFPMediaStreamQualityResp,
        EventRFPMediaStreamQuality,
        GetRFPSyncQuality,
        GetRFPSyncQualityResp,
        EventRFPSyncQuality,
        GetRFPIpQuality,
        GetRFPIpQualityResp,
        EventRFPIpQuality,
        msQuality,
        ipQuality,
        syncQuality,
        GetLicenseServerList,
        GetLicenseServerListResp,
        SetLicenseServerList,
        SetLicenseServerListResp,
        EventLicenseServerListCnf,
        licenseServer1,
        licenseServer2,
        licenseServer3,
        GetBluetoothBeaconSummary,
        GetBluetoothBeaconSummaryResp,
        EventBluetoothBeaconSummary,
        GetVideoDevSummary,
        GetVideoDevSummaryResp,
        EventVideoDevSummary,
        GetOMPURL,
        GetOMPURLResp,
        SetOMPURL,
        SetOMPURLResp,
        EventOMPURLCnf,
        GetDECTPpSettings,
        GetDECTPpSettingsResp,
        SetDECTPpSettings,
        SetDECTPpSettingsResp,
        EventDECTPpSettingsCnf,
        bootTextHeadline,
        bootTextStartup,
        ResetRFPMediaStreamQuality,
        ResetRFPMediaStreamQualityResp,
        GetAdditionalSettings,
        GetAdditionalSettingsResp,
        SetAdditionalSettings,
        SetAdditionalSettingsResp,
        EventAdditionalSettingsCnf,
        GetSecureSIPCertificateServerImport,
        GetSecureSIPCertificateServerImportResp,
        SetSecureSIPCertificateServerImport,
        SetSecureSIPCertificateServerImportResp,
        EventSecureSIPCertificateServerImportCnf,
        GetRestrictedSubscriptionDuration,
        GetRestrictedSubscriptionDurationResp,
        SetRestrictedSubscriptionDuration,
        SetRestrictedSubscriptionDurationResp,
        EventRestrictedSubscriptionDurationCnf,
        GetSpecialBranding,
        GetSpecialBrandingResp,
        SetSpecialBranding,
        SetSpecialBrandingResp,
        EventSpecialBrandingCnf,
        GetPortRangeSIP,
        GetPortRangeSIPResp,
        SetPortRangeSIP,
        SetPortRangeSIPResp,
        EventPortRangeSIPCnf,
        userUdpTcp,
        userTls,
        confRoomUdpTcp,
        confRoomTls,
        GetIntercomCallHandlingSIP,
        GetIntercomCallHandlingSIPResp,
        SetIntercomCallHandlingSIP,
        SetIntercomCallHandlingSIPResp,
        EventIntercomCallHandlingSIPCnf,
        GetConfigURL,
        GetConfigURLResp,
        SetConfigURL,
        SetConfigURLResp,
        EventConfigURLCnf,
        GetUsedConfigURL,
        GetUsedConfigURLResp,
        EventUsedConfigURL,
        GetSystemCredentials,
        GetSystemCredentialsResp,
        SetSystemCredentials,
        SetSystemCredentialsResp,
        EventSystemCredentialsCnf,
        GetSystemProvUpdTrig,
        GetSystemProvUpdTrigResp,
        SetSystemProvUpdTrig,
        SetSystemProvUpdTrigResp,
        EventSystemProvUpdTrigCnf,
        PARKFromServer,
        PARKFromServerResp,
        EventPARKFromServerResult,
        GetOMMCertificate,
        GetOMMCertificateResp,
        SetOMMCertificate,
        SetOMMCertificateResp,
        EventOMMCertificateCnf,
        GetPPFirmwareURL,
        GetPPFirmwareURLResp,
        SetPPFirmwareURL,
        SetPPFirmwareURLResp,
        EventPPFirmwareURLCnf,
        GetSoftwareImageURL,
        GetSoftwareImageURLResp,
        SetSoftwareImageURL,
        SetSoftwareImageURLResp,
        EventSoftwareImageURLCnf,
        GetPreserveUserDeviceRelation,
        GetPreserveUserDeviceRelationResp,
        SetPreserveUserDeviceRelation,
        SetPreserveUserDeviceRelationResp,
        EventPreserveUserDeviceRelationCnf,
        GetSecurePROVCertificateServerImport,
        GetSecurePROVCertificateServerImportResp,
        SetSecurePROVCertificateServerImport,
        SetSecurePROVCertificateServerImportResp,
        EventSecurePROVCertificateServerImportCnf,
        GetSecureOMMCertificateServerImport,
        GetSecureOMMCertificateServerImportResp,
        SetSecureOMMCertificateServerImport,
        SetSecureOMMCertificateServerImportResp,
        EventSecureOMMCertificateServerImportCnf,
        ActivateRemoteSystemDump,
        GetRemoteSystemDump,
        GetRemoteSystemDumpResp,
        SetRemoteSystemDump,
        SetRemoteSystemDumpResp,
        EventRemoteSystemDumpCnf,
        GetSARI,
        GetSARIResp,
        SetSARI,
        SetSARIResp,
        EventSARICnf,
        GetUserDeviceSyncOMM,
        GetUserDeviceSyncOMMResp,
        SetUserDeviceSyncOMM,
        SetUserDeviceSyncOMMResp,
        EventUserDeviceSyncOMMCnf,
        GetDECTPowerLimit,
        GetDECTPowerLimitResp,
        SetDECTPowerLimit,
        SetDECTPowerLimitResp,
        EventDECTPowerLimitCnf,
        directory,
        GetCorporateDirectory,
        GetCorporateDirectoryResp,
        SetCorporateDirectory,
        SetCorporateDirectoryResp,
        EventCorporateDirectoryCnf,
        GetCorporateDirectoryOrder,
        GetCorporateDirectoryOrderResp,
        SetCorporateDirectoryOrder,
        SetCorporateDirectoryOrderResp,
        EventCorporateDirectoryOrderCnf,
        omm,
        GetOMM,
        GetOMMResp,
        CreateOMM,
        CreateOMMResp,
        SetOMM,
        SetOMMResp,
        DeleteOMM,
        DeleteOMMResp,
        EventOMMCnf,
        CreateApplicationDataChannel,
        CreateApplicationDataChannelResp,
        DeleteApplicationDataChannel,
        DeleteApplicationDataChannelResp,
        EventApplicationDataChannelCnf,
        ApplicationDataChannel,
        ApplicationDataChannelResp,
        EventApplicationDataChannel,
        SubscribeApplicationDataChannel,
        SubscribeApplicationDataChannelResp,
        EventClientInfo,
        GetPPDevByIPEI,
        GetPPDevByIPEIResp,
        GetPPUserByNumber,
        GetPPUserByNumberResp,
        GetMOMControlState,
        GetMOMControlStateResp,
        EventMOMControlState,
        GetSupplicant,
        GetSupplicantResp,
        SetSupplicant,
        SetSupplicantResp,
        EventSupplicantCnf,
        GetSupplicantCertificate,
        GetSupplicantCertificateResp,
        SetSupplicantCertificate,
        SetSupplicantCertificateResp,
        EventSupplicantCertificateCnf,
        GetSupplicantCertificateServerImport,
        GetSupplicantCertificateServerImportResp,
        SetSupplicantCertificateServerImport,
        SetSupplicantCertificateServerImportResp,
        EventSupplicantCertificateServerImportCnf,
        GetGDPRCompliance,
        GetGDPRComplianceResp,
        SetGDPRCompliance,
        SetGDPRComplianceResp,
        EventGDPRComplianceCnf,
        internalEvent_LinkOpen,
        internalEvent_LinkReleased,
        internalEvent_LinkOpenFailed,
        internalEvent_LinkReady,
        internalEvent_Exception,
        LocatingPositioningData,
        Image,
        Device;

        private LinkedList<OmiMessageInterface> listenerList = new LinkedList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerDataNotificationListener(OmiMessageInterface omiMessageInterface) {
            LinkedList<OmiMessageInterface> linkedList = this.listenerList;
            synchronized (linkedList) {
                this.listenerList.add(omiMessageInterface);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deregisterDataNotificationListener(OmiMessageInterface omiMessageInterface) {
            LinkedList<OmiMessageInterface> linkedList = this.listenerList;
            synchronized (linkedList) {
                this.listenerList.remove(omiMessageInterface);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processMessage(OmiMessage omiMessage) {
            LinkedList<OmiMessageInterface> linkedList = this.listenerList;
            synchronized (linkedList) {
                for (OmiMessageInterface omiMessageInterface : this.listenerList) {
                    if (omiMessageInterface == null) continue;
                    if (useSynchronizer) {
                        EventQueue.invokeLater(new OmiMessageSynchronizer(omiMessageInterface, omiMessage));
                        continue;
                    }
                    omiMessageInterface.processOmiMessage(omiMessage);
                }
            }
        }
    }
}

