/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.OmiHandler;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;
import com.aastra.omilib.PpDataHandler;
import com.aastra.omilib.PpDevDataRecord;
import com.aastra.util.UtilSpy;
import java.util.HashMap;
import java.util.LinkedList;

public class PpDevByIPEIHandler
implements OmiManagementEventInterface,
OmiMessageInterface {
    private OmiManagement om = null;
    private OmiHandler omiHandler = null;
    private HashMap<Integer, String> pendingMap = new HashMap();
    private int seqNb = 0;
    private LinkedList<PpDevByIPEINotificationInterface> listenerList = new LinkedList();

    public PpDevByIPEIHandler(OmiManagement omiManagement) {
        this.omiHandler = omiManagement.getOmiHandler();
        this.om = omiManagement;
        this.om.registerManagementEventListener(this);
        OmiMessage.elemIds.GetPPDevByIPEIResp.registerDataNotificationListener(this);
    }

    public void registerDataNotificationListener(PpDevByIPEINotificationInterface ppDevByIPEINotificationInterface) {
        this.listenerList.add(ppDevByIPEINotificationInterface);
    }

    public void deregisterDataNotificationListener(PpDevByIPEINotificationInterface ppDevByIPEINotificationInterface) {
        this.listenerList.remove(ppDevByIPEINotificationInterface);
    }

    private void GenerateDataNotification(PpDevDataRecord ppDevDataRecord) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating PP dev by IPEI notification: No listener");
        }
        for (PpDevByIPEINotificationInterface ppDevByIPEINotificationInterface : this.listenerList) {
            if (ppDevByIPEINotificationInterface == null) continue;
            ppDevByIPEINotificationInterface.processPpDevByIPEINotification(ppDevDataRecord);
        }
    }

    private void GenerateErrorNotification(String string, OmiMessage omiMessage) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating PP dev by IPEI error notification: No listener");
        }
        for (PpDevByIPEINotificationInterface ppDevByIPEINotificationInterface : this.listenerList) {
            if (ppDevByIPEINotificationInterface == null) continue;
            ppDevByIPEINotificationInterface.processPpDevByIPEIErrorNotification(string, omiMessage);
        }
    }

    public void sendGetPPDevByIPEI(String string) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetPPDevByIPEI.name());
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), this.seqNb);
        omiMessage.addAttrib(OmiMessage.PPDevType.ipei.name(), string);
        this.omiHandler.sendOmiMessage(omiMessage);
        this.pendingMap.put(this.seqNb, string);
        if (++this.seqNb > 50001) {
            this.seqNb = 0;
        }
    }

    private void processGetPPDevByIPEIResp(OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        int n = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
        String string2 = this.pendingMap.get(n);
        if (string != null) {
            this.GenerateErrorNotification(string2, omiMessage);
        } else {
            OmiMessage omiMessage2 = omiMessage.getSubElement();
            int n2 = Integer.parseInt(omiMessage2.getAttribVal(OmiMessage.PPDevType.ppn.name()));
            PpDevDataRecord ppDevDataRecord = new PpDevDataRecord(n2);
            PpDataHandler.setDevAttribsFromMsg(ppDevDataRecord, omiMessage2);
            this.GenerateDataNotification(ppDevDataRecord);
        }
    }

    @Override
    public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
        this.pendingMap.clear();
        this.seqNb = 0;
    }

    @Override
    public void processOmiMessage(OmiMessage omiMessage) {
        switch (omiMessage.id) {
            case GetPPDevByIPEIResp: {
                this.processGetPPDevByIPEIResp(omiMessage);
                break;
            }
        }
    }

    public static interface PpDevByIPEINotificationInterface {
        public void processPpDevByIPEINotification(PpDevDataRecord var1);

        public void processPpDevByIPEIErrorNotification(String var1, OmiMessage var2);
    }
}

