/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.Database;
import com.aastra.omilib.DatabaseChangeEvent;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.PpDevDataRecord;
import java.util.HashSet;

public class PpDevDatabase
extends Database {
    public static final int MAX_PP = 50001;
    private PpDevDataRecord[] ppArray = new PpDevDataRecord[50001];
    private int[] ppIdxArray = new int[50001];
    private int AnzRecords = 0;
    private int maxPPN = 0;
    private HashSet<Integer> filterPPN = new HashSet();

    public PpDevDataRecord getPpByPpn(int n) {
        if (n >= 0 && n < 50001) {
            return this.ppArray[n];
        }
        return null;
    }

    @Override
    public PpDevDataRecord getRecordByIdx(int n) {
        if (n >= 0 && n < this.AnzRecords && this.ppArray[this.ppIdxArray[n]] != null) {
            return this.ppArray[this.ppIdxArray[n]];
        }
        return null;
    }

    public PpDevDataRecord createPp(PpDevDataRecord ppDevDataRecord) {
        int n = (Integer)ppDevDataRecord.getField(PpDevDataRecord.IDX_PPN);
        DatabaseChangeEvent databaseChangeEvent = new DatabaseChangeEvent(Database.DatabaseChangeEnum.RECORD_ADDED, n, DatabaseChangeEvent.DatabaseChangeType.PP_DEV);
        if (n < 50001) {
            if (this.ppArray[n] != null) {
                databaseChangeEvent.cause = Database.DatabaseChangeEnum.RECORD_CHANGED;
            }
            this.ppArray[n] = ppDevDataRecord;
            if (n > this.maxPPN) {
                this.maxPPN = n;
            }
            this.updateIndex(databaseChangeEvent);
            return this.ppArray[n];
        }
        return null;
    }

    public void deletePp(int n) {
        if (n >= 0 && n < 50001 && this.ppArray[n] != null) {
            this.ppArray[n].deleted = true;
            this.updateIndex(new DatabaseChangeEvent(Database.DatabaseChangeEnum.RECORD_DELETED, n, DatabaseChangeEvent.DatabaseChangeType.PP_DEV));
        }
    }

    @Override
    public void updateIndex() {
        this.updateIndex(new DatabaseChangeEvent(Database.DatabaseChangeEnum.INDEX_UPDATE, 0, DatabaseChangeEvent.DatabaseChangeType.PP_DEV));
    }

    private void updateIndex(DatabaseChangeEvent databaseChangeEvent) {
        int n = -1;
        this.AnzRecords = 0;
        for (int i = 0; i <= this.maxPPN; ++i) {
            if (this.ppArray[i] == null) continue;
            if (this.ppArray[i].deleted) {
                this.ppArray[i] = null;
                continue;
            }
            if (this.getFilterActive()) {
                if (this.filterMatch(this.ppArray[i])) {
                    if (i == databaseChangeEvent.recordId) {
                        n = this.AnzRecords;
                    }
                    this.ppIdxArray[this.AnzRecords++] = i;
                    if (this.filterPPN.contains(i)) continue;
                    this.filterPPN.add(i);
                    if (i != databaseChangeEvent.recordId || databaseChangeEvent.cause != Database.DatabaseChangeEnum.RECORD_CHANGED) continue;
                    databaseChangeEvent.cause = Database.DatabaseChangeEnum.RECORD_ADDED;
                    continue;
                }
                if (!this.filterPPN.contains(i)) continue;
                this.filterPPN.remove(i);
                if (i != databaseChangeEvent.recordId || databaseChangeEvent.cause != Database.DatabaseChangeEnum.RECORD_CHANGED) continue;
                databaseChangeEvent.cause = Database.DatabaseChangeEnum.RECORD_DELETED;
                continue;
            }
            if (!this.filterPPN.isEmpty()) {
                this.filterPPN.clear();
            }
            if (i == databaseChangeEvent.recordId) {
                n = this.AnzRecords;
            }
            this.ppIdxArray[this.AnzRecords++] = i;
        }
        if (n != -1) {
            databaseChangeEvent.modelId = n;
        }
        if (databaseChangeEvent.cause != Database.DatabaseChangeEnum.RECORD_CHANGED || databaseChangeEvent.modelId != -1) {
            this.generateChangeNotification(databaseChangeEvent);
        }
    }

    @Override
    public int getRecordNumber() {
        return this.AnzRecords;
    }

    @Override
    public String[] getFieldNames() {
        return PpDevDataRecord.getFieldNames();
    }

    public void clearAll() {
        for (int i = 0; i <= this.maxPPN; ++i) {
            this.ppArray[i] = null;
        }
        this.maxPPN = 0;
        this.AnzRecords = 0;
    }

    public void updateTransientFields(PpDevDataRecord ppDevDataRecord) {
        int n = (Integer)ppDevDataRecord.getField(PpDevDataRecord.IDX_PPN);
        PpDevDataRecord ppDevDataRecord2 = this.getPpByPpn(n);
        if (ppDevDataRecord2 != null) {
            for (int i = 0; i < PpDevDataRecord.ppDevNumberOfAttribs; ++i) {
                if ((i >= PpDevDataRecord.ppDevNumberOfOmiAttribs || !OmiMessage.PPDevType.values()[i].isClassReadOnly()) && i < PpDevDataRecord.ppDevNumberOfOmiAttribs || ppDevDataRecord2.getField(i) == null || (ppDevDataRecord.getField(i) == null || ppDevDataRecord.getField(i).equals(ppDevDataRecord2.getField(i))) && ppDevDataRecord.getField(i) != null) continue;
                ppDevDataRecord.setField(i, ppDevDataRecord2.getField(i));
                ppDevDataRecord.commitChangeOfField(i);
            }
        }
    }
}

