/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.SummaryHandler;
import com.aastra.util.UtilSpy;
import java.util.LinkedList;

public class PpDevSummaryHandler
extends SummaryHandler {
    private PpDevSummaryClass summary = null;
    private LinkedList<PpDevSummaryNotificationInterface> listenerList = new LinkedList();

    public void registerPpDevSummaryNotificationListener(PpDevSummaryNotificationInterface ppDevSummaryNotificationInterface) {
        this.listenerList.add(ppDevSummaryNotificationInterface);
    }

    public void deregisterPpDevSummaryNotificationListener(PpDevSummaryNotificationInterface ppDevSummaryNotificationInterface) {
        this.listenerList.remove(ppDevSummaryNotificationInterface);
    }

    @Override
    protected void GenerateSummaryNotification() {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating pp dev summary notification: No listener");
        }
        PpDevSummaryClass ppDevSummaryClass = this.summary.clone();
        for (PpDevSummaryNotificationInterface ppDevSummaryNotificationInterface : this.listenerList) {
            if (ppDevSummaryNotificationInterface == null) continue;
            ppDevSummaryNotificationInterface.processPpDevSummaryNotification(ppDevSummaryClass);
        }
    }

    @Override
    protected void GenerateSummaryErrorNotification(OmiMessage omiMessage) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating pp dev summary error notification: No listener");
        }
        for (PpDevSummaryNotificationInterface ppDevSummaryNotificationInterface : this.listenerList) {
            if (ppDevSummaryNotificationInterface == null) continue;
            ppDevSummaryNotificationInterface.processPpDevSummaryErrorNotification(omiMessage);
        }
    }

    public PpDevSummaryHandler(OmiManagement omiManagement) {
        super(omiManagement, OmiMessage.elemIds.GetPPDevSummary, OmiMessage.elemIds.GetPPDevSummaryResp, OmiMessage.elemIds.EventPPDevSummary, OmiMessage.EventType.PPDevSummary);
    }

    public PpDevSummaryClass getSummary() {
        if (this.summary == null) {
            this.summary = new PpDevSummaryClass();
        }
        return this.summary.clone();
    }

    @Override
    protected void initSummary() {
        if (this.summary == null) {
            this.summary = new PpDevSummaryClass();
        } else {
            this.summary.clear();
        }
        this.GenerateSummaryNotification();
    }

    @Override
    protected boolean processSummary(OmiMessage omiMessage) {
        int n;
        boolean bl = false;
        if (omiMessage.getAttribVal(OmiMessage.PPDevSummaryType.nRecords.name()) != null && this.summary.nRecords != (n = omiMessage.getAttribValInt(OmiMessage.PPDevSummaryType.nRecords.name()))) {
            this.summary.nRecords = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.PPDevSummaryType.ppnFirst.name()) != null && this.summary.ppnFirst != (n = omiMessage.getAttribValInt(OmiMessage.PPDevSummaryType.ppnFirst.name()))) {
            this.summary.ppnFirst = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.PPDevSummaryType.subscribedDevs.name()) != null && this.summary.nSubscribed != (n = omiMessage.getAttribValInt(OmiMessage.PPDevSummaryType.subscribedDevs.name()))) {
            this.summary.nSubscribed = n;
            bl = true;
        }
        return bl;
    }

    public static interface PpDevSummaryNotificationInterface {
        public void processPpDevSummaryNotification(PpDevSummaryClass var1);

        public void processPpDevSummaryErrorNotification(OmiMessage var1);
    }

    public static class PpDevSummaryClass {
        public int nRecords = 0;
        public int ppnFirst = 0;
        public int nSubscribed = 0;

        public void clear() {
            this.nRecords = 0;
            this.ppnFirst = 0;
            this.nSubscribed = 0;
        }

        public PpDevSummaryClass clone() {
            PpDevSummaryClass ppDevSummaryClass = new PpDevSummaryClass();
            ppDevSummaryClass.nRecords = this.nRecords;
            ppDevSummaryClass.ppnFirst = this.ppnFirst;
            ppDevSummaryClass.nSubscribed = this.nSubscribed;
            return ppDevSummaryClass;
        }
    }
}

