/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.Database;
import com.aastra.omilib.DatabaseChangeEvent;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.PpUmoDataRecord;
import com.aastra.omilib.PpUserDataRecord;

public class PpUmoDatabase
extends Database {
    public static final int MAX_UMO_USER = 50001;
    private PpUmoDataRecord[] umoArray = new PpUmoDataRecord[50001];
    private int[] umoIdxArray = new int[50001];
    private int nbRecords = 0;
    private int maxUid = 0;

    public PpUmoDataRecord getRecordByUid(int n) {
        if (n >= 0 && n < 50001) {
            return this.umoArray[n];
        }
        return null;
    }

    @Override
    public PpUmoDataRecord getRecordByIdx(int n) {
        if (n >= 0 && n < this.nbRecords) {
            return this.umoArray[this.umoIdxArray[n]];
        }
        return null;
    }

    public PpUmoDataRecord updateUmoRecord(PpUserDataRecord ppUserDataRecord) {
        PpUmoDataRecord ppUmoDataRecord = null;
        int n = (Integer)ppUserDataRecord.getField(PpUmoDataRecord.IDX_UID);
        OmiMessage.PPMonitoringModeType pPMonitoringModeType = (OmiMessage.PPMonitoringModeType)((Object)ppUserDataRecord.getField(PpUserDataRecord.IDX_MONITORING));
        if (pPMonitoringModeType == OmiMessage.PPMonitoringModeType.Off) {
            ppUmoDataRecord = this.getRecordByUid(n);
            if (ppUmoDataRecord != null) {
                this.deleteUmoRecord(n);
            }
        } else {
            ppUmoDataRecord = this.getRecordByUid(n);
            if (ppUmoDataRecord == null) {
                ppUmoDataRecord = new PpUmoDataRecord(n);
            }
            ppUmoDataRecord.setField(PpUmoDataRecord.IDX_PPN, ppUserDataRecord.getField(PpUserDataRecord.IDX_PPN));
            ppUmoDataRecord.setField(PpUmoDataRecord.IDX_NAME, ppUserDataRecord.getField(PpUserDataRecord.IDX_NAME));
            ppUmoDataRecord.setField(PpUmoDataRecord.IDX_NUM, ppUserDataRecord.getField(PpUserDataRecord.IDX_NUM));
            ppUmoDataRecord.setField(PpUmoDataRecord.IDX_MONITORING, ppUserDataRecord.getField(PpUserDataRecord.IDX_MONITORING));
            ppUmoDataRecord.setField(PpUmoDataRecord.IDX_MONITORING_HAS, ppUserDataRecord.getField(PpUserDataRecord.IDX_MONITORING_HAS));
            ppUmoDataRecord.setField(PpUmoDataRecord.IDX_MONITORING_HSS, ppUserDataRecord.getField(PpUserDataRecord.IDX_MONITORING_HSS));
            ppUmoDataRecord.setField(PpUmoDataRecord.IDX_MONITORING_HRS, ppUserDataRecord.getField(PpUserDataRecord.IDX_MONITORING_HRS));
            ppUmoDataRecord.setField(PpUmoDataRecord.IDX_MONITORING_HCS, ppUserDataRecord.getField(PpUserDataRecord.IDX_MONITORING_HCS));
            ppUmoDataRecord.setField(PpUmoDataRecord.IDX_MONITORING_SRS, ppUserDataRecord.getField(PpUserDataRecord.IDX_MONITORING_SRS));
            ppUmoDataRecord.setField(PpUmoDataRecord.IDX_MONITORING_SCS, ppUserDataRecord.getField(PpUserDataRecord.IDX_MONITORING_SCS));
            ppUmoDataRecord.setField(PpUmoDataRecord.IDX_MONITORING_CDS, ppUserDataRecord.getField(PpUserDataRecord.IDX_MONITORING_CDS));
            ppUmoDataRecord.setField(PpUmoDataRecord.IDX_MONITORING_HBS, ppUserDataRecord.getField(PpUserDataRecord.IDX_MONITORING_HBS));
            ppUmoDataRecord.setField(PpUmoDataRecord.IDX_MONITORING_BTS, ppUserDataRecord.getField(PpUserDataRecord.IDX_MONITORING_BTS));
            ppUmoDataRecord.setField(PpUmoDataRecord.IDX_MONITORING_SWS, ppUserDataRecord.getField(PpUserDataRecord.IDX_MONITORING_SWS));
            ppUmoDataRecord.setField(PpUmoDataRecord.IDX_MONITORING_CUS, ppUserDataRecord.getField(PpUserDataRecord.IDX_MONITORING_CUS));
            return this.createUmoRecord(ppUmoDataRecord);
        }
        return null;
    }

    public void deleteUmoRecord(int n) {
        if (n >= 0 && n < 50001 && this.umoArray[n] != null) {
            this.umoArray[n].deleted = true;
            this.updateIndex(new DatabaseChangeEvent(Database.DatabaseChangeEnum.RECORD_DELETED, n, DatabaseChangeEvent.DatabaseChangeType.PP_UMO));
        }
    }

    @Override
    public void updateIndex() {
        this.updateIndex(new DatabaseChangeEvent(Database.DatabaseChangeEnum.INDEX_UPDATE, 0, DatabaseChangeEvent.DatabaseChangeType.PP_UMO));
    }

    public void updateIndex(DatabaseChangeEvent databaseChangeEvent) {
        this.nbRecords = 0;
        int n = -1;
        for (int i = 0; i <= this.maxUid; ++i) {
            if (this.umoArray[i] == null) continue;
            if (this.umoArray[i].deleted) {
                this.umoArray[i] = null;
                continue;
            }
            if (i == databaseChangeEvent.recordId) {
                n = this.nbRecords;
            }
            this.umoIdxArray[this.nbRecords++] = i;
        }
        if (n != -1) {
            databaseChangeEvent.modelId = n;
        }
        this.generateChangeNotification(databaseChangeEvent);
    }

    @Override
    public int getRecordNumber() {
        return this.nbRecords;
    }

    @Override
    public String[] getFieldNames() {
        return PpUmoDataRecord.getFieldNames();
    }

    public void clearAll() {
        for (int i = 0; i <= this.maxUid; ++i) {
            this.umoArray[i] = null;
        }
        this.maxUid = 0;
        this.nbRecords = 0;
    }

    public int getMaxUserId() {
        return this.maxUid;
    }

    private PpUmoDataRecord createUmoRecord(PpUmoDataRecord ppUmoDataRecord) {
        int n = (Integer)ppUmoDataRecord.getField(PpUmoDataRecord.IDX_UID);
        DatabaseChangeEvent databaseChangeEvent = new DatabaseChangeEvent(Database.DatabaseChangeEnum.RECORD_ADDED, n, DatabaseChangeEvent.DatabaseChangeType.PP_UMO);
        if (n < 50001) {
            if (this.umoArray[n] != null) {
                databaseChangeEvent.cause = Database.DatabaseChangeEnum.RECORD_CHANGED;
            }
            this.umoArray[n] = ppUmoDataRecord;
            if (n > this.maxUid) {
                this.maxUid = n;
            }
            this.updateIndex(databaseChangeEvent);
            return this.umoArray[n];
        }
        return null;
    }
}

