/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.OmiHandler;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;
import com.aastra.omilib.PpDataHandler;
import com.aastra.omilib.PpUserDataRecord;
import com.aastra.util.UtilSpy;
import java.util.HashMap;
import java.util.LinkedList;

public class PpUserByNumberHandler
implements OmiManagementEventInterface,
OmiMessageInterface {
    private OmiManagement om = null;
    private OmiHandler omiHandler = null;
    private HashMap<Integer, String> pendingMap = new HashMap();
    private int seqNb = 0;
    private LinkedList<PpUserByNumberNotificationInterface> listenerList = new LinkedList();

    public PpUserByNumberHandler(OmiManagement omiManagement) {
        this.omiHandler = omiManagement.getOmiHandler();
        this.om = omiManagement;
        this.om.registerManagementEventListener(this);
        OmiMessage.elemIds.GetPPUserByNumberResp.registerDataNotificationListener(this);
    }

    public void registerDataNotificationListener(PpUserByNumberNotificationInterface ppUserByNumberNotificationInterface) {
        this.listenerList.add(ppUserByNumberNotificationInterface);
    }

    public void deregisterDataNotificationListener(PpUserByNumberNotificationInterface ppUserByNumberNotificationInterface) {
        this.listenerList.remove(ppUserByNumberNotificationInterface);
    }

    private void GenerateDataNotification(PpUserDataRecord ppUserDataRecord) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating PP user by number notification: No listener");
        }
        for (PpUserByNumberNotificationInterface ppUserByNumberNotificationInterface : this.listenerList) {
            if (ppUserByNumberNotificationInterface == null) continue;
            ppUserByNumberNotificationInterface.processPpUserByNumberNotification(ppUserDataRecord);
        }
    }

    private void GenerateErrorNotification(String string, OmiMessage omiMessage) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating PP user by number error notification: No listener");
        }
        for (PpUserByNumberNotificationInterface ppUserByNumberNotificationInterface : this.listenerList) {
            if (ppUserByNumberNotificationInterface == null) continue;
            ppUserByNumberNotificationInterface.processPpUserByNumberErrorNotification(string, omiMessage);
        }
    }

    public void sendGetPPUserByNumber(String string) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetPPUserByNumber.name());
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), this.seqNb);
        omiMessage.addAttrib(OmiMessage.PPUserType.num.name(), string);
        this.omiHandler.sendOmiMessage(omiMessage);
        this.pendingMap.put(this.seqNb, string);
        if (++this.seqNb > 50001) {
            this.seqNb = 0;
        }
    }

    private void processGetPPUserByNumberResp(OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        int n = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
        String string2 = this.pendingMap.get(n);
        if (string != null) {
            this.GenerateErrorNotification(string2, omiMessage);
        } else {
            OmiMessage omiMessage2 = omiMessage.getSubElement();
            int n2 = Integer.parseInt(omiMessage2.getAttribVal(OmiMessage.PPUserType.uid.name()));
            PpUserDataRecord ppUserDataRecord = new PpUserDataRecord(n2);
            PpDataHandler.setUserAttribsFromMsg(ppUserDataRecord, omiMessage2);
            this.GenerateDataNotification(ppUserDataRecord);
        }
    }

    @Override
    public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
        this.pendingMap.clear();
        this.seqNb = 0;
    }

    @Override
    public void processOmiMessage(OmiMessage omiMessage) {
        switch (omiMessage.id) {
            case GetPPUserByNumberResp: {
                this.processGetPPUserByNumberResp(omiMessage);
                break;
            }
        }
    }

    public static interface PpUserByNumberNotificationInterface {
        public void processPpUserByNumberNotification(PpUserDataRecord var1);

        public void processPpUserByNumberErrorNotification(String var1, OmiMessage var2);
    }
}

