/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.SummaryHandler;
import com.aastra.util.UtilSpy;
import java.util.LinkedList;

public class PpUserSummaryHandler
extends SummaryHandler {
    private PpUserSummaryClass summary = null;
    private LinkedList<PpUserSummaryNotificationInterface> listenerList = new LinkedList();

    public void registerPpUserSummaryNotificationListener(PpUserSummaryNotificationInterface ppUserSummaryNotificationInterface) {
        this.listenerList.add(ppUserSummaryNotificationInterface);
    }

    public void deregisterPpUserSummaryNotificationListener(PpUserSummaryNotificationInterface ppUserSummaryNotificationInterface) {
        this.listenerList.remove(ppUserSummaryNotificationInterface);
    }

    @Override
    protected void GenerateSummaryNotification() {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating pp user summary notification: No listener");
        }
        PpUserSummaryClass ppUserSummaryClass = this.summary.clone();
        for (PpUserSummaryNotificationInterface ppUserSummaryNotificationInterface : this.listenerList) {
            if (ppUserSummaryNotificationInterface == null) continue;
            ppUserSummaryNotificationInterface.processPpUserSummaryNotification(ppUserSummaryClass);
        }
    }

    @Override
    protected void GenerateSummaryErrorNotification(OmiMessage omiMessage) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating pp user summary error notification: No listener");
        }
        for (PpUserSummaryNotificationInterface ppUserSummaryNotificationInterface : this.listenerList) {
            if (ppUserSummaryNotificationInterface == null) continue;
            ppUserSummaryNotificationInterface.processPpUserSummaryErrorNotification(omiMessage);
        }
    }

    public PpUserSummaryHandler(OmiManagement omiManagement) {
        super(omiManagement, OmiMessage.elemIds.GetPPUserSummary, OmiMessage.elemIds.GetPPUserSummaryResp, OmiMessage.elemIds.EventPPUserSummary, OmiMessage.EventType.PPUserSummary);
    }

    public PpUserSummaryClass getSummary() {
        if (this.summary == null) {
            this.summary = new PpUserSummaryClass();
        }
        return this.summary.clone();
    }

    @Override
    protected void initSummary() {
        if (this.summary == null) {
            this.summary = new PpUserSummaryClass();
        } else {
            this.summary.clear();
        }
        this.GenerateSummaryNotification();
    }

    @Override
    protected boolean processSummary(OmiMessage omiMessage) {
        int n;
        boolean bl = false;
        if (omiMessage.getAttribVal(OmiMessage.PPUserSummaryType.nRecords.name()) != null && this.summary.nRecords != (n = omiMessage.getAttribValInt(OmiMessage.PPUserSummaryType.nRecords.name()))) {
            this.summary.nRecords = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.PPUserSummaryType.uidFirst.name()) != null && this.summary.uidFirst != (n = omiMessage.getAttribValInt(OmiMessage.PPUserSummaryType.uidFirst.name()))) {
            this.summary.uidFirst = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.PPUserSummaryType.nSipRegistration.name()) != null && this.summary.nSipRegistration != (n = omiMessage.getAttribValInt(OmiMessage.PPUserSummaryType.nSipRegistration.name()))) {
            this.summary.nSipRegistration = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.PPUserSummaryType.nLocatable.name()) != null && this.summary.nLocatable != (n = omiMessage.getAttribValInt(OmiMessage.PPUserSummaryType.nLocatable.name()))) {
            this.summary.nLocatable = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.PPUserSummaryType.nBtLocatable.name()) != null && this.summary.nBtLocatable != (n = omiMessage.getAttribValInt(OmiMessage.PPUserSummaryType.nBtLocatable.name()))) {
            this.summary.nBtLocatable = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.PPUserSummaryType.nMsgSend.name()) != null && this.summary.nMsgSend != (n = omiMessage.getAttribValInt(OmiMessage.PPUserSummaryType.nMsgSend.name()))) {
            this.summary.nMsgSend = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.PPUserSummaryType.usersActiveMonitored.name()) != null && this.summary.nMonitoringModeActive != (n = omiMessage.getAttribValInt(OmiMessage.PPUserSummaryType.usersActiveMonitored.name()))) {
            this.summary.nMonitoringModeActive = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.PPUserSummaryType.usersPassiveMonitored.name()) != null && this.summary.nMonitoringModePassive != (n = omiMessage.getAttribValInt(OmiMessage.PPUserSummaryType.usersPassiveMonitored.name()))) {
            this.summary.nMonitoringModePassive = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.PPUserSummaryType.usersWarned.name()) != null && this.summary.nMonitoringStateWarning != (n = omiMessage.getAttribValInt(OmiMessage.PPUserSummaryType.usersWarned.name()))) {
            this.summary.nMonitoringStateWarning = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.PPUserSummaryType.usersUnavailable.name()) != null && this.summary.nMonitoringStateUnavailable != (n = omiMessage.getAttribValInt(OmiMessage.PPUserSummaryType.usersUnavailable.name()))) {
            this.summary.nMonitoringStateUnavailable = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.PPUserSummaryType.usersEscalated.name()) != null && this.summary.nMonitoringStateEscalated != (n = omiMessage.getAttribValInt(OmiMessage.PPUserSummaryType.usersEscalated.name()))) {
            this.summary.nMonitoringStateEscalated = n;
            bl = true;
        }
        return bl;
    }

    public static interface PpUserSummaryNotificationInterface {
        public void processPpUserSummaryNotification(PpUserSummaryClass var1);

        public void processPpUserSummaryErrorNotification(OmiMessage var1);
    }

    public static class PpUserSummaryClass {
        public int nRecords = 0;
        public int uidFirst = 0;
        public int nSipRegistration = 0;
        public int nLocatable = 0;
        public int nBtLocatable = 0;
        public int nMsgSend = 0;
        public int nMonitoringModeActive = 0;
        public int nMonitoringModePassive = 0;
        public int nMonitoringStateWarning = 0;
        public int nMonitoringStateUnavailable = 0;
        public int nMonitoringStateEscalated = 0;

        public void clear() {
            this.nRecords = 0;
            this.uidFirst = 0;
            this.nSipRegistration = 0;
            this.nLocatable = 0;
            this.nBtLocatable = 0;
            this.nMsgSend = 0;
            this.nMonitoringModeActive = 0;
            this.nMonitoringModePassive = 0;
            this.nMonitoringStateWarning = 0;
            this.nMonitoringStateUnavailable = 0;
            this.nMonitoringStateEscalated = 0;
        }

        public PpUserSummaryClass clone() {
            PpUserSummaryClass ppUserSummaryClass = new PpUserSummaryClass();
            ppUserSummaryClass.nRecords = this.nRecords;
            ppUserSummaryClass.uidFirst = this.uidFirst;
            ppUserSummaryClass.nSipRegistration = this.nSipRegistration;
            ppUserSummaryClass.nLocatable = this.nLocatable;
            ppUserSummaryClass.nBtLocatable = this.nBtLocatable;
            ppUserSummaryClass.nMsgSend = this.nMsgSend;
            ppUserSummaryClass.nMonitoringModeActive = this.nMonitoringModeActive;
            ppUserSummaryClass.nMonitoringModePassive = this.nMonitoringModePassive;
            ppUserSummaryClass.nMonitoringStateWarning = this.nMonitoringStateWarning;
            ppUserSummaryClass.nMonitoringStateUnavailable = this.nMonitoringStateUnavailable;
            ppUserSummaryClass.nMonitoringStateEscalated = this.nMonitoringStateEscalated;
            return ppUserSummaryClass;
        }
    }
}

