/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.DataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.OmiHandler;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;
import com.aastra.omilib.RfpDataNotificationInterface;
import com.aastra.omilib.RfpDataRecord;
import com.aastra.omilib.RfpDatabase;
import com.aastra.omilib.SiteDataHandler;
import com.aastra.util.UtilSpy;
import java.util.LinkedList;

public class RfpDataHandler
extends DataHandler
implements OmiMessageInterface,
OmiManagementEventInterface {
    private OmiHandler omiHandler = null;
    private RfpDatabase rfpDb = new RfpDatabase();
    private LinkedList<RfpDataNotificationInterface> listenerList = new LinkedList();
    private boolean getBulkInProgress = false;
    private boolean ppBulkReady = false;
    private boolean sitesComplete = false;
    private SiteDataHandler siteHandler = null;
    private boolean encryptionEnabled = false;
    private RfpDataRecord[] bulkModifyRfps = null;
    private static final int MAX_SEQ_NUM = RfpDatabase.maxRfp + 1;
    private Transaction[] transArr = new Transaction[MAX_SEQ_NUM];
    private int nextSequenceNumber = 0;

    private int getNewSequenceNumber() {
        int n = this.nextSequenceNumber++;
        if (this.nextSequenceNumber >= MAX_SEQ_NUM) {
            this.nextSequenceNumber = 0;
        }
        return n;
    }

    public RfpDataHandler(OmiManagement omiManagement) {
        this.omiHandler = omiManagement.getOmiHandler();
        omiManagement.registerManagementEventListener(this);
        this.initialize();
    }

    public RfpDataHandler(OmiManagement omiManagement, SiteDataHandler siteDataHandler) {
        this.omiHandler = omiManagement.getOmiHandler();
        omiManagement.registerManagementEventListener(this);
        this.siteHandler = siteDataHandler;
        if (this.siteHandler != null) {
            this.siteHandler.setRfpDataHandler(this);
        }
        this.initialize();
    }

    private void initialize() {
        OmiMessage.elemIds.GetRFPResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.CreateRFPResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.DeleteRFPResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetRFPResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventRFPCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventRFPState.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventRFPDetails.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetDECTEncryptionResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventDECTEncryptionCnf.registerDataNotificationListener(this);
    }

    public void registerRfpStatisticListener(OmiMessageInterface omiMessageInterface) {
        OmiMessage.elemIds.GetRFPStatisticConfigResp.registerDataNotificationListener(omiMessageInterface);
        OmiMessage.elemIds.GetRFPStatisticResp.registerDataNotificationListener(omiMessageInterface);
        OmiMessage.elemIds.ResetRFPStatisticResp.registerDataNotificationListener(omiMessageInterface);
    }

    public void deregisterRfpStatisticListener(OmiMessageInterface omiMessageInterface) {
        OmiMessage.elemIds.GetRFPStatisticConfigResp.deregisterDataNotificationListener(omiMessageInterface);
        OmiMessage.elemIds.GetRFPStatisticResp.deregisterDataNotificationListener(omiMessageInterface);
        OmiMessage.elemIds.ResetRFPStatisticResp.deregisterDataNotificationListener(omiMessageInterface);
    }

    public void registerDataNotificationListener(RfpDataNotificationInterface rfpDataNotificationInterface) {
        this.listenerList.add(rfpDataNotificationInterface);
    }

    public void deregisterDataNotificationListener(RfpDataNotificationInterface rfpDataNotificationInterface) {
        this.listenerList.remove(rfpDataNotificationInterface);
    }

    private void GenerateDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating RFP notification: No listener");
        }
        for (RfpDataNotificationInterface rfpDataNotificationInterface : this.listenerList) {
            if (rfpDataNotificationInterface == null) continue;
            rfpDataNotificationInterface.processRfpDataNotification(n, dataNotificationEnum);
        }
    }

    private void GenerateErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating RFP error notification: No listener");
        }
        for (RfpDataNotificationInterface rfpDataNotificationInterface : this.listenerList) {
            if (rfpDataNotificationInterface == null) continue;
            rfpDataNotificationInterface.processRfpErrorNotification(n, dataNotificationEnum, omiMessage);
        }
    }

    public void allSitesReceived() {
        this.sitesComplete = true;
        if (this.ppBulkReady) {
            this.StartFetchingRfpData();
        }
    }

    public void changeSiteName(int n, String string) {
        this.rfpDb.changeSiteName(n, string);
    }

    public RfpDataRecord getRfpData(int n) {
        return this.rfpDb.getRfpByRfpId(n);
    }

    public RfpDataRecord getRfpDataByIdx(int n) {
        return this.rfpDb.getRecordByIdx(n);
    }

    public RfpDatabase getDatabase() {
        return this.rfpDb;
    }

    private void sendRfpBulkReq(int n, int n2, boolean bl, boolean bl2) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetRFP);
        omiMessage.addAttrib(OmiMessage.attribIds.id.name(), n);
        omiMessage.addAttrib(OmiMessage.attribIds.maxRecords.name(), n2);
        omiMessage.addAttrib(OmiMessage.attribIds.withState.name(), bl);
        omiMessage.addAttrib(OmiMessage.attribIds.withDetails.name(), bl2);
        this.omiHandler.sendOmiMessage(omiMessage);
        this.getBulkInProgress = true;
    }

    public boolean sendRfpReq(int n, boolean bl, boolean bl2) {
        if (!this.getBulkInProgress) {
            OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetRFP);
            omiMessage.addAttrib(OmiMessage.attribIds.id.name(), n);
            omiMessage.addAttrib(OmiMessage.attribIds.withState.name(), bl);
            omiMessage.addAttrib(OmiMessage.attribIds.withDetails.name(), bl2);
            this.omiHandler.sendOmiMessage(omiMessage);
            return true;
        }
        return false;
    }

    public int sendCreateRfp(RfpDataRecord rfpDataRecord) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.CreateRFP);
        int n = this.getNewSequenceNumber();
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), n);
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.rfp);
        rfpDataRecord.addChangedAttribsToMsg(omiMessage2);
        this.transArr[n] = new Transaction(n, actionEnum.ACTION_CREATE_RFP, rfpDataRecord);
        this.omiHandler.sendOmiMessage(omiMessage);
        return n;
    }

    public void sendDeleteRfp(int n) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.DeleteRFP);
        int n2 = this.getNewSequenceNumber();
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), n2);
        omiMessage.addAttrib(OmiMessage.RFPType.id.name(), n);
        this.transArr[n2] = new Transaction(n2, actionEnum.ACTION_DELETE_RFP, n);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public boolean sendSetRfp(RfpDataRecord rfpDataRecord) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.SetRFP);
        int n = this.getNewSequenceNumber();
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), n);
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.rfp);
        if (rfpDataRecord.addChangedAttribsToMsg(omiMessage2) > 0) {
            this.transArr[n] = new Transaction(n, actionEnum.ACTION_SET_RFP, rfpDataRecord);
            this.omiHandler.sendOmiMessage(omiMessage);
            return true;
        }
        return false;
    }

    public boolean sendChangeDeleteRfps(DataHandler.SendBulkActionType sendBulkActionType, RfpDataRecord[] rfpDataRecordArray, DataHandler.DataHandlerSendBulkInterface dataHandlerSendBulkInterface) {
        if (rfpDataRecordArray == null || rfpDataRecordArray.length == 0) {
            return false;
        }
        this.bulkModifyRfps = (RfpDataRecord[])rfpDataRecordArray.clone();
        return this.startSendBulk(sendBulkActionType, this.bulkModifyRfps.length, dataHandlerSendBulkInterface);
    }

    public void cancelChangeDeleteRfps() {
        this.stopSendBulk();
    }

    @Override
    protected void sendNextCreate(int n) {
        this.sendCreateRfp(this.bulkModifyRfps[n]);
    }

    @Override
    protected void sendNextChange(int n) {
        this.sendSetRfp(this.bulkModifyRfps[n]);
    }

    @Override
    protected void sendNextDelete(int n) {
        this.sendDeleteRfp((Integer)this.bulkModifyRfps[n].getField(RfpDataRecord.IDX_RFP_ID));
    }

    public void sendGetRFPStatisticConfig() {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetRFPStatisticConfig);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendGetRFPStatistic(int n, int n2, int n3) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetRFPStatistic);
        omiMessage.addAttrib(OmiMessage.attribIds.id.name(), n);
        omiMessage.addAttrib(OmiMessage.attribIds.maxRecords.name(), n2);
        omiMessage.addAttrib(OmiMessage.attribIds.recordSet.name(), n3);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendGetRFPStatistic(int n, int n2, int n3, int n4) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetRFPStatistic);
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), n);
        omiMessage.addAttrib(OmiMessage.attribIds.id.name(), n2);
        omiMessage.addAttrib(OmiMessage.attribIds.maxRecords.name(), n3);
        omiMessage.addAttrib(OmiMessage.attribIds.recordSet.name(), n4);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendResetRFPStatistic(int n, int n2) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.ResetRFPStatistic);
        omiMessage.addAttrib(OmiMessage.attribIds.id.name(), n);
        omiMessage.addAttrib(OmiMessage.attribIds.elemId.name(), n2);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendResetRFPStatistic(int n, int n2, int n3) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.ResetRFPStatistic);
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), n);
        omiMessage.addAttrib(OmiMessage.attribIds.id.name(), n2);
        omiMessage.addAttrib(OmiMessage.attribIds.elemId.name(), n3);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void SendGetRfpSync(int n) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetRFPSync);
        omiMessage.addAttrib(OmiMessage.attribIds.id.name(), n);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void registerSyncMsgListener(OmiMessageInterface omiMessageInterface) {
        OmiMessage.elemIds.GetRFPSyncResp.registerDataNotificationListener(omiMessageInterface);
        OmiMessage.elemIds.EventRFPSync.registerDataNotificationListener(omiMessageInterface);
        OmiMessage.elemIds.EventRFPSyncRel.registerDataNotificationListener(omiMessageInterface);
    }

    public void setRfpPosition(int n, int n2, int n3) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.SetRFP);
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.rfp);
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), -1);
        omiMessage2.addAttrib(OmiMessage.RFPType.id.name(), n);
        omiMessage2.addAttrib(OmiMessage.RFPType.x.name(), n2);
        omiMessage2.addAttrib(OmiMessage.RFPType.y.name(), n3);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void setInternalAttrib(int n, int n2, Object object) {
        RfpDataRecord rfpDataRecord = this.rfpDb.getRfpByRfpId(n);
        if (rfpDataRecord != null) {
            Object object2 = rfpDataRecord.getField(n2);
            if (object2 != null && object2.equals(object)) {
                return;
            }
            rfpDataRecord.setField(n2, object);
            rfpDataRecord.commitChanges();
            this.rfpDb.createRfp(rfpDataRecord);
        }
    }

    public void subscribeForSyncRelation(int n) {
        OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.RFPSync, OmiMessage.EventFilterItems.rfpId, "" + n);
    }

    public void unsubscribeForSyncRelation(int n) {
        OmiMessage.sendResetEventSubscription(this.omiHandler, OmiMessage.EventType.RFPSync, OmiMessage.EventFilterItems.rfpId, "" + n);
    }

    private void setAttribsFromMsg(boolean bl, RfpDataRecord rfpDataRecord, OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.RFPType.rpn.name());
        if (string != null) {
            this.rfpDb.resetRpnEntry((Integer)rfpDataRecord.getField(RfpDataRecord.IDX_RFP_ID));
        }
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = omiMessage.getFirstAttribName();
        while (string2 != null) {
            try {
                Object object;
                if (string2.equals(OmiMessage.RFPType.hwType.name())) {
                    object = OmiMessage.RFPHwTypeType.getTypeFromStrRealHw(omiMessage.getAttribVal(string2));
                    rfpDataRecord.setField(string2, object);
                } else if (string2.equals(OmiMessage.RFPType.syncState.name())) {
                    rfpDataRecord.setField(string2, (Object)OmiMessage.RFPSyncStateType.valueOf(omiMessage.getAttribVal(string2)));
                } else if (string2.equals(OmiMessage.RFPType.radioType.name())) {
                    rfpDataRecord.setField(string2, (Object)OmiMessage.RFPRadioTypeType.valueOf(omiMessage.getAttribVal(string2)));
                } else if (string2.equals(OmiMessage.RFPType.wlanHighThroughputTypeUsed.name())) {
                    rfpDataRecord.setField(string2, (Object)OmiMessage.RFPWlanHTUsedType.valueOf(omiMessage.getAttribVal(string2)));
                } else {
                    rfpDataRecord.setField(string2, (Object)omiMessage.getAttribVal(string2));
                    if (string2.equals(OmiMessage.RFPType.site.name())) {
                        if (this.siteHandler != null) {
                            object = this.siteHandler.getSiteBySiteId((Integer)rfpDataRecord.getField(RfpDataRecord.IDX_SITE));
                            if (object != null) {
                                rfpDataRecord.setField(RfpDataRecord.IDX_SITE_TEXT, (Object)((SiteDataHandler.Site)object).name);
                            }
                            bl3 = true;
                        }
                    } else if (string2.equals(OmiMessage.RFPType.hasEncryption.name())) {
                        bl2 = true;
                    } else if (string2.equals(OmiMessage.RFPType.hasAdvancedFeatures.name())) {
                        bl3 = true;
                    } else if (string2.equals(OmiMessage.RFPType.connected.name())) {
                        bl2 = true;
                        bl3 = true;
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            string2 = omiMessage.getNextAttribName();
        }
        if (((Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_HWTYPE_LOCKED)).booleanValue()) {
            rfpDataRecord.setField(RfpDataRecord.IDX_HWTYPE_TEXT, (Object)((OmiMessage.RFPHwTypeType)((Object)rfpDataRecord.getField((int)RfpDataRecord.IDX_HWTYPE))).strRealHw);
        } else {
            rfpDataRecord.setField(RfpDataRecord.IDX_HWTYPE_TEXT, (Object)((OmiMessage.RFPHwTypeType)((Object)rfpDataRecord.getField((int)RfpDataRecord.IDX_HWTYPE))).strPreselect);
        }
        if (bl2) {
            this.setRfpEncryptionState(rfpDataRecord);
        }
        if (bl3) {
            this.setRfpAdvancedFeaturesState(rfpDataRecord);
        }
        if (bl) {
            rfpDataRecord.commitChanges();
        }
    }

    private void handleEventRfp(OmiMessage omiMessage) {
        for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
            if (omiMessage2.id != OmiMessage.elemIds.rfp) continue;
            int n = Integer.parseInt(omiMessage2.getAttribVal(OmiMessage.RFPType.id.name()));
            RfpDataRecord rfpDataRecord = this.rfpDb.getRfpByRfpId(n);
            String string = omiMessage2.getAttribVal(OmiMessage.attribIds.deleted.name());
            if (rfpDataRecord != null) {
                if (string != null) {
                    this.rfpDb.deleteRfp(n);
                    this.GenerateDataNotification(n, DataNotificationEnum.DATA_DELETED);
                    continue;
                }
                this.setAttribsFromMsg(false, rfpDataRecord, omiMessage2);
                if (!rfpDataRecord.getRecordChanged()) continue;
                this.rfpDb.createRfp(rfpDataRecord);
                this.GenerateDataNotification(n, DataNotificationEnum.DATA_RFP_CHANGED_CNF);
                rfpDataRecord.commitChanges();
                continue;
            }
            if (omiMessage.id != OmiMessage.elemIds.EventRFPCnf || string != null) continue;
            rfpDataRecord = new RfpDataRecord(n);
            this.setAttribsFromMsg(true, rfpDataRecord, omiMessage2);
            this.rfpDb.createRfp(rfpDataRecord);
            this.GenerateDataNotification(n, DataNotificationEnum.NEW_DATA);
        }
    }

    private int processBulkResp(OmiMessage omiMessage) {
        int n = 0;
        for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
            if (omiMessage2.id == OmiMessage.elemIds.rfp) {
                n = Integer.parseInt(omiMessage2.getAttribVal(OmiMessage.RFPType.id.name()));
                RfpDataRecord rfpDataRecord = this.rfpDb.getRfpByRfpId(n);
                if (rfpDataRecord == null) {
                    rfpDataRecord = new RfpDataRecord(n);
                }
                this.setAttribsFromMsg(true, rfpDataRecord, omiMessage2);
                this.rfpDb.createRfp(rfpDataRecord);
                this.GenerateDataNotification(n, DataNotificationEnum.NEW_DATA);
                continue;
            }
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "RFP notification with wrong element id=" + (Object)((Object)omiMessage2.id));
        }
        return n;
    }

    private void StartFetchingRfpData() {
        OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.RFPCnf, OmiMessage.EventFilterItems.rfpId, "-1");
        OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.RFPState, OmiMessage.EventFilterItems.rfpId, "-1");
        OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.RFPDetails, OmiMessage.EventFilterItems.rfpId, "-1");
        this.sendRfpBulkReq(0, 16, true, true);
    }

    @Override
    public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
        switch (omiManagementEventEnum) {
            case LINK_READY: {
                this.ppBulkReady = false;
                this.sitesComplete = false;
                this.rfpDb.clearAll();
                this.GenerateDataNotification(0, DataNotificationEnum.DATA_DELETED_ALL);
                break;
            }
            case PP_BULK_READY: {
                this.ppBulkReady = true;
                if (this.siteHandler == null) {
                    this.StartFetchingRfpData();
                    break;
                }
                if (!this.sitesComplete) break;
                this.StartFetchingRfpData();
                break;
            }
        }
    }

    @Override
    public void processOmiMessage(OmiMessage omiMessage) {
        int n = -1;
        Transaction transaction = null;
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.seq.name());
        if (string != null && (n = Integer.parseInt(string)) >= 0 && n < MAX_SEQ_NUM) {
            transaction = this.transArr[n];
        }
        switch (omiMessage.id) {
            case GetRFPResp: {
                if (this.getBulkInProgress) {
                    int n2 = this.processBulkResp(omiMessage);
                    if (n2 > 0) {
                        this.sendRfpBulkReq(n2 + 1, 16, true, true);
                        break;
                    }
                    this.getBulkInProgress = false;
                    this.GenerateDataNotification(this.rfpDb.getRecordNumber(), DataNotificationEnum.DATA_BULK_READY);
                    break;
                }
                this.processBulkResp(omiMessage);
                break;
            }
            case CreateRFPResp: {
                if (transaction == null) break;
                this.checkSendBulk();
                String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string2 != null) {
                    this.GenerateErrorNotification(-1, DataNotificationEnum.CREATE_RFP, omiMessage);
                    break;
                }
                OmiMessage omiMessage2 = omiMessage.getSubElement();
                RfpDataRecord rfpDataRecord = (RfpDataRecord)transaction.object;
                int n3 = Integer.parseInt(omiMessage2.getAttribVal(OmiMessage.RFPType.id.name()));
                rfpDataRecord.setField(RfpDataRecord.IDX_RFP_ID, (Object)("" + n3));
                this.setAttribsFromMsg(true, rfpDataRecord, omiMessage2);
                this.rfpDb.createRfp(rfpDataRecord);
                this.GenerateDataNotification(n3, DataNotificationEnum.NEW_DATA);
                break;
            }
            case DeleteRFPResp: {
                if (transaction == null) break;
                this.checkSendBulk();
                String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                int n4 = (Integer)transaction.object;
                if (string3 != null) {
                    this.GenerateErrorNotification(n4, DataNotificationEnum.DATA_DELETED, omiMessage);
                    break;
                }
                this.rfpDb.deleteRfp(n4);
                this.GenerateDataNotification(n4, DataNotificationEnum.DATA_DELETED);
                break;
            }
            case SetRFPResp: {
                if (transaction == null) break;
                this.checkSendBulk();
                String string4 = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string4 != null) {
                    RfpDataRecord rfpDataRecord = (RfpDataRecord)transaction.object;
                    this.GenerateErrorNotification((Integer)rfpDataRecord.getField(RfpDataRecord.IDX_RFP_ID), DataNotificationEnum.DATA_CHANGED, omiMessage);
                    break;
                }
                RfpDataRecord rfpDataRecord = (RfpDataRecord)transaction.object;
                OmiMessage omiMessage3 = omiMessage.getSubElement();
                this.setAttribsFromMsg(true, rfpDataRecord, omiMessage3);
                this.rfpDb.createRfp(rfpDataRecord);
                this.GenerateDataNotification((Integer)rfpDataRecord.getField(RfpDataRecord.IDX_RFP_ID), DataNotificationEnum.DATA_RFP_CHANGED_RESP);
                break;
            }
            case EventRFPState: 
            case EventRFPCnf: 
            case EventRFPDetails: {
                this.handleEventRfp(omiMessage);
                break;
            }
            case GetDECTEncryptionResp: 
            case EventDECTEncryptionCnf: {
                this.encryptionEnabled = omiMessage.getAttribValBool(OmiMessage.attribIds.enable.name());
                this.setEncryptionStateAll();
                break;
            }
        }
        if (transaction != null) {
            this.transArr[n] = null;
        }
    }

    private void setEncryptionStateAll() {
        RfpDataRecord rfpDataRecord = null;
        int n = this.rfpDb.getRecordNumber();
        for (int i = 0; i < RfpDatabase.maxRfp && n > 0; ++i) {
            rfpDataRecord = this.rfpDb.getRecordByIdx(i);
            if (rfpDataRecord == null) continue;
            this.setRfpEncryptionState(rfpDataRecord);
            rfpDataRecord.commitChanges();
            this.GenerateDataNotification((Integer)rfpDataRecord.getField(RfpDataRecord.IDX_RFP_ID), DataNotificationEnum.DATA_CHANGED);
            --n;
        }
    }

    private void setRfpEncryptionState(RfpDataRecord rfpDataRecord) {
        OmiMessage.RfpCapabilityStateType rfpCapabilityStateType = this.encryptionEnabled && ((Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_CONNECTED)).booleanValue() ? (((Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_HAS_ENCRYPTION)).booleanValue() ? OmiMessage.RfpCapabilityStateType.SupportedActive : OmiMessage.RfpCapabilityStateType.NotSupportedError) : ((Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_HAS_ENCRYPTION) != false ? OmiMessage.RfpCapabilityStateType.SupportedInactive : OmiMessage.RfpCapabilityStateType.NotSupportedInactive);
        rfpDataRecord.setField(RfpDataRecord.IDX_ENCRYPTION_STATE, (Object)rfpCapabilityStateType);
    }

    protected void updateSiteAdvancedFeaturesState(SiteDataHandler.Site site) {
        RfpDataRecord rfpDataRecord = null;
        int n = this.rfpDb.getRecordNumber();
        for (int i = 0; i < RfpDatabase.maxRfp && n > 0; ++i) {
            rfpDataRecord = this.rfpDb.getRecordByIdx(i);
            if (rfpDataRecord == null) continue;
            if ((Integer)rfpDataRecord.getField(RfpDataRecord.IDX_SITE) == site.id) {
                this.setRfpAdvancedFeaturesState(rfpDataRecord);
                rfpDataRecord.commitChanges();
                this.GenerateDataNotification((Integer)rfpDataRecord.getField(RfpDataRecord.IDX_RFP_ID), DataNotificationEnum.DATA_CHANGED);
            }
            --n;
        }
    }

    private void setRfpAdvancedFeaturesState(RfpDataRecord rfpDataRecord) {
        if (this.siteHandler != null) {
            OmiMessage.RfpCapabilityStateType rfpCapabilityStateType = this.siteHandler.getAdvancedFeaturesActive((Integer)rfpDataRecord.getField(RfpDataRecord.IDX_SITE)) && ((Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_CONNECTED)).booleanValue() ? (((Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_HAS_ADVANCED_FEAT)).booleanValue() ? OmiMessage.RfpCapabilityStateType.SupportedActive : OmiMessage.RfpCapabilityStateType.NotSupportedError) : ((Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_HAS_ADVANCED_FEAT) != false ? OmiMessage.RfpCapabilityStateType.SupportedInactive : OmiMessage.RfpCapabilityStateType.NotSupportedInactive);
            rfpDataRecord.setField(RfpDataRecord.IDX_ADVANCED_FEATURES_STATE, (Object)rfpCapabilityStateType);
        }
    }

    private class Transaction {
        public Object object = null;

        public Transaction(int n, actionEnum actionEnum2, Object object) {
            this.object = object;
        }
    }

    public static enum actionEnum {
        ACTION_CREATE_RFP,
        ACTION_SET_RFP,
        ACTION_DELETE_RFP,
        ACTION_RFP_BULK_REQ,
        ACTION_GET_RFP;

    }
}

