/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.Database;
import com.aastra.omilib.DatabaseChangeEvent;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.RfpDataRecord;
import java.util.HashSet;

public class RfpDatabase
extends Database {
    public static final int MAX_RFP = 4096;
    public static int maxRfp = 4096;
    private RfpDataRecord[] rfpArray = new RfpDataRecord[maxRfp];
    private int[] rfpIdxArray = new int[maxRfp];
    private int[] rpnIdxArray = new int[maxRfp];
    private int AnzRecords = 0;
    private int maxRfpId = 0;
    private HashSet<Integer> filterRfp = new HashSet();

    public RfpDatabase() {
        for (int i = 0; i < maxRfp; ++i) {
            this.rpnIdxArray[i] = -1;
        }
    }

    public RfpDataRecord getRfpByRfpId(int n) {
        if (n < 0 || n >= maxRfp) {
            return null;
        }
        return this.rfpArray[n];
    }

    public RfpDataRecord getRfpByRpn(int n) {
        if (n >= 0 && n < maxRfp) {
            int n2 = this.rpnIdxArray[n];
            if (n2 == -1) {
                return null;
            }
            return this.rfpArray[n2];
        }
        return null;
    }

    @Override
    public RfpDataRecord getRecordByIdx(int n) {
        if (n >= 0 && n < this.AnzRecords && this.rfpArray[this.rfpIdxArray[n]] != null) {
            return this.rfpArray[this.rfpIdxArray[n]];
        }
        return null;
    }

    public void resetRpnEntry(int n) {
        if (n < 0 || n >= maxRfp) {
            return;
        }
        RfpDataRecord rfpDataRecord = this.rfpArray[n];
        if (rfpDataRecord != null) {
            Integer n2 = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_RPN);
            Integer n3 = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_PAGING_AREA);
            if (n2 != null && n3 != null && n2 >= 0 && n2 < maxRfp && n3 != -1) {
                this.rpnIdxArray[n2.intValue()] = -1;
            }
        }
    }

    public RfpDataRecord createRfp(RfpDataRecord rfpDataRecord) {
        int n = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_RFP_ID);
        DatabaseChangeEvent databaseChangeEvent = new DatabaseChangeEvent(Database.DatabaseChangeEnum.RECORD_ADDED, n, DatabaseChangeEvent.DatabaseChangeType.RFP);
        if (n >= 0 && n < maxRfp) {
            if (n > this.maxRfpId) {
                this.maxRfpId = n;
            }
            if (this.rfpArray[n] != null) {
                databaseChangeEvent.cause = Database.DatabaseChangeEnum.RECORD_CHANGED;
            }
            this.rfpArray[n] = rfpDataRecord;
            Integer n2 = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_RPN);
            if (n2 != null && n2 >= 0 && n2 < maxRfp) {
                this.rpnIdxArray[n2.intValue()] = -1;
                Integer n3 = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_PAGING_AREA);
                if (n3 != null && n3 != -1) {
                    this.rpnIdxArray[n2.intValue()] = n;
                }
            }
            this.updateIndex(databaseChangeEvent);
            return this.rfpArray[n];
        }
        return null;
    }

    public void deleteRfp(int n) {
        if (n < 0 || n >= maxRfp) {
            return;
        }
        if (this.rfpArray[n] != null) {
            this.resetRpnEntry(n);
            this.rfpArray[n].deleted = true;
        }
        DatabaseChangeEvent databaseChangeEvent = new DatabaseChangeEvent(Database.DatabaseChangeEnum.RECORD_DELETED, n, DatabaseChangeEvent.DatabaseChangeType.RFP);
        this.updateIndex(databaseChangeEvent);
    }

    @Override
    public void updateIndex() {
        this.updateIndex(new DatabaseChangeEvent(Database.DatabaseChangeEnum.INDEX_UPDATE, 0, DatabaseChangeEvent.DatabaseChangeType.RFP));
    }

    public void updateIndex(DatabaseChangeEvent databaseChangeEvent) {
        int n = -1;
        this.AnzRecords = 0;
        for (int i = 0; i <= this.maxRfpId; ++i) {
            if (this.rfpArray[i] == null) continue;
            if (this.rfpArray[i].deleted) {
                this.rfpArray[i] = null;
                continue;
            }
            if (this.getFilterActive()) {
                if (this.filterMatch(this.rfpArray[i])) {
                    if (i == databaseChangeEvent.recordId) {
                        n = this.AnzRecords;
                    }
                    this.rfpIdxArray[this.AnzRecords++] = i;
                    if (this.filterRfp.contains(i)) continue;
                    this.filterRfp.add(i);
                    if (i != databaseChangeEvent.recordId || databaseChangeEvent.cause != Database.DatabaseChangeEnum.RECORD_CHANGED) continue;
                    databaseChangeEvent.cause = Database.DatabaseChangeEnum.RECORD_ADDED;
                    continue;
                }
                if (!this.filterRfp.contains(i)) continue;
                this.filterRfp.remove(i);
                if (i != databaseChangeEvent.recordId || databaseChangeEvent.cause != Database.DatabaseChangeEnum.RECORD_CHANGED) continue;
                databaseChangeEvent.cause = Database.DatabaseChangeEnum.RECORD_DELETED;
                continue;
            }
            if (i == databaseChangeEvent.recordId) {
                n = this.AnzRecords;
            }
            this.rfpIdxArray[this.AnzRecords++] = i;
            if (this.filterRfp.isEmpty()) continue;
            this.filterRfp.clear();
        }
        if (n != -1) {
            databaseChangeEvent.modelId = n;
        }
        if (databaseChangeEvent.cause != Database.DatabaseChangeEnum.RECORD_CHANGED || databaseChangeEvent.modelId != -1) {
            this.generateChangeNotification(databaseChangeEvent);
        }
    }

    @Override
    public int getRecordNumber() {
        return this.AnzRecords;
    }

    @Override
    public String[] getFieldNames() {
        return RfpDataRecord.getFieldNames();
    }

    public void clearAll() {
        for (int i = 0; i <= this.maxRfpId; ++i) {
            this.rfpArray[i] = null;
        }
        this.maxRfpId = 0;
        this.AnzRecords = 0;
        this.updateIndex(new DatabaseChangeEvent(Database.DatabaseChangeEnum.INDEX_UPDATE, 0, DatabaseChangeEvent.DatabaseChangeType.RFP));
    }

    public void changeSiteName(int n, String string) {
        for (int i = 0; i <= this.maxRfpId; ++i) {
            int n2;
            if (this.rfpArray[i] == null || (n2 = ((Integer)this.rfpArray[i].getField(RfpDataRecord.IDX_SITE)).intValue()) != n) continue;
            String string2 = (String)this.rfpArray[i].getField(RfpDataRecord.IDX_SITE_TEXT);
            boolean bl = true;
            if (string2 != null && string != null && string2.equals(string)) {
                bl = false;
            }
            if (!bl) continue;
            this.rfpArray[i].setField(RfpDataRecord.IDX_SITE_TEXT, (Object)string);
            this.updateIndex(new DatabaseChangeEvent(Database.DatabaseChangeEnum.RECORD_CHANGED, i, DatabaseChangeEvent.DatabaseChangeType.RFP));
        }
    }

    public int getRFPsNoAdvancedFeaturesInSite(int n) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < maxRfp; ++i) {
            if (this.rfpArray[i] == null) continue;
            if ((Integer)this.rfpArray[i].getField(RfpDataRecord.IDX_SITE) == n && ((Boolean)this.rfpArray[i].getField(RfpDataRecord.IDX_CONNECTED)).booleanValue() && !((Boolean)this.rfpArray[i].getField(RfpDataRecord.IDX_HAS_ADVANCED_FEAT)).booleanValue()) {
                ++n3;
            }
            if (++n2 == this.AnzRecords) break;
        }
        return n3;
    }

    public void updateTransientFields(RfpDataRecord rfpDataRecord) {
        int n = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_RFP_ID);
        RfpDataRecord rfpDataRecord2 = this.getRfpByRfpId(n);
        if (rfpDataRecord2 != null) {
            for (int i = 0; i < OmiMessage.RFPType.values().length; ++i) {
                if (!OmiMessage.RFPType.values()[i].isClassReadOnly() || rfpDataRecord.getField(i).equals(rfpDataRecord2.getField(i))) continue;
                rfpDataRecord.setField(i, rfpDataRecord2.getField(i));
                rfpDataRecord.commitChangeOfField(i);
            }
        }
    }
}

