/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.OmiHandler;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;
import com.aastra.omilib.RfpDataHandler;
import com.aastra.omilib.RfpDataRecord;
import com.aastra.util.UtilSpy;
import java.util.LinkedList;

public class RfpQualityHandler
implements OmiManagementEventInterface,
OmiMessageInterface {
    private static final int MAX_BULK_RECORDS = 20;
    private RfpQualityDatabase rfpQualityDb = new RfpQualityDatabase();
    private RfpQualityDatabase rfpQualityApplicationDb = new RfpQualityDatabase();
    private OmiManagement om = null;
    private OmiHandler omiHandler = null;
    private RfpDataHandler rfpDataHandler = null;
    private boolean getMediaStreamBulkInProgress = false;
    private boolean getIpBulkInProgress = false;
    private boolean getSyncBulkInProgress = false;
    private boolean syncTableModeSnapshot = false;
    private LinkedList<MediaStreamQualityNotificationInterface> mediaStreamListenerList = new LinkedList();

    public void registerMediaStreamQualityNotificationListener(MediaStreamQualityNotificationInterface mediaStreamQualityNotificationInterface) {
        this.mediaStreamListenerList.add(mediaStreamQualityNotificationInterface);
    }

    public void deregisterMediaStreamQualityNotificationListener(MediaStreamQualityNotificationInterface mediaStreamQualityNotificationInterface) {
        this.mediaStreamListenerList.remove(mediaStreamQualityNotificationInterface);
    }

    private void GenerateMediaStreamDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        if (this.mediaStreamListenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating RFP media stream quality notification: No listener");
        }
        for (MediaStreamQualityNotificationInterface mediaStreamQualityNotificationInterface : this.mediaStreamListenerList) {
            if (mediaStreamQualityNotificationInterface == null) continue;
            mediaStreamQualityNotificationInterface.processMediaStreamQualityDataNotification(n, dataNotificationEnum);
        }
    }

    public RfpQualityHandler(OmiManagement omiManagement, RfpDataHandler rfpDataHandler) {
        this.omiHandler = omiManagement.getOmiHandler();
        this.rfpDataHandler = rfpDataHandler;
        this.om = omiManagement;
        this.om.registerManagementEventListener(this);
        OmiMessage.elemIds.GetRFPMediaStreamQualityResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventRFPMediaStreamQuality.registerDataNotificationListener(this);
        OmiMessage.elemIds.ResetRFPMediaStreamQualityResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetRFPIpQualityResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventRFPIpQuality.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetRFPSyncQualityResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventRFPSyncQuality.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetRFPResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventRFPCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventRFPState.registerDataNotificationListener(this);
    }

    public Database getRfpQualityDb() {
        return this.rfpQualityDb;
    }

    public RfpQualityRecord getRecordByRecordId(int n) {
        return this.rfpQualityDb.getRecordById(n);
    }

    public RfpQualityRecord getRecordByTableIdx(int n) {
        return (RfpQualityRecord)this.rfpQualityDb.getRecordByIdx(n);
    }

    public void sendGetRfpMediaStreamQualityRecord(int n) {
        this.sendGetRfpMediaStreamQualityBulk(n, 1);
    }

    public void sendGetRfpMediaStreamQualityBulk(int n, int n2) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetRFPMediaStreamQuality);
        omiMessage.addAttrib(OmiMessage.attribIds.id.name(), n);
        omiMessage.addAttrib(OmiMessage.attribIds.maxRecords.name(), n2);
        this.omiHandler.sendOmiMessage(omiMessage);
        if (n2 > 1) {
            this.getMediaStreamBulkInProgress = true;
        }
    }

    private int processGetRfpMediaStreamQualityResp(OmiMessage omiMessage) {
        RfpQualityRecord rfpQualityRecord;
        int n = 0;
        for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
            if (!this.processRfpMediaStreamQualityElem(omiMessage2, DataNotificationEnum.NEW_DATA)) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "GetRFPMediaStreamQualityResp with no RFP elem");
                continue;
            }
            ++n;
        }
        if (n == 20 && (rfpQualityRecord = (RfpQualityRecord)this.rfpQualityDb.getRecordByIdx(this.rfpQualityDb.getRecordNumber() - 1)) != null) {
            return (Integer)rfpQualityRecord.getField(0);
        }
        return 0;
    }

    private void processEventRfpMediaStreamQuality(OmiMessage omiMessage) {
        for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
            if (this.processRfpMediaStreamQualityElem(omiMessage2, DataNotificationEnum.DATA_CHANGED)) continue;
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "EventRFPMediaStreamQuality with no RFP elem");
        }
    }

    private boolean processRfpMediaStreamQualityElem(OmiMessage omiMessage, DataNotificationEnum dataNotificationEnum) {
        if (omiMessage.id == OmiMessage.elemIds.msQuality) {
            Integer n;
            Integer n2;
            Integer n3;
            Integer n4;
            Integer n5;
            Integer n6;
            Integer n7;
            Integer n8;
            int n9 = omiMessage.getAttribValInt(OmiMessage.RfpQualityType.id.name());
            RfpQualityRecord rfpQualityRecord = this.rfpQualityDb.getRecordById(n9);
            if (rfpQualityRecord == null) {
                rfpQualityRecord = new RfpQualityRecord(n9);
            }
            if ((n8 = Integer.valueOf(omiMessage.getAttribValInt(OmiMessage.RfpQualityType.connects.name()))) != null && rfpQualityRecord.connects != n8) {
                rfpQualityRecord.connects = n8;
            }
            if ((n7 = Integer.valueOf(omiMessage.getAttribValInt(OmiMessage.RfpQualityType.duration.name()))) != null && rfpQualityRecord.duration != n7) {
                rfpQualityRecord.duration = n7;
            }
            if ((n6 = Integer.valueOf(omiMessage.getAttribValInt(OmiMessage.RfpQualityType.packetsRx.name()))) != null && rfpQualityRecord.packetsRx != n6) {
                rfpQualityRecord.packetsRx = n6;
            }
            if ((n5 = Integer.valueOf(omiMessage.getAttribValInt(OmiMessage.RfpQualityType.octetsRx.name()))) != null && rfpQualityRecord.octetsRx != n5) {
                rfpQualityRecord.octetsRx = n5;
            }
            if ((n4 = Integer.valueOf(omiMessage.getAttribValInt(OmiMessage.RfpQualityType.packetsTx.name()))) != null && rfpQualityRecord.packetsTx != n4) {
                rfpQualityRecord.packetsTx = n4;
            }
            if ((n3 = Integer.valueOf(omiMessage.getAttribValInt(OmiMessage.RfpQualityType.octetsTx.name()))) != null && rfpQualityRecord.octetsTx != n3) {
                rfpQualityRecord.octetsTx = n3;
            }
            if ((n2 = Integer.valueOf(omiMessage.getAttribValInt(OmiMessage.RfpQualityType.packetsLost.name()))) != null && rfpQualityRecord.packetsLost != n2) {
                rfpQualityRecord.packetsLost = n2;
            }
            if ((n = Integer.valueOf(omiMessage.getAttribValInt(OmiMessage.RfpQualityType.maxJitter.name()))) != null && rfpQualityRecord.maxJitter != n) {
                rfpQualityRecord.maxJitter = n;
            }
            this.rfpQualityDb.addRecord(rfpQualityRecord);
            return true;
        }
        return false;
    }

    public void sendResetRFPMediaStreamQuality() {
        this.sendResetRFPMediaStreamQuality(-1);
    }

    public void sendResetRFPMediaStreamQuality(int n) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.ResetRFPMediaStreamQuality);
        omiMessage.addAttrib(OmiMessage.attribIds.id.name(), n);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void startRfpMediaStreamQuality() {
        OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.RFPMsQuality, OmiMessage.EventFilterItems.rfpId, "-1");
        this.sendGetRfpMediaStreamQualityBulk(0, 20);
    }

    public void stopRfpMediaStreamQuality() {
        OmiMessage.sendResetEventSubscription(this.omiHandler, OmiMessage.EventType.RFPMsQuality, OmiMessage.EventFilterItems.rfpId, "-1");
        this.rfpQualityDb.clearAll();
    }

    public void sendGetRfpIpQualityRecord(int n) {
        this.sendGetRfpIpQualityBulk(n, 1);
    }

    public void sendGetRfpIpQualityBulk(int n, int n2) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetRFPIpQuality);
        omiMessage.addAttrib(OmiMessage.attribIds.id.name(), n);
        omiMessage.addAttrib(OmiMessage.attribIds.maxRecords.name(), n2);
        this.omiHandler.sendOmiMessage(omiMessage);
        if (n2 > 1) {
            this.getIpBulkInProgress = true;
        }
    }

    private int processGetRfpIpQualityResp(OmiMessage omiMessage) {
        RfpQualityRecord rfpQualityRecord;
        int n = 0;
        for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
            if (!this.processRfpIpQualityElem(omiMessage2, DataNotificationEnum.NEW_DATA)) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "GetRFPIpQualityResp with no RFP elem");
                continue;
            }
            ++n;
        }
        if (n == 20 && (rfpQualityRecord = (RfpQualityRecord)this.rfpQualityDb.getRecordByIdx(this.rfpQualityDb.getRecordNumber() - 1)) != null) {
            return (Integer)rfpQualityRecord.getField(0);
        }
        return 0;
    }

    private void processEventRfpIpQuality(OmiMessage omiMessage) {
        for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
            if (this.processRfpIpQualityElem(omiMessage2, DataNotificationEnum.DATA_CHANGED)) continue;
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "EventRFPIpQuality with no RFP elem");
        }
    }

    private boolean processRfpIpQualityElem(OmiMessage omiMessage, DataNotificationEnum dataNotificationEnum) {
        if (omiMessage.id == OmiMessage.elemIds.ipQuality) {
            Integer n;
            Integer n2;
            Integer n3;
            Integer n4;
            Integer n5;
            Integer n6;
            float f;
            Integer n7;
            float f2;
            Integer n8;
            Integer n9;
            int n10 = omiMessage.getAttribValInt(OmiMessage.RfpQualityType.id.name());
            RfpQualityRecord rfpQualityRecord = this.rfpQualityDb.getRecordById(n10);
            if (rfpQualityRecord == null) {
                rfpQualityRecord = new RfpQualityRecord(n10);
            }
            if ((n9 = Integer.valueOf(omiMessage.getAttribValInt(OmiMessage.RfpQualityType.connectedTime.name()))) != null && rfpQualityRecord.connectedTime != n9) {
                rfpQualityRecord.connectedTime = n9;
            }
            if ((n8 = Integer.valueOf(omiMessage.getAttribValInt(OmiMessage.RfpQualityType.currentRTT.name()))) != null && rfpQualityRecord.currentRTT != (f2 = (float)n8.intValue() / 1000.0f)) {
                rfpQualityRecord.currentRTT = f2;
            }
            if ((n7 = Integer.valueOf(omiMessage.getAttribValInt(OmiMessage.RfpQualityType.maxRTT.name()))) != null && rfpQualityRecord.maxRTT != (f = (float)n7.intValue() / 1000.0f)) {
                rfpQualityRecord.maxRTT = f;
            }
            if ((n6 = Integer.valueOf(omiMessage.getAttribValInt(OmiMessage.RfpQualityType.count.name()))) != null && rfpQualityRecord.count != n6) {
                rfpQualityRecord.count = n6;
            }
            if ((n5 = Integer.valueOf(omiMessage.getAttribValInt(OmiMessage.RfpQualityType.interval1.name()))) != null && rfpQualityRecord.interval1 != n5) {
                rfpQualityRecord.interval1 = n5;
            }
            if ((n4 = Integer.valueOf(omiMessage.getAttribValInt(OmiMessage.RfpQualityType.interval2.name()))) != null && rfpQualityRecord.interval2 != n4) {
                rfpQualityRecord.interval2 = n4;
            }
            if ((n3 = Integer.valueOf(omiMessage.getAttribValInt(OmiMessage.RfpQualityType.interval3.name()))) != null && rfpQualityRecord.interval3 != n3) {
                rfpQualityRecord.interval3 = n3;
            }
            if ((n2 = Integer.valueOf(omiMessage.getAttribValInt(OmiMessage.RfpQualityType.interval4.name()))) != null && rfpQualityRecord.interval4 != n2) {
                rfpQualityRecord.interval4 = n2;
            }
            if ((n = Integer.valueOf(omiMessage.getAttribValInt(OmiMessage.RfpQualityType.interval5.name()))) != null && rfpQualityRecord.interval5 != n) {
                rfpQualityRecord.interval5 = n;
            }
            this.rfpQualityDb.addRecord(rfpQualityRecord);
            return true;
        }
        return false;
    }

    public void startRfpIpQuality() {
        OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.RFPIpQuality, OmiMessage.EventFilterItems.rfpId, "-1");
        this.sendGetRfpIpQualityBulk(0, 20);
    }

    public void stopRfpIpQuality() {
        OmiMessage.sendResetEventSubscription(this.omiHandler, OmiMessage.EventType.RFPIpQuality, OmiMessage.EventFilterItems.rfpId, "-1");
        this.rfpQualityDb.clearAll();
    }

    public void sendGetRfpSyncQualityRecord(int n) {
        this.sendGetRfpSyncQualityBulk(n, 1);
    }

    public void sendGetRfpSyncQualityBulk(int n, int n2) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetRFPSyncQuality);
        omiMessage.addAttrib(OmiMessage.attribIds.id.name(), n);
        omiMessage.addAttrib(OmiMessage.attribIds.maxRecords.name(), n2);
        this.omiHandler.sendOmiMessage(omiMessage);
        if (n2 > 1) {
            this.getSyncBulkInProgress = true;
        }
    }

    private int processGetRfpSyncQualityResp(OmiMessage omiMessage) {
        RfpQualityRecord rfpQualityRecord;
        int n = 0;
        for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
            if (!this.processRfpSyncQualityElem(omiMessage2, DataNotificationEnum.NEW_DATA)) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "GetRFPSyncQualityResp with no RFP elem");
                continue;
            }
            this.sendRfpReqWithState(omiMessage2.getAttribValInt(OmiMessage.RfpQualityType.id.name()));
            ++n;
        }
        if (n == 20 && (rfpQualityRecord = (RfpQualityRecord)this.rfpQualityDb.getRecordByIdx(this.rfpQualityDb.getRecordNumber() - 1)) != null) {
            return (Integer)rfpQualityRecord.getField(0);
        }
        return 0;
    }

    private void processEventRfpSyncQuality(OmiMessage omiMessage) {
        for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
            if (this.processRfpSyncQualityElem(omiMessage2, DataNotificationEnum.DATA_CHANGED)) continue;
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "EventRFPSyncQuality with no RFP elem");
        }
    }

    private boolean processRfpSyncQualityElem(OmiMessage omiMessage, DataNotificationEnum dataNotificationEnum) {
        if (omiMessage.id == OmiMessage.elemIds.syncQuality) {
            Integer n;
            Integer n2;
            Integer n3;
            Object object;
            int n4 = omiMessage.getAttribValInt(OmiMessage.RfpQualityType.id.name());
            RfpQualityRecord rfpQualityRecord = this.rfpQualityDb.getRecordById(n4);
            if (rfpQualityRecord == null) {
                rfpQualityRecord = new RfpQualityRecord(n4);
                object = this.rfpDataHandler.getRfpData(n4);
                if (object != null) {
                    rfpQualityRecord.syncState = (OmiMessage.RFPSyncStateType)((Object)((RfpDataRecord)object).getField(RfpDataRecord.IDX_SYNC_STATE));
                    rfpQualityRecord.cluster = (Integer)((RfpDataRecord)object).getField(RfpDataRecord.IDX_CLUSTER);
                }
            }
            if ((object = Integer.valueOf(omiMessage.getAttribValInt(OmiMessage.RfpQualityType.strongRels.name()))) != null && rfpQualityRecord.strongRels != (Integer)object) {
                rfpQualityRecord.strongRels = (Integer)object;
            }
            if ((n3 = Integer.valueOf(omiMessage.getAttribValInt(OmiMessage.RfpQualityType.lowRels.name()))) != null && rfpQualityRecord.lowRels != n3) {
                rfpQualityRecord.lowRels = n3;
            }
            if ((n2 = Integer.valueOf(omiMessage.getAttribValInt(OmiMessage.RfpQualityType.maxRSSI.name()))) != null && rfpQualityRecord.maxRSSI != n2) {
                rfpQualityRecord.maxRSSI = n2;
            }
            if ((n = Integer.valueOf(omiMessage.getAttribValInt(OmiMessage.RfpQualityType.minRSSI.name()))) != null && rfpQualityRecord.minRSSI != n) {
                rfpQualityRecord.minRSSI = n;
            }
            this.rfpQualityDb.addRecord(rfpQualityRecord);
            if (!this.syncTableModeSnapshot) {
                this.rfpQualityApplicationDb.addRecord(rfpQualityRecord);
            }
            return true;
        }
        return false;
    }

    public void startRfpSyncQuality() {
        OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.RFPSyncQuality, OmiMessage.EventFilterItems.rfpId, "-1");
        this.sendGetRfpSyncQualityBulk(0, 20);
    }

    public void stopRfpSyncQuality() {
        OmiMessage.sendResetEventSubscription(this.omiHandler, OmiMessage.EventType.RFPSyncQuality, OmiMessage.EventFilterItems.rfpId, "-1");
        this.rfpQualityDb.clearAll();
        this.rfpQualityApplicationDb.clearAll();
    }

    @Override
    public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
        if (omiManagementEventEnum == OmiManagementEventEnum.LINK_READY) {
            this.rfpQualityDb.clearAll();
            this.rfpQualityApplicationDb.clearAll();
        }
    }

    @Override
    public void processOmiMessage(OmiMessage omiMessage) {
        int n = 0;
        switch (omiMessage.id) {
            case GetRFPMediaStreamQualityResp: {
                n = this.processGetRfpMediaStreamQualityResp(omiMessage);
                if (!this.getMediaStreamBulkInProgress) break;
                if (n > 0) {
                    this.sendGetRfpMediaStreamQualityBulk(n + 1, 20);
                    break;
                }
                this.getMediaStreamBulkInProgress = false;
                this.GenerateMediaStreamDataNotification(this.rfpQualityDb.getRecordNumber(), DataNotificationEnum.DATA_BULK_READY);
                break;
            }
            case EventRFPMediaStreamQuality: {
                this.processEventRfpMediaStreamQuality(omiMessage);
                break;
            }
            case ResetRFPMediaStreamQualityResp: {
                String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string == null) break;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, String.format("ResetRFPMediaStreamQualityResp with error '%s'", string));
                break;
            }
            case GetRFPIpQualityResp: {
                n = this.processGetRfpIpQualityResp(omiMessage);
                if (!this.getIpBulkInProgress) break;
                if (n > 0) {
                    this.sendGetRfpIpQualityBulk(n + 1, 20);
                    break;
                }
                this.getIpBulkInProgress = false;
                break;
            }
            case EventRFPIpQuality: {
                this.processEventRfpIpQuality(omiMessage);
                break;
            }
            case GetRFPSyncQualityResp: {
                n = this.processGetRfpSyncQualityResp(omiMessage);
                if (!this.getSyncBulkInProgress) break;
                if (n > 0) {
                    this.sendGetRfpSyncQualityBulk(n + 1, 20);
                    break;
                }
                this.getSyncBulkInProgress = false;
                break;
            }
            case EventRFPSyncQuality: {
                this.processEventRfpSyncQuality(omiMessage);
                break;
            }
            case GetRFPResp: 
            case EventRFPCnf: 
            case EventRFPState: {
                this.processRfpCnfState(omiMessage);
                break;
            }
        }
    }

    private void processRfpCnfState(OmiMessage omiMessage) {
        for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
            int n;
            OmiMessage.RFPSyncStateType rFPSyncStateType;
            int n2;
            RfpQualityRecord rfpQualityRecord;
            if (omiMessage2.id != OmiMessage.elemIds.rfp || (rfpQualityRecord = this.rfpQualityDb.getRecordById(n2 = Integer.parseInt(omiMessage2.getAttribVal(OmiMessage.RFPType.id.name())))) == null) continue;
            boolean bl = false;
            if (omiMessage2.getAttribVal(OmiMessage.RFPType.syncState.name()) != null && rfpQualityRecord.syncState != (rFPSyncStateType = OmiMessage.RFPSyncStateType.valueOf(omiMessage2.getAttribVal(OmiMessage.RFPType.syncState.name())))) {
                rfpQualityRecord.syncState = rFPSyncStateType;
                bl = true;
            }
            if (omiMessage2.getAttribVal(OmiMessage.RFPType.cluster.name()) != null && rfpQualityRecord.cluster != (n = omiMessage2.getAttribValInt(OmiMessage.RFPType.cluster.name()))) {
                rfpQualityRecord.cluster = n;
                bl = true;
            }
            if (!bl) continue;
            this.rfpQualityDb.addRecord(rfpQualityRecord);
            if (this.syncTableModeSnapshot) continue;
            this.rfpQualityApplicationDb.addRecord(rfpQualityRecord);
        }
    }

    private void sendRfpReqWithState(int n) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetRFP);
        omiMessage.addAttrib(OmiMessage.attribIds.id.name(), n);
        omiMessage.addAttrib(OmiMessage.attribIds.withState.name(), true);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public Database getRfpQualityApplicationDb() {
        return this.rfpQualityApplicationDb;
    }

    public boolean getSyncTableModeSnapshot() {
        return this.syncTableModeSnapshot;
    }

    public void changeSyncTableModeSnapshot(boolean bl) {
        if (this.syncTableModeSnapshot != bl) {
            this.syncTableModeSnapshot = bl;
            if (!this.syncTableModeSnapshot) {
                this.updateRfpQualityApplicationDb();
            }
        }
    }

    public void updateRfpQualityApplicationDb() {
        if (this.syncTableModeSnapshot) {
            int n = this.rfpQualityDb.getRecordNumber();
            this.rfpQualityApplicationDb.clearAll();
            if (n > 0) {
                for (int i = 0; i < 4096; ++i) {
                    if (this.rfpQualityDb.getRecordByIdx(i) == null) continue;
                    this.rfpQualityApplicationDb.addRecord((RfpQualityRecord)this.rfpQualityDb.getRecordByIdx(i));
                    if (--n == 0) break;
                }
            }
        }
    }

    public static interface MediaStreamQualityNotificationInterface {
        public void processMediaStreamQualityDataNotification(int var1, DataNotificationEnum var2);
    }

    public static class RfpQualityDatabase
    extends Database {
        RfpQualityRecord[] rfpQualityRecords = new RfpQualityRecord[4096];
        int[] rfpQualityIdx = new int[4096];
        int noOfRecords = 0;

        @Override
        public DataRecord getRecordByIdx(int n) {
            if (n >= 0 && n < this.noOfRecords) {
                return this.rfpQualityRecords[this.rfpQualityIdx[n]];
            }
            return null;
        }

        public RfpQualityRecord getRecordById(int n) {
            if (n >= 0 && n < 4096) {
                return this.rfpQualityRecords[n];
            }
            return null;
        }

        @Override
        public int getRecordNumber() {
            return this.noOfRecords;
        }

        @Override
        public void updateIndex() {
            this.noOfRecords = 0;
            for (int i = 0; i < 4096; ++i) {
                if (this.rfpQualityRecords[i] == null) continue;
                this.rfpQualityIdx[this.noOfRecords++] = i;
            }
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }

        public void addRecord(RfpQualityRecord rfpQualityRecord) {
            if (rfpQualityRecord.id >= 0 && rfpQualityRecord.id < 4096) {
                this.rfpQualityRecords[rfpQualityRecord.id] = rfpQualityRecord;
                this.updateIndex();
            }
        }

        public void clearAll() {
            for (int i = 0; i < this.noOfRecords; ++i) {
                this.rfpQualityRecords[this.rfpQualityIdx[i]] = null;
            }
            this.noOfRecords = 0;
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }

        @Override
        public String[] getFieldNames() {
            return RfpQualityRecord.getFieldNames();
        }
    }

    public static class RfpQualityRecord
    extends DataRecord {
        public static final int IDX_ID = 0;
        public static final int IDX_CONNECTS = 1;
        public static final int IDX_DURATION = 2;
        public static final int IDX_PACKETS_RX = 3;
        public static final int IDX_OCTETS_RX = 4;
        public static final int IDX_PACKETS_TX = 5;
        public static final int IDX_OCTETS_TX = 6;
        public static final int IDX_PACKETS_LOST = 7;
        public static final int IDX_MAX_JITTER = 8;
        public static final int IDX_CONNECTED_TIME = 9;
        public static final int IDX_CURRENT_RTT = 10;
        public static final int IDX_MAX_RTT = 11;
        public static final int IDX_COUNT = 12;
        public static final int IDX_INTERVAL1 = 13;
        public static final int IDX_INTERVAL2 = 14;
        public static final int IDX_INTERVAL3 = 15;
        public static final int IDX_INTERVAL4 = 16;
        public static final int IDX_INTERVAL5 = 17;
        public static final int IDX_SYNC_STATE = 18;
        public static final int IDX_CLUSTER = 19;
        public static final int IDX_STRONG_RELS = 20;
        public static final int IDX_LOW_RELS = 21;
        public static final int IDX_MAX_RSSI = 22;
        public static final int IDX_MIN_RSSI = 23;
        public static final int NUMBER_OF_FIELDS = 24;
        private static String[] fieldNames = new String[]{"id", "connects", "duration", "RX packets", "RX octets", "TX packets", "RX octets", "lost packets", "max jitter", "connected time", "current RTT", "max RTT", "count", "interval1", "interval2", "interval3", "interval4", "interval5", "sync state", "cluster", "strong rels", "low rels", "max RSSI", "min RSSI"};
        public int id = 0;
        public int connects = 0;
        public int duration = 0;
        public int packetsRx = 0;
        public int octetsRx = 0;
        public int packetsTx = 0;
        public int octetsTx = 0;
        public int packetsLost = 0;
        public int maxJitter = 0;
        public int connectedTime = 0;
        public float currentRTT = 0.0f;
        public float maxRTT = 0.0f;
        public int count = 0;
        public int interval1 = 0;
        public int interval2 = 0;
        public int interval3 = 0;
        public int interval4 = 0;
        public int interval5 = 0;
        public OmiMessage.RFPSyncStateType syncState = OmiMessage.RFPSyncStateType.Inactive;
        public int cluster = 0;
        public int strongRels = 0;
        public int lowRels = 0;
        public int maxRSSI = 0;
        public int minRSSI = 0;

        public RfpQualityRecord() {
        }

        public RfpQualityRecord(int n) {
            this.id = n;
        }

        public static void setTableHeaderText(int n, String string) {
            if (n >= 0 && n < 24) {
                RfpQualityRecord.fieldNames[n] = string;
            }
        }

        public static String[] getFieldNames() {
            return fieldNames;
        }

        @Override
        public Object getField(int n) {
            switch (n) {
                case 0: {
                    return this.id;
                }
                case 1: {
                    return this.connects;
                }
                case 2: {
                    return this.duration;
                }
                case 3: {
                    return this.packetsRx;
                }
                case 4: {
                    return this.octetsRx;
                }
                case 5: {
                    return this.packetsTx;
                }
                case 6: {
                    return this.octetsTx;
                }
                case 7: {
                    return this.packetsLost;
                }
                case 8: {
                    return this.maxJitter;
                }
                case 9: {
                    return this.connectedTime;
                }
                case 10: {
                    return Float.valueOf(this.currentRTT);
                }
                case 11: {
                    return Float.valueOf(this.maxRTT);
                }
                case 12: {
                    return this.count;
                }
                case 13: {
                    return this.interval1;
                }
                case 14: {
                    return this.interval2;
                }
                case 15: {
                    return this.interval3;
                }
                case 16: {
                    return this.interval4;
                }
                case 17: {
                    return this.interval5;
                }
                case 18: {
                    return this.syncState;
                }
                case 19: {
                    return this.cluster;
                }
                case 20: {
                    return this.strongRels;
                }
                case 21: {
                    return this.lowRels;
                }
                case 22: {
                    return this.maxRSSI;
                }
                case 23: {
                    if (this.minRSSI == -100) {
                        return 0;
                    }
                    return this.minRSSI;
                }
            }
            return null;
        }

        @Override
        public DataRecord clone() {
            RfpQualityRecord rfpQualityRecord = new RfpQualityRecord();
            rfpQualityRecord.id = this.id;
            rfpQualityRecord.connects = this.connects;
            rfpQualityRecord.duration = this.duration;
            rfpQualityRecord.packetsRx = this.packetsRx;
            rfpQualityRecord.octetsRx = this.octetsRx;
            rfpQualityRecord.packetsTx = this.packetsTx;
            rfpQualityRecord.octetsTx = this.octetsTx;
            rfpQualityRecord.packetsLost = this.packetsLost;
            rfpQualityRecord.maxJitter = this.maxJitter;
            rfpQualityRecord.connectedTime = this.connectedTime;
            rfpQualityRecord.currentRTT = this.currentRTT;
            rfpQualityRecord.maxRTT = this.maxRTT;
            rfpQualityRecord.count = this.count;
            rfpQualityRecord.interval1 = this.interval1;
            rfpQualityRecord.interval2 = this.interval2;
            rfpQualityRecord.interval3 = this.interval3;
            rfpQualityRecord.interval4 = this.interval4;
            rfpQualityRecord.interval5 = this.interval5;
            rfpQualityRecord.syncState = this.syncState;
            rfpQualityRecord.cluster = this.cluster;
            rfpQualityRecord.strongRels = this.strongRels;
            rfpQualityRecord.lowRels = this.lowRels;
            rfpQualityRecord.maxRSSI = this.maxRSSI;
            rfpQualityRecord.minRSSI = this.minRSSI;
            return rfpQualityRecord;
        }
    }
}

