/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.OmiHandler;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;
import com.aastra.util.UtilSpy;
import java.util.LinkedList;

public class SWManagementHandler
implements OmiMessageInterface,
OmiManagementEventInterface {
    private OmiHandler omiHandler = null;
    private LinkedList<SWManagementDataNotificationInterface> listenerList = new LinkedList();
    private SoftwareUpdate swUpdate = new SoftwareUpdate();

    public SWManagementHandler(OmiManagement omiManagement) {
        this.omiHandler = omiManagement.getOmiHandler();
        omiManagement.registerManagementEventListener(this);
        OmiMessage.elemIds.GetSoftwareUpdateResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SoftwareUpdateResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventSoftwareUpdateCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.SystemRestartResp.registerDataNotificationListener(this);
    }

    public SoftwareUpdate getSwUpdate() {
        return this.clone();
    }

    public SoftwareUpdate clone() {
        SoftwareUpdate softwareUpdate = new SoftwareUpdate();
        softwareUpdate.allAtOnce = this.swUpdate.allAtOnce;
        softwareUpdate.timedUpdate = this.swUpdate.timedUpdate;
        softwareUpdate.hour = this.swUpdate.hour;
        softwareUpdate.minute = this.swUpdate.minute;
        softwareUpdate.maxDelay = this.swUpdate.maxDelay;
        softwareUpdate.hourCalculated = this.swUpdate.hourCalculated;
        softwareUpdate.minuteCalculated = this.swUpdate.minuteCalculated;
        return softwareUpdate;
    }

    public void sendSoftwareUpdate() {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.SoftwareUpdate);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendSoftwareUpdate(SoftwareUpdate softwareUpdate) {
        if (softwareUpdate.allAtOnce != this.swUpdate.allAtOnce || softwareUpdate.timedUpdate != this.swUpdate.timedUpdate || softwareUpdate.hour != this.swUpdate.hour || softwareUpdate.minute != this.swUpdate.minute || softwareUpdate.maxDelay != this.swUpdate.maxDelay) {
            OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.SoftwareUpdate);
            if (softwareUpdate.allAtOnce != this.swUpdate.allAtOnce) {
                omiMessage.addAttrib(OmiMessage.SoftwareUpdateType.allAtOnce.name(), softwareUpdate.allAtOnce);
            }
            if (softwareUpdate.timedUpdate != this.swUpdate.timedUpdate) {
                omiMessage.addAttrib(OmiMessage.SoftwareUpdateType.timedUpdate.name(), softwareUpdate.timedUpdate);
            }
            if (softwareUpdate.hour != this.swUpdate.hour) {
                omiMessage.addAttrib(OmiMessage.SoftwareUpdateType.hour.name(), softwareUpdate.hour);
            }
            if (softwareUpdate.minute != this.swUpdate.minute) {
                omiMessage.addAttrib(OmiMessage.SoftwareUpdateType.minute.name(), softwareUpdate.minute);
            }
            if (softwareUpdate.maxDelay != this.swUpdate.maxDelay) {
                omiMessage.addAttrib(OmiMessage.SoftwareUpdateType.maxDelay.name(), softwareUpdate.maxDelay);
            }
            this.omiHandler.sendOmiMessage(omiMessage);
        }
    }

    public void sendGetSoftwareUpdate() {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetSoftwareUpdate);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendSystemRestart(boolean bl, boolean bl2) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.SystemRestart);
        omiMessage.addAttrib(OmiMessage.attribIds.resetDB.name(), bl);
        omiMessage.addAttrib(OmiMessage.attribIds.resetToFactoryDefaults.name(), bl2);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    @Override
    public void processOmiMessage(OmiMessage omiMessage) {
        String string = null;
        switch (omiMessage.id) {
            case SoftwareUpdateResp: 
            case GetSoftwareUpdateResp: 
            case EventSoftwareUpdateCnf: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Handler Received SoftwareUpdateResp error");
                    this.GenerateSWManagementErrorNotification(DataNotificationEnum.SOFTWARE_UPDATE, omiMessage);
                    break;
                }
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, String.format("Handler Received %s success", omiMessage.id.name()));
                this.processSwUpdateElem(omiMessage);
                this.GenerateSWManagementDataNotification(DataNotificationEnum.SOFTWARE_UPDATE);
                break;
            }
            case SystemRestartResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Handler Received SystemRestartResp error");
                    this.GenerateSWManagementErrorNotification(DataNotificationEnum.SYSTEM_RESTART, omiMessage);
                    break;
                }
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Handler Received SystemRestartResp success");
                this.GenerateSWManagementDataNotification(DataNotificationEnum.SYSTEM_RESTART);
                break;
            }
        }
    }

    private boolean processSwUpdateElem(OmiMessage omiMessage) {
        Integer n;
        boolean bl = false;
        Boolean bl2 = omiMessage.getAttribValBoolNotMandatory(OmiMessage.SoftwareUpdateType.timedUpdate.name());
        if (bl2 != null && this.swUpdate.timedUpdate != bl2) {
            this.swUpdate.timedUpdate = bl2;
            bl = true;
        }
        if ((bl2 = omiMessage.getAttribValBoolNotMandatory(OmiMessage.SoftwareUpdateType.allAtOnce.name())) != null && this.swUpdate.allAtOnce != bl2) {
            this.swUpdate.allAtOnce = bl2;
            bl = true;
        }
        if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.SoftwareUpdateType.hour.name())) != null && this.swUpdate.hour != n) {
            this.swUpdate.hour = n;
            bl = true;
        }
        if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.SoftwareUpdateType.minute.name())) != null && this.swUpdate.minute != n) {
            this.swUpdate.minute = n;
            bl = true;
        }
        if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.SoftwareUpdateType.maxDelay.name())) != null && this.swUpdate.maxDelay != n) {
            this.swUpdate.maxDelay = n;
            bl = true;
        }
        if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.SoftwareUpdateType.hourCalculated.name())) != null && this.swUpdate.hourCalculated != n) {
            this.swUpdate.hourCalculated = n;
            bl = true;
        }
        if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.SoftwareUpdateType.minuteCalculated.name())) != null && this.swUpdate.minuteCalculated != n) {
            this.swUpdate.minuteCalculated = n;
            bl = true;
        }
        return bl;
    }

    public void registerDataNotificationListener(SWManagementDataNotificationInterface sWManagementDataNotificationInterface) {
        this.listenerList.add(sWManagementDataNotificationInterface);
    }

    public void deregisterDataNotificationListener(SWManagementDataNotificationInterface sWManagementDataNotificationInterface) {
        this.listenerList.remove(sWManagementDataNotificationInterface);
    }

    private void GenerateSWManagementDataNotification(DataNotificationEnum dataNotificationEnum) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating SWManagement data notification: No listener");
        }
        for (SWManagementDataNotificationInterface sWManagementDataNotificationInterface : this.listenerList) {
            if (sWManagementDataNotificationInterface == null) continue;
            sWManagementDataNotificationInterface.processSWManagementDataNotification(dataNotificationEnum);
        }
    }

    private void GenerateSWManagementErrorNotification(DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating SWManagement error notification: No listener");
        }
        for (SWManagementDataNotificationInterface sWManagementDataNotificationInterface : this.listenerList) {
            if (sWManagementDataNotificationInterface == null) continue;
            sWManagementDataNotificationInterface.processSWManagementErrorNotification(dataNotificationEnum, omiMessage);
        }
    }

    @Override
    public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
        switch (omiManagementEventEnum) {
            case LINK_READY: {
                this.sendGetSoftwareUpdate();
                break;
            }
        }
    }

    public static interface SWManagementDataNotificationInterface {
        public void processSWManagementDataNotification(DataNotificationEnum var1);

        public void processSWManagementErrorNotification(DataNotificationEnum var1, OmiMessage var2);
    }

    public static class SoftwareUpdate {
        public boolean timedUpdate = false;
        public boolean allAtOnce = false;
        public int hour = 0;
        public int minute = 0;
        public int maxDelay = 0;
        public int hourCalculated = 0;
        public int minuteCalculated = 0;
    }
}

