/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.OmiHandler;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;

public abstract class SummaryHandler
implements OmiManagementEventInterface,
OmiMessageInterface {
    protected OmiManagement om = null;
    protected OmiHandler omiHandler = null;
    protected OmiManagementEventEnum omiMgmtState = null;
    private OmiMessage.elemIds getSummary;
    private OmiMessage.elemIds getSummaryResp;
    private OmiMessage.elemIds eventSummary;
    private Subscription[] subscriptionType = null;

    protected SummaryHandler(OmiManagement omiManagement, OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.EventType eventType) {
        this.om = omiManagement;
        this.omiHandler = this.om.getOmiHandler();
        this.om.registerManagementEventListener(this);
        this.getSummary = elemIds2;
        this.getSummaryResp = elemIds3;
        this.eventSummary = elemIds4;
        this.subscriptionType = new Subscription[1];
        this.subscriptionType[0] = new Subscription(eventType);
        this.getSummaryResp.registerDataNotificationListener(this);
        this.eventSummary.registerDataNotificationListener(this);
    }

    protected SummaryHandler(OmiManagement omiManagement, OmiMessage.elemIds elemIds2, OmiMessage.elemIds elemIds3, OmiMessage.elemIds elemIds4, OmiMessage.EventType[] eventTypeArray) {
        this.om = omiManagement;
        this.omiHandler = this.om.getOmiHandler();
        this.om.registerManagementEventListener(this);
        this.getSummary = elemIds2;
        this.getSummaryResp = elemIds3;
        this.eventSummary = elemIds4;
        this.subscriptionType = new Subscription[eventTypeArray.length];
        for (int i = 0; i < eventTypeArray.length; ++i) {
            this.subscriptionType[i] = new Subscription(eventTypeArray[i]);
        }
        this.getSummaryResp.registerDataNotificationListener(this);
        this.eventSummary.registerDataNotificationListener(this);
    }

    public void activateRequest() {
        for (int i = 0; i < this.subscriptionType.length; ++i) {
            if (this.subscriptionType[i].activateRequest) continue;
            this.subscriptionType[i].activateRequest = true;
            this.startSingleSubscription(this.subscriptionType[i]);
        }
        this.sendGetSummary();
    }

    public boolean activateRequest(OmiMessage.EventType eventType) {
        for (int i = 0; i < this.subscriptionType.length; ++i) {
            if (this.subscriptionType[i].eventType != eventType || this.subscriptionType[i].activateRequest) continue;
            this.subscriptionType[i].activateRequest = true;
            this.startSingleSubscription(this.subscriptionType[i]);
            this.sendGetSummary();
            return true;
        }
        return false;
    }

    public void deactivateRequest() {
        for (int i = 0; i < this.subscriptionType.length; ++i) {
            if (!this.subscriptionType[i].activateRequest) continue;
            this.subscriptionType[i].activateRequest = false;
            this.stopSingleSubscription(this.subscriptionType[i]);
        }
    }

    public boolean deactivateRequest(OmiMessage.EventType eventType) {
        for (int i = 0; i < this.subscriptionType.length; ++i) {
            if (this.subscriptionType[i].eventType != eventType || !this.subscriptionType[i].activateRequest) continue;
            this.subscriptionType[i].activateRequest = false;
            this.stopSingleSubscription(this.subscriptionType[i]);
            return true;
        }
        return false;
    }

    protected abstract void initSummary();

    protected abstract boolean processSummary(OmiMessage var1);

    protected abstract void GenerateSummaryNotification();

    protected abstract void GenerateSummaryErrorNotification(OmiMessage var1);

    private void sendGetSummary() {
        if (this.omiMgmtState == OmiManagementEventEnum.LINK_READY) {
            OmiMessage omiMessage = new OmiMessage(this.getSummary);
            this.omiHandler.sendOmiMessage(omiMessage);
        }
    }

    private void startSingleSubscription(Subscription subscription) {
        if (this.omiMgmtState == OmiManagementEventEnum.LINK_READY) {
            OmiMessage.sendSetEventSubscription(this.omiHandler, subscription.eventType, null, null);
        }
    }

    private void stopSingleSubscription(Subscription subscription) {
        if (this.omiMgmtState == OmiManagementEventEnum.LINK_READY) {
            OmiMessage.sendResetEventSubscription(this.omiHandler, subscription.eventType, null, null);
        }
    }

    private void startSubscriptionsAfterLinkReady() {
        boolean bl = false;
        for (int i = 0; i < this.subscriptionType.length; ++i) {
            if (!this.subscriptionType[i].activateRequest) continue;
            bl = true;
            OmiMessage.sendSetEventSubscription(this.omiHandler, this.subscriptionType[i].eventType, null, null);
        }
        if (bl) {
            this.sendGetSummary();
        }
    }

    @Override
    public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
        switch (omiManagementEventEnum) {
            case LINK_READY: {
                this.initSummary();
                this.omiMgmtState = OmiManagementEventEnum.LINK_READY;
                this.startSubscriptionsAfterLinkReady();
                break;
            }
            case LINK_CLOSED: {
                this.omiMgmtState = OmiManagementEventEnum.LINK_CLOSED;
                break;
            }
        }
    }

    @Override
    public void processOmiMessage(OmiMessage omiMessage) {
        String string = null;
        if (omiMessage.id == this.getSummaryResp) {
            string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
            if (string != null) {
                this.GenerateSummaryErrorNotification(omiMessage);
            } else if (this.processSummary(omiMessage)) {
                this.GenerateSummaryNotification();
            }
        } else if (omiMessage.id == this.eventSummary && this.processSummary(omiMessage)) {
            this.GenerateSummaryNotification();
        }
    }

    private class Subscription {
        private OmiMessage.EventType eventType = null;
        private boolean activateRequest = false;

        private Subscription(OmiMessage.EventType eventType) {
            this.eventType = eventType;
        }
    }
}

