/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.OmiHandler;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;
import com.aastra.omilib.VersionTypeEnum;
import com.aastra.util.UtilSpy;

public class VersionHandler
implements OmiMessageInterface {
    public static final int MAX_VERSION_ELEMENTS = 500;
    public static final String versionUnknown = "-1.-1.-1";
    public static final String versionNone = "0.0.0";
    public static final String versionInitial = "1.0.0";
    public static VersionDatabase versionElementDb = new VersionDatabase();
    private OmiHandler omiHandler = null;

    public VersionHandler(OmiManagement omiManagement) {
        this.omiHandler = omiManagement.getOmiHandler();
        OmiMessage.elemIds.GetVersionsResp.registerDataNotificationListener(this);
    }

    public VersionDatabase getDb() {
        return versionElementDb;
    }

    public void sendGetVersions() {
        versionElementDb.clearAll();
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetVersions);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    @Override
    public void processOmiMessage(OmiMessage omiMessage) {
        String string = null;
        if (omiMessage.id == OmiMessage.elemIds.GetVersionsResp) {
            string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
            if (string != null) {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Handler received GetVersionResp error");
            } else {
                String string2 = omiMessage.getXmlString();
                String[] stringArray = string2.split(" ", 500);
                for (int i = 1; i < stringArray.length - 1; ++i) {
                    VersionElement versionElement = new VersionElement();
                    String[] stringArray2 = stringArray[i].split("=", 2);
                    versionElement.name = stringArray2[0];
                    versionElement.versionOmm = new VersionClass(stringArray2[1]);
                    try {
                        versionElement.versionOmilib = VersionTypeEnum.valueOf(versionElement.name).getVersionOmilib();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        versionElement.versionOmilib = new VersionClass(versionUnknown);
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, String.format("Received version info for unknown element '%s'", versionElement.name));
                    }
                    versionElementDb.add(versionElement);
                }
            }
        }
    }

    public static class VersionDatabase {
        VersionElement[] elemArray = new VersionElement[500];
        int idx = 0;

        public int getRecordNumber() {
            return this.idx;
        }

        public VersionElement getRecord(int n) {
            if (n < this.idx) {
                return this.elemArray[n];
            }
            return null;
        }

        public boolean containsElement(String string) {
            for (int i = 0; i < this.idx; ++i) {
                if (!this.elemArray[i].name.equals(string)) continue;
                return true;
            }
            return false;
        }

        public void add(VersionElement versionElement) {
            this.elemArray[this.idx] = versionElement;
            ++this.idx;
        }

        public void clearAll() {
            for (int i = 0; i < this.idx; ++i) {
                this.elemArray[this.idx] = null;
            }
            this.idx = 0;
        }
    }

    public static class VersionElement {
        private String name;
        private VersionClass versionOmm;
        private VersionClass versionOmilib;

        public String getName() {
            return this.name;
        }

        public String getVersionOmmString() {
            return String.format("%d.%d.%d", this.versionOmm.major, this.versionOmm.minor, this.versionOmm.bugfix);
        }

        public String getVersionOmilibString() {
            return String.format("%d.%d.%d", this.versionOmilib.major, this.versionOmilib.minor, this.versionOmilib.bugfix);
        }

        public VersionCompare compare() {
            if (this.getVersionOmilibString().equals(VersionHandler.versionNone) && this.getVersionOmmString().equals(VersionHandler.versionNone)) {
                return VersionCompare.NotSupportedBoth;
            }
            if (this.getVersionOmilibString().equals(VersionHandler.versionUnknown)) {
                return VersionCompare.NotSupportedOmilibUnknown;
            }
            if (this.getVersionOmilibString().equals(VersionHandler.versionNone)) {
                return VersionCompare.NotSupportedOmilibDontCare;
            }
            if (this.getVersionOmmString().equals(VersionHandler.versionNone)) {
                return VersionCompare.NotSupportedOmm;
            }
            if (this.getVersionOmilibString().equals(this.getVersionOmmString())) {
                return VersionCompare.Equal;
            }
            if (this.versionOmilib.major == this.versionOmm.major) {
                if (this.versionOmilib.minor == this.versionOmm.minor) {
                    if (this.versionOmilib.bugfix > this.versionOmm.bugfix) {
                        return VersionCompare.BugfixDiffOmilibNewer;
                    }
                    return VersionCompare.BugfixDiffOmmNewer;
                }
                if (this.versionOmilib.minor > this.versionOmm.minor) {
                    return VersionCompare.MinorDiffOmilibNewer;
                }
                return VersionCompare.MinorDiffOmmNewer;
            }
            if (this.versionOmilib.major > this.versionOmm.major) {
                return VersionCompare.MajorDiffOmilibNewer;
            }
            return VersionCompare.MajorDiffOmmNewer;
        }
    }

    public static class VersionClass {
        public int major = 0;
        public int minor = 0;
        public int bugfix = 0;

        public VersionClass() {
        }

        public VersionClass(int n, int n2, int n3) {
            this.major = n;
            this.minor = n2;
            this.bugfix = n3;
        }

        public VersionClass(String string) {
            int n = string.length();
            if (string.contains("\"")) {
                string = string.substring(1, n - 1);
            }
            String[] stringArray = string.split("\\.", 3);
            this.major = Integer.parseInt(stringArray[0]);
            this.minor = Integer.parseInt(stringArray[1]);
            this.bugfix = Integer.parseInt(stringArray[2]);
        }
    }

    public static enum VersionCompare {
        NotSupportedBoth,
        NotSupportedOmilibUnknown,
        NotSupportedOmilibDontCare,
        NotSupportedOmm,
        MajorDiffOmilibNewer,
        MajorDiffOmmNewer,
        MinorDiffOmilibNewer,
        MinorDiffOmmNewer,
        BugfixDiffOmilibNewer,
        BugfixDiffOmmNewer,
        Equal;

    }
}

