/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.OmiHandler;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;
import com.aastra.omilib.OmilibUtil;
import com.aastra.util.UtilSpy;
import java.util.LinkedList;

public class WLANProfileHandler
implements OmiMessageInterface,
OmiManagementEventInterface {
    private OmiHandler omiHandler = null;
    private WLANProfileDatabase profileDb = new WLANProfileDatabase();
    private static ACLDatabase[] aclDb = new ACLDatabase[20];
    private LinkedList<WLANProfileDataNotificationInterface> listenerListProfile = new LinkedList();
    private LinkedList<WLANProfileACLDataNotificationInterface> listenerListProfileACL = new LinkedList();

    public WLANProfileHandler(OmiManagement omiManagement) {
        this.omiHandler = omiManagement.getOmiHandler();
        omiManagement.registerManagementEventListener(this);
        OmiMessage.elemIds.GetWLANProfileResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.CreateWLANProfileResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.DeleteWLANProfileResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetWLANProfileResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventWLANProfileCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetACLEntryResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.CreateACLEntryResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetACLEntryResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.DeleteACLEntryResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventACLCnf.registerDataNotificationListener(this);
    }

    public void registerProfileDataNotificationListener(WLANProfileDataNotificationInterface wLANProfileDataNotificationInterface) {
        this.listenerListProfile.add(wLANProfileDataNotificationInterface);
    }

    public void deregisterProfileDataNotificationListener(WLANProfileDataNotificationInterface wLANProfileDataNotificationInterface) {
        this.listenerListProfile.remove(wLANProfileDataNotificationInterface);
    }

    private void GenerateDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        if (this.listenerListProfile.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating WLAN profile notification: No listener");
        }
        for (WLANProfileDataNotificationInterface wLANProfileDataNotificationInterface : this.listenerListProfile) {
            if (wLANProfileDataNotificationInterface == null) continue;
            wLANProfileDataNotificationInterface.processWLANProfileDataNotification(n, dataNotificationEnum);
        }
    }

    private void GenerateErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        if (this.listenerListProfile.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating WLAN error notification: No listener");
        }
        for (WLANProfileDataNotificationInterface wLANProfileDataNotificationInterface : this.listenerListProfile) {
            if (wLANProfileDataNotificationInterface == null) continue;
            wLANProfileDataNotificationInterface.processWLANProfileErrorNotification(n, dataNotificationEnum, omiMessage);
        }
    }

    public void registerProfileACLDataNotificationListener(WLANProfileACLDataNotificationInterface wLANProfileACLDataNotificationInterface) {
        this.listenerListProfileACL.add(wLANProfileACLDataNotificationInterface);
    }

    public void deregisterProfileACLDataNotificationListener(WLANProfileACLDataNotificationInterface wLANProfileACLDataNotificationInterface) {
        this.listenerListProfileACL.remove(wLANProfileACLDataNotificationInterface);
    }

    private void GenerateACLDataNotification(int n, DataNotificationEnum dataNotificationEnum, String string) {
        if (this.listenerListProfileACL.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating WLAN ACL notification: No listener");
        }
        for (WLANProfileACLDataNotificationInterface wLANProfileACLDataNotificationInterface : this.listenerListProfileACL) {
            if (wLANProfileACLDataNotificationInterface == null) continue;
            wLANProfileACLDataNotificationInterface.processWLANProfileACLDataNotification(n, dataNotificationEnum, string);
        }
    }

    private void GenerateACLErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        if (this.listenerListProfileACL.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating WLAN ACL error notification: No listener");
        }
        for (WLANProfileACLDataNotificationInterface wLANProfileACLDataNotificationInterface : this.listenerListProfileACL) {
            if (wLANProfileACLDataNotificationInterface == null) continue;
            wLANProfileACLDataNotificationInterface.processWLANProfileACLErrorNotification(n, dataNotificationEnum, omiMessage);
        }
    }

    public void sendGetWLANProfile(int n) {
        this.sendGetWLANProfileBulk(n, 1);
    }

    public void sendGetWLANProfileBulk(int n, int n2) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetWLANProfile);
        omiMessage.addAttrib(OmiMessage.attribIds.id.name(), n);
        omiMessage.addAttrib(OmiMessage.attribIds.maxRecords.name(), n2);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    private void sendGetACLEntries(int n, int n2, String string) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetACLEntry);
        omiMessage.addAttrib(OmiMessage.attribIds.wlanProfile.name(), n);
        if (string == null) {
            omiMessage.addAttrib(OmiMessage.ACLEntryType.ethAddr.name(), "00:00:00:00:00:00");
        } else {
            omiMessage.addAttrib(OmiMessage.ACLEntryType.ethAddr.name(), string);
        }
        omiMessage.addAttrib(OmiMessage.attribIds.maxRecords.name(), n2);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    private String processACLEntries(WLANProfile wLANProfile, OmiMessage omiMessage) {
        String string = null;
        int n = 0;
        String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.deleted.name());
        for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
            if (omiMessage2.id != OmiMessage.elemIds.entry || (string = omiMessage2.getAttribVal(OmiMessage.ACLEntryType.ethAddr.name())) == null) continue;
            if (string2 != null) {
                wLANProfile.deleteACLEntry(string);
                this.GenerateACLDataNotification(wLANProfile.id, DataNotificationEnum.DATA_DELETED, string);
                continue;
            }
            ACLEntry aCLEntry = null;
            aCLEntry = wLANProfile.getACLEntry(string);
            if (aCLEntry == null) {
                aCLEntry = new ACLEntry();
                aCLEntry.ethAddr = string;
                if (omiMessage2.getAttribVal(OmiMessage.ACLEntryType.name.name()) != null) {
                    aCLEntry.name = omiMessage2.getAttribVal(OmiMessage.ACLEntryType.name.name());
                }
                wLANProfile.addACLEntry(aCLEntry);
                ++n;
                this.GenerateACLDataNotification(wLANProfile.id, DataNotificationEnum.NEW_DATA, string);
                continue;
            }
            if (omiMessage2.getAttribVal(OmiMessage.ACLEntryType.name.name()) != null) {
                aCLEntry.name = omiMessage2.getAttribVal(OmiMessage.ACLEntryType.name.name());
            }
            wLANProfile.setACLEntry(aCLEntry);
            this.GenerateACLDataNotification(wLANProfile.id, DataNotificationEnum.DATA_CHANGED, string);
        }
        if (n == 20) {
            return string;
        }
        return null;
    }

    private void processACLMessage(OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        if (string != null) {
            int n = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
            switch (omiMessage.id) {
                case GetACLEntryResp: 
                case CreateACLEntryResp: {
                    this.GenerateACLErrorNotification(n, DataNotificationEnum.NEW_DATA, omiMessage);
                    break;
                }
                case SetACLEntryResp: {
                    this.GenerateACLErrorNotification(n, DataNotificationEnum.DATA_CHANGED, omiMessage);
                    break;
                }
                case DeleteACLEntryResp: {
                    this.GenerateACLErrorNotification(n, DataNotificationEnum.DATA_DELETED, omiMessage);
                    break;
                }
            }
            return;
        }
        int n = omiMessage.getAttribValInt(OmiMessage.attribIds.wlanProfile.name());
        WLANProfile wLANProfile = this.profileDb.getRecordById(n);
        if (wLANProfile != null) {
            switch (omiMessage.id) {
                case GetACLEntryResp: {
                    String string2 = this.processACLEntries(wLANProfile, omiMessage);
                    if (string2 == null) break;
                    string2 = OmilibUtil.incrementMACAddr(string2);
                    this.sendGetACLEntries(n, 20, string2);
                    break;
                }
                case CreateACLEntryResp: 
                case SetACLEntryResp: {
                    this.processACLEntries(wLANProfile, omiMessage);
                    break;
                }
                case DeleteACLEntryResp: {
                    break;
                }
                case EventACLCnf: {
                    String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.deleteAll.name());
                    if (string3 != null) {
                        wLANProfile.clearAllACLEntries();
                        this.GenerateACLDataNotification(n, DataNotificationEnum.DATA_DELETED_ALL, null);
                        break;
                    }
                    this.processACLEntries(wLANProfile, omiMessage);
                    break;
                }
            }
        }
    }

    public Database getWLANProfileDatabase() {
        return this.profileDb;
    }

    public Database getAclDb(int n) {
        if (aclDb[n - 1] == null) {
            WLANProfileHandler.aclDb[n - 1] = new ACLDatabase();
        }
        return aclDb[n - 1];
    }

    public ACLEntry getAclEntryByTableIdx(int n, int n2) {
        return (ACLEntry)aclDb[n - 1].getRecordByIdx(n2);
    }

    public WLANProfile getWlanProfileByProfileId(int n) {
        return this.profileDb.getRecordById(n);
    }

    public WLANProfile getWlanProfileByTableIdx(int n) {
        return (WLANProfile)this.profileDb.getRecordByIdx(n);
    }

    private void profileElemToObject(OmiMessage omiMessage, WLANProfile wLANProfile, boolean bl, boolean bl2) {
        Boolean bl3;
        wLANProfile.id = omiMessage.getAttribValInt(OmiMessage.WLANProfileType.id.name());
        String string = omiMessage.getAttribVal(OmiMessage.WLANProfileType.profileType.name());
        if (string != null) {
            try {
                wLANProfile.profileType = OmiMessage.WLANProfileRFPType.valueOf(string);
            }
            catch (Exception exception) {}
        } else if (bl) {
            System.out.printf("Missing '%s'\n", OmiMessage.WLANProfileType.profileType.name());
        }
        if ((bl3 = omiMessage.getAttribValBoolNotMandatory(OmiMessage.WLANProfileType.enable.name())) != null) {
            wLANProfile.enable = bl3;
        } else if (bl) {
            System.out.printf("Missing '%s'\n", OmiMessage.WLANProfileType.enable.name());
        }
        Integer n = omiMessage.getAttribValIntNotMandatory(OmiMessage.WLANProfileType.beaconIntval.name());
        if (n != null) {
            wLANProfile.beaconInterval = n;
        } else if (bl) {
            System.out.printf("Missing '%s'\n", OmiMessage.WLANProfileType.beaconIntval.name());
        }
        n = omiMessage.getAttribValIntNotMandatory(OmiMessage.WLANProfileType.dtimIntval.name());
        if (n != null) {
            wLANProfile.dtimInterval = n;
        } else if (bl) {
            System.out.printf("Missing '%s'\n", OmiMessage.WLANProfileType.dtimIntval.name());
        }
        n = omiMessage.getAttribValIntNotMandatory(OmiMessage.WLANProfileType.rtsThreshold.name());
        if (n != null) {
            wLANProfile.rtsThreshold = n;
        } else if (bl) {
            System.out.printf("Missing '%s'\n", OmiMessage.WLANProfileType.rtsThreshold.name());
        }
        n = omiMessage.getAttribValIntNotMandatory(OmiMessage.WLANProfileType.fragThreshold.name());
        if (n != null) {
            wLANProfile.fragThreshold = n;
        } else if (bl) {
            System.out.printf("Missing '%s'\n", OmiMessage.WLANProfileType.fragThreshold.name());
        }
        if (wLANProfile.profileType == OmiMessage.WLANProfileRFPType.RFP42) {
            bl3 = omiMessage.getAttribValBoolNotMandatory(OmiMessage.WLANProfileType.interferenceAvoidance.name());
            if (bl3 != null) {
                wLANProfile.interferenceAvoidance = bl3.booleanValue() ? OmiMessage.GenericNoneInactiveActiveType.active : OmiMessage.GenericNoneInactiveActiveType.inactive;
            } else if (bl) {
                System.out.printf("Missing '%s'\n", OmiMessage.WLANProfileType.interferenceAvoidance.name());
                wLANProfile.interferenceAvoidance = OmiMessage.GenericNoneInactiveActiveType.inactive;
            }
        } else {
            wLANProfile.interferenceAvoidance = OmiMessage.GenericNoneInactiveActiveType.none;
        }
        string = omiMessage.getAttribVal(OmiMessage.WLANProfileType.maxRate.name());
        if (string != null) {
            wLANProfile.maxRate = OmiMessage.WLANMaxRateType.axiValueToEnum(string);
        } else if (bl && wLANProfile.profileType == OmiMessage.WLANProfileRFPType.RFP42) {
            System.out.printf("Missing '%s'\n", OmiMessage.WLANProfileType.maxRate.name());
            wLANProfile.maxRate = OmiMessage.WLANMaxRateType.RATE_54000;
        }
        string = omiMessage.getAttribVal(OmiMessage.WLANProfileType.mode.name());
        if (string != null) {
            try {
                wLANProfile.mode = OmiMessage.WLANModeType.valueOf(string);
            }
            catch (Exception exception) {
                if (wLANProfile.profileType == OmiMessage.WLANProfileRFPType.RFP42) {
                    wLANProfile.mode = OmiMessage.WLANModeType.BG;
                }
            }
        } else if (bl && wLANProfile.profileType == OmiMessage.WLANProfileRFPType.RFP42) {
            System.out.printf("Missing '%s'\n", OmiMessage.WLANProfileType.mode.name());
            wLANProfile.mode = OmiMessage.WLANModeType.BG;
        }
        if ((string = omiMessage.getAttribVal(OmiMessage.WLANProfileType.qos.name())) != null) {
            try {
                wLANProfile.qos = OmiMessage.WMEQoSType.axiValueToEnum(string);
            }
            catch (Exception exception) {
                wLANProfile.qos = OmiMessage.WMEQoSType.None;
            }
        } else if (bl) {
            System.out.printf("Missing '%s'\n", OmiMessage.WLANProfileType.qos.name());
        }
        if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.WLANProfileType.nRFPs.name())) != null) {
            wLANProfile.numberRFPs = n;
        } else if (bl) {
            System.out.printf("Missing '%s'\n", OmiMessage.WLANProfileType.nRFPs.name());
        }
        OmiMessage omiMessage2 = omiMessage.getSubElement();
        int n2 = 0;
        if (!bl2) {
            for (int i = 0; i < 4; ++i) {
                wLANProfile.ssidProfiles[i] = null;
            }
        }
        while (omiMessage2 != null && n2 < 4) {
            switch (omiMessage2.id) {
                case ssid1: {
                    wLANProfile.ssidProfiles[0] = this.parseSSID(omiMessage2, wLANProfile.ssidProfiles[0]);
                    ++n2;
                    break;
                }
                case ssid2: {
                    wLANProfile.ssidProfiles[1] = this.parseSSID(omiMessage2, wLANProfile.ssidProfiles[1]);
                    ++n2;
                    break;
                }
                case ssid3: {
                    wLANProfile.ssidProfiles[2] = this.parseSSID(omiMessage2, wLANProfile.ssidProfiles[2]);
                    ++n2;
                    break;
                }
                case ssid4: {
                    wLANProfile.ssidProfiles[3] = this.parseSSID(omiMessage2, wLANProfile.ssidProfiles[3]);
                    ++n2;
                    break;
                }
            }
            omiMessage2 = omiMessage2.getNext();
        }
    }

    private SSIDProfile parseSSID(OmiMessage omiMessage, SSIDProfile sSIDProfile) {
        Boolean bl = false;
        Boolean bl2 = false;
        String string = omiMessage.getAttribVal(OmiMessage.SSIDProfileType.ssid.name());
        if (string != null) {
            if (sSIDProfile != null) {
                if (string.isEmpty()) {
                    return null;
                }
            } else {
                bl = true;
                sSIDProfile = new SSIDProfile();
            }
            sSIDProfile.ssid = string;
        } else if (sSIDProfile == null) {
            return null;
        }
        Boolean bl3 = omiMessage.getAttribValBoolNotMandatory(OmiMessage.SSIDProfileType.enable.name());
        if (bl3 != null) {
            sSIDProfile.enable = bl3;
        } else if (bl2.booleanValue()) {
            System.out.printf("Missing in new %s: '%s'\n", omiMessage.id.name(), OmiMessage.SSIDProfileType.enable.name());
        }
        Integer n = omiMessage.getAttribValIntNotMandatory(OmiMessage.SSIDProfileType.vlanTag.name());
        if (n != null) {
            sSIDProfile.vlanTag = n;
        } else {
            if (bl.booleanValue()) {
                sSIDProfile.vlanTag = 0;
            }
            if (bl2.booleanValue()) {
                System.out.printf("Missing in new %s: '%s'\n", omiMessage.id.name(), OmiMessage.SSIDProfileType.vlanTag.name());
            }
        }
        n = omiMessage.getAttribValIntNotMandatory(OmiMessage.SSIDProfileType.distributionIntval.name());
        if (n != null) {
            sSIDProfile.distributionIntval = n;
        } else if (bl2.booleanValue()) {
            System.out.printf("Missing in new %s: '%s'\n", omiMessage.id.name(), OmiMessage.SSIDProfileType.distributionIntval.name());
        }
        bl3 = omiMessage.getAttribValBoolNotMandatory(OmiMessage.SSIDProfileType.privacy.name());
        if (bl3 != null) {
            sSIDProfile.privacy = bl3;
        } else if (bl2.booleanValue()) {
            System.out.printf("Missing in new %s: '%s'\n", omiMessage.id.name(), OmiMessage.SSIDProfileType.privacy.name());
        }
        string = omiMessage.getAttribVal(OmiMessage.SSIDProfileType.wepKey1.name());
        if (string != null) {
            sSIDProfile.wepKey1 = string;
        } else if (bl2.booleanValue()) {
            System.out.printf("Missing in new %s: '%s'\n", omiMessage.id.name(), OmiMessage.SSIDProfileType.wepKey1.name());
        }
        string = omiMessage.getAttribVal(OmiMessage.SSIDProfileType.wepKey2.name());
        if (string != null) {
            sSIDProfile.wepKey2 = string.isEmpty() ? null : string;
        } else if (bl2.booleanValue()) {
            System.out.printf("Missing in new %s: '%s'\n", omiMessage.id.name(), OmiMessage.SSIDProfileType.wepKey2.name());
        }
        string = omiMessage.getAttribVal(OmiMessage.SSIDProfileType.wepKey3.name());
        if (string != null) {
            sSIDProfile.wepKey3 = string.isEmpty() ? null : string;
        } else if (bl2.booleanValue()) {
            System.out.printf("Missing in new %s: '%s'\n", omiMessage.id.name(), OmiMessage.SSIDProfileType.wepKey3.name());
        }
        string = omiMessage.getAttribVal(OmiMessage.SSIDProfileType.wepKey4.name());
        if (string != null) {
            sSIDProfile.wepKey4 = string.isEmpty() ? null : string;
        } else if (bl2.booleanValue()) {
            System.out.printf("Missing in new %s: '%s'\n", omiMessage.id.name(), OmiMessage.SSIDProfileType.wepKey4.name());
        }
        bl3 = omiMessage.getAttribValBoolNotMandatory(OmiMessage.SSIDProfileType.wepKeyHex.name());
        if (bl3 != null) {
            sSIDProfile.wepKeyHex = bl3;
        } else if (bl2.booleanValue()) {
            System.out.printf("Missing in new %s: '%s'\n", omiMessage.id.name(), OmiMessage.SSIDProfileType.wepKeyHex.name());
        }
        n = omiMessage.getAttribValIntNotMandatory(OmiMessage.SSIDProfileType.defaultWepKey.name());
        if (n != null) {
            sSIDProfile.defaultWepKey = n;
        } else if (bl2.booleanValue()) {
            System.out.printf("Missing in new %s: '%s'\n", omiMessage.id.name(), OmiMessage.SSIDProfileType.defaultWepKey.name());
        }
        string = omiMessage.getAttribVal(OmiMessage.SSIDProfileType.psk.name());
        if (string != null) {
            sSIDProfile.psk = string;
        } else if (bl2.booleanValue()) {
            System.out.printf("Missing in new %s: '%s'\n", omiMessage.id.name(), OmiMessage.SSIDProfileType.psk.name());
        }
        bl3 = omiMessage.getAttribValBoolNotMandatory(OmiMessage.SSIDProfileType.pskHex.name());
        if (bl3 != null) {
            sSIDProfile.pskHex = bl3;
        } else if (bl2.booleanValue()) {
            System.out.printf("Missing in new %s: '%s'\n", omiMessage.id.name(), OmiMessage.SSIDProfileType.pskHex.name());
        }
        bl3 = omiMessage.getAttribValBoolNotMandatory(OmiMessage.SSIDProfileType.useRadius.name());
        if (bl3 != null) {
            sSIDProfile.useRadius = bl3;
        } else if (bl2.booleanValue()) {
            System.out.printf("Missing in new %s: '%s'\n", omiMessage.id.name(), OmiMessage.SSIDProfileType.useRadius.name());
        }
        string = omiMessage.getAttribVal(OmiMessage.SSIDProfileType.radiusAddr.name());
        if (string != null) {
            sSIDProfile.radiusAddr = string;
        } else if (bl2.booleanValue()) {
            System.out.printf("Missing in new %s: '%s'\n", omiMessage.id.name(), OmiMessage.SSIDProfileType.radiusAddr.name());
        }
        n = omiMessage.getAttribValIntNotMandatory(OmiMessage.SSIDProfileType.radiusPort.name());
        if (n != null) {
            sSIDProfile.radiusPort = n;
        } else if (bl2.booleanValue()) {
            System.out.printf("Missing in new %s: '%s'\n", omiMessage.id.name(), OmiMessage.SSIDProfileType.radiusPort.name());
        }
        string = omiMessage.getAttribVal(OmiMessage.SSIDProfileType.radiusSecret.name());
        if (string != null) {
            sSIDProfile.radiusSecret = string;
        } else if (bl2.booleanValue()) {
            System.out.printf("Missing in new %s: '%s'\n", omiMessage.id.name(), OmiMessage.SSIDProfileType.radiusSecret.name());
        }
        bl3 = omiMessage.getAttribValBoolNotMandatory(OmiMessage.SSIDProfileType.bssIsolation.name());
        if (bl3 != null) {
            sSIDProfile.bssIsolation = bl3;
        } else if (bl2.booleanValue()) {
            System.out.printf("Missing in new %s: '%s'\n", omiMessage.id.name(), OmiMessage.SSIDProfileType.bssIsolation.name());
        }
        bl3 = omiMessage.getAttribValBoolNotMandatory(OmiMessage.SSIDProfileType.useACL.name());
        if (bl3 != null) {
            sSIDProfile.useACL = bl3;
        } else if (bl2.booleanValue()) {
            System.out.printf("Missing in new %s: '%s'\n", omiMessage.id.name(), OmiMessage.SSIDProfileType.useACL.name());
        }
        bl3 = omiMessage.getAttribValBoolNotMandatory(OmiMessage.SSIDProfileType.hiddenSSID.name());
        if (bl3 != null) {
            sSIDProfile.hiddenSSID = bl3;
        } else if (bl2.booleanValue()) {
            System.out.printf("Missing in new %s: '%s'\n", omiMessage.id.name(), OmiMessage.SSIDProfileType.hiddenSSID.name());
        }
        string = omiMessage.getAttribVal(OmiMessage.SSIDProfileType.keyLength.name());
        if (string != null) {
            try {
                sSIDProfile.keyLength = OmiMessage.WEPKeyLengthType.axiValueToEnum(omiMessage.getAttribVal(OmiMessage.SSIDProfileType.keyLength.name()));
            }
            catch (Exception exception) {
                System.out.printf("%s - '%s' wrong value: '%s'\n", omiMessage.id.name(), OmiMessage.SSIDProfileType.keyLength.name(), string);
            }
        } else if (bl2.booleanValue()) {
            System.out.printf("Missing in new %s: '%s'\n", omiMessage.id.name(), OmiMessage.SSIDProfileType.keyLength.name());
        }
        if ((string = omiMessage.getAttribVal(OmiMessage.SSIDProfileType.security.name())) != null) {
            try {
                sSIDProfile.security = OmiMessage.WLANSecurityType.valueOf(string);
            }
            catch (Exception exception) {
                System.out.printf("%s - '%s' wrong value: '%s'\n", omiMessage.id.name(), OmiMessage.SSIDProfileType.security.name(), string);
            }
        } else if (bl2.booleanValue()) {
            System.out.printf("Missing in new %s: '%s'\n", omiMessage.id.name(), OmiMessage.SSIDProfileType.security.name());
        }
        if ((string = omiMessage.getAttribVal(OmiMessage.SSIDProfileType.wpaType.name())) != null) {
            try {
                sSIDProfile.wpaType = OmiMessage.WPATypeType.valueOf(string);
            }
            catch (Exception exception) {
                System.out.printf("%s - '%s' wrong value: '%s'\n", omiMessage.id.name(), OmiMessage.SSIDProfileType.wpaType.name(), string);
            }
        } else if (bl2.booleanValue()) {
            System.out.printf("Missing in new %s: '%s'\n", omiMessage.id.name(), OmiMessage.SSIDProfileType.wpaType.name());
        }
        return sSIDProfile;
    }

    private void profileObjectToElem(WLANProfile wLANProfile, OmiMessage omiMessage, boolean bl) {
        if (bl) {
            omiMessage.addAttrib(OmiMessage.WLANProfileType.id.name(), wLANProfile.id);
        }
        if (wLANProfile.profileType != null) {
            omiMessage.addAttrib(OmiMessage.WLANProfileType.profileType.name(), wLANProfile.profileType.name());
        }
        if (wLANProfile.enable != null) {
            omiMessage.addAttrib(OmiMessage.WLANProfileType.enable.name(), wLANProfile.enable);
        }
        if (wLANProfile.beaconInterval != null) {
            omiMessage.addAttrib(OmiMessage.WLANProfileType.beaconIntval.name(), wLANProfile.beaconInterval);
        }
        if (wLANProfile.dtimInterval != null) {
            omiMessage.addAttrib(OmiMessage.WLANProfileType.dtimIntval.name(), wLANProfile.dtimInterval);
        }
        if (wLANProfile.rtsThreshold != null) {
            omiMessage.addAttrib(OmiMessage.WLANProfileType.rtsThreshold.name(), wLANProfile.rtsThreshold);
        }
        if (wLANProfile.fragThreshold != null) {
            omiMessage.addAttrib(OmiMessage.WLANProfileType.fragThreshold.name(), wLANProfile.fragThreshold);
        }
        if (wLANProfile.interferenceAvoidance == OmiMessage.GenericNoneInactiveActiveType.inactive) {
            omiMessage.addAttrib(OmiMessage.WLANProfileType.interferenceAvoidance.name(), false);
        } else if (wLANProfile.interferenceAvoidance == OmiMessage.GenericNoneInactiveActiveType.active) {
            omiMessage.addAttrib(OmiMessage.WLANProfileType.interferenceAvoidance.name(), true);
        }
        if (wLANProfile.maxRate != null) {
            omiMessage.addAttrib(OmiMessage.WLANProfileType.maxRate.name(), wLANProfile.maxRate.getAxiVal());
        }
        if (wLANProfile.mode != null) {
            omiMessage.addAttrib(OmiMessage.WLANProfileType.mode.name(), wLANProfile.mode.name());
        }
        if (wLANProfile.qos != null) {
            omiMessage.addAttrib(OmiMessage.WLANProfileType.qos.name(), wLANProfile.qos.getAxiVal());
        }
        OmiMessage omiMessage2 = null;
        for (int i = 0; i < 4; ++i) {
            if (wLANProfile.ssidProfiles[i] == null) continue;
            SSIDProfile sSIDProfile = wLANProfile.ssidProfiles[i];
            OmiMessage.elemIds elemIds2 = OmiMessage.elemIds.ssid1;
            switch (i) {
                case 0: {
                    elemIds2 = OmiMessage.elemIds.ssid1;
                    break;
                }
                case 1: {
                    elemIds2 = OmiMessage.elemIds.ssid2;
                    break;
                }
                case 2: {
                    elemIds2 = OmiMessage.elemIds.ssid3;
                    break;
                }
                case 3: {
                    elemIds2 = OmiMessage.elemIds.ssid4;
                }
            }
            omiMessage2 = omiMessage2 == null ? omiMessage.addSubElement(elemIds2) : omiMessage2.addElement(elemIds2);
            if (sSIDProfile.enable != null) {
                omiMessage2.addAttrib(OmiMessage.SSIDProfileType.enable.name(), sSIDProfile.enable);
            }
            if (sSIDProfile.ssid != null) {
                omiMessage2.addAttrib(OmiMessage.SSIDProfileType.ssid.name(), sSIDProfile.ssid);
            }
            if (sSIDProfile.security != null) {
                omiMessage2.addAttrib(OmiMessage.SSIDProfileType.security.name(), sSIDProfile.security.name());
            }
            if (sSIDProfile.vlanTag != null) {
                omiMessage2.addAttrib(OmiMessage.SSIDProfileType.vlanTag.name(), sSIDProfile.vlanTag);
            }
            if (sSIDProfile.distributionIntval != null) {
                omiMessage2.addAttrib(OmiMessage.SSIDProfileType.distributionIntval.name(), sSIDProfile.distributionIntval);
            }
            if (sSIDProfile.privacy != null) {
                omiMessage2.addAttrib(OmiMessage.SSIDProfileType.privacy.name(), sSIDProfile.privacy);
            }
            if (sSIDProfile.wepKey1 != null) {
                omiMessage2.addAttrib(OmiMessage.SSIDProfileType.wepKey1.name(), sSIDProfile.wepKey1);
            }
            if (sSIDProfile.wepKey2 != null) {
                omiMessage2.addAttrib(OmiMessage.SSIDProfileType.wepKey2.name(), sSIDProfile.wepKey2);
            }
            if (sSIDProfile.wepKey3 != null) {
                omiMessage2.addAttrib(OmiMessage.SSIDProfileType.wepKey3.name(), sSIDProfile.wepKey3);
            }
            if (sSIDProfile.wepKey4 != null) {
                omiMessage2.addAttrib(OmiMessage.SSIDProfileType.wepKey4.name(), sSIDProfile.wepKey4);
            }
            if (sSIDProfile.defaultWepKey != null) {
                omiMessage2.addAttrib(OmiMessage.SSIDProfileType.defaultWepKey.name(), sSIDProfile.defaultWepKey);
            }
            if (sSIDProfile.wepKeyHex != null) {
                omiMessage2.addAttrib(OmiMessage.SSIDProfileType.wepKeyHex.name(), sSIDProfile.wepKeyHex);
            }
            if (sSIDProfile.wpaType != null) {
                omiMessage2.addAttrib(OmiMessage.SSIDProfileType.wpaType.name(), sSIDProfile.wpaType.name());
            }
            if (sSIDProfile.psk != null) {
                omiMessage2.addAttrib(OmiMessage.SSIDProfileType.psk.name(), sSIDProfile.psk);
            }
            if (sSIDProfile.pskHex != null) {
                omiMessage2.addAttrib(OmiMessage.SSIDProfileType.pskHex.name(), sSIDProfile.pskHex);
            }
            if (sSIDProfile.useRadius != null) {
                omiMessage2.addAttrib(OmiMessage.SSIDProfileType.useRadius.name(), sSIDProfile.useRadius);
            }
            if (sSIDProfile.radiusAddr != null) {
                omiMessage2.addAttrib(OmiMessage.SSIDProfileType.radiusAddr.name(), sSIDProfile.radiusAddr);
            }
            if (sSIDProfile.radiusPort != null) {
                omiMessage2.addAttrib(OmiMessage.SSIDProfileType.radiusPort.name(), sSIDProfile.radiusPort);
            }
            if (sSIDProfile.radiusSecret != null) {
                omiMessage2.addAttrib(OmiMessage.SSIDProfileType.radiusSecret.name(), sSIDProfile.radiusSecret);
            }
            if (sSIDProfile.keyLength != null) {
                omiMessage2.addAttrib(OmiMessage.SSIDProfileType.keyLength.name(), sSIDProfile.keyLength.getAxiVal());
            }
            if (sSIDProfile.bssIsolation != null) {
                omiMessage2.addAttrib(OmiMessage.SSIDProfileType.bssIsolation.name(), sSIDProfile.bssIsolation);
            }
            if (sSIDProfile.useACL != null) {
                omiMessage2.addAttrib(OmiMessage.SSIDProfileType.useACL.name(), sSIDProfile.useACL);
            }
            if (sSIDProfile.hiddenSSID == null) continue;
            omiMessage2.addAttrib(OmiMessage.SSIDProfileType.hiddenSSID.name(), sSIDProfile.hiddenSSID);
        }
    }

    private boolean processProfileElem(OmiMessage omiMessage, DataNotificationEnum dataNotificationEnum, boolean bl) {
        if (omiMessage.id == OmiMessage.elemIds.profile) {
            WLANProfile wLANProfile = null;
            int n = omiMessage.getAttribValInt(OmiMessage.WLANProfileType.id.name());
            boolean bl2 = false;
            wLANProfile = this.profileDb.getRecordById(n);
            if (wLANProfile == null) {
                wLANProfile = new WLANProfile();
                bl2 = true;
                wLANProfile.setDefaults();
            }
            this.profileElemToObject(omiMessage, wLANProfile, bl2, bl);
            this.profileDb.addProfile(wLANProfile);
            this.GenerateDataNotification(wLANProfile.id, dataNotificationEnum);
            return true;
        }
        return false;
    }

    private void processGetWLANProfileResp(OmiMessage omiMessage) {
        for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
            if (omiMessage2.id != OmiMessage.elemIds.profile) continue;
            WLANProfile wLANProfile = new WLANProfile();
            wLANProfile.setDefaults();
            this.profileElemToObject(omiMessage2, wLANProfile, true, false);
            this.profileDb.addProfile(wLANProfile);
            this.sendGetACLEntries(wLANProfile.id, 20, null);
            this.GenerateDataNotification(wLANProfile.id, DataNotificationEnum.NEW_DATA);
        }
        this.GenerateDataNotification(this.profileDb.getRecordNumber(), DataNotificationEnum.DATA_BULK_READY);
    }

    @Override
    public void processOmiMessage(OmiMessage omiMessage) {
        String string = null;
        switch (omiMessage.id) {
            case GetWLANProfileResp: {
                this.processGetWLANProfileResp(omiMessage);
                break;
            }
            case CreateWLANProfileResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    this.GenerateErrorNotification(-1, DataNotificationEnum.NEW_DATA, omiMessage);
                    break;
                }
                OmiMessage omiMessage2 = omiMessage.getSubElement();
                if (omiMessage2 != null && this.processProfileElem(omiMessage2, DataNotificationEnum.NEW_DATA, false)) break;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "CreateWLANProfileResp no profile elem");
                break;
            }
            case DeleteWLANProfileResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    int n = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
                    this.GenerateErrorNotification(n, DataNotificationEnum.DATA_DELETED, omiMessage);
                    break;
                }
                int n = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
                this.profileDb.getRecordById(n).clearAllACLEntries();
                this.GenerateACLDataNotification(n, DataNotificationEnum.DATA_DELETED_ALL, null);
                this.profileDb.deleteProfile(n);
                this.GenerateDataNotification(n, DataNotificationEnum.DATA_DELETED);
                break;
            }
            case SetWLANProfileResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    int n = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
                    this.GenerateErrorNotification(n, DataNotificationEnum.DATA_CHANGED, omiMessage);
                    break;
                }
                OmiMessage omiMessage3 = omiMessage.getSubElement();
                if (omiMessage3 != null && this.processProfileElem(omiMessage3, DataNotificationEnum.DATA_CHANGED, false)) break;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "SetWLANProfileResp no profile elem");
                break;
            }
            case EventWLANProfileCnf: {
                int n = omiMessage.getAttribValInt(OmiMessage.attribIds.deleted.name());
                OmiMessage omiMessage4 = omiMessage.getSubElement();
                if (omiMessage4 != null && omiMessage4.id == OmiMessage.elemIds.profile) {
                    int n2 = omiMessage4.getAttribValInt(OmiMessage.WLANProfileType.id.name());
                    if (n == 1) {
                        this.profileDb.deleteProfile(n2);
                        this.GenerateDataNotification(n2, DataNotificationEnum.DATA_DELETED);
                        break;
                    }
                    if (this.profileDb.getRecordById(n2) != null) {
                        this.processProfileElem(omiMessage4, DataNotificationEnum.DATA_CHANGED, true);
                        break;
                    }
                    this.processProfileElem(omiMessage4, DataNotificationEnum.NEW_DATA, true);
                    break;
                }
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "EventWLANProfileResp no profile elem");
                break;
            }
            case GetACLEntryResp: 
            case CreateACLEntryResp: 
            case SetACLEntryResp: 
            case DeleteACLEntryResp: 
            case EventACLCnf: {
                this.processACLMessage(omiMessage);
                break;
            }
        }
    }

    @Override
    public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
        if (omiManagementEventEnum == OmiManagementEventEnum.LINK_READY) {
            this.profileDb.clearAll();
            this.GenerateDataNotification(0, DataNotificationEnum.DATA_DELETED_ALL);
            OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.WLANProfileCnf, null, null);
            OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.ACLCnf, null, null);
            this.sendGetWLANProfileBulk(1, 20);
        }
    }

    public int sendCreateWLANProfile(WLANProfile wLANProfile) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.CreateWLANProfile);
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), 0);
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.profile);
        this.profileObjectToElem(wLANProfile, omiMessage2, false);
        this.omiHandler.sendOmiMessage(omiMessage);
        return 0;
    }

    public int sendSetWLANProfile(WLANProfile wLANProfile) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.SetWLANProfile);
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), wLANProfile.id);
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.profile);
        this.profileObjectToElem(wLANProfile, omiMessage2, true);
        this.omiHandler.sendOmiMessage(omiMessage);
        return wLANProfile.id;
    }

    public int sendDeleteProfile(WLANProfile wLANProfile) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.DeleteWLANProfile);
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), wLANProfile.id);
        omiMessage.addAttrib(OmiMessage.WLANProfileType.id.name(), wLANProfile.id);
        this.omiHandler.sendOmiMessage(omiMessage);
        return wLANProfile.id;
    }

    public void sendCreateACLEntry(ACLEntry aCLEntry, int n) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.CreateACLEntry);
        omiMessage.addAttrib(OmiMessage.attribIds.wlanProfile.name(), n);
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.entry);
        omiMessage2.addAttrib(OmiMessage.ACLEntryType.ethAddr.name(), aCLEntry.ethAddr);
        if (aCLEntry.name != null) {
            omiMessage2.addAttrib(OmiMessage.ACLEntryType.name.name(), aCLEntry.name);
        }
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendChangeACLEntry(ACLEntry aCLEntry, int n) {
        if (aCLEntry.name == null) {
            return;
        }
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.SetACLEntry);
        omiMessage.addAttrib(OmiMessage.attribIds.wlanProfile.name(), n);
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.entry);
        omiMessage2.addAttrib(OmiMessage.ACLEntryType.ethAddr.name(), aCLEntry.ethAddr);
        omiMessage2.addAttrib(OmiMessage.ACLEntryType.name.name(), aCLEntry.name);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendDeleteACLEntry(ACLEntry aCLEntry, int n) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.DeleteACLEntry);
        omiMessage.addAttrib(OmiMessage.attribIds.wlanProfile.name(), n);
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.entry);
        omiMessage2.addAttrib(OmiMessage.ACLEntryType.ethAddr.name(), aCLEntry.ethAddr);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendDeleteAllACLEntry(int n) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.DeleteACLEntry);
        omiMessage.addAttrib(OmiMessage.attribIds.wlanProfile.name(), n);
        omiMessage.addAttrib(OmiMessage.attribIds.deleteAll.name(), 1);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public static interface WLANProfileACLDataNotificationInterface {
        public void processWLANProfileACLDataNotification(int var1, DataNotificationEnum var2, String var3);

        public void processWLANProfileACLErrorNotification(int var1, DataNotificationEnum var2, OmiMessage var3);
    }

    public static interface WLANProfileDataNotificationInterface {
        public void processWLANProfileDataNotification(int var1, DataNotificationEnum var2);

        public void processWLANProfileErrorNotification(int var1, DataNotificationEnum var2, OmiMessage var3);
    }

    public static class WLANProfileDatabase
    extends Database {
        public static final int MAX_PROFILES = 20;
        public static final int FIRST_PROFILE_ID = 1;
        WLANProfile[] profiles = new WLANProfile[20];
        int[] profileIdx = new int[20];
        int noOfProfiles = 0;

        @Override
        public DataRecord getRecordByIdx(int n) {
            if (n >= 0 && n < this.noOfProfiles) {
                return this.profiles[this.profileIdx[n]];
            }
            return null;
        }

        public WLANProfile getRecordById(int n) {
            if (n > 0 && n <= 20) {
                return this.profiles[n - 1];
            }
            return null;
        }

        @Override
        public int getRecordNumber() {
            return this.noOfProfiles;
        }

        @Override
        public void updateIndex() {
            this.noOfProfiles = 0;
            for (int i = 0; i < 20; ++i) {
                if (this.profiles[i] == null) continue;
                this.profileIdx[this.noOfProfiles++] = i;
            }
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }

        public void addProfile(WLANProfile wLANProfile) {
            this.profiles[wLANProfile.id - 1] = wLANProfile;
            this.updateIndex();
        }

        public void deleteProfile(int n) {
            this.profiles[n - 1] = null;
            this.updateIndex();
        }

        private void clearAll() {
            for (int i = 0; i < this.noOfProfiles; ++i) {
                if (this.profiles[this.profileIdx[i]] == null) continue;
                this.profiles[this.profileIdx[i]].clearAllACLEntries();
                this.profiles[this.profileIdx[i]] = null;
            }
            this.noOfProfiles = 0;
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }

        public String[] getFieldNameArray() {
            return WLANProfile.getFieldNames();
        }

        @Override
        public String[] getFieldNames() {
            return WLANProfile.getFieldNames();
        }
    }

    public static class WLANProfile
    extends DataRecord {
        public static final int MAX_SSID_PROFILES = 4;
        public static final int MAX_ACL_ENTRIES = 512;
        public static final int IDX_ID = 0;
        public static final int IDX_ENABLE = 1;
        public static final int IDX_PROFILE_TYPE = 2;
        public static final int IDX_BEACON_INTERVAL = 3;
        public static final int IDX_DTIM_INTERVAL = 4;
        public static final int IDX_RTS_THRESHOLD = 5;
        public static final int IDX_FRAG_THRESHOLD = 6;
        public static final int IDX_INTERFERENCE_AVOIDANCE = 7;
        public static final int IDX_MAX_RATE = 8;
        public static final int IDX_MODE = 9;
        public static final int IDX_QOS = 10;
        public static final int IDX_SSID1 = 11;
        public static final int IDX_SSID2 = 12;
        public static final int IDX_SSID3 = 13;
        public static final int IDX_SSID4 = 14;
        public static final int IDX_SECURITY = 15;
        public static final int IDX_NUMBER_RFPS = 16;
        public static final int NUMBER_OF_FIELDS = 17;
        public int id;
        public Boolean enable;
        public Integer beaconInterval = null;
        public Integer dtimInterval = null;
        public Integer rtsThreshold = null;
        public Integer fragThreshold = null;
        public OmiMessage.GenericNoneInactiveActiveType interferenceAvoidance;
        public OmiMessage.WLANMaxRateType maxRate = null;
        public OmiMessage.WLANModeType mode = null;
        public OmiMessage.WMEQoSType qos = null;
        public OmiMessage.WLANProfileRFPType profileType = null;
        public SSIDProfile[] ssidProfiles = new SSIDProfile[4];
        public Integer numberRFPs;
        private static String[] fieldNames = new String[]{"id", "enabled", "profile type", "beacon int.", "DTIM int.", "RTS threshold", "frag. threshold", "interf. avoid.", "max rate", "mode", "qos", "SSID1", "SSID2", "SSID3", "SSID4", "Security", "nb RFPs"};

        public WLANProfile() {
        }

        public WLANProfile(int n) {
            this.id = n;
        }

        public void setDefaults() {
            this.enable = false;
            this.beaconInterval = 100;
            this.dtimInterval = 5;
            this.rtsThreshold = 2347;
            this.fragThreshold = 2346;
            this.interferenceAvoidance = OmiMessage.GenericNoneInactiveActiveType.none;
            this.maxRate = null;
            this.mode = OmiMessage.WLANModeType.N;
            this.qos = OmiMessage.WMEQoSType.WME_DiffServ;
            this.profileType = OmiMessage.WLANProfileRFPType.RFP43;
            this.numberRFPs = 0;
        }

        public static void setTableHeaderText(int n, String string) {
            if (n >= 0 && n < 17) {
                WLANProfile.fieldNames[n] = string;
            }
        }

        public static String[] getFieldNames() {
            return fieldNames;
        }

        @Override
        public Object getField(int n) {
            switch (n) {
                case 0: {
                    return this.id;
                }
                case 1: {
                    return this.enable;
                }
                case 2: {
                    return this.profileType;
                }
                case 3: {
                    return this.beaconInterval;
                }
                case 4: {
                    return this.dtimInterval;
                }
                case 5: {
                    return this.rtsThreshold;
                }
                case 6: {
                    return this.fragThreshold;
                }
                case 7: {
                    return this.interferenceAvoidance;
                }
                case 8: {
                    if (this.maxRate == null) {
                        return "";
                    }
                    return this.maxRate;
                }
                case 9: {
                    return this.mode;
                }
                case 10: {
                    return this.qos;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    if (this.ssidProfiles[n - 11] == null) {
                        return "";
                    }
                    return this.ssidProfiles[n - 11].ssid;
                }
                case 16: {
                    return this.numberRFPs;
                }
            }
            return null;
        }

        public boolean addACLEntry(ACLEntry aCLEntry) {
            if (aclDb[this.id - 1] == null) {
                aclDb[this.id - 1] = new ACLDatabase();
            }
            if (aclDb[this.id - 1].getRecordNumber() < 512) {
                aclDb[this.id - 1].addAclEntry(aCLEntry);
                return true;
            }
            return false;
        }

        public boolean setACLEntry(ACLEntry aCLEntry) {
            if (aclDb[this.id - 1] != null) {
                aclDb[this.id - 1].setAclEntry(aCLEntry);
                return true;
            }
            return false;
        }

        public void deleteACLEntry(String string) {
            aclDb[this.id - 1].deleteAclEntry(string);
        }

        private ACLEntry getACLEntry(String string) {
            if (aclDb[this.id - 1] != null) {
                return aclDb[this.id - 1].getRecordByEthAddr(string);
            }
            return null;
        }

        public void clearAllACLEntries() {
            if (aclDb[this.id - 1] != null) {
                aclDb[this.id - 1].clearAll();
            }
        }
    }

    public static class ACLDatabase
    extends Database {
        public static final int MAX_ACL_ENTRIES = 512;
        public static final int ACL_ENTRIES_BULK_CNT = 20;
        ACLEntry[] aclEntries = new ACLEntry[512];
        int[] aclEntryIdx = new int[512];
        int noOfAclEntries = 0;

        @Override
        public DataRecord getRecordByIdx(int n) {
            if (n >= 0 && n < this.noOfAclEntries) {
                return this.aclEntries[this.aclEntryIdx[n]];
            }
            return null;
        }

        public ACLEntry getRecordByEthAddr(String string) {
            for (int i = 0; i < this.noOfAclEntries; ++i) {
                if (!this.aclEntries[this.aclEntryIdx[i]].ethAddr.equals(string)) continue;
                return this.aclEntries[this.aclEntryIdx[i]];
            }
            return null;
        }

        @Override
        public int getRecordNumber() {
            return this.noOfAclEntries;
        }

        @Override
        public void updateIndex() {
            this.noOfAclEntries = 0;
            for (int i = 0; i < 512; ++i) {
                if (this.aclEntries[i] == null) continue;
                this.aclEntryIdx[this.noOfAclEntries++] = i;
            }
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }

        public void addAclEntry(ACLEntry aCLEntry) {
            for (int i = 0; i < 512; ++i) {
                if (this.aclEntries[i] != null) continue;
                this.aclEntries[i] = aCLEntry;
                this.updateIndex();
                return;
            }
        }

        public void setAclEntry(ACLEntry aCLEntry) {
            int n;
            for (n = 0; n < this.noOfAclEntries; ++n) {
                if (!this.aclEntries[this.aclEntryIdx[n]].ethAddr.equals(aCLEntry.ethAddr)) continue;
                this.aclEntries[this.aclEntryIdx[n]] = aCLEntry;
                this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
                return;
            }
            for (n = 0; n < 512; ++n) {
                if (this.aclEntries[n] != null) continue;
                this.aclEntries[n] = aCLEntry;
                this.updateIndex();
                return;
            }
        }

        public void deleteAclEntry(String string) {
            for (int i = 0; i < this.noOfAclEntries; ++i) {
                if (!this.aclEntries[this.aclEntryIdx[i]].ethAddr.equals(string)) continue;
                this.aclEntries[this.aclEntryIdx[i]] = null;
                this.updateIndex();
                return;
            }
        }

        public void clearAll() {
            for (int i = 0; i < this.noOfAclEntries; ++i) {
                this.aclEntries[this.aclEntryIdx[i]] = null;
            }
            this.noOfAclEntries = 0;
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }

        public String[] getFieldNameArray() {
            return ACLEntry.getFieldNames();
        }

        @Override
        public String[] getFieldNames() {
            return ACLEntry.getFieldNames();
        }
    }

    public static class ACLEntry
    extends DataRecord {
        public static final int IDX_ETH_ADDR = 0;
        public static final int IDX_NAME = 1;
        public static final int NUMBER_OF_FIELDS = 2;
        private static String[] fieldNames = new String[]{"MAC address", "name"};
        public String ethAddr;
        public String name;

        public static void setTableHeaderText(int n, String string) {
            if (n >= 0 && n < 2) {
                ACLEntry.fieldNames[n] = string;
            }
        }

        public static String[] getFieldNames() {
            return fieldNames;
        }

        @Override
        public Object getField(int n) {
            switch (n) {
                case 0: {
                    return this.ethAddr;
                }
                case 1: {
                    if (this.name == null) {
                        return "";
                    }
                    return this.name;
                }
            }
            return null;
        }
    }

    public static class SSIDProfile {
        public static final String radiusAddrDefault = "0.0.0.0";
        public static final int radiusPortDefault = 1812;
        public static final int PRE_SHARED_KEY_TEXT_LEN_MIN = 8;
        public static final int PRE_SHARED_KEY_TEXT_LEN_MAX = 63;
        public static final int PRE_SHARED_KEY_HEX_LEN = 64;
        public Boolean enable;
        public String ssid;
        public Integer vlanTag;
        public OmiMessage.WLANSecurityType security;
        public Integer distributionIntval = null;
        public Boolean privacy;
        public String wepKey1;
        public String wepKey2;
        public String wepKey3;
        public String wepKey4;
        public Integer defaultWepKey;
        public Boolean wepKeyHex;
        public OmiMessage.WPATypeType wpaType;
        public String psk;
        public Boolean pskHex;
        public Boolean useRadius;
        public String radiusAddr;
        public Integer radiusPort;
        public String radiusSecret;
        public OmiMessage.WEPKeyLengthType keyLength;
        public Boolean bssIsolation;
        public Boolean useACL;
        public Boolean hiddenSSID;
    }
}

