/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib.mom;

import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.OmiHandler;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;
import com.aastra.util.UtilSpy;
import java.util.LinkedList;

public class MomOmmHandler
implements OmiManagementEventInterface,
OmiMessageInterface {
    private static final int MAX_BULK_RECORDS = 20;
    public static final int INVALID_MOM_OMM_ID = 0;
    private MomOmmDatabase ommDb = new MomOmmDatabase();
    private OmiManagement om = null;
    private OmiHandler omiHandler = null;
    private boolean getBulkInProgress = false;
    private LinkedList<MomOmmDataNotificationInterface> listenerList = new LinkedList();

    public MomOmmHandler(OmiManagement omiManagement) {
        this.om = omiManagement;
        this.omiHandler = this.om.getOmiHandler();
        this.om.registerManagementEventListener(this);
        OmiMessage.elemIds.GetOMMResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.CreateOMMResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetOMMResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.DeleteOMMResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventOMMCnf.registerDataNotificationListener(this);
    }

    public void registerDataNotificationListener(MomOmmDataNotificationInterface momOmmDataNotificationInterface) {
        this.listenerList.add(momOmmDataNotificationInterface);
    }

    public void deregisterDataNotificationListener(MomOmmDataNotificationInterface momOmmDataNotificationInterface) {
        this.listenerList.remove(momOmmDataNotificationInterface);
    }

    private void GenerateDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating mom omm notification: No listener");
        }
        for (MomOmmDataNotificationInterface momOmmDataNotificationInterface : this.listenerList) {
            if (momOmmDataNotificationInterface == null) continue;
            momOmmDataNotificationInterface.processMomOmmDataNotification(n, dataNotificationEnum);
        }
    }

    public Database getDb() {
        return this.ommDb;
    }

    public void sendGetOmm(int n) {
        this.sendGetOmmBulk(n, 1);
    }

    public void sendGetOmmBulk(int n, int n2) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetOMM);
        omiMessage.addAttrib(OmiMessage.attribIds.id.name(), n);
        omiMessage.addAttrib(OmiMessage.attribIds.maxRecords.name(), n2);
        this.omiHandler.sendOmiMessage(omiMessage);
        if (n2 > 1) {
            this.getBulkInProgress = true;
        }
    }

    public void sendCreateOmm(MomOmmRecord momOmmRecord) {
        UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "sendCreateOmm not implemented");
    }

    public void sendSetOmm(MomOmmRecord momOmmRecord) {
        UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "sendSetOmm not implemented");
    }

    public void sendDeleteOmm(int n) {
        UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "sendDeleteOmm not implemented");
    }

    private int processGetOmmResp(OmiMessage omiMessage) {
        MomOmmRecord momOmmRecord;
        int n = 0;
        for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
            if (!this.processOmmElem(omiMessage2, DataNotificationEnum.NEW_DATA)) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "GetOmmResp no OMMType elem");
                continue;
            }
            ++n;
        }
        if (n == 20 && (momOmmRecord = (MomOmmRecord)this.ommDb.getRecordByIdx(this.ommDb.getRecordNumber() - 1)) != null) {
            return (Integer)momOmmRecord.getField(0);
        }
        return 0;
    }

    private boolean processOmmElem(OmiMessage omiMessage, DataNotificationEnum dataNotificationEnum) {
        Boolean bl;
        String string;
        if (omiMessage.id != OmiMessage.elemIds.omm) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "processOmmElem: found invalid sub element");
            return false;
        }
        int n = omiMessage.getAttribValInt(OmiMessage.OMMType.id.name());
        MomOmmRecord momOmmRecord = this.ommDb.getRecordById(n);
        if (momOmmRecord == null) {
            momOmmRecord = new MomOmmRecord(n);
            if (dataNotificationEnum == DataNotificationEnum.DATA_CHANGED) {
                dataNotificationEnum = DataNotificationEnum.NEW_DATA;
            }
        }
        if ((string = omiMessage.getAttribVal(OmiMessage.OMMType.name.name())) != null) {
            momOmmRecord.name = string;
        }
        if ((string = omiMessage.getAttribVal(OmiMessage.OMMType.desc.name())) != null) {
            momOmmRecord.desc = string;
        }
        if ((string = omiMessage.getAttribVal(OmiMessage.OMMType.domain1.name())) != null) {
            momOmmRecord.domain1 = string;
        }
        if ((string = omiMessage.getAttribVal(OmiMessage.OMMType.domain2.name())) != null) {
            momOmmRecord.domain2 = string;
        }
        if ((string = omiMessage.getAttribVal(OmiMessage.OMMType.username.name())) != null) {
            momOmmRecord.username = string;
        }
        if ((string = omiMessage.getAttribVal(OmiMessage.OMMType.password.name())) != null) {
            momOmmRecord.password = string;
        }
        if ((string = omiMessage.getAttribVal(OmiMessage.OMMType.cloudId.name())) != null) {
            momOmmRecord.cloudId = string;
        }
        if ((bl = Boolean.valueOf(omiMessage.getAttribValBool(OmiMessage.OMMType.enable.name()))) != null) {
            momOmmRecord.enable = bl;
        }
        if ((bl = Boolean.valueOf(omiMessage.getAttribValBool(OmiMessage.OMMType.ommProvisioning.name()))) != null) {
            momOmmRecord.ommProvisioning = bl;
        }
        if ((bl = Boolean.valueOf(omiMessage.getAttribValBool(OmiMessage.OMMType.connected.name()))) != null) {
            momOmmRecord.connected = bl;
        }
        if ((string = omiMessage.getAttribVal(OmiMessage.URLType.sslMethod.name())) != null) {
            momOmmRecord.sslMethod = OmiMessage.SslMethodType.protocolValueToEnum(string);
        }
        if ((bl = Boolean.valueOf(omiMessage.getAttribValBool(OmiMessage.OMMType.validateCerts.name()))) != null) {
            momOmmRecord.validateCerts = bl;
        }
        if ((bl = Boolean.valueOf(omiMessage.getAttribValBool(OmiMessage.OMMType.validateExpires.name()))) != null) {
            momOmmRecord.validateExpires = bl;
        }
        if ((bl = Boolean.valueOf(omiMessage.getAttribValBool(OmiMessage.OMMType.validateHostName.name()))) != null) {
            momOmmRecord.validateHostName = bl;
        }
        if ((bl = Boolean.valueOf(omiMessage.getAttribValBool(OmiMessage.OMMType.allowNonConfTrustCerts.name()))) != null) {
            momOmmRecord.allowNonConfTrustCerts = bl;
        }
        if ((bl = Boolean.valueOf(omiMessage.getAttribValBool(OmiMessage.OMMType.importCerts.name()))) != null) {
            momOmmRecord.importCerts = bl;
        }
        this.ommDb.addOmm(momOmmRecord);
        this.GenerateDataNotification(n, dataNotificationEnum);
        return true;
    }

    @Override
    public void processOmiMessage(OmiMessage omiMessage) {
        switch (omiMessage.id) {
            case GetOMMResp: {
                int n = this.processGetOmmResp(omiMessage);
                if (!this.getBulkInProgress) break;
                if (n > 0) {
                    this.sendGetOmmBulk(n + 1, 20);
                    break;
                }
                this.getBulkInProgress = false;
                this.GenerateDataNotification(this.ommDb.getRecordNumber(), DataNotificationEnum.DATA_BULK_READY);
                break;
            }
            case CreateOMMResp: {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "CreateOMMResp not implemented");
                break;
            }
            case SetOMMResp: {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "SetOMMResp not implemented");
                break;
            }
            case DeleteOMMResp: {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "DeleteOMMResp not implemented");
                break;
            }
            case EventOMMCnf: {
                OmiMessage omiMessage2 = omiMessage.getSubElement();
                if (omiMessage2 != null) {
                    boolean bl = omiMessage.getAttribValBool(OmiMessage.attribIds.deleted.name());
                    if (bl) {
                        if (omiMessage2.id == OmiMessage.elemIds.omm) {
                            int n = omiMessage2.getAttribValInt(OmiMessage.OMMType.id.name());
                            this.ommDb.deleteOmm(n);
                            this.GenerateDataNotification(n, DataNotificationEnum.DATA_DELETED);
                            break;
                        }
                    } else if (this.processOmmElem(omiMessage2, DataNotificationEnum.DATA_CHANGED)) break;
                }
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "EventOMMCnf no OMMType elem");
                break;
            }
            default: {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "MomOmmHandler: received unsupported msg.id: " + (Object)((Object)omiMessage.id));
            }
        }
    }

    @Override
    public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
        if (omiManagementEventEnum == OmiManagementEventEnum.LINK_READY) {
            this.ommDb.clearAll();
            this.GenerateDataNotification(0, DataNotificationEnum.DATA_DELETED_ALL);
            OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.MOMOMMCnf, null, null);
            this.sendGetOmmBulk(1, 20);
        }
    }

    public static class MomOmmDatabase
    extends Database {
        public static final int MAX_OMMS = 500;
        MomOmmRecord[] ommArray = new MomOmmRecord[500];
        int[] ommIdx = new int[500];
        int noOfOmms = 0;

        @Override
        public int getRecordNumber() {
            return this.noOfOmms;
        }

        @Override
        public DataRecord getRecordByIdx(int n) {
            if (n >= 0 && n < this.noOfOmms) {
                return this.ommArray[this.ommIdx[n] - 1];
            }
            return null;
        }

        @Override
        public String[] getFieldNames() {
            return MomOmmRecord.getFieldNames();
        }

        @Override
        public void updateIndex() {
            this.noOfOmms = 0;
            for (int i = 1; i <= 500; ++i) {
                if (this.ommArray[i - 1] == null) continue;
                this.ommIdx[this.noOfOmms++] = i;
            }
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }

        public MomOmmRecord getRecordById(int n) {
            if (n > 0 && n <= 500) {
                return this.ommArray[n - 1];
            }
            return null;
        }

        public void addOmm(MomOmmRecord momOmmRecord) {
            if (momOmmRecord.id > 0 && momOmmRecord.id <= 500) {
                this.ommArray[momOmmRecord.id - 1] = momOmmRecord;
                this.updateIndex();
            }
        }

        public void deleteOmm(int n) {
            if (n > 0 && n <= 500) {
                this.ommArray[n - 1] = null;
                this.updateIndex();
            }
        }

        public void clearAll() {
            for (int i = 0; i < 500; ++i) {
                this.ommArray[i] = null;
            }
            this.noOfOmms = 0;
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }
    }

    public static class MomOmmRecord
    extends DataRecord {
        public static final int IDX_ID = 0;
        public static final int IDX_NAME = 1;
        public static final int IDX_DESCRIPTION = 2;
        public static final int IDX_DOMAIN_1 = 3;
        public static final int IDX_DOMAIN_2 = 4;
        public static final int IDX_USER_NAME = 5;
        public static final int IDX_PASSWORD = 6;
        public static final int IDX_CLOUD_ID = 7;
        public static final int IDX_ENABLE = 8;
        public static final int IDX_OMM_PROVISIONING = 9;
        public static final int IDX_CONNECTED = 10;
        public static final int IDX_SSL_METHOD = 11;
        public static final int IDX_VALIDATE_CERTS = 12;
        public static final int IDX_VALIDATE_EXPIRES = 13;
        public static final int IDX_VALIDATE_HOST_NAME = 14;
        public static final int IDX_ALLOW_NON_CONF_TRUST_CERTS = 15;
        public static final int IDX_IMPORT_CERTS = 16;
        public static final int NUMBER_OF_FIELDS = 17;
        private static String[] fieldNames = new String[]{"id", "name", "description", "domain1", "doamain2", "user name", "password", "clouid id", "enabled", "omm prov.", "connected", "ssl method", "val. certs", "val. expires", "val host name", "a.n.c.tr. certs", "import certs"};
        public int id = 0;
        public String name = null;
        public String desc = null;
        public String domain1 = null;
        public String domain2 = null;
        public String username = null;
        public String password = null;
        public String cloudId = null;
        public boolean enable = false;
        public boolean ommProvisioning = false;
        public boolean connected = false;
        public OmiMessage.SslMethodType sslMethod = null;
        public boolean validateCerts = false;
        public boolean validateExpires = false;
        public boolean validateHostName = false;
        public boolean allowNonConfTrustCerts = false;
        public boolean importCerts = false;

        public MomOmmRecord() {
        }

        public MomOmmRecord(int n) {
            this.id = n;
        }

        public static void setTableHeaderText(int n, String string) {
            if (n >= 0 && n < 17) {
                MomOmmRecord.fieldNames[n] = string;
            }
        }

        public static String[] getFieldNames() {
            return fieldNames;
        }

        @Override
        public Object getField(int n) {
            switch (n) {
                case 0: {
                    return this.id;
                }
                case 1: {
                    return this.name;
                }
                case 2: {
                    return this.desc;
                }
                case 3: {
                    return this.domain1;
                }
                case 4: {
                    return this.domain2;
                }
                case 5: {
                    return this.username;
                }
                case 6: {
                    return this.password;
                }
                case 7: {
                    return this.cloudId;
                }
                case 8: {
                    return this.enable;
                }
                case 9: {
                    return this.ommProvisioning;
                }
                case 10: {
                    return this.connected;
                }
                case 11: {
                    return this.sslMethod;
                }
                case 12: {
                    return this.validateCerts;
                }
                case 13: {
                    return this.validateExpires;
                }
                case 14: {
                    return this.validateHostName;
                }
                case 15: {
                    return this.allowNonConfTrustCerts;
                }
                case 16: {
                    return this.importCerts;
                }
            }
            return null;
        }

        @Override
        public DataRecord clone() {
            MomOmmRecord momOmmRecord = new MomOmmRecord();
            momOmmRecord.id = this.id;
            momOmmRecord.name = this.name;
            momOmmRecord.desc = this.desc;
            momOmmRecord.domain1 = this.domain1;
            momOmmRecord.domain2 = this.domain2;
            momOmmRecord.username = this.username;
            momOmmRecord.password = this.password;
            momOmmRecord.cloudId = this.cloudId;
            momOmmRecord.enable = this.enable;
            momOmmRecord.ommProvisioning = this.ommProvisioning;
            momOmmRecord.connected = this.connected;
            momOmmRecord.sslMethod = this.sslMethod;
            momOmmRecord.validateCerts = this.validateCerts;
            momOmmRecord.validateExpires = this.validateExpires;
            momOmmRecord.validateHostName = this.validateHostName;
            momOmmRecord.allowNonConfTrustCerts = this.allowNonConfTrustCerts;
            momOmmRecord.importCerts = this.importCerts;
            return momOmmRecord;
        }

        public String toString() {
            return this.name;
        }
    }

    public static interface MomOmmDataNotificationInterface {
        public void processMomOmmDataNotification(int var1, DataNotificationEnum var2);

        public void processMomOmmDataErrorNotification(int var1, DataNotificationEnum var2, OmiMessage var3);
    }
}

