/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.style;

import com.aastra.style.AastraCommon;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class AastraContentButton
extends JButton {
    private Color normalBg = null;
    private Color pressedBg = null;
    private Color hoverBg = null;
    private Color disabledBg = null;
    private ImageIcon selectedIcon = null;
    private ImageIcon unselectedIcon = null;
    private ImageIcon disabledIcon = null;
    private boolean selectState = false;
    private static final long serialVersionUID = 5284838395819230484L;

    public AastraContentButton() {
        this.initialize();
    }

    public AastraContentButton(Icon icon) {
        super(icon);
        this.initialize();
    }

    protected void initialize() {
        this.setBorderPainted(false);
        this.setBackground(AastraCommon.MitelColorDarkBackground);
        this.setFocusPainted(false);
        this.setFont(AastraCommon.AastraFontCommon);
    }

    public void setBgNormal(Color color) {
        this.normalBg = color;
    }

    public void setBgPressed(Color color) {
        this.pressedBg = color;
    }

    public void setBgHover(Color color) {
        this.hoverBg = color;
    }

    public void setBgDisabled(Color color) {
        this.disabledBg = color;
    }

    public void setIconUnselected(ImageIcon imageIcon) {
        this.unselectedIcon = imageIcon;
    }

    public void setIconSelected(ImageIcon imageIcon) {
        this.selectedIcon = imageIcon;
    }

    public void setIconDisabled(ImageIcon imageIcon) {
        this.disabledIcon = imageIcon;
    }

    public void select(boolean bl) {
        this.selectState = bl;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        ButtonModel buttonModel = this.getModel();
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color = null;
        ImageIcon imageIcon = null;
        if (!this.isEnabled()) {
            color = this.disabledBg != null ? this.disabledBg : this.normalBg;
            imageIcon = this.disabledIcon != null ? this.disabledIcon : this.unselectedIcon;
        } else if (this.selectState) {
            color = this.pressedBg != null ? this.pressedBg : this.normalBg;
            imageIcon = this.selectedIcon != null ? this.selectedIcon : this.unselectedIcon;
        } else {
            color = this.normalBg;
            if (buttonModel.isRollover() && this.hoverBg != null) {
                color = this.hoverBg;
            }
            imageIcon = this.unselectedIcon;
        }
        if (color != null) {
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (imageIcon != null) {
            imageIcon.paintIcon(this, graphics, 0, 0);
        }
        graphics2D.dispose();
    }
}

