/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.style;

import com.aastra.style.AastraCommon;
import com.aastra.style.AastraTextFieldUI;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.text.Document;

public class AastraTextField
extends JTextField {
    private static final long serialVersionUID = 3851770850765145588L;
    private static Border emptyBorder = new EmptyBorder(0, 2, 0, 2);
    private Shape shape;

    public AastraTextField() {
        this.initialize();
    }

    public AastraTextField(String string) {
        super(string);
        this.initialize();
    }

    public AastraTextField(int n) {
        super(n);
        this.initialize();
    }

    public AastraTextField(String string, int n) {
        super(string, n);
        this.initialize();
    }

    public AastraTextField(Document document, String string, int n) {
        super(document, string, n);
        this.initialize();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, AastraCommon.MitelRoundCornerRadius, AastraCommon.MitelRoundCornerRadius);
        super.paintComponent(graphics);
    }

    @Override
    protected void paintBorder(Graphics graphics) {
        Border border = this.getBorder();
        if (border.getClass() == EmptyBorder.class) {
            graphics.setColor(AastraCommon.MitelColorTextFieldBorder);
            graphics.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, AastraCommon.MitelRoundCornerRadius, AastraCommon.MitelRoundCornerRadius);
        } else {
            super.paintBorder(graphics);
        }
    }

    @Override
    public boolean contains(int n, int n2) {
        if (this.shape == null || !this.shape.getBounds().equals(this.getBounds())) {
            this.shape = new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth() - 1, this.getHeight() - 1, AastraCommon.MitelRoundCornerRadius, AastraCommon.MitelRoundCornerRadius);
        }
        return this.shape.contains(n, n2);
    }

    protected void initialize() {
        this.setFont(AastraCommon.AastraFontCommon);
        this.setUI(new AastraTextFieldUI());
        this.setBorder(emptyBorder);
        this.setOpaque(false);
    }
}

