/*
 * Decompiled with CFR 0.152.
 */
package OPSB;

import OPSB.PreStorageBase;
import OPSB.RecordLocRfp;
import OPSB.RecordLocRfpSip;
import OPSB.RfpLocInstrFieldsSip;
import OPSB.RfpLocStorageBase;
import java.io.PrintWriter;

public class RfpLocStorageBaseSip
extends RfpLocStorageBase {
    RfpLocInstrFieldsSip m_instrFields;

    public RfpLocStorageBaseSip(String string) {
        super(string);
        this.m_max_sequence_fields = RecordLocRfpSip.MAX;
        this.m_max_instruction_fields = RfpLocInstrFieldsSip.MAX;
        this.m_sequenceLine = new String[this.m_max_sequence_fields];
    }

    public RfpLocStorageBaseSip(String string, String string2) {
        super(string, string2);
        this.m_max_sequence_fields = RecordLocRfpSip.MAX;
        this.m_max_instruction_fields = RfpLocInstrFieldsSip.MAX;
        this.m_sequenceLine = new String[this.m_max_sequence_fields];
    }

    @Override
    protected void resetInstructions() {
        this.m_instrFields = new RfpLocInstrFieldsSip(this.m_max_instruction_fields);
    }

    @Override
    protected boolean addRecord() {
        RecordLocRfpSip recordLocRfpSip = new RecordLocRfpSip();
        if (this.CrossCheckMacIp(this.m_sequenceLine)) {
            if (recordLocRfpSip.parseAndSetFields(this.m_sequenceLine, this.writeReadPreDataProtFile, this.m_data_record_sequence_counter)) {
                this.rfpRecords.addElement(recordLocRfpSip);
            } else {
                this.m_error_no = 1;
            }
        } else {
            this.m_error_no = 1;
        }
        ++this.m_data_record_sequence_counter;
        return true;
    }

    @Override
    protected boolean changeRecord() {
        boolean bl = false;
        boolean bl2 = true;
        int n = RecordLocRfp.MAC_ADDR;
        if (this.rfpRecords == null) {
            return false;
        }
        for (int i = 0; i < this.rfpRecords.size() && !bl; ++i) {
            RecordLocRfpSip recordLocRfpSip = (RecordLocRfpSip)this.rfpRecords.get(i);
            if (this.m_sequenceLine[RecordLocRfpSip.MAC_ADDR].compareTo(recordLocRfpSip.data[RecordLocRfpSip.MAC_ADDR]) != 0) continue;
            bl = true;
            do {
                String string;
                if (this.m_sequenceLine[n].length() <= 0 && n >= RecordLocRfp.ACTIVE_FLAG) {
                    this.m_sequenceLine[n] = recordLocRfpSip.data[n];
                }
                if ((string = this.parseSequenceField(n, this.m_sequenceLine[n])).length() <= 0) continue;
                this.writeInstrProtFile.println(": " + String.valueOf(this.m_data_record_sequence_counter) + " : " + PreStorageBase.text.getCurrentLang("records_error", PreStorageBase.language) + ": " + PreStorageBase.text.getCurrentLang("parse_fields", PreStorageBase.language) + " " + String.valueOf(n + 1) + " : " + string);
                this.m_error_no = 1;
                bl2 = false;
            } while (++n < this.m_max_sequence_fields);
            if (!bl2) continue;
            recordLocRfpSip.parseAndChangeFields(this.m_sequenceLine, this.writeReadPreDataProtFile, this.m_data_record_sequence_counter);
        }
        if (!bl && bl2) {
            this.writeInstrProtFile.println(": " + String.valueOf(this.m_data_record_sequence_counter) + " : " + PreStorageBase.text.getCurrentLang("records_error", PreStorageBase.language) + ": " + PreStorageBase.text.getCurrentLang("records_mac ", PreStorageBase.language) + this.m_sequenceLine[RecordLocRfp.MAC_ADDR] + " " + PreStorageBase.text.getCurrentLang("records_not_found", PreStorageBase.language));
            this.m_error_no = 1;
        }
        ++this.m_data_record_sequence_counter;
        return true;
    }

    @Override
    public String[] getRecord(int n) {
        if (this.rfpRecords == null) {
            return null;
        }
        if (n < this.rfpRecords.size()) {
            RecordLocRfpSip recordLocRfpSip = (RecordLocRfpSip)this.rfpRecords.get(n);
            return recordLocRfpSip.data;
        }
        return null;
    }

    @Override
    public String getField(int n, int n2) {
        if (this.rfpRecords == null || this.m_only_mac_list) {
            return "";
        }
        if (n < this.rfpRecords.size()) {
            RecordLocRfpSip recordLocRfpSip = (RecordLocRfpSip)this.rfpRecords.get(n);
            return recordLocRfpSip.getField(n2);
        }
        return "";
    }

    @Override
    public void printUserInfoHeader(PrintWriter printWriter) {
        int n = 0;
        printWriter.println("# ----------------------------------------------------- #");
        printWriter.println("# instruction section                                   #");
        printWriter.println("# ----------------------------------------------------- #");
        printWriter.println(" ");
        for (n = 0; n < this.m_max_instruction_fields; ++n) {
            String string = this.getInstrIdentifier(n);
            if (string.length() <= 0) continue;
            printWriter.println("# " + string + " = ");
        }
        printWriter.println(" ");
        printWriter.println("# ----------------------------------------------------- #");
        printWriter.println("# data sequence                                         #");
        printWriter.println("# ----------------------------------------------------- #");
        printWriter.println("#  1. MAC_ADDR           ! no instruction supported !");
        printWriter.println("#  2. ACTIVE_FLAG");
        printWriter.println("#  3. RFPADDR            ! no instruction supported !");
        printWriter.println("#  4. NET_MASK");
        printWriter.println("#  5. TFTP_SERVER");
        printWriter.println("#  6. TFTP_FILE");
        printWriter.println("#  7. OMM1");
        printWriter.println("#  8. OMM2");
        printWriter.println("#  9. GATEWAY");
        printWriter.println("# 10. DNS_SERVER");
        printWriter.println("# 11. DNS_DOMAIN");
        printWriter.println("# 12. SYSLOG_ADDR");
        printWriter.println("# 13. SYSLOG_PORT");
        printWriter.println("# 14. USE_VLAN");
        printWriter.println("# 15. SRVLIST");
        printWriter.println("# 16. BROADCAST_ADDR");
        printWriter.println("# 17. VLAN_ID");
        printWriter.println("# 18. PREFERRED_TFTP");
        printWriter.println("# 19. CONFIG_FILE_SERVER");
        printWriter.println("# 20. USE_802_1X");
        printWriter.println(" ");
    }

    @Override
    public String instrGetParseInfo(int n) {
        return this.m_instrFields.elem[n].instrGetParseInfo();
    }

    @Override
    public boolean instrOk(int n) {
        return this.m_instrFields.elem[n].singleInstrSetOk();
    }

    @Override
    public String getInstrValue(int n) {
        return this.m_instrFields.elem[n].instrGetValue();
    }

    @Override
    public void setInstrValue(int n, String string) {
        this.m_instrFields.elem[n].instrSet(string);
    }

    @Override
    public String getInstrIdentifier(int n) {
        return this.m_instrFields.elem[n].instrGetIdentifier();
    }

    @Override
    public int instrGetValueLen(int n) {
        return this.m_instrFields.elem[n].instrGetValueLen();
    }

    @Override
    public String instrEvalValue(int n) {
        return this.m_instrFields.elem[n].instrEvalValue();
    }

    @Override
    public String parseSequenceField(int n, String string) {
        return this.m_instrFields.elem[n].valid_value(string);
    }

    @Override
    public int getFieldType(int n) {
        return this.m_instrFields.elem[n].param_type;
    }

    @Override
    public void proceedReviewOfMandatorySettings(String[] stringArray) {
        this.m_instrFields.reviewMandatorySettings(stringArray);
    }
}

