/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omcfg;

import com.aastra.omcfg.GuiAboutDlg;
import com.aastra.omcfg.GuiCommon;
import com.aastra.omcfg.GuiEulaDlg;
import com.aastra.omcfg.GuiMain;
import com.aastra.omcfg.GuiOptionsDlg;
import com.aastra.omcfg.GuiSpyConsole;
import com.aastra.omcfg.util.UtilConvert;
import com.aastra.omcfg.util.UtilLocale;
import com.aastra.style.AastraCheckBoxMenuItem;
import com.aastra.style.AastraMenu;
import com.aastra.style.AastraMenuBar;
import com.aastra.style.AastraMenuItem;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class GuiMenuBar
extends AastraMenuBar {
    private static final long serialVersionUID = 1L;
    private GuiMain guiMain = null;
    private AastraMenu menuHelp = null;
    private AastraMenu menuGeneral = null;
    private AastraMenuItem menuItemOptions = null;
    private AastraMenuItem menuItemExit = null;
    private AastraCheckBoxMenuItem menuItemSpyConsole = null;
    private AastraMenuItem menuItemEula = null;
    private AastraMenuItem menuItemAboutOMP = null;
    private GuiSpyConsole spyConsole = GuiMain.getSpyConsole();

    public GuiMenuBar() {
        this.guiMain = GuiMain.getGuiMainObject();
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(350, 26));
        this.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.add(this.getMenuHelp());
        this.add(this.getMenuGeneral());
        this.spyConsole.initializeGuiMenuBarObject(this);
    }

    private AastraMenu getMenuHelp() {
        if (this.menuHelp == null) {
            this.menuHelp = new AastraMenu();
            String string = UtilLocale.getString("TXT_HELP");
            this.menuHelp.setText(string);
            Integer n = null;
            for (int i = 0; i < string.length() && (n = UtilConvert.getKeyEvent(Character.valueOf(string.charAt(i)))) == null; ++i) {
            }
            if (n != null) {
                this.menuHelp.setMnemonic(n);
            }
            this.menuHelp.add(this.getMenuItemEula());
            this.menuHelp.add(this.getMenuItemAboutOMP());
        }
        return this.menuHelp;
    }

    private AastraMenuItem getMenuItemEula() {
        if (this.menuItemEula == null) {
            this.menuItemEula = new AastraMenuItem();
            String string = UtilLocale.getString("TXT_INFO_20");
            this.menuItemEula.setText(string);
            Integer n = null;
            for (int i = 0; i < string.length() && (n = UtilConvert.getKeyEvent(Character.valueOf(string.charAt(i)))) == null; ++i) {
            }
            if (n != null) {
                this.menuItemEula.setMnemonic(n);
            }
            this.menuItemEula.setEnabled(true);
            this.menuItemEula.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiEulaDlg guiEulaDlg = new GuiEulaDlg(GuiMain.getGuiMainObject());
                    guiEulaDlg.setVisible(true);
                }
            });
        }
        return this.menuItemEula;
    }

    private AastraMenuItem getMenuItemAboutOMP() {
        if (this.menuItemAboutOMP == null) {
            this.menuItemAboutOMP = new AastraMenuItem();
            String string = UtilLocale.getString("TXT_ABOUT") + " " + GuiCommon.ApplicationNameShort;
            this.menuItemAboutOMP.setText(string);
            this.menuItemAboutOMP.setEnabled(true);
            this.menuItemAboutOMP.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiAboutDlg guiAboutDlg = new GuiAboutDlg(GuiMenuBar.this.guiMain);
                    guiAboutDlg.setVisible(true);
                }
            });
        }
        return this.menuItemAboutOMP;
    }

    public void setMenuItemSpyConsole(Boolean bl) {
        this.menuItemSpyConsole.setSelected(bl);
    }

    private AastraMenu getMenuGeneral() {
        if (this.menuGeneral == null) {
            this.menuGeneral = new AastraMenu();
            String string = UtilLocale.getString("TXT_GENERAL");
            this.menuGeneral.setText(string);
            Integer n = null;
            for (int i = 0; i < string.length() && ((n = UtilConvert.getKeyEvent(Character.valueOf(string.charAt(i)))) == null || n == Integer.valueOf(this.menuHelp.getMnemonic())); ++i) {
            }
            if (n != null) {
                this.menuGeneral.setMnemonic(n);
            }
            this.menuGeneral.add(this.getMenuItemOptions());
            this.menuGeneral.add(this.getMenuItemExit());
        }
        return this.menuGeneral;
    }

    private AastraMenuItem getMenuItemOptions() {
        if (this.menuItemOptions == null) {
            this.menuItemOptions = new AastraMenuItem();
            String string = UtilLocale.getString("TXT_OPTIONS");
            this.menuItemOptions.setText(string);
            Integer n = UtilConvert.getKeyEvent(Character.valueOf(string.charAt(0)));
            if (n != null) {
                this.menuItemOptions.setMnemonic(n);
            }
            this.menuItemOptions.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiOptionsDlg guiOptionsDlg = new GuiOptionsDlg();
                    guiOptionsDlg.setVisible(true);
                }
            });
        }
        return this.menuItemOptions;
    }

    private AastraMenuItem getMenuItemExit() {
        if (this.menuItemExit == null) {
            this.menuItemExit = new AastraMenuItem();
            String string = UtilLocale.getString("TXT_EXIT");
            this.menuItemExit.setText(string);
            Integer n = null;
            for (int i = 0; i < string.length() && ((n = UtilConvert.getKeyEvent(Character.valueOf(string.charAt(i)))) == null || n == Integer.valueOf(this.menuItemOptions.getMnemonic())); ++i) {
            }
            if (n != null) {
                this.menuItemExit.setMnemonic(n);
            }
            this.menuItemExit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (GuiMenuBar.this.guiMain != null) {
                        GuiMenuBar.this.guiMain.exitApplication(null);
                    }
                }
            });
        }
        return this.menuItemExit;
    }
}

