/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omcfg;

import com.aastra.omcfg.GuiMenuBar;
import com.aastra.omcfg.util.UtilLocale;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraScrollPane;
import com.aastra.style.AastraTextArea;
import com.aastra.util.UtilSpy;
import java.awt.Dimension;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;

public class GuiSpyConsole
extends JFrame
implements UtilSpy.SpyOutputInterface {
    private static final long serialVersionUID = 1L;
    private static final int characterNumberIdeal = 200000;
    private static final int characterNumberExcessMax = 500;
    private AastraTextArea textArea = null;
    private AastraScrollPane scrollPane = null;
    private GuiMenuBar guiMenuBar = null;

    public GuiSpyConsole() {
        this.initialize();
    }

    private void initialize() {
        this.setMinimumSize(new Dimension(1024, 200));
        this.setDefaultCloseOperation(1);
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GuiSpyConsole.this.guiMenuBar.setMenuItemSpyConsole(false);
                UtilSpy.spySetOutputConfiguration(true, false);
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
            }
        });
        this.setContentPane(this.getScrollPane());
    }

    public void setTitle() {
        this.setTitle(UtilLocale.getString("TXT_EXPERT_CONSOLE"));
    }

    @Override
    public synchronized void spyInfo(String string) {
        if (!string.endsWith("\n")) {
            string = string + "\n";
        }
        this.textArea.append(string);
        int n = this.textArea.getDocument().getLength();
        this.textArea.setCaretPosition(n);
        int n2 = n - 200000;
        if (n2 >= 500) {
            this.textArea.replaceRange("", 0, n2);
        }
    }

    @Override
    public void spyError(String string) {
        this.spyInfo(string);
    }

    private AastraTextArea getTextArea() {
        if (this.textArea == null) {
            this.textArea = new AastraTextArea();
            this.textArea.setEditable(false);
            this.textArea.setFont(AastraCommon.AastraFontSpyConsole);
            this.textArea.setRows(40);
            this.textArea.setColumns(100);
        }
        return this.textArea;
    }

    private AastraScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new AastraScrollPane(this.getTextArea());
        }
        return this.scrollPane;
    }

    public void initializeGuiMenuBarObject(GuiMenuBar guiMenuBar) {
        if (this.guiMenuBar == null) {
            this.guiMenuBar = guiMenuBar;
        }
    }
}

