/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omcfg.guiutil;

import com.aastra.omcfg.GuiMain;
import com.aastra.omcfg.util.UtilGeneralBooleanSettings;
import com.aastra.omcfg.util.UtilLocale;
import com.aastra.omcfg.util.UtilPreferences;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraCheckBox;
import com.aastra.style.AastraDialog;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.BitSet;

public class GuiUtilTableConfigDlg
extends AastraDialog {
    private static final long serialVersionUID = 1L;
    private AastraPanel tableConfigPanel = null;
    private AastraButton buttonOK = null;
    private AastraButton buttonCancel = null;
    private AastraScrollPane itemlistScrollPanel = null;
    private AastraCheckBox checkBoxAll;
    private ConfiguratorTable table = null;
    private int[] allColumnsArray = null;
    private int[] allColumnsArraySorted = null;
    protected AastraCheckBox[] checkBoxActiveArray;
    private UtilPreferences.TableColSelectKeyTypeEnum key = null;
    private AastraPanel itemListPanel = null;
    private boolean selectionAll = false;
    private String title = null;
    private int selectedColumnNum = 0;
    private String[] columnNamesArray = null;
    private String[] colHeaderToolTipsArray = null;
    private boolean isSorted;

    public GuiUtilTableConfigDlg(ConfiguratorTable configuratorTable, int[] nArray, UtilPreferences.TableColSelectKeyTypeEnum tableColSelectKeyTypeEnum) {
        super(GuiMain.getGuiMainObject());
        this.table = configuratorTable;
        this.columnNamesArray = this.table.getColumnNamesArr();
        this.allColumnsArray = nArray;
        this.key = tableColSelectKeyTypeEnum;
        this.initialize();
    }

    public GuiUtilTableConfigDlg(ConfiguratorTable configuratorTable, int[] nArray, UtilPreferences.TableColSelectKeyTypeEnum tableColSelectKeyTypeEnum, String[] stringArray) {
        super(GuiMain.getGuiMainObject());
        this.table = configuratorTable;
        this.columnNamesArray = this.table.getColumnNamesArr();
        this.allColumnsArray = nArray;
        this.key = tableColSelectKeyTypeEnum;
        this.colHeaderToolTipsArray = stringArray;
        this.initialize();
    }

    public GuiUtilTableConfigDlg(String[] stringArray, int[] nArray, UtilPreferences.TableColSelectKeyTypeEnum tableColSelectKeyTypeEnum, boolean bl, String string) {
        super(GuiMain.getGuiMainObject());
        this.columnNamesArray = stringArray;
        this.allColumnsArray = nArray;
        this.key = tableColSelectKeyTypeEnum;
        this.selectionAll = bl;
        this.title = string;
        this.initialize();
    }

    private void initialize() {
        this.isSorted = UtilGeneralBooleanSettings.getSingleId(UtilGeneralBooleanSettings.SettingIdsEnum.TABLE_COL_SELECTION_SORTED_ALPHABETICALLY);
        if (this.selectionAll) {
            this.setSize(290, 490);
        } else {
            this.setSize(290, 445);
        }
        this.setResizable(false);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setLocationRelativeTo(null);
        if (this.title != null) {
            this.setTitle(this.title);
        } else {
            this.setTitle(UtilLocale.getString("TXT_SELECT_COLUMNS"));
        }
        this.setContentPane(this.getTableConfigPanel());
        this.getRootPane().setDefaultButton(this.getButtonOK());
    }

    private AastraPanel getTableConfigPanel() {
        if (this.tableConfigPanel == null) {
            this.tableConfigPanel = new AastraPanel();
            this.tableConfigPanel.setLayout(null);
            this.tableConfigPanel.add((Component)this.getItemListScrollPanel(), null);
            if (this.selectionAll) {
                this.tableConfigPanel.add((Component)this.getCheckBoxAll(), null);
            }
            this.tableConfigPanel.add((Component)this.getButtonOK(), null);
            this.tableConfigPanel.add((Component)this.getButtonCancel(), null);
        }
        return this.tableConfigPanel;
    }

    private AastraCheckBox getCheckBoxAll() {
        if (this.checkBoxAll == null) {
            this.checkBoxAll = new AastraCheckBox();
            this.checkBoxAll.setBounds(40, 370, 180, 22);
            this.checkBoxAll.setText(UtilLocale.getString("TXT_SELECT_ALL"));
            this.checkBoxAll.setSelected(false);
            this.checkBoxAll.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    boolean bl = GuiUtilTableConfigDlg.this.checkBoxAll.isSelected();
                    for (int i = 0; i < GuiUtilTableConfigDlg.this.checkBoxActiveArray.length; ++i) {
                        GuiUtilTableConfigDlg.this.checkBoxActiveArray[i].setSelected(bl);
                    }
                }
            });
        }
        return this.checkBoxAll;
    }

    protected AastraButton getButtonOK() {
        if (this.buttonOK == null) {
            this.buttonOK = new AastraButton();
            if (this.selectionAll) {
                this.buttonOK.setBounds(43, 415, 76, 26);
            } else {
                this.buttonOK.setBounds(43, 375, 76, 26);
            }
            this.buttonOK.setText(UtilLocale.getString("TXT_OK"));
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiUtilTableConfigDlg.this.setAndSaveActiveColumns();
                    GuiUtilTableConfigDlg.this.setVisible(false);
                }
            });
        }
        return this.buttonOK;
    }

    private AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = new AastraButton();
            if (this.selectionAll) {
                this.buttonCancel.setBounds(162, 415, 76, 26);
            } else {
                this.buttonCancel.setBounds(162, 375, 76, 26);
            }
            this.buttonCancel.setText(UtilLocale.getString("TXT_CANCEL"));
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiUtilTableConfigDlg.this.setVisible(false);
                }
            });
        }
        return this.buttonCancel;
    }

    private AastraScrollPane getItemListScrollPanel() {
        if (this.itemlistScrollPanel == null) {
            this.itemlistScrollPanel = new AastraScrollPane(this.getItemListPanel());
            this.itemlistScrollPanel.setBounds(9, 9, 268, 345);
        }
        return this.itemlistScrollPanel;
    }

    private AastraPanel getItemListPanel() {
        if (this.itemListPanel == null) {
            this.itemListPanel = new AastraPanel();
            this.itemListPanel.setLayout(null);
            this.buildCheckBoxes();
        }
        return this.itemListPanel;
    }

    protected void buildCheckBoxes() {
        BitSet bitSet = UtilPreferences.getTableColumnsSelection(this.key);
        if (bitSet == null) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, GuiUtilTableConfigDlg.class, "Pref key '" + (Object)((Object)this.key) + "' not found");
        }
        this.itemListPanel.setPreferredSize(new Dimension(1, this.allColumnsArray.length * 27));
        this.checkBoxActiveArray = new AastraCheckBox[this.allColumnsArray.length];
        for (int i = 0; i < this.allColumnsArray.length; ++i) {
            this.checkBoxActiveArray[i] = new AastraCheckBox();
            this.checkBoxActiveArray[i].setBounds(30, 20 + i * 25, 180, 22);
            this.checkBoxActiveArray[i].setText(this.getColumnName(i));
            if (bitSet != null) {
                if (bitSet.get(this.getAllColumnsArrayIdx(i))) {
                    this.checkBoxActiveArray[i].setSelected(true);
                    ++this.selectedColumnNum;
                } else {
                    this.checkBoxActiveArray[i].setSelected(false);
                }
            }
            this.checkBoxActiveArray[i].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        GuiUtilTableConfigDlg.this.selectedColumnNum++;
                    } else {
                        GuiUtilTableConfigDlg.this.selectedColumnNum--;
                    }
                    if (GuiUtilTableConfigDlg.this.selectedColumnNum > 0) {
                        GuiUtilTableConfigDlg.this.getButtonOK().setEnabled(true);
                    } else {
                        GuiUtilTableConfigDlg.this.getButtonOK().setEnabled(false);
                    }
                }
            });
            this.itemListPanel.add(this.checkBoxActiveArray[i]);
        }
    }

    protected void setAndSaveActiveColumns() {
        BitSet bitSet = new BitSet();
        if (this.table != null) {
            int n = 0;
            for (int i = 0; i < this.allColumnsArray.length; ++i) {
                if (!this.checkBoxActiveArray[i].isSelected()) continue;
                ++n;
            }
            int[] nArray = new int[n];
            n = 0;
            for (int i = 0; i < this.allColumnsArray.length; ++i) {
                if (!this.checkBoxActiveArray[i].isSelected()) continue;
                bitSet.set(this.getAllColumnsArrayIdx(i));
                nArray[n++] = this.allColumnsArray[this.getAllColumnsArrayIdx(i)];
            }
            if (this.isSorted) {
                Arrays.sort(nArray);
            }
            this.table.setColumnArr(nArray, n);
            if (this.colHeaderToolTipsArray != null) {
                this.table.setColumnHeaderToolTips(this.colHeaderToolTipsArray);
            }
        } else {
            for (int i = 0; i < this.allColumnsArray.length; ++i) {
                if (!this.checkBoxActiveArray[i].isSelected()) continue;
                bitSet.set(this.getAllColumnsArrayIdx(i));
            }
        }
        UtilPreferences.setTableColumnsSelection(this.key, bitSet);
    }

    private String getColumnName(int n) {
        if (this.isSorted) {
            if (this.allColumnsArraySorted == null) {
                this.sortColumnNames();
            }
            return this.columnNamesArray[this.allColumnsArraySorted[n]];
        }
        return this.columnNamesArray[this.allColumnsArray[n]];
    }

    private int getAllColumnsArrayIdx(int n) {
        if (this.isSorted) {
            int n2;
            for (n2 = 0; n2 < this.allColumnsArray.length && this.allColumnsArray[n2] != this.allColumnsArraySorted[n]; ++n2) {
            }
            return n2;
        }
        return n;
    }

    private void sortColumnNames() {
        Object[] objectArray = (String[])this.columnNamesArray.clone();
        Arrays.sort(objectArray);
        this.allColumnsArraySorted = new int[this.allColumnsArray.length];
        int n = 0;
        block0: for (int i = 0; n < this.allColumnsArraySorted.length && i < objectArray.length; ++i) {
            for (int j = 0; j < this.allColumnsArray.length; ++j) {
                if (!((String)objectArray[i]).equals(this.columnNamesArray[this.allColumnsArray[j]])) continue;
                this.allColumnsArraySorted[n++] = this.allColumnsArray[j];
                continue block0;
            }
        }
    }
}

