/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omcfg.rfpcfg;

import com.aastra.omcfg.rfpcfg.ConfigRow;
import com.aastra.omcfg.rfpcfg.LanguageText;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.StringTokenizer;
import java.util.Vector;

public class ConfigReader {
    public static final int TYPE_BOOL = 1;
    public static final int TYPE_STRING = 2;
    public static final int TYPE_IP = 3;
    public static final int TYPE_U8 = 4;
    public static final int TYPE_U16 = 5;
    public static final int TYPE_URL = 6;
    public static final int TYPE_PATH = 7;
    public static Vector<ConfigRow> allParameters = new Vector();
    public static Vector<LanguageText> allTexts = new Vector();
    public static int language = 0;
    private String config_file_name;

    public ConfigReader(String string) {
        this.config_file_name = new String(string);
        this.readLanguageText();
    }

    private void readLanguageText() {
        Object object;
        LineNumberReader lineNumberReader;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader("resources/language.csv");
            lineNumberReader = new LineNumberReader(fileReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            InputStream inputStream = this.getClass().getResourceAsStream("/resources/language.csv");
            try {
                Charset charset = Charset.forName("ISO-8859-1");
                object = charset.newDecoder();
                ((CharsetDecoder)object).onMalformedInput(CodingErrorAction.REPORT);
                lineNumberReader = new LineNumberReader(new InputStreamReader(inputStream, (CharsetDecoder)object));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                lineNumberReader = new LineNumberReader(new InputStreamReader(inputStream));
            }
        }
        try {
            allTexts.clear();
            while (lineNumberReader.ready()) {
                StringTokenizer stringTokenizer = new StringTokenizer(lineNumberReader.readLine(), ";");
                String string = stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreTokens()) continue;
                int n = stringTokenizer.countTokens();
                for (int i = 1; i <= n; ++i) {
                    object = stringTokenizer.nextToken();
                    LanguageText languageText = new LanguageText(string, i, (String)object);
                    allTexts.add(languageText);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public Vector<String> getLanguages() {
        Vector<String> vector = new Vector<String>();
        boolean bl = true;
        int n = 0;
        while (bl) {
            LanguageText languageText = allTexts.elementAt(n);
            while (languageText.isSysText("language")) {
                bl = false;
                vector.add(languageText.getText());
                languageText = allTexts.elementAt(++n);
            }
            ++n;
        }
        return vector;
    }

    public void readConfigFile() {
        Object object;
        LineNumberReader lineNumberReader;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(this.config_file_name);
            lineNumberReader = new LineNumberReader(fileReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            object = this.getClass().getResourceAsStream(this.config_file_name);
            lineNumberReader = new LineNumberReader(new InputStreamReader((InputStream)object));
        }
        try {
            allParameters.clear();
            String string = "";
            object = "";
            while (lineNumberReader.ready()) {
                ConfigRow configRow = new ConfigRow();
                StringTokenizer stringTokenizer = new StringTokenizer(lineNumberReader.readLine(), ",");
                if (stringTokenizer.hasMoreTokens()) {
                    StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "\"");
                    stringTokenizer2.nextToken();
                    configRow.setName(stringTokenizer2.nextToken());
                    if (stringTokenizer.hasMoreTokens()) {
                        string = new String(stringTokenizer.nextToken());
                    }
                    if (string.indexOf(new String("OPTION_SHOW")) >= 0) {
                        configRow.setShown(true);
                    }
                    if (string.indexOf(new String("OPTION_MUST")) >= 0) {
                        configRow.setRequired(true);
                    }
                    if (string.indexOf(new String("OPTION_INVISIBLE")) >= 0) {
                        configRow.setInvisible(true);
                    }
                    if (string.indexOf(new String("OPTION_LIST")) >= 0) {
                        configRow.setList(true);
                    }
                    if (string.indexOf(new String("OPTION_BOOL")) >= 0) {
                        configRow.setType(1);
                    } else if (string.indexOf(new String("OPTION_STRING")) >= 0) {
                        configRow.setType(2);
                    } else if (string.indexOf(new String("OPTION_IP")) >= 0) {
                        configRow.setType(3);
                    } else if (string.indexOf(new String("OPTION_U8")) >= 0) {
                        configRow.setType(4);
                    } else if (string.indexOf(new String("OPTION_U16")) >= 0) {
                        configRow.setType(5);
                    } else if (string.indexOf(new String("OPTION_URL")) >= 0) {
                        configRow.setType(6);
                    } else if (string.indexOf(new String("OPTION_PATH")) >= 0) {
                        configRow.setType(7);
                    }
                    if (stringTokenizer.hasMoreTokens() && ((String)(object = new String(stringTokenizer.nextToken()))).indexOf(new String("0x")) >= 0) {
                        if (((String)(object = ((String)object).substring(((String)object).indexOf(new String("0x")) + 2))).indexOf(new String(" ")) >= 0) {
                            object = ((String)object).substring(0, ((String)object).indexOf(new String(" ")));
                        }
                        if (((String)object).indexOf(new String("}")) >= 0) {
                            object = ((String)object).substring(0, ((String)object).indexOf(new String("}")));
                        }
                        while (((String)object).length() > 1 && ((String)object).indexOf(new String("0")) == 0) {
                            object = ((String)object).substring(1);
                        }
                        try {
                            configRow.setMaxLen(Long.valueOf((String)object, 16).intValue());
                        }
                        catch (NumberFormatException numberFormatException) {
                            configRow.setMaxLen(0);
                            numberFormatException.printStackTrace();
                        }
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        stringTokenizer2 = new StringTokenizer(string2, "\"");
                        if ((string2 = stringTokenizer2.nextToken()) != null) {
                            configRow.setDisplayName(string2);
                        }
                    }
                }
                allParameters.add(configRow);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static int getIndexFromConfig(String string) {
        int n = -1;
        for (int i = 0; i < allParameters.size(); ++i) {
            ConfigRow configRow = allParameters.elementAt(i);
            if (!configRow.getName().equals(string)) continue;
            n = i;
        }
        return n;
    }

    public static ConfigRow getParamFromConfig(String string, boolean bl) {
        for (int i = 0; i < allParameters.size(); ++i) {
            ConfigRow configRow = allParameters.elementAt(i);
            if (!(bl ? configRow.getDisplayName().equals(string) : configRow.getName().equals(string))) continue;
            return configRow;
        }
        return null;
    }

    public static String getNameFromDisplayName(String string) {
        for (int i = 0; i < allParameters.size(); ++i) {
            ConfigRow configRow = allParameters.elementAt(i);
            if (!configRow.getDisplayName().equals(string)) continue;
            return configRow.getName();
        }
        return string;
    }

    public static String getDisplayNameFromName(String string) {
        for (int i = 0; i < allParameters.size(); ++i) {
            ConfigRow configRow = allParameters.elementAt(i);
            if (!configRow.getName().equals(string)) continue;
            return configRow.getDisplayName();
        }
        return string;
    }

    public static String getCurrentLang(String string) {
        if (allTexts.size() == 0) {
            ConfigReader configReader = new ConfigReader("resources/omm_param.cfg");
            configReader.getLanguages();
            language = 1;
        }
        for (int i = 0; i < allTexts.size(); ++i) {
            LanguageText languageText = allTexts.elementAt(i);
            if (!languageText.isSysText(string) || !languageText.isLanguage(language)) continue;
            return languageText.getText();
        }
        return string;
    }
}

