/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omcfg.rfpcfg;

import com.aastra.omcfg.GuiInfoConsole;
import com.aastra.omcfg.rfpcfg.CRCSum;
import com.aastra.omcfg.rfpcfg.ConfigReader;
import com.aastra.omcfg.rfpcfg.ConfigRow;
import com.aastra.omcfg.rfpcfg.ConfigurationFunctions;
import com.aastra.omcfg.rfpcfg.EthIf;
import com.aastra.omcfg.rfpcfg.MacObj;
import com.aastra.omcfg.rfpcfg.NetworkEventSynchronizer;
import com.aastra.omcfg.rfpcfg.ParamPacket;
import com.aastra.omcfg.rfpcfg.ParamsEnum;
import com.aastra.omcfg.rfpcfg.RfpRecord;
import java.awt.EventQueue;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class NewNetworkThread
extends Thread {
    private static final int configPort = 64000;
    private static final int MAX_UDP_SIZE = 2000;
    private String error_string;
    private ConfigurationFunctions configFunctionsObject = null;
    private DatagramSocket ds = null;
    private DatagramSocket dsrecv = null;
    private boolean socketOpen = false;
    private boolean broadcast = false;
    private boolean useProxy = false;
    private Timer timer = new Timer();
    private boolean timerdebug = false;
    private InetAddress sendfromAddr = null;
    private Vector<MacObj> macs;
    private SecondRxThread rxThread2 = new SecondRxThread();

    public NewNetworkThread() {
        this.macs = new Vector();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                NewNetworkThread.this.macTimerAction();
            }
        }, 500L, 500L);
    }

    private synchronized MacObj addMAC(byte[] byArray, String string) {
        MacObj macObj = this.getMAC(byArray);
        if (macObj != null) {
            return macObj;
        }
        macObj = new MacObj();
        macObj.m_mac = byArray;
        macObj.m_param = string;
        this.macs.add(macObj);
        return macObj;
    }

    private synchronized MacObj getMAC(byte[] byArray) {
        for (int i = 0; i < this.macs.size(); ++i) {
            MacObj macObj = this.macs.get(i);
            if (macObj.m_mac[0] != byArray[0] || macObj.m_mac[1] != byArray[1] || macObj.m_mac[2] != byArray[2] || macObj.m_mac[3] != byArray[3] || macObj.m_mac[4] != byArray[4] || macObj.m_mac[5] != byArray[5]) continue;
            return macObj;
        }
        return null;
    }

    public synchronized void resetScanOnMacList() {
        for (MacObj macObj : this.macs) {
            if (macObj.state != 1) continue;
            macObj.newState(2);
        }
    }

    private synchronized void macTimerAction() {
        for (MacObj macObj : this.macs) {
            if (macObj.state <= 2) continue;
            ++macObj.count;
            if (macObj.count % macObj.retryInterval != 0) continue;
            switch (macObj.state) {
                case 3: 
                case 4: {
                    if (macObj.count / macObj.retryInterval < macObj.repeatCount) {
                        if (this.timerdebug) {
                            System.out.println("Timer: " + macObj.macString + " State=" + macObj.state);
                        }
                        this.sendPacket(macObj.packet);
                        break;
                    }
                    macObj.newState(1);
                    break;
                }
                case 5: 
                case 6: {
                    if (macObj.count / macObj.retryInterval < macObj.repeatCount) {
                        if (this.timerdebug) {
                            System.out.println("Timer: " + macObj.macString + " State=" + macObj.state);
                        }
                        this.sendPacket(macObj.packet);
                        break;
                    }
                    EventQueue.invokeLater(new NetworkEventSynchronizer(macObj.macString, 5));
                    macObj.newState(1);
                    break;
                }
                case 9: {
                    if (macObj.count / macObj.retryInterval < macObj.repeatCount) {
                        if (this.timerdebug) {
                            System.out.println("Timer: " + macObj.macString + " State=" + macObj.state);
                        }
                        this.sendPacket(macObj.packet);
                        break;
                    }
                    EventQueue.invokeLater(new NetworkEventSynchronizer(macObj.macString, 7));
                    macObj.newState(1);
                    break;
                }
                case 10: {
                    if (macObj.count / macObj.retryInterval < macObj.repeatCount) {
                        if (this.timerdebug) {
                            System.out.println("Timer: " + macObj.macString + " State=" + macObj.state);
                        }
                        this.sendPacket(macObj.packet);
                        break;
                    }
                    EventQueue.invokeLater(new NetworkEventSynchronizer(macObj.macString, 9));
                    macObj.newState(1);
                    break;
                }
                case 7: 
                case 8: {
                    if (macObj.count / macObj.retryInterval < macObj.repeatCount) {
                        if (this.timerdebug) {
                            System.out.println("Timer: " + macObj.macString + " State=" + macObj.state);
                        }
                        this.sendPacket(macObj.packet);
                        break;
                    }
                    EventQueue.invokeLater(new NetworkEventSynchronizer(macObj.macString, 11));
                    macObj.newState(1);
                    this.configFunctionsObject.CookieRequestSend(macObj.macString);
                }
            }
        }
    }

    public void setConfigFunctionsObject(ConfigurationFunctions configurationFunctions) {
        this.configFunctionsObject = configurationFunctions;
    }

    public synchronized boolean sendPacket(ParamPacket paramPacket) {
        byte[] byArray;
        boolean bl = false;
        String string = paramPacket.getProxy();
        boolean bl2 = false;
        InetAddress inetAddress = null;
        try {
            if (string != null) {
                inetAddress = InetAddress.getByName(string);
                bl2 = true;
            } else {
                byArray = new byte[]{-1, -1, -1, -1};
                inetAddress = InetAddress.getByAddress(byArray);
                bl = true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            GuiInfoConsole.showError("invalid proxy address");
            return false;
        }
        if (!this.changeSocket(bl, EthIf.actualAddr, bl2)) {
            this.error_string = "sendPacket - socket error";
            System.out.println(this.error_string);
            return false;
        }
        byArray = paramPacket.getBytes();
        if (byArray == null) {
            this.error_string = "packet conversion failed";
            return false;
        }
        try {
            DatagramPacket datagramPacket = new DatagramPacket(byArray, paramPacket.length(), this.ds.getLocalSocketAddress());
            datagramPacket.setAddress(inetAddress);
            this.ds.send(datagramPacket);
        }
        catch (SocketException socketException) {
            this.error_string = "can't create datagram packet";
            return false;
        }
        catch (IOException iOException) {
            this.error_string = "sendPacket socket IO Exception";
            return false;
        }
        return true;
    }

    public synchronized boolean addRfpOperation(ParamPacket paramPacket, int n) {
        byte[] byArray = paramPacket.getDestinationMac();
        MacObj macObj = this.getMAC(byArray);
        if (macObj == null) {
            macObj = this.addMAC(byArray, null);
            macObj.macString = this.convertMacToString(byArray);
        }
        if (macObj.state != 1) {
            return false;
        }
        macObj.packet = paramPacket;
        macObj.state = n;
        return true;
    }

    private void ThreadCleanup(String string) {
        this.error_string = string;
        System.out.println(string);
        if (this.socketOpen) {
            this.ds.close();
            this.socketOpen = false;
        }
    }

    private byte[] extractMacAddr(byte[] byArray, int n) {
        byte[] byArray2 = new byte[]{byArray[2], byArray[3], byArray[4], byArray[5], byArray[6], byArray[7]};
        return byArray2;
    }

    private String convertMacToString(byte[] byArray) {
        return String.format("%1$02x:%2$02x:%3$02x:%4$02x:%5$02x:%6$02x", byArray[0], byArray[1], byArray[2], byArray[3], byArray[4], byArray[5]);
    }

    public static Param processParamString(RfpRecord rfpRecord, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\u0000");
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            ParamsEnum paramsEnum;
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf("=");
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            try {
                paramsEnum = ParamsEnum.valueOf(string3);
            }
            catch (Exception exception) {
                paramsEnum = null;
            }
            if (paramsEnum == ParamsEnum.version_mismatch) {
                if (string4.length() >= 32) {
                    object = new byte[string4.length() / 2];
                    for (int i = 0; i < string4.length() / 2; ++i) {
                        byte by = Byte.parseByte(string4.substring(2 * i, 2 * i + 1), 16);
                        byte by2 = Byte.parseByte(string4.substring(2 * i + 1, 2 * i + 2), 16);
                        int n2 = by2 | by << 4;
                        object[i] = (byte)n2;
                    }
                    Param param = new Param();
                    param.id = ParamsEnum.version_mismatch;
                    param.valueBytes = (byte[])object;
                    return param;
                }
                return null;
            }
            if (paramsEnum == ParamsEnum.cookie) {
                object = new Param();
                ((Param)object).id = ParamsEnum.cookie;
                ((Param)object).valueString = string4;
                return object;
            }
            if (rfpRecord == null) continue;
            if (paramsEnum != null) {
                if (paramsEnum == ParamsEnum.use_local_cfg) {
                    bl = true;
                }
                if (paramsEnum.dbIdx != 0) {
                    rfpRecord.setField(paramsEnum.dbIdx, string4);
                    continue;
                }
            }
            if ((object = ConfigReader.getParamFromConfig(string3, false)) != null) {
                if (((ConfigRow)object).isInvisible()) continue;
                rfpRecord.addExtraParameter(((ConfigRow)object).getDisplayName(), string4);
                continue;
            }
            rfpRecord.addExtraParameter(string3, string4);
        }
        if (!bl && rfpRecord != null) {
            rfpRecord.setField(3, "0");
        }
        return null;
    }

    private void processScanResp(byte[] byArray, int n) {
        byte[] byArray2 = this.extractMacAddr(byArray, n);
        String string = this.convertMacToString(byArray2);
        String string2 = new String(byArray, 9, n - 13);
        MacObj macObj = this.getMAC(byArray2);
        if (macObj == null) {
            macObj = this.addMAC(byArray2, string2);
            macObj.macString = string;
            macObj.state = 2;
        }
        if (macObj.state == 2) {
            if (this.configFunctionsObject != null) {
                if (this.configFunctionsObject.requestConfigAfterScan) {
                    if (!this.configFunctionsObject.showAccessedRfpOnly) {
                        EventQueue.invokeLater(new NetworkEventSynchronizer(string, 1));
                    }
                    ParamPacket paramPacket = this.configFunctionsObject.buildListPacket(byArray2);
                    paramPacket.setProxy(this.configFunctionsObject.proxy);
                    macObj.packet = paramPacket;
                    macObj.newState(3);
                    this.sendPacket(paramPacket);
                } else {
                    EventQueue.invokeLater(new NetworkEventSynchronizer(string, 1));
                }
            } else {
                EventQueue.invokeLater(new NetworkEventSynchronizer(string, 1));
            }
        }
        if (macObj.state == 2) {
            macObj.newState(1);
        }
    }

    private void processListResp(byte[] byArray, int n) {
        byte[] byArray2 = this.extractMacAddr(byArray, n);
        String string = this.convertMacToString(byArray2);
        String string2 = new String(byArray, 9, n - 13);
        MacObj macObj = this.getMAC(byArray2);
        if (macObj == null) {
            return;
        }
        Param param = NewNetworkThread.processParamString(null, string2);
        if (param != null) {
            if (param.id == ParamsEnum.version_mismatch && macObj.state == 3) {
                macObj.packet.setChallenge(param.valueBytes);
                if (this.sendPacket(macObj.packet)) {
                    macObj.newState(4);
                }
            }
        } else {
            EventQueue.invokeLater(new NetworkEventSynchronizer(string, 2, string2));
        }
        if (macObj.state != 4) {
            macObj.state = 1;
        }
    }

    private void processCookieResp(byte[] byArray, int n) {
        byte[] byArray2 = this.extractMacAddr(byArray, n);
        String string = this.convertMacToString(byArray2);
        String string2 = new String(byArray, 9, n - 13);
        MacObj macObj = this.getMAC(byArray2);
        if (macObj == null) {
            return;
        }
        if (macObj.state != 9) {
            return;
        }
        Param param = NewNetworkThread.processParamString(null, string2);
        if (param != null && param.id == ParamsEnum.cookie) {
            EventQueue.invokeLater(new NetworkEventSynchronizer(string, 6, param.valueString));
        }
        macObj.state = 1;
    }

    private void processBackdoorResp(byte[] byArray, int n) {
        byte[] byArray2 = this.extractMacAddr(byArray, n);
        String string = this.convertMacToString(byArray2);
        MacObj macObj = this.getMAC(byArray2);
        if (macObj == null) {
            return;
        }
        if (macObj.state != 9) {
            return;
        }
        EventQueue.invokeLater(new NetworkEventSynchronizer(string, 8, null));
        macObj.state = 1;
    }

    private void processSetResp(byte[] byArray, int n) {
        byte[] byArray2 = this.extractMacAddr(byArray, n);
        String string = this.convertMacToString(byArray2);
        String string2 = new String(byArray, 9, n - 13);
        MacObj macObj = this.getMAC(byArray2);
        if (macObj == null) {
            return;
        }
        Param param = NewNetworkThread.processParamString(null, string2);
        if (param != null) {
            if (param.id == ParamsEnum.version_mismatch && macObj.state == 5) {
                macObj.packet.setChallenge(param.valueBytes);
                if (this.sendPacket(macObj.packet)) {
                    macObj.newState(6);
                } else {
                    EventQueue.invokeLater(new NetworkEventSynchronizer(macObj.macString, 5));
                }
            }
        } else {
            EventQueue.invokeLater(new NetworkEventSynchronizer(string, 3, string2));
        }
        if (macObj.state != 6) {
            macObj.newState(1);
        }
    }

    private void processListV2Resp(byte[] byArray, int n) {
        byte[] byArray2 = this.extractMacAddr(byArray, n);
        String string = this.convertMacToString(byArray2);
        String string2 = new String(byArray, 9, n - 13);
        MacObj macObj = this.getMAC(byArray2);
        if (macObj == null) {
            return;
        }
        if (macObj.state == 4) {
            EventQueue.invokeLater(new NetworkEventSynchronizer(string, 2, string2));
        }
        macObj.newState(1);
    }

    private void processSetV2Resp(byte[] byArray, int n) {
        byte[] byArray2 = this.extractMacAddr(byArray, n);
        String string = this.convertMacToString(byArray2);
        String string2 = new String(byArray, 9, n - 13);
        MacObj macObj = this.getMAC(byArray2);
        if (macObj == null) {
            return;
        }
        if (macObj.state == 6) {
            EventQueue.invokeLater(new NetworkEventSynchronizer(string, 3, string2));
        }
        macObj.newState(1);
    }

    private void processResetResp(byte[] byArray, int n) {
        byte[] byArray2 = this.extractMacAddr(byArray, n);
        String string = this.convertMacToString(byArray2);
        String string2 = new String(byArray, 9, n - 13);
        MacObj macObj = this.getMAC(byArray2);
        if (macObj == null) {
            return;
        }
        System.out.println("reset response id=" + (byArray[0] << 8 | byArray[1]) + " mac=" + string);
        Param param = NewNetworkThread.processParamString(null, string2);
        if (param != null) {
            if (param.id == ParamsEnum.version_mismatch) {
                System.out.println("reset response version mismatch received, state=" + macObj.state);
                if (macObj.state == 7) {
                    macObj.packet.setChallenge(param.valueBytes);
                    if (this.sendPacket(macObj.packet)) {
                        macObj.newState(8);
                        System.out.println("send Reset V2 " + string);
                    } else {
                        macObj.newState(1);
                        this.configFunctionsObject.CookieRequestSend(string);
                    }
                }
            }
        } else if (macObj.state == 7) {
            EventQueue.invokeLater(new NetworkEventSynchronizer(string, 10, string2));
        }
        if (macObj.state != 8 && macObj.state != 9) {
            macObj.newState(1);
        }
    }

    private void processResetRespV2(byte[] byArray, int n) {
        byte[] byArray2 = this.extractMacAddr(byArray, n);
        String string = this.convertMacToString(byArray2);
        String string2 = new String(byArray, 9, n - 13);
        MacObj macObj = this.getMAC(byArray2);
        if (macObj == null) {
            return;
        }
        System.out.println("reset V2 response id=" + (byArray[0] << 8 | byArray[1]) + " mac=" + string);
        Param param = NewNetworkThread.processParamString(null, string2);
        if (param != null) {
            if (param.id == ParamsEnum.version_mismatch && macObj.state == 8) {
                macObj.newState(1);
                this.configFunctionsObject.CookieRequestSend(string);
            }
        } else if (macObj.state == 8) {
            EventQueue.invokeLater(new NetworkEventSynchronizer(string, 10, string2));
        }
        if (macObj.state != 9) {
            macObj.newState(1);
        }
    }

    private boolean changeSocket(boolean bl, InetAddress inetAddress, boolean bl2) {
        if (this.socketOpen) {
            if (this.broadcast == bl && inetAddress.equals(this.sendfromAddr) && this.useProxy == bl2) {
                return true;
            }
            this.ds.close();
            if (this.rxThread2.receiveActive) {
                while (this.rxThread2.socketOpen) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (this.dsrecv != this.ds) {
                this.dsrecv.close();
            }
            while (this.socketOpen) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        try {
            if (inetAddress != null) {
                this.ds = new DatagramSocket(null);
                this.ds.setReuseAddress(true);
                this.ds.bind(new InetSocketAddress(inetAddress, 64000));
                if (!bl2) {
                    this.dsrecv = new DatagramSocket(null);
                    this.dsrecv.setReuseAddress(true);
                    this.dsrecv.bind(new InetSocketAddress(64000));
                    this.rxThread2.receiveActive = true;
                    this.rxThread2.socketOpen = true;
                } else {
                    this.dsrecv = this.ds;
                }
            } else {
                this.dsrecv = this.ds = new DatagramSocket(64000);
            }
            if (!this.ds.isBound()) {
                this.ds.close();
                System.out.println("NetworkThread: DatagramSocket create failed");
                return false;
            }
        }
        catch (SocketException socketException) {
            EventQueue.invokeLater(new NetworkEventSynchronizer("bind failed    [" + socketException.getMessage() + "]", 4));
            return false;
        }
        try {
            this.ds.setBroadcast(bl);
            this.dsrecv.setBroadcast(bl);
        }
        catch (SocketException socketException) {
            this.error_string = "socket setBroadcast failed";
            System.out.println(this.error_string);
            return false;
        }
        this.sendfromAddr = inetAddress;
        this.broadcast = bl;
        this.socketOpen = true;
        this.useProxy = bl2;
        try {
            Thread.sleep(30L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    public synchronized void processReceivedDataPacket(int n, byte[] object, int n2, InetAddress inetAddress) {
        block18: {
            block19: {
                Object object2;
                if (n2 < 9) {
                    return;
                }
                if ((object[8] & 0xCF) == 8) {
                    if (n2 < 13) {
                        return;
                    }
                    CRCSum cRCSum = new CRCSum((byte[])object, n2);
                    if (cRCSum.checkCRC()) {
                        object2 = new byte[((byte[])object).length - 13];
                        for (int i = 0; i < ((byte[])object).length - 13; ++i) {
                            object2[i] = object[9 + i];
                        }
                        object = object2;
                        n2 -= 13;
                    } else {
                        return;
                    }
                }
                if (n2 < 9) {
                    return;
                }
                byte by = object[8];
                if ((by & 0x10) == 0) break block18;
                object2 = new CRCSum((byte[])object, n2);
                if (!((CRCSum)object2).checkCRC()) break block19;
                switch (by & 0xF) {
                    case 5: {
                        this.processScanResp((byte[])object, n2);
                        break block18;
                    }
                    case 2: {
                        this.processListResp((byte[])object, n2);
                        break block18;
                    }
                    case 4: {
                        this.processListV2Resp((byte[])object, n2);
                        break block18;
                    }
                    case 1: {
                        this.processSetResp((byte[])object, n2);
                        break block18;
                    }
                    case 3: {
                        this.processSetV2Resp((byte[])object, n2);
                        break block18;
                    }
                    case 9: {
                        this.processResetResp((byte[])object, n2);
                        break block18;
                    }
                    case 10: {
                        this.processResetRespV2((byte[])object, n2);
                        break block18;
                    }
                    case 6: {
                        this.processCookieResp((byte[])object, n2);
                        break block18;
                    }
                    case 7: {
                        this.processBackdoorResp((byte[])object, n2);
                    }
                    default: {
                        System.out.println(String.format("received action %02X from", by) + inetAddress.toString());
                        return;
                    }
                }
            }
            return;
        }
    }

    @Override
    public void run() {
        this.rxThread2.start();
        this.changeSocket(true, EthIf.actualAddr, false);
        while (true) {
            if (this.socketOpen) {
                DatagramPacket datagramPacket;
                try {
                    datagramPacket = new DatagramPacket(new byte[2000], 2000, this.ds.getLocalSocketAddress());
                }
                catch (Exception exception) {
                    this.ThreadCleanup("can't create datagram packet for rx");
                    return;
                }
                try {
                    this.dsrecv.receive(datagramPacket);
                }
                catch (IOException iOException) {
                    this.socketOpen = false;
                    this.ThreadCleanup("RX socket IO error");
                    continue;
                }
                this.processReceivedDataPacket(1, datagramPacket.getData(), datagramPacket.getLength(), datagramPacket.getAddress());
                continue;
            }
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private class SecondRxThread
    extends Thread {
        public boolean receiveActive = false;
        public boolean socketOpen = false;

        private SecondRxThread() {
        }

        @Override
        public void run() {
            while (true) {
                if (this.socketOpen && this.receiveActive) {
                    DatagramPacket datagramPacket;
                    try {
                        datagramPacket = new DatagramPacket(new byte[2000], 2000, NewNetworkThread.this.ds.getLocalSocketAddress());
                    }
                    catch (Exception exception) {
                        NewNetworkThread.this.ThreadCleanup("RXThread2: can't create datagram packet for rx");
                        return;
                    }
                    try {
                        NewNetworkThread.this.ds.receive(datagramPacket);
                    }
                    catch (IOException iOException) {
                        this.socketOpen = false;
                        this.receiveActive = false;
                        System.out.println("RX Thread 2 socket IO error");
                        continue;
                    }
                    NewNetworkThread.this.processReceivedDataPacket(2, datagramPacket.getData(), datagramPacket.getLength(), datagramPacket.getAddress());
                    continue;
                }
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    public static class Param {
        ParamsEnum id;
        String valueString;
        byte[] valueBytes;
    }
}

