/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omcfg.rfpcfg;

import com.aastra.omcfg.rfpcfg.RfpRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.DatabaseChangeEvent;

public class RfpDatabase
extends Database {
    public static final int MAX_RFP = 4096;
    public static int maxRfp = 4096;
    private RfpRecord[] rfpArray = new RfpRecord[maxRfp];
    private int[] rfpIdxArray = new int[maxRfp];
    private int AnzRecords = 0;
    private int maxRfpId = 0;

    public RfpDatabase() {
        for (int i = 0; i < maxRfp; ++i) {
            this.rfpIdxArray[i] = -1;
        }
    }

    @Override
    public RfpRecord getRecordByIdx(int n) {
        if (n >= 0 && n < this.AnzRecords && this.rfpArray[this.rfpIdxArray[n]] != null) {
            return this.rfpArray[this.rfpIdxArray[n]];
        }
        return null;
    }

    public RfpRecord getRecordByMac(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i <= this.maxRfpId; ++i) {
            String string2;
            Object object;
            if (this.rfpArray[i] == null || (object = this.rfpArray[i].getField(2)) == null || !string.equals(string2 = (String)object)) continue;
            return this.rfpArray[i];
        }
        return null;
    }

    @Override
    public int getRecordNumber() {
        return this.AnzRecords;
    }

    @Override
    public String[] getFieldNames() {
        return RfpRecord.getFieldNames();
    }

    public void clearAll() {
        for (int i = 0; i <= this.maxRfpId; ++i) {
            this.rfpArray[i] = null;
        }
        this.maxRfpId = 0;
        this.AnzRecords = 0;
        this.updateIndex(new DatabaseChangeEvent(Database.DatabaseChangeEnum.INDEX_UPDATE, 0, DatabaseChangeEvent.DatabaseChangeType.RFP));
    }

    @Override
    public void updateIndex() {
        this.updateIndex(new DatabaseChangeEvent(Database.DatabaseChangeEnum.INDEX_UPDATE, 0, DatabaseChangeEvent.DatabaseChangeType.RFP));
    }

    public void updateIndex(DatabaseChangeEvent databaseChangeEvent) {
        int n = -1;
        this.AnzRecords = 0;
        for (int i = 0; i <= this.maxRfpId; ++i) {
            if (this.rfpArray[i] == null) continue;
            if (this.rfpArray[i].deleted) {
                this.rfpArray[i] = null;
                continue;
            }
            if (this.getFilterActive()) {
                if (!this.filterMatch(this.rfpArray[i])) continue;
                if (databaseChangeEvent.recordId == i) {
                    n = this.AnzRecords;
                }
                this.rfpIdxArray[this.AnzRecords++] = i;
                continue;
            }
            if (databaseChangeEvent.recordId == i) {
                n = this.AnzRecords;
            }
            this.rfpIdxArray[this.AnzRecords++] = i;
        }
        if (n != -1) {
            databaseChangeEvent.modelId = n;
        }
        this.generateChangeNotification(databaseChangeEvent);
    }

    public RfpRecord createRfp(RfpRecord rfpRecord) {
        int n = (Integer)rfpRecord.getField(0);
        DatabaseChangeEvent databaseChangeEvent = new DatabaseChangeEvent(Database.DatabaseChangeEnum.RECORD_ADDED, n, DatabaseChangeEvent.DatabaseChangeType.RFP);
        if (n >= 0 && n < maxRfp) {
            if (n > this.maxRfpId) {
                this.maxRfpId = n;
            }
            if (this.rfpArray[n] != null) {
                databaseChangeEvent.cause = Database.DatabaseChangeEnum.RECORD_CHANGED;
            }
            this.rfpArray[n] = rfpRecord;
            this.updateIndex(databaseChangeEvent);
            return this.rfpArray[n];
        }
        return null;
    }

    public RfpRecord createRfp(String string) {
        RfpRecord rfpRecord = this.getRecordByMac(string);
        if (rfpRecord != null) {
            return rfpRecord;
        }
        for (int i = 0; i <= this.maxRfpId; ++i) {
            if (this.rfpArray[i] != null) continue;
            rfpRecord = new RfpRecord(i);
            rfpRecord.setField(2, string);
            return this.createRfp(rfpRecord);
        }
        rfpRecord = new RfpRecord(this.maxRfpId + 1);
        rfpRecord.setField(2, string);
        return this.createRfp(rfpRecord);
    }

    public void deleteRfp(int n) {
        if (n < 0 || n >= maxRfp) {
            return;
        }
        if (this.rfpArray[n] != null) {
            this.rfpArray[n].deleted = true;
        }
        DatabaseChangeEvent databaseChangeEvent = new DatabaseChangeEvent(Database.DatabaseChangeEnum.RECORD_DELETED, n, DatabaseChangeEvent.DatabaseChangeType.RFP);
        this.updateIndex(databaseChangeEvent);
    }

    public void TestCreateRFPs() {
        RfpRecord rfpRecord = new RfpRecord(1);
        rfpRecord.setField(2, "00:30:42:01:02:03");
        this.createRfp(rfpRecord);
        rfpRecord = new RfpRecord(2);
        rfpRecord.setField(2, "00:30:42:01:02:04");
        rfpRecord.setField(3, new Boolean(true));
        rfpRecord.setField(4, "10.103.35.177");
        rfpRecord.setField(5, "255.255.255.0");
        rfpRecord.setField(7, "10.103.35.177");
        rfpRecord.setField(8, "10.103.35.188");
        rfpRecord.setField(6, "10.103.35.1");
        rfpRecord.setField(9, "10.103.35.20");
        rfpRecord.setField(10, "fkrause/iprfp3G.dnld");
        this.createRfp(rfpRecord);
        rfpRecord = new RfpRecord(3);
        rfpRecord.setField(2, "00:30:42:01:02:05");
        rfpRecord.setField(3, new Boolean(false));
        this.createRfp(rfpRecord);
    }
}

