/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.Database;
import com.aastra.omilib.GenericDataRecord;

public class GenericDatabase
extends Database {
    public static final int MAX_ELEM = 50001;
    private GenericDataRecord[] dataArray = new GenericDataRecord[50001];
    private int[] idxArray = new int[50001];
    private int AnzRecords = 0;
    private int maxId = 0;
    private String[] fieldNames = new String[20];

    public GenericDatabase() {
        this.fieldNames[0] = "id";
        for (int i = 1; i < 20; ++i) {
            this.fieldNames[i] = "field " + i;
        }
    }

    public GenericDataRecord getRecordById(int n) {
        return this.dataArray[n];
    }

    @Override
    public GenericDataRecord getRecordByIdx(int n) {
        if (n < this.AnzRecords && this.dataArray[this.idxArray[n]] != null) {
            return this.dataArray[this.idxArray[n]];
        }
        return null;
    }

    public GenericDataRecord createRecord(GenericDataRecord genericDataRecord) {
        int n = (Integer)genericDataRecord.getField(0);
        if (n >= 0 && n < 50001) {
            this.dataArray[n] = genericDataRecord;
            if (n > this.maxId) {
                this.maxId = n;
            }
            this.updateIndex();
            return this.dataArray[n];
        }
        return null;
    }

    public void deleteRecord(int n) {
        if (this.dataArray[n] != null) {
            this.dataArray[n].deleted = true;
            this.updateIndex();
        }
    }

    @Override
    public void updateIndex() {
        this.AnzRecords = 0;
        for (int i = 0; i <= this.maxId; ++i) {
            if (this.dataArray[i] == null) continue;
            if (this.dataArray[i].deleted) {
                this.dataArray[i] = null;
                continue;
            }
            this.idxArray[this.AnzRecords++] = i;
        }
        this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
    }

    @Override
    public int getRecordNumber() {
        return this.AnzRecords;
    }

    public void setFieldName(int n, String string) {
        if (n >= 0 && n < 20) {
            this.fieldNames[n] = string;
        }
    }

    public void setFieldNames(String[] stringArray) {
        if (stringArray != null) {
            int n = stringArray.length;
            if (n > 20) {
                n = 20;
            }
            for (int i = 0; i < n; ++i) {
                this.fieldNames[i] = stringArray[i];
            }
        }
    }

    @Override
    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public void clearAll() {
        for (int i = 0; i <= this.maxId; ++i) {
            this.dataArray[i] = null;
        }
        this.maxId = 0;
        this.AnzRecords = 0;
    }
}

