/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilibgui;

import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.DatabaseChangeEvent;
import com.aastra.omilibgui.AastraTableCellEditor;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.omilibgui.ConfiguratorTableModel;
import com.aastra.style.AastraCheckBox;
import com.aastra.style.AastraHeadRenderer;
import com.aastra.style.AastraTable;
import com.aastra.style.AastraTableCellRenderer;
import com.aastra.util.UtilSpy;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class ConfiguratorTable
extends AastraTable
implements Database.DatabaseChangeNotificationInterface,
ListSelectionListener,
TableModelListener {
    private static final long serialVersionUID = 1L;
    private ConfiguratorTableModel tableModel = null;
    private AastraTableCellRenderer cellRenderer = null;
    private AastraTableCellEditor cellEditor = null;
    private Database database = null;
    private ConfiguratorTableEventInterface eventListener = null;
    private MultiSelectionNotificationInterface multiSelectListener = null;
    private JTable table = null;
    private DatabaseChangeEvent.DatabaseChangeType type = DatabaseChangeEvent.DatabaseChangeType.ALL;
    private int selectColumnWidth = 0;
    private int headerHeight = 0;
    private AastraHeadRenderer headRenderer = null;
    private MouseListener[] mouseListenersHeader = null;
    private MouseListener[] mouseListenersBody = null;
    private TableRowSorter<TableModel> tableRowSorter = null;
    private int[] preferredColumnwidthArr = new int[150];
    private boolean tableState = true;
    private int numberOfSelectedRows = 0;

    public ConfiguratorTable(Database database) {
        this.tableModel = new ConfiguratorTableModel(database);
        this.database = database;
        this.database.registerChangeNotificationListener(this);
        this.setModel(this.tableModel);
        for (int i = 0; i < 150; ++i) {
            this.preferredColumnwidthArr[i] = 0;
        }
        this.table = this;
        this.setIntercellSpacing(new Dimension(4, 0));
        this.setShowGrid(false);
        this.setShowVerticalLines(true);
        this.setRowSelectionAllowed(true);
        this.setSelectionMode(2);
        this.setRowSorter(this.getTableRowSorter());
        this.cellRenderer = new AastraTableCellRenderer();
        this.cellEditor = new AastraTableCellEditor(this);
        this.setDefaultRenderer(String.class, this.cellRenderer);
        this.setDefaultRenderer(Integer.class, this.cellRenderer);
        this.setDefaultRenderer(Float.class, this.cellRenderer);
        this.setDefaultRenderer(Boolean.class, this.cellRenderer);
        this.setDefaultRenderer(ImageIcon.class, this.cellRenderer);
        this.setDefaultEditor(Boolean.class, this.cellEditor);
        this.cellRenderer.setTable(this);
        this.tableModel.setCellRenderer(this.cellRenderer);
        JTableHeader jTableHeader = this.getTableHeader();
        this.headRenderer = new AastraHeadRenderer(jTableHeader);
        jTableHeader.setDefaultRenderer(this.headRenderer);
        this.getSelectionModel().addListSelectionListener(this);
        this.selectColumnWidth = new AastraCheckBox().getPreferredSize().width + 2 * this.getIntercellSpacing().width;
        this.headerHeight = new AastraCheckBox().getPreferredSize().height - 3;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = ConfiguratorTable.this.table.rowAtPoint(point);
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_TABLE, this, "Clicked at: " + ConfiguratorTable.this.table.rowAtPoint(point) + " " + ConfiguratorTable.this.table.columnAtPoint(point) + " " + mouseEvent.getClickCount());
                int n2 = ConfiguratorTable.this.table.getSelectedRowCount();
                if (ConfiguratorTable.this.eventListener != null) {
                    if (n2 <= 1) {
                        int n3 = ConfiguratorTable.this.table.convertRowIndexToModel(n);
                        DataRecord dataRecord = ConfiguratorTable.this.database.getRecordByIdx(n3);
                        if (dataRecord != null) {
                            if (mouseEvent.getClickCount() >= 2) {
                                ConfiguratorTable.this.eventListener.processTableMouseDoubleClick(dataRecord.clone());
                            } else {
                                ConfiguratorTable.this.eventListener.processTableMouseClick(dataRecord.clone());
                            }
                        }
                        ConfiguratorTable.this.numberOfSelectedRows = 1;
                    } else {
                        ConfiguratorTable.this.eventListener.processTableMouseClick(null);
                    }
                }
                ConfiguratorTable.this.notifyMultiSelection(n2);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                int n = ConfiguratorTable.this.table.getSelectedRowCount();
                if (ConfiguratorTable.this.multiSelectListener != null && n != ConfiguratorTable.this.numberOfSelectedRows) {
                    ConfiguratorTable.this.notifyMultiSelection(n);
                    ConfiguratorTable.this.numberOfSelectedRows = n;
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                int n = ConfiguratorTable.this.table.getSelectedRowCount();
                if (ConfiguratorTable.this.eventListener != null) {
                    if (n == 1) {
                        int n2 = ConfiguratorTable.this.table.getSelectedRow();
                        int n3 = ConfiguratorTable.this.table.convertRowIndexToModel(n2);
                        DataRecord dataRecord = ConfiguratorTable.this.database.getRecordByIdx(n3);
                        ConfiguratorTable.this.eventListener.processTableSelectionChanged(dataRecord.clone());
                        ConfiguratorTable.this.numberOfSelectedRows = 1;
                    } else {
                        ConfiguratorTable.this.eventListener.processTableSelectionChanged(null);
                    }
                }
                ConfiguratorTable.this.notifyMultiSelection(n);
            }
        });
    }

    private void notifyMultiSelection(int n) {
        if (this.multiSelectListener != null && n > 1) {
            int[] nArray = this.getSelectedRows();
            DataRecord[] dataRecordArray = new DataRecord[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = this.convertRowIndexToModel(nArray[i]);
                dataRecordArray[i] = this.database.getRecordByIdx(n2).clone();
            }
            this.multiSelectListener.processMultiSelectionChanged(dataRecordArray);
        }
    }

    public void registerEventListener(ConfiguratorTableEventInterface configuratorTableEventInterface) {
        this.eventListener = configuratorTableEventInterface;
    }

    public void registerMultiSelectListener(MultiSelectionNotificationInterface multiSelectionNotificationInterface) {
        this.multiSelectListener = multiSelectionNotificationInterface;
    }

    public boolean getSelectColumnEnabled() {
        return this.tableModel.getSelectColumnEnabled();
    }

    public int[] getActiveColumnArr() {
        return this.tableModel.getActiveColumnArr();
    }

    public int[] getActiveTextColumnArr() {
        return this.tableModel.getActiveTextColumnArr();
    }

    public void setColumnArr(int[] nArray, int n) {
        if (n > nArray.length) {
            n = nArray.length;
        }
        this.tableModel.setActiveColumnArr(nArray);
        this.tableModel.activeColumnNumber = n;
        this.tableStructureChange();
        this.applyPreferredColumnWidthSettings();
    }

    public void setPreferredColumnWidth(int n, int n2) {
        if (n < 150) {
            this.preferredColumnwidthArr[n] = n2;
        }
    }

    public void applyPreferredColumnWidthSettings() {
        int[] nArray = this.tableModel.getActiveColumnArr();
        for (int i = 0; i < 150; ++i) {
            TableColumn tableColumn;
            if (this.preferredColumnwidthArr[i] == 0) continue;
            int n = -1;
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] != i) continue;
                n = j;
                break;
            }
            if (n == -1) continue;
            if (this.tableModel.getSelectColumnEnabled()) {
                ++n;
            }
            if ((tableColumn = this.getColumnModel().getColumn(n)) == null) continue;
            tableColumn.setPreferredWidth(this.preferredColumnwidthArr[i]);
        }
    }

    public void tableStructureChange() {
        this.tableModel.fireTableStructureChanged();
        if (this.getSelectionModel().getSelectionMode() != 0) {
            TableColumn tableColumn = this.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(this.selectColumnWidth);
            tableColumn.setMaxWidth(this.selectColumnWidth);
            tableColumn.setMinWidth(this.selectColumnWidth);
            tableColumn.setResizable(false);
        }
        this.reassignTableRowSorterIconComparators();
        this.tableModel.updateRendererOptions();
    }

    @Override
    public void doLayout() {
        if (this.getSelectionModel().getSelectionMode() != 0) {
            TableColumn tableColumn = this.getColumnModel().getColumn(this.convertColumnIndexToView(0));
            tableColumn.setPreferredWidth(this.selectColumnWidth);
            tableColumn.setMaxWidth(this.selectColumnWidth);
            tableColumn.setMinWidth(this.selectColumnWidth);
            tableColumn.setResizable(false);
            this.getTableHeader().setPreferredSize(new Dimension(this.table.getColumnModel().getTotalColumnWidth(), this.headerHeight));
        }
        super.doLayout();
    }

    public int getActiveColumnNumber() {
        return this.tableModel.activeColumnNumber;
    }

    public String[] getColumnNamesArr() {
        return this.tableModel.getColumnNames();
    }

    public void replaceDb(Database database) {
        if (database != null) {
            this.database.deregisterChangeNotificationListener(this);
            this.database = database;
            this.database.registerChangeNotificationListener(this);
            this.tableModel.fireTableDataChanged();
        }
    }

    public void setFilter(Integer n, String string, int n2) {
        this.database.setFilter(n, string, n2);
        this.database.updateIndex();
        this.tableModel.fireTableDataChanged();
    }

    public boolean getFilterActive() {
        return this.database.getFilterActive();
    }

    public void setIconArray(int n, ImageIcon[] imageIconArray) {
        this.tableModel.setIconArray(n, imageIconArray);
        this.initTableRowSorterIconComparator(n);
    }

    public ConfiguratorTableModel.ImageIconArray getImageIconArray(int n) {
        return this.tableModel.getImageIconArray(n);
    }

    public void setPasswordColum(int n) {
        this.tableModel.setPasswordColum(n);
    }

    @Override
    public void databaseChangeNotification(DatabaseChangeEvent databaseChangeEvent) {
        if (databaseChangeEvent.type != this.type && this.type != DatabaseChangeEvent.DatabaseChangeType.ALL) {
            return;
        }
        if (databaseChangeEvent.cause == Database.DatabaseChangeEnum.INDEX_UPDATE) {
            this.tableModel.fireTableDataChanged();
        }
        if (databaseChangeEvent.cause == Database.DatabaseChangeEnum.RECORD_ADDED) {
            this.tableModel.fireTableDataChanged();
        }
        if (databaseChangeEvent.cause == Database.DatabaseChangeEnum.RECORD_CHANGED) {
            if (databaseChangeEvent.modelId < this.database.getRecordNumber()) {
                this.tableModel.fireTableRowsUpdated(databaseChangeEvent.modelId, databaseChangeEvent.modelId);
            } else {
                this.tableModel.fireTableDataChanged();
            }
        }
        if (databaseChangeEvent.cause == Database.DatabaseChangeEnum.RECORD_DELETED) {
            this.tableModel.fireTableDataChanged();
        }
        this.updateAllSelectedBox();
    }

    public void setColumnFormatString(int n, String string) {
        this.database.setFieldFormatString(n, string);
        this.tableModel.updateRendererOptions();
    }

    public void setNegativeIntAsInvalid(int n) {
        this.tableModel.setNegativeIntAsInvalid(n);
    }

    public void setZeroIntAsInvalid(int n) {
        this.tableModel.setZeroIntAsInvalid(n);
    }

    @Override
    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        if (this.convertColumnIndexToModel(n2) == 0 && this.getSelectionModel().getSelectionMode() != 0) {
            bl = true;
        }
        super.changeSelection(n, n2, bl, bl2);
        this.updateAllSelectedBox();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.table.getSelectedRowCount();
        if (listSelectionEvent.getValueIsAdjusting() && n == 0) {
            return;
        }
        if ((n == 0 || n == this.table.getRowCount()) && n != this.numberOfSelectedRows) {
            this.notifyMultiSelection(n);
            if (this.eventListener != null) {
                this.eventListener.processTableSelectionChanged(null);
            }
            this.numberOfSelectedRows = n;
        }
        super.valueChanged(listSelectionEvent);
    }

    public void setType(DatabaseChangeEvent.DatabaseChangeType databaseChangeType) {
        this.type = databaseChangeType;
    }

    public void unselect(int n) {
        int n2 = this.table.convertRowIndexToView(n);
        super.changeSelection(n2, 0, true, false);
    }

    public void removeRowSelectionAll() {
        if (this.table.getSelectedRowCount() > 0) {
            this.table.removeRowSelectionInterval(0, this.table.getRowCount() - 1);
        }
    }

    @Override
    public void setSelectionMode(int n) {
        boolean bl = n != 0;
        this.tableModel.selectionColumnState(bl);
        this.tableModel.fireTableStructureChanged();
        super.setSelectionMode(n);
    }

    public void updateAllSelectedBox() {
        if (this.getSelectedRowCount() != this.getRowCount()) {
            this.headRenderer.setAllSelect(false);
            this.table.getTableHeader().repaint();
        }
    }

    public void setActive(boolean bl) {
        if (this.tableState == bl) {
            return;
        }
        this.tableState = bl;
        if (!bl) {
            this.setEnabled(false);
            for (MouseListener mouseListener : this.mouseListenersHeader = this.getTableHeader().getMouseListeners()) {
                this.getTableHeader().removeMouseListener(mouseListener);
            }
            this.mouseListenersBody = this.getMouseListeners();
            for (MouseListener mouseListener : this.mouseListenersBody) {
                this.removeMouseListener(mouseListener);
            }
            this.cellRenderer.setInactivMode(true);
            this.validate();
        } else {
            this.setEnabled(true);
            for (MouseListener mouseListener : this.mouseListenersHeader) {
                this.getTableHeader().addMouseListener(mouseListener);
            }
            for (MouseListener mouseListener : this.mouseListenersBody) {
                this.addMouseListener(mouseListener);
            }
            this.cellRenderer.setInactivMode(false);
            this.validate();
        }
    }

    public void setColumnHeaderToolTips(String[] stringArray) {
        ColumnHeaderToolTips columnHeaderToolTips = new ColumnHeaderToolTips();
        int[] nArray = this.tableModel.getActiveColumnArr();
        for (int i = 0; i < nArray.length; ++i) {
            TableColumn tableColumn = this.table.getColumnModel().getColumn(i);
            columnHeaderToolTips.setToolTip(tableColumn, stringArray[nArray[i]]);
        }
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.addMouseMotionListener(columnHeaderToolTips);
    }

    private TableRowSorter<TableModel> getTableRowSorter() {
        if (this.tableRowSorter == null) {
            this.tableRowSorter = new TableRowSorter<ConfiguratorTableModel>(this.tableModel);
        }
        return this.tableRowSorter;
    }

    private void initTableRowSorterIconComparator(int n) {
        if (n >= 0 && n < 150) {
            this.setActiveTableRowSorterIconComparator(n);
        }
    }

    private void reassignTableRowSorterIconComparators() {
        for (int i = 0; i < 150; ++i) {
            if (this.tableModel.getIconArray(i) == null) continue;
            this.setActiveTableRowSorterIconComparator(i);
        }
    }

    private void setActiveTableRowSorterIconComparator(int n) {
        int[] nArray = this.tableModel.getActiveColumnArr();
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            this.setTableRowSorterComparator(i, this.tableModel.getIconArray(n));
        }
    }

    private void setTableRowSorterComparator(int n, final ImageIcon[] imageIconArray) {
        if (this.tableRowSorter != null) {
            if (this.getSelectionModel().getSelectionMode() != 0) {
                ++n;
            }
            this.tableRowSorter.setComparator(n, new Comparator<ImageIcon>(){

                @Override
                public int compare(ImageIcon imageIcon, ImageIcon imageIcon2) {
                    int n = 0;
                    int n2 = 0;
                    for (n = 0; n < imageIconArray.length && !imageIcon.equals(imageIconArray[n]); ++n) {
                    }
                    for (n2 = 0; n2 < imageIconArray.length && !imageIcon2.equals(imageIconArray[n2]); ++n2) {
                    }
                    return n - n2;
                }
            });
        }
    }

    public class ColumnHeaderToolTips
    extends MouseMotionAdapter {
        TableColumn curCol;
        Map<TableColumn, String> tips = new HashMap<TableColumn, String>();

        public void setToolTip(TableColumn tableColumn, String string) {
            if (string == null) {
                this.tips.remove(tableColumn);
            } else {
                this.tips.put(tableColumn, string);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            TableColumn tableColumn = null;
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            JTable jTable = jTableHeader.getTable();
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            if (n >= 0) {
                tableColumn = tableColumnModel.getColumn(n);
            }
            if (tableColumn != this.curCol) {
                jTableHeader.setToolTipText(this.tips.get(tableColumn));
                this.curCol = tableColumn;
            }
        }
    }

    public static interface MultiSelectionNotificationInterface {
        public void processMultiSelectionChanged(DataRecord[] var1);
    }
}

