/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilibgui;

import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.style.AastraTableCellRenderer;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;

public class ConfiguratorTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    public static final int MAX_COLUM = 150;
    private boolean selectColumnEnabled = true;
    private Database database;
    public int activeColumnNumber = 1;
    private ArrayList<Integer> activeColumnArr = null;
    ImageIconArray[] iconArrays = new ImageIconArray[150];
    boolean[] password = new boolean[150];
    boolean[] negativeAsInvalid = null;
    boolean[] zeroAsInvalid = null;
    private AastraTableCellRenderer cellRenderer = null;
    private static final String pwString = "<html>&bull&bull&bull&bull&bull&bull&bull</html>";

    public ConfiguratorTableModel(Database database) {
        this.database = database;
        this.activeColumnArr = new ArrayList(9);
        for (int i = 0; i < 9; ++i) {
            this.activeColumnArr.add(i);
        }
    }

    public boolean getSelectColumnEnabled() {
        return this.selectColumnEnabled;
    }

    @Override
    public int getColumnCount() {
        int n = this.activeColumnNumber;
        if (this.selectColumnEnabled) {
            ++n;
        }
        return n;
    }

    @Override
    public int getRowCount() {
        return this.database.getRecordNumber();
    }

    @Override
    public String getColumnName(int n) {
        if (this.selectColumnEnabled) {
            if (n == 0) {
                return "";
            }
            return this.database.getFieldNames()[this.activeColumnArr.get(n - 1)];
        }
        return this.database.getFieldNames()[this.activeColumnArr.get(n)];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 0 && this.selectColumnEnabled) {
            return false;
        }
        DataRecord dataRecord = this.database.getRecordByIdx(n);
        if (dataRecord != null) {
            int n3 = this.selectColumnEnabled ? this.activeColumnArr.get(n2 - 1).intValue() : this.activeColumnArr.get(n2).intValue();
            if (this.password[n3]) {
                return pwString;
            }
            Object object = dataRecord.getField(n3);
            if (object != null) {
                if (object instanceof Enum) {
                    if (n3 < 150 && this.iconArrays[n3] != null && ((Enum)object).ordinal() < this.iconArrays[n3].icons.length) {
                        return this.iconArrays[n3].icons[((Enum)object).ordinal()];
                    }
                    return object.toString();
                }
                if (object instanceof Boolean && n3 < 150 && this.iconArrays[n3] != null && this.iconArrays[n3].icons.length >= 2) {
                    if (((Boolean)object).booleanValue()) {
                        return this.iconArrays[n3].icons[1];
                    }
                    return this.iconArrays[n3].icons[0];
                }
                return object;
            }
        }
        return "-";
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (this.getRowCount() == 0) {
            return String.class;
        }
        Object object = this.getValueAt(0, n);
        if (object == null) {
            return String.class;
        }
        if (object instanceof Enum) {
            return String.class;
        }
        return object.getClass();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 0 && this.selectColumnEnabled;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
    }

    public String[] getColumnNames() {
        return this.database.getFieldNames();
    }

    public void setIconArray(int n, ImageIcon[] imageIconArray) {
        if (n >= 0 && n < 150) {
            this.iconArrays[n] = new ImageIconArray();
            this.iconArrays[n].icons = imageIconArray;
        }
    }

    public ImageIcon[] getIconArray(int n) {
        if (n >= 0 && n < 150 && this.iconArrays[n] != null) {
            return this.iconArrays[n].icons;
        }
        return null;
    }

    public ImageIconArray getImageIconArray(int n) {
        if (n >= 0 && n < 150) {
            return this.iconArrays[n];
        }
        return null;
    }

    public void setPasswordColum(int n) {
        if (n >= 0 && n < 150) {
            this.password[n] = true;
        }
    }

    public void updateRendererOptions() {
        if (this.cellRenderer != null) {
            this.cellRenderer.resetFormatStrings();
            this.cellRenderer.resetNegativeIntegerAsInvalid();
            this.cellRenderer.resetZeroIntegerAsInvalid();
            int n = this.selectColumnEnabled ? 1 : 0;
            for (int i = 0; i < this.activeColumnNumber; ++i) {
                if (this.database.getFieldFormatString(this.activeColumnArr.get(i)) != null) {
                    this.cellRenderer.setFormatString(i + n, this.database.getFieldFormatString(this.activeColumnArr.get(i)));
                }
                if (this.negativeAsInvalid != null && this.negativeAsInvalid[this.activeColumnArr.get(i)]) {
                    this.cellRenderer.setNegativeIntegerAsInvalid(i + n, true);
                }
                if (this.zeroAsInvalid == null || !this.zeroAsInvalid[this.activeColumnArr.get(i)]) continue;
                this.cellRenderer.setZeroIntegerAsInvalid(i + n, true);
            }
        }
    }

    public void setNegativeIntAsInvalid(int n) {
        if (n >= 0 && n < 150) {
            if (this.negativeAsInvalid == null) {
                this.negativeAsInvalid = new boolean[150];
            }
            this.negativeAsInvalid[n] = true;
            this.updateRendererOptions();
        }
    }

    public void setZeroIntAsInvalid(int n) {
        if (n >= 0 && n < 150) {
            if (this.zeroAsInvalid == null) {
                this.zeroAsInvalid = new boolean[150];
            }
            this.zeroAsInvalid[n] = true;
            this.updateRendererOptions();
        }
    }

    public void setCellRenderer(AastraTableCellRenderer aastraTableCellRenderer) {
        this.cellRenderer = aastraTableCellRenderer;
    }

    public void selectionColumnState(boolean bl) {
        this.selectColumnEnabled = bl;
    }

    public int[] getActiveColumnArr() {
        int[] nArray = new int[this.activeColumnArr.size()];
        int n = 0;
        for (int n2 : this.activeColumnArr) {
            nArray[n++] = n2;
        }
        return nArray;
    }

    public int[] getActiveTextColumnArr() {
        int n = 0;
        for (int n2 : this.activeColumnArr) {
            if (this.iconArrays[n2] != null) continue;
            ++n;
        }
        int[] nArray = new int[n];
        n = 0;
        for (int n3 : this.activeColumnArr) {
            if (this.iconArrays[n3] != null) continue;
            nArray[n++] = n3;
        }
        return nArray;
    }

    public void setActiveColumnArr(int[] nArray) {
        this.activeColumnArr.clear();
        for (int i = 0; i < nArray.length; ++i) {
            this.activeColumnArr.add(nArray[i]);
        }
    }

    protected class ImageIconArray {
        public ImageIcon[] icons = null;

        protected ImageIconArray() {
        }
    }
}

