/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.style;

import com.aastra.style.AastraCommon;
import com.aastra.util.UtilResource;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class AastraTabbedPaneUI
extends BasicTabbedPaneUI {
    ImageIcon tabSelMidImg = UtilResource.createImageIcon(this.getClass(), "tab_selected_mid.png");
    ImageIcon tabMidImg = UtilResource.createImageIcon(this.getClass(), "tab_normal_mid.png");
    ImageIcon tabSelLeftImg = UtilResource.createImageIcon(this.getClass(), "tab_selected_left.png");
    ImageIcon tabLeftImg = UtilResource.createImageIcon(this.getClass(), "tab_normal_left.png");
    ImageIcon tabSelRightImg = UtilResource.createImageIcon(this.getClass(), "tab_selected_right.png");
    ImageIcon tabRightImg = UtilResource.createImageIcon(this.getClass(), "tab_normal_right.png");

    public AastraTabbedPaneUI() {
        UIManager.put("TabbedPane.contentAreaColor", AastraCommon.AastraColorBorderTabbedPane);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
    }

    @Override
    protected void paintTabArea(Graphics graphics, int n, int n2) {
        int n3 = this.tabPane.getBounds().width;
        graphics.setColor(AastraCommon.AastraColorCommon);
        graphics.fillRect(0, 0, n3, this.rects[0].height + 3);
        super.paintTabArea(graphics, n, n2);
    }

    @Override
    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        ImageIcon imageIcon;
        ImageIcon imageIcon2;
        ImageIcon imageIcon3;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (bl) {
            imageIcon3 = this.tabSelMidImg;
            imageIcon2 = this.tabSelLeftImg;
            imageIcon = this.tabSelRightImg;
        } else {
            imageIcon3 = this.tabMidImg;
            imageIcon2 = this.tabLeftImg;
            imageIcon = this.tabRightImg;
        }
        graphics2D.drawImage(imageIcon2.getImage(), n3, n4 + 1, imageIcon2.getIconWidth(), n6, null);
        for (int i = imageIcon2.getIconWidth(); i < n5; i += imageIcon3.getIconWidth()) {
            int n7 = i + imageIcon3.getIconWidth() < n5 ? imageIcon3.getIconWidth() : n5 - i;
            graphics2D.drawImage(imageIcon3.getImage(), i + n3, n4 + 1, n7, n6, null);
        }
        graphics2D.drawImage(imageIcon.getImage(), n3 + n5 - imageIcon.getIconWidth(), n4 + 1, imageIcon.getIconWidth(), n6, null);
        graphics2D.dispose();
    }

    @Override
    protected void paintText(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
        Rectangle rectangle2 = this.rects[n2];
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(rectangle2.x, rectangle2.y);
        graphics.setFont(AastraCommon.AastraFontCommon);
        if (bl) {
            graphics.setColor(AastraCommon.AastraColorTabTextSelected);
        } else if (this.tabPane.isEnabledAt(n2)) {
            graphics.setColor(AastraCommon.AastraColorTabText);
        } else {
            graphics.setColor(AastraCommon.AastraColorTabTextDisabled);
        }
        FontMetrics fontMetrics2 = this.getFontMetrics();
        graphics.drawString(string, rectangle2.width / 2 - fontMetrics2.stringWidth(string) / 2 + 1, rectangle2.height / 2 + fontMetrics2.getMaxDescent());
        graphics2D.translate(-1 * rectangle2.x, -1 * rectangle2.y);
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    protected Insets getContentBorderInsets(int n) {
        return new Insets(1, 1, 1, 1);
    }
}

