/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.style;

import com.aastra.style.AastraCheckBox;
import com.aastra.style.AastraCommon;
import com.aastra.util.UtilResource;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class AastraTableCellRenderer
implements TableCellRenderer {
    public static final int MAX_COL = 150;
    private String[] formatStrings = null;
    private boolean[] negativeIntegerAsInvalid = null;
    private boolean[] zeroIntegerAsInvalid = null;
    private Color bg1 = AastraCommon.AastraColorTableRowBgFirst;
    private Color bg2 = AastraCommon.AastraColorTableRowBgSecond;
    private Color fg = AastraCommon.AastraColorTableRow;
    private ImageIcon cbIcon = (ImageIcon)new AastraCheckBox().getIcon();
    private JTable table = null;

    public void setTable(JTable jTable) {
        this.table = jTable;
    }

    public void setFormatString(int n, String string) {
        if (this.formatStrings == null) {
            this.formatStrings = new String[150];
        }
        if (n >= 0 && n < 150) {
            this.formatStrings[n] = string;
        }
    }

    public void resetFormatStrings() {
        this.formatStrings = null;
    }

    public void setNegativeIntegerAsInvalid(int n, boolean bl) {
        if (this.negativeIntegerAsInvalid == null) {
            this.negativeIntegerAsInvalid = new boolean[150];
        }
        if (n >= 0 && n < 150) {
            this.negativeIntegerAsInvalid[n] = bl;
        }
    }

    public void setZeroIntegerAsInvalid(int n, boolean bl) {
        if (this.zeroIntegerAsInvalid == null) {
            this.zeroIntegerAsInvalid = new boolean[150];
        }
        if (n >= 0 && n < 150) {
            this.zeroIntegerAsInvalid[n] = bl;
        }
    }

    public void resetNegativeIntegerAsInvalid() {
        this.negativeIntegerAsInvalid = null;
    }

    public void resetZeroIntegerAsInvalid() {
        this.zeroIntegerAsInvalid = null;
    }

    private String getConvertedInteger(int n, int n2) {
        if (this.table != null) {
            int n3 = this.table.convertColumnIndexToModel(n);
            if (this.negativeIntegerAsInvalid != null && this.negativeIntegerAsInvalid[n3] && n2 < 0) {
                return "-";
            }
            if (this.zeroIntegerAsInvalid != null && this.zeroIntegerAsInvalid[n3] && n2 == 0) {
                return "-";
            }
            if (this.formatStrings != null && this.formatStrings[n3] != null) {
                return String.format(this.formatStrings[n3], n2);
            }
        }
        return "" + n2;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JComponent jComponent;
        if (object instanceof JLabel) {
            jComponent = (JLabel)object;
        } else if (object instanceof ImageIcon) {
            jComponent = new JLabel((ImageIcon)object);
        } else if (object instanceof Boolean) {
            AastraCheckBox aastraCheckBox = new AastraCheckBox();
            aastraCheckBox.setSelected(bl);
            aastraCheckBox.setHorizontalAlignment(2);
            aastraCheckBox.setVerticalAlignment(0);
            aastraCheckBox.setIcon(this.cbIcon);
            jComponent = aastraCheckBox;
        } else {
            jComponent = object != null ? (object.getClass() == Integer.class ? new JLabel(this.getConvertedInteger(n2, (Integer)object)) : new JLabel(object.toString())) : new JLabel("");
        }
        jComponent.setOpaque(true);
        if (n % 2 == 0) {
            jComponent.setBackground(this.bg1);
        } else {
            jComponent.setBackground(this.bg2);
        }
        if (bl) {
            jComponent.setForeground(AastraCommon.AastraColorTableRowSel);
        } else {
            jComponent.setForeground(this.fg);
        }
        jComponent.setFont(AastraCommon.AastraFontCommon);
        return jComponent;
    }

    public void setInactivMode(boolean bl) {
        if (!bl) {
            this.bg1 = AastraCommon.AastraColorTableRowBgFirst;
            this.bg2 = AastraCommon.AastraColorTableRowBgSecond;
            this.fg = AastraCommon.AastraColorTableRow;
            this.cbIcon = (ImageIcon)new AastraCheckBox().getIcon();
        } else {
            this.bg1 = AastraCommon.AastraColorTableRowInactiveBgFirst;
            this.bg2 = AastraCommon.AastraColorTableRowInactiveBgSecond;
            this.fg = AastraCommon.AastraColorTableRowInactive;
            this.cbIcon = UtilResource.createImageIcon(this.getClass(), "cb_inactive.png");
        }
    }
}

