/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.style;

import com.aastra.style.AastraCheckBox;
import com.aastra.util.UtilResource;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.Icon;

public class AastraTristateCheckbox
extends AastraCheckBox {
    private static final long serialVersionUID = 4358830697315571805L;
    public static final State NOT_SELECTED = new State();
    public static final State SELECTED = new State();
    public static final State DONT_CARE = new State();
    private static Icon tristateIcon = UtilResource.createImageIcon(AastraCheckBox.class, "tristateCheckbox.png");
    private static Icon tristateDisabledIcon = UtilResource.createImageIcon(AastraCheckBox.class, "tristateDisabledCheckbox.png");
    private static Icon alternateTristateIcon = UtilResource.createImageIcon(AastraCheckBox.class, "tristateCheckboxQuestionMark.png");
    private static Icon alternateTristateDisabledIcon = UtilResource.createImageIcon(AastraCheckBox.class, "tristateDisabledCheckboxQuestionMark.png");
    private boolean useAlternateTristateIcon = false;
    private State state = DONT_CARE;
    private LinkedList<ActionListener> actionListenerList = new LinkedList();

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.actionListenerList.add(actionListener);
    }

    public AastraTristateCheckbox(String string, Icon icon, State state) {
        super(string, icon);
        this.setState(state);
        super.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AastraTristateCheckbox.this.isSelected()) {
                    AastraTristateCheckbox.this.state = SELECTED;
                } else {
                    AastraTristateCheckbox.this.state = NOT_SELECTED;
                }
                for (ActionListener actionListener : AastraTristateCheckbox.this.actionListenerList) {
                    if (actionListener == null) continue;
                    actionListener.actionPerformed(actionEvent);
                }
            }
        });
    }

    public AastraTristateCheckbox(String string, State state) {
        this(string, null, state);
    }

    public AastraTristateCheckbox(String string) {
        this(string, NOT_SELECTED);
    }

    public AastraTristateCheckbox() {
        this((String)null);
    }

    public void setState(State state) {
        this.state = state;
        if (this.state == NOT_SELECTED) {
            this.setSelected(false);
        } else if (this.state == SELECTED) {
            this.setSelected(true);
        }
        this.repaint();
    }

    public State getState() {
        return this.state;
    }

    public void useQuestionMarkAsTristate(boolean bl) {
        this.useAlternateTristateIcon = bl;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.state == DONT_CARE) {
            if (this.isEnabled()) {
                if (this.useAlternateTristateIcon) {
                    alternateTristateIcon.paintIcon(this, graphics, 4, 4);
                } else {
                    tristateIcon.paintIcon(this, graphics, 4, 4);
                }
            } else if (this.useAlternateTristateIcon) {
                alternateTristateDisabledIcon.paintIcon(this, graphics, 4, 4);
            } else {
                tristateDisabledIcon.paintIcon(this, graphics, 4, 4);
            }
        }
    }

    public static class State {
        private State() {
        }
    }
}

