MOM_BIN="/opt/SIP-DECT-MOM/bin/SIP-DECT-MOM"
MOM_VERSION=00000000:00000000
MOM_ENDLESS="/var/lock/subsys/SIP-DECT-MOM-SH.endless"
MOM_PID_FILE="/var/run/SIP-DECT-MOM.pid"

MOM_DIR="/opt/SIP-DECT-MOM"
MOM_CORE_DIR="/opt/SIP-DECT-MOM/tmp"
MOM_CORE_PATTERN="core"

exec 2>&1 > /var/log/SIP-DECT-MOM.log

trap "logger $0 get signal and ignored!" 1 2 3 10 15

# found core files from own application 
# and compress with gzip
compress_own_core_files()
{
mom_name=`echo $MOM_BIN|sed -e's/^.*\///'`
for core_files in $MOM_CORE_PATTERN*
	do
		count=`file $core_files|grep -c $mom_name`
		if [[ $count -ge 1 ]]
		    then
		      echo "Found core file: $core_files from $mom_name, compressing..."
		      gzip $core_files
		      mv $core_files.gz $MOM_CORE_DIR
		    fi
	done	
}

#remove more than 10 Corefiles
#latest first
remove_own_core_files()
{
MAX_CORE_FILES=10
core_file_number=`ls $MOM_CORE_DIR/*.gz 2>/dev/null|wc -w`
core_files_delete=`expr $core_file_number - $MAX_CORE_FILES`
while [ $core_files_delete -ge 1 ]
  do
     file_delete=`ls -1rt $MOM_CORE_DIR/*.gz 2>/dev/null |head -1`
     echo "remove core file $file_delete"
     rm $file_delete
      core_files_delete=`expr $core_files_delete - 1`
    done
}
#Get all parameters
read_mom_parameter()
{
if [ -f /etc/sysconfig/SIP-DECT-MOM ];then
        . /etc/sysconfig/SIP-DECT-MOM
fi

#Get all parameters
MOM_START_PARAMETER=" "
 	if [ -n "$MOM_IF" ]; then
 	   MOM_START_PARAMETER="${MOM_START_PARAMETER} -i ${MOM_IF}"
 	fi   
 	
 	if [ -n "$MOM_CONFIG_FILE" ]; then
 	   MOM_START_PARAMETER="${MOM_START_PARAMETER} -f ${MOM_CONFIG_FILE}"
 	fi

}	


if [ ! -x ${MOM_BIN} ]; then
	echo -n "MOM, ${MOM_BIN} not installed!"
	exit 5
fi


ulimit -n 32768 -c unlimited
cd "$MOM_DIR"
read_mom_parameter 	
mom_name=`echo $MOM_BIN|sed -e's/^.*\///'`

${MOM_BIN}  ${MOM_START_PARAMETER} -d
/sbin/pidof -s ${MOM_BIN} -o%PPID >${MOM_PID_FILE}


while [  -e "$MOM_ENDLESS$$" ]
do    
    kill -s CONT `cat ${MOM_PID_FILE}`  2>/dev/null
    if [ $? != 0 ]; then 
      compress_own_core_files
      remove_own_core_files
      read_mom_parameter
      #for safety reason, we clean process system from mom programs
      grep -qi $mom_name  /proc/[0-9]*/stat
      if [  $? == 0 ]; then
         killall  -q  $mom_name
         sleep 3
         killall  -q -9 $mom_name
         sleep 3
      fi
      # end safety cleanup
      echo "Restart ${MOM_BIN}"
      ${MOM_BIN}  ${MOM_START_PARAMETER} -d
      /sbin/pidof  -s ${MOM_BIN} -o%PPID >${MOM_PID_FILE}
    fi
    sleep 3
done

echo "$0 with PID: $$ is stopped!"
