#!/bin/sh
#exit codes
NO_FILE=1
NO_ACCESS=2
NO_CONN=3
NO_ROUTE=4
NO_LOOKUP=9


#base name for temp files
OUT_FILE=/tmp/list

#parameter assignments
HOST=$1
USER=$2
PASSWD=$4
DIR=$3
#passed the exit code
clean_exit () {
	if [ "$1" != "0" ]
	then
		echo "-$1"
	fi
	rm -f ${OUT_FILE}.txt > /dev/null 2>&1
	exit $1
}
check_host () {
	/bin/grep "Connection refused" ${OUT_FILE}.txt > /dev/null 2>&1
	if [ $? -eq 0 ]
	then
		clean_exit ${NO_CONN}
	fi
	/bin/grep "No route to host" ${OUT_FILE}.txt > /dev/null 2>&1
	if [ $? -eq 0 ]
	then
		clean_exit ${NO_ROUTE}
	fi
}
check_user () {
	/bin/grep "Host name lookup failure" ${OUT_FILE}.txt > /dev/null 2>&1
	if [ $? -eq 0 ]
	then
		clean_exit ${NO_LOOKUP}
	fi
	/bin/grep "^230" ${OUT_FILE}.txt > /dev/null 2>&1
	if [ $? -ne 0 ]
	then
		clean_exit ${NO_ACCESS}
	fi
}
check_for_listing () {
	/bin/grep "^550" ${OUT_FILE}.txt > /dev/null 2>&1
	if [ $? -eq 0 ]
	then
		clean_exit ${NO_FILE}
	fi
}
get_file_listing () {
	year=`date |awk '{print $6}'`
	awk '/^-.*update-.*-.*.tgz/ {
		vFields=split($9, version, "-")
		bFields=split(version[2], beta, ".")
		yFields=split($8, year, ":")
		if(yFields==2) {
			pYear='"$year"'
		} else {
			pYear=$8
		}
		if((bFields==3) && (version[2] !~ /^A/ )) {
			print version[2]"	"$6"/"$7"/"pYear"	Beta version "beta[3]"	"$9
		} else if(version[2] ~ /^[0-9]/ ) {
			print version[2]"	"$6"/"$7"/"pYear"	GA version "beta[3]"	"$9
		} else if(version[2] ~ /^B/ ) {
			print version[2]"	"$6"/"$7"/"pYear"	Beta version "beta[3]"	"$9
		} else if (version[2] ~ /^A/ ) {
			print version[2]"	"$6"/"$7"/"pYear"	Alpha version	"$9
		} else {
			print version[2]"	"$6"/"$7"/"pYear"	ENG Version	"$9
		}
	}' ${OUT_FILE}.txt > /tmp/index.txt
	echo 0
}

/usr/bin/ftp -pvn ${HOST} > ${OUT_FILE}.txt 2>&1 <<END_SCRIPT
quote USER ${USER}
quote PASS ${PASSWD}
cd ${DIR}
ls
quit
END_SCRIPT
check_host
check_user
check_for_listing
get_file_listing
