#!/bin/sh
#exit codes
NO_FILE=1
NO_ACCESS=2
NO_CONN=3
NO_ROUTE=4
NO_LOOKUP=9


#base name for temp files
OUT_FILE=test

#parameter assignments
HOST=$1
USER=$2
PASSWD=$5
DIR=$3
FILE=$4
#passed the exit code
clean_exit () {
	if [ "$1" != "0" ]
	then
		echo "-$1"
	fi
	rm -f ${OUT_FILE}.txt > /dev/null 2>&1
	rm -f ${OUT_FILE}1.txt > /dev/null 2>&1
	exit $1
}
check_host () {
	grep "Connection refused" ${OUT_FILE}.txt > /dev/null 2>&1
	if [ $? -eq 0 ]
	then
		clean_exit ${NO_CONN}
	fi
	grep "No route to host" ${OUT_FILE}.txt > /dev/null 2>&1
	if [ $? -eq 0 ]
	then
		clean_exit ${NO_ROUTE}
	fi
}
check_user () {
	/bin/grep "Host name lookup failure" ${OUT_FILE}.txt > /dev/null 2>&1
	if [ $? -eq 0 ]
	then
		clean_exit ${NO_LOOKUP}
	fi
	grep "^230" ${OUT_FILE}.txt > /dev/null 2>&1
	if [ $? -ne 0 ]
	then
		clean_exit ${NO_ACCESS}
	fi
}
check_for_file () {
	grep "^550" ${OUT_FILE}.txt > /dev/null 2>&1
	if [ $? -eq 0 ]
	then
		clean_exit ${NO_FILE}
	fi
}
get_file_size () {
	grep 213 ${OUT_FILE}.txt > ${OUT_FILE}1.txt
	rc=$?
	if [ ${rc} -eq 0 ]
	then
		rc=`awk '{print $2}' ${OUT_FILE}1.txt`
	else
		clean_exit ${NO_FILE}
	fi
	echo "${rc}"
	clean_exit 0
}

ftp -pvn ${HOST} > ${OUT_FILE}.txt 2>&1 <<END_SCRIPT
quote USER ${USER}
quote PASS ${PASSWD}
cd ${DIR}
size ${FILE}
quit
END_SCRIPT
check_host
check_user
check_for_file
get_file_size
